// ----------------------------------------------------------------------------
// Copyright 2007-2013, GeoTelematic Solutions, Inc.
// All rights reserved
// ----------------------------------------------------------------------------
//
// This source module is PROPRIETARY and CONFIDENTIAL.
// NOT INTENDED FOR PUBLIC RELEASE.
// 
// Use of this software is subject to the terms and conditions outlined in
// the 'Commercial' license provided with this software.  If you did not obtain
// a copy of the license with this software please request a copy from the
// Software Provider.
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ----------------------------------------------------------------------------
// Last know location
// ----------------------------------------------------------------------------
// Change History:
//  2007/03/11  Martin D. Flynn
//     -Initial release
//  2007/06/03  Martin D. Flynn
//     -Added PrivateLabel to constructor
// ----------------------------------------------------------------------------
package org.opengts.war.report.event;

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.opengts.util.*;
import org.opengts.db.*;
import org.opengts.db.tables.*;

import org.opengts.war.tools.*;
import org.opengts.war.report.*;

public class EventSummaryReport
    extends ReportData
{

    // ------------------------------------------------------------------------
    // Summary report
    // 1 EventData record per device
    // As-of date ('To' date only)
    // ------------------------------------------------------------------------

    private static String PROP_minimumCheckInAge = "minimumCheckInAge";

    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------

    /* minimum checkin-age (used for "Last Known Location" report) */
    private long minCheckInAgeSec   = 0L;

    /**
    *** Event Summary Report Constructor
    *** @param rptEntry The ReportEntry that generated this report
    *** @param reqState The session RequestProperties instance
    *** @param devList  The list of devices
    **/
    public EventSummaryReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList)
        throws ReportException
    {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        //if ((acct == null) || (this.getDeviceCount() < 1)) {
        //    throw new ReportException("At least 1 Device must be specified");
        //}
        // report on all authorized devices
        ////this.getReportDeviceList().addAllAuthorizedDevices();
    }

    // ------------------------------------------------------------------------

    /**
    *** Post report initialization
    **/
    public void postInitialize()
    {

        /* ReportConstraints */
        ReportConstraints rc = this.getReportConstraints();
        rc.setTimeStart(-1L); // disregard 'start' time

        /* Properties */
        this.minCheckInAgeSec = this.getProperties().getLong(PROP_minimumCheckInAge,0L);

    }

    // ------------------------------------------------------------------------

    /**
    *** Returns true if this report supports displaying a map
    *** @return True if this report supports displaying a map, false otherwise
    **/
    public boolean getSupportsMapDisplay()
    {
        return true;
    }

    /**
    *** Returns true if this report supports displaying KML
    *** @return True if this report supports displaying KML, false otherwise
    **/
    public boolean getSupportsKmlDisplay()
    {
        return true;
    }

    // ------------------------------------------------------------------------

    /**
    *** Gets the bound ReportLayout singleton instance for this report
    *** @return The bound ReportLayout
    **/
    public static ReportLayout GetReportLayout()
    {
        // bind the report format to this data
        return EventDataLayout.getReportLayout();
    }

    /**
    *** Gets the bound ReportLayout singleton instance for this report
    *** @return The bound ReportLayout
    **/
    public ReportLayout getReportLayout()
    {
        // bind the report format to this data
        return GetReportLayout();
    }

    // ------------------------------------------------------------------------

    /**
    *** Callback for each EventData record selected.  This method can be overridden 
    *** by the subclass to allow for additional criteria selection.
    *** @param ev  The current EventData record to test
    *** @return True to accept record, false to skip record
    **/
    protected boolean isEventDataMatch(EventData ev)
    {
        if (this.minCheckInAgeSec > 0L) {
            Device dev = ev.getDevice(); // should not be null
            long lcTime = (dev != null)? dev.getLastTotalConnectTime() : 0L;
            long lcAge  = DateTime.getCurrentTimeSec() - lcTime;
            if (lcAge < this.minCheckInAgeSec) {
                // last check-in age is after minimum
                return false;
            }
        }
        return true;
    }

    // ------------------------------------------------------------------------

    /**
    *** Creates and returns an iterator for the row data displayed in the body of this report.
    *** @return The body row data iterator
    **/
    public DBDataIterator getBodyDataIterator()
    {
        EventData ed[] = this.getEventData(null);
        Arrays.sort(ed, new EventData.DeviceDescriptionComparator()); // sort by device description
        return new ArrayDataIterator(ed); // 'EventDataLayout' expects EventData[]
    }
 
    /**
    *** Creates and returns an iterator for the row data displayed in the total rows of this report.
    *** @return The total row data iterator
    **/
    public DBDataIterator getTotalsDataIterator()
    {
        return null;
    }

    // ------------------------------------------------------------------------
    // EventData record retrieval overrides
    
    /**
    *** Returns the limit type contraint
    *** @return The limit type
    **/
    public EventData.LimitType getSelectionLimitType()
    {
        return EventData.LimitType.LAST;
    }
    
    /**
    *** Returns the selection limit
    *** @return The selection limit
    **/
    public long getSelectionLimit()
    {
        return 1L;
    }

    // ------------------------------------------------------------------------

}
