// ----------------------------------------------------------------------------
// Copyright Zona-OpenGTS
// All rights reserved
// ----------------------------------------------------------------------------
//
// This source module is PROPRIETARY and CONFIDENTIAL.
// NOT INTENDED FOR PUBLIC RELEASE.
// 
// Use of this software is subject to the terms and conditions outlined in
// the 'Commercial' license provided with this software.  If you did not obtain
// a copy of the license with this software please request a copy from the
// Software Provider.
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ----------------------------------------------------------------------------
// Description:
//  Server Initialization
// ----------------------------------------------------------------------------
// Change History:
//  2014/02/16  Edgar Jose Guinan Ramoni
//     -Initial release
//  2014/02/17  Edgar Jose Guinan Ramoni
//     -This module is to support devices: 
//      Teltonika Series - FM1100, FM2200, FM3100, FM3200, FM3300, FM4100, FM4200, FM5300, AT1000
// ----------------------------------------------------------------------------
package org.opengts.servers.teltonika;

import org.opengts.*;
import org.opengts.util.*;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DCServerConfig;

public class Constants
{

    // ------------------------------------------------------------------------
 
    /* title */
    public static final String  TITLE_NAME                  = "TELTONIKA";
    public static final String  VERSION                     = "0.1.4";
    public static final String  COPYRIGHT                   = Version.COPYRIGHT;

    // ------------------------------------------------------------------------

    /* device code */
    public static final String  DEVICE_CODE                 = "teltonika";

    /* device code */
    public static final String  CFG_packetLenEndOfStream    = DEVICE_CODE + ".packetLenEndOfStream";

    // ------------------------------------------------------------------------

    /* ASCII packets*/
    public static final boolean ASCII_PACKETS               = false;
    public static final int     ASCII_LINE_TERMINATOR[]     = new int[] { };
    public static final int     ASCII_IGNORE_CHARS[]        = null; // new int[] { 0x00 };

    /* packet length */
    public static final int     MIN_PACKET_LENGTH           = 1;
    public static final int     MAX_PACKET_LENGTH           = 1500;
    
    /* terminate flags */
    public static final boolean TERMINATE_ON_TIMEOUT        = true;

    // ------------------------------------------------------------------------

    /* TCP Timeouts */
    public static final long    TIMEOUT_TCP_IDLE            = 60000L;
    public static final long    TIMEOUT_TCP_PACKET          = 10000L;
    public static final long    TIMEOUT_TCP_SESSION         = 240000L;

    /* UDP Timeouts */
    public static final long    TIMEOUT_UDP_IDLE            = 60000L;
    public static final long    TIMEOUT_UDP_PACKET          = 10000L;
    public static final long    TIMEOUT_UDP_SESSION         = 240000L;

    /* linger on close */
    public static final int     LINGER_ON_CLOSE_SEC         = 2;

    // ------------------------------------------------------------------------

    /* minimum acceptable speed */
    public static final double  MINIMUM_SPEED_KPH           = 3.0;

    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------

    public static void main(String argv[])
    {
        Print.sysPrintln(VERSION);
    }

}
