// ----------------------------------------------------------------------------
// Copyright 2007-2013, GeoTelematic Solutions, Inc.
// All rights reserved
// ----------------------------------------------------------------------------
//
// This source module is PROPRIETARY and CONFIDENTIAL.
// NOT INTENDED FOR PUBLIC RELEASE.
// 
// Use of this software is subject to the terms and conditions outlined in
// the 'Commercial' license provided with this software.  If you did not obtain
// a copy of the license with this software please request a copy from the
// Software Provider.
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ----------------------------------------------------------------------------
// Change History:
//  2009/11/10  Martin D. Flynn
//     -Initial Creation
//  2013/05/19  Martin D. Flynn
//     -Added support for displaying last/next service time calendar
// ----------------------------------------------------------------------------

var MAX_COMMAND_ARGS   = 10;
var COMMAND_ARG_PREFIX = "rct_";

// Onload
function devCommandOnLoad() {
    devCommandRadioChanged();
};

// ----------------------------------------------------------------------------

/**
*** Show Last Service Calander
**/
function deviceToggleLastServiceTimeCalendar()
{
    var fade = false;
    if (lastSrvDateCal) {
        var cal = lastSrvDateCal;
        var fld = document.getElementById(ID_LAST_SERVICE_DATE);
        if (cal.isExpanded()) {
            // collapse
            cal.setExpanded(false, fade);
            if (fld) { fld.value = cal.getTimeAsString(); }
        } else {
            // expand
            if (fld) { cal.setDateAsString(fld.value); }
            cal.setExpanded(true, fade);
            cal.setCallbackOnSelect(function() {
                cal.setExpanded(false, fade);
                if (fld) { fld.value = cal.getDateAsString(); }
            });
        }
    }
};

/**
*** Show Next Service Calander
**/
function deviceToggleNextServiceTimeCalendar()
{
    var fade = false;
    if (nextSrvDateCal) {
        var cal = nextSrvDateCal;
        var fld = document.getElementById(ID_NEXT_SERVICE_DATE);
        if (cal.isExpanded()) {
            // collapse
            cal.setExpanded(false, fade);
            if (fld) { fld.value = cal.getTimeAsString(); }
        } else {
            // expand
            if (fld) { cal.setDateAsString(fld.value); }
            cal.setExpanded(true, fade);
            cal.setCallbackOnSelect(function() {
                cal.setExpanded(false, fade);
                if (fld) { fld.value = cal.getDateAsString(); }
            });
        }
    }
};

// ----------------------------------------------------------------------------

// Command radio button selection changed
function devCommandRadioChanged() {
   //try {
      if (document.DeviceCommandForm.cmdRadioSel.length) {
         var rc = document.DeviceCommandForm.cmdRadioSel.length;
         //alert("Radio selection changed ... " + rc);
         for (var i = 0; i < rc; i++) {
            var cmdName = document.DeviceCommandForm.cmdRadioSel[i].value;
            var cmdChkd = document.DeviceCommandForm.cmdRadioSel[i].checked;
            //alert("Command: " + i + " " + cmdName);
            for (var a = 0; a < MAX_COMMAND_ARGS; a++) {
                var cmdOptn = document.getElementById(COMMAND_ARG_PREFIX + cmdName + '_' + a);
                if (!cmdOptn) { continue; }
                //alert("Radio selection changed ... " + i + " " + cmdChkd);
                if (cmdChkd) {
                   cmdOptn.disabled  = false;
                   cmdOptn.className = "textInput";
                } else {
                   cmdOptn.disabled  = true;
                   cmdOptn.className = "textReadOnly";
                }
            }
         }
      }
   //} catch (e) {
      //
   //}
};
