#!/bin/bash
# -----------------------------------------------------------------------------
# Project: OpenGTS - Open GPS Tracking System
# URL    : http://www.opengts.org
# File   : gtsConfig.command
# -----------------------------------------------------------------------------

# --- reload environment vars
# - GTS_HOME
# - CATALINA_HOME
#if [ "${GTS_HOME}" = "" ] && [ -f "/usr/local/gts_vars.env" ]; then
if [ -f "/usr/local/gts_vars.env" ]; then
    . /usr/local/gts_vars.env
fi

# --- make sure we have GTS_HOME defined
if [ "${GTS_HOME}" = "" ]; then 
    echo "Unable to determine GTS_HOME"
    sleep 3
    exit 1
fi

# --- environment vars:
echo "GTS_HOME      = ${GTS_HOME}"
echo "CATALINA_HOME = ${CATALINA_HOME}"

# --- start config tool
cd ${GTS_HOME}
./bin/gtsConfig.pl -config
