/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.maps.jsmap;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.opengts.db.tables.Geozone;
import org.opengts.util.I18N;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.maps.JSMap;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.MapDimension;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.RequestProperties;

public class VirtualEarth
extends JSMap {
    private static final String CURSOR_CROSSHAIR = "crosshair";
    private static final String CURSOR_HAND_OPEN = "http://maps.live.com/cursors/grab.cur";
    private static final String VE_MAPCONTROL_URL = "http://dev.virtualearth.net/mapcontrol/mapcontrol.ashx?v=6.2";
    private int[] VALID_ZOOM_VALUES = new int[]{19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    private static final double DEFAULT_ZOOM = 7.0;

    public VirtualEarth(String name, String key) {
        super(name, key);
        this.addSupportedFeature(2L);
        this.addSupportedFeature(4L);
        this.addSupportedFeature(1L);
        this.addSupportedFeature(8L);
        this.addSupportedFeature(16L);
        this.addSupportedFeature(32L);
        this.addSupportedFeature(64L);
        this.addSupportedFeature(128L);
    }

    @Override
    protected void writeJSVariables(PrintWriter out, RequestProperties reqState) throws IOException {
        super.writeJSVariables(out, reqState);
    }

    @Override
    protected void writeJSIncludes(PrintWriter out, RequestProperties reqState) throws IOException {
        MapProvider mp = reqState.getMapProvider();
        RTProperties mrtp = mp != null ? mp.getProperties() : null;
        String mapControlURL = mrtp != null ? mrtp.getString("ve.mapcontrol", null) : null;
        super.writeJSIncludes(out, reqState, new String[]{JavaScriptTools.qualifyJSFileRef((String)"maps/jsmap.js"), !StringTools.isBlank((String)mapControlURL) ? mapControlURL : VE_MAPCONTROL_URL, JavaScriptTools.qualifyJSFileRef((String)"maps/VirtualEarth.js")});
    }

    protected String getMapCellStyle(RequestProperties reqState, MapDimension mapDim) {
        return "position:relative; " + super.getMapCellStyle(reqState, mapDim);
    }

    public int getGeozoneSupportedPointCount(int type) {
        Geozone.GeozoneType gzType = Geozone.getGeozoneType((int)type);
        if (!Geozone.IsGeozoneTypeSupported((Geozone.GeozoneType)gzType)) {
            return 0;
        }
        RTProperties rtp = this.getProperties();
        switch (gzType) {
            case POINT_RADIUS: {
                return rtp.getBoolean(PROP_zone_map_multipoint, false) ? Geozone.GetGeoPointCount() : 1;
            }
            case BOUNDED_RECT: {
                return 0;
            }
            case SWEPT_POINT_RADIUS: {
                return rtp.getBoolean(PROP_zone_map_corridor, false) ? Geozone.GetGeoPointCount() : 0;
            }
            case POLYGON: {
                return rtp.getBoolean(PROP_zone_map_polygon, false) ? Geozone.GetGeoPointCount() : 0;
            }
        }
        return 0;
    }

    public String[] getGeozoneInstructions(int type, Locale loc) {
        I18N i18n = I18N.getI18N(VirtualEarth.class, (Locale)loc);
        if (type == Geozone.GeozoneType.POINT_RADIUS.getIntValue()) {
            return new String[]{i18n.getString("VirtualEarth.geozoneNotes.1", "Click to reset center."), i18n.getString("VirtualEarth.geozoneNotes.2", "Click-drag Geozone to move."), i18n.getString("VirtualEarth.geozoneNotes.3", "Shift-click-drag to resize."), i18n.getString("VirtualEarth.geozoneNotes.4", "Ctrl-click-drag for distance.")};
        }
        if (type == Geozone.GeozoneType.POLYGON.getIntValue()) {
            return new String[]{i18n.getString("VirtualEarth.geozoneNotes.1", "Click to reset center."), i18n.getString("VirtualEarth.geozoneNotes.5", "Click-drag corner to resize."), i18n.getString("VirtualEarth.geozoneNotes.4", "Ctrl-click-drag for distance.")};
        }
        return new String[0];
    }
}

