/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.maps.jsmap;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.opengts.db.tables.Geozone;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.maps.JSMap;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.RequestProperties;

public class OpenLayers
extends JSMap {
    private static final String OPENLAYERS_JS_URL = "http://openlayers.org/api/OpenLayers.js";
    public static final String[] PROP_SITIMAPA_enable = new String[]{"sitiMapa.enable"};
    public static final String[] PROP_GEOSERVER_enable = new String[]{"geoServer.enable"};
    public static final String[] PROP_GEOSERVER_title = new String[]{"geoServer.title"};
    public static final String[] PROP_GEOSERVER_url = new String[]{"geoServer.url"};
    public static final String[] PROP_GEOSERVER_maxResolution = new String[]{"geoServer.maxResolution"};
    public static final String[] PROP_GEOSERVER_size = new String[]{"geoServer.size"};
    public static final String[] PROP_GEOSERVER_projection = new String[]{"geoServer.projection"};
    public static final String[] PROP_GEOSERVER_layers = new String[]{"geoServer.layers"};
    public static final String[] PROP_GEOSERVER_bounds = new String[]{"geoServer.bounds"};
    public static final String[] PROP_GEOSERVER_units = new String[]{"geoServer.units"};
    public static final String[] PROP_GEOSERVER_layerType = new String[]{"geoServer.layerType"};
    public static final String[] PROP_MAPQUEST_showOSMLayer = new String[]{"mapQuest.enableLayer.osm"};
    public static final String[] PROP_MAPQUEST_showAerialLayer = new String[]{"mapQuest.enableLayer.aerial", "mapQuest.enableLayer.arial"};
    private static final int DEFAULT_ZOOM = 4;

    public OpenLayers(String name, String key) {
        super(name, key);
        this.addSupportedFeature(2L);
        this.addSupportedFeature(4L);
        this.addSupportedFeature(1L);
        this.addSupportedFeature(8L);
        this.addSupportedFeature(16L);
        this.addSupportedFeature(32L);
        this.addSupportedFeature(64L);
        this.addSupportedFeature(128L);
    }

    @Override
    protected void writeJSVariables(PrintWriter out, RequestProperties reqState) throws IOException {
        super.writeJSVariables(out, reqState);
        out.write("// OpenLayers custom vars\n");
        RTProperties rtp = this.getProperties();
        boolean gsEnable = rtp.getBoolean(PROP_GEOSERVER_enable, false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_enable", (Object)gsEnable);
        if (gsEnable) {
            String gsTitle = StringTools.blankDefault((String)rtp.getString(PROP_GEOSERVER_title, null), (String)"WMS Provider");
            String gsURL = rtp.getString(PROP_GEOSERVER_url, "");
            String gsMaxRes = StringTools.blankDefault((String)rtp.getString(PROP_GEOSERVER_maxResolution, null), (String)"auto");
            String gsSize = StringTools.blankDefault((String)rtp.getString(PROP_GEOSERVER_size, null), (String)"{ width:0, height:0 }");
            String gsProj = StringTools.blankDefault((String)rtp.getString(PROP_GEOSERVER_projection, null), (String)"EPSG:4326");
            String gsLayers = rtp.getString(PROP_GEOSERVER_layers, "");
            String gsBounds = StringTools.blankDefault((String)rtp.getString(PROP_GEOSERVER_bounds, null), (String)"{ top:0, left:0, bottom:0, right:0 }");
            String gsUnits = StringTools.blankDefault((String)rtp.getString(PROP_GEOSERVER_units, null), (String)"degrees");
            String gsLayerT = StringTools.blankDefault((String)rtp.getString(PROP_GEOSERVER_layerType, null), (String)"tiled");
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_title", (Object)gsTitle);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_url", (Object)gsURL);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_maxResolution", (Object)gsMaxRes, (!StringTools.isDouble((String)gsMaxRes, (boolean)true) ? 1 : 0) != 0);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_size", (Object)gsSize, (boolean)false);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_projection", (Object)gsProj);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_layers", (Object)gsLayers);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_bounds", (Object)gsBounds, (boolean)false);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_units", (Object)gsUnits);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GEOSERVER_layerType", (Object)gsLayerT);
        }
        boolean smEnable = !gsEnable ? rtp.getBoolean(PROP_SITIMAPA_enable, false) : false;
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SITIMAPA_enable", (Object)smEnable);
        boolean mqOsmLayer = rtp.getBoolean(PROP_MAPQUEST_showOSMLayer, false);
        boolean mqAerialLayer = rtp.getBoolean(PROP_MAPQUEST_showAerialLayer, false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAPQUEST_showOSMLayer", (Object)mqOsmLayer);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAPQUEST_showAerialLayer", (Object)mqAerialLayer);
    }

    @Override
    protected void writeJSIncludes(PrintWriter out, RequestProperties reqState) throws IOException {
        String jsURL;
        MapProvider mp = reqState.getMapProvider();
        RTProperties mrtp = mp != null ? mp.getProperties() : null;
        String string = jsURL = mrtp != null ? mrtp.getString("openlayers.js", null) : null;
        if (!StringTools.isBlank((String)jsURL)) {
            String authKey = this.getAuthorization();
            jsURL = StringTools.replace((String)jsURL, (String)"${key}", (String)authKey);
        }
        super.writeJSIncludes(out, reqState, new String[]{JavaScriptTools.qualifyJSFileRef((String)"maps/jsmap.js"), !StringTools.isBlank((String)jsURL) ? jsURL : OPENLAYERS_JS_URL, JavaScriptTools.qualifyJSFileRef((String)"maps/OpenLayers.js")});
    }

    public int getGeozoneSupportedPointCount(int type) {
        Geozone.GeozoneType gzType = Geozone.getGeozoneType((int)type);
        if (!Geozone.IsGeozoneTypeSupported((Geozone.GeozoneType)gzType)) {
            Print.logWarn((String)("Geozone type not supported: " + type), (Object[])new Object[0]);
            return 0;
        }
        int ptCnt = 0;
        RTProperties rtp = this.getProperties();
        switch (gzType) {
            case POINT_RADIUS: {
                ptCnt = rtp.getBoolean(PROP_zone_map_multipoint, false) ? Geozone.GetGeoPointCount() : 1;
                break;
            }
            case BOUNDED_RECT: {
                return 0;
            }
            case SWEPT_POINT_RADIUS: {
                ptCnt = rtp.getBoolean(PROP_zone_map_corridor, false) ? Geozone.GetGeoPointCount() : 0;
                break;
            }
            case POLYGON: {
                int n = ptCnt = rtp.getBoolean(PROP_zone_map_polygon, false) ? Geozone.GetGeoPointCount() : 0;
            }
        }
        if (ptCnt <= 0) {
            Print.logWarn((String)("Geozone type not enabled: " + type), (Object[])new Object[0]);
        }
        return ptCnt;
    }

    public String[] getGeozoneInstructions(int type, Locale loc) {
        I18N i18n = I18N.getI18N(OpenLayers.class, (Locale)loc);
        if (type == Geozone.GeozoneType.POINT_RADIUS.getIntValue()) {
            return new String[]{i18n.getString("OpenLayers.geozoneNotes.1", "Click to reset center."), i18n.getString("OpenLayers.geozoneNotes.2", "Click-drag Geozone to move."), i18n.getString("OpenLayers.geozoneNotes.3", "Shift-click-drag to resize."), i18n.getString("OpenLayers.geozoneNotes.4", "Ctrl-click-drag for distance.")};
        }
        if (type == Geozone.GeozoneType.POLYGON.getIntValue()) {
            return new String[]{i18n.getString("OpenLayers.geozoneNotes.1", "Click to reset center."), i18n.getString("OpenLayers.geozoneNotes.5", "Click-drag corner to resize."), i18n.getString("OpenLayers.geozoneNotes.4", "Ctrl-click-drag for distance.")};
        }
        return new String[0];
    }
}

