/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.maps.jsmap;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Vector;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.maps.JSMap;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPageAdaptor;

public class Mapstraction
extends JSMap {
    public static final String PROVIDER_OPENLAYERS = "openlayers";
    public static final String PROVIDER_GOOGLEV3 = "googlev3";
    public static final String PROVIDER_CLOUDMADE = "cloudmade";
    public static final String PROVIDER_MICROSOFT = "microsoft";
    public static final String PROVIDER_MICROSOFT7 = "microsoft7";
    public static final String PROVIDER_MAPQUEST = "mapquest";
    public static final String PROVIDER_OPENMQ = "openmq";
    public static final String PROVIDER_ESRI = "esri";
    public static final String PROVIDER_OPENSPACE = "openspace";
    public static final String PROVIDER_LEAFLET = "leaflet";
    public static final String PROVIDER_OVI = "ovi";
    public static final String PROVIDER_GOOGLE = "google";
    public static final String PROVIDER_YAHOO = "yahoo";
    public static final String PROVIDER_MULTIMAP = "multimap";
    public static final String PROVIDER_MAP24 = "map24";
    public static final String PROVIDER_OPENSTREETMAP = "openstreetmap";
    public static final String PROVIDER_FREEEARTH = "freeearth";
    public static final String DEFAULT_PROVIDER = "openlayers";
    private static final String[] PROP_version = new String[]{"mapstractionVersion"};
    public static final String[] PROP_provider = new String[]{"mapstractionProvider"};
    public static final String[] PROP_LOCAL_JS = new String[]{"mapstractionLocalJS"};
    private String apiVersion = null;
    private boolean didInitFeatures = false;

    public Mapstraction(String name, String key) {
        super(name, key);
        this.addSupportedFeature(8L);
    }

    public String getApiVersion() {
        if (this.apiVersion == null) {
            String apiV = this.getProperties().getString(PROP_version, "").trim().toLowerCase();
            apiV = StringTools.isBlank((String)apiV) ? "1" : (apiV.equals("2") ? "2" : "1");
            this.apiVersion = apiV;
        }
        return this.apiVersion;
    }

    public boolean isVersion1() {
        return this.getApiVersion().equals("1");
    }

    public boolean isVersion2() {
        return this.getApiVersion().equals("2");
    }

    public boolean isFeatureSupported(long feature) {
        if (!this.didInitFeatures) {
            String mapProvider = this.getProperties().getString(PROP_provider, "openlayers");
            boolean isOpenLayers = mapProvider.equals("openlayers");
            if (isOpenLayers) {
                this.addSupportedFeature(2L);
                this.addSupportedFeature(4L);
            }
            this.didInitFeatures = true;
        }
        return super.isFeatureSupported(feature);
    }

    @Override
    protected void writeJSVariables(PrintWriter out, RequestProperties reqState) throws IOException {
        super.writeJSVariables(out, reqState);
        String mapProvider = this.getProperties().getString(PROP_provider, "openlayers");
        out.write("// Mapstraction custom vars (" + mapProvider + ")\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SHOW_CUSTOM_ICON", (Object)mapProvider.equals("openlayers"));
        if (mapProvider.equals(PROVIDER_CLOUDMADE)) {
            String key = this._getAuthKey(mapProvider, "");
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"cloudmade_key", (Object)key);
        } else if (mapProvider.equals(PROVIDER_MICROSOFT7)) {
            String key = this._getAuthKey(mapProvider, "AlneHdcKOFDot4FjwyuLH8ZSUIz5rv_X22vULKa7H5ia0JnsxiykdO8y");
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"microsoft_key", (Object)key);
        }
    }

    @Override
    public void writeStyle(PrintWriter out, RequestProperties reqState) throws IOException {
        super.writeStyle(out, reqState);
        String mapProvider = this.getProperties().getString(PROP_provider, "openlayers");
        if (mapProvider.equals(PROVIDER_ESRI)) {
            WebPageAdaptor.writeCssLink((PrintWriter)out, (RequestProperties)reqState, (String)"http://serverapi.arcgisonline.com/jsapi/arcgis/3.2/js/esri/css/esri.css", null);
            WebPageAdaptor.writeCssLink((PrintWriter)out, (RequestProperties)reqState, (String)"http://serverapi.arcgisonline.com/jsapi/arcgis/3.2/js/dojo/dijit/themes/claro/claro.css", null);
        } else if (mapProvider.equals(PROVIDER_LEAFLET)) {
            WebPageAdaptor.writeCssLink((PrintWriter)out, (RequestProperties)reqState, (String)"http://leaflet.cloudmade.com/dist/leaflet.css", null);
        }
    }

    protected String _getAuthKey(String provider, String dftKey) {
        String mapKey = this.getAuthorization();
        if (StringTools.isBlank((String)mapKey)) {
            Print.logError((String)"No '%s' key!", (Object[])new Object[]{provider});
            mapKey = dftKey != null ? dftKey : "";
        }
        return mapKey;
    }

    @Override
    protected void writeJSIncludes(PrintWriter out, RequestProperties reqState) throws IOException {
        Vector<String> jsList = new Vector<String>();
        jsList.add(JavaScriptTools.qualifyJSFileRef((String)"maps/jsmap.js"));
        String mapProvider = this.getProperties().getString(PROP_provider, "openlayers");
        if (mapProvider.equals("openlayers")) {
            jsList.add("http://dev.openlayers.org/releases/OpenLayers-2.9.1/OpenLayers.js");
        } else if (mapProvider.equals(PROVIDER_GOOGLEV3)) {
            jsList.add("http://maps.google.com/maps/api/js?sensor=false");
            jsList.add(JavaScriptTools.qualifyJSFileRef((String)"mapstraction/labeledmarker.js"));
        } else if (mapProvider.equals(PROVIDER_OPENSPACE)) {
            String key = this._getAuthKey(mapProvider, "");
            jsList.add("http://openspace.ordnancesurvey.co.uk/osmapapi/openspace.js?key=" + key);
        } else if (mapProvider.equals(PROVIDER_OPENMQ)) {
            jsList.add("http://open.mapquestapi.com/sdk/js/v7.0.s/mqa.toolkit.js");
        } else if (mapProvider.equals(PROVIDER_CLOUDMADE)) {
            jsList.add("http://tile.cloudmade.com/wml/latest/web-maps-lite.js");
        } else if (mapProvider.equals(PROVIDER_MICROSOFT)) {
            jsList.add("http://ecn.dev.virtualearth.net/mapcontrol/mapcontrol.ashx?v=6.3&mkt=en-us");
        } else if (mapProvider.equals(PROVIDER_MICROSOFT7)) {
            jsList.add("http://ecn.dev.virtualearth.net/mapcontrol/mapcontrol.ashx?v=7.0");
        } else if (mapProvider.equals(PROVIDER_MAPQUEST)) {
            String key = this._getAuthKey(mapProvider, "");
            jsList.add("http://www.mapquestapi.com/sdk/js/v7.0.s/mqa.toolkit.js?key=" + key + "");
        } else if (mapProvider.equals(PROVIDER_ESRI)) {
            jsList.add("http://serverapi.arcgisonline.com/jsapi/arcgis/?v=3.2");
        } else if (mapProvider.equals(PROVIDER_LEAFLET)) {
            jsList.add("http://leaflet.cloudmade.com/dist/leaflet.js");
        } else if (mapProvider.equals(PROVIDER_OVI)) {
            jsList.add("http://api.maps.ovi.com/jsl.js");
        } else if (mapProvider.equals(PROVIDER_FREEEARTH)) {
            Print.logError((String)"Maptraction map provider no longer supported: %s", (Object[])new Object[]{mapProvider});
        } else if (mapProvider.equals(PROVIDER_MAP24)) {
            Print.logError((String)"Maptraction map provider no longer supported: %s", (Object[])new Object[]{mapProvider});
        } else if (mapProvider.equals(PROVIDER_MULTIMAP)) {
            Print.logError((String)"Maptraction map provider no longer supported: %s", (Object[])new Object[]{mapProvider});
        } else if (mapProvider.equals(PROVIDER_YAHOO)) {
            Print.logError((String)"Maptraction map provider no longer supported: %s", (Object[])new Object[]{mapProvider});
        } else {
            Print.logError((String)"Unrecognized map provider specified: %s", (Object[])new Object[]{mapProvider});
        }
        if (this.getProperties().getBoolean(PROP_LOCAL_JS, false)) {
            jsList.add(JavaScriptTools.qualifyJSFileRef((String)("mapstraction/mxn/mxn.js?(" + mapProvider + ")")));
        } else {
            jsList.add("http://mapstraction.com/mxn/build/latest/mxn.js?(" + mapProvider + ")");
        }
        jsList.add(JavaScriptTools.qualifyJSFileRef((String)"maps/MapstractionMXN2.js"));
        super.writeJSIncludes(out, reqState, jsList.toArray(new String[jsList.size()]));
    }

    public String[] getGeozoneInstructions(int type, Locale loc) {
        I18N i18n = I18N.getI18N(Mapstraction.class, (Locale)loc);
        return new String[]{i18n.getString("Mapstraction.geozoneInstructions", "")};
    }
}

