/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.maps.jsmap;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Geozone;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.maps.JSMap;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;

public class GoogleMaps
extends JSMap {
    private static final String[] PROP_version = new String[]{"google.version"};
    private static final String[] PROP_mapcontrol = new String[]{"google.mapcontrol"};
    private static final String[] PROP_useSSL = new String[]{"google.useSSL"};
    private static final String[] PROP_sensor = new String[]{"google.sensor"};
    private static final String[] PROP_channel = new String[]{"google.channel"};
    private static final String[] PROP_enableRuler = new String[]{"google.enableRuler"};
    private static final String[] PROP_mapOptions = new String[]{"google.mapOptions"};
    private static final String[] PROP_mapInitCallback = new String[]{"google.mapInitCallback"};
    private static final String[] PROP_addTrafficOverlay = new String[]{"google.addTrafficOverlay", "addTrafficOverlay"};
    private static final String[] PROP_addWeatherOverlay = new String[]{"google.addWeatherOverlay", "addWeatherOverlay"};
    private static final String[] PROP_addCloudOverlay = new String[]{"google.addCloudOverlay", "addCloudOverlay"};
    private static final String[] PROP_addOpenStreetMap = new String[]{"google.addOpenStreetMap", "addOpenStreetMap"};
    private static final String[] PROP_addBingMap = new String[]{"google.addBingMap", "addBingMap"};
    private static final String[] PROP_kmlOverlay = new String[]{"google.kmlOverlay", "kmlOverlay"};
    private static final String PremierPrefix_ = "gme-";
    private String apiVersion = null;
    private String mapOptions = null;

    public GoogleMaps(String name, String key) {
        super(name, key);
        this.addSupportedFeature(2L);
        this.addSupportedFeature(1L);
        this.addSupportedFeature(8L);
        this.addSupportedFeature(16L);
        this.addSupportedFeature(32L);
        this.addSupportedFeature(64L);
        this.addSupportedFeature(128L);
    }

    public String getApiVersion() {
        if (this.apiVersion == null) {
            String apiV = this.getProperties().getString(PROP_version, "").trim().toLowerCase();
            if (StringTools.isBlank((String)apiV)) {
                apiV = "2";
            }
            this.apiVersion = apiV;
        }
        return this.apiVersion;
    }

    public boolean isVersion2() {
        return this.getApiVersion().equals("2");
    }

    public boolean isVersion3() {
        return this.getApiVersion().equals("3");
    }

    public boolean isVersionJS() {
        return this.getApiVersion().equals("js");
    }

    public String getMapOptions() {
        if (this.mapOptions == null) {
            this.mapOptions = this.getProperties().getString(PROP_mapOptions, "");
        }
        return this.mapOptions;
    }

    public String getMapInitCallback() {
        String cb = this.getProperties().getString(PROP_mapInitCallback, null);
        return cb;
    }

    public void postInit() {
        if (this.isVersion3() && this.getProperties().getBoolean(PROP_enableRuler, false)) {
            this.addSupportedFeature(4L);
        }
    }

    public boolean validate() {
        if (this.isVersion2()) {
            String authKey = this.getAuthorization();
            if (authKey == null || authKey.startsWith("*")) {
                Print.logError((String)"Google Map key not specified", (Object[])new Object[0]);
                return false;
            }
            if (!authKey.startsWith(PremierPrefix_) && authKey.length() < 30) {
                Print.logError((String)"Invalid Google Map key specified", (Object[])new Object[0]);
                return false;
            }
        } else if (this.isVersion3() || this.isVersionJS()) {
            // empty if block
        }
        return true;
    }

    @Override
    protected void writeJSVariables(PrintWriter out, RequestProperties reqState) throws IOException {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(GoogleMaps.class);
        Locale locale = reqState.getLocale();
        RTProperties rtp = this.getProperties();
        String trafficText = i18n.getString("GoogleMaps.traffic", "Traffic");
        String weatherText = i18n.getString("GoogleMaps.weather", "Weather");
        String cloudText = i18n.getString("GoogleMaps.clouds", "Clouds");
        String tempU = "F";
        switch (reqState.getTemperatureUnits()) {
            case C: {
                tempU = "C";
                break;
            }
            case F: {
                tempU = "F";
            }
        }
        String speedU = "MPH";
        switch (reqState.getSpeedUnits()) {
            case MPH: {
                speedU = "MPH";
                break;
            }
            case KPH: {
                speedU = "KPH";
                break;
            }
            case KNOTS: {
                speedU = "KNOTS";
            }
        }
        out.write("// --- Google specific vars [" + this.getName() + "]\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_API", (Object)this.getApiVersion());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_API_V2", (Object)this.isVersion2());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_MAP_OPTIONS", (Object)this.getMapOptions(), (boolean)false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_MAP_INIT_CALLBACK", (Object)this.getMapInitCallback(), (boolean)false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_BINGMAP", (Object)rtp.getBoolean(PROP_addBingMap, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_OPENSTREETMAP", (Object)rtp.getBoolean(PROP_addOpenStreetMap, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_TRAFFIC_OVERLAY", (Object)rtp.getBoolean(PROP_addTrafficOverlay, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TRAFFIC_TEXT", (Object)trafficText);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_WEATHER_OVERLAY", (Object)rtp.getBoolean(PROP_addWeatherOverlay, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"WEATHER_TEMPU", (Object)tempU);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"WEATHER_SPEEDU", (Object)speedU);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"WEATHER_TEXT", (Object)weatherText);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_CLOUD_OVERLAY", (Object)rtp.getBoolean(PROP_addCloudOverlay, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"CLOUD_TEXT", (Object)cloudText);
        String kmlURL = rtp.getString(PROP_kmlOverlay, null);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_KML_OVERLAY", (Object)(!StringTools.isBlank((String)kmlURL) ? 1 : 0));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"GOOGLE_KML_URL", (Object)kmlURL);
        super.writeJSVariables(out, reqState);
    }

    @Override
    protected void writeJSIncludes(PrintWriter out, RequestProperties reqState) throws IOException {
        String mapCtlURL;
        MapProvider mp = reqState.getMapProvider();
        RTProperties mrtp = mp != null ? mp.getProperties() : null;
        String string = mapCtlURL = mrtp != null ? mrtp.getString(PROP_mapcontrol, null) : null;
        if (StringTools.isBlank((String)mapCtlURL)) {
            String sensorVal;
            StringBuffer sb = new StringBuffer();
            boolean useSSL = mrtp.getBoolean(PROP_useSSL, false);
            sb.append(useSSL ? "https://" : "http://");
            if (this.isVersion3()) {
                boolean weather;
                sb.append("maps.google.com/maps/api/js?v=3");
                RTProperties rtp = this.getProperties();
                boolean bl = weather = rtp.getBoolean(PROP_addWeatherOverlay, false) || rtp.getBoolean(PROP_addCloudOverlay, false);
                if (weather) {
                    sb.append("&libraries=weather");
                }
            } else if (this.isVersion2()) {
                sb.append("maps.google.com/maps?file=api&v=2");
            } else if (this.isVersionJS()) {
                sb.append("maps.googleapis.com/maps/api/js?sensor=false");
            } else {
                sb.append("maps.google.com/maps?file=api&v=2");
            }
            String channelVal = mrtp != null ? mrtp.getString(PROP_channel, "") : "";
            String authKey = this.getAuthorization();
            if (!StringTools.isBlank((String)authKey) && !authKey.startsWith("*")) {
                if (authKey.startsWith(PremierPrefix_)) {
                    sb.append("&client=").append(authKey);
                    if (StringTools.isBlank((String)channelVal)) {
                        channelVal = DBConfig.getServiceAccountID(null);
                    }
                } else if (this.isVersion2() && authKey.length() < 25) {
                    Print.logError((String)"Invalid Google Map V2 key specified", (Object[])new Object[0]);
                } else {
                    sb.append("&key=").append(authKey);
                }
            } else if (this.isVersion2()) {
                Print.logError((String)"Google Map V2 key not specified", (Object[])new Object[0]);
            }
            if (!StringTools.isBlank((String)channelVal)) {
                sb.append("&channel=").append(channelVal);
            }
            String string2 = sensorVal = mrtp != null ? mrtp.getString(PROP_sensor, "true") : "true";
            if (!StringTools.isBlank((String)sensorVal)) {
                sb.append("&sensor=").append(sensorVal);
            }
            sb.append("&oe=").append("utf-8");
            String localStr = reqState.getPrivateLabel().getLocaleString();
            if (!StringTools.isBlank((String)localStr)) {
                sb.append("&hl=").append(localStr);
            }
            mapCtlURL = sb.toString();
        }
        super.writeJSIncludes(out, reqState, new String[]{JavaScriptTools.qualifyJSFileRef((String)"maps/jsmap.js"), mapCtlURL, this.isVersion3() || this.isVersionJS() ? JavaScriptTools.qualifyJSFileRef((String)"maps/GoogleMapsV3.js") : JavaScriptTools.qualifyJSFileRef((String)"maps/GoogleMapsV2.js")});
    }

    public int getGeozoneSupportedPointCount(int type) {
        Geozone.GeozoneType gzType = Geozone.getGeozoneType((int)type);
        if (!Geozone.IsGeozoneTypeSupported((Geozone.GeozoneType)gzType)) {
            return 0;
        }
        RTProperties rtp = this.getProperties();
        switch (gzType) {
            case POINT_RADIUS: {
                return rtp.getBoolean(PROP_zone_map_multipoint, false) ? Geozone.GetGeoPointCount() : 1;
            }
            case BOUNDED_RECT: {
                return 0;
            }
            case SWEPT_POINT_RADIUS: {
                return rtp.getBoolean(PROP_zone_map_corridor, false) ? Geozone.GetGeoPointCount() : 0;
            }
            case POLYGON: {
                return rtp.getBoolean(PROP_zone_map_polygon, false) ? Geozone.GetGeoPointCount() : 0;
            }
        }
        return 0;
    }

    public String[] getGeozoneInstructions(int type, Locale loc) {
        I18N i18n = I18N.getI18N(GoogleMaps.class, (Locale)loc);
        if (type == Geozone.GeozoneType.POINT_RADIUS.getIntValue()) {
            return new String[]{i18n.getString("GoogleMaps.geozoneNotes.1", "Click to reset center."), i18n.getString("GoogleMaps.geozoneNotes.2", "Click-drag center to move."), i18n.getString("GoogleMaps.geozoneNotes.3", "Click-drag radius to resize.")};
        }
        if (type == Geozone.GeozoneType.POLYGON.getIntValue()) {
            return new String[]{i18n.getString("GoogleMaps.geozoneNotes.1", "Click to reset center."), i18n.getString("GoogleMaps.geozoneNotes.2", "Click-drag center to move."), i18n.getString("GoogleMaps.geozoneNotes.4", "Click-drag corner to resize.")};
        }
        return new String[0];
    }
}

