/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.maps;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.EventUtil;
import org.opengts.db.tables.Account;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.MapProviderAdapter;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.PushpinIcon;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPageAdaptor;

public class JSMap
extends MapProviderAdapter {
    public static final String DEFAULT_MAP_ID = "jsmap";
    private static final int DEFAULT_ZOOM = 14;
    private static final int PUSHPIN_ZOOM = 8;
    private static final String PROP_MAP_ID = "jsmap.mapID";
    private static final String PROP_MAP_LOADING = "jsmap.showMapLoading";
    private static final String PROP_MAP_LOADING_IMAGE = "jsmap.showMapLoading.image";
    private static final Object[] SKIP_PROPS = new Object[]{PROP_javascript_src, PROP_javascript_inline, PROP_zone_map_width, PROP_zone_map_height, PROP_map_width, PROP_map_height, PROP_map_fillFrame, PROP_map_pushpins, PROP_map_maxCreationAge, PROP_map_routeLine, PROP_map_routeLine_color, PROP_map_routeLine_arrows, PROP_map_routeLine_snapToRoad, PROP_scrollWheelZoom, PROP_map_view, PROP_iconSelector, PROP_iconSelector_legend, PROP_iconSel_fleet, PROP_iconSel_fleet_legend, PROP_pushpin_zoom, PROP_default_zoom, PROP_default_latitude, PROP_default_longitude};

    public JSMap(String name, String key) {
        super(name, key);
    }

    public String getMapID() {
        RTProperties rtp = this.getProperties();
        return rtp.getString(PROP_MAP_ID, DEFAULT_MAP_ID);
    }

    protected boolean _skipPropKey(Object key) {
        String ks = key.toString();
        for (int i = 0; i < SKIP_PROPS.length; ++i) {
            Object[] propKey = (String[])SKIP_PROPS[i];
            if (!ListTools.contains((Object[])propKey, (Object)ks)) continue;
            return true;
        }
        return false;
    }

    public void writeStyle(PrintWriter out, RequestProperties reqState) throws IOException {
        WebPageAdaptor.writeCssLink((PrintWriter)out, (RequestProperties)reqState, (String)"JSMap.css", null);
    }

    protected void writeJSVariables(PrintWriter out, RequestProperties reqState) throws IOException {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(JSMap.class);
        Locale locale = reqState.getLocale();
        GeoPoint dftCenter = this.getDefaultCenter(null);
        boolean isFleet = reqState.isFleet();
        Account account = reqState.getCurrentAccount();
        long maxPushpins = this.getMaxPushpins(reqState);
        out.write("// --- Map support Javascript [" + this.getName() + "]\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAP_PROVIDER_NAME", (Object)this.getName());
        boolean wrotePropHeader = false;
        RTProperties rtp = this.getProperties();
        Iterator i = rtp.keyIterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (this._skipPropKey(key)) continue;
            if (!wrotePropHeader) {
                out.write("// Defined properties\n");
                wrotePropHeader = true;
            }
            String[] val = StringTools.parseStringArray((String)rtp.getProperty(key, (Object)"").toString(), (char)'\n');
            String propVar = "PROP_" + key.toString().replace('.', '_').replace('-', '_');
            if (val.length == 1) {
                if (StringTools.isDouble((String)val[0], (boolean)true) || StringTools.isLong((String)val[0], (boolean)true) || StringTools.isBoolean((String)val[0], (boolean)true)) {
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)propVar, (Object)val[0], (boolean)false);
                    continue;
                }
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)propVar, (Object)val[0]);
                continue;
            }
            if (val.length <= 1) continue;
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)propVar, (Object)StringTools.join((String[])val, (String)"\\n"));
        }
        Account.SpeedUnits speedUnits = reqState.getSpeedUnits();
        boolean speedIsKph = speedUnits.equals((Object)Account.SpeedUnits.KPH);
        double altUnitsMult = speedIsKph ? 1.0 : 3.280839895013123;
        String altUnitsName = speedIsKph ? i18n.getString("JSMap.altitude.meters", "Meters") : i18n.getString("JSMap.altitude.feet", "Feet");
        out.write("// Element IDs\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAP_ID", (Object)this.getMapID());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_DETAIL_TABLE", (Object)"trackMapDataTable");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_DETAIL_CONTROL", (Object)"trackMapDataControl");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_LAT_LON_DISPLAY", (Object)"trackMapLatLonDisplay");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_DISTANCE_DISPLAY", (Object)"trackMapDistanceDisplay");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_LATEST_EVENT_DATE", (Object)"lastEventDate");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_LATEST_EVENT_TIME", (Object)"lastEventTime");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_LATEST_EVENT_TMZ", (Object)"lastEventTmz");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_LATEST_BATTERY", (Object)"lastBatteryLevel");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_MESSAGE_TEXT", (Object)"contentMessage");
        out.write("// Geozone IDs\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_ZONE_LATITUDE_", (Object)"trackMapZoneLatitude_");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_ZONE_LONGITUDE_", (Object)"trackMapZoneLongitude_");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ID_ZONE_RADIUS_M", (Object)"trackMapZoneRadiusM");
        out.write("// Session constants\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"PUSHPINS_SHOW", (Object)rtp.getBoolean(PROP_map_pushpins, true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAX_PUSH_PINS", (Object)maxPushpins);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAX_CREATION_AGE_SEC", (Object)rtp.getInt(PROP_map_maxCreationAge, 0));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAP_WIDTH", (Object)this.getDimension().getWidth());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAP_HEIGHT", (Object)this.getDimension().getHeight());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"IS_FLEET", (Object)isFleet);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SHOW_SAT_COUNT", (Object)rtp.getBoolean(PROP_detail_showSatCount, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SHOW_SPEED", (Object)rtp.getBoolean(PROP_info_showSpeed, true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"COMBINE_SPEED_HEAD", (Object)rtp.getBoolean(PROP_combineSpeedHeading, true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SHOW_ALTITUDE", (Object)rtp.getBoolean(PROP_info_showAltitude, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SHOW_ADDR", (Object)reqState.getShowAddress());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"INCL_BLANK_ADDR", (Object)rtp.getBoolean(PROP_info_inclBlankAddress, true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SHOW_OPT_FIELDS", (Object)rtp.getBoolean(PROP_info_showOptionalFields, true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"INCL_BLANK_OPT_FIELDS", (Object)rtp.getBoolean(PROP_info_inclBlankOptFields, true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"LATLON_FORMAT", (Object)Account.getLatLonFormat((Account)account).getIntValue());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"DISTANCE_KM_MULT", (Object)reqState.getDistanceUnits().getMultiplier());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SPEED_KPH_MULT", (Object)speedUnits.getMultiplier());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SPEED_UNITS", (Object)speedUnits.toString(locale));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ALTITUDE_METERS_MULT", (Object)altUnitsMult);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ALTITUDE_UNITS", (Object)altUnitsName);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TIME_ZONE", (Object)reqState.getTimeZoneString(null));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"DEFAULT_CENTER", (Object)("{ lat:" + dftCenter.getLatitude() + ", lon:" + dftCenter.getLongitude() + " }"), (boolean)false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"DEFAULT_ZOOM", (Object)this.getDefaultZoom(14, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"PUSHPIN_ZOOM", (Object)this.getDefaultZoom(8, true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAP_AUTHORIZATION", (Object)this.getAuthorization());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SCROLL_WHEEL_ZOOM", (Object)rtp.getBoolean(PROP_scrollWheelZoom, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"DEFAULT_VIEW", (Object)rtp.getString(PROP_map_view, "").toLowerCase());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ROUTE_LINE_SHOW", (Object)rtp.getBoolean(PROP_map_routeLine, true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ROUTE_LINE_COLOR", (Object)rtp.getString(PROP_map_routeLine_color, "#FF2222"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ROUTE_LINE_ARROWS", (Object)rtp.getBoolean(PROP_map_routeLine_arrows, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"ROUTE_SNAP_TO_ROAD", (Object)rtp.getBoolean(PROP_map_routeLine_snapToRoad, false));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"REPLAY_INTERVAL", (Object)this.getReplayInterval());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"REPLAY_SINGLE", (Object)this.getReplaySinglePushpin());
        Object[] adrTitles = reqState.getAddressTitles();
        String adrTitle = (String)ListTools.itemAt((Object[])adrTitles, (int)0, null);
        Object[] devTitles = reqState.getDeviceTitles();
        String devTitle = (String)ListTools.itemAt((Object[])devTitles, (int)0, null);
        out.write("// Localized Text/Labels\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"HEADING", (Object)("new Array(\"" + GeoPoint.CompassHeading.N.toString(locale) + "\"," + "\"" + GeoPoint.CompassHeading.NE.toString(locale) + "\"," + "\"" + GeoPoint.CompassHeading.E.toString(locale) + "\"," + "\"" + GeoPoint.CompassHeading.SE.toString(locale) + "\"," + "\"" + GeoPoint.CompassHeading.S.toString(locale) + "\"," + "\"" + GeoPoint.CompassHeading.SW.toString(locale) + "\"," + "\"" + GeoPoint.CompassHeading.W.toString(locale) + "\"," + "\"" + GeoPoint.CompassHeading.NW.toString(locale) + "\")"), (boolean)false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_INFO_DATE", (Object)i18n.getString("JSMap.info.date", "Date"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_INFO_GPS", (Object)i18n.getString("JSMap.info.gps", "GPS"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_INFO_SATS", (Object)i18n.getString("JSMap.info.sats", "#Sats"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_INFO_SPEED", (Object)i18n.getString("JSMap.info.speed", "Speed"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_INFO_HEADING", (Object)GeoPoint.GetHeadingTitle((Locale)locale));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_INFO_ALTITUDE", (Object)i18n.getString("JSMap.info.altitude", "Altitude"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_INFO_STOP_TIME", (Object)i18n.getString("JSMap.info.stopTime", "Stop Time"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_INFO_ADDR", (Object)(!StringTools.isBlank((String)adrTitle) ? adrTitle : i18n.getString("JSMap.info.address", "Address")));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_DEVICE", (Object)(!StringTools.isBlank((String)devTitle) ? devTitle : i18n.getString("JSMap.device", "Device")));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_DATE", (Object)i18n.getString("JSMap.dateTime", "Date/Time"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_CODE", (Object)i18n.getString("JSMap.code", "Status"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_LATLON", (Object)i18n.getString("JSMap.latLon", "Lat/Lon"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_SATCOUNT", (Object)i18n.getString("JSMap.satCount", "#Sats"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_ADDR", (Object)(!StringTools.isBlank((String)adrTitle) ? adrTitle : i18n.getString("JSMap.address", "Address")));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_SPEED", (Object)reqState.getSpeedUnits().toString(locale));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_HEADING", (Object)i18n.getString("JSMap.heading", "Heading"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_DISTANCE", (Object)reqState.getDistanceUnits().toString(locale));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_TIMEOUT", (Object)i18n.getString("JSMap.sessionTimeout", "Your session has timed-out.\nPlease login ..."));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_PING_OK", (Object)i18n.getString("JSMap.pingDevice.ok", "A command request has been sent.\nThe {0} should respond shortly ...", devTitles));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_PING_ERROR", (Object)i18n.getString("JSMap.pingDevice.err", "The command request failed.\nThe {0} may not support this feature ...", devTitles));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_MAXPUSHPINS_ALERT", (Object)i18n.getString("JSMap.maxPushpins.err", "The maximum number of allowed pushpins has been exceeded.\n [max={0}] Not all pushpins may be displayed on this map.\nAdjust the 'From' time to see remaining pushpins", (Object)String.valueOf(maxPushpins)));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_MAXPUSHPINS_MSG", (Object)i18n.getString("JSMap.maxPushpins.msg", "Only partial data displayed.  The maximum allowed pushpins has been reached.<BR>Adjust the Date/Time range accordingly to view the remaining pushpins."));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_UNAVAILABLE", (Object)i18n.getString("JSMap.unavailable", "unavailable"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_showLocationDetails", (Object)i18n.getString("JSMap.showLocationDetails", "Show Location Details"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_hideLocationDetails", (Object)i18n.getString("JSMap.hideLocationDetails", "Hide Location Details"));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_LOADING_MAP_POINTS", rtp.getBoolean(PROP_MAP_LOADING, false) ? i18n.getString("JSMap.loadingMapPoints", "Loading Map Points ...") : null);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAP_LOADING_IMAGE_URI", (Object)rtp.getString(PROP_MAP_LOADING_IMAGE, null));
        JSMap.writePushpinArray(out, reqState);
        out.write("// Geozone support constants\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvGeozoneMode", (Object)false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MAX_ZONE_RADIUS_M", (Object)30000.0);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"MIN_ZONE_RADIUS_M", (Object)5.0);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"DETAIL_REPORT", (Object)this.isFeatureSupported(8L));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"DETAIL_INFO_BOX", (Object)this.isFeatureSupported(16L));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_METERS", (Object)GeoPoint.DistanceUnits.METERS.toString(locale));
        out.write("// TrackMap Vars\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvPoiPins", null);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvDataSets", null);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvDetailPoints", null);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvDetailVisible", (Object)false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvDetailAscending", (Object)privLabel.getBooleanProperty("trackMap.detailAscending", true));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvDetailCenterPushpin", (Object)privLabel.getBooleanProperty("trackMap.detailCenterPushpin", false));
        TimeZone tmz = reqState.getTimeZone();
        String dateFmt = account != null ? account.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String timeFmt = account != null ? account.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        DateTime today = new DateTime(tmz);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvTodayEpoch", (Object)today.getTimeSec());
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvTodayYMD", (Object)("{ YYYY:" + today.getYear(tmz) + ", MM:" + today.getMonth1(tmz) + ", DD:" + today.getDayOfMonth(tmz) + " }"), (boolean)false);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvTodayDateFmt", (Object)today.format(dateFmt, tmz));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvTodayTimeFmt", (Object)today.format(timeFmt, tmz));
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvTodayTmzFmt", (Object)today.format("z", tmz));
        out.write("// Last event time\n");
        DateTime lastEventTime = reqState.getLastEventTime();
        if (lastEventTime != null) {
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventEpoch", (Object)lastEventTime.getTimeSec());
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventYMD", (Object)("{ YYYY:" + lastEventTime.getYear(tmz) + ", MM:" + lastEventTime.getMonth1(tmz) + ", DD:" + lastEventTime.getDayOfMonth(tmz) + " }"), (boolean)false);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventDateFmt", (Object)lastEventTime.format(dateFmt, tmz));
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventTimeFmt", (Object)lastEventTime.format(timeFmt, tmz));
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventTmzFmt", (Object)lastEventTime.format("z", tmz));
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastBatteryLevel", (Object)0L);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastSignalStrength", (Object)0L);
        } else {
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventEpoch", (Object)0L);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventYMD", null);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventDateFmt", null);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventTimeFmt", null);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastEventTmzFmt", null);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastBatteryLevel", (Object)0.0);
            JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvLastSignalStrength", (Object)0.0);
        }
        out.write("// Map vars\n");
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsmapElem", null);
        JavaScriptTools.writeJSVar((PrintWriter)out, (String)DEFAULT_MAP_ID, null);
    }

    public static void writePushpinArray(PrintWriter out, RequestProperties reqState) throws IOException {
        MapProvider mapProv = reqState.getMapProvider();
        out.write("// Icon URLs\n");
        out.write("var jsvPushpinIcon = new Array(\n");
        OrderedMap iconMap = mapProv.getPushpinIconMap(reqState);
        Iterator k = iconMap.keyIterator();
        while (k.hasNext()) {
            String key = (String)k.next();
            PushpinIcon ppi = (PushpinIcon)iconMap.get((Object)key);
            String I = ppi.getIconURL();
            boolean iE = ppi.getIconEval();
            int iW = ppi.getIconWidth();
            int iH = ppi.getIconHeight();
            int iX = ppi.getIconHotspotX();
            int iY = ppi.getIconHotspotY();
            String S = ppi.getShadowURL();
            int sW = ppi.getShadowWidth();
            int sH = ppi.getShadowHeight();
            String B = ppi.getBackgroundURL();
            int bW = ppi.getBackgroundWidth();
            int bH = ppi.getBackgroundHeight();
            int bX = ppi.getBackgroundOffsetX();
            int bY = ppi.getBackgroundOffsetY();
            out.write("    {");
            out.write(" key:\"" + key + "\",");
            if (iE) {
                out.write(" iconEval:\"" + I + "\",");
            } else {
                out.write(" iconURL:\"" + I + "\",");
            }
            out.write(" iconSize:[" + iW + "," + iH + "],");
            out.write(" iconOffset:[" + iX + "," + iY + "],");
            out.write(" iconHotspot:[" + iX + "," + iY + "],");
            out.write(" shadowURL:\"" + S + "\",");
            out.write(" shadowSize:[" + sW + "," + sH + "]");
            if (!StringTools.isBlank((String)B)) {
                out.write(",");
                out.write(" bgURL:\"" + B + "\",");
                out.write(" bgSize:[" + bW + "," + bH + "],");
                out.write(" bgOffset:[" + bX + "," + bY + "]");
            }
            out.write(" }");
            if (k.hasNext()) {
                out.write(",");
            }
            out.write("\n");
        }
        out.write("    );\n");
    }

    protected void writeJSIncludes(PrintWriter out, RequestProperties reqState, String[] jsMapURLs) throws IOException {
        HttpServletRequest request = reqState.getHttpServletRequest();
        JavaScriptTools.writeJSIncludes((PrintWriter)out, (String[])jsMapURLs, (HttpServletRequest)request);
    }

    protected void writeJSIncludes(PrintWriter out, RequestProperties reqState) throws IOException {
    }

    public void writeJavaScript(PrintWriter out, RequestProperties reqState) throws IOException {
        String mapLoadingImageURI;
        if (this.getProperties().getBoolean(PROP_MAP_LOADING, false) && !StringTools.isBlank((String)(mapLoadingImageURI = this.getProperties().getString(PROP_MAP_LOADING_IMAGE, null)))) {
            out.write("<link rel=\"prefetch\" href=\"" + mapLoadingImageURI + "\">\n");
        }
        JavaScriptTools.writeStartJavaScript((PrintWriter)out);
        this.writeJSVariables(out, reqState);
        JavaScriptTools.writeEndJavaScript((PrintWriter)out);
        this.writeJSIncludes(out, reqState);
        String[] jsMapURLs = StringTools.parseStringArray((String)this.getProperties().getString(PROP_javascript_src, ""), (char)'\n');
        this.writeJSIncludes(out, reqState, jsMapURLs);
        String jsMapInline = StringTools.trim((String)this.getProperties().getString(PROP_javascript_inline, null));
        if (!StringTools.isBlank((String)jsMapInline)) {
            JavaScriptTools.writeStartJavaScript((PrintWriter)out);
            out.write("// --- Inline Javascript [" + this.getName() + "]\n");
            out.write(jsMapInline);
            out.write("\n");
            JavaScriptTools.writeEndJavaScript((PrintWriter)out);
        }
        JavaScriptTools.writeStartJavaScript((PrintWriter)out);
        out.write(EventUtil.getInstance().getParseMapEventJS(reqState.isFleet(), reqState.getLocale()));
        JavaScriptTools.writeEndJavaScript((PrintWriter)out);
    }

    public void writeMapUpdate(int mapDataFormat, RequestProperties reqState, int[] statusCodes) throws IOException {
        super.writeMapUpdate(mapDataFormat, reqState, statusCodes);
    }
}

