/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.tlt2h;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.servers.GPSEvent;
import org.opengts.servers.tlt2h.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static int DATA_FORMAT_OPTION = 1;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static long SIMEVENT_DIGITAL_INPUTS = 0L;
    private static boolean DFT_INSERT_EVENT;
    private static boolean INSERT_EVENT;
    public static double MINIMUM_SPEED_KPH;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    public static final double KNOTS_PER_KILOMETER = 0.5399568034557235;
    private String tipoData = "";
    private static final int[] InputStatusCodes_ON;
    private static final int[] InputStatusCodes_OFF;
    private String sessionID = null;
    private GPSEvent gpsEvent = null;
    private Device gpsDevice = null;
    private String lastModemID = null;
    private boolean terminate = false;
    private String ipAddress = null;
    private int clientPort = 0;
    public static final boolean USE_STANDARD_TCP_SESSION_ID = true;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.clientPort = this.getSessionInfo().getRemotePort();
        this.tipoData = this.isDuplex() ? "TCP" : "UDP";
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public String getSessionID() {
        if (!StringTools.isBlank(this.sessionID)) {
            return this.sessionID;
        }
        if (this.gpsDevice != null) {
            return TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        }
        if (this.gpsEvent != null) {
            return TrackClientPacketHandler.CreateTcpSessionID(this.gpsEvent.getDevice());
        }
        return null;
    }

    public static String GetTcpSessionID(Device dev) {
        return DCServerFactory.getTcpSessionID(dev);
    }

    public static String CreateTcpSessionID(Device dev) {
        return DCServerFactory.createTcpSessionID(dev);
    }

    private GPSEvent createGPSEvent(String modemID) {
        DCServerConfig dcserver = Main.getServerConfig(null);
        if (this.gpsDevice != null) {
            if (!(modemID.equals("*") || this.lastModemID != null && this.lastModemID.equals(modemID))) {
                Print.logError("New MobileID does not match previously loaded Device", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, this.gpsDevice);
        } else {
            if (StringTools.isBlank(modemID) || modemID.equals("*")) {
                Print.logWarn("ModemID not specified!", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, modemID);
            this.gpsDevice = this.gpsEvent.getDevice();
        }
        if (this.gpsDevice == null) {
            return null;
        }
        this.sessionID = TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        return this.gpsEvent;
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        return -2;
    }

    private void setTerminate() {
        this.terminate = true;
    }

    @Override
    public boolean getTerminateSession() {
        return this.terminate;
    }

    @Override
    public byte[] getInitialPacket() throws Exception {
        return null;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes != null && pktBytes.length > 0) {
            String s = StringTools.toStringValue(pktBytes).trim();
            System.out.println("");
            byte[] rtn = null;
            if (!s.endsWith("##")) {
                return null;
            }
            System.out.println(this.tipoData + " : " + s);
            rtn = this.insertTLT2HData(s);
            return rtn;
        }
        Print.logInfo("...", new Object[0]);
        return null;
    }

    @Override
    public byte[] getFinalPacket(boolean hasError) throws Exception {
        return null;
    }

    private long _getUTCSeconds(long dmy, long hms) {
        long DAY;
        int HH = (int)(hms / 10000L % 100L);
        int MM = (int)(hms / 100L % 100L);
        int SS = (int)(hms % 100L);
        long TOD = (long)HH * 3600L + (long)MM * 60L + (long)SS;
        if (dmy > 0L) {
            int yy = (int)(dmy % 100L) + 2000;
            int mm = (int)(dmy / 100L % 100L);
            int dd = (int)(dmy / 10000L % 100L);
            long yr = (long)yy * 1000L + (long)((mm - 3) * 1000 / 12);
            DAY = (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)dd - 719469L;
        } else {
            long dif;
            long utc = DateTime.getCurrentTimeSec();
            long tod = utc % DateTime.DaySeconds(1L);
            DAY = utc / DateTime.DaySeconds(1L);
            long l = dif = tod >= TOD ? tod - TOD : TOD - tod;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = tod > TOD ? ++DAY : --DAY;
            }
        }
        long sec = DateTime.DaySeconds(DAY) + TOD;
        return sec;
    }

    private double _parseLatitude(String s, String d) {
        double _lat = StringTools.parseDouble(s, 99999.0);
        if (_lat < 99999.0) {
            double lat = (long)_lat / 100L;
            lat += (_lat - lat * 100.0) / 60.0;
            return d.equals("S") ? -lat : lat;
        }
        return 90.0;
    }

    private double _parseLongitude(String s, String d) {
        double _lon = StringTools.parseDouble(s, 99999.0);
        if (_lon < 99999.0) {
            double lon = (long)_lon / 100L;
            lon += (_lon - lon * 100.0) / 60.0;
            return d.equals("W") ? -lon : lon;
        }
        return 180.0;
    }

    private byte[] insertTLT2HData(String s) {
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        Print.logInfo("Parsing ...", new Object[0]);
        String[] fld = StringTools.parseStringArray(s, '#');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        if (fld.length < 7) {
            Print.logWarn("Campos insuficientes", new Object[0]);
            return null;
        }
        Print.logInfo("FLD: " + fld[0], new Object[0]);
        Print.logInfo("FLD: " + fld[1], new Object[0]);
        Print.logInfo("FLD: " + fld[2], new Object[0]);
        Print.logInfo("FLD: " + fld[3], new Object[0]);
        Print.logInfo("FLD: " + fld[4], new Object[0]);
        Print.logInfo("FLD: " + fld[5], new Object[0]);
        Print.logInfo("FLD: " + fld[6], new Object[0]);
        String modemID = null;
        modemID = fld[1];
        if (StringTools.isBlank(modemID)) {
            Print.logError("'ID:' value is missing", new Object[0]);
            return null;
        }
        String[] gprm = StringTools.parseStringArray(fld[6], ',');
        long hms = StringTools.parseLong(gprm[1], 0L);
        long dmy = StringTools.parseLong(gprm[9], 0L);
        long fixtime = this._getUTCSeconds(dmy, hms);
        boolean validGPS = gprm[2].equalsIgnoreCase("A");
        double latitude = validGPS ? this._parseLatitude(gprm[3], gprm[4]) : 0.0;
        double longitude = validGPS ? this._parseLongitude(gprm[5], gprm[6]) : 0.0;
        double knots = validGPS ? StringTools.parseDouble(gprm[7], -1.0) : 0.0;
        double heading = validGPS ? StringTools.parseDouble(gprm[8], -1.0) : 0.0;
        double speedKPH = knots >= 0.0 ? knots * 1.852 : -1.0;
        double altitudeM = 0.0;
        int statusCode = 61472;
        if (!validGPS) {
            System.out.println("DATA GPS NO VALIDA!. --- Se descarta trama para evitar errores ---");
            return null;
        }
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        Device device = this.gpsEvent.getDevice();
        if (device == null) {
            return null;
        }
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        System.out.println("Registro ---> [" + accountID + "/" + deviceID + "/" + uniqueID + "]");
        System.out.println("Evento: " + fixtime + " [" + new DateTime(fixtime) + "]");
        double maxSpeed = device.getSpeedLimitKPH();
        if (speedKPH > MINIMUM_SPEED_KPH && speedKPH < maxSpeed) {
            statusCode = device.getLastValidSpeed() <= MINIMUM_SPEED_KPH ? 61713 : 61714;
        } else if (speedKPH >= maxSpeed) {
            statusCode = 61722;
        } else if (speedKPH <= MINIMUM_SPEED_KPH) {
            statusCode = 61715;
        }
        speedKPH = this.gpsEvent.ajustaVelocidad(device.getDescription(), speedKPH);
        this.lastModemID = modemID;
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setBatteryLevel(100.0);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    private boolean parseInsertRecord_Common(GPSEvent gpsEv) {
        List<Device.GeozoneTransition> zone;
        double odomKM;
        long fixtime = gpsEv.getTimestamp();
        int statusCode = gpsEv.getStatusCode();
        Device dev = gpsEv.getDevice();
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date/time", new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
            gpsEv.setTimestamp(fixtime);
        }
        if (!gpsEv.isValidGeoPoint()) {
            Print.logWarn("Invalid lat/lon: " + gpsEv.getLatitude() + "/" + gpsEv.getLongitude(), new Object[0]);
            gpsEv.setLatitude(0.0);
            gpsEv.setLongitude(0.0);
        }
        GeoPoint geoPoint = gpsEv.getGeoPoint();
        if (gpsEv.getSpeedKPH() < MINIMUM_SPEED_KPH) {
            gpsEv.setSpeedKPH(0.0);
            gpsEv.setHeading(0.0);
        }
        odomKM = (odomKM = 0.0) <= 0.0 ? (ESTIMATE_ODOMETER && geoPoint.isValid() ? this.gpsDevice.getNextOdometerKM(geoPoint) : this.gpsDevice.getLastOdometerKM()) : dev.adjustOdometerKM(odomKM);
        Print.logInfo("Odometer KM: " + odomKM, new Object[0]);
        gpsEv.setOdometerKM(odomKM);
        if (SIMEVENT_GEOZONES && geoPoint.isValid() && (zone = dev.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                gpsEv.insertEventData(z.getTimestamp(), z.getStatusCode(), z.getGeozone());
                Print.logInfo("Geozone    : " + z, new Object[0]);
            }
        }
        if (gpsEv.hasInputMask() && gpsEv.getInputMask() >= 0L) {
            long chgMask;
            long gpioInput = gpsEv.getInputMask();
            if (SIMEVENT_DIGITAL_INPUTS > 0L && (chgMask = (dev.getLastInputState() ^ gpioInput) & SIMEVENT_DIGITAL_INPUTS) != 0L) {
                for (int b = 0; b <= 15; ++b) {
                    long m = 1L << b;
                    if ((chgMask & m) == 0L) continue;
                    int inpCode = (gpioInput & m) != 0L ? InputStatusCodes_ON[b] : InputStatusCodes_OFF[b];
                    long inpTime = fixtime;
                    gpsEv.insertEventData(inpTime, inpCode);
                    Print.logInfo("GPIO : " + StatusCodes.GetDescription(inpCode, null), new Object[0]);
                }
            }
            dev.setLastInputState(gpioInput & 0xFFFFL);
        }
        gpsEv.insertEventData(fixtime, statusCode);
        gpsEv.updateDevice();
        return true;
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig(null);
        if (dcsc == null) {
            Print.logWarn("DCServer not found: " + Main.getServerName(), new Object[0]);
            return;
        }
        DATA_FORMAT_OPTION = dcsc.getIntProperty(Main.ARG_FORMAT, DATA_FORMAT_OPTION);
        MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
        ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
        SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
        SIMEVENT_DIGITAL_INPUTS = dcsc.getSimulateDigitalInputs(SIMEVENT_DIGITAL_INPUTS) & 0xFFFFL;
    }

    private static int _usage() {
        String cn = StringTools.className(TrackClientPacketHandler.class);
        Print.sysPrintln("Test/Load Device Communication Server", new Object[0]);
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  $JAVA_HOME/bin/java -classpath <classpath> %s {options}", cn);
        Print.sysPrintln("Options:", new Object[0]);
        Print.sysPrintln("  -insert=[true|false]    Insert parsed records into EventData", new Object[0]);
        Print.sysPrintln("  -format=[1|2]           Data format", new Object[0]);
        Print.sysPrintln("  -debug                  Parse internal sample/debug data (if any)", new Object[0]);
        Print.sysPrintln("  -parseFile=<file>       Parse data from specified file", new Object[0]);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int _main(boolean fromMain) {
        INSERT_EVENT = RTConfig.getBoolean(Main.ARG_INSERT, DFT_INSERT_EVENT);
        if (!INSERT_EVENT) {
            Print.sysPrintln("Warning: Data will NOT be inserted into the database", new Object[0]);
        }
        TrackClientPacketHandler tcph = new TrackClientPacketHandler();
        if (RTConfig.getBoolean(Main.ARG_DEBUG, false)) {
            String[] data = null;
            switch (DATA_FORMAT_OPTION) {
                case 1: {
                    data = new String[]{"123456789012345,2006/09/05,07:47:26,35.3640,-142.2958,27.0,224.8"};
                    break;
                }
                case 2: {
                    data = new String[]{"account/device/$GPRMC,025423.494,A,3709.0642,N,14207.8315,W,12.09,108.52,200505,,*2E", "/device/$GPRMC,025423.494,A,3709.0642,N,14207.8315,W,12.09,108.52,200505,,*2E"};
                    break;
                }
                case 3: {
                    data = new String[]{"2,123,1234567890,0,20101223,110819,1,2.1,39.1234,-142.1234,33,227,1800"};
                    break;
                }
                case 9: {
                    data = new String[]{"mid=123456789012345 lat=39.12345 lon=-142.12345 kph=123.0"};
                    break;
                }
                default: {
                    Print.sysPrintln("Unrecognized Data Format: %d", DATA_FORMAT_OPTION);
                    return TrackClientPacketHandler._usage();
                }
            }
            for (int i = 0; i < data.length; ++i) {
                tcph.getHandlePacket(data[i].getBytes());
            }
            return 0;
        }
        if (RTConfig.hasProperty(Main.ARG_PARSEFILE)) {
            File parseFile = RTConfig.getFile(Main.ARG_PARSEFILE, null);
            if (parseFile == null || !parseFile.isFile()) {
                Print.sysPrintln("Data source file not specified, or does not exist.", new Object[0]);
                return TrackClientPacketHandler._usage();
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(parseFile);
            }
            catch (IOException ioe) {
                Print.logException("Error openning input file: " + parseFile, ioe);
                return 2;
            }
            try {
                while (true) {
                    String data;
                    if (StringTools.isBlank(data = FileTools.readLine(fis))) {
                        continue;
                    }
                    tcph.getHandlePacket(data.getBytes());
                }
            }
            catch (EOFException eof) {
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("***** End-Of-File *****", new Object[0]);
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
            catch (IOException ioe) {
                try {
                    Print.logException("Error reaading input file: " + parseFile, ioe);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable th) {}
                }
            }
            return 0;
        }
        return TrackClientPacketHandler._usage();
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        TrackClientPacketHandler.configInit();
        System.exit(TrackClientPacketHandler._main(false));
    }

    static {
        INSERT_EVENT = DFT_INSERT_EVENT = true;
        MINIMUM_SPEED_KPH = 0.0;
        InputStatusCodes_ON = new int[]{62496, 62497, 62498, 62499, 62500, 62501, 62502, 62503, 62504, 62505, 62506, 62507, 62508, 62509, 62510, 62511};
        InputStatusCodes_OFF = new int[]{62528, 62529, 62530, 62531, 62532, 62533, 62534, 62535, 62536, 62537, 62538, 62539, 62540, 62541, 62542, 62543};
    }
}

