/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.gl100;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.TimeZone;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.servers.GPSEvent;
import org.opengts.servers.gl100.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static int DATA_FORMAT_OPTION = 1;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static long SIMEVENT_DIGITAL_INPUTS = 0L;
    private static boolean DFT_INSERT_EVENT;
    private static boolean INSERT_EVENT;
    public static double MINIMUM_SPEED_KPH;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    public static final double KNOTS_PER_KILOMETER = 0.5399568034557235;
    private static final TimeZone gmtTimezone;
    private String tipoData = "";
    private static final int[] InputStatusCodes_ON;
    private static final int[] InputStatusCodes_OFF;
    private String sessionID = null;
    private GPSEvent gpsEvent = null;
    private Device gpsDevice = null;
    private String lastModemID = null;
    private boolean terminate = false;
    private String ipAddress = null;
    private int clientPort = 0;
    public static final boolean USE_STANDARD_TCP_SESSION_ID = true;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.clientPort = this.getSessionInfo().getRemotePort();
        this.tipoData = this.isDuplex() ? "TCP" : "UDP";
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public String getSessionID() {
        if (!StringTools.isBlank(this.sessionID)) {
            return this.sessionID;
        }
        if (this.gpsDevice != null) {
            return TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        }
        if (this.gpsEvent != null) {
            return TrackClientPacketHandler.CreateTcpSessionID(this.gpsEvent.getDevice());
        }
        return null;
    }

    public static String GetTcpSessionID(Device dev) {
        return DCServerFactory.getTcpSessionID(dev);
    }

    public static String CreateTcpSessionID(Device dev) {
        return DCServerFactory.createTcpSessionID(dev);
    }

    private GPSEvent createGPSEvent(String modemID) {
        DCServerConfig dcserver = Main.getServerConfig(null);
        if (this.gpsDevice != null) {
            if (!(modemID.equals("*") || this.lastModemID != null && this.lastModemID.equals(modemID))) {
                Print.logError("New MobileID does not match previously loaded Device", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, this.gpsDevice);
        } else {
            if (StringTools.isBlank(modemID) || modemID.equals("*")) {
                Print.logWarn("ModemID not specified!", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, modemID);
            this.gpsDevice = this.gpsEvent.getDevice();
        }
        if (this.gpsDevice == null) {
            return null;
        }
        this.sessionID = TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        return this.gpsEvent;
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        return -1;
    }

    private void setTerminate() {
        this.terminate = true;
    }

    @Override
    public boolean getTerminateSession() {
        return this.terminate;
    }

    @Override
    public byte[] getInitialPacket() throws Exception {
        return null;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes != null && pktBytes.length > 0) {
            String s = StringTools.toStringValue(pktBytes).trim();
            byte[] rtn = null;
            if (s.startsWith("+RESP")) {
                Print.logInfo("------ Trama GL100 -----", new Object[0]);
                rtn = this.parseInsertRecordGL100(s);
            } else if (s.startsWith("$")) {
                Print.logInfo("------ Trama Raptor -----", new Object[0]);
                rtn = this.parseInsertRecordRaptor(s);
            } else if (s.startsWith(">")) {
                Print.logInfo("------ Trama Alave -----", new Object[0]);
                rtn = this.parseInsertRecordAlave(s);
            } else if (s.startsWith("link")) {
                Print.logInfo("MTC UPDATER: " + s, new Object[0]);
                rtn = this.parseInsertRecordUpdater(s);
            } else {
                Print.logInfo("No Conozco esta trama", new Object[0]);
            }
            return rtn;
        }
        Print.logInfo("...", new Object[0]);
        return null;
    }

    @Override
    public byte[] getFinalPacket(boolean hasError) throws Exception {
        return null;
    }

    private long _parsearFechas(String ymd, String hms) {
        String[] d = new String[]{ymd.substring(0, 4), ymd.substring(4, 6), ymd.substring(6, 8)};
        String[] t = new String[]{hms.substring(0, 2), hms.substring(2, 4), hms.substring(4, 6)};
        if (d.length != 3 && t.length != 3) {
            return 0L;
        }
        int YY = StringTools.parseInt(d[0], 0);
        int MM = StringTools.parseInt(d[1], 0);
        int DD = StringTools.parseInt(d[2], 0);
        int hh = StringTools.parseInt(t[0], 0);
        int mm = StringTools.parseInt(t[1], 0);
        int ss = StringTools.parseInt(t[2], 0);
        if (YY < 100) {
            YY += 2000;
        }
        DateTime dt = new DateTime(gmtTimezone, YY, MM, DD, hh, mm, ss);
        return dt.getTimeSec();
    }

    private long _parseDate7(String ymd, String hms) {
        String[] d = new String[]{ymd.substring(4, 6), ymd.substring(2, 4), ymd.substring(0, 2)};
        String[] t = new String[]{hms.substring(0, 2), hms.substring(2, 4), hms.substring(4, 6)};
        if (d.length != 3 && t.length != 3) {
            return 0L;
        }
        int YY = StringTools.parseInt(d[0], 0);
        int MM = StringTools.parseInt(d[1], 0);
        int DD = StringTools.parseInt(d[2], 0);
        int hh = StringTools.parseInt(t[0], 0);
        int mm = StringTools.parseInt(t[1], 0);
        int ss = StringTools.parseInt(t[2], 0);
        if (YY < 100) {
            YY += 2000;
        }
        DateTime dt = new DateTime(gmtTimezone, YY, MM, DD, hh, mm, ss);
        return dt.getTimeSec();
    }

    private double _buscaLatitud(String s, String d) {
        double _lat = StringTools.parseDouble(s, 99999.0);
        if (_lat < 99999.0) {
            double lat = (long)_lat / 100L;
            lat += (_lat - lat * 100.0) / 60.0;
            return d.equals("S") ? -lat : lat;
        }
        return 90.0;
    }

    private double _buscaLongitud(String s, String d) {
        double _lon = StringTools.parseDouble(s, 99999.0);
        if (_lon < 99999.0) {
            double lon = (long)_lon / 100L;
            lon += (_lon - lon * 100.0) / 60.0;
            return d.equals("W") ? -lon : lon;
        }
        return 180.0;
    }

    private byte[] parseInsertRecordRaptor(String s) {
        Print.logInfo("Raptor: " + s, new Object[0]);
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        String modemID = fld[0].toLowerCase().substring(1, fld[0].length());
        String dateRaptor = fld[2].toLowerCase();
        String timeRaptor = fld[3].toLowerCase();
        long fixtime = this._parseDate7(dateRaptor, timeRaptor);
        double latitudDec = this._buscaLatitud(fld[4].substring(0, fld[4].length() - 1), fld[4].substring(fld[4].length() - 1, fld[4].length()));
        double longitudDec = this._buscaLongitud(fld[5].substring(0, fld[5].length() - 1), fld[5].substring(fld[5].length() - 1, fld[5].length()));
        double latitude = StringTools.parseDouble(latitudDec, 0.0);
        double longitude = StringTools.parseDouble(longitudDec, 0.0);
        double speedKPH = StringTools.parseDouble(fld[6], 0.0);
        double heading = StringTools.parseDouble(fld[7], 0.0);
        double altitudeM = StringTools.parseDouble(fld[8], 0.0);
        String hex = fld[9];
        int statusCode = Integer.parseInt(hex, 16);
        if (latitude >= -1.0 || latitude <= -20.0 || longitude >= -68.0 || longitude <= -82.0) {
            System.out.println("Error en Posicion");
            return null;
        }
        String Sen1 = fld[10];
        String Door = fld[11];
        String Sen2 = fld[12];
        String Sal1 = fld[13];
        String Sal2 = fld[14];
        String entradas = Sen1 + Door + Sen2 + Sal1 + Sal2;
        long inputs = StringTools.parseLong(entradas, 0L);
        String Str_adc = fld[15].substring(0, fld[15].length() - 1);
        double adcValue = StringTools.parseDouble(Str_adc, 0.0);
        double fuelLevel = adcValue * 100.0 / 165.0;
        fuelLevel -= 100.0;
        fuelLevel = -fuelLevel;
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        Device device = this.gpsEvent.getDevice();
        if (device == null) {
            return null;
        }
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        System.out.println("Registro ---> [" + accountID + "/" + deviceID + "/" + uniqueID + "]");
        System.out.println("Evento: [" + new DateTime(fixtime) + "]");
        double maxSpeed = device.getSpeedLimitKPH();
        if (speedKPH > MINIMUM_SPEED_KPH && speedKPH < maxSpeed) {
            statusCode = device.getLastValidSpeed() <= MINIMUM_SPEED_KPH ? 61713 : 61714;
        } else if (speedKPH >= maxSpeed) {
            statusCode = 61722;
        } else if (speedKPH <= MINIMUM_SPEED_KPH) {
            statusCode = 61715;
        }
        speedKPH = this.gpsEvent.ajustaVelocidad(device.getDescription(), speedKPH);
        this.lastModemID = modemID;
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setBatteryLevel(100.0);
        this.gpsEvent.setAltitude(altitudeM);
        this.gpsEvent.setInputMask(inputs);
        this.gpsEvent.setFuelTotal(fuelLevel);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    private byte[] parseInsertRecordGL100(String s) {
        Print.logInfo("GL100: " + s, new Object[0]);
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        if (fld[0].contains("GTTRI") || fld[0].contains("GTRTL") || fld[0].contains("GTSZI")) {
            System.out.println("Reporte OK!");
        }
        String modemID = fld[1];
        String dateGL100 = fld[12].toLowerCase().substring(0, 8);
        String timeGL100 = fld[12].toLowerCase().substring(8, 14);
        long fixtime = this._parsearFechas(dateGL100, timeGL100);
        int statusCode = 61472;
        double latitude = StringTools.parseDouble(fld[11], 0.0);
        double longitude = StringTools.parseDouble(fld[10], 0.0);
        double speedKPH = StringTools.parseDouble(fld[6], 0.0);
        double heading = StringTools.parseDouble(fld[7], 0.0);
        double altitudeM = StringTools.parseDouble(fld[8], 0.0);
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        Device device = this.gpsEvent.getDevice();
        if (device == null) {
            return null;
        }
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        System.out.println("Registro ---> [" + accountID + "/" + deviceID + "/" + uniqueID + "]");
        System.out.println("Evento: [" + new DateTime(fixtime) + "]");
        double maxSpeed = device.getSpeedLimitKPH();
        if (speedKPH > MINIMUM_SPEED_KPH && speedKPH < maxSpeed) {
            statusCode = device.getLastValidSpeed() <= MINIMUM_SPEED_KPH ? 61713 : 61714;
        } else if (speedKPH >= maxSpeed) {
            statusCode = 61722;
        } else if (speedKPH <= MINIMUM_SPEED_KPH) {
            statusCode = 61715;
        }
        speedKPH = this.gpsEvent.ajustaVelocidad(device.getDescription(), speedKPH);
        this.lastModemID = modemID;
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setBatteryLevel(100.0);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    private byte[] parseInsertRecordAlave(String s) {
        Print.logInfo("Alave: " + s, new Object[0]);
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        String modemID = fld[0].substring(1);
        long fixtime = new DateTime(DateTime.getGMTTimeZone()).getTimeSec();
        if (fixtime - DateTime.MinuteSeconds(15L) > DateTime.getCurrentTimeSec()) {
            fixtime -= DateTime.DaySeconds(1L);
        }
        int statusCode = 61472;
        double latitude = 0.0;
        double longitude = 0.0;
        double speedKPH = 0.0;
        double heading = 0.0;
        double altitudeM = 0.0;
        String flag = fld[2];
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        Device device = this.gpsEvent.getDevice();
        if (device == null) {
            return null;
        }
        latitude = StringTools.parseDouble(device.getFixedLatitude(), 0.0);
        if (!GeoPoint.isValid(latitude, longitude = StringTools.parseDouble(device.getFixedLongitude(), 0.0))) {
            Print.logWarn("Invalid lat/lon: " + latitude + "/" + longitude, new Object[0]);
            latitude = 0.0;
            longitude = 0.0;
            speedKPH = 0.0;
        }
        if (flag.equalsIgnoreCase("0xF847")) {
            statusCode = 63617;
        } else if (flag.equalsIgnoreCase("FD13")) {
            statusCode = 64787;
        } else if (flag.equalsIgnoreCase("FD15")) {
            statusCode = 64789;
        }
        speedKPH = this.gpsEvent.ajustaVelocidad(device.getDescription(), speedKPH);
        this.lastModemID = modemID;
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        System.out.println("Registro ---> [" + accountID + "/" + deviceID + "/" + uniqueID + "]");
        System.out.println("Evento: [" + new DateTime(fixtime) + "]");
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setBatteryLevel(100.0);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    private byte[] parseInsertRecordUpdater(String s) {
        System.out.println("MTC Updater");
        System.out.println("---------------------------------");
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        String modemID = fld[1].trim();
        long fixtime = new DateTime(DateTime.getGMTTimeZone()).getTimeSec();
        if (fixtime - DateTime.MinuteSeconds(15L) > DateTime.getCurrentTimeSec()) {
            fixtime -= DateTime.DaySeconds(1L);
        }
        int statusCode = 61477;
        double latitude = 0.0;
        double longitude = 0.0;
        double speedKPH = 0.0;
        double heading = 0.0;
        double altitudeM = 0.0;
        latitude = StringTools.parseDouble(fld[2], 0.0);
        longitude = StringTools.parseDouble(fld[3], 0.0);
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        Device device = this.gpsEvent.getDevice();
        if (device == null) {
            return null;
        }
        if (!GeoPoint.isValid(latitude, longitude)) {
            Print.logWarn("Invalid lat/lon: " + latitude + "/" + longitude, new Object[0]);
            latitude = 0.0;
            longitude = 0.0;
            speedKPH = 0.0;
            return null;
        }
        speedKPH = this.gpsEvent.ajustaVelocidad(device.getDescription(), speedKPH);
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        System.out.println("Registro ---> [" + accountID + "/" + deviceID + "/" + uniqueID + "]");
        System.out.println("Evento: [" + new DateTime(fixtime) + "]");
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setBatteryLevel(100.0);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    private boolean parseInsertRecord_Common(GPSEvent gpsEv) {
        List<Device.GeozoneTransition> zone;
        double odomKM;
        long fixtime = gpsEv.getTimestamp();
        int statusCode = gpsEv.getStatusCode();
        Device dev = gpsEv.getDevice();
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date/time", new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
            gpsEv.setTimestamp(fixtime);
            return false;
        }
        if (!gpsEv.isValidGeoPoint()) {
            Print.logWarn("Invalid lat/lon: " + gpsEv.getLatitude() + "/" + gpsEv.getLongitude(), new Object[0]);
            gpsEv.setLatitude(0.0);
            gpsEv.setLongitude(0.0);
            return false;
        }
        GeoPoint geoPoint = gpsEv.getGeoPoint();
        if (gpsEv.getSpeedKPH() < MINIMUM_SPEED_KPH) {
            gpsEv.setSpeedKPH(0.0);
            gpsEv.setHeading(0.0);
        }
        odomKM = (odomKM = 0.0) <= 0.0 ? (ESTIMATE_ODOMETER && geoPoint.isValid() ? this.gpsDevice.getNextOdometerKM(geoPoint) : this.gpsDevice.getLastOdometerKM()) : dev.adjustOdometerKM(odomKM);
        Print.logInfo("Odometer KM: " + odomKM, new Object[0]);
        gpsEv.setOdometerKM(odomKM);
        if (SIMEVENT_GEOZONES && geoPoint.isValid() && (zone = dev.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                gpsEv.insertEventData(z.getTimestamp(), z.getStatusCode(), z.getGeozone());
                Print.logInfo("Geozone    : " + z, new Object[0]);
            }
        }
        if (gpsEv.hasInputMask() && gpsEv.getInputMask() >= 0L) {
            long chgMask;
            long gpioInput = gpsEv.getInputMask();
            if (SIMEVENT_DIGITAL_INPUTS > 0L && (chgMask = (dev.getLastInputState() ^ gpioInput) & SIMEVENT_DIGITAL_INPUTS) != 0L) {
                for (int b = 0; b <= 15; ++b) {
                    long m = 1L << b;
                    if ((chgMask & m) == 0L) continue;
                    int inpCode = (gpioInput & m) != 0L ? InputStatusCodes_ON[b] : InputStatusCodes_OFF[b];
                    long inpTime = fixtime;
                    gpsEv.insertEventData(inpTime, inpCode);
                    Print.logInfo("GPIO : " + StatusCodes.GetDescription(inpCode, null), new Object[0]);
                }
            }
            dev.setLastInputState(gpioInput & 0xFFFFL);
        }
        gpsEv.insertEventData(fixtime, statusCode);
        gpsEv.updateDevice();
        return true;
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig(null);
        if (dcsc == null) {
            Print.logWarn("DCServer not found: " + Main.getServerName(), new Object[0]);
            return;
        }
        DATA_FORMAT_OPTION = dcsc.getIntProperty(Main.ARG_FORMAT, DATA_FORMAT_OPTION);
        MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
        ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
        SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
        SIMEVENT_DIGITAL_INPUTS = dcsc.getSimulateDigitalInputs(SIMEVENT_DIGITAL_INPUTS) & 0xFFFFL;
    }

    private static int _usage() {
        String cn = StringTools.className(TrackClientPacketHandler.class);
        Print.sysPrintln("Test/Load Device Communication Server", new Object[0]);
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  $JAVA_HOME/bin/java -classpath <classpath> %s {options}", cn);
        Print.sysPrintln("Options:", new Object[0]);
        Print.sysPrintln("  -insert=[true|false]    Insert parsed records into EventData", new Object[0]);
        Print.sysPrintln("  -format=[1|2]           Data format", new Object[0]);
        Print.sysPrintln("  -debug                  Parse internal sample/debug data (if any)", new Object[0]);
        Print.sysPrintln("  -parseFile=<file>       Parse data from specified file", new Object[0]);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int _main(boolean fromMain) {
        INSERT_EVENT = RTConfig.getBoolean(Main.ARG_INSERT, DFT_INSERT_EVENT);
        if (!INSERT_EVENT) {
            Print.sysPrintln("Warning: Data will NOT be inserted into the database", new Object[0]);
        }
        TrackClientPacketHandler tcph = new TrackClientPacketHandler();
        if (RTConfig.getBoolean(Main.ARG_DEBUG, false)) {
            String[] data = null;
            switch (DATA_FORMAT_OPTION) {
                case 1: {
                    data = new String[]{"123456789012345,2006/09/05,07:47:26,35.3640,-142.2958,27.0,224.8"};
                    break;
                }
                case 2: {
                    data = new String[]{"account/device/$GPRMC,025423.494,A,3709.0642,N,14207.8315,W,12.09,108.52,200505,,*2E", "/device/$GPRMC,025423.494,A,3709.0642,N,14207.8315,W,12.09,108.52,200505,,*2E"};
                    break;
                }
                case 3: {
                    data = new String[]{"2,123,1234567890,0,20101223,110819,1,2.1,39.1234,-142.1234,33,227,1800"};
                    break;
                }
                case 9: {
                    data = new String[]{"mid=123456789012345 lat=39.12345 lon=-142.12345 kph=123.0"};
                    break;
                }
                default: {
                    Print.sysPrintln("Unrecognized Data Format: %d", DATA_FORMAT_OPTION);
                    return TrackClientPacketHandler._usage();
                }
            }
            for (int i = 0; i < data.length; ++i) {
                tcph.getHandlePacket(data[i].getBytes());
            }
            return 0;
        }
        if (RTConfig.hasProperty(Main.ARG_PARSEFILE)) {
            File parseFile = RTConfig.getFile(Main.ARG_PARSEFILE, null);
            if (parseFile == null || !parseFile.isFile()) {
                Print.sysPrintln("Data source file not specified, or does not exist.", new Object[0]);
                return TrackClientPacketHandler._usage();
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(parseFile);
            }
            catch (IOException ioe) {
                Print.logException("Error openning input file: " + parseFile, ioe);
                return 2;
            }
            try {
                while (true) {
                    String data;
                    if (StringTools.isBlank(data = FileTools.readLine(fis))) {
                        continue;
                    }
                    tcph.getHandlePacket(data.getBytes());
                }
            }
            catch (EOFException eof) {
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("***** End-Of-File *****", new Object[0]);
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
            catch (IOException ioe) {
                try {
                    Print.logException("Error reaading input file: " + parseFile, ioe);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable th) {}
                }
            }
            return 0;
        }
        return TrackClientPacketHandler._usage();
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        TrackClientPacketHandler.configInit();
        System.exit(TrackClientPacketHandler._main(false));
    }

    static {
        INSERT_EVENT = DFT_INSERT_EVENT = true;
        MINIMUM_SPEED_KPH = 0.0;
        gmtTimezone = DateTime.getGMTTimeZone();
        InputStatusCodes_ON = new int[]{62496, 62497, 62498, 62499, 62500, 62501, 62502, 62503, 62504, 62505, 62506, 62507, 62508, 62509, 62510, 62511};
        InputStatusCodes_OFF = new int[]{62528, 62529, 62530, 62531, 62532, 62533, 62534, 62535, 62536, 62537, 62538, 62539, 62540, 62541, 62542, 62543};
    }
}

