/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class ValidateConnection {
    private static final int BITS_PER_MINUTE = 2;
    private static final byte BITS_PER_MINUTE_MASK = 3;
    private static final int BITS_PER_UNIT_ADDR = 3;
    private static final int BITS_PER_UNIT = 8;
    private static final int BITS_PER_UNIT_MASK = 7;
    private static final int BYTES_PER_UNIT = 1;
    private static final int MINUTES_PER_UNIT = 4;
    private int minuteRange = 120;
    private int byteLength = 0;
    private byte padMask = 0;

    public ValidateConnection(int minuteRange) {
        this.minuteRange = minuteRange >= 0 ? minuteRange : 0;
        this.byteLength = (this.minuteRange * 2 + 8 - 1) / 8;
        int pad = this.byteLength * 4 - minuteRange;
        this.padMask = pad > 0 ? (byte)((1 << (4 - pad) * 2) - 1) : (byte)(this.minuteRange > 0 ? -1 : 0);
    }

    public int getByteLength() {
        return this.byteLength;
    }

    private byte[] _adjustProfileMask(byte[] profileMask) {
        if (profileMask == null || profileMask.length != this.byteLength) {
            byte[] b = new byte[this.byteLength];
            if (profileMask != null && profileMask.length != 0) {
                if (profileMask.length <= this.byteLength) {
                    int ofs = this.byteLength - profileMask.length;
                    System.arraycopy(profileMask, 0, b, ofs, profileMask.length);
                } else {
                    int ofs = profileMask.length - this.byteLength;
                    System.arraycopy(profileMask, ofs, b, 0, this.byteLength);
                }
            }
            profileMask = b;
        }
        return profileMask;
    }

    public byte[] markConnection(int maxConnections, int maxPerMinute, byte[] profileMask, long shiftSec) {
        int count;
        long shiftMin = shiftSec / 60L;
        if ((profileMask = this.shiftMinutes(shiftMin, profileMask)).length == 0) {
            return profileMask;
        }
        if (maxConnections > 0 && (count = this.countConnections(profileMask)) + 1 > maxConnections) {
            Print.logError((String)"Exceeded maximum allowable connections", (Object[])new Object[0]);
            return null;
        }
        int ndx = profileMask.length - 1;
        byte val = (byte)(profileMask[ndx] & 3);
        if (maxPerMinute <= 0 || maxPerMinute > 3) {
            maxPerMinute = 3;
        }
        if (val < 3 && val < maxPerMinute) {
            val = (byte)(val + 1);
            profileMask[ndx] = (byte)(profileMask[ndx] & 0xFFFFFFFC | val & 3);
            return profileMask;
        }
        Print.logError((String)"Exceeded the per-minute maximum", (Object[])new Object[0]);
        return null;
    }

    private int countConnections(byte[] mask) {
        int count = 0;
        if (mask != null && mask.length > 0) {
            if (mask.length < this.byteLength) {
                Print.logStackTrace((String)("Invalid mask length: " + mask.length + " [" + this.byteLength));
            }
            int ofs = mask.length <= this.byteLength ? 0 : mask.length - this.byteLength;
            int len = mask.length <= this.byteLength ? mask.length : this.byteLength;
            for (int i = 0; i < len; ++i) {
                for (long n = (long)mask[i + ofs] & 0xFFL; n != 0L; n >>>= 2) {
                    count += (int)(n & 3L) & 0xFF;
                }
            }
        }
        return count;
    }

    private byte[] shiftMinutes(long minutes, byte[] mask) {
        mask = this._adjustProfileMask(mask);
        long n = minutes * 2L;
        if (n <= 0L) {
            return mask;
        }
        int ofs = mask.length - this.byteLength;
        long nUnits = n >>> 3;
        byte[] newMask = new byte[this.byteLength];
        if (nUnits >= (long)newMask.length) {
            return newMask;
        }
        int nBits = (int)n & 7;
        if (nBits == 0) {
            for (int i = 0; i < newMask.length - (int)nUnits; ++i) {
                int fromNdx = i + (int)nUnits + ofs;
                newMask[i] = mask[fromNdx];
            }
        } else {
            int fromNdx;
            int i;
            int nBits2 = 8 - nBits;
            for (i = 0; i < newMask.length - (int)nUnits - 1; ++i) {
                fromNdx = i + (int)nUnits + ofs;
                newMask[i] = (byte)(mask[fromNdx] << nBits | mask[fromNdx + 1] >>> nBits2);
            }
            fromNdx = i + (int)nUnits + ofs;
            newMask[i] = (byte)(mask[fromNdx] << nBits);
            newMask[0] = (byte)(newMask[0] & this.padMask);
        }
        return newMask;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        ValidateConnection a = new ValidateConnection(120);
        byte[] b = new byte[a.getByteLength()];
        a.markConnection(9, -1, b, 0L);
        a.markConnection(9, -1, b, 0L);
        for (int i = 0; i < 120; ++i) {
            byte[] x = a.markConnection(5, -1, b, 60L);
            Print.logInfo((String)("Mask: " + StringTools.toHexString((byte[])x)), (Object[])new Object[0]);
        }
    }
}

