/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import org.opendmtp.server.base.AccountID;
import org.opendmtp.server.base.DMTPServer;
import org.opendmtp.server.base.Event;
import org.opendmtp.server.base.Packet;
import org.opendmtp.server.base.PacketList;
import org.opendmtp.server.base.PacketParseException;
import org.opendmtp.server.base.UniqueID;
import org.opendmtp.server.base.ValidateConnection;
import org.opendmtp.server.db.AccountDB;
import org.opendmtp.server.db.DeviceDB;
import org.opendmtp.server.db.PayloadTemplate;
import org.opengts.util.DateTime;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DeviceID {
    private DeviceDB db = null;
    private AccountID accountId = null;
    private ValidateConnection connectionValidator = null;

    private static DeviceDB GetDeviceDB(UniqueID uniqId) throws PacketParseException {
        DMTPServer.DBFactory fact = DMTPServer.getDBFactory();
        if (fact != null) {
            byte[] id = uniqId.getId();
            DeviceDB db = fact.getDeviceDB(id);
            if (db != null) {
                return db;
            }
            Print.logError((String)("Device not found: UniqueID " + StringTools.toHexString((byte[])id)), (Object[])new Object[0]);
        }
        return null;
    }

    private static DeviceDB GetDeviceDB(AccountDB acctDB, String devName) throws PacketParseException {
        DMTPServer.DBFactory fact = DMTPServer.getDBFactory();
        if (fact != null) {
            DeviceDB db = fact.getDeviceDB(acctDB, devName);
            if (db != null) {
                return db;
            }
            String acctName = acctDB != null ? acctDB.getAccountName() : "null";
            Print.logError((String)("Device not found: Acct/Dev " + acctName + "/" + devName), (Object[])new Object[0]);
        }
        return null;
    }

    public static DeviceID loadDeviceID(UniqueID uniqId) throws PacketParseException {
        return new DeviceID(uniqId);
    }

    public static DeviceID loadDeviceID(AccountID acctId, String devName) throws PacketParseException {
        return new DeviceID(acctId, devName);
    }

    private DeviceID(UniqueID uniqId) throws PacketParseException {
        if (uniqId == null || !uniqId.isValid()) {
            Print.logError((String)("UniqueID is invalid: " + uniqId), (Object[])new Object[0]);
            throw new PacketParseException(61457, null);
        }
        this.db = DeviceID.GetDeviceDB(uniqId);
        if (this.db == null) {
            Print.logError((String)("UniqueID not found: " + uniqId), (Object[])new Object[0]);
            throw new PacketParseException(61457, null);
        }
        this.accountId = AccountID.loadAccountID(this.db.getAccountName());
        Print.logInfo((String)("[" + new DateTime() + "] Loaded device: " + this.db.getAccountName() + "/" + this.db.getDeviceName()), (Object[])new Object[0]);
    }

    private DeviceID(AccountID acctId, String devName) throws PacketParseException {
        if (devName == null || devName.equals("")) {
            Print.logError((String)"Device name is null/empty", (Object[])new Object[0]);
            throw new PacketParseException(61489, null);
        }
        if (acctId == null) {
            Print.logError((String)"AccountID is null", (Object[])new Object[0]);
            throw new PacketParseException(61473, null);
        }
        AccountDB acctDB = acctId.getAccountDB();
        this.db = DeviceID.GetDeviceDB(acctDB, devName);
        if (this.db == null) {
            String acctName = acctId.getAccountName();
            Print.logError((String)("Device not found: " + acctName + "/" + devName), (Object[])new Object[0]);
            throw new PacketParseException(61489, null);
        }
        this.accountId = acctId;
        Print.logInfo((String)("[" + new DateTime() + "] Loaded device: " + this.db.getAccountName() + "/" + this.db.getDeviceName()), (Object[])new Object[0]);
    }

    public AccountID getAccountID() {
        return this.accountId;
    }

    public DeviceDB getDeviceDB() {
        return this.db;
    }

    public String getAccountName() {
        return this.db.getAccountName();
    }

    public String getDeviceName() {
        return this.db.getDeviceName();
    }

    public boolean isActive() {
        return this.db.isActive();
    }

    public boolean isValidIpAddress(String ipAddr) {
        return this.db.isValidIpAddress(ipAddr);
    }

    public ValidateConnection getConnectionValidator() {
        if (this.connectionValidator == null) {
            this.connectionValidator = new ValidateConnection(this.db.getLimitTimeIntervalMinutes());
        }
        return this.connectionValidator;
    }

    public boolean markAndValidateConnection(boolean isDuplex) {
        long nowTime = DateTime.getCurrentTimeSec();
        byte[] totalConn = this.getConnectionValidator().markConnection(this.db.getMaxTotalConnections(), this.db.getMaxTotalConnectionsPerMinute(), this.db.getTotalConnectionProfile(), nowTime - this.db.getLastTotalConnectionTime());
        if (totalConn == null) {
            Print.logError((String)"Exceeded total allowable conections", (Object[])new Object[0]);
            return false;
        }
        this.db.setTotalConnectionProfile(totalConn);
        this.db.setLastTotalConnectionTime(nowTime);
        if (isDuplex) {
            byte[] duplexConn = this.getConnectionValidator().markConnection(this.db.getMaxDuplexConnections(), this.db.getMaxDuplexConnectionsPerMinute(), this.db.getDuplexConnectionProfile(), nowTime - this.db.getLastDuplexConnectionTime());
            if (duplexConn == null) {
                Print.logError((String)"Exceeded allowable duplex conections", (Object[])new Object[0]);
                return false;
            }
            this.db.setDuplexConnectionProfile(duplexConn);
            this.db.setLastDuplexConnectionTime(nowTime);
        }
        return true;
    }

    public boolean supportsEncoding(int encoding) {
        return this.db.supportsEncoding(encoding);
    }

    public void removeEncoding(int encoding) {
        this.db.removeEncoding(encoding);
    }

    public boolean addClientPayloadTemplate(PayloadTemplate template) {
        return this.db.addClientPayloadTemplate(template);
    }

    public PayloadTemplate getClientPayloadTemplate(int custType) {
        return this.db.getClientPayloadTemplate(custType);
    }

    public int saveEvent(Event event) {
        Packet packet = event.getPacket();
        long timeEnd = DateTime.getCurrentTimeSec();
        long timeStart = timeEnd - DateTime.MinuteSeconds((long)this.db.getLimitTimeIntervalMinutes());
        if (this.db.getMaxAllowedEvents() > 0 && this.db.getEventCount(timeStart, timeEnd) >= (long)this.db.getMaxAllowedEvents()) {
            Print.logError((String)"Excessive events", (Object[])new Object[0]);
            return 62513;
        }
        int err = this.db.insertEvent(event.getGeoEvent());
        return err;
    }

    public void saveSessionStatistics(long startTime, String ipAddr, boolean isDuplex, long bytesRead, long bytesWritten, long evtsRecv) {
        this.db.sessionStatistics(startTime, ipAddr, isDuplex, bytesRead, bytesWritten, evtsRecv);
    }

    public PacketList getPendingPackets() {
        return this.db.getPendingPackets();
    }

    public void clearPendingPackets(PacketList pktList) {
        this.db.clearPendingPackets(pktList);
    }

    public int saveChanges() throws PacketParseException {
        return this.db.saveChanges();
    }

    public void handleError(int errCode, byte[] errData) {
        this.db.handleError(errCode, errData);
    }

    public void handleDiagnostic(int diagCode, byte[] diagData) {
        this.db.handleDiagnostic(diagCode, diagData);
    }

    public void handleProperty(int propKey, byte[] propVal) {
        this.db.handleProperty(propKey, propVal);
    }

    public String toString() {
        return this.db != null ? this.db.toString() : "";
    }
}

