/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import java.net.DatagramSocket;
import org.opendmtp.server.base.DMTPClientPacketHandler;
import org.opendmtp.server.db.AccountDB;
import org.opendmtp.server.db.DeviceDB;
import org.opengts.util.Print;
import org.opengts.util.ServerSocketThread;

public class DMTPServer {
    public static final int MAX_PORTS = 4;
    private static DMTPServer trackTcpInstance = null;
    private static boolean allowFirstSessionNegotiation = true;
    private static long tcpTimeout_idle = 10000L;
    private static long tcpTimeout_packet = 4000L;
    private static long tcpTimeout_session = 15000L;
    private static long udpTimeout_idle = 5000L;
    private static long udpTimeout_packet = 4000L;
    private static long udpTimeout_session = 60000L;
    private static DBFactory dbFactory = null;
    private ServerSocketThread[] tcpThread = new ServerSocketThread[4];
    private int tcpCount = 0;
    private ServerSocketThread[] udpThread = new ServerSocketThread[4];
    private int udpCount = 0;

    public static DMTPServer createTrackSocketHandler(int port) throws Throwable {
        return DMTPServer.createTrackSocketHandler(new int[]{port});
    }

    public static DMTPServer createTrackSocketHandler(int[] port) throws Throwable {
        if (trackTcpInstance == null) {
            trackTcpInstance = new DMTPServer(port);
        }
        return trackTcpInstance;
    }

    public static void setAllowFirstSessionNegotiation(boolean state) {
        allowFirstSessionNegotiation = state;
    }

    public static boolean getAllowFirstSessionNegotiation() {
        return allowFirstSessionNegotiation;
    }

    public static void setTcpIdleTimeout(long timeout) {
        tcpTimeout_idle = timeout;
    }

    public static long getTcpIdleTimeout() {
        return tcpTimeout_idle;
    }

    public static void setTcpPacketTimeout(long timeout) {
        tcpTimeout_packet = timeout;
    }

    public static long getTcpPacketTimeout() {
        return tcpTimeout_packet;
    }

    public static void setTcpSessionTimeout(long timeout) {
        tcpTimeout_session = timeout;
    }

    public static long getTcpSessionTimeout() {
        return tcpTimeout_session;
    }

    public static void setUdpIdleTimeout(long timeout) {
        udpTimeout_idle = timeout;
    }

    public static long getUdpIdleTimeout() {
        return udpTimeout_idle;
    }

    public static void setUdpPacketTimeout(long timeout) {
        udpTimeout_packet = timeout;
    }

    public static long getUdpPacketTimeout() {
        return udpTimeout_packet;
    }

    public static void setUdpSessionTimeout(long timeout) {
        udpTimeout_session = timeout;
    }

    public static long getUdpSessionTimeout() {
        return udpTimeout_session;
    }

    public static void shutdown() {
        if (trackTcpInstance != null) {
            try {
                int i;
                for (i = 0; i < DMTPServer.trackTcpInstance.tcpThread.length; ++i) {
                    if (DMTPServer.trackTcpInstance.tcpThread[i] == null) continue;
                    DMTPServer.trackTcpInstance.tcpThread[i].shutdown();
                }
                for (i = 0; i < DMTPServer.trackTcpInstance.udpThread.length; ++i) {
                    if (DMTPServer.trackTcpInstance.udpThread[i] == null) continue;
                    DMTPServer.trackTcpInstance.udpThread[i].shutdown();
                }
            }
            catch (Throwable e) {
                Print.logException((String)"Error shutting down server", (Throwable)e);
            }
            trackTcpInstance = null;
        }
    }

    public static void setDBFactory(DBFactory factory) {
        dbFactory = factory;
    }

    public static DBFactory getDBFactory() {
        return dbFactory;
    }

    private DMTPServer(int[] port) throws Throwable {
        if (port != null && port.length > 0) {
            for (int i = 0; i < port.length; ++i) {
                this.startPortListeners(port[i]);
            }
        } else {
            throw new Exception("No ports specified");
        }
    }

    private void startPortListeners(int port) throws Throwable {
        if (port <= 0 || port > 65535) {
            throw new Exception("Invalid port number: " + port);
        }
        this.startTCP(port);
        this.startUDP(port);
    }

    private void startTCP(int port) throws Throwable {
        ServerSocketThread sst = null;
        if (this.tcpCount >= this.tcpThread.length) {
            throw new Exception("Too many TCP connection listeners");
        }
        try {
            sst = new ServerSocketThread(port);
        }
        catch (Throwable t) {
            Print.logException((String)"ServerSocket error", (Throwable)t);
            throw t;
        }
        sst.setTextPackets(false);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(new int[]{13, 124});
        sst.setMaximumPacketLength(600);
        sst.setMinimumPacketLength(3);
        sst.setIdleTimeout(tcpTimeout_idle);
        sst.setPacketTimeout(tcpTimeout_packet);
        sst.setSessionTimeout(tcpTimeout_session);
        sst.setLingerTimeoutSec(5);
        sst.setTerminateOnTimeout(true);
        sst.setClientPacketHandlerClass(DMTPClientPacketHandler.class);
        Print.logInfo((String)("DMTP: Starting TCP listener thread on port " + port + " [timeout=" + sst.getSessionTimeout() + "ms] ..."), (Object[])new Object[0]);
        sst.start();
        this.tcpThread[this.tcpCount++] = sst;
    }

    private void startUDP(int port) throws Throwable {
        ServerSocketThread sst = null;
        if (this.udpCount >= this.udpThread.length) {
            throw new Exception("Too many UDP connection listeners");
        }
        try {
            sst = new ServerSocketThread(new DatagramSocket(port));
        }
        catch (Throwable t) {
            Print.logException((String)"ServerSocket error", (Throwable)t);
            throw t;
        }
        sst.setTextPackets(false);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(new int[]{13, 124});
        sst.setMaximumPacketLength(600);
        sst.setMinimumPacketLength(3);
        sst.setIdleTimeout(udpTimeout_idle);
        sst.setPacketTimeout(udpTimeout_packet);
        sst.setSessionTimeout(udpTimeout_session);
        sst.setTerminateOnTimeout(true);
        sst.setClientPacketHandlerClass(DMTPClientPacketHandler.class);
        Print.logInfo((String)("DMTP: Starting UDP listener thread on port " + port + " [timeout=" + sst.getSessionTimeout() + "ms] ..."), (Object[])new Object[0]);
        sst.start();
        this.udpThread[this.udpCount++] = sst;
    }

    public static interface DBFactory {
        public AccountDB getAccountDB(String var1);

        public DeviceDB getDeviceDB(AccountDB var1, String var2);

        public DeviceDB getDeviceDB(byte[] var1);
    }
}

