/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.util.Vector;
import org.opendmtp.codes.Encoding;
import org.opendmtp.codes.ServerErrors;
import org.opendmtp.server.base.AccountID;
import org.opendmtp.server.base.DMTPGeoEvent;
import org.opendmtp.server.base.DMTPServer;
import org.opendmtp.server.base.DeviceID;
import org.opendmtp.server.base.Event;
import org.opendmtp.server.base.Packet;
import org.opendmtp.server.base.PacketList;
import org.opendmtp.server.base.PacketParseException;
import org.opendmtp.server.base.UniqueID;
import org.opendmtp.server.db.PayloadTemplate;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.FletcherChecksum;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DMTPClientPacketHandler
extends AbstractClientPacketHandler {
    private static boolean SAVE_MARKED_CONNECTION_INFO = true;
    private static boolean UDP_RETURN_RESPONSE = false;
    private boolean terminate = false;
    private boolean isDuplex = true;
    private long sessionStartTime = 0L;
    private InetAddress inetAddress = null;
    private String ipAddress = null;
    private int encoding = -1;
    private FletcherChecksum fletcher = new FletcherChecksum();
    private AccountID accountId = null;
    private DeviceID deviceId = null;
    private int eventTotalCount = 0;
    private int eventBlockCount = 0;
    private Event lastValidEvent = null;
    private Packet eventErrorPacket = null;
    private int formatErrorCount = 0;
    private int formatErrorType = 0;
    private int formatRecvTemplate = 0;
    private boolean expectEventTemplate = false;
    private boolean sendPending = true;
    private PacketList pendingPackets = null;

    public static void setUdpReturnResponse(boolean state) {
        UDP_RETURN_RESPONSE = state;
    }

    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.sessionStartTime = DateTime.getCurrentTimeSec();
        this.inetAddress = inetAddr;
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.isDuplex = isTCP;
        this.eventTotalCount = 0;
        this.formatErrorCount = 0;
        this.formatErrorType = 0;
        if (this.isDuplex) {
            Print.logInfo((String)("Begin Duplex communication: " + this.ipAddress), (Object[])new Object[0]);
        } else {
            Print.logInfo((String)("Begin Simplex communication: " + this.ipAddress), (Object[])new Object[0]);
        }
    }

    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        boolean hasError;
        boolean bl = hasError = err != null;
        if (hasError) {
            if (this.pendingPackets != null) {
                Print.logWarn((String)"**** Session terminating with errors (PendingPackets remain intact)", (Object[])new Object[0]);
            } else {
                Print.logWarn((String)"Session terminating with errors", (Object[])new Object[0]);
            }
        } else {
            try {
                this._clearPendingPackets();
            }
            catch (PacketParseException ppe) {
                // empty catch block
            }
        }
        if (this.deviceId != null) {
            this.deviceId.saveSessionStatistics(this.sessionStartTime, this.ipAddress, this.isDuplex, readCount, writeCount, this.eventTotalCount);
        }
        if (this.isDuplex()) {
            Print.logInfo((String)("End Duplex communication: " + this.ipAddress), (Object[])new Object[0]);
            try {
                Thread.sleep(75L);
            }
            catch (Throwable t) {}
        } else {
            Print.logInfo((String)("End Simplex communication: " + this.ipAddress), (Object[])new Object[0]);
        }
    }

    public boolean isDuplex() {
        return this.isDuplex;
    }

    public int getActualPacketLength(byte[] packet, int packetLen) {
        if (packetLen >= 1 && packet[0] == 36) {
            return -1;
        }
        if (packetLen >= 3) {
            int payloadLen = packet[2] & 0xFF;
            return 3 + payloadLen;
        }
        return 0;
    }

    public byte[] getHandlePacket(byte[] pktBytes) {
        String ipAddr = this.getHostAddress();
        Packet[] resp = this._parsePacket(ipAddr, pktBytes);
        if (resp == null || resp.length == 0) {
            return null;
        }
        if (this.isDuplex()) {
            if (resp.length == 1) {
                Print.logDebug((String)("==> " + resp[0].toString(this.encoding)), (Object[])new Object[0]);
                return resp[0].encode(this.encoding);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int i = 0; i < resp.length; ++i) {
                Print.logDebug((String)("==> " + resp[i].toString(this.encoding)), (Object[])new Object[0]);
                byte[] b = resp[i].encode(this.encoding);
                baos.write(b, 0, b.length);
            }
            return baos.toByteArray();
        }
        if (!UDP_RETURN_RESPONSE) {
            Print.logError((String)"UDP Response discarded.", (Object[])new Object[0]);
            return null;
        }
        if (resp.length == 1) {
            Print.logDebug((String)("==> " + resp[0].toString(this.encoding)), (Object[])new Object[0]);
            return resp[0].encode(this.encoding);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < resp.length; ++i) {
            Print.logDebug((String)("==> " + resp[i].toString(this.encoding)), (Object[])new Object[0]);
            byte[] b = resp[i].encode(this.encoding);
            baos.write(b, 0, b.length);
        }
        return baos.toByteArray();
    }

    public boolean terminateSession() {
        return this.terminate;
    }

    private void _setTerminateSession() {
        this.terminate = true;
    }

    private void loadUniqueID(String ipAddr, byte[] id) throws PacketParseException {
        if (this.deviceId != null) {
            Print.logError((String)"Device ID already defined", (Object[])new Object[0]);
            throw new PacketParseException(62226, null);
        }
        UniqueID uniqId = new UniqueID(id);
        if (!uniqId.isValid()) {
            throw new PacketParseException(61457, null);
        }
        DeviceID devId = DeviceID.loadDeviceID(uniqId);
        this._setAccountId(ipAddr, devId.getAccountID());
        this._setDeviceId(ipAddr, devId);
    }

    private void loadAccountId(String ipAddr, String acctName) throws PacketParseException {
        if (this.accountId != null) {
            Print.logError((String)"Account ID already defined", (Object[])new Object[0]);
            throw new PacketParseException(62226, null);
        }
        if (acctName == null || acctName.equals("")) {
            Print.logError((String)"Account name is null/empty", (Object[])new Object[0]);
            throw new PacketParseException(61473, null);
        }
        AccountID acctId = AccountID.loadAccountID(acctName.toLowerCase());
        this._setAccountId(ipAddr, acctId);
    }

    private void _setAccountId(String ipAddr, AccountID acctId) throws PacketParseException {
        if (acctId == null) {
            throw new PacketParseException(61473, null);
        }
        if (!acctId.isActive()) {
            throw new PacketParseException(61474, null);
        }
        this.accountId = acctId;
    }

    private AccountID getAccountId() throws PacketParseException {
        if (this.accountId == null) {
            PacketParseException ppe = new PacketParseException(61473, null);
            ppe.setTerminate();
            throw ppe;
        }
        return this.accountId;
    }

    private void loadDeviceId(String ipAddr, String devName) throws PacketParseException {
        if (this.deviceId != null) {
            Print.logError((String)"Device ID already defined", (Object[])new Object[0]);
            throw new PacketParseException(62226, null);
        }
        if (devName == null || devName.equals("")) {
            Print.logError((String)"Device name is null/empty", (Object[])new Object[0]);
            throw new PacketParseException(61489, null);
        }
        DeviceID devId = DeviceID.loadDeviceID(this.getAccountId(), devName.toLowerCase());
        this._setDeviceId(ipAddr, devId);
    }

    private void _setDeviceId(String ipAddr, DeviceID devId) throws PacketParseException {
        int servErr;
        if (devId == null) {
            Print.logError((String)"Device ID is null", (Object[])new Object[0]);
            throw new PacketParseException(61489, null);
        }
        if (!devId.isValidIpAddress(ipAddr)) {
            Print.logError((String)("Invalid IP address: " + ipAddr), (Object[])new Object[0]);
            throw new PacketParseException(61491, null);
        }
        if (!devId.isActive()) {
            Print.logError((String)("Device is inactive: " + devId.getDeviceName()), (Object[])new Object[0]);
            throw new PacketParseException(61490, null);
        }
        if (!devId.markAndValidateConnection(this.isDuplex())) {
            Print.logError((String)("Excessive connections: " + devId.getDeviceName()), (Object[])new Object[0]);
            throw new PacketParseException(61505, null);
        }
        if (SAVE_MARKED_CONNECTION_INFO && (servErr = devId.saveChanges()) != 0) {
            throw new PacketParseException(servErr, null);
        }
        this.deviceId = devId;
    }

    private DeviceID getDeviceId() throws PacketParseException {
        if (this.deviceId == null) {
            PacketParseException ppe = new PacketParseException(61489, null);
            ppe.setTerminate();
            throw ppe;
        }
        return this.deviceId;
    }

    private Packet[] _handleError(Packet packet) throws PacketParseException {
        Payload payload = packet.getPayload(true);
        int errCode = (int)payload.readULong(2, 0L);
        switch (errCode) {
            case 61713: 
            case 61714: 
            case 61715: {
                return null;
            }
            case 61716: {
                this.getDeviceId().removeEncoding(this.encoding);
                if (Encoding.IsEncodingAscii(this.encoding)) {
                    this.encoding = Encoding.IsEncodingChecksum(this.encoding) ? 11 : 10;
                }
                return null;
            }
            case 61717: {
                return null;
            }
            case 61718: {
                return null;
            }
            case 61719: {
                return null;
            }
            case 61729: {
                return null;
            }
            case 61953: {
                return null;
            }
            case 61954: {
                return null;
            }
            case 61969: {
                return null;
            }
            case 61970: {
                return null;
            }
            case 61971: {
                return null;
            }
            case 62225: 
            case 62241: {
                return null;
            }
            case 62465: 
            case 62481: 
            case 62482: 
            case 62483: 
            case 62484: 
            case 62497: 
            case 62513: 
            case 62529: {
                return null;
            }
            case 63761: 
            case 63762: {
                return null;
            }
        }
        return null;
    }

    private int _handleEvent(Event event) throws PacketParseException {
        DeviceID devId = this.getDeviceId();
        if (Print.isDebugLoggingLevel()) {
            DMTPGeoEvent gev = event.getGeoEvent();
            StringBuffer sb = new StringBuffer();
            sb.append("\n");
            sb.append(devId.getAccountName()).append("/").append(devId.getDeviceName());
            sb.append(" ");
            sb.append(event.toString());
            Print.logDebug((String)sb.toString(), (Object[])new Object[0]);
        }
        return devId.saveEvent(event);
    }

    private void _clearPendingPackets() throws PacketParseException {
        if (this.pendingPackets != null) {
            Print.logInfo((String)"Deleting sent PendingPackets ...", (Object[])new Object[0]);
            this.getDeviceId().clearPendingPackets(this.pendingPackets);
            this.pendingPackets = null;
        }
    }

    private Packet[] _handlePacket(String ipAddr, Packet packet) throws PacketParseException {
        if (!packet.isIdentType()) {
            this.getDeviceId();
        }
        if (packet.isEventType()) {
            Event evData = null;
            evData = new Event(ipAddr, packet);
            ++this.eventTotalCount;
            ++this.eventBlockCount;
            if (this.eventErrorPacket == null) {
                int err = this._handleEvent(evData);
                if (err == 0) {
                    this.lastValidEvent = evData;
                } else if (err == 62514) {
                    this.lastValidEvent = evData;
                } else {
                    Print.logError((String)("Event insertion [" + StringTools.toHexString((long)err, (int)16) + "] " + ServerErrors.getErrorDescription(err)), (Object[])new Object[0]);
                    long seq = evData.getSequence();
                    int seqLen = evData.getSequenceLength();
                    PacketParseException ppe = null;
                    if (seq >= 0L && seqLen > 0) {
                        Payload p = new Payload();
                        p.writeULong(seq, seqLen);
                        byte[] errData = p.getBytes();
                        ppe = new PacketParseException(err, packet, errData);
                    } else {
                        ppe = new PacketParseException(err, packet);
                    }
                    this.eventErrorPacket = ppe.createServerErrorPacket();
                }
            }
            return null;
        }
        Payload payload = packet.getPayload(true);
        switch (packet.getPacketType()) {
            case 0: 
            case 1: {
                boolean clientHasMore = packet.getPacketType() == 1;
                Vector<Packet> resp = new Vector<Packet>();
                if (this.encoding == 0 && packet.getPayloadLength() != 0) {
                    if (packet.getPayloadLength() == 2) {
                        if (!this.fletcher.isValid()) {
                            Print.logError((String)"Fletcher checksum is INVALID!!", (Object[])new Object[0]);
                            throw new PacketParseException(62225, packet);
                        }
                    } else {
                        throw new PacketParseException(61716, packet);
                    }
                }
                this.fletcher.reset();
                if (this.lastValidEvent != null) {
                    Packet ackPkt = Packet.createServerPacket(160);
                    int seqLen = this.lastValidEvent.getSequenceLength();
                    if (seqLen > 0) {
                        long seq = this.lastValidEvent.getSequence();
                        ackPkt.getPayload(true).writeLong(seq, seqLen);
                    }
                    resp.add(ackPkt);
                    this.eventBlockCount = 0;
                    this.lastValidEvent = null;
                }
                if (this.eventErrorPacket != null) {
                    resp.add(this.eventErrorPacket);
                    this.eventErrorPacket = null;
                }
                this._clearPendingPackets();
                boolean serverSentPending = false;
                if (this.sendPending) {
                    this.pendingPackets = this.getDeviceId().getPendingPackets();
                    if (this.pendingPackets != null) {
                        Object[] p = this.pendingPackets.getPackets();
                        Print.logInfo((String)("Adding PendingPacket's to response [cnt=" + p.length + "]"), (Object[])new Object[0]);
                        ListTools.toList((Object[])p, resp);
                        serverSentPending = true;
                    }
                }
                if (clientHasMore || serverSentPending || this.expectEventTemplate) {
                    Packet eobPkt = Packet.createServerPacket(0);
                    resp.add(eobPkt);
                    if (this.expectEventTemplate) {
                        this.expectEventTemplate = false;
                    }
                } else {
                    Packet eotPkt = Packet.createServerPacket(255);
                    resp.add(eotPkt);
                    this._setTerminateSession();
                }
                return (Packet[])ListTools.toArray(resp, Packet.class);
            }
            case 17: {
                try {
                    int len = payload.getAvailableReadLength();
                    int maxLen = len <= 20 ? len : 20;
                    byte[] uniqId = payload.readBytes(maxLen);
                    this.loadUniqueID(ipAddr, uniqId);
                    break;
                }
                catch (PacketParseException ppe) {
                    ppe.setTerminate();
                    throw ppe;
                }
            }
            case 18: {
                try {
                    String acctName = payload.readString(20);
                    this.loadAccountId(ipAddr, acctName);
                    break;
                }
                catch (PacketParseException ppe) {
                    ppe.setTerminate();
                    throw ppe;
                }
            }
            case 19: {
                try {
                    String devName = payload.readString(20);
                    if (this.accountId != null) {
                        this.loadDeviceId(ipAddr, devName);
                        break;
                    }
                    this.loadUniqueID(ipAddr, StringTools.getBytes((String)devName));
                    break;
                }
                catch (PacketParseException ppe) {
                    ppe.setTerminate();
                    throw ppe;
                }
            }
            case 176: {
                int propKey = (int)payload.readULong(2, 0L);
                byte[] propVal = payload.readBytes(255);
                this.getDeviceId().handleProperty(propKey, propVal);
                break;
            }
            case 207: {
                ++this.formatRecvTemplate;
                int custType = (int)payload.readULong(1, 0L);
                Payload p = new Payload();
                p.writeULong((long)custType, 1);
                if (!Packet.isCustomEventType(custType)) {
                    byte[] errData = p.getBytes();
                    throw new PacketParseException(62481, packet, errData);
                }
                int numFlds = (int)payload.readULong(1, 0L);
                if (!payload.isValidReadLength(numFlds * 3)) {
                    byte[] errData = p.getBytes();
                    throw new PacketParseException(62481, packet, errData);
                }
                PayloadTemplate.Field[] field = new PayloadTemplate.Field[numFlds];
                int accumLen = 0;
                for (int i = 0; i < field.length; ++i) {
                    long fldMask = payload.readULong(3, 0L);
                    field[i] = new PayloadTemplate.Field(fldMask);
                    if (!field[i].isValidType()) {
                        byte[] errData = p.getBytes();
                        throw new PacketParseException(62481, packet, errData);
                    }
                    if ((accumLen += field[i].getLength()) <= 255) continue;
                    byte[] errData = p.getBytes();
                    throw new PacketParseException(62481, packet, errData);
                }
                PayloadTemplate payloadTemp = new PayloadTemplate(custType, field);
                this.getDeviceId().addClientPayloadTemplate(payloadTemp);
                break;
            }
            case 208: {
                int diagCode = (int)payload.readULong(2, 0L);
                byte[] diagData = payload.readBytes(255);
                this.getDeviceId().handleDiagnostic(diagCode, diagData);
                break;
            }
            case 224: {
                int errCode = (int)payload.readULong(2, 0L);
                byte[] errData = payload.readBytes(255);
                this.getDeviceId().handleError(errCode, errData);
                return this._handleError(packet);
            }
            default: {
                throw new PacketParseException(61714, packet);
            }
        }
        return null;
    }

    private Packet[] _parsePacket(String ipAddr, byte[] pkt) {
        this.fletcher.runningChecksum(pkt);
        if (pkt != null && pkt.length > 0) {
            if (pkt[0] == 36) {
                int len = pkt[pkt.length - 1] == 13 ? pkt.length - 1 : pkt.length;
                Print.logDebug((String)("<== " + StringTools.toStringValue((byte[])pkt, (int)0, (int)len)), (Object[])new Object[0]);
            } else {
                String encPkt = StringTools.toHexString((byte[])pkt);
                Print.logDebug((String)("<== 0x" + encPkt), (Object[])new Object[0]);
            }
        }
        Packet packet = null;
        try {
            packet = new Packet(this.deviceId, true, pkt);
            if (this.encoding == -1) {
                this.encoding = packet.getEncoding();
            }
            Packet[] p = this._handlePacket(ipAddr, packet);
            return p;
        }
        catch (PacketParseException ppe) {
            int errCode;
            Packet errPkt = ppe.getPacket();
            if (errPkt == null) {
                ppe.setPacket(packet);
                errPkt = packet;
            }
            if (ppe.terminateSession()) {
                this._setTerminateSession();
            }
            if ((errCode = ppe.getErrorCode()) == 62498) {
                if (++this.formatErrorCount == 1) {
                    if (errPkt != null) {
                        this.formatErrorType = errPkt.getPacketType();
                        if (this.isDuplex()) {
                            int hdrType = errPkt.getPacketHeader() << 8 | errPkt.getPacketType();
                            String hdrTypeStr = StringTools.toHexString((long)hdrType, (int)16);
                            Print.logWarn((String)("Unrecognized event packet type: 0x" + hdrTypeStr + " (client will be notified)"), (Object[])new Object[0]);
                            if (DMTPServer.getAllowFirstSessionNegotiation()) {
                                this.expectEventTemplate = true;
                            }
                        } else {
                            Print.logException((String)"Unrecognized event packet type during Simplex transport!", (Throwable)ppe);
                        }
                    } else {
                        this.formatErrorType = 0;
                    }
                } else if (errPkt != null && errPkt.getPacketType() == this.formatErrorType) {
                    return null;
                }
            } else if (errCode == 61489) {
                Print.logError((String)"Invalid Device ID", (Object[])new Object[0]);
            } else {
                Print.logException((String)"Error: ", (Throwable)ppe);
            }
            return new Packet[]{ppe.createServerErrorPacket()};
        }
    }
}

