/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import org.opendmtp.server.base.DMTPServer;
import org.opendmtp.server.base.PacketParseException;
import org.opendmtp.server.db.AccountDB;
import org.opengts.util.Print;

public class AccountID {
    private AccountDB db = null;

    private static AccountDB GetAccountDB(String acctName) throws PacketParseException {
        DMTPServer.DBFactory fact = DMTPServer.getDBFactory();
        if (fact != null) {
            AccountDB db = fact.getAccountDB(acctName);
            if (db != null) {
                return db;
            }
        } else {
            Print.logError((String)"No factory registered for AccountID", (Object[])new Object[0]);
        }
        return null;
    }

    public static AccountID loadAccountID(String acctName) throws PacketParseException {
        return new AccountID(acctName);
    }

    private AccountID(String acctName) throws PacketParseException {
        if (acctName == null || acctName.equals("")) {
            Print.logError((String)"Account name is null/empty", (Object[])new Object[0]);
            throw new PacketParseException(61473, null);
        }
        this.db = AccountID.GetAccountDB(acctName);
        if (this.db == null) {
            Print.logError((String)("AccountID not found: " + acctName), (Object[])new Object[0]);
            throw new PacketParseException(61473, null);
        }
    }

    public AccountDB getAccountDB() {
        return this.db;
    }

    public String getAccountName() {
        return this.db.getAccountName();
    }

    public boolean isActive() {
        return this.db.isActive();
    }

    public String toString() {
        return this.db != null ? this.db.toString() : "";
    }
}

