/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.codes;

import org.opengts.util.StringTools;

public class CommandErrors {
    public static final int COMMAND_OK = 0;
    public static final int COMMAND_OK_ACK = 1;
    public static final int COMMAND_ARGUMENTS = 61457;
    public static final int COMMAND_INDEX = 61458;
    public static final int COMMAND_STATUS = 61459;
    public static final int COMMAND_LENGTH = 61460;
    public static final int COMMAND_NAME = 61461;
    public static final int COMMAND_CHECKSUM = 61462;
    public static final int COMMAND_OFFSET = 61463;
    public static final int COMMAND_EXECUTION = 62737;
    public static final int COMMAND_HARDWARE_FAILURE = 62753;
    public static final int COMMAND_ERROR_00 = 65024;
    public static final int COMMAND_ERROR_01 = 65025;
    public static final int COMMAND_ERROR_02 = 65026;
    public static final int COMMAND_ERROR_03 = 65027;
    public static final int COMMAND_ERROR_04 = 65028;
    public static final int COMMAND_ERROR_05 = 65029;
    public static final int COMMAND_ERROR_06 = 65030;
    public static final int COMMAND_ERROR_07 = 65031;
    public static final int COMMAND_FEATURE_NOT_SUPPORTED = 65281;

    public static String getErrorDescription(int errCode) {
        switch (errCode) {
            case 0: {
                return "Successful";
            }
            case 61457: {
                return "Invalid argument";
            }
            case 61458: {
                return "Invalid index";
            }
            case 61459: {
                return "Invalid status code";
            }
            case 61460: {
                return "Invalid length";
            }
            case 61461: {
                return "Invalid name";
            }
            case 61462: {
                return "Invalid checksum";
            }
            case 61463: {
                return "Invalid offset";
            }
            case 65281: {
                return "Feature not supported";
            }
            case 62737: {
                return "Execution error";
            }
            case 62753: {
                return "Hardware failure";
            }
        }
        return "Unknown [" + StringTools.toHexString((long)errCode, (int)16) + "]";
    }
}

