/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.calamp;

import java.net.InetAddress;
import java.util.List;
import java.util.TimeZone;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.servers.calamp.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static boolean DEBUG_MODE = false;
    public static String[] UNIQUEID_PREFIX = null;
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static long SIMEVENT_DIGITAL_INPUTS = 255L;
    public static boolean XLATE_LOCATON_INMOTION = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static boolean PACKET_LEN_END_OF_STREAM = true;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    private static final TimeZone gmtTimezone = DateTime.getGMTTimeZone();
    private String modemID = null;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.modemID = null;
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        if (PACKET_LEN_END_OF_STREAM) {
            return -2;
        }
        return -1;
    }

    public static String toHexString(byte[] ba) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ba.length; ++i) {
            str.append(String.format("%x", ba[i]));
        }
        return str.toString();
    }

    public static String fromHexString(String hex) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            str.append((char)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        return str.toString();
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (ListTools.isEmpty(pktBytes)) {
            Print.logWarn("Ignoring empty/null packet", new Object[0]);
            return null;
        }
        if (pktBytes.length < 11) {
            Print.logError("Unexpected packet length: " + pktBytes.length, new Object[0]);
            return null;
        }
        String s = StringTools.toStringValue(pktBytes).trim();
        String h = StringTools.toHexString(pktBytes).trim();
        System.out.println("Hexa: " + h);
        if (h.startsWith("8305")) {
            String ack = h.substring(0, 26);
            String dem = TrackClientPacketHandler.fromHexString(ack);
            System.out.println("ack: " + dem);
            return dem.getBytes();
        }
        return this.parseInsertRecord_calamp(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] parseInsertRecord_calamp(String s) {
        List<Device.GeozoneTransition> zone;
        int code;
        int gpx;
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        Print.logInfo("Parsing (calamp): " + s, new Object[0]);
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        if (fld.length < 15) {
            Print.logWarn("Invalid number of fields", new Object[0]);
            return null;
        }
        int imeiNdx = -1;
        for (int f = 0; f < fld.length; ++f) {
            if (!fld[f].startsWith("imei:")) continue;
            this.modemID = fld[f].substring("imei:".length()).trim();
            imeiNdx = f;
            break;
        }
        if (StringTools.isBlank(this.modemID)) {
            Print.logError("'imei:' value is missing", new Object[0]);
            return null;
        }
        for (gpx = 0; gpx < fld.length && !fld[gpx].equalsIgnoreCase("GPRMC"); ++gpx) {
        }
        if (gpx >= fld.length) {
            Print.logError("'GPRMC' not found", new Object[0]);
            return null;
        }
        if (gpx + 12 >= fld.length) {
            Print.logError("Insufficient 'GPRMC' fields", new Object[0]);
            return null;
        }
        long hms = StringTools.parseLong(fld[gpx + 1], 0L);
        long dmy = StringTools.parseLong(fld[gpx + 9], 0L);
        long fixtime = this._getUTCSeconds_DMY_HMS(dmy, hms);
        boolean validGPS = fld[gpx + 2].equalsIgnoreCase("A");
        double latitude = validGPS ? this._parseLatitude(fld[gpx + 3], fld[gpx + 4]) : 0.0;
        double longitude = validGPS ? this._parseLongitude(fld[gpx + 5], fld[gpx + 6]) : 0.0;
        double knots = validGPS ? StringTools.parseDouble(fld[gpx + 7], -1.0) : 0.0;
        double headingDeg = validGPS ? StringTools.parseDouble(fld[gpx + 8], -1.0) : 0.0;
        double speedKPH = knots >= 0.0 ? knots * 1.852 : -1.0;
        double odomKM = 0.0;
        String altMStr = fld.length > imeiNdx + 2 ? fld[imeiNdx + 2] : "";
        double altitudeM = StringTools.parseDouble(altMStr, 0.0);
        long gpioInput = -1L;
        String battVStr = fld.length > imeiNdx + 3 ? fld[imeiNdx + 3] : "";
        double batteryV = 0.0;
        if (battVStr.startsWith("F:") || battVStr.startsWith("L:")) {
            batteryV = StringTools.parseDouble(battVStr.substring(2), 0.0);
        }
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date: " + fld[gpx + 9] + "/" + fld[gpx + 1], new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
        }
        String eventCode = gpx + 14 < fld.length ? StringTools.trim(fld[gpx + 14]) : "";
        int statusCode = 61472;
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null && !StringTools.isBlank(eventCode) && (code = dcs.translateStatusCode(eventCode, -9999)) != -9999) {
            statusCode = code;
        }
        if (statusCode == -1) {
            Print.logError("Ignoring EventCode: " + eventCode, new Object[0]);
            return null;
        }
        if (statusCode == 0) {
            statusCode = speedKPH > 0.0 ? 61714 : 61472;
        } else if (XLATE_LOCATON_INMOTION && statusCode == 61472 && speedKPH > 0.0) {
            statusCode = 61714;
        }
        if (validGPS && !GeoPoint.isValid(latitude, longitude)) {
            Print.logWarn("Invalid GPRMC lat/lon: " + latitude + "/" + longitude, new Object[0]);
            latitude = 0.0;
            longitude = 0.0;
            validGPS = false;
        }
        GeoPoint geoPoint = new GeoPoint(latitude, longitude);
        if (speedKPH < MINIMUM_SPEED_KPH) {
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        Print.logInfo("IMEI     : " + this.modemID, new Object[0]);
        Print.logInfo("Timestamp: " + fixtime + " [" + new DateTime(fixtime) + "]", new Object[0]);
        Print.logInfo("GPS      : " + geoPoint, new Object[0]);
        Print.logInfo("Speed    : " + StringTools.format(speedKPH, "#0.0") + " kph " + headingDeg, new Object[0]);
        Print.logInfo("Altitude : " + StringTools.format(altitudeM, "#0.0") + " meters", new Object[0]);
        Print.logInfo("Battery  : " + StringTools.format(batteryV, "#0.0") + " Volts", new Object[0]);
        Device device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), this.modemID);
        if (device == null) {
            return null;
        }
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        Print.logInfo("UniqueID  : " + uniqueID, new Object[0]);
        Print.logInfo("DeviceID  : " + accountID + "/" + deviceID, new Object[0]);
        double maxSpeed = device.getSpeedLimitKPH();
        if (speedKPH > MINIMUM_SPEED_KPH && speedKPH < maxSpeed) {
            statusCode = device.getLastValidSpeed() <= MINIMUM_SPEED_KPH ? 61713 : 61714;
        } else if (speedKPH >= maxSpeed) {
            statusCode = 61722;
        } else if (speedKPH <= MINIMUM_SPEED_KPH) {
            statusCode = 61715;
        }
        DataTransport dataXPort = device.getDataTransport();
        if (this.hasIPAddress() && !dataXPort.isValidIPAddress(this.getIPAddress())) {
            DTIPAddrList validIPAddr = dataXPort.getIpAddressValid();
            Print.logError("Invalid IP Address from device: " + this.getIPAddress() + " [expecting " + validIPAddr + "]", new Object[0]);
            return null;
        }
        dataXPort.setIpAddressCurrent(this.getIPAddress());
        dataXPort.setRemotePortCurrent(this.getRemotePort());
        dataXPort.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!dataXPort.getDeviceCode().equalsIgnoreCase(Main.getServerName())) {
            dataXPort.setDeviceCode(Main.getServerName());
        }
        odomKM = odomKM <= 0.0 ? (ESTIMATE_ODOMETER && validGPS ? device.getNextOdometerKM(geoPoint) : device.getLastOdometerKM()) : device.adjustOdometerKM(odomKM);
        Print.logInfo("OdometerKM: " + odomKM, new Object[0]);
        if (SIMEVENT_GEOZONES && validGPS && (zone = device.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                this.insertEventRecord(device, z.getTimestamp(), z.getStatusCode(), z.getGeozone(), geoPoint, 0L, 0.0, 0, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
                Print.logInfo("Geozone    : " + z, new Object[0]);
                if (z.getStatusCode() != statusCode) continue;
                Print.logDebug("StatusCode already inserted: 0x" + StatusCodes.GetHex(statusCode), new Object[0]);
                statusCode = -1;
            }
        }
        if (!(statusCode < 0 || statusCode == -1 || statusCode == 61472 && this.hasSavedEvents())) {
            if (statusCode != 61472) {
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, 0L, 0.0, 0, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
            } else if (validGPS && !device.isNearLastValidLocation(geoPoint, MINIMUM_MOVED_METERS)) {
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, 0L, 0.0, 0, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
            }
        }
        try {
            device.updateChangedEventFields();
        }
        catch (DBException dbe) {
            Print.logException("Unable to update Device: " + accountID + "/" + deviceID, dbe);
        }
        return null;
    }

    private long _getUTCSeconds_DMY_HMS(long dmy, long hms) {
        long DAY;
        int HH = (int)(hms / 10000L % 100L);
        int MM = (int)(hms / 100L % 100L);
        int SS = (int)(hms % 100L);
        long TOD = (long)HH * 3600L + (long)MM * 60L + (long)SS;
        if (dmy > 0L) {
            int yy = (int)(dmy % 100L) + 2000;
            int mm = (int)(dmy / 100L % 100L);
            int dd = (int)(dmy / 10000L % 100L);
            long yr = (long)yy * 1000L + (long)((mm - 3) * 1000 / 12);
            DAY = (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)dd - 719469L;
        } else {
            long dif;
            long utc = DateTime.getCurrentTimeSec();
            long tod = utc % DateTime.DaySeconds(1L);
            DAY = utc / DateTime.DaySeconds(1L);
            long l = dif = tod >= TOD ? tod - TOD : TOD - tod;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = tod > TOD ? ++DAY : --DAY;
            }
        }
        long sec = DateTime.DaySeconds(DAY) + TOD;
        return sec;
    }

    private double _parseLatitude(String s, String d) {
        double _lat = StringTools.parseDouble(s, 99999.0);
        if (_lat < 99999.0) {
            double lat = (long)_lat / 100L;
            lat += (_lat - lat * 100.0) / 60.0;
            return d.equals("S") ? -lat : lat;
        }
        return 90.0;
    }

    private double _parseLongitude(String s, String d) {
        double _lon = StringTools.parseDouble(s, 99999.0);
        if (_lon < 99999.0) {
            double lon = (long)_lon / 100L;
            lon += (_lon - lon * 100.0) / 60.0;
            return d.equals("W") ? -lon : lon;
        }
        return 180.0;
    }

    private EventData createEventRecord(Device device, long gpsTime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitudeM, double odomKM, long gpioInput, double batteryV) {
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        EventData.Key evKey = new EventData.Key(accountID, deviceID, gpsTime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeozone(geozone);
        evdb.setGeoPoint(geoPoint);
        evdb.setGpsAge(gpsAge);
        evdb.setHDOP(HDOP);
        evdb.setSatelliteCount(numSats);
        evdb.setSpeedKPH(speedKPH);
        evdb.setHeading(heading);
        evdb.setAltitude(altitudeM);
        evdb.setOdometerKM(odomKM);
        evdb.setInputMask(gpioInput);
        evdb.setBatteryVolts(batteryV);
        return evdb;
    }

    private void insertEventRecord(Device device, long gpsTime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitudeM, double odomKM, long gpioInput, double batteryV) {
        EventData evdb = this.createEventRecord(device, gpsTime, statusCode, geozone, geoPoint, gpsAge, HDOP, numSats, speedKPH, heading, altitudeM, odomKM, gpioInput, batteryV);
        Print.logInfo("Event: [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        if (!DEBUG_MODE) {
            device.insertEventData(evdb);
            this.incrementSavedEventCount();
        }
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
            SIMEVENT_DIGITAL_INPUTS = dcsc.getSimulateDigitalInputs(SIMEVENT_DIGITAL_INPUTS) & 0xFFL;
            XLATE_LOCATON_INMOTION = dcsc.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            PACKET_LEN_END_OF_STREAM = dcsc.getBooleanProperty("calamp.packetLenEndOfStream", PACKET_LEN_END_OF_STREAM);
        }
    }
}

