/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.GroupRecord;
import org.opengts.db.RuleFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.rule.EventRuleFactory;
import org.opengts.rule.tables.Rule;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class RuleList
extends DeviceRecord<RuleList> {
    public static final int ALL_CODES = 0;
    public static final String ALL_DEVICES = "*";
    public static final String[] ALL_DEVICES_ARRAY = new String[]{"*"};
    public static final String NO_DEVICES = "-";
    public static final String ALL_GROUPS = "*";
    public static final String[] ALL_GROUPS_ARRAY = new String[]{"*"};
    public static final String NO_GROUPS = "-";
    private static int IncludeDeviceGroupRules = -1;
    public static final String _TABLE_NAME = "RuleList";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_ruleID = "ruleID";
    public static final String FLD_groupID = "groupID";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID(true), DeviceRecord.newField_deviceID(true), GroupRecord.newField_groupID(true), new DBField("statusCode", Integer.TYPE, "UINT32", "Status Code", "key=true editor=statusCode dftval=0"), new DBField("ruleID", String.class, DBField.TYPE_RULE_ID(), "Rule ID", "key=true"), RuleList.newField_lastUpdateTime(), RuleList.newField_lastUpdateUser(true), RuleList.newField_creationTime()};
    private static DBFactory<RuleList> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_GROUP = new String[]{"group", "grp"};
    private static final String[] ARG_CODE = new String[]{"code"};
    private static final String[] ARG_RULE = new String[]{"rule"};
    private static final String[] ARG_ADD = new String[]{"add"};
    private static final String[] ARG_REMOVE = new String[]{"remove", "delete"};
    private static final String[] ARG_DEVRULES = new String[]{"devRules"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_EXISTS = new String[]{"exists"};
    private static final String[] ARG_CRON = new String[]{"cron"};

    public static boolean IncludeDeviceGroupRules() {
        if (IncludeDeviceGroupRules < 0) {
            boolean bl = RTConfig.getBoolean("RuleList.includeGroupRules", false);
            if (bl && !RuleList.getFactory().hasField(FLD_groupID)) {
                Print.logWarn("\"RuleList.includeGroupRules=true\" specified, but 'RuleList' table does not have 'groupID' column enabled", new Object[0]);
                bl = false;
            }
            IncludeDeviceGroupRules = bl ? 1 : 0;
        }
        return IncludeDeviceGroupRules == 1;
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName(_TABLE_NAME);
    }

    public static DBFactory<RuleList> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory(RuleList.TABLE_NAME(), FieldInfo, DBFactory.KeyType.PRIMARY, RuleList.class, Key.class, true, true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
            factory.addParentTable(Rule.TABLE_NAME());
            factory.setFieldDefaultValue("deviceID", "-");
            factory.setFieldDefaultValue(FLD_groupID, "-");
            factory.setFieldDefaultValue(FLD_statusCode, new Integer(0));
        }
        return factory;
    }

    public RuleList() {
    }

    public RuleList(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(RuleList.class, locale);
        return i18N.getString("RuleList.description", "This table defines Device and StatusCode specific Rule associations.");
    }

    @Override
    public void setDeviceID(String string) {
        super.setDeviceID(StringTools.isBlank(string) ? "-" : string);
    }

    public String getGroupID() {
        String string = (String)this.getFieldValue(FLD_groupID);
        return StringTools.trim(string);
    }

    public void setGroupID(String string) {
        this.setFieldValue(FLD_groupID, StringTools.isBlank(string) ? "-" : StringTools.trim(string));
    }

    public int getStatusCode() {
        Integer n = (Integer)this.getFieldValue(FLD_statusCode);
        return n != null ? n : 0;
    }

    public String getRuleID() {
        String string = (String)this.getFieldValue(FLD_ruleID);
        return string != null ? string : "";
    }

    @Override
    public String toString() {
        String string = "/";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAccountID());
        stringBuffer.append(string);
        stringBuffer.append(this.getDeviceID());
        stringBuffer.append(string);
        stringBuffer.append("0x").append(StringTools.toHexString(this.getStatusCode(), 16));
        stringBuffer.append(string);
        stringBuffer.append(this.getRuleID());
        return stringBuffer.toString();
    }

    @Override
    public void setCreationDefaultValues() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<RuleList> getRuleList(String string, String string2, long l) throws DBException {
        Statement statement;
        DBConnection dBConnection;
        Vector<RuleList> vector;
        block19: {
            if (StringTools.isBlank(string)) {
                return null;
            }
            vector = new Vector<RuleList>();
            dBConnection = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                DBSelect<RuleList> dBSelect = new DBSelect<RuleList>(RuleList.getFactory());
                DBWhere dBWhere = dBSelect.createDBWhere();
                if (!StringTools.isBlank(string2)) {
                    dBSelect.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", string), dBWhere.EQ(FLD_ruleID, string2))));
                } else {
                    dBSelect.setWhere(dBWhere.WHERE_(dBWhere.EQ("accountID", string)));
                }
                dBSelect.setOrderByFields(FLD_ruleID);
                dBSelect.setLimit(l);
                dBConnection = DBConnection.getDefaultConnection();
                statement = dBConnection.execute(dBSelect.toString());
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("accountID");
                    String string4 = resultSet.getString("deviceID");
                    String string5 = resultSet.getString(FLD_groupID);
                    int n = resultSet.getInt(FLD_statusCode);
                    String string6 = resultSet.getString(FLD_ruleID);
                    RuleList ruleList = new RuleList(new Key(string3, string4, string5, n, string6));
                    ruleList.setAllFieldValues(resultSet);
                    vector.add(ruleList);
                }
                if (resultSet == null) break block19;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DBException("Getting Account/Rule RuleList", sQLException);
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dBConnection);
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DBConnection.release(dBConnection);
        return vector;
    }

    public static Collection<String> getRulesForDevice(Device device, int n) throws DBException {
        if (device != null) {
            String string = device.getAccountID();
            String string2 = device.getDeviceID();
            return RuleList.getRulesForDevice(string, string2, false, n);
        }
        return null;
    }

    protected static Collection<String> getRulesForDevice(String string, String string2, boolean bl, int n) throws DBException {
        Object object;
        Object object2;
        Object object3;
        if (StringTools.isBlank(string)) {
            return null;
        }
        if (StringTools.isBlank(string2)) {
            string2 = "*";
        }
        if (n <= 0 || n == 0) {
            n = 0;
        }
        HashSet<String> hashSet = new HashSet<String>();
        DBConnection dBConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            object3 = new DBSelect<RuleList>(RuleList.getFactory());
            ((DBSelect)object3).setSelectedFields(FLD_ruleID);
            object2 = ((DBSelect)object3).createDBWhere();
            ((DBSelect)object3).setWhere(((DBWhere)object2).WHERE_(((DBWhere)object2).AND(((DBWhere)object2).EQ("accountID", string), string2.equals("*") ? ((DBWhere)object2).EQ("deviceID", "*") : ((DBWhere)object2).OR(((DBWhere)object2).EQ("deviceID", "*"), ((DBWhere)object2).EQ("deviceID", string2)), bl ? null : (n == 0 ? ((DBWhere)object2).EQ(FLD_statusCode, 0) : ((DBWhere)object2).OR(((DBWhere)object2).EQ(FLD_statusCode, 0), ((DBWhere)object2).EQ(FLD_statusCode, n))))));
            ((DBSelect)object3).setOrderByFields(FLD_ruleID);
            dBConnection = DBConnection.getDefaultConnection();
            statement = dBConnection.execute(((DBSelect)object3).toString());
            resultSet = statement.getResultSet();
            while (resultSet.next()) {
                object = resultSet.getString(FLD_ruleID);
                hashSet.add((String)object);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException("Getting Account/Device RuleList", sQLException);
            }
            catch (Throwable throwable) {
                DBConnection.release(dBConnection, statement, resultSet);
                throw throwable;
            }
        }
        DBConnection.release(dBConnection, statement, resultSet);
        if (RuleList.IncludeDeviceGroupRules() && !string2.equals("*")) {
            dBConnection = null;
            statement = null;
            resultSet = null;
            try {
                object3 = DeviceGroup.getDeviceGroupsForDevice(string, string2);
                if (!ListTools.isEmpty(object3)) {
                    object2 = new DBSelect<RuleList>(RuleList.getFactory());
                    ((DBSelect)object2).setSelectedFields(FLD_ruleID);
                    object = ((DBSelect)object2).createDBWhere();
                    ((DBWhere)object).append(((DBWhere)object).EQ("accountID", string));
                    ((DBWhere)object).append(((DBWhere)object).AND_(((DBWhere)object).INLIST(FLD_groupID, (Iterable<?>)object3)));
                    if (!bl) {
                        ((DBWhere)object).append(((DBWhere)object).AND_(n == 0 ? ((DBWhere)object).EQ(FLD_statusCode, 0) : ((DBWhere)object).OR(((DBWhere)object).EQ(FLD_statusCode, 0), ((DBWhere)object).EQ(FLD_statusCode, n))));
                    }
                    ((DBSelect)object2).setWhere(((DBWhere)object).WHERE_(((DBWhere)object).toString()));
                    ((DBSelect)object2).setOrderByFields(FLD_ruleID);
                    dBConnection = DBConnection.getDefaultConnection();
                    statement = dBConnection.execute(((DBSelect)object2).toString());
                    resultSet = statement.getResultSet();
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(FLD_ruleID);
                        hashSet.add(string3);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new DBException("Getting Account/Device RuleList", sQLException);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
                DBConnection.release(dBConnection);
            }
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getStatusCodesForDeviceID(Rule rule, String string, boolean bl) throws DBException {
        Object object;
        Statement statement;
        DBConnection dBConnection;
        Vector<Integer> vector;
        block20: {
            if (rule == null) {
                Print.logWarn("Specified Rule is null!", new Object[0]);
                return null;
            }
            String string2 = rule.getAccountID();
            String string3 = rule.getRuleID();
            if (StringTools.isBlank(string)) {
                string = "*";
            }
            vector = new Vector<Integer>();
            dBConnection = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                object = new DBSelect<RuleList>(RuleList.getFactory());
                ((DBSelect)object).setSelectedFields(FLD_statusCode);
                DBWhere dBWhere = ((DBSelect)object).createDBWhere();
                ((DBSelect)object).setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", string2), string.equals("*") || bl ? dBWhere.EQ("deviceID", string) : dBWhere.OR(dBWhere.EQ("deviceID", "*"), dBWhere.EQ("deviceID", string)), dBWhere.EQ(FLD_ruleID, string3))));
                ((DBSelect)object).setOrderByFields(FLD_statusCode);
                dBConnection = DBConnection.getDefaultConnection();
                statement = dBConnection.execute(((DBSelect)object).toString());
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    int n = resultSet.getInt(FLD_statusCode);
                    vector.add(new Integer(n));
                }
                if (resultSet == null) break block20;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DBException("Getting Account/Device RuleList", sQLException);
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dBConnection);
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DBConnection.release(dBConnection);
        object = new int[vector.size()];
        int i = 0;
        while (i < vector.size()) {
            object[i] = (Integer)vector.get(i);
            ++i;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getDeviceIDsForStatusCode(Rule rule, int n, boolean bl) throws DBException {
        Statement statement;
        DBConnection dBConnection;
        Vector<String> vector;
        boolean bl2;
        block20: {
            if (rule == null) {
                Print.logWarn("Specified Rule is null!", new Object[0]);
                return null;
            }
            String string = rule.getAccountID();
            String string2 = rule.getRuleID();
            if (n < 0) {
                n = 0;
            }
            bl2 = false;
            vector = new Vector<String>();
            dBConnection = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                DBSelect<RuleList> dBSelect = new DBSelect<RuleList>(RuleList.getFactory());
                dBSelect.setSelectedFields(FLD_statusCode);
                DBWhere dBWhere = dBSelect.createDBWhere();
                dBSelect.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", string), n == 0 || bl ? dBWhere.EQ(FLD_statusCode, n) : dBWhere.OR(dBWhere.EQ(FLD_statusCode, 0), dBWhere.EQ(FLD_statusCode, n)), dBWhere.EQ(FLD_ruleID, string2))));
                dBSelect.setOrderByFields("deviceID");
                dBConnection = DBConnection.getDefaultConnection();
                statement = dBConnection.execute(dBSelect.toString());
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("deviceID");
                    if ("*".equals(string3)) {
                        bl2 = true;
                        break;
                    }
                    vector.add(string3);
                }
                if (resultSet == null) break block20;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DBException("Getting Account/StatusCode RuleList", sQLException);
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dBConnection);
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DBConnection.release(dBConnection);
        if (!bl2) {
            return vector.toArray(new String[vector.size()]);
        }
        return ALL_DEVICES_ARRAY;
    }

    public static void deleteRules(String string, String string2, String string3, String string4, int n) throws DBException {
        DBConnection dBConnection = null;
        try {
            Key key = new Key();
            key.setFieldValue("accountID", string);
            key.setFieldValue(FLD_ruleID, string2);
            if (!StringTools.isBlank(string3)) {
                key.setFieldValue("deviceID", string3);
            }
            if (!StringTools.isBlank(string4)) {
                key.setFieldValue(FLD_groupID, string4);
            }
            if (n >= 0) {
                key.setFieldValue(FLD_statusCode, n);
            }
            if (!key.exists(DBWhere.KEY_PARTIAL_ALL)) {
                Print.logWarn("RuleList Key does not exist: " + key + " (attempting delete anyway)", new Object[0]);
            }
            DBDelete dBDelete = new DBDelete(RuleList.getFactory());
            dBDelete.setWhere(key.getWhereClause(DBWhere.KEY_PARTIAL_ALL));
            dBConnection = DBConnection.getDefaultConnection();
            dBConnection.executeUpdate(dBDelete.toString());
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException("Deleting Rules", sQLException);
            }
            catch (Throwable throwable) {
                DBConnection.release(dBConnection);
                throw throwable;
            }
        }
        DBConnection.release(dBConnection);
    }

    public static void deleteRules(String string, String string2) throws DBException {
        DBConnection dBConnection = null;
        try {
            Key key = new Key();
            key.setFieldValue("accountID", string);
            key.setFieldValue(FLD_ruleID, string2);
            DBDelete dBDelete = new DBDelete(RuleList.getFactory());
            dBDelete.setWhere(key.getWhereClause(DBWhere.KEY_PARTIAL_ALL));
            dBConnection = DBConnection.getDefaultConnection();
            dBConnection.executeUpdate(dBDelete.toString());
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException("Deleting Rules", sQLException);
            }
            catch (Throwable throwable) {
                DBConnection.release(dBConnection);
                throw throwable;
            }
        }
        DBConnection.release(dBConnection);
    }

    public static boolean clearRuleListEntries(String string, String string2) {
        try {
            RuleList.deleteRules(string, string2);
            return true;
        }
        catch (DBException dBException) {
            Print.logException("Error deleting existing Rule entries from the RuleList table", dBException);
            return false;
        }
    }

    public static boolean setSingleGroupRuleListEntry(String string, String string2, String string3, int n) {
        if (StringTools.isBlank(string3)) {
            string3 = "*";
        }
        if (n <= 0) {
            n = 0;
        }
        if (!RuleList.clearRuleListEntries(string, string2)) {
            return false;
        }
        if (!string3.equals("-")) {
            Key key = new Key(string, null, string3, n, string2);
            try {
                if (key.exists()) {
                    Print.logWarn("RuleList entry already exists: " + key, new Object[0]);
                } else {
                    RuleList ruleList = (RuleList)key.getDBRecord();
                    ruleList.setCreationDefaultValues();
                    ruleList.save();
                }
                return true;
            }
            catch (DBException dBException) {
                Print.logException("Error adding Group RuleList entry: " + key, dBException);
                return false;
            }
        }
        return true;
    }

    public static boolean setSingleDeviceRuleListEntry(String string, String string2, String string3, int n) {
        if (StringTools.isBlank(string3)) {
            string3 = "*";
        }
        if (n <= 0) {
            n = 0;
        }
        if (!RuleList.clearRuleListEntries(string, string2)) {
            return false;
        }
        if (!string3.equals("-")) {
            Key key = new Key(string, string3, null, n, string2);
            try {
                if (key.exists()) {
                    Print.logWarn("RuleList entry already exists: " + key, new Object[0]);
                } else {
                    RuleList ruleList = (RuleList)key.getDBRecord();
                    ruleList.setCreationDefaultValues();
                    ruleList.save();
                }
                return true;
            }
            catch (DBException dBException) {
                Print.logException("Error adding Device RuleList entry: " + key, dBException);
                return false;
            }
        }
        return true;
    }

    private static void usage() {
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + RuleList.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Common Options:", new Object[0]);
        Print.logInfo("  -account=<id>      Acount ID which owns RuleList", new Object[0]);
        Print.logInfo("  -device=<id>       Device ID which owns RuleList", new Object[0]);
        Print.logInfo("  -group=<id>        Group ID which owns RuleList", new Object[0]);
        Print.logInfo("  -code=<code>       Status Code", new Object[0]);
        Print.logInfo("  -rule=<id>         Rule ID", new Object[0]);
        Print.logInfo("  -add               Add specified Rule to RuleList", new Object[0]);
        Print.logInfo("  -remove            Remove specified Rule from RuleList", new Object[0]);
        Print.logInfo("  -devRules[=all]    List Device Rules", new Object[0]);
        Print.logInfo("  -list              List RuleList entries", new Object[0]);
        Print.logInfo("  -exists            Checks for existance of partially specified keys", new Object[0]);
        Print.logInfo("  -cron[=true|false] True to list cron rules, False for non-cron rules", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Collection<Object> collection;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        AccountRecord accountRecord;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        DBConfig.cmdLineInit(stringArray, true);
        String string = RTConfig.getString(ARG_ACCOUNT, null);
        String string2 = RTConfig.getString(ARG_DEVICE, null);
        String string3 = RTConfig.getString(ARG_GROUP, null);
        int n = RTConfig.getInt(ARG_CODE, -1);
        String string4 = RTConfig.getString(ARG_RULE, null);
        int n2 = -1;
        String string5 = RTConfig.getString(ARG_CRON, null);
        if (string5 != null) {
            if (string5.equals("") || string5.equalsIgnoreCase("true")) {
                n2 = 1;
                RuleFactory ruleFactory = Device.getRuleFactory();
                if (ruleFactory instanceof EventRuleFactory) {
                    ((EventRuleFactory)ruleFactory).setCronMode(true);
                }
            } else if (string5.equalsIgnoreCase("false")) {
                n2 = 0;
            } else if (string5.equalsIgnoreCase("all")) {
                n2 = -1;
            }
        }
        boolean bl5 = n2 == 1;
        int n3 = 0;
        if (string == null || string.equals("")) {
            Print.logError("Account-ID not specified.", new Object[0]);
            RuleList.usage();
        }
        boolean bl6 = bl4 = !StringTools.isBlank(string2);
        if (bl4 && string2.startsWith("/")) {
            string2 = "*";
        }
        boolean bl7 = bl3 = !StringTools.isBlank(string3);
        if (bl3 && string3.startsWith("/")) {
            string3 = "*";
        }
        if (bl4 && bl3) {
            Print.logError("'device' and 'group' specifications are mutually exclusive", new Object[0]);
            RuleList.usage();
        }
        if (!(RTConfig.hasProperty(ARG_LIST) || bl4 || bl3)) {
            Print.logError("One of 'device' or 'group' must be specified", new Object[0]);
            RuleList.usage();
        }
        boolean bl8 = bl2 = n >= 0;
        if (n > 0 && !StatusCodes.IsValid(n, null)) {
            Print.logError("Invalid Status Code specified.", new Object[0]);
            RuleList.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(string);
            if (account == null) {
                Print.logError("Account-ID does not exist: " + string, new Object[0]);
                RuleList.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException("Error loading Account: " + string, dBException);
            System.exit(99);
        }
        if (bl4 && !string2.equals("*")) {
            try {
                accountRecord = Device.getDevice(account, string2);
                if (accountRecord == null) {
                    Print.logError("Device-ID does not exist: " + string + "/" + string2, new Object[0]);
                    RuleList.usage();
                }
            }
            catch (DBException dBException) {
                Print.logException("Error loading Device: " + string + "/" + string2, dBException);
                System.exit(99);
            }
        }
        if (bl3 && !string3.equals("*")) {
            try {
                accountRecord = DeviceGroup.getDeviceGroup(account, string3);
                if (accountRecord == null) {
                    Print.logError("Group-ID does not exist: " + string + "/" + string3, new Object[0]);
                    RuleList.usage();
                }
            }
            catch (DBException dBException) {
                Print.logException("Error loading DeviceGroup: " + string + "/" + string3, dBException);
                System.exit(99);
            }
        }
        boolean bl9 = bl = !StringTools.isBlank(string4);
        if (bl) {
            try {
                object3 = Rule.getRule(account, string4);
                if (object3 == null) {
                    Print.logError("Rule-ID does not exist: " + string + "/" + string4, new Object[0]);
                    RuleList.usage();
                }
            }
            catch (DBException dBException) {
                Print.logException("Error loading Rule: " + string + "/" + string4, dBException);
                System.exit(99);
            }
        }
        object3 = new StringBuffer();
        ((StringBuffer)object3).append(string);
        ((StringBuffer)object3).append("/");
        ((StringBuffer)object3).append(bl4 ? string2 : "-");
        ((StringBuffer)object3).append("/");
        ((StringBuffer)object3).append(bl3 ? string3 : "-");
        ((StringBuffer)object3).append("/");
        ((StringBuffer)object3).append(n > 0 ? StatusCodes.GetHex(n) + "[" + StatusCodes.GetName(n, null) + "]" : "*");
        if (bl) {
            ((StringBuffer)object3).append("/");
            ((StringBuffer)object3).append(string4);
        }
        if (RTConfig.getBoolean(ARG_EXISTS, false)) {
            ++n3;
            object2 = new StringBuffer();
            object = new Key();
            ((DBRecordKey)object).setFieldValue("accountID", string);
            ((StringBuffer)object2).append("Account=").append(string);
            if (!StringTools.isBlank(string2)) {
                ((StringBuffer)object2).append(", Device=").append(string2);
                ((DBRecordKey)object).setFieldValue("deviceID", string2);
            }
            if (!StringTools.isBlank(string3)) {
                ((StringBuffer)object2).append(", Group=").append(string3);
                ((DBRecordKey)object).setFieldValue(FLD_groupID, string3);
            }
            if (n >= 0) {
                ((StringBuffer)object2).append(", StatusCode=").append(n);
                ((DBRecordKey)object).setFieldValue(FLD_statusCode, n);
            }
            if (!StringTools.isBlank(string4)) {
                ((StringBuffer)object2).append(", RuleID=").append(string4);
                ((DBRecordKey)object).setFieldValue(FLD_ruleID, string4);
            }
            try {
                Print.sysPrintln("Exists Key: " + object2, new Object[0]);
                if (((DBRecordKey)object).exists(DBWhere.KEY_PARTIAL_ALL)) {
                    Print.sysPrintln("RuleList Key found: " + object, new Object[0]);
                } else {
                    Print.sysPrintln("RuleList Key not found: " + object, new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError("Error finding RuleList entry: " + object, new Object[0]);
                dBException.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean(ARG_REMOVE, false)) {
            ++n3;
            if (!bl) {
                Print.logError("Rule-ID not specified.", new Object[0]);
                RuleList.usage();
            } else if (!bl2) {
                Print.logError("Status Code not specified.", new Object[0]);
                RuleList.usage();
            }
            try {
                RuleList.deleteRules(string, string4, bl4 ? string2 : null, bl3 ? string3 : null, n);
            }
            catch (DBException dBException) {
                Print.logError("Error deleting RuleList entry: " + object3, new Object[0]);
                dBException.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean(ARG_ADD, false)) {
            ++n3;
            if (!bl) {
                Print.logError("Rule-ID not specified.", new Object[0]);
                RuleList.usage();
            } else if (!bl2) {
                Print.logError("Status Code not specified.", new Object[0]);
                RuleList.usage();
            }
            try {
                object2 = new Key(string, bl4 ? string2 : null, bl3 ? string3 : null, n, string4);
                if (((DBRecordKey)object2).exists()) {
                    Print.logWarn("RuleList entry already exists: " + object3, new Object[0]);
                } else {
                    object = (RuleList)((DBRecordKey)object2).getDBRecord();
                    ((RuleList)object).setCreationDefaultValues();
                    ((DBRecord)object).save();
                    Print.logInfo("Added RuleList entry: " + object3, new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError("Error adding RuleList entry: " + object3, new Object[0]);
                dBException.printException();
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty(ARG_DEVRULES)) {
            object2 = RTConfig.getString(ARG_DEVRULES, "");
            boolean bl10 = ((String)object2).equalsIgnoreCase("all");
            ++n3;
            Print.sysPrintln("", new Object[0]);
            try {
                if (bl4) {
                    Print.sysPrintln("Account/Device/StatusCode: " + string + "/" + string2 + "/" + n, new Object[0]);
                    collection = RuleList.getRulesForDevice(string, string2, bl10, n);
                    int n4 = 0;
                    for (String string6 : collection) {
                        Rule.Key key = new Rule.Key(string, string6);
                        Rule rule = key.exists() ? (Rule)key.getDBRecord(true) : null;
                        if (rule == null || !rule.isActive() || n2 >= 0 && bl5 != rule.getIsCronRule()) continue;
                        Print.sysPrintln(Rule.listRule(rule, 2, null), new Object[0]);
                        ++n4;
                    }
                    if (n4 == 0) {
                        Print.sysPrintln("  No Rules", new Object[0]);
                    }
                } else {
                    Print.sysPrintln("Account Rules: " + string, new Object[0]);
                    Print.sysPrintln(Rule.listRules(string, null, 2, null), new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError("Error list Rules: " + string + "/" + string2 + "/" + n, new Object[0]);
                dBException.printException();
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty(ARG_LIST)) {
            object2 = RTConfig.getString(ARG_LIST, "");
            boolean bl11 = ((String)object2).equalsIgnoreCase("all");
            ++n3;
            Print.sysPrintln("", new Object[0]);
            try {
                Print.sysPrintln("Account: " + string, new Object[0]);
                collection = RuleList.getRuleList(string, string4, -1L);
                for (Object object4 : collection) {
                    Print.sysPrintln("  -------------------------------------------", new Object[0]);
                    Print.sysPrintln("  DeviceID  : " + ((DeviceRecord)object4).getDeviceID(), new Object[0]);
                    Print.sysPrintln("  GroupID   : " + ((RuleList)object4).getGroupID(), new Object[0]);
                    Print.sysPrintln("  StatusCode: " + ((RuleList)object4).getStatusCode(), new Object[0]);
                    Print.sysPrintln("  RuleID    : " + ((RuleList)object4).getRuleID(), new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError("Error list Rules: " + string + "/" + string2 + "/" + n, new Object[0]);
                dBException.printException();
                System.exit(99);
            }
        }
        if (n3 == 0) {
            Print.logWarn("Missing options ...", new Object[0]);
            RuleList.usage();
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<RuleList> {
        public Key() {
        }

        public Key(String string, String string2, String string3, int n, String string4) {
            String string5 = string2 != null ? string2.toLowerCase() : "-";
            String string6 = string3 != null ? string3.toLowerCase() : "-";
            super.setKeyValue("accountID", string != null ? string.toLowerCase() : "");
            super.setKeyValue("deviceID", string5);
            super.setKeyValue(RuleList.FLD_groupID, string6);
            super.setKeyValue(RuleList.FLD_statusCode, n);
            super.setKeyValue(RuleList.FLD_ruleID, string4 != null ? string4.toLowerCase() : "");
        }

        @Override
        public DBFactory<RuleList> getFactory() {
            return RuleList.getFactory();
        }
    }
}

