/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.RuleFactory;
import org.opengts.db.RuleFactoryAdapter;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.EventRuleFactory;
import org.opengts.rule.event.EventSelector;
import org.opengts.rule.selector.ParserException;
import org.opengts.rule.selector.Selector;
import org.opengts.rule.tables.RuleList;
import org.opengts.rule.tables.RuleTrigger;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Rule
extends AccountRecord<Rule> {
    public static final String SYSTEM_RULE_PREFIX = "";
    private static RuleFactory ruleFactory = null;
    public static final String SYSADMIN_RULE_S = "$SYSRULE(\"";
    public static final String SYSADMIN_RULE_E = "\")";
    public static final String _TABLE_NAME = "Rule";
    public static final String FLD_ruleID = "ruleID";
    public static final String FLD_isCronRule = "isCronRule";
    public static final String FLD_ruleTag = "ruleTag";
    public static final String FLD_selector = "selector";
    public static final String FLD_actionMask = "actionMask";
    public static final String FLD_cannedActions = "cannedActions";
    public static final String FLD_priority = "priority";
    public static final String FLD_minNotifyAge = "minNotifyAge";
    public static final String FLD_notifyEmail = "notifyEmail";
    public static final String FLD_emailSubject = "emailSubject";
    public static final String FLD_emailText = "emailText";
    public static final String FLD_smsText = "smsText";
    public static final String FLD_useEmailWrapper = "useEmailWrapper";
    public static final String FLD_ruleDisable = "ruleDisable";
    public static final String FLD_ruleEnable = "ruleEnable";
    public static final String FLD_sendCommand = "sendCommand";
    public static final String FLD_description = "description";
    public static final String FLD_isActive = "isActive";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID(true), new DBField("ruleID", String.class, DBField.TYPE_RULE_ID(), "Rule ID", "key=true"), new DBField("isCronRule", Boolean.TYPE, "BOOLEAN", "Is Cron Rule", "edit=2"), new DBField("ruleTag", String.class, DBField.TYPE_STRING(24), "Rule Tag", "edit=2"), new DBField("selector", String.class, "TEXT", "Rule Selector", "edit=2 editor=ruleSelector"), new DBField("actionMask", Integer.TYPE, "UINT32", "Action Mask", "edit=2 format=X2 editor=ruleAction mask=RuleFactory$NotifyAction"), new DBField("cannedActions", String.class, DBField.TYPE_STRING(80), "Canned Actions", "edit=2"), new DBField("priority", Integer.TYPE, "UINT16", "Priority", "edit=2"), new DBField("minNotifyAge", Long.TYPE, "UINT32", "Minimum Notify Age", "edit=2"), new DBField("notifyEmail", String.class, DBField.TYPE_EMAIL_LIST(), "Notification EMail Address", "edit=2"), new DBField("emailSubject", String.class, "TEXT", "EMail Subject", "edit=2 utf8=true"), new DBField("emailText", String.class, "TEXT", "EMail Message", "edit=2 editor=textArea utf8=true"), new DBField("smsText", String.class, "TEXT", "SMS Message", "edit=2 editor=textArea utf8=true"), new DBField("useEmailWrapper", Boolean.TYPE, "BOOLEAN", "Use EMail Wrapper", "edit=2"), new DBField("ruleDisable", String.class, DBField.TYPE_STRING(64), "Disabled Rules", "edit=2"), new DBField("ruleEnable", String.class, DBField.TYPE_STRING(64), "Enabled Rules", "edit=2"), new DBField("sendCommand", String.class, "TEXT", "Send Commands", "edit=2"), Rule.newField_isActive(), Rule.newField_description(), Rule.newField_lastUpdateTime(), Rule.newField_lastUpdateUser(true), Rule.newField_creationTime()};
    private static DBFactory<Rule> factory = null;
    private boolean _sysRuleInit = false;
    private Rule _sysRule = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_RULE = new String[]{"rule"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_LIST = new String[]{"list"};

    private static void initRuleFactory() {
        if (ruleFactory == null) {
            Print.logDebug("Initializing RuleFactory ...", new Object[0]);
            ruleFactory = new EventRuleFactory(new EventRuleAction());
            Device.setRuleFactory(ruleFactory);
        }
    }

    public static String GetSysRuleIDFromSelector(String string) {
        if (!StringTools.startsWithIgnoreCase(string, SYSADMIN_RULE_S)) {
            return null;
        }
        if (!StringTools.endsWithIgnoreCase(string, SYSADMIN_RULE_E)) {
            return null;
        }
        String string2 = string.substring(SYSADMIN_RULE_S.length(), string.length() - SYSADMIN_RULE_E.length());
        if (string2.length() <= 0) {
            return null;
        }
        if (string2.indexOf(34) >= 0) {
            Print.logError("Invalid SysAdmin rule specification! " + string, new Object[0]);
            return null;
        }
        return string2;
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName(_TABLE_NAME);
    }

    public static DBFactory<Rule> getFactory() {
        if (factory == null) {
            EnumTools.registerEnumClass(RuleFactory.NotifyAction.class);
            factory = DBFactory.createDBFactory(Rule.TABLE_NAME(), FieldInfo, DBFactory.KeyType.PRIMARY, Rule.class, Key.class, true, true);
            factory.addParentTable(Account.TABLE_NAME());
            Rule.initRuleFactory();
        }
        return factory;
    }

    public Rule() {
    }

    public Rule(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(Rule.class, locale);
        return i18N.getString("Rule.description", "This table defines Account specific Rules.");
    }

    public String getRuleID() {
        String string = (String)this.getFieldValue(FLD_ruleID);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public static boolean isSystemAdminRuleID(String string) {
        if (StringTools.isBlank(string)) {
            return false;
        }
        if (StringTools.isBlank(SYSTEM_RULE_PREFIX)) {
            return false;
        }
        return string.startsWith(SYSTEM_RULE_PREFIX);
    }

    public Rule getSysRuleFromSelector() {
        if (!this._sysRuleInit) {
            this._sysRuleInit = true;
            this._sysRule = null;
            String string = this.getSelector();
            String string2 = Rule.GetSysRuleIDFromSelector(string);
            if (!StringTools.isBlank(string2)) {
                try {
                    String string3 = Account.getSystemAdminAccountID();
                    this._sysRule = Rule.getRule(string3, string2);
                }
                catch (DBException dBException) {
                    Print.logError("Error obtaining sysrule: " + string2 + " [" + dBException + "]", new Object[0]);
                }
            }
        }
        return this._sysRule;
    }

    @Override
    public String getDescription() {
        return super.getDescription();
    }

    public String getDescription(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getDescription();
        }
        return this.getDescription();
    }

    public boolean getIsCronRule() {
        Boolean bl = (Boolean)this.getFieldValue(FLD_isCronRule);
        return bl != null ? bl : false;
    }

    public void setIsCronRule(boolean bl) {
        this.setFieldValue(FLD_isCronRule, bl);
    }

    public boolean getIsCronRule(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getIsCronRule();
        }
        return this.getIsCronRule();
    }

    public boolean hasRuleTag() {
        return !StringTools.isBlank(this.getRuleTag());
    }

    public String getRuleTag() {
        String string = (String)this.getFieldValue(FLD_ruleTag);
        return StringTools.trim(string);
    }

    public void setRuleTag(String string) {
        this.setFieldValue(FLD_ruleTag, StringTools.trim(string));
    }

    public String getRuleTag(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getRuleTag();
        }
        return this.getRuleTag();
    }

    public boolean setSystemRuleSettings() {
        Rule rule = this.getSysRuleFromSelector();
        if (rule != null) {
            this.setIsActive(rule.getIsActive());
            this.setDescription(rule.getDescription());
            this.setIsCronRule(rule.getIsCronRule());
            this.setRuleTag(rule.getRuleTag());
            this.setActionMask(rule.getActionMask());
            this.setMinNotifyAge(rule.getMinNotifyAge());
            this.setCannedActions(rule.getCannedActions());
            this.setEmailSubject(rule.getEmailSubject());
            this.setEmailText(rule.getEmailText());
            this.setSmsText(rule.getSmsText());
        }
        return false;
    }

    public boolean hasSelector() {
        return !this.getSelector().equals(SYSTEM_RULE_PREFIX);
    }

    public String getSelector() {
        String string = (String)this.getFieldValue(FLD_selector);
        return StringTools.trim(string);
    }

    public void setSelector(String string) {
        this.setFieldValue(FLD_selector, StringTools.trim(string));
    }

    public String getSelector(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getSelector();
        }
        return this.getSelector();
    }

    public int getActionMask() {
        Integer n = (Integer)this.getFieldValue(FLD_actionMask);
        return n != null ? RuleFactoryAdapter.ValidateActionMask(n) : 0;
    }

    public void setActionMask(int n) {
        this.setFieldValue(FLD_actionMask, RuleFactoryAdapter.ValidateActionMask(n));
    }

    public int getActionMask(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getActionMask();
        }
        return this.getActionMask();
    }

    public boolean hasCannedActions() {
        return !StringTools.isBlank(this.getCannedActions());
    }

    public String getCannedActions() {
        String string = (String)this.getFieldValue(FLD_cannedActions);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public void setCannedActions(String string) {
        this.setFieldValue(FLD_cannedActions, string != null ? string : SYSTEM_RULE_PREFIX);
    }

    public String getCannedActions(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getCannedActions();
        }
        return this.getCannedActions();
    }

    public int getPriority() {
        Integer n = (Integer)this.getFieldValue(FLD_priority);
        return n != null ? n : 0;
    }

    public void setPriority(int n) {
        this.setFieldValue(FLD_priority, n);
    }

    public int getPriority(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getPriority();
        }
        return this.getPriority();
    }

    public long getMinNotifyAge() {
        Long l = (Long)this.getFieldValue(FLD_minNotifyAge);
        return l != null ? l : 0L;
    }

    public void setMinNotifyAge(long l) {
        this.setFieldValue(FLD_minNotifyAge, l >= 0L ? l : 0L);
    }

    public boolean elapsedMinimumNotifyAge(Account account) {
        if (account == null) {
            return false;
        }
        long l = this.getMinNotifyAge();
        if (l <= 0L) {
            return true;
        }
        long l2 = 0L;
        try {
            l2 = RuleTrigger.getLastRuleTriggerTime(account, this.getRuleID());
            if (l2 <= 0L) {
                return true;
            }
        }
        catch (DBException dBException) {
            Print.logError("Unable to get last RuleTrigger time: " + dBException, new Object[0]);
            return true;
        }
        long l3 = DateTime.getCurrentTimeSec() - l2;
        if (l3 >= l) {
            return true;
        }
        Print.logInfo("Skipping notification, recently notified " + l3 + " seconds ago", new Object[0]);
        return false;
    }

    public boolean elapsedMinimumNotifyAge(Device device) {
        if (device == null) {
            return false;
        }
        long l = this.getMinNotifyAge();
        if (l <= 0L) {
            return true;
        }
        long l2 = 0L;
        try {
            l2 = RuleTrigger.getLastRuleTriggerTime(device, this.getRuleID());
            if (l2 <= 0L) {
                return true;
            }
        }
        catch (DBException dBException) {
            Print.logError("Unable to get last RuleTrigger time: " + dBException, new Object[0]);
            return true;
        }
        long l3 = DateTime.getCurrentTimeSec() - l2;
        if (l3 >= l) {
            return true;
        }
        Print.logInfo("Skipping notification, recently notified " + l3 + " seconds ago", new Object[0]);
        return false;
    }

    public boolean elapsedMinimumNotifyAge(EventData eventData) {
        if (eventData == null) {
            return false;
        }
        return this.elapsedMinimumNotifyAge(eventData.getDevice());
    }

    public String getNotifyEmail() {
        String string = (String)this.getFieldValue(FLD_notifyEmail);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public void setNotifyEmail(String string) {
        this.setFieldValue(FLD_notifyEmail, string != null ? string : SYSTEM_RULE_PREFIX);
    }

    public String getEmailSubject() {
        String string = (String)this.getFieldValue(FLD_emailSubject);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public void setEmailSubject(String string) {
        this.setFieldValue(FLD_emailSubject, string != null ? string : SYSTEM_RULE_PREFIX);
    }

    public String getEmailSubject(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getEmailSubject();
        }
        return this.getEmailSubject();
    }

    public String getEmailText() {
        String string = (String)this.getFieldValue(FLD_emailText);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public void setEmailText(String string) {
        String string2 = string != null ? StringTools.encodeNewline(string) : SYSTEM_RULE_PREFIX;
        this.setFieldValue(FLD_emailText, string2);
    }

    public String getEmailText(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getEmailText();
        }
        return this.getEmailText();
    }

    public String getSmsText() {
        String string = (String)this.getFieldValue(FLD_smsText);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public void setSmsText(String string) {
        String string2 = string != null ? StringTools.encodeNewline(string) : SYSTEM_RULE_PREFIX;
        this.setFieldValue(FLD_smsText, string2);
    }

    public String getSmsText(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getSmsText();
        }
        return this.getSmsText();
    }

    public static String CreateDefaultSmsText(String string, String string2, String string3) {
        if (!StringTools.isBlank(string3)) {
            String string4 = StringTools.trim(string3);
            return string4.replace('\n', ' ').trim();
        }
        String string5 = StringTools.trim(string);
        String string6 = StringTools.trim(string2);
        String string7 = StringTools.trim(string5 + " " + string6);
        return string7.replace('\n', ' ').trim();
    }

    public String getDefaultSmsText(boolean bl) {
        Object object;
        if (bl && (object = this.getSysRuleFromSelector()) != null) {
            return ((Rule)object).getDefaultSmsText(false);
        }
        object = this.getEmailSubject();
        String string = this.getEmailText();
        String string2 = this.getSmsText();
        return Rule.CreateDefaultSmsText((String)object, string, string2);
    }

    public boolean getUseEmailWrapper() {
        Boolean bl = (Boolean)this.getFieldValue(FLD_useEmailWrapper);
        return bl != null ? bl : true;
    }

    public void setUseEmailWrapper(boolean bl) {
        this.setFieldValue(FLD_useEmailWrapper, bl);
    }

    public boolean getUseEmailWrapper(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getUseEmailWrapper();
        }
        return this.getUseEmailWrapper();
    }

    public String getRuleDisable() {
        String string = (String)this.getFieldValue(FLD_ruleDisable);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public void setRuleDisable(String string) {
        this.setFieldValue(FLD_ruleDisable, string != null ? string : SYSTEM_RULE_PREFIX);
    }

    public String getRuleDisable(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getRuleDisable();
        }
        return this.getRuleDisable();
    }

    public String getRuleEnable() {
        String string = (String)this.getFieldValue(FLD_ruleEnable);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public void setRuleEnable(String string) {
        this.setFieldValue(FLD_ruleEnable, string != null ? string : SYSTEM_RULE_PREFIX);
    }

    public String getRuleEnable(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getRuleEnable();
        }
        return this.getRuleEnable();
    }

    public String getSendCommand() {
        String string = (String)this.getFieldValue(FLD_sendCommand);
        return string != null ? string : SYSTEM_RULE_PREFIX;
    }

    public void setSendCommand(String string) {
        this.setFieldValue(FLD_sendCommand, string != null ? string : SYSTEM_RULE_PREFIX);
    }

    public String getSendCommand(boolean bl) {
        Rule rule;
        if (bl && (rule = this.getSysRuleFromSelector()) != null) {
            return rule.getSendCommand();
        }
        return this.getSendCommand();
    }

    @Override
    public String toString() {
        return this.getAccountID() + "/" + this.getRuleID();
    }

    @Override
    public void setCreationDefaultValues() {
        BasicPrivateLabel basicPrivateLabel;
        this.setIsActive(true);
        this.setDescription("New Rule [" + this.getRuleID() + "]");
        this.setActionMask(263);
        Account account = this.getAccount();
        BasicPrivateLabel basicPrivateLabel2 = basicPrivateLabel = account != null ? account.getPrivateLabel() : null;
        if (basicPrivateLabel == null || !basicPrivateLabel.getEventNotificationDefault()) {
            this.setUseEmailWrapper(false);
        } else {
            this.setEmailSubject(basicPrivateLabel.getEventNotificationSubject());
            this.setEmailText(basicPrivateLabel.getEventNotificationBody());
            this.setUseEmailWrapper(false);
        }
        super.setRuntimeDefaultValues();
    }

    public static EventSelector getEventSelector() {
        return EventSelector.getInstance();
    }

    public static boolean checkSelectorSyntax(String string) {
        return Rule.getEventSelector().checkSyntax(string);
    }

    public static Selector.Result getSelectorResult(String string, EventData eventData) throws ParserException {
        return Rule.getEventSelector().getResult(string, eventData);
    }

    public static boolean isSelectorMatch(String string, EventData eventData) throws ParserException {
        Selector.Result result = Rule.getSelectorResult(string, eventData);
        return result != null ? result.isMatch() : false;
    }

    public static Selector.Result getSelectorResult(String string, Device device) throws ParserException {
        return Rule.getEventSelector().getResult(string, device);
    }

    public static boolean isSelectorMatch(String string, Device device) throws ParserException {
        Selector.Result result = Rule.getSelectorResult(string, device);
        return result != null ? result.isMatch() : false;
    }

    public static Selector.Result getSelectorResult(String string, Account account) throws ParserException {
        return Rule.getEventSelector().getResult(string, account);
    }

    public static boolean isSelectorMatch(String string, Account account) throws ParserException {
        Selector.Result result = Rule.getSelectorResult(string, account);
        return result != null ? result.isMatch() : false;
    }

    public static boolean exists(String string, String string2) throws DBException {
        if (string != null && string2 != null) {
            Key key = new Key(string, string2);
            return key.exists();
        }
        return false;
    }

    public static Rule getRule(String string, String string2) throws DBException {
        if (StringTools.isBlank(string)) {
            throw new DBException("AccountID is blank/null");
        }
        if (StringTools.isBlank(string2)) {
            throw new DBException("RuleID is blank/null");
        }
        Key key = new Key(string, string2);
        if (key.exists()) {
            return (Rule)key.getDBRecord(true);
        }
        return null;
    }

    public static Rule getRule(Account account, String string) throws DBException {
        String string2;
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        if (Rule.isSystemAdminRuleID(string) && !account.isSystemAdmin()) {
            string2 = Account.getSystemAdminAccountID();
            if (StringTools.isBlank(string2)) {
                throw new DBException("SystemAdmin AccountID is blank/null");
            }
        } else {
            string2 = account.getAccountID();
        }
        if (StringTools.isBlank(string)) {
            throw new DBException("RuleID is blank/null");
        }
        Key key = new Key(string2, string);
        if (key.exists()) {
            Rule rule = (Rule)key.getDBRecord(true);
            if (rule != null) {
                if (account != null && string2.equals(rule.getAccountID())) {
                    rule.setAccount(account);
                }
                return rule;
            }
            return null;
        }
        return null;
    }

    public static Rule getRule(Account account, String string, boolean bl) throws DBException {
        if (account == null) {
            throw new DBException("Account not specified.");
        }
        String string2 = account.getAccountID();
        if (StringTools.isBlank(string)) {
            throw new DBException("RuleID not specified.");
        }
        if (Rule.isSystemAdminRuleID(string) && !account.isSystemAdmin()) {
            throw new DBException("RuleID not allowed for non system admin.");
        }
        Rule rule = null;
        Key key = new Key(string2, string);
        if (!key.exists()) {
            if (bl) {
                rule = (Rule)key.getDBRecord();
                rule.setAccount(account);
                rule.setCreationDefaultValues();
                return rule;
            }
            throw new DBException("Rule-ID does not exists '" + key + "'");
        }
        if (bl) {
            throw new DBException("Rule-ID already exists '" + key + "'");
        }
        rule = Rule.getRule(account, string);
        if (rule == null) {
            throw new DBException("Unable to read existing Rule-ID '" + key + "'");
        }
        return rule;
    }

    public static Rule createNewRule(Account account, String string) throws DBException {
        Rule rule = Rule.getRule(account, string, true);
        if (rule != null) {
            rule.save();
        }
        return rule;
    }

    public static Collection<String> getRuleIDs(String string, boolean bl, boolean bl2, boolean bl3) throws DBException {
        Vector<String> vector = new Vector<String>();
        Rule._getRuleIDs(string, vector, null, bl, bl2 ? -1 : 0, bl3, null);
        return vector;
    }

    public static Collection<String> getAllRuleIDs(String string, boolean bl) throws DBException {
        return Rule.getRuleIDs(string, false, true, bl);
    }

    public static Map<String, String> getSystemAdminRuleIDMap(boolean bl) throws DBException {
        String string = Account.getSystemAdminAccountID();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Rule._getRuleIDs(string, null, hashMap, true, bl ? -1 : 0, false, null);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _getRuleIDs(String string, List<String> list, Map<String, String> map, boolean bl, int n, boolean bl2, String string2) throws DBException {
        Statement statement;
        DBConnection dBConnection;
        block23: {
            if (list == null && map == null) {
                return;
            }
            if (StringTools.isBlank(string)) {
                return;
            }
            if (bl2 && AccountRecord.isSystemAdminAccountID(string)) {
                bl2 = false;
            }
            dBConnection = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                String string3;
                String string4;
                DBSelect<Rule> dBSelect = new DBSelect<Rule>(Rule.getFactory());
                dBSelect.setSelectedFields(FLD_ruleID, FLD_description);
                dBSelect.setOrderByFields(FLD_ruleID);
                DBWhere dBWhere = dBSelect.createDBWhere();
                int n2 = n < 0 ? -1 : (n == 0 ? 0 : 1);
                String string5 = n2 >= 0 ? dBWhere.EQ(FLD_isCronRule, n2) : null;
                String string6 = string4 = !StringTools.isBlank(string2) ? dBWhere.EQ(FLD_ruleTag, string2) : null;
                if (bl || string5 != null || string4 != null) {
                    dBWhere.append(dBWhere.AND(dBWhere.EQ("accountID", string), bl ? dBWhere.NE(FLD_isActive, 0) : null, string5, string4));
                } else {
                    dBWhere.append(dBWhere.EQ("accountID", string));
                }
                if (bl2 && !StringTools.isBlank(string3 = Account.getSystemAdminAccountID())) {
                    dBWhere.append(dBWhere.OR_(dBWhere.AND(dBWhere.EQ("accountID", string3), dBWhere.NE(FLD_isActive, 0), string5, string4)));
                }
                dBSelect.setWhere(dBWhere.WHERE(dBWhere.toString()));
                dBConnection = DBConnection.getDefaultConnection();
                statement = dBConnection.execute(dBSelect.toString());
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    string3 = resultSet.getString(FLD_ruleID);
                    if (list != null) {
                        list.add(string3);
                    }
                    if (map == null) continue;
                    String string7 = resultSet.getString(FLD_description);
                    map.put(string3, string7);
                }
                if (resultSet == null) break block23;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DBException("Getting Account Rule List", sQLException);
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dBConnection);
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DBConnection.release(dBConnection);
    }

    public static StringBuffer listRules(String string, String string2, int n, StringBuffer stringBuffer) throws DBException {
        Collection<String> collection;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        if (!ListTools.isEmpty(collection = Rule.getRuleIDs(string, false, true, false))) {
            for (String string3 : collection) {
                Rule.listRule(string, string3, string2, n + 2, stringBuffer);
            }
        } else {
            String string4 = StringTools.replicateString(" ", n);
            stringBuffer.append(string4).append("---------------------------------------\n");
            stringBuffer.append(string4).append("No Rules\n");
        }
        return stringBuffer;
    }

    public static StringBuffer listRule(String string, String string2, String string3, int n, StringBuffer stringBuffer) throws DBException {
        Key key;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        if ((key = new Key(string, string2)).exists()) {
            Rule rule = (Rule)key.getDBRecord(true);
            if (StringTools.isBlank(string3) || string3.equalsIgnoreCase(rule.getRuleTag())) {
                return Rule.listRule(rule, n, stringBuffer);
            }
            return stringBuffer;
        }
        String string4 = StringTools.replicateString(" ", n);
        stringBuffer.append(string4).append("---------------------------------------\n");
        stringBuffer.append(string4).append("Rule does not exists: " + string + "/" + string2 + "\n");
        return stringBuffer;
    }

    public static StringBuffer listRule(Rule rule, int n, StringBuffer stringBuffer) throws DBException {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        String string = StringTools.replicateString(" ", n);
        stringBuffer.append(string).append("---------------------------------------\n");
        if (rule != null) {
            String[] stringArray;
            stringBuffer.append(string).append("Rule          : " + rule.getRuleID() + "\n");
            stringBuffer.append(string).append("  Description : " + rule.getDescription() + "\n");
            stringBuffer.append(string).append("  IsActive    : " + rule.getIsActive() + "\n");
            stringBuffer.append(string).append("  IsCronRule  : " + rule.getIsCronRule() + "\n");
            stringBuffer.append(string).append("  RuleTag     : " + rule.getRuleTag() + "\n");
            stringBuffer.append(string).append("  Selector    : " + rule.getSelector() + "\n");
            stringBuffer.append(string).append("  ActionMask  : " + rule.getActionMask() + "\n");
            stringBuffer.append(string).append("  NotifyEMail : " + rule.getNotifyEmail() + "\n");
            stringBuffer.append(string).append("  EMailSubject: " + rule.getEmailSubject() + "\n");
            stringBuffer.append(string).append("  EMailBody   : \n");
            String[] stringArray2 = stringArray = StringTools.split(StringTools.decodeNewline(rule.getEmailText()), '\n');
            int n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String string2 = stringArray2[i];
                stringBuffer.append(string).append("    > " + string2 + "\n");
            }
            stringBuffer.append(string).append("  SMSText     : \n");
            for (String string3 : stringArray2 = StringTools.split(StringTools.decodeNewline(rule.getSmsText()), '\n')) {
                stringBuffer.append(string).append("    > " + string3 + "\n");
            }
        } else {
            stringBuffer.append(string).append("(null rule specified)\n");
        }
        return stringBuffer;
    }

    public boolean clearRuleListEntries() {
        String string = this.getAccountID();
        String string2 = this.getRuleID();
        return RuleList.clearRuleListEntries(string, string2);
    }

    public void setSingleDeviceRuleListEntry(String string, int n) {
        String string2 = this.getAccountID();
        String string3 = this.getRuleID();
        RuleList.setSingleDeviceRuleListEntry(string2, string3, string, n);
    }

    public void setSingleGroupRuleListEntry(String string, int n) {
        String string2 = this.getAccountID();
        String string3 = this.getRuleID();
        RuleList.setSingleGroupRuleListEntry(string2, string3, string, n);
    }

    private static void usage() {
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + Rule.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Common Options:", new Object[0]);
        Print.logInfo("  -account=<id>      Acount ID which owns Rule", new Object[0]);
        Print.logInfo("  -rule=<id>         Rule ID which owns Rule", new Object[0]);
        Print.logInfo("  -create            Create a new Device", new Object[0]);
        Print.logInfo("  -edit              Edit an existing (or newly created) Rule", new Object[0]);
        Print.logInfo("  -delete            Delete specified Rule", new Object[0]);
        Print.logInfo("  -list[=tag]        List defined rules [matching tag]", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        DBConfig.cmdLineInit(stringArray, true);
        String string = RTConfig.getString(ARG_ACCOUNT, SYSTEM_RULE_PREFIX);
        String string2 = RTConfig.getString(ARG_RULE, SYSTEM_RULE_PREFIX);
        if (StringTools.isBlank(string)) {
            Print.logError("Account-ID not specified.", new Object[0]);
            Rule.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(string);
            if (account == null) {
                Print.logError("Account-ID does not exist: " + string, new Object[0]);
                Rule.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException("Error loading Account: " + string, dBException);
            System.exit(99);
        }
        boolean bl = false;
        if (!StringTools.isBlank(string2)) {
            try {
                bl = Rule.exists(string, string2);
            }
            catch (DBException dBException) {
                Print.logError("Error determining if Device exists: " + string + "," + string2, new Object[0]);
                System.exit(99);
            }
        }
        int n = 0;
        if (RTConfig.getBoolean(ARG_DELETE, false)) {
            ++n;
            if (StringTools.isBlank(string2)) {
                Print.logError("Rule-ID not specified.", new Object[0]);
                Rule.usage();
            } else if (!bl) {
                Print.logWarn("Rule does not exist: " + string + "/" + string2, new Object[0]);
                Print.logWarn("Continuing with delete process ...", new Object[0]);
            }
            try {
                object = new Key(string, string2);
                ((DBRecordKey)object).delete(true);
                Print.logInfo("Rule deleted: " + string + "/" + string2, new Object[0]);
            }
            catch (DBException dBException) {
                Print.logError("Error deleting Rule: " + string + "/" + string2, new Object[0]);
                dBException.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean(ARG_CREATE, false)) {
            ++n;
            if (StringTools.isBlank(string2)) {
                Print.logError("Rule-ID not specified.", new Object[0]);
                Rule.usage();
            } else if (bl) {
                Print.logWarn("Rule already exists: " + string + "/" + string2, new Object[0]);
            } else {
                try {
                    object = Rule.createNewRule(account, string2);
                    Print.logInfo("Created Rule: " + string + "/" + string2, new Object[0]);
                    if (RTConfig.hasProperty("code")) {
                        int n2 = RTConfig.getInt("code", 0);
                        ((Rule)object).setSingleDeviceRuleListEntry("*", n2);
                    }
                }
                catch (DBException dBException) {
                    Print.logError("Error creating Rule: " + string + "/" + string2, new Object[0]);
                    dBException.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean(ARG_EDIT, false)) {
            ++n;
            if (string2 == null || string2.equals(SYSTEM_RULE_PREFIX)) {
                Print.logError("Rule-ID not specified.", new Object[0]);
                Rule.usage();
            } else if (!bl) {
                Print.logError("Device does not exist: " + string + "/" + string2, new Object[0]);
            } else {
                try {
                    object = Rule.getRule(account, string2, false);
                    DBEdit dBEdit = new DBEdit((DBRecord)object);
                    dBEdit.edit();
                }
                catch (IOException iOException) {
                    if (iOException instanceof EOFException) {
                        Print.logError("End of input", new Object[0]);
                    } else {
                        Print.logError("IO Error", new Object[0]);
                    }
                }
                catch (DBException dBException) {
                    Print.logError("Error editing Rule: " + string + "/" + string2, new Object[0]);
                    dBException.printException();
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_LIST)) {
            ++n;
            object = RTConfig.getString(ARG_LIST, null);
            StringBuffer stringBuffer = new StringBuffer();
            try {
                if (!StringTools.isBlank(string2)) {
                    Rule.listRule(string, string2, (String)object, 0, stringBuffer);
                } else {
                    Rule.listRules(string, (String)object, 0, stringBuffer);
                }
            }
            catch (DBException dBException) {
                Print.logError("Error listing Rule: " + string + "/" + string2, new Object[0]);
                dBException.printException();
            }
            Print.sysPrintln(stringBuffer.toString(), new Object[0]);
        }
        if (n == 0) {
            Print.logWarn("Missing options ...", new Object[0]);
            Rule.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<Rule> {
        public Key() {
        }

        public Key(String string, String string2) {
            super.setKeyValue("accountID", string != null ? string.toLowerCase() : Rule.SYSTEM_RULE_PREFIX);
            super.setKeyValue(Rule.FLD_ruleID, string2 != null ? string2.toLowerCase() : Rule.SYSTEM_RULE_PREFIX);
        }

        @Override
        public DBFactory<Rule> getFactory() {
            return Rule.getFactory();
        }
    }
}

