/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.util.Locale;
import java.util.Random;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.StatusCode;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.NotificationMessage;
import org.opengts.rule.tables.Rule;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class NotifyQueue
extends DeviceRecord<NotifyQueue>
implements NotificationMessage {
    private static Random random = new Random();
    public static final String _TABLE_NAME = "NotifyQueue";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_messageID = "messageID";
    public static final String FLD_ruleID = "ruleID";
    public static final String FLD_priority = "priority";
    public static final String FLD_sender = "sender";
    public static final String FLD_recipients = "recipients";
    public static final String FLD_subject = "subject";
    public static final String FLD_message = "message";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID(true), DeviceRecord.newField_deviceID(true), new DBField("ruleID", String.class, DBField.TYPE_RULE_ID(), "Rule ID", "key=true"), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", "key=true"), new DBField("statusCode", Integer.TYPE, "UINT32", "Status_Code", "key=true format=X2 editor=statusCode"), new DBField("messageID", String.class, DBField.TYPE_STRING(24), "Message_ID", "altkey=true"), new DBField("priority", Integer.TYPE, "UINT32", "Priority", "edit=2"), new DBField("sender", String.class, DBField.TYPE_STRING(64), "Sender", "edit=2"), new DBField("recipients", String.class, DBField.TYPE_STRING(256), "Recipients", "edit=2"), new DBField("subject", String.class, "TEXT", "Subject", "edit=2 utf8=true"), new DBField("message", String.class, "TEXT", "Message", "edit=2 utf8=true"), NotifyQueue.newField_lastUpdateTime(), NotifyQueue.newField_creationTime()};
    private static DBFactory<NotifyQueue> factory = null;
    private Rule rule = null;

    private static String CreateMessageID(long l) {
        long l2 = (long)random.nextInt() & 0xFFFFFFFFL;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StringTools.toHexString(l, 32));
        stringBuffer.append(StringTools.toHexString(l2, 32));
        return stringBuffer.toString();
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName(_TABLE_NAME);
    }

    public static DBFactory<NotifyQueue> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory(NotifyQueue.TABLE_NAME(), FieldInfo, DBFactory.KeyType.PRIMARY, NotifyQueue.class, Key.class, false, false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public NotifyQueue() {
    }

    public NotifyQueue(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(NotifyQueue.class, locale);
        return i18N.getString("NotifyQueue.description", "This table contains Device specific queued notification messages. Rule-based notification messages may be placed in this table as an alternative to sending an email.  The 'Notification' servlet provides access to the messages within this table.");
    }

    public String getRuleID() {
        String string = (String)this.getFieldValue(FLD_ruleID);
        return string != null ? string : "";
    }

    public void setRuleID(String string) {
        this.setFieldValue(FLD_ruleID, string != null ? string : "");
    }

    public void setRule(Rule rule) {
        if (rule != null) {
            if (StringTools.isBlank(this.getRuleID())) {
                this.rule = rule;
                this.setRuleID(rule.getRuleID());
            } else if (rule.getRuleID().equals(this.getRuleID())) {
                this.rule = rule;
            } else {
                Print.logError("Refusing to set 'Rule' with incompatible RuleID (expected:" + this.getRuleID() + " ==> found:" + rule.getRuleID() + ")", new Object[0]);
            }
        } else {
            this.rule = null;
        }
    }

    public Rule getRule() throws DBException {
        if (this.rule != null) {
            return this.rule;
        }
        if (!StringTools.isBlank(this.getRuleID())) {
            return Rule.getRule(this.getAccountID(), this.getRuleID());
        }
        return null;
    }

    @Override
    public long getTimestamp() {
        Long l = (Long)this.getFieldValue(FLD_timestamp);
        return l != null ? l : 0L;
    }

    public void setTimestamp(long l) {
        this.setFieldValue(FLD_timestamp, l);
    }

    @Override
    public String getTimestampString() {
        Account account = this.getAccount();
        String string = account != null ? account.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String string2 = account != null ? account.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        DateTime dateTime = new DateTime(this.getTimestamp());
        return dateTime.gmtFormat(string + " " + string2 + " z");
    }

    @Override
    public int getStatusCode() {
        Integer n = (Integer)this.getFieldValue(FLD_statusCode);
        return n != null ? n : 0;
    }

    public void setStatusCode(int n) {
        this.setFieldValue(FLD_statusCode, n);
    }

    @Override
    public String getStatusCodeDescription(BasicPrivateLabel basicPrivateLabel) {
        int n;
        Device device = this.getDevice();
        String string = StatusCode.getDescription(device, n = this.getStatusCode(), basicPrivateLabel, null);
        if (StringTools.isBlank(string)) {
            Print.logError("StatusCode description is empty! : 0x" + StringTools.toHexString(n, 16), new Object[0]);
        }
        return string;
    }

    @Override
    public String getMessageID() {
        String string = (String)this.getFieldValue(FLD_messageID);
        return string != null ? string : "";
    }

    public void setMessageID(String string) {
        this.setFieldValue(FLD_messageID, string != null ? string : "");
    }

    public void setMessageID(long l) {
        this.setMessageID(NotifyQueue.CreateMessageID(l));
    }

    @Override
    public int getPriority() {
        Integer n = (Integer)this.getFieldValue(FLD_priority);
        return n != null ? n : 0;
    }

    public void setPriority(int n) {
        this.setFieldValue(FLD_priority, n);
    }

    @Override
    public String getSender() {
        String string = (String)this.getFieldValue(FLD_sender);
        return string != null ? string : "";
    }

    public void setSender(String string) {
        this.setFieldValue(FLD_sender, string != null ? string : "");
    }

    @Override
    public String getRecipients() {
        String string = (String)this.getFieldValue(FLD_recipients);
        return string != null ? string : "";
    }

    public void setRecipients(String string) {
        this.setFieldValue(FLD_recipients, string != null ? string : "");
    }

    @Override
    public String getSubject() {
        String string = (String)this.getFieldValue(FLD_subject);
        return string != null ? string : "";
    }

    public void setSubject(String string) {
        this.setFieldValue(FLD_subject, string != null ? string : "");
    }

    public String getMessage() {
        String string = (String)this.getFieldValue(FLD_message);
        return string != null ? string : "";
    }

    public void setMessage(String string) {
        this.setFieldValue(FLD_message, string != null ? string : "");
    }

    @Override
    public String getBody() {
        return this.getMessage();
    }

    @Override
    public String toString() {
        return this.getAccountID() + "/" + this.getDeviceID() + "/" + this.getTimestamp();
    }

    public static void getRecordCallback(String string, String string2, long l, long l2, DBRecordHandler<NotifyQueue> dBRecordHandler) throws DBException {
        if (StringTools.isBlank(string) || StringTools.isBlank(string2)) {
            return;
        }
        if (dBRecordHandler == null) {
            return;
        }
        DBWhere dBWhere = new DBWhere(NotifyQueue.getFactory());
        dBWhere.append(dBWhere.AND(dBWhere.EQ("accountID", string), dBWhere.EQ("deviceID", string2)));
        if (l >= 0L) {
            dBWhere.append(dBWhere.AND_(dBWhere.GE(FLD_timestamp, l)));
        }
        if (l2 >= 0L && l2 >= l) {
            dBWhere.append(dBWhere.AND_(dBWhere.LE(FLD_timestamp, l2)));
        }
        DBSelect<NotifyQueue> dBSelect = new DBSelect<NotifyQueue>(NotifyQueue.getFactory());
        dBSelect.setWhere(dBWhere.WHERE(dBWhere.toString()));
        dBSelect.setOrderByFields(FLD_timestamp);
        dBSelect.setOrderAscending(true);
        DBRecord.select(dBSelect, dBRecordHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotificationMessage[] getNotificationMessages(String string, String string2, int n, int n2) {
        String string3;
        DBWhere dBWhere = new DBWhere(NotifyQueue.getFactory());
        if (string != null && !string.equals("") && !string.equals("*")) {
            dBWhere.append(dBWhere.EQ("accountID", string));
            if (string2 != null && !string2.equals("") && !string2.equals("*")) {
                dBWhere.append(dBWhere.AND_(dBWhere.EQ("deviceID", string2)));
            }
            if (n > 0) {
                dBWhere.append(dBWhere.AND_(dBWhere.EQ(FLD_priority, n)));
            }
        } else if (n > 0) {
            dBWhere.append(dBWhere.EQ(FLD_priority, n));
        }
        if ((string3 = dBWhere.toString()).equals("")) {
            Print.logInfo("NotifyQueue WHERE: <retrieving all messages>", new Object[0]);
        } else {
            Print.logInfo("NotifyQueue WHERE: " + dBWhere.toString(), new Object[0]);
        }
        NotifyQueue[] notifyQueueArray = null;
        try {
            DBProvider.lockTables(new String[]{NotifyQueue.TABLE_NAME()}, null);
            notifyQueueArray = (NotifyQueue[])DBRecord.select(NotifyQueue.getFactory(), (String)string3, null, (String[])new String[]{FLD_messageID}, (boolean)true, (long)n2, (long)-1L, null);
        }
        catch (DBException dBException) {
            notifyQueueArray = null;
            Print.logException("Retrieving NotifyQueue records", dBException);
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dBException) {}
        }
        return notifyQueueArray;
    }

    public static boolean deleteMessageID(String string) {
        try {
            Key key = new Key(string);
            if (key.altIndexExists("altIndex")) {
                key.altIndexDelete("altIndex");
                return true;
            }
            Print.logError("MessageID does not exist: " + string, new Object[0]);
            return false;
        }
        catch (DBException dBException) {
            Print.logException("Unable to delete MessageID: " + string, dBException);
            return false;
        }
    }

    @Override
    public void setCreationDefaultValues() {
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit(stringArray, true);
        String string = "opendmtp";
        String string2 = "mobile";
        EventRuleAction._debugSendNotification(string, string2, 61472);
    }

    public static class Key
    extends DeviceRecord.DeviceKey<NotifyQueue> {
        public Key() {
        }

        public Key(String string, String string2, String string3, long l, int n) {
            super.setKeyValue("accountID", string != null ? string.toLowerCase() : "");
            super.setKeyValue("deviceID", string2 != null ? string2.toLowerCase() : "");
            super.setKeyValue(NotifyQueue.FLD_ruleID, string3 != null ? string3.toLowerCase() : "");
            super.setKeyValue(NotifyQueue.FLD_timestamp, l);
            super.setKeyValue(NotifyQueue.FLD_statusCode, n);
            super.setKeyValue(NotifyQueue.FLD_messageID, NotifyQueue.CreateMessageID(l));
        }

        public Key(String string) {
            String string2;
            String string3 = string2 = string != null ? string.toUpperCase().trim() : "";
            if (!string2.equals("")) {
                super.setFieldValue(NotifyQueue.FLD_messageID, string2);
            } else {
                Print.logStackTrace("Invalid Alternate Key MessageID specified!");
            }
        }

        @Override
        public DBFactory<NotifyQueue> getFactory() {
            return NotifyQueue.getFactory();
        }
    }
}

