/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.rule.tables.GeoCorridorList;
import org.opengts.rule.util.GeoSegment;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeozoneChecker;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class GeoCorridor
extends AccountRecord<GeoCorridor> {
    public static final double MIN_RADIUS_METERS = 5.0;
    public static final double MAX_RADIUS_METERS = 3000.0;
    private static GeozoneChecker GeoSegmentChecker = null;
    private List<GeoPoint> geoPointList = null;
    public static final String _TABLE_NAME = "GeoCorridor";
    public static final String FLD_corridorID = "corridorID";
    public static final String FLD_radius = "radius";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID(true), new DBField("corridorID", String.class, DBField.TYPE_CORR_ID(), "GeoCorridor ID", "key=true"), new DBField("radius", Integer.TYPE, "UINT32", "Radius Meters", "edit=2"), GeoCorridor.newField_displayName(), GeoCorridor.newField_description(), GeoCorridor.newField_lastUpdateTime(), GeoCorridor.newField_lastUpdateUser(true), GeoCorridor.newField_creationTime()};
    private static DBFactory<GeoCorridor> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_CORRIDOR = new String[]{"corridor", "corr"};
    private static final String[] ARG_RADIUS = new String[]{"radius", "r"};
    private static final String[] ARG_POINTS = new String[]{"points", "pt"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_EDITALL = new String[]{"editall", "eda"};
    private static final String[] ARG_LIST = new String[]{"list"};

    private static void initGeoCorridor() {
        if (GeoSegmentChecker == null) {
            try {
                MethodAction methodAction = new MethodAction((Object)"org.opengts.rule.util.GeoSegment", "getGeozoneChecker");
                GeoSegmentChecker = (GeozoneChecker)methodAction.invoke();
                Print.logDebug("Initialed GeoCorridor/GeoSegment ...", new Object[0]);
            }
            catch (Throwable throwable) {
                Print.logDebug("GeoCorridor not supported.", new Object[0]);
                GeoSegmentChecker = null;
            }
        }
    }

    public static boolean isGeoCorridorSupported() {
        return GeoSegmentChecker != null;
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName(_TABLE_NAME);
    }

    public static DBFactory<GeoCorridor> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory(GeoCorridor.TABLE_NAME(), FieldInfo, DBFactory.KeyType.PRIMARY, GeoCorridor.class, Key.class, true, true);
            factory.addParentTable(Account.TABLE_NAME());
            GeoCorridor.initGeoCorridor();
        }
        return factory;
    }

    public GeoCorridor() {
    }

    public GeoCorridor(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(GeoCorridor.class, locale);
        return i18N.getString("GeoCorridor.description", "This table defines Account GeoCorridors.");
    }

    public String getCorridorID() {
        String string = (String)this.getFieldValue(FLD_corridorID);
        return StringTools.trim(string);
    }

    public void setCorridorID(String string) {
        this.setFieldValue(FLD_corridorID, StringTools.trim(string));
    }

    public double getRadiusMeters() {
        return this.getRadius();
    }

    public double getRadiusMeters(double d, double d2) {
        double d3 = this.getRadius();
        if (d >= 0.0 && d3 < d) {
            return d;
        }
        if (d2 >= 0.0 && d3 > d2) {
            return d2;
        }
        return d3;
    }

    public double getRadiusKilometers() {
        return (double)this.getRadius() / 1000.0;
    }

    public int getRadius() {
        Integer n = (Integer)this.getFieldValue(FLD_radius);
        return n != null ? n : 0;
    }

    public void setRadius(int n) {
        this.setFieldValue(FLD_radius, n);
    }

    @Override
    public String toString() {
        return this.getAccountID() + "/" + this.getCorridorID();
    }

    protected static DBSelect _getCorridorListSelect(String string, String string2) {
        if (StringTools.isBlank(string)) {
            return null;
        }
        if (StringTools.isBlank(string2)) {
            return null;
        }
        DBSelect<GeoCorridorList> dBSelect = new DBSelect<GeoCorridorList>(GeoCorridorList.getFactory());
        DBWhere dBWhere = dBSelect.createDBWhere();
        dBSelect.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", string), dBWhere.EQ(FLD_corridorID, string2))));
        dBSelect.setOrderByFields("sortID");
        return dBSelect;
    }

    public List<GeoPoint> getGeoPoints() throws DBException {
        if (this.geoPointList != null) {
            return this.geoPointList;
        }
        List<GeoPoint> list = this.geoPointList = new Vector<GeoPoint>();
        DBSelect dBSelect = GeoCorridor._getCorridorListSelect(this.getAccountID(), this.getCorridorID());
        if (dBSelect == null) {
            return list;
        }
        DBConnection dBConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            dBConnection = DBConnection.getDefaultConnection();
            statement = dBConnection.execute(dBSelect.toString());
            resultSet = statement.getResultSet();
            while (resultSet.next()) {
                String string = resultSet.getString("accountID");
                String string2 = resultSet.getString(FLD_corridorID);
                int n = resultSet.getInt("sortID");
                GeoCorridorList geoCorridorList = new GeoCorridorList(new GeoCorridorList.Key(string, string2, n));
                geoCorridorList.setAllFieldValues(resultSet);
                geoCorridorList.getGeoPoints(list);
            }
        }
        catch (SQLException sQLException) {
            throw new DBException("Get GeoCorridor List", sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
            DBConnection.release(dBConnection);
        }
        return list;
    }

    public void clearGeoPoints() throws DBException {
        String string = this.getAccountID();
        String string2 = this.getCorridorID();
        this.geoPointList = null;
        DBConnection dBConnection = null;
        try {
            DBDelete dBDelete = new DBDelete(GeoCorridorList.getFactory());
            DBWhere dBWhere = dBDelete.createDBWhere();
            dBDelete.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", string), dBWhere.EQ(FLD_corridorID, string2))));
            dBConnection = DBConnection.getDefaultConnection();
            dBConnection.executeUpdate(dBDelete.toString());
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException("GeoCorridorList deletion", sQLException);
            }
            catch (Throwable throwable) {
                DBConnection.release(dBConnection);
                throw throwable;
            }
        }
        DBConnection.release(dBConnection);
    }

    public void setGeoPoints(List<GeoPoint> list) throws DBException {
        String string = this.getAccountID();
        String string2 = this.getCorridorID();
        this.clearGeoPoints();
        if (!ListTools.isEmpty(list)) {
            int n = 0;
            int n2 = 0;
            while (n2 < list.size()) {
                GeoCorridorList geoCorridorList = new GeoCorridorList(new GeoCorridorList.Key(string, string2, n++));
                n2 = geoCorridorList.setGeoPoints(list, n2);
                geoCorridorList.insert();
            }
        }
    }

    public boolean containsPoint(GeoPoint geoPoint) throws DBException {
        if (GeoSegmentChecker != null) {
            List<GeoPoint> list = this.getGeoPoints();
            GeoPoint[] geoPointArray = list.toArray(new GeoPoint[list.size()]);
            double d = this.getRadiusKilometers();
            boolean bl = GeoSegmentChecker.containsPoint(geoPoint, geoPointArray, d);
            Print.logDebug("[" + this.getCorridorID() + "] Contains Point: " + bl, new Object[0]);
            return bl;
        }
        throw new DBException("'GeoCorridor.containsPoint' not supported");
    }

    public double getLengthKilometers() throws DBException {
        List<GeoPoint> list = this.getGeoPoints();
        int n = list.size();
        if (n <= 1) {
            return 0.0;
        }
        GeoPoint geoPoint = list.get(0);
        double d = 0.0;
        for (int i = 1; i < n; ++i) {
            GeoPoint geoPoint2 = list.get(i);
            double d2 = geoPoint.kilometersToPoint(geoPoint2);
            if (d2 != Double.NaN) {
                d += d2;
            } else {
                Print.logWarn("GeoCorridor contains invalid data: " + this, new Object[0]);
            }
            geoPoint = geoPoint2;
        }
        return d;
    }

    public double getLengthMeters() throws DBException {
        return this.getLengthKilometers() * 1000.0;
    }

    public int getDirectionOfTravel(GeoPoint geoPoint, double d) throws DBException {
        return GeoSegment.getDirectionOfTravel(geoPoint, d, this.getGeoPoints(), this.getRadiusKilometers());
    }

    @Override
    public void setCreationDefaultValues() {
    }

    public static boolean exists(String string, String string2) throws DBException {
        if (string != null && string2 != null) {
            Key key = new Key(string, string2);
            return key.exists();
        }
        return false;
    }

    public static GeoCorridor getGeoCorridor(Account account, String string) throws DBException {
        if (account != null && string != null) {
            String string2 = account.getAccountID();
            Key key = new Key(string2, string);
            if (key.exists()) {
                GeoCorridor geoCorridor = (GeoCorridor)key.getDBRecord(true);
                geoCorridor.setAccount(account);
                return geoCorridor;
            }
            return null;
        }
        return null;
    }

    public static GeoCorridor getGeoCorridor(Account account, String string, boolean bl) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String string2 = account.getAccountID();
        if (StringTools.isBlank(string)) {
            throw new DBNotFoundException("Corridor-ID not specified for account: " + string2);
        }
        GeoCorridor geoCorridor = null;
        Key key = new Key(string2, string);
        if (!key.exists()) {
            if (bl) {
                geoCorridor = (GeoCorridor)key.getDBRecord();
                geoCorridor.setAccount(account);
                geoCorridor.setCreationDefaultValues();
                return geoCorridor;
            }
            throw new DBNotFoundException("Corridor-ID does not exists: " + key);
        }
        if (bl) {
            throw new DBAlreadyExistsException("Corridor-ID already exists '" + key + "'");
        }
        geoCorridor = GeoCorridor.getGeoCorridor(account, string);
        if (geoCorridor == null) {
            throw new DBException("Unable to read existing Corridor-ID: " + key);
        }
        return geoCorridor;
    }

    public static String[] getCorridorIDsForAccount(String string) throws DBException {
        if (StringTools.isBlank(string)) {
            return new String[0];
        }
        DBWhere dBWhere = new DBWhere(GeoCorridor.getFactory());
        dBWhere.append(dBWhere.EQ("accountID", string));
        String string2 = dBWhere.WHERE(dBWhere.toString());
        DBSelect<GeoCorridor> dBSelect = new DBSelect<GeoCorridor>(GeoCorridor.getFactory());
        dBSelect.setWhere(string2);
        dBSelect.setOrderByFields(FLD_corridorID);
        return GeoCorridor.getCorridorIDs(dBSelect);
    }

    public static String[] getCorridorIDs(DBSelect<GeoCorridor> dBSelect) throws DBException {
        if (dBSelect == null) {
            return new String[0];
        }
        OrderedSet<String> orderedSet = new OrderedSet<String>(true);
        DBConnection dBConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            dBConnection = DBConnection.getDefaultConnection();
            statement = dBConnection.execute(dBSelect.toString());
            resultSet = statement.getResultSet();
            while (resultSet.next()) {
                String string = resultSet.getString(FLD_corridorID);
                orderedSet.add(string);
            }
        }
        catch (SQLException sQLException) {
            throw new DBException("Getting GeoCorridor ID List", sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
            DBConnection.release(dBConnection);
        }
        return orderedSet.toArray((K[])new String[orderedSet.size()]);
    }

    private static String _fmtCorridorID(String string, String string2) {
        return string + "/" + string2;
    }

    private static void usage() {
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + GeoCorridor.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Common Options:", new Object[0]);
        Print.logInfo("  -account=<id>      Acount ID which owns Device", new Object[0]);
        Print.logInfo("  -corridor=<id>     GeoCorridor ID to create/edit", new Object[0]);
        Print.logInfo("  -radius=<meters>   Radius in meters", new Object[0]);
        Print.logInfo("  -points=<pts>      GeoPoints (lat/lon,lat/lon,...)", new Object[0]);
        Print.logInfo("  -list              List existing GeoCorridor", new Object[0]);
        Print.logInfo("  -create            Create a new GeoCorridor", new Object[0]);
        Print.logInfo("  -edit              Edit an existing (or newly created) GeoCorridor", new Object[0]);
        Print.logInfo("  -delete            Delete specified GeoCorridor", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        DBConfig.cmdLineInit(stringArray, true);
        String string = RTConfig.getString(ARG_ACCOUNT, "");
        String string2 = RTConfig.getString(ARG_CORRIDOR, "");
        if (StringTools.isBlank(string)) {
            Print.logError("Account-ID not specified.", new Object[0]);
            GeoCorridor.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(string);
            if (account == null) {
                Print.logError("Account-ID does not exist: " + string, new Object[0]);
                GeoCorridor.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException("Error loading Account: " + string, dBException);
            System.exit(99);
        }
        if (StringTools.isBlank(string2)) {
            Print.logError("Corridor-ID not specified.", new Object[0]);
            GeoCorridor.usage();
        }
        boolean bl = false;
        try {
            bl = GeoCorridor.exists(string, string2);
        }
        catch (DBException dBException) {
            Print.logError("Error determining if GeoCorridor exists: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
            System.exit(99);
        }
        int n = 0;
        if (RTConfig.getBoolean(ARG_DELETE, false) && !string.equals("") && !string2.equals("")) {
            ++n;
            if (!bl) {
                Print.logWarn("GeoCorridor does not exist: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
                Print.logWarn("Continuing with delete process ...", new Object[0]);
            }
            try {
                object = new Key(string, string2);
                ((DBRecordKey)object).delete(true);
                Print.logInfo("GeoCorridor deleted: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
                bl = false;
            }
            catch (DBException dBException) {
                Print.logError("Error deleting GeoCorridor: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
                dBException.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean(ARG_CREATE, false)) {
            ++n;
            if (bl) {
                Print.logWarn("GeoCorridor already exists: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
            } else {
                try {
                    object = GeoCorridor.getGeoCorridor(account, string2, true);
                    int n2 = RTConfig.getInt(ARG_RADIUS, 1000);
                    String[] stringArray2 = StringTools.split(RTConfig.getString(ARG_POINTS, ""), ',');
                    Vector<GeoPoint> cloneable = new Vector<GeoPoint>();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        GeoPoint geoPoint = new GeoPoint(stringArray2[i]);
                        if (!geoPoint.isValid()) continue;
                        cloneable.add(geoPoint);
                    }
                    ((GeoCorridor)object).setRadius(n2);
                    ((GeoCorridor)object).setGeoPoints(cloneable);
                    ((DBRecord)object).save();
                    Print.logInfo("Created GeoCorridor: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
                    bl = true;
                }
                catch (DBException dBException) {
                    Print.logError("Error creating GeoCorridor: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
                    dBException.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean(ARG_LIST, false)) {
            ++n;
            if (!bl) {
                Print.logWarn("GeoCorridor does not exist: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
                System.exit(99);
            }
            try {
                object = GeoCorridor.getGeoCorridor(account, string2, false);
                List<GeoPoint> list = ((GeoCorridor)object).getGeoPoints();
                Print.sysPrintln("GeoCorridor  : " + GeoCorridor._fmtCorridorID(((AccountRecord)object).getAccountID(), ((GeoCorridor)object).getCorridorID()), new Object[0]);
                Print.sysPrintln("Description  : " + ((DBRecord)object).getDescription(), new Object[0]);
                Print.sysPrintln("Radius Meters: " + ((GeoCorridor)object).getRadius(), new Object[0]);
                for (GeoPoint geoPoint : list) {
                    Print.sysPrintln("       Point : " + geoPoint, new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError("Error listing GeoCorridor: " + GeoCorridor._fmtCorridorID(string, string2), new Object[0]);
                dBException.printException();
                System.exit(99);
            }
            System.exit(1);
        }
        if (n == 0) {
            Print.logWarn("Missing options ...", new Object[0]);
            GeoCorridor.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<GeoCorridor> {
        public Key() {
        }

        public Key(String string, String string2) {
            super.setKeyValue("accountID", string != null ? string.toLowerCase() : "");
            super.setKeyValue(GeoCorridor.FLD_corridorID, string2 != null ? string2.toLowerCase() : "");
        }

        @Override
        public DBFactory<GeoCorridor> getFactory() {
            return GeoCorridor.getFactory();
        }
    }
}

