/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.util.Locale;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.FuelManager;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class FuelRegister
extends DeviceRecord<FuelRegister> {
    private static boolean DEBUG_MODE = false;
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_latitude = "latitude";
    public static final String FLD_longitude = "longitude";
    public static final String FLD_fuelLevel = "fuelLevel";
    public static final String FLD_deltaFuelLevel = "deltaFuelLevel";
    public static final String FLD_isIncrease = "isIncrease";
    public static final String FLD_fuelTotal = "fuelTotal";
    public static final String FLD_odometerKM = "odometerKM";
    public static final String FLD_subdivision = "subdivision";
    public static final String FLD_address = "address";
    private static DBField[] FieldInfo = new DBField[]{FuelRegister.newField_accountID(true), FuelRegister.newField_deviceID(true), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", "key=true"), new DBField("statusCode", Integer.TYPE, "UINT32", "Status Code", "editor=statusCode format=X2"), new DBField("latitude", Double.TYPE, "DOUBLE", "Latitude", "format=#0.00000"), new DBField("longitude", Double.TYPE, "DOUBLE", "Longitude", "format=#0.00000"), new DBField("fuelLevel", Double.TYPE, "DOUBLE", "Fuel Level", "format=#0.00"), new DBField("deltaFuelLevel", Double.TYPE, "DOUBLE", "Delta Fuel Level", "format=#0.00"), new DBField("isIncrease", Boolean.TYPE, "BOOLEAN", "Is Fuel Increase", ""), new DBField("fuelTotal", Double.TYPE, "DOUBLE", "Total Fuel Used", "format=#0.0 units=volume"), new DBField("odometerKM", Double.TYPE, "DOUBLE", "Odometer KM", "format=#0.0 units=distance"), new DBField("subdivision", String.class, DBField.TYPE_STRING(32), "Subdivision", "utf8=true"), new DBField("address", String.class, DBField.TYPE_ADDRESS(), "Address", "utf8=true"), FuelRegister.newField_creationTime()};
    private static DBFactory<FuelRegister> factory = null;
    private EventData _cacheEventData = null;
    private static FuelManager fuelManager = null;
    private static final String[] ARG_TEST = new String[]{"test"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName("FuelRegister");
    }

    public static DBFactory<FuelRegister> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory(FuelRegister.TABLE_NAME(), FieldInfo, DBFactory.KeyType.PRIMARY, FuelRegister.class, Key.class, false, false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
            FuelRegister.initFuelManager();
        }
        return factory;
    }

    public FuelRegister() {
    }

    public FuelRegister(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(FuelRegister.class, locale);
        return i18N.getString("FuelRegister.description", "This table defines Fuel regsiter information.");
    }

    public long getTimestamp() {
        return this.getFieldValue(FLD_timestamp, 0L);
    }

    public void setTimestamp(long l) {
        this.setFieldValue(FLD_timestamp, l);
    }

    public String getTimestampString() {
        Account account = this.getAccount();
        String string = account != null ? account.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String string2 = account != null ? account.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        DateTime dateTime = new DateTime(this.getTimestamp());
        return dateTime.gmtFormat(string + " " + string2 + " z");
    }

    public int getStatusCode() {
        return this.getFieldValue(FLD_statusCode, 0);
    }

    public void setStatusCode(int n) {
        this.setFieldValue(FLD_statusCode, n);
    }

    public double getLatitude() {
        return this.getFieldValue(FLD_latitude, 0.0);
    }

    public void setLatitude(double d) {
        this.setFieldValue(FLD_latitude, d);
    }

    public GeoPoint getGeoPoint() {
        return new GeoPoint(this.getLatitude(), this.getLongitude());
    }

    public void setGeoPoint(double d, double d2) {
        this.setLatitude(d);
        this.setLongitude(d2);
    }

    public void setGeoPoint(GeoPoint geoPoint) {
        if (geoPoint != null && geoPoint.isValid()) {
            this.setLatitude(geoPoint.getLatitude());
            this.setLongitude(geoPoint.getLongitude());
        } else {
            Print.logInfo("GeoPoint is invalid: " + geoPoint, new Object[0]);
            this.setLatitude(0.0);
            this.setLongitude(0.0);
        }
    }

    public boolean isValidGeoPoint() {
        return GeoPoint.isValid(this.getLatitude(), this.getLongitude());
    }

    public double getLongitude() {
        return this.getFieldValue(FLD_longitude, 0.0);
    }

    public void setLongitude(double d) {
        this.setFieldValue(FLD_longitude, d);
    }

    public double getFuelLevel() {
        return this.getFieldValue(FLD_fuelLevel, 0.0);
    }

    public void setFuelLevel(double d) {
        double d2 = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        this.setFieldValue(FLD_fuelLevel, d2);
    }

    public double getDeltaFuelLevel() {
        return this.getFieldValue(FLD_deltaFuelLevel, 0.0);
    }

    public void setDeltaFuelLevel(double d) {
        double d2 = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        this.setFieldValue(FLD_deltaFuelLevel, d2);
    }

    public boolean getIsIncrease() {
        Boolean bl = (Boolean)this.getFieldValue(FLD_isIncrease);
        return bl != null ? bl : false;
    }

    public void setIsIncrease(boolean bl) {
        this.setFieldValue(FLD_isIncrease, bl);
    }

    public double getLastFuelLevel() {
        double d = this.getFuelLevel();
        double d2 = this.getDeltaFuelLevel();
        boolean bl = this.getIsIncrease();
        return d - d2;
    }

    public double getFuelTotal() {
        return this.getFieldValue(FLD_fuelTotal, 0.0);
    }

    public void setFuelTotal(double d) {
        this.setFieldValue(FLD_fuelTotal, d);
    }

    public double getOdometerKM() {
        return this.getFieldValue(FLD_odometerKM, 0.0);
    }

    public void setOdometerKM(double d) {
        this.setFieldValue(FLD_odometerKM, d);
    }

    public String getEventSubdivision(boolean bl) {
        String string = this.getSubdivision();
        if (StringTools.isBlank(string)) {
            EventData eventData = this.getEventData();
            String string2 = string = eventData != null ? eventData.getSubdivision() : "";
            if (!StringTools.isBlank(string)) {
                this.setSubdivision(string);
                if (bl) {
                    try {
                        this.update(FLD_subdivision);
                    }
                    catch (DBException dBException) {
                        Print.logError("Unable to get EventData address", dBException);
                    }
                }
            }
        }
        return string;
    }

    public String getSubdivision() {
        String string = (String)this.getFieldValue(FLD_subdivision);
        return StringTools.trim(string);
    }

    public void setSubdivision(String string) {
        this.setFieldValue(FLD_subdivision, StringTools.trim(string));
    }

    public String getEventAddress(boolean bl) {
        String string = this.getAddress();
        if (StringTools.isBlank(string)) {
            EventData eventData = this.getEventData();
            String string2 = string = eventData != null ? eventData.getAddress() : "";
            if (!StringTools.isBlank(string)) {
                this.setAddress(string);
                if (bl) {
                    try {
                        this.update(FLD_address);
                    }
                    catch (DBException dBException) {
                        Print.logError("Unable to get EventData address", dBException);
                    }
                }
            }
        }
        return string;
    }

    public String getAddress() {
        String string = (String)this.getFieldValue(FLD_address);
        return StringTools.trim(string);
    }

    public void setAddress(String string) {
        this.setFieldValue(FLD_address, StringTools.trim(string));
    }

    private void _setEventDataFields(EventData eventData, double d, boolean bl) {
        if (eventData == null) {
            return;
        }
        this.setStatusCode(eventData.getStatusCode());
        this.setLatitude(eventData.getLatitude());
        this.setLongitude(eventData.getLongitude());
        this.setOdometerKM(eventData.getOdometerKM());
        this.setAddress(eventData.getAddress());
        this.setSubdivision(eventData.getSubdivision());
        this.setFuelTotal(eventData.getFuelTotal());
        this.setFuelLevel(eventData.getFuelLevel(true));
        this.setDeltaFuelLevel(d);
        this.setIsIncrease(bl);
    }

    public EventData getEventData() {
        if (this._cacheEventData == null) {
            try {
                String string = this.getAccountID();
                String string2 = this.getDeviceID();
                long l = this.getTimestamp();
                int n = this.getStatusCode();
                this._cacheEventData = EventData.getEventData(string, string2, l, n);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this._cacheEventData;
    }

    private static void initFuelManager() {
        boolean bl = RTConfig.getBoolean("FuelRegister.installFuelManager", false);
        if (bl && fuelManager == null) {
            Print.logDebug("Initializing FuelManager ...", new Object[0]);
            fuelManager = new FuelManager(){

                @Override
                public FuelManager.LevelChangeType insertFuelLevelChange(EventData eventData) {
                    try {
                        return FuelRegister.insertFuelLevelChange(eventData);
                    }
                    catch (Throwable throwable) {
                        return FuelManager.LevelChangeType.UNKNOWN;
                    }
                }
            };
            Device.setFuelManager(fuelManager);
        }
    }

    public static boolean getIgnoreNegativeFuelLevels() {
        return RTConfig.getBoolean("FuelRegister.ignoreNegativeFuelLevels", true);
    }

    public static boolean getIgnoreZeroFuelLevels() {
        return RTConfig.getBoolean("FuelRegister.ignoreZeroFuelLevels", true);
    }

    public static boolean getIgnoreWhileMoving() {
        return RTConfig.getBoolean("FuelRegister.ignoreWhileMoving", false);
    }

    public static double getLevelIncreaseThreshold() {
        return RTConfig.getDouble("FuelRegister.levelIncreaseThreshold", 0.5);
    }

    public static double getLevelDecreaseThreshold() {
        return RTConfig.getDouble("FuelRegister.levelDecreaseThreshold", 0.3);
    }

    public static FuelManager.LevelChangeType insertFuelLevelChange(EventData eventData) {
        double d = FuelRegister.getLevelIncreaseThreshold();
        double d2 = FuelRegister.getLevelDecreaseThreshold();
        if (eventData == null) {
            return FuelManager.LevelChangeType.UNKNOWN;
        }
        Device device = eventData.getDevice();
        if (device == null) {
            return FuelManager.LevelChangeType.UNKNOWN;
        }
        String string = device.getAccountID();
        String string2 = device.getDeviceID();
        long l = eventData.getTimestamp();
        int n = eventData.getStatusCode();
        double d3 = eventData.getFuelLevel(true);
        double d4 = device.getLastFuelLevel();
        double d5 = d3 - d4;
        if (n == 63825) {
            try {
                FuelRegister fuelRegister = FuelRegister.getFuelRegister(string, string2, l, true);
                fuelRegister._setEventDataFields(eventData, d5, true);
                if (!DEBUG_MODE) {
                    fuelRegister.save();
                }
                Print.logInfo("Explicit fuel increase (refill)", new Object[0]);
                return FuelManager.LevelChangeType.INCREASE;
            }
            catch (DBException dBException) {
                Print.logError("Error creating new FuelRegister: " + dBException, new Object[0]);
                return FuelManager.LevelChangeType.UNKNOWN;
            }
        }
        if (n == 63826) {
            try {
                FuelRegister fuelRegister = FuelRegister.getFuelRegister(string, string2, l, true);
                fuelRegister._setEventDataFields(eventData, d5, false);
                if (!DEBUG_MODE) {
                    fuelRegister.save();
                }
                Print.logInfo("Explicit fuel decrease (theft)", new Object[0]);
                return FuelManager.LevelChangeType.DECREASE;
            }
            catch (DBException dBException) {
                Print.logError("Error creating new FuelRegister: " + dBException, new Object[0]);
                return FuelManager.LevelChangeType.UNKNOWN;
            }
        }
        if (d3 < 0.0 && FuelRegister.getIgnoreNegativeFuelLevels()) {
            Print.logDebug("Fuel level % is < zero, ignoring fuel level checks", new Object[0]);
            return FuelManager.LevelChangeType.UNKNOWN;
        }
        if (d3 == 0.0 && FuelRegister.getIgnoreZeroFuelLevels()) {
            Print.logDebug("Fuel level % is zero, ignoring fuel level checks", new Object[0]);
            return FuelManager.LevelChangeType.UNKNOWN;
        }
        if (eventData.getSpeedKPH() > 0.0 && FuelRegister.getIgnoreWhileMoving()) {
            Print.logDebug("Vehicle moving, ignoring fuel level checks", new Object[0]);
            return FuelManager.LevelChangeType.NONE;
        }
        if (d > 0.0 && d5 > d) {
            try {
                FuelRegister fuelRegister = FuelRegister.getFuelRegister(string, string2, l, true);
                fuelRegister._setEventDataFields(eventData, d5, true);
                if (!DEBUG_MODE) {
                    fuelRegister.save();
                }
                Print.logInfo("[" + string + "/" + string2 + "] Detected fuel increase (refill):" + " old=" + StringTools.format(d4 * 100.0, "0.0") + "%" + " new=" + StringTools.format(d3 * 100.0, "0.0") + "%" + " delta=" + StringTools.format(d5 * 100.0, "0.0") + "%", new Object[0]);
                return FuelManager.LevelChangeType.INCREASE;
            }
            catch (DBException dBException) {
                Print.logError("Error creating new FuelRegister: " + dBException, new Object[0]);
                return FuelManager.LevelChangeType.UNKNOWN;
            }
        }
        if (d2 > 0.0 && d5 < -d2) {
            try {
                FuelRegister fuelRegister = FuelRegister.getFuelRegister(string, string2, l, true);
                fuelRegister._setEventDataFields(eventData, d5, false);
                if (!DEBUG_MODE) {
                    fuelRegister.save();
                }
                Print.logInfo("[" + string + "/" + string2 + "] Detected fuel decrease (theft):" + " old=" + StringTools.format(d4 * 100.0, "0.0") + "%" + " new=" + StringTools.format(d3 * 100.0, "0.0") + "%" + " delta=" + StringTools.format(d5 * 100.0, "0.0") + "%", new Object[0]);
                return FuelManager.LevelChangeType.DECREASE;
            }
            catch (DBException dBException) {
                Print.logError("Error creating new FuelRegister: " + dBException, new Object[0]);
                return FuelManager.LevelChangeType.UNKNOWN;
            }
        }
        return FuelManager.LevelChangeType.NONE;
    }

    @Override
    public void setCreationDefaultValues() {
        super.setRuntimeDefaultValues();
    }

    public static FuelRegister getFuelRegister(String string, String string2, long l) throws DBException {
        return FuelRegister.getFuelRegister(string, string2, l, false);
    }

    public static FuelRegister getFuelRegister(String string, String string2, long l, boolean bl) throws DBException {
        if (StringTools.isBlank(string) || StringTools.isBlank(string2)) {
            return null;
        }
        if (l <= 0L) {
            return null;
        }
        Key key = new Key(string, string2, l);
        if (key.exists()) {
            return (FuelRegister)key.getDBRecord(true);
        }
        if (bl) {
            FuelRegister fuelRegister = (FuelRegister)key.getDBRecord();
            fuelRegister.setCreationDefaultValues();
            return fuelRegister;
        }
        return null;
    }

    public static void getRecordCallback(String string, String string2, long l, long l2, DBRecordHandler<FuelRegister> dBRecordHandler) throws DBException {
        if (StringTools.isBlank(string) || StringTools.isBlank(string2)) {
            return;
        }
        if (dBRecordHandler == null) {
            return;
        }
        DBSelect<FuelRegister> dBSelect = new DBSelect<FuelRegister>(FuelRegister.getFactory());
        DBWhere dBWhere = new DBWhere(FuelRegister.getFactory());
        dBWhere.append(dBWhere.AND(dBWhere.EQ("accountID", string), dBWhere.EQ("deviceID", string2)));
        if (l >= 0L) {
            dBWhere.append(dBWhere.AND_(dBWhere.GE(FLD_timestamp, l)));
        }
        if (l2 >= 0L && l2 >= l) {
            dBWhere.append(dBWhere.AND_(dBWhere.LE(FLD_timestamp, l2)));
        }
        dBSelect.setWhere(dBWhere.WHERE(dBWhere.toString()));
        dBSelect.setOrderByFields(FLD_timestamp);
        dBSelect.setOrderAscending(true);
        DBRecord.select(dBSelect, dBRecordHandler);
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit(stringArray, true);
        DEBUG_MODE = true;
        String string = "demo";
        String string2 = "demo";
        if (!RTConfig.getBoolean(ARG_TEST, false)) {
            Print.sysPrintln("Add '-test' option to run FuelRegister test", new Object[0]);
            System.exit(0);
        }
        Account account = null;
        Device device = null;
        try {
            account = Account.getAccount(string);
            if (account == null) {
                Print.logError("Account not found: " + string, new Object[0]);
                System.exit(99);
            }
            if ((device = Device.getDevice(account, string2)) == null) {
                Print.logError("Device not found: " + string2, new Object[0]);
                System.exit(99);
            }
        }
        catch (DBException dBException) {
            Print.sysPrintln("Unable to load Account/Device", new Object[0]);
            Print.sysPrintln("AccountID : " + string, new Object[0]);
            Print.sysPrintln("DeviceID  : " + string2, new Object[0]);
            Print.sysPrintln("-------------------------------------------------------------------------------", new Object[0]);
            dBException.printStackTrace();
            Print.sysPrintln("-------------------------------------------------------------------------------", new Object[0]);
            System.exit(99);
        }
        long l = DateTime.getCurrentTimeSec();
        EventData.Key key = new EventData.Key(string, string2, l, 61472);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setDevice(device);
        eventData.setGeoPoint(37.784, -142.399);
        eventData.setFuelLevel(0.0);
        double d = 1.0;
        device.setLastFuelLevel(d);
        eventData.setFuelLevel(d);
        int n = 0;
        while (n < 10) {
            Print.sysPrintln("Fuel-Level: " + StringTools.format(d * 100.0, "0.0") + "%", new Object[0]);
            eventData.setFuelLevel(d);
            FuelManager.LevelChangeType levelChangeType = FuelRegister.insertFuelLevelChange(eventData);
            device.setLastFuelLevel(d);
            if (!((d -= 0.01) < 0.05)) continue;
            d = 1.0;
            ++n;
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<FuelRegister> {
        public Key() {
        }

        public Key(String string, String string2, long l) {
            super.setKeyValue("accountID", string != null ? string.toLowerCase() : "");
            super.setKeyValue("deviceID", string2 != null ? string2.toLowerCase() : "");
            super.setKeyValue(FuelRegister.FLD_timestamp, l);
        }

        @Override
        public DBFactory<FuelRegister> getFactory() {
            return FuelRegister.getFactory();
        }
    }
}

