/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.event;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.opengts.Version;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Resource;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.event.EventFunctionHandler;
import org.opengts.rule.event.EventFunctionMap;
import org.opengts.rule.event.EventFunctionMapFactory;
import org.opengts.rule.event.EventIdentifierHandler;
import org.opengts.rule.event.EventIdentifierMap;
import org.opengts.rule.event.EventIdentifierMapFactory;
import org.opengts.rule.selector.FunctionHandler;
import org.opengts.rule.selector.FunctionMap;
import org.opengts.rule.selector.FunctionMapFactory;
import org.opengts.rule.selector.IdentifierHandler;
import org.opengts.rule.selector.IdentifierMap;
import org.opengts.rule.selector.IdentifierMapFactory;
import org.opengts.rule.selector.ParserException;
import org.opengts.rule.selector.Selector;
import org.opengts.rule.tables.Rule;
import org.opengts.rule.tables.RuleTrigger;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class EventSelector
extends Selector {
    public static final String UTILITY_VERSION = "1.3.12";
    public static final String ENRE_VERSION = "1.2.11";
    private static long LIMIT_TEST = 0L;
    private static long VCHECK = 0L;
    private static long VCHECK_MSG = 0L;
    private static long VCHECK_MSGMOD = 21L;
    private static String VCHECK_ERROR = null;
    private static boolean SID_MATCH = true;
    private static boolean HASH_MATCH = true;
    private static boolean CronMode = false;
    private static EventSelector eventSelectorInstance = null;
    private EventData syntaxCheckEventData;
    private static final String[] ARG_HELP = new String[]{"help", "h"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    private static final String[] ARG_USER = new String[]{"user", "usr", "u"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev", "d"};
    private static final String[] ARG_TIMESTAMP = new String[]{"timestamp", "time", "ts"};
    private static final String[] ARG_CODE = new String[]{"statusCode", "code", "sc"};
    private static final String[] ARG_GPS = new String[]{"geoPoint", "gps", "gp"};
    private static final String[] ARG_KPH = new String[]{"kph", "speed"};
    private static final String[] ARG_MPH = new String[]{"mph"};
    private static final String[] ARG_ODOM = new String[]{"odometer", "odom", "od"};
    private static final String[] ARG_THERMAL = new String[]{"thermo", "temp", "tp"};
    private static final String[] ARG_CRON = new String[]{"cron"};

    public static String getVersion() {
        return EventSelector.getVersion(true);
    }

    public static String getVersion(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ENRE_VERSION);
            boolean bl2 = false;
            if (!bl2) {
                stringBuffer.append("-");
                bl2 = true;
            }
            stringBuffer.append("L(").append(109L).append(")");
            return stringBuffer.toString();
        }
        return ENRE_VERSION;
    }

    public static String getJarAuthString(String string) {
        if (StringTools.isBlank(string)) {
            String string2;
            String string3;
            URL uRL;
            string = RTConfig.getString("%mainJar", "");
            Class<EventSelector> clazz = EventSelector.class;
            ClassLoader classLoader = clazz.getClassLoader();
            if ((classLoader != null || (classLoader = ClassLoader.getSystemClassLoader()) != null) && (uRL = classLoader.getResource(clazz.getName().replace('.', '/') + ".class")) != null && (string3 = uRL.getPath()) != null && (string2 = StringTools.trim(uRL.getProtocol())).equalsIgnoreCase("jar")) {
                int n = StringTools.startsWithIgnoreCase(string3, "file:") ? "file:".length() : 0;
                int n2 = string3.indexOf("!");
                string = n2 >= 0 ? string3.substring(n, n2) : string3.substring(n, string3.length());
            }
        }
        long l = RTConfig.getLong("RuleFactory.key", 188900966474565L) & 0xFFFFFFFFFFFFL;
        return "mutinda,ruledb,1381279040,110," + l + "," + string;
    }

    public static void SetCronMode(boolean bl) {
        CronMode = bl;
    }

    public static boolean GetCronMode() {
        return CronMode;
    }

    public static void initSingleton() {
        if (eventSelectorInstance == null) {
            eventSelectorInstance = new EventSelector();
        }
    }

    public static EventSelector getInstance() {
        EventSelector.initSingleton();
        if (VCHECK > 0L && VCHECK_MSG++ % VCHECK_MSGMOD == 0L) {
            Print._log(2, -1, "*** Internal error: EX2959-2-" + VCHECK_ERROR + " (contact service provider)", new Object[0]);
        }
        return eventSelectorInstance;
    }

    public static String getDCSJarFilePath(String string) {
        File file = RTConfig.getLoadedConfigDir();
        if (file == null) {
            return "";
        }
        File file2 = new File(file, "build/lib/" + string + ".jar");
        if (file2 == null) {
            return "";
        }
        if (!file2.isFile()) {
            return "";
        }
        return file2.toString();
    }

    private static String getMainJarFilePath(String string, Class clazz) {
        ClassLoader classLoader;
        if (clazz == null) {
            clazz = EventSelector.class;
        }
        if ((classLoader = clazz.getClassLoader()) == null && (classLoader = ClassLoader.getSystemClassLoader()) == null) {
            return ":loader";
        }
        URL uRL = classLoader.getResource(clazz.getName().replace('.', '/') + ".class");
        if (uRL == null) {
            return ":resource";
        }
        String string2 = uRL.getPath();
        if (string2 == null) {
            return ":path";
        }
        String string3 = StringTools.trim(uRL.getProtocol());
        if (!string3.equalsIgnoreCase("jar")) {
            if (!string3.equalsIgnoreCase("file")) {
                return ":proto";
            }
            if (string2.endsWith("TrackServer.class")) {
                return EventSelector.getDCSJarFilePath(string);
            }
            if (string2.endsWith("TrackClientPacketHandler.class")) {
                return EventSelector.getDCSJarFilePath(string);
            }
            Print.logInfo("File: " + string2, new Object[0]);
            return ":proto";
        }
        int n = StringTools.startsWithIgnoreCase(string2, "file:") ? "file:".length() : 0;
        int n2 = string2.indexOf("!");
        if (n2 >= 0) {
            return string2.substring(n, n2);
        }
        return string2.substring(n, string2.length());
    }

    private static byte[] shuffle(byte[] byArray, Random random) {
        if (byArray != null && byArray.length > 1 && random != null) {
            for (int i = byArray.length - 1; i > 0; --i) {
                int n = random.nextInt(i + 1);
                if (i == n) continue;
                byte by = byArray[i];
                byArray[i] = byArray[n];
                byArray[n] = by;
            }
        }
        return byArray;
    }

    private static byte[] getRandomBytes(int n, Random random) {
        if (n > 0 && random != null) {
            byte[] byArray = new byte[n];
            random.nextBytes(byArray);
            return byArray;
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = FileTools.readStream(fileInputStream);
            return byArray;
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private EventSelector() {
        Object object;
        String string;
        String string2;
        block52: {
            int n;
            block51: {
                this.syntaxCheckEventData = null;
                n = 0;
                string2 = "";
                long l = 1381279040L;
                long l2 = 110L;
                String string3 = "ruledb";
                String string4 = RTConfig.getString("ServiceAccount.ID", "");
                if (StringTools.isBlank(string3)) {
                    n = 101;
                    ++VCHECK;
                    string2 = string2 + (1000 + n) + ":";
                } else if (StringTools.isBlank(string4)) {
                    n = 200;
                    SID_MATCH = false;
                    ++VCHECK;
                    string2 = string2 + (1000 + n) + ":";
                } else if (!(string4.equals(RTConfig.getString("ServiceAccount.ID", "")) && string4.equals("mutinda") && string4.equals("mutinda"))) {
                    n = 201;
                    SID_MATCH = false;
                    ++VCHECK;
                    string2 = string2 + (1000 + n) + ":" + string4;
                } else {
                    string = EventSelector.getMainJarFilePath(string3, this.getClass());
                    if (StringTools.isBlank(string)) {
                        n = 120;
                        HASH_MATCH = false;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":";
                    } else if (string.startsWith(":")) {
                        n = 120;
                        HASH_MATCH = false;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":" + string;
                    } else if (!StringTools.endsWithIgnoreCase(string, ".jar")) {
                        n = 305;
                        HASH_MATCH = false;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":" + string;
                    } else if (!FileTools.isFile(string)) {
                        n = 310;
                        HASH_MATCH = false;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":" + string;
                    } else {
                        object = EventSelector.readFile(new File(string));
                        if (ListTools.isEmpty((byte[])object)) {
                            n = 320;
                            HASH_MATCH = false;
                            ++VCHECK;
                            string2 = string2 + (1000 + n) + ":" + string;
                        } else {
                            File file = RTConfig.getLoadedConfigFile();
                            File file2 = file != null ? new File(file.getParentFile(), "GTS_Enterprise") : null;
                            byte[] byArray = EventSelector.readFile(file2);
                            if (ListTools.isEmpty(byArray)) {
                                n = 210;
                                ++VCHECK;
                                string2 = string2 + (1000 + n) + ":";
                            } else {
                                boolean bl = false;
                                RTProperties rTProperties = new RTProperties(new ByteArrayInputStream(byArray));
                                StringBuffer stringBuffer = new StringBuffer("GTS.");
                                String string5 = rTProperties.getString(stringBuffer + "Copyright", "");
                                String string6 = rTProperties.getString(stringBuffer + "ServiceID", "");
                                String string7 = rTProperties.getString(stringBuffer + "Version", "");
                                if (StringTools.isBlank(string5)) {
                                    n = 220;
                                    ++VCHECK;
                                    string2 = string2 + (1000 + n) + ":";
                                } else {
                                    File file3;
                                    Object object2;
                                    Object object3;
                                    int n2;
                                    Object object4;
                                    Object object5 = "RuleFactory." + string3;
                                    String string8 = "gtsauth:rule." + string3;
                                    if (OSTools.hasGetCallerClass()) {
                                        object4 = null;
                                        n2 = 2;
                                        while ((object3 = OSTools.getCallerClass(n2)) != null) {
                                            object4 = object3;
                                            ++n2;
                                        }
                                        if (object4 != null) {
                                            try {
                                                MethodAction methodAction = new MethodAction(object4, "DCServerFactory_LoadName");
                                                object3 = (String)methodAction.invoke();
                                                object2 = "RuleFactory." + (String)object3 + "." + string3;
                                                if (RTConfig.hasProperty((String)object2)) {
                                                    Print.logInfo("Changing DCS ruledb property to: " + (String)object2, new Object[0]);
                                                    object5 = object2;
                                                    string8 = "gtsauth:rule." + (String)object3 + "." + string3;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (StringTools.isBlank((String)(object4 = StringTools.trim(RTConfig.getString((String)object5, "")))) && (file3 = DBConfig.get_GTS_HOME()) != null) {
                                        object3 = new File(file3, DBConfig.AUTHKEY_DCS_CONF(string3));
                                        if (!((File)object3).isFile()) {
                                            object3 = new File(file3, "authkeys.conf");
                                        }
                                        if (((File)object3).isFile()) {
                                            object2 = new RTProperties((File)object3);
                                            object4 = StringTools.trim(((RTProperties)object2).getString((String)object5, ""));
                                        }
                                    }
                                    n2 = 1;
                                    try {
                                        byte[] byArray2;
                                        String string9;
                                        byte[] byArray3;
                                        Object object6;
                                        long l3 = RTConfig.getLong("RuleFactory.key", 188900966474565L) & 0xFFFFFFFFFFFFL;
                                        long l4 = BigInteger.valueOf(l3).xor(new BigInteger(string3.getBytes())).longValue();
                                        Random random = new Random(l4 & 0xFFFFFFFFFFFFL);
                                        Random random2 = new Random(l4 / 2L & 0xFFFFFFFFFFFFL);
                                        if (random.nextBoolean()) {
                                            object6 = MessageDigest.getInstance("MD5");
                                            ((MessageDigest)object6).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object6).update(String.valueOf(l2).getBytes());
                                            ((MessageDigest)object6).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object6).update(String.valueOf(l).getBytes());
                                            ((MessageDigest)object6).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object6).update(string3.getBytes());
                                            ((MessageDigest)object6).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object6).update(string4.getBytes());
                                            ((MessageDigest)object6).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object6).update(string5.getBytes());
                                            ((MessageDigest)object6).update(string6.getBytes());
                                            ((MessageDigest)object6).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            byArray3 = ((MessageDigest)object6).digest();
                                        } else {
                                            object6 = new Payload();
                                            ((Payload)object6).writeBytes(EventSelector.getRandomBytes(4, random));
                                            ((Payload)object6).writeULong(l2, 4, false);
                                            ((Payload)object6).writeULong(l, 8);
                                            ((Payload)object6).writeString(string3, 20, true);
                                            ((Payload)object6).writeString(string4, 20, true);
                                            ((Payload)object6).writeString(string5, 80, true);
                                            ((Payload)object6).writeString(string6, 20, true);
                                            ((Payload)object6).writeBytes(EventSelector.getRandomBytes(160 - ((Payload)object6).getSize(), random));
                                            byArray3 = ((Payload)object6).getBytes();
                                        }
                                        object6 = Mac.getInstance("HmacSHA256");
                                        ((Mac)object6).init(new SecretKeySpec(EventSelector.shuffle(byArray3, random), ((Mac)object6).getAlgorithm()));
                                        if (bl) {
                                            ((Mac)object6).update(byArray);
                                        }
                                        if ((string9 = new BigInteger(1, byArray2 = EventSelector.shuffle(((Mac)object6).doFinal((byte[])object), random)).toString(16)).equalsIgnoreCase((String)object4) || ((String)object4).startsWith(string4 + "," + string3 + "," + l)) break block51;
                                        if (StringTools.isBlank((String)object4)) {
                                            n = 330;
                                            HASH_MATCH = false;
                                            ++VCHECK;
                                            string2 = string2 + (1000 + n) + ":" + "RuleFactory." + string3;
                                            Resource.setGlobalResourceValue(string8, "binary", "", EventSelector.shuffle(byArray2, random2));
                                            break block52;
                                        }
                                        n = 350;
                                        HASH_MATCH = false;
                                        ++VCHECK;
                                        string2 = string2 + (1000 + n) + ":" + string4 + "," + string3 + "," + l + "," + l2 + "," + l3 + "," + string;
                                        Resource.setGlobalResourceValue(string8, "binary", "", EventSelector.shuffle(byArray2, random2));
                                    }
                                    catch (Throwable throwable) {
                                        if (((String)object4).startsWith(string4 + "," + string3 + "," + l)) break block51;
                                        if (StringTools.isBlank((String)object4)) {
                                            n = 330;
                                            HASH_MATCH = false;
                                            ++VCHECK;
                                            string2 = string2 + (1000 + n) + ":" + "RuleFactory." + string3;
                                            break block52;
                                        }
                                        n = 390;
                                        HASH_MATCH = false;
                                        ++VCHECK;
                                        string2 = string2 + (1000 + n) + ":";
                                    }
                                }
                            }
                        }
                    }
                }
                break block52;
            }
            long l = DateTime.getCurrentTimeSec();
            boolean bl = false;
            if (bl) {
                n = 500;
                ++VCHECK;
                string2 = string2 + (1000 + n) + ":";
            } else {
                try {
                    long l5 = DBRecord.getRecordCount(Device.getFactory());
                    if (l5 > 118L) {
                        n = 400;
                        LIMIT_TEST = 1562587685504633840L;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":" + l5;
                    } else {
                        LIMIT_TEST = -1562587685504633841L;
                    }
                }
                catch (DBException dBException) {
                    n = 490;
                    ++VCHECK;
                    string2 = string2 + (1000 + n) + ":" + dBException.getMessage();
                }
            }
        }
        string = RTConfig.getString("EventFunctionMapFactory.class");
        if (!StringTools.isBlank(string)) {
            try {
                object = new MethodAction(string);
                this.setFunctionMapFactory((EventFunctionMapFactory)((MethodAction)object).invoke());
            }
            catch (Throwable throwable) {
                Print.logException("Unable to instantiate '" + string + "'", throwable);
                this.setFunctionMapFactory(new EventFunctionMapFactory());
            }
        } else {
            this.setFunctionMapFactory(new EventFunctionMapFactory());
        }
        string = RTConfig.getString("EventIdentifierMapFactory.class");
        if (!StringTools.isBlank(string)) {
            try {
                object = new MethodAction(string);
                this.setIdentifierMapFactory((EventIdentifierMapFactory)((MethodAction)object).invoke());
            }
            catch (Throwable throwable) {
                Print.logException("Unable to instantiate '" + string + "'", throwable);
                this.setIdentifierMapFactory(new EventIdentifierMapFactory());
            }
        } else {
            this.setIdentifierMapFactory(new EventIdentifierMapFactory());
        }
        this.syntaxCheckEventData = null;
        if (VCHECK > 0L) {
            VCHECK_ERROR = string2;
            VCHECK_MSG = VCHECK_MSGMOD - 2L;
        }
    }

    public String _getVersion() {
        String string = ENRE_VERSION;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (VCHECK > 0L) {
            stringBuffer.append("*");
        }
        stringBuffer.append(string);
        if (!HASH_MATCH) {
            int n;
            if (!bl) {
                stringBuffer.append("-");
                bl = true;
            }
            stringBuffer.append("H");
            int n2 = n = VCHECK_ERROR != null ? VCHECK_ERROR.indexOf(":") : -1;
            if (n > 0) {
                stringBuffer.append(VCHECK_ERROR.substring(0, n));
            }
        }
        if (!SID_MATCH) {
            if (!bl) {
                stringBuffer.append("-");
                bl = true;
            }
            stringBuffer.append("S");
        }
        if (!bl) {
            stringBuffer.append("-");
            bl = true;
        }
        stringBuffer.append("L(").append(109L).append(")");
        return stringBuffer.toString();
    }

    @Override
    public FunctionMap newFunctionMap(int n, Object object, boolean bl) {
        FunctionMapFactory functionMapFactory = this.getFunctionMapFactory();
        if (object instanceof EventData) {
            return new EventFunctionMap(functionMapFactory, n, (EventData)object, bl);
        }
        if (object instanceof Account) {
            return new EventFunctionMap(functionMapFactory, n, (Account)object, bl);
        }
        if (object instanceof Device) {
            return new EventFunctionMap(functionMapFactory, n, (Device)object, bl);
        }
        if (object == null) {
            return new EventFunctionMap(functionMapFactory, n, (EventData)null, bl);
        }
        Print.logError("Object must be one of type EventData/Account/Device! [found " + StringTools.className(object) + "]", new Object[0]);
        return null;
    }

    public List<String> getFunctionNames() {
        FunctionMapFactory functionMapFactory = this.getFunctionMapFactory();
        OrderedSet<FunctionHandler> orderedSet = new OrderedSet<FunctionHandler>(functionMapFactory.getFunctions(), true);
        Vector<String> vector = new Vector<String>();
        Iterator<FunctionHandler> iterator = ListTools.sort(orderedSet, null).iterator();
        while (iterator.hasNext()) {
            String[] stringArray = iterator.next().getNames();
            if (ListTools.isEmpty(stringArray)) continue;
            vector.add(stringArray[0]);
        }
        return vector;
    }

    public FunctionHandler getFunction(String string) {
        if (!StringTools.isBlank(string)) {
            FunctionMapFactory functionMapFactory = this.getFunctionMapFactory();
            return functionMapFactory.getFunction(string);
        }
        return null;
    }

    public int addFunction(EventFunctionHandler eventFunctionHandler) {
        return this.getFunctionMapFactory().addFunction(eventFunctionHandler);
    }

    @Override
    public IdentifierMap newIdentifierMap(Object object) {
        IdentifierMapFactory identifierMapFactory = this.getIdentifierMapFactory();
        if (object instanceof EventData) {
            return new EventIdentifierMap(identifierMapFactory, (EventData)object);
        }
        if (object instanceof Account) {
            return new EventIdentifierMap(identifierMapFactory, (Account)object);
        }
        if (object instanceof Device) {
            return new EventIdentifierMap(identifierMapFactory, (Device)object);
        }
        if (object == null) {
            return new EventIdentifierMap(identifierMapFactory, (EventData)null);
        }
        Print.logError("Object must be one of type EventData/Account/Device! [found " + StringTools.className(object) + "]", new Object[0]);
        return null;
    }

    public List<String> getIdentifierNames() {
        IdentifierMapFactory identifierMapFactory = this.getIdentifierMapFactory();
        OrderedSet<IdentifierHandler> orderedSet = new OrderedSet<IdentifierHandler>(identifierMapFactory.getIdentifiers(), true);
        Vector<String> vector = new Vector<String>();
        Iterator<IdentifierHandler> iterator = ListTools.sort(orderedSet, null).iterator();
        while (iterator.hasNext()) {
            String[] stringArray = iterator.next().getNames();
            if (ListTools.isEmpty(stringArray)) continue;
            vector.add(stringArray[0]);
        }
        return vector;
    }

    public IdentifierHandler getIdentifier(String string) {
        if (!StringTools.isBlank(string)) {
            IdentifierMapFactory identifierMapFactory = this.getIdentifierMapFactory();
            return identifierMapFactory.getIdentifier(string);
        }
        return null;
    }

    public int addIdentifier(EventIdentifierHandler eventIdentifierHandler) {
        return this.getIdentifierMapFactory().addIdentifier(eventIdentifierHandler);
    }

    @Override
    public boolean checkSyntax(String string) {
        Object object = this.getSyntaxCheckObject();
        boolean bl = super.checkSyntax(string, object);
        if (bl) {
            return true;
        }
        try {
            super.getResult(-1, string, object);
        }
        catch (ParserException parserException) {
            Print.logError("Selector: " + parserException, new Object[0]);
            Print.logException("Selector: " + string, parserException);
        }
        return false;
    }

    private Object getSyntaxCheckObject() {
        return this.syntaxCheckEventData;
    }

    @Override
    public Object getResultValue(String string, Object object) throws ParserException {
        long l;
        if ((LIMIT_TEST ^ 0xFFFFFFFFFFFFFFFFL) != 1562587685504633840L) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(5017L);
            }
            catch (Throwable throwable) {
                return FunctionHandler.LONG_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return FunctionHandler.LONG_FALSE;
            }
        }
        if (!SID_MATCH || !HASH_MATCH) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(7187L);
            }
            catch (Throwable throwable) {
                return FunctionHandler.LONG_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return FunctionHandler.LONG_FALSE;
            }
        }
        return super.getResultValue(string, object);
    }

    @Override
    public Selector.Result getResult(String string, Object object) throws ParserException {
        long l;
        if ((LIMIT_TEST ^ 0xFFFFFFFFFFFFFFFFL) != 1562587685504633840L) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(5021L);
            }
            catch (Throwable throwable) {
                return Selector.RESULT_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return Selector.RESULT_FALSE;
            }
        }
        if (!SID_MATCH || !HASH_MATCH) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(7053L);
            }
            catch (Throwable throwable) {
                return Selector.RESULT_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return Selector.RESULT_FALSE;
            }
        }
        return super.getResult(string, object);
    }

    @Override
    public Selector.Result getResult(int n, String string, Object object) throws ParserException {
        long l;
        if ((LIMIT_TEST ^ 0xFFFFFFFFFFFFFFFFL) != 1562587685504633840L) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(5027L);
            }
            catch (Throwable throwable) {
                return Selector.RESULT_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return Selector.RESULT_FALSE;
            }
        }
        if (!SID_MATCH || !HASH_MATCH) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(6073L);
            }
            catch (Throwable throwable) {
                return Selector.RESULT_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return Selector.RESULT_FALSE;
            }
        }
        return super.getResult(n, string, object);
    }

    public Selector.Result getAccountRuleResult(int n, Account account, String string, EventData eventData) throws ParserException, DBException {
        Rule rule = Rule.getRule(account, string);
        if (rule == null) {
            String string2 = account != null ? account.getAccountID() : "?";
            throw new ParserException("Rule not found: " + string);
        }
        if (!rule.isActive()) {
            String string3 = account != null ? account.getAccountID() : "?";
            Print.logWarn("Rule not active: " + string3 + "/" + string, new Object[0]);
            return RESULT_FALSE;
        }
        String string4 = rule.getSelector();
        AccountRecord accountRecord = eventData != null ? eventData : account;
        return this.getResult(n, string4, accountRecord);
    }

    public Selector.Result getSysAdminRuleResult(int n, String string, EventData eventData) throws ParserException, DBException {
        String string2 = AccountRecord.getSystemAdminAccountID();
        if (StringTools.isBlank(string2)) {
            throw new ParserException("No SystemAdmin account to retrieve Rule: " + string);
        }
        Rule rule = Rule.getRule(string2, string);
        if (rule == null) {
            throw new ParserException("Rule not found: " + string2 + "/" + string);
        }
        if (!rule.isActive()) {
            Print.logWarn("Rule not active: " + string2 + "/" + string, new Object[0]);
            return RESULT_FALSE;
        }
        String string3 = rule.getSelector();
        EventData eventData2 = eventData != null ? eventData : null;
        return this.getResult(n, string3, eventData2);
    }

    private static void usage() {
        String string = EventSelector.class.getName();
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  java ... " + string + " -help", new Object[0]);
        Print.sysPrintln("  java ... " + string + " -list", new Object[0]);
        Print.sysPrintln("  java ... " + string + " {options}", new Object[0]);
        Print.sysPrintln("Options:", new Object[0]);
        Print.sysPrintln("  -help               This help", new Object[0]);
        Print.sysPrintln("  -list               List all available functions/identifiers", new Object[0]);
        Print.sysPrintln("  -account=<id>       Acount ID which owns Device/Event", new Object[0]);
        Print.sysPrintln("  -device=<id>        Device ID which owns Event", new Object[0]);
        Print.sysPrintln("  -timestamp=<code>   Timestamp", new Object[0]);
        Print.sysPrintln("  -code=<code>        Status Code ('0' to leave EventData null)", new Object[0]);
        Print.sysPrintln("  -gps=<lat>/<lon>    GPS Location", new Object[0]);
        Print.sysPrintln("  -mph=<speedMPH>     Speed in MPH", new Object[0]);
        Print.sysPrintln("  -kph=<speedKPH>     Speed in KM/H", new Object[0]);
        Print.sysPrintln("  -odom=<odometerKM>  Odometer in KM", new Object[0]);
        Print.sysPrintln("  -temp=<C>,<C>,...   Comma separated list of temperatures", new Object[0]);
        Print.sysPrintln("  -cron=<mode>        Set 'Cron' mode true/false [default true]", new Object[0]);
        Print.sysPrintln("", new Object[0]);
        System.exit(1);
    }

    private static void listFunctions(EventSelector eventSelector, int n, String string, String string2) {
        Print.sysPrintln("Functions:", new Object[0]);
        OrderedSet<FunctionHandler> orderedSet = new OrderedSet<FunctionHandler>(eventSelector.getFunctionMapFactory().getFunctions(), true);
        for (FunctionHandler functionHandler : ListTools.sort(orderedSet, null)) {
            String[] stringArray = functionHandler.getNames();
            if (!StringTools.isBlank(string2) && !stringArray[0].startsWith(string2)) continue;
            String string3 = functionHandler.getUsage();
            String string4 = functionHandler.getDescription();
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!StringTools.isBlank(string3)) {
                stringBuffer.append(StringTools.leftAlign(string3, n));
            } else {
                stringBuffer.append(StringTools.leftAlign(StringTools.join(functionHandler.getNames(), ","), n));
            }
            Print.sysPrintln(stringBuffer.toString(), new Object[0]);
            Print.sysPrintln(string + string + string4, new Object[0]);
        }
    }

    private static void listIdentifiers(EventSelector eventSelector, int n, String string, String string2) {
        Print.sysPrintln("Identifiers:", new Object[0]);
        OrderedSet<IdentifierHandler> orderedSet = new OrderedSet<IdentifierHandler>(eventSelector.getIdentifierMapFactory().getIdentifiers(), true);
        for (IdentifierHandler identifierHandler : ListTools.sort(orderedSet, null)) {
            String[] stringArray = identifierHandler.getNames();
            if (!StringTools.isBlank(string2) && !stringArray[0].startsWith(string2)) continue;
            String string3 = identifierHandler.getDescription();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(StringTools.leftAlign(StringTools.join(stringArray, ","), n));
            Print.sysPrintln(stringBuffer.toString(), new Object[0]);
            Print.sysPrintln(string + string + string3, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        String string;
        DBConfig.cmdLineInit(stringArray, true);
        RTConfig.setBoolean("log.include.frame", true);
        int n = 25;
        String string2 = "    ";
        VCHECK_MSGMOD = 2L;
        if (RTConfig.hasProperty(ARG_HELP)) {
            EventSelector.usage();
        }
        EventSelector.SetCronMode(RTConfig.getBoolean(ARG_CRON, true));
        EventSelector eventSelector = EventSelector.getInstance();
        if (RTConfig.hasProperty(ARG_LIST)) {
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("Function Usage Legend:", new Object[0]);
            Print.sysPrintln("    (...)  = Function argument list, '()' is optional if function has no arguments", new Object[0]);
            Print.sysPrintln("    [...]  = Optional specification", new Object[0]);
            Print.sysPrintln("    {...}  = Mandatory specification set (one of the items must be specified)", new Object[0]);
            Print.sysPrintln("    |      = Indicates alternative specifications", new Object[0]);
            Print.sysPrintln("", new Object[0]);
            EventSelector.listFunctions(eventSelector, n, string2, null);
            Print.sysPrintln("", new Object[0]);
            EventSelector.listIdentifiers(eventSelector, n, string2, null);
            Print.sysPrintln("", new Object[0]);
            System.exit(0);
        }
        if (StringTools.isBlank(string = RTConfig.getString(ARG_ACCOUNT, "demo"))) {
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("ERROR: Account-ID not specified.", new Object[0]);
            EventSelector.usage();
        }
        try {
            if (!Account.exists(string)) {
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("ERROR: Account-ID does not exist: " + string, new Object[0]);
                EventSelector.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException("Error checking Account existance: " + string, dBException);
            System.exit(99);
        }
        String string3 = RTConfig.getString(ARG_USER, "");
        try {
            if (!StringTools.isBlank(string3) && !User.exists(string, string3)) {
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("ERROR: User-ID does not exist: " + string + "/" + string3, new Object[0]);
                EventSelector.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException("Error checking User existance: " + string + "/" + string3, dBException);
            System.exit(99);
        }
        String string4 = RTConfig.getString(ARG_DEVICE, "");
        if (StringTools.isBlank(string4) && string.equals("demo")) {
            string4 = "demo";
        }
        if (string4.equals("NONE")) {
            string4 = "";
        } else if (!StringTools.isBlank(string4)) {
            try {
                if (StringTools.isBlank(string4)) {
                    Print.sysPrintln("", new Object[0]);
                    Print.sysPrintln("ERROR: Device-ID not specified.", new Object[0]);
                    EventSelector.usage();
                }
                if (!Device.exists(string, string4)) {
                    Print.sysPrintln("", new Object[0]);
                    Print.sysPrintln("ERROR: Device-ID does not exist: " + string + "/" + string4, new Object[0]);
                    EventSelector.usage();
                }
            }
            catch (DBException dBException) {
                Print.logException("Error checking Device existance: " + string + "/" + string4, dBException);
                System.exit(99);
            }
        }
        long l = DateTime.getCurrentTimeSec();
        if (RTConfig.hasProperty(ARG_TIMESTAMP)) {
            String string5 = RTConfig.getString(ARG_TIMESTAMP, null);
            try {
                object3 = DateTime.parseArgumentDate(string5, null, false);
                l = ((DateTime)object3).getTimeSec();
            }
            catch (DateTime.DateParseException dateParseException) {
                Print.sysPrintln("Invalid Time format: " + string5, new Object[0]);
            }
        }
        int n2 = RTConfig.getInt(ARG_CODE, 61472);
        object3 = RTConfig.getString(ARG_GPS, "37.784/-142.399");
        GeoPoint geoPoint = new GeoPoint((String)object3);
        if (!geoPoint.isValid()) {
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("ERROR: Specified GeoPoint is not valid: " + (String)object3, new Object[0]);
            EventSelector.usage();
        }
        double d = 0.0;
        if (RTConfig.hasProperty(ARG_KPH)) {
            d = RTConfig.getDouble(ARG_KPH, 0.0);
        } else if (RTConfig.hasProperty(ARG_MPH)) {
            d = RTConfig.getDouble(ARG_MPH, 0.0) * 1.609344;
        }
        double d2 = RTConfig.getDouble(ARG_ODOM, 0.0);
        double[] dArray = RTConfig.getDoubleArray(ARG_THERMAL, null);
        long l2 = DateTime.getCurrentTimeSec();
        boolean bl = false;
        String string6 = new DateTime(1381279040L).toString();
        Print.sysPrintln("-------------------------------------------------------------------------------", new Object[0]);
        Print.sysPrintln("Rule Evaluation Testing Utility", new Object[0]);
        Print.sysPrintln("Copyright 2007-2013, GeoTelematic Solutions, Inc.", new Object[0]);
        Print.sysPrintln("Service ID  : mutinda", new Object[0]);
        Print.sysPrintln("Tool Version: 1.3.12, 1381279040 [" + string6 + "]", new Object[0]);
        Print.sysPrintln("ENRE Version: " + eventSelector._getVersion() + (VCHECK_ERROR != null ? " [" + VCHECK_ERROR + "]" : ""), new Object[0]);
        Print.sysPrintln("GTS  Version: " + Version.getVersion(), new Object[0]);
        Print.sysPrintln("(subject to licensing terms/conditions which accompany this software product)", new Object[0]);
        Print.sysPrintln("-------------------------------------------------------------------------------", new Object[0]);
        Account account = null;
        User user = null;
        Device device = null;
        EventData eventData = null;
        TimeZone timeZone = null;
        boolean bl2 = true;
        boolean bl3 = true;
        try {
            account = Account.getAccount(string);
            user = !StringTools.isBlank(string3) ? User.getUser(account, string3) : null;
            device = !StringTools.isBlank(string4) ? Device.getDevice(account, string4) : null;
            TimeZone timeZone2 = timeZone = account != null ? DateTime.getTimeZone(account.getTimeZone()) : DateTime.getGMTTimeZone();
            if (n2 == 0 || l <= 0L) {
                eventData = null;
            } else if (device != null) {
                long l3;
                long l4;
                object2 = new EventData.Key(string, string4, l, n2);
                object = (EventData)((DBRecordKey)object2).getDBRecord();
                ((EventData)object).setGeoPoint(geoPoint);
                ((EventData)object).setSpeedKPH(d);
                ((EventData)object).setOdometerKM(d2);
                ((AccountRecord)object).setAccount(account);
                ((DeviceRecord)object).setDevice(device);
                if (d <= 0.0) {
                    l4 = 0L;
                    l3 = l - DateTime.MinuteSeconds(23L);
                    Print.logInfo("Setting Device as STOPPED", new Object[0]);
                    device.setLastStartTime(l4);
                    device.setLastStopTime(l3);
                } else {
                    l4 = l - DateTime.MinuteSeconds(56L);
                    l3 = 0L;
                    Print.logInfo("Setting Device as MOVING", new Object[0]);
                    device.setLastStartTime(l4);
                    device.setLastStopTime(l3);
                }
                if (!ListTools.isEmpty(dArray)) {
                    for (int i = 0; i < dArray.length; ++i) {
                        ((EventData)object).setThermoAverage(i, dArray[i]);
                    }
                }
                ((EventData)object).setDriverMessage("Hello World");
                ((EventData)object).setDriverID("smith");
                eventData = object;
            } else {
                eventData = null;
            }
            account.setCurrentUser(user);
        }
        catch (DBException dBException) {
            Print.sysPrintln("Unable to load Account/Device/EventData", new Object[0]);
            Print.sysPrintln("AccountID : " + string, new Object[0]);
            Print.sysPrintln("DeviceID  : " + string4, new Object[0]);
            Print.sysPrintln("-------------------------------------------------------------------------------", new Object[0]);
            dBException.printStackTrace();
            Print.sysPrintln("-------------------------------------------------------------------------------", new Object[0]);
            System.exit(99);
        }
        object2 = device != null ? device.getLastValidLocation() : GeoPoint.INVALID_GEOPOINT;
        Print.sysPrintln("Default Attributes:", new Object[0]);
        Print.sysPrintln("  CronMode  : " + EventSelector.GetCronMode(), new Object[0]);
        Print.sysPrintln("  Account   : " + account, new Object[0]);
        Print.sysPrintln("  User      : " + user, new Object[0]);
        Print.sysPrintln("  Device    : " + device, new Object[0]);
        Print.sysPrintln("  EventData : " + eventData, new Object[0]);
        Print.sysPrintln("  Timestamp : " + l + " [" + new DateTime(l, timeZone) + "]", new Object[0]);
        Print.sysPrintln("  StatusCode: " + StatusCodes.GetHex(n2) + " [" + StatusCodes.GetDescription(n2, null) + "]", new Object[0]);
        Print.sysPrintln("  GeoPoint  : " + geoPoint, new Object[0]);
        Print.sysPrintln("  Prev GP   : " + object2, new Object[0]);
        Print.sysPrintln("  Speed     : " + d + " km/h", new Object[0]);
        Print.sysPrintln("  Odometer  : " + d2 + " km", new Object[0]);
        Print.sysPrintln("  Temp C    : " + StringTools.join(dArray, ","), new Object[0]);
        Print.sysPrintln("-------------------------------------------------------------------------------", new Object[0]);
        object = "Special commands: (prefixed with '/' character\n  exit                      Exit this command-line utility\n  /exit                     Exit this command-line utility\n  /list    [<partialID>]    List of identifiers beginning with partial name\n  /list    $[<partialFTN>]  List of functions beginning with partial name\n  /syntax  <selector>       syntax check specified selector\n  /rule    <ruleID>         execute selector for specified rule-id\n  /exerule <ruleID>         execute selector and action for specified rule-id\n  /message <text>           display message with replaced ${..} vars\n  /set     <field>=<value>  set EventData field to value\n  /help    <identifier>     <identifier> help information\n  /help    $<function>      $<function> help information";
        Print.sysPrintln((String)object, new Object[0]);
        Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
        String string7 = "/exit";
        String string8 = "/quit";
        String string9 = "/list";
        String string10 = "/help";
        String string11 = "/syntax";
        String string12 = "/ftncheck";
        String string13 = "/rule";
        String string14 = "/exerule";
        String string15 = "/message";
        String string16 = "/msg";
        String string17 = "/set";
        String string18 = "/get";
        String string19 = "/reload";
        String[] stringArray2 = new String[]{string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19};
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                Print.sysPrint("Expression> ", new Object[0]);
                String string20 = "";
                try {
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object9;
                    String string21 = bufferedReader.readLine();
                    if (string21 == null || (string20 = string21.trim()).equalsIgnoreCase("exit") || string20.equalsIgnoreCase(string7) || string20.equalsIgnoreCase("quit") || string20.equalsIgnoreCase(string8)) break;
                    if (StringTools.isBlank(string20)) continue;
                    if (device == null) {
                        Print.logWarn("Device is null", new Object[0]);
                    } else if (bl2) {
                        long l5 = device.getLastStartTime();
                        long l6 = device.getLastStopTime();
                        device.reload();
                        device.setLastStartTime(l5);
                        device.setLastStopTime(l6);
                    }
                    if (account == null) {
                        Print.logWarn("Account is null", new Object[0]);
                    } else if (bl3) {
                        account.reload();
                    }
                    if (string20.startsWith(string19)) {
                        boolean bl4;
                        object9 = string20.substring(string19.length()).trim();
                        bl2 = bl4 = StringTools.parseBoolean((String)object9, bl2);
                        bl3 = bl4;
                        Print.sysPrintln("Account/Device reload is " + (bl4 ? "ON" : "OFF"), new Object[0]);
                        continue;
                    }
                    if (string20.startsWith(string17)) {
                        void var50_76;
                        object9 = string20.substring(string17.length()).trim();
                        int n3 = ((String)object9).indexOf("=");
                        if (n3 <= 0) {
                            Print.sysPrintln("Invalid FIELD=VALUE specification.", new Object[0]);
                            continue;
                        }
                        String string22 = "EventData";
                        String string5 = ((String)object9).substring(0, n3).trim();
                        object7 = ((String)object9).substring(n3 + 1).trim();
                        int n4 = string5.indexOf(".");
                        if (n4 >= 0) {
                            string22 = string5.substring(0, n4).trim();
                            String string23 = string5.substring(n4 + 1).trim();
                        }
                        AccountRecord accountRecord = null;
                        if (string22.equalsIgnoreCase("EventData") || StringTools.isBlank(string22)) {
                            accountRecord = eventData;
                        } else if (string22.equalsIgnoreCase("Device")) {
                            accountRecord = device;
                        } else if (string22.equalsIgnoreCase("Account")) {
                            accountRecord = account;
                        } else {
                            Print.sysPrintln("'/set' not supported for table: " + string22, new Object[0]);
                            continue;
                        }
                        object6 = DBRecord.getFactory(accountRecord);
                        Object object8 = object5 = object6 != null ? ((DBFactory)object6).getField((String)var50_76) : null;
                        if (object5 == null) {
                            Print.sysPrintln("Field not found: " + string22 + "." + (String)var50_76, new Object[0]);
                            continue;
                        }
                        if (object5.isPrimaryKey()) {
                            Print.sysPrintln("'/set' cannot be used on a primary key field: " + string22 + "." + (String)var50_76, new Object[0]);
                            continue;
                        }
                        object4 = object5.parseStringValue((String)object7);
                        accountRecord.setValue((String)var50_76, object4);
                        Print.sysPrintln("Set '" + string22 + "." + (String)var50_76 + "': " + accountRecord.getValue((String)var50_76), new Object[0]);
                        continue;
                    }
                    if (string20.startsWith(string18)) {
                        void var50_79;
                        object9 = string20.substring(string18.length()).trim();
                        int n5 = ((String)object9).indexOf("=");
                        if (n5 >= 0) {
                            object9 = ((String)object9).substring(0, n5).trim();
                        }
                        String string23 = "EventData";
                        Object object10 = object9;
                        int n6 = ((String)object10).indexOf(".");
                        if (n6 >= 0) {
                            string23 = ((String)object10).substring(0, n6).trim();
                            String string24 = ((String)object10).substring(n6 + 1).trim();
                        }
                        AccountRecord accountRecord = null;
                        if (string23.equalsIgnoreCase("EventData") || StringTools.isBlank(string23)) {
                            accountRecord = eventData;
                        } else if (string23.equalsIgnoreCase("Device")) {
                            accountRecord = device;
                        } else if (string23.equalsIgnoreCase("Account")) {
                            accountRecord = account;
                        } else {
                            Print.sysPrintln("'/get' not supported for table: " + string23, new Object[0]);
                            continue;
                        }
                        DBFactory<EventData> dBFactory = DBRecord.getFactory(accountRecord);
                        Object object11 = object6 = dBFactory != null ? dBFactory.getField((String)var50_79) : null;
                        if (object6 == null) {
                            Print.sysPrintln("Field not found: " + string23 + "." + (String)var50_79, new Object[0]);
                            continue;
                        }
                        object5 = accountRecord.getValue((String)var50_79);
                        Print.sysPrintln("Get '" + string23 + "." + (String)var50_79 + "': " + object5, new Object[0]);
                        continue;
                    }
                    if (string20.startsWith(string9)) {
                        object9 = string20.substring(string9.length()).trim();
                        Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
                        if (((String)object9).startsWith("$")) {
                            EventSelector.listFunctions(eventSelector, n, string2, (String)object9);
                        } else {
                            EventSelector.listIdentifiers(eventSelector, n, string2, (String)object9);
                        }
                        Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
                        Print.sysPrintln("", new Object[0]);
                        continue;
                    }
                    if (string20.startsWith(string10)) {
                        object9 = string20.substring(string10.length()).trim();
                        if (((String)object9).startsWith("$")) {
                            Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
                            FunctionHandler functionHandler = eventSelector.getFunction((String)object9);
                            if (functionHandler != null) {
                                Print.sysPrintln(functionHandler.getUsage(), new Object[0]);
                                Print.sysPrintln(functionHandler.getDescription(), new Object[0]);
                            } else {
                                Print.sysPrintln("Function not found: " + (String)object9, new Object[0]);
                            }
                        } else if (!StringTools.isBlank((String)object9)) {
                            Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
                            IdentifierHandler identifierHandler = eventSelector.getIdentifier((String)object9);
                            if (identifierHandler != null) {
                                Print.sysPrintln(identifierHandler.getDescription(), new Object[0]);
                            } else {
                                Print.sysPrintln("Identifier not found: " + (String)object9, new Object[0]);
                            }
                        }
                        Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
                        Print.sysPrintln((String)object, new Object[0]);
                        Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
                        Print.sysPrintln("", new Object[0]);
                        continue;
                    }
                    if (string20.startsWith(string11)) {
                        object9 = string20.substring(string11.length()).trim();
                        Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
                        boolean bl5 = eventSelector.checkSyntax((String)object9, eventData != null ? eventData : account);
                        Print.sysPrintln(" ==> syntax: " + (bl5 ? "Valid" : "Invalid"), new Object[0]);
                        Print.sysPrintln("------------------------------------------------------------------------------", new Object[0]);
                        Print.sysPrintln("", new Object[0]);
                        continue;
                    }
                    if (string20.startsWith(string12)) {
                        object9 = eventData != null ? eventData : account;
                        Collection<FunctionHandler> collection = eventSelector.getFunctionMapFactory().getFunctions();
                        for (FunctionHandler functionHandler : collection) {
                            object7 = (EventFunctionHandler)functionHandler;
                            String[] stringArray3 = ((EventFunctionHandler)object7).getNames();
                            EventFunctionHandler.ArgCk argCk = ((EventFunctionHandler)object7).getArgCheck();
                            if (argCk == null) {
                                Print.sysPrintln(stringArray3[0] + " : ArgCk is null ...", new Object[0]);
                                Print.sysPrintln("", new Object[0]);
                                continue;
                            }
                            object6 = argCk.getArgCounts();
                            object5 = argCk.getArgTypes();
                            object4 = stringArray3[0];
                            block21: for (int i = 0; i < ((Object)object6).length; ++i) {
                                for (int j = 0; j < 2; ++j) {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append((String)object4);
                                    stringBuffer.append("(");
                                    Object object12 = object6[i];
                                    for (int k = 0; k < object12; ++k) {
                                        Class clazz;
                                        if (k > 0) {
                                            stringBuffer.append(",");
                                        }
                                        if ((clazz = object5[k]).equals(String.class)) {
                                            stringBuffer.append("\"demo\"");
                                            continue;
                                        }
                                        if (clazz.equals(Object.class)) {
                                            stringBuffer.append(j == 0 ? "\"1\"" : "1");
                                            continue;
                                        }
                                        if (clazz.equals(Double.class)) {
                                            stringBuffer.append("0.0");
                                            continue;
                                        }
                                        if (clazz.equals(Long.class)) {
                                            stringBuffer.append("1");
                                            continue;
                                        }
                                        if (clazz.equals(Boolean.class)) {
                                            stringBuffer.append("1");
                                            continue;
                                        }
                                        Print.logError("Unrecognized type: " + StringTools.className(clazz), new Object[0]);
                                    }
                                    stringBuffer.append(")");
                                    String string25 = stringBuffer.toString();
                                    boolean bl4 = eventSelector.checkSyntax(string25, object9);
                                    String string26 = "   " + StringTools.leftAlign(string25, 22) + " ==> ";
                                    if (j > 0) {
                                        string26 = string26 + "(retry) ";
                                    }
                                    if (bl4) {
                                        try {
                                            Selector.Result result = EventSelector.getInstance().getResult(0, string25, object9);
                                            Print.sysPrintln(string26 + "OK", new Object[0]);
                                            continue block21;
                                        }
                                        catch (ParserException parserException) {
                                            Print.sysPrintln(string26 + parserException.getMessage(), new Object[0]);
                                            continue;
                                        }
                                    }
                                    Print.sysPrintln(string26 + "Invalid Syntax", new Object[0]);
                                }
                            }
                        }
                        Print.sysPrintln("", new Object[0]);
                        continue;
                    }
                    if (string20.startsWith(string15) || string20.startsWith(string16)) {
                        object9 = string20.startsWith(string15) ? string20.substring(string15.length()).trim() : string20.substring(string16.length()).trim();
                        EventRuleAction.EventDataText eventDataText = new EventRuleAction.EventDataText(account, device, eventData, null, null, null, null);
                        String string26 = eventDataText.toString((String)object9);
                        Print.sysPrintln("Message: " + string26, new Object[0]);
                        Print.sysPrintln("", new Object[0]);
                        continue;
                    }
                    object9 = null;
                    int n7 = 0;
                    if (string20.startsWith(string13) || string20.startsWith(string14)) {
                        block135: {
                            String string27;
                            if (account == null) {
                                Print.sysPrintln("Account not specified (required for RuleID specification)", new Object[0]);
                                Print.sysPrintln("", new Object[0]);
                                continue;
                            }
                            String[] stringArray4 = null;
                            if (string20.startsWith(string13)) {
                                stringArray4 = StringTools.split(string20.substring(string13.length()).trim(), ' ');
                            } else if (string20.startsWith(string14)) {
                                stringArray4 = StringTools.split(string20.substring(string14.length()).trim(), ' ');
                                n7 = 1;
                            }
                            String string28 = string27 = stringArray4.length >= 1 ? stringArray4[0] : null;
                            if (StringTools.isBlank(string27)) {
                                Print.sysPrintln("RuleID not specified", new Object[0]);
                                Print.sysPrintln("", new Object[0]);
                                continue;
                            }
                            object7 = stringArray4.length >= 2 ? stringArray4[1] : null;
                            try {
                                object9 = Rule.getRule(account, string27);
                                if (object9 == null) {
                                    Print.sysPrintln("RuleID does not exist: " + string27, new Object[0]);
                                    Print.sysPrintln("", new Object[0]);
                                    continue;
                                }
                                if (StringTools.isBlank((String)object7)) break block135;
                                ((Rule)object9).setCannedActions((String)object7);
                            }
                            catch (DBException dBException) {
                                Print.sysPrintln("Unable to retrieve Rule: " + dBException, new Object[0]);
                                Print.sysPrintln("", new Object[0]);
                                continue;
                            }
                        }
                        string20 = ((Rule)object9).getSelector();
                    }
                    AccountRecord accountRecord = eventData != null ? eventData : (device != null ? device : (account != null ? account : null));
                    Selector.Result result = EventSelector.getInstance().getResult(0, string20, accountRecord);
                    object7 = result.getValue();
                    String string29 = StringTools.className(object7);
                    if (string29.startsWith("java.lang.")) {
                        string29 = string29.substring("java.lang.".length());
                    }
                    Print.sysPrintln(" ==> object  : " + StringTools.className(accountRecord), new Object[0]);
                    Print.sysPrintln(" ==> selector: " + string20, new Object[0]);
                    Print.sysPrintln(" ==> value   : " + object7, new Object[0]);
                    Print.sysPrintln(" ==> type    : " + string29, new Object[0]);
                    Print.sysPrintln(" ==> match   : " + result.isMatch(), new Object[0]);
                    if (object9 != null) {
                        Print.sysPrintln("", new Object[0]);
                        if (result.isMatch()) {
                            boolean bl5 = true;
                            if (eventData != null) {
                                if (((Rule)object9).elapsedMinimumNotifyAge(eventData.getDevice())) {
                                    Print.sysPrintln("Updating RuleTrigger for Device/Rule ...", new Object[0]);
                                    RuleTrigger.setRuleTriggerTime(eventData.getDevice(), (Rule)object9, -1L);
                                } else {
                                    Print.sysPrintln("Skipping rule actions due to recent trigger ...\n", new Object[0]);
                                    bl5 = false;
                                }
                            } else if (device != null) {
                                if (((Rule)object9).elapsedMinimumNotifyAge(device)) {
                                    Print.sysPrintln("Updating RuleTrigger for Device/Rule ...", new Object[0]);
                                    RuleTrigger.setRuleTriggerTime(device, (Rule)object9, -1L);
                                } else {
                                    Print.sysPrintln("Skipping rule actions due to recent trigger ...\n", new Object[0]);
                                    bl5 = false;
                                }
                            } else if (account != null) {
                                if (((Rule)object9).elapsedMinimumNotifyAge(account)) {
                                    Print.sysPrintln("Updating RuleTrigger for Account/Rule ...", new Object[0]);
                                    RuleTrigger.setRuleTriggerTime(account, (Rule)object9, -1L);
                                } else {
                                    Print.sysPrintln("Skipping rule actions due to recent trigger ...\n", new Object[0]);
                                    bl5 = false;
                                }
                            } else {
                                Print.sysPrintln("Skipping rule actions due to unknown object type ...\n", new Object[0]);
                                bl5 = false;
                            }
                            if (bl5 && n7 != 0) {
                                if (eventData != null) {
                                    object6 = StringTools.trim(((Rule)object9).getCannedActions());
                                    if (object9 != null) {
                                        int n8 = ((Rule)object9).getActionMask();
                                        object5 = "[0x" + StringTools.toHexString(n8, 24) + "] " + EventRuleAction.GetActionMaskDescription(n8);
                                    } else {
                                        object5 = "default";
                                    }
                                    Print.sysPrintln("-----------------------------------------------------", new Object[0]);
                                    if (!StringTools.isBlank((String)object6)) {
                                        Print.sysPrintln("Executing Rule Actions: actionMask=" + (String)object5 + " [CRA " + (String)object6 + "]", new Object[0]);
                                    } else {
                                        Print.sysPrintln("Executing Rule Actions: actionMask=" + (String)object5, new Object[0]);
                                    }
                                    EventRuleAction._debugSendNotification(eventData, (Rule)object9);
                                    if (device != null) {
                                        device.updateOtherChangedEventFields();
                                    }
                                } else {
                                    Print.sysPrintln("Unable to execute Rule Action: event is null", new Object[0]);
                                }
                            }
                        } else if (eventData != null) {
                            Print.sysPrintln("Clearing RuleTrigger for Device/Rule ...\n", new Object[0]);
                            RuleTrigger.clearRuleTriggerTime(eventData.getDevice(), (Rule)object9);
                        } else if (device != null) {
                            Print.sysPrintln("Clearing RuleTrigger for Device/Rule ...\n", new Object[0]);
                            RuleTrigger.clearRuleTriggerTime(device, (Rule)object9);
                        } else if (account != null) {
                            Print.sysPrintln("Clearing RuleTrigger for Account/Rule ...\n", new Object[0]);
                            RuleTrigger.clearRuleTriggerTime(account, (Rule)object9);
                        }
                    }
                    Print.sysPrintln("", new Object[0]);
                }
                catch (ParserException parserException) {
                    Print.sysPrintln(" ERROR: " + parserException.getMessage(), new Object[0]);
                    for (String string30 : stringArray2) {
                        if (string20.indexOf(string30.substring(1)) < 0) continue;
                        Print.sysPrintln(" -- Missing prefixing '/'?", new Object[0]);
                        break;
                    }
                    Print.sysPrintln("", new Object[0]);
                }
            }
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("... exit ...", new Object[0]);
            Print.sysPrintln("", new Object[0]);
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

