/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.event;

import org.opengts.db.tables.Device;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.rule.event.EventIdentifierHandler;
import org.opengts.rule.event.EventIdentifierMap;
import org.opengts.rule.selector.IdentifierMap;
import org.opengts.rule.selector.IdentifierMapFactory;
import org.opengts.util.StringTools;

public class EventIdentifierMapFactory
extends IdentifierMapFactory {
    protected static final Long LONG_SUNDAY = new Long(0L);
    protected static final Long LONG_MONDAY = new Long(1L);
    protected static final Long LONG_TUESDAY = new Long(2L);
    protected static final Long LONG_WEDNESDAY = new Long(3L);
    protected static final Long LONG_THURSDAY = new Long(4L);
    protected static final Long LONG_FRIDAY = new Long(5L);
    protected static final Long LONG_SATURDAY = new Long(6L);

    @Override
    protected void initIdentifiers() {
        this.addIdentifier(new EventIdentifierHandler(new String[]{"account", "accountid"}){

            @Override
            public String getDescription() {
                return "Event account ID";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                return StringTools.trim(eventIdentifierMap.getAccountID());
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"device", "deviceid"}){

            @Override
            public String getDescription() {
                return "Event device ID";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                return StringTools.trim(eventIdentifierMap.getDeviceID());
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"statuscode", "code"}){

            @Override
            public String getDescription() {
                return "Event status code";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? (long)eventData.getStatusCode() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"timestamp", "time"}){

            @Override
            public String getDescription() {
                return "Event Epoch timestamp (seconds)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? eventData.getTimestamp() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"latitude", "lat"}){

            @Override
            public String getDescription() {
                return "Event latitude (degrees)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getLatitude() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"longitude", "lon"}){

            @Override
            public String getDescription() {
                return "Event longitude (degrees)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getLongitude() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"gpsage", "age"}){

            @Override
            public String getDescription() {
                return "Event GPS age (seconds)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? eventData.getGpsAge() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"creationage", "createage"}){

            @Override
            public String getDescription() {
                return "Event Creation age (seconds)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? eventData.getCreationAge() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"speed", "kph", "speedkph"}){

            @Override
            public String getDescription() {
                return "Event speed (kph)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getSpeedKPH() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"speedmph", "mph"}){

            @Override
            public String getDescription() {
                return "Event speed (mph)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getSpeedKPH() * 0.621371192237334 : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"speedknots", "knots"}){

            @Override
            public String getDescription() {
                return "Event speed (knots)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getSpeedKPH() * 0.5399568034557235 : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"postedspeed", "postedkph"}){

            @Override
            public String getDescription() {
                return "Posted speed (km/h)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getSpeedLimitKPH() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"postedmph"}){

            @Override
            public String getDescription() {
                return "Posted speed (mph)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getSpeedLimitKPH() * 0.621371192237334 : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"heading", "head"}){

            @Override
            public String getDescription() {
                return "Event heading (degrees)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getHeading() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"altitude", "altm"}){

            @Override
            public String getDescription() {
                return "Event altitude (meters)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getAltitude() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"distance", "distkm"}){

            @Override
            public String getDescription() {
                return "Event distance (km)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getDistanceKM() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"odometer", "odomkm"}){

            @Override
            public String getDescription() {
                return "Event odometer (km)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getOdometerKM() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"address"}){

            @Override
            public String getDescription() {
                return "Event Address";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null ? eventData.getAddress() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"subdivision", "state"}){

            @Override
            public String getDescription() {
                return "Event subdivision/state";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null ? eventData.getSubdivision() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"geozoneid", "zoneid"}){

            @Override
            public String getDescription() {
                return "Event geozone id";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null ? eventData.getGeozoneID() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"geozone", "zone"}){

            @Override
            public String getDescription() {
                return "Event geozone description";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null ? eventData.getGeozoneDescription() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"geozoneindex", "zoneindex"}){

            @Override
            public String getDescription() {
                return "Event geozone index";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? eventData.getGeozoneIndex() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"j1708fault", "faultCode"}){

            @Override
            public String getDescription() {
                return "Event OBD fault";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? eventData.getFieldValue("j1708Fault", 0L) : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"input", "inputMask"}){

            @Override
            public String getDescription() {
                return "Event inputMask";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? eventData.getInputMask() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"lastInput", "lastInputMask"}){

            @Override
            public String getDescription() {
                return "Device lastInput";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                return new Long(device != null ? device.getLastInputState() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"ignition", "ignitionState"}){

            @Override
            public String getDescription() {
                return "Event ignition state";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                Device device = eventIdentifierMap.getDevice();
                if (device == null) {
                    return new Long(-1L);
                }
                switch (device.getIgnitionStateAsOfEvent(eventData)) {
                    case 0: {
                        return new Long(0L);
                    }
                    case 1: {
                        return new Long(1L);
                    }
                }
                return new Long(-1L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"currentIgnition", "lastIgnition", "lastIgnitionState"}){

            @Override
            public String getDescription() {
                return "Device last ignition state";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                if (device == null) {
                    return new Long(-1L);
                }
                switch (device.getCurrentIgnitionState()) {
                    case 0: {
                        return new Long(0L);
                    }
                    case 1: {
                        return new Long(1L);
                    }
                }
                return new Long(-1L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"lastIgnitionOnTime"}){

            @Override
            public String getDescription() {
                return "Device last ignition on time";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                if (device == null) {
                    return new Long(-1L);
                }
                return new Long(device.getLastIgnitionOnTime());
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"lastIgnitionOffTime"}){

            @Override
            public String getDescription() {
                return "Device last ignition off time";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                if (device == null) {
                    return new Long(-1L);
                }
                return new Long(device.getLastIgnitionOffTime());
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"dcs", "dcserver", "deviceCode"}){

            @Override
            public String getDescription() {
                return "Device DCS";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                return device != null ? device.getDeviceCode() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"vin", "vehicleID"}){

            @Override
            public String getDescription() {
                return "Vehice ID";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                return device != null ? device.getVehicleID() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"lastVin", "lastVehicleID"}){

            @Override
            public String getDescription() {
                return "Last Vehice ID";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                return device != null ? device.getLastVehicleID() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"equipmentType", "equipType"}){

            @Override
            public String getDescription() {
                return "Equipment Status";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                return device != null ? device.getEquipmentType() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"equipmentStatus", "equipStat"}){

            @Override
            public String getDescription() {
                return "Equipment Status";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                return new Long(device != null ? (long)device.getEquipmentStatus() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"priority"}){

            @Override
            public String getDescription() {
                return "Event priority";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? (long)eventData.getPriority() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"fuelLevel"}){

            @Override
            public String getDescription() {
                return "Event fuelLevel percent";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getFuelLevel(true) : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"fuelLevel2"}){

            @Override
            public String getDescription() {
                return "Event fuelLevel-2 percent";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getFuelLevel2() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"batteryLevel"}){

            @Override
            public String getDescription() {
                return "Event batteryLevel percent";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getBatteryLevel() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"batteryVolts"}){

            @Override
            public String getDescription() {
                return "Event batteryVolts";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getBatteryVolts() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"vehicleVolts", "vBatteryVolts"}){

            @Override
            public String getDescription() {
                return "Event vBatteryVolts";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getVBatteryVolts() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"coolantTemp", "coolantTemperature"}){

            @Override
            public String getDescription() {
                return "Event Coolant Temp";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getCoolantTemp() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"coolantLevel"}){

            @Override
            public String getDescription() {
                return "Event Coolant Level %";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getCoolantLevel() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"oilTemp", "oilTemperature"}){

            @Override
            public String getDescription() {
                return "Event Oil Temp";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getOilTemp() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"oilLevel"}){

            @Override
            public String getDescription() {
                return "Event Oil Level %";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getOilLevel() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"oilPressure"}){

            @Override
            public String getDescription() {
                return "Event Oil Pressure";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getOilPressure() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"engineRpm", "rpm"}){

            @Override
            public String getDescription() {
                return "Event Engine RPM";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Long(eventData != null ? eventData.getEngineRpm() : 0L);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thermoAverage0", "temp0", "temperature0"}){

            @Override
            public String getDescription() {
                return "Event Temperature #0";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getThermoAverage0() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thermoAverage1", "temp1", "temperature1"}){

            @Override
            public String getDescription() {
                return "Event Temperature #1";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getThermoAverage1() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thermoAverage2", "temp2", "temperature2"}){

            @Override
            public String getDescription() {
                return "Event Temperature #2";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getThermoAverage2() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thermoAverage3", "temp3", "temperature3"}){

            @Override
            public String getDescription() {
                return "Event Temperature #3";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getThermoAverage3() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thermoAverage4", "temp4", "temperature4"}){

            @Override
            public String getDescription() {
                return "Event Temperature #4";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getThermoAverage4() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thermoAverage5", "temp5", "temperature5"}){

            @Override
            public String getDescription() {
                return "Event Temperature #5";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getThermoAverage5() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thermoAverage6", "temp6", "temperature6"}){

            @Override
            public String getDescription() {
                return "Event Temperature #6";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getThermoAverage6() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thermoAverage7", "temp7", "temperature7"}){

            @Override
            public String getDescription() {
                return "Event Temperature #7";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getThermoAverage7() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"analog0"}){

            @Override
            public String getDescription() {
                return "Event Analog #0";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getAnalog0() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"analog1"}){

            @Override
            public String getDescription() {
                return "Event Analog #1";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getAnalog1() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"analog2"}){

            @Override
            public String getDescription() {
                return "Event Analog #2";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getAnalog2() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"analog3"}){

            @Override
            public String getDescription() {
                return "Event Analog #3";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getAnalog3() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"pulseCount"}){

            @Override
            public String getDescription() {
                return "Event Pulse Count";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return new Double(eventData != null ? eventData.getPulseCount() : 0.0);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"driver", "driverID"}){

            @Override
            public String getDescription() {
                return "Event driver ID";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                return eventIdentifierMap.getDriverID();
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"driverBadge", "driverBadgeID"}){

            @Override
            public String getDescription() {
                return "Event driver badge ID";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Driver driver = eventIdentifierMap.getDriver();
                return driver != null ? driver.getBadgeID() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"driverLic", "driverLicense"}){

            @Override
            public String getDescription() {
                return "Event driver license";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Driver driver = eventIdentifierMap.getDriver();
                return driver != null ? driver.getLicenseNumber() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"driverLicExpire", "driverLicExpiration"}){

            @Override
            public String getDescription() {
                return "Event driver license expiration";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Driver driver = eventIdentifierMap.getDriver();
                long l = driver != null ? driver.getLicenseExpire() : 0L;
                return new Long(l);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"trailer", "entity"}){

            @Override
            public String getDescription() {
                return "Event trailer/entity ID";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null ? eventData.getFieldValue("entityID", "") : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"jobNumber", "eventJobNumber", "eventJobID"}){

            @Override
            public String getDescription() {
                return "Event Job ID";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null ? eventData.getFieldValue("jobNumber", "") : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"deviceJobNumber", "deviceJobID"}){

            @Override
            public String getDescription() {
                return "Device Job Number";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                Device device = eventIdentifierMap.getDevice();
                return device != null ? device.getJobNumber() : "";
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"costCenter", "eventCostCenter"}){

            @Override
            public String getDescription() {
                return "Event Cost Center";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null ? eventData.getFieldValue("costCenter", 0L) : LONG_ZERO.longValue();
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"isFirst", "firstEvent", "isFirstEvent"}){

            @Override
            public String getDescription() {
                return "Last Event in list";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null && eventData.getIsFirstEvent() ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"isLast", "lastEvent", "isLastEvent"}){

            @Override
            public String getDescription() {
                return "Last Event in list";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                EventIdentifierMap eventIdentifierMap = (EventIdentifierMap)identifierMap;
                EventData eventData = eventIdentifierMap.getEventData();
                return eventData != null && eventData.getIsLastEvent() ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"pi"}){

            @Override
            public String getDescription() {
                return "Pi 3.141592653 ...";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return new Double(Math.PI);
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"true"}){

            @Override
            public String getDescription() {
                return "True";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_TRUE;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"false"}){

            @Override
            public String getDescription() {
                return "False";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_FALSE;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"sunday", "sun"}){

            @Override
            public String getDescription() {
                return "Day-Of-Week: Sunday (0)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_SUNDAY;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"monday", "mon"}){

            @Override
            public String getDescription() {
                return "Day-Of-Week: Monday (1)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_MONDAY;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"tuesday", "tue"}){

            @Override
            public String getDescription() {
                return "Day-Of-Week: Tuesday (2)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_TUESDAY;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"wednesday", "wed"}){

            @Override
            public String getDescription() {
                return "Day-Of-Week: Wednesday (3)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_WEDNESDAY;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"thursday", "thu"}){

            @Override
            public String getDescription() {
                return "Day-Of-Week: Thursday (4)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_THURSDAY;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"friday", "fri"}){

            @Override
            public String getDescription() {
                return "Day-Of-Week: Friday (5)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_FRIDAY;
            }
        });
        this.addIdentifier(new EventIdentifierHandler(new String[]{"saturday", "sat"}){

            @Override
            public String getDescription() {
                return "Day-Of-Week: Saturday (6)";
            }

            @Override
            public Object getValue(IdentifierMap identifierMap) {
                return LONG_SATURDAY;
            }
        });
    }
}

