/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.event;

import java.io.File;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.TimeZone;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DeviceRecord;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.StatusCode;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtypes.DTOBDFault;
import org.opengts.rule.event.EventFunctionHandler;
import org.opengts.rule.event.EventFunctionMap;
import org.opengts.rule.event.EventSelector;
import org.opengts.rule.selector.FunctionMap;
import org.opengts.rule.selector.FunctionMapFactory;
import org.opengts.rule.selector.ParserException;
import org.opengts.rule.selector.Selector;
import org.opengts.rule.tables.GeoCorridor;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class EventFunctionMapFactory
extends FunctionMapFactory {
    protected static boolean IsDateValid(int n, int n2, int n3) {
        if (n2 < 1 || n2 > 12 || n < 1 || n3 < 1800 || n3 > 2300) {
            return false;
        }
        if (n <= 28) {
            return true;
        }
        return n <= DateTime.getMaxMonthDayCount(n2, DateTime.isLeapYear(n3));
    }

    protected static DateTime GetDateTime(FunctionMap functionMap, Object[] objectArray, long l) {
        EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
        DateTime dateTime = null;
        if (objectArray.length == 0) {
            TimeZone timeZone = eventFunctionMap.getTimeZone();
            dateTime = new DateTime(l, timeZone);
        } else if (EventFunctionHandler.IsNumericArg(objectArray[0])) {
            TimeZone timeZone = eventFunctionMap.getTimeZone();
            long l2 = EventFunctionHandler.LongValue(objectArray[0]);
            dateTime = new DateTime(l2, timeZone);
        }
        return dateTime;
    }

    @Override
    protected void initFunctions() {
        this.addFunction(new EventFunctionHandler(new String[]{"$SC", "$CODE"}){

            @Override
            public String getUsage() {
                return "Boolean $SC(Long A [, Long B [, Long C [, Long D]]])";
            }

            @Override
            public String getDescription() {
                return "True iff current StatusCode matches a listed code";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, 3, 4, Long.class, Long.class, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 4 || !1.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                int n = eventFunctionMap.getStatusCode();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (n != (int)1.LongValue(objectArray[i])) continue;
                    return LONG_TRUE;
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$SCINP", "$DIN", "$ISDIN"}){

            @Override
            public String getUsage() {
                return "Boolean $SCINP([Long X [,Boolean S])";
            }

            @Override
            public String getDescription() {
                return "True iff StatusCode is digital input (X, if specified) (with state S, if specified)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, Long.class, Boolean.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 2 || !2.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                boolean bl = false;
                if (objectArray.length == 0) {
                    int n = eventFunctionMap.getStatusCode();
                    return StatusCodes.IsDigitalInput(n, bl) ? LONG_TRUE : LONG_FALSE;
                }
                if (objectArray.length == 1) {
                    int n = 2.IntValue(objectArray[0]) - 1;
                    int n2 = eventFunctionMap.getStatusCode();
                    if (n < 0) {
                        return StatusCodes.IsDigitalInput(n2, bl) ? LONG_TRUE : LONG_FALSE;
                    }
                    if (n == StatusCodes.GetDigitalInputIndex(n2)) {
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                int n = 2.IntValue(objectArray[0]);
                boolean bl2 = 2.BooleanValue(objectArray[1]);
                int n3 = eventFunctionMap.getStatusCode();
                if (n < 0) {
                    if (bl2) {
                        return StatusCodes.IsDigitalInputOn(n3, bl) ? LONG_TRUE : LONG_FALSE;
                    }
                    return StatusCodes.IsDigitalInputOff(n3, bl) ? LONG_TRUE : LONG_FALSE;
                }
                if (n == StatusCodes.GetDigitalInputIndex(n3)) {
                    if (bl2) {
                        return StatusCodes.IsDigitalInputOn(n3, bl) ? LONG_TRUE : LONG_FALSE;
                    }
                    return StatusCodes.IsDigitalInputOff(n3, bl) ? LONG_TRUE : LONG_FALSE;
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$INP", "$INPUT"}){

            @Override
            public String getUsage() {
                return "Boolean $INPUT([Long BIT])";
            }

            @Override
            public String getDescription() {
                return "True iff Event 'inputMask' BIT is true";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                int n;
                if (objectArray.length > 1 || !3.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_FALSE;
                }
                long l = eventData.getInputMask();
                int n2 = n = objectArray.length > 0 ? 3.IntValue(objectArray[0]) : -1;
                if (n < 0) {
                    return l != 0L ? LONG_TRUE : LONG_FALSE;
                }
                long l2 = 1L << n;
                return (l & l2) != 0L ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DOW"}){

            @Override
            public String getUsage() {
                return "Long $DOW([{Timestamp T} | {Long DAY, Long MONTH [, Long YEAR]}])";
            }

            @Override
            public String getDescription() {
                return "Event time (or T, if specified) day-of-week";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, 3, Long.class, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                int n;
                if (objectArray.length > 3 || !4.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                if (objectArray.length <= 1) {
                    DateTime dateTime = EventFunctionMapFactory.GetDateTime(eventFunctionMap, objectArray, 0L);
                    if (dateTime == null) {
                        Print.logWarn("Timestamp parsing error", new Object[0]);
                        return null;
                    }
                    if (dateTime.getTimeSec() == 0L) {
                        return new Long(0L);
                    }
                    return new Long(dateTime.getDayOfWeek());
                }
                TimeZone timeZone = eventFunctionMap.getTimeZone();
                int n2 = 4.IntValue(objectArray[0]);
                int n3 = 4.IntValue(objectArray[1]);
                int n4 = n = objectArray.length >= 3 ? 4.IntValue(objectArray[2]) : new DateTime(eventFunctionMap.getTimestamp(), timeZone).getYear();
                if (n <= 99) {
                    n += 2000;
                }
                if (!EventFunctionMapFactory.IsDateValid(n2, n3, n)) {
                    Print.logWarn("Invalid Date/Time", new Object[0]);
                    return null;
                }
                DateTime dateTime = new DateTime(timeZone, n, n3, n2, 12, 0, 0);
                return new Long(dateTime.getDayOfWeek());
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DAY"}){

            @Override
            public String getUsage() {
                return "Long $DAY([{Timestamp T} | {Long DAY, Long MONTH [, Long YEAR]}])";
            }

            @Override
            public String getDescription() {
                return "Gregorian day of Event, or T, or DAY,MONTH,YEAR";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return DateTime.getDayNumberFromDate(new DateTime());
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, 3, Long.class, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                long l;
                if (objectArray.length > 3 || !5.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                if (objectArray.length == 0) {
                    DateTime dateTime = new DateTime(eventFunctionMap.getTimestamp(), eventFunctionMap.getTimeZone());
                    l = DateTime.getDayNumberFromDate(dateTime);
                } else if (objectArray.length == 1) {
                    DateTime dateTime = new DateTime(5.LongValue(objectArray[0]), eventFunctionMap.getTimeZone());
                    l = DateTime.getDayNumberFromDate(dateTime);
                } else {
                    int n;
                    TimeZone timeZone = eventFunctionMap.getTimeZone();
                    int n2 = 5.IntValue(objectArray[0]);
                    int n3 = 5.IntValue(objectArray[1]);
                    int n4 = n = objectArray.length >= 3 ? 5.IntValue(objectArray[2]) : new DateTime(eventFunctionMap.getTimestamp(), timeZone).getYear();
                    if (n <= 99) {
                        n += 2000;
                    }
                    if (!EventFunctionMapFactory.IsDateValid(n2, n3, n)) {
                        return null;
                    }
                    l = DateTime.getDayNumberFromDate(n, n3, n2);
                }
                return new Long(l);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$WEEKDAY", "$WD"}){

            @Override
            public String getUsage() {
                return "Boolean $WEEKDAY([{Timestamp T} | {Long DAY, Long MONTH [, Long YEAR]}])";
            }

            @Override
            public String getDescription() {
                return "True iff Event time (or T, if specified) is a weekday";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, 3, Long.class, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                int n;
                if (objectArray.length > 3 || !6.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                if (objectArray.length <= 1) {
                    DateTime dateTime = EventFunctionMapFactory.GetDateTime(eventFunctionMap, objectArray, 0L);
                    if (dateTime == null) {
                        Print.logWarn("Timestamp parsing error", new Object[0]);
                        return null;
                    }
                    if (dateTime.getTimeSec() == 0L) {
                        return LONG_FALSE;
                    }
                    int n2 = dateTime.getDayOfWeek();
                    return n2 >= 1 && n2 <= 5 ? LONG_TRUE : LONG_FALSE;
                }
                TimeZone timeZone = eventFunctionMap.getTimeZone();
                int n3 = 6.IntValue(objectArray[0]);
                int n4 = 6.IntValue(objectArray[1]);
                int n5 = n = objectArray.length >= 3 ? 6.IntValue(objectArray[2]) : new DateTime(eventFunctionMap.getTimestamp(), timeZone).getYear();
                if (n <= 99) {
                    n += 2000;
                }
                if (!EventFunctionMapFactory.IsDateValid(n3, n4, n)) {
                    return null;
                }
                DateTime dateTime = new DateTime(timeZone, n, n4, n3, 12, 0, 0);
                int n6 = dateTime.getDayOfWeek();
                return n6 >= 1 && n6 <= 5 ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$WEEKEND", "$WE"}){

            @Override
            public String getUsage() {
                return "Boolean $WEEKEND([{Timestamp T} | {Long DAY, Long MONTH [, Long YEAR]}])";
            }

            @Override
            public String getDescription() {
                return "True iff Event time (or T, if specified) is a weekend";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, 3, Long.class, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                int n;
                if (objectArray.length > 3 || !7.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                if (objectArray.length <= 1) {
                    DateTime dateTime = EventFunctionMapFactory.GetDateTime(eventFunctionMap, objectArray, 0L);
                    if (dateTime == null) {
                        Print.logWarn("Timestamp parsing error", new Object[0]);
                        return null;
                    }
                    if (dateTime.getTimeSec() == 0L) {
                        return LONG_FALSE;
                    }
                    int n2 = dateTime.getDayOfWeek();
                    return n2 >= 1 && n2 <= 5 ? LONG_FALSE : LONG_TRUE;
                }
                TimeZone timeZone = eventFunctionMap.getTimeZone();
                int n3 = 7.IntValue(objectArray[0]);
                int n4 = 7.IntValue(objectArray[1]);
                int n5 = n = objectArray.length >= 3 ? 7.IntValue(objectArray[2]) : new DateTime(eventFunctionMap.getTimestamp(), timeZone).getYear();
                if (n <= 99) {
                    n += 2000;
                }
                if (!EventFunctionMapFactory.IsDateValid(n3, n4, n)) {
                    return null;
                }
                DateTime dateTime = new DateTime(timeZone, n, n4, n3, 12, 0, 0);
                int n6 = dateTime.getDayOfWeek();
                return n6 >= 1 && n6 <= 5 ? LONG_FALSE : LONG_TRUE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$TOD"}){

            @Override
            public String getUsage() {
                return "Long $TOD([{Timestamp T} | {String HHMM} | {Long HOUR, Long MIN}])";
            }

            @Override
            public String getDescription() {
                return "Time of day (minute: 0..1440)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                DateTime dateTime = new DateTime();
                return new Long((long)dateTime.getHour24() * 60L + (long)dateTime.getMinute());
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, Object.class, Long.class);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                long l;
                if (objectArray.length > 2) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                if (objectArray.length == 0) {
                    DateTime dateTime = new DateTime(eventFunctionMap.getTimestamp(), eventFunctionMap.getTimeZone());
                    l = (long)dateTime.getHour24() * 60L + (long)dateTime.getMinute();
                    return new Long(l);
                } else if (objectArray.length == 1) {
                    if (8.IsStringArg(objectArray[0])) {
                        String string = ((String)objectArray[0]).trim();
                        int n = string.indexOf(":");
                        if (n <= 0) return null;
                        int n2 = StringTools.parseInt(string.substring(0, n), -1);
                        int n3 = StringTools.parseInt(string.substring(n + 1), -1);
                        if (n2 < 0 || n2 > 23 || n3 < 0 || n3 > 59) return null;
                        l = (long)n2 * 60L + (long)n3;
                        return new Long(l);
                    } else {
                        long l2 = 8.LongValue(objectArray[0]);
                        if (l2 < 0L) {
                            return null;
                        }
                        if (l2 <= 2400L) {
                            long l3 = l2 / 100L % 24L;
                            long l4 = l2 % 100L % 60L;
                            l = l3 * 60L + l4;
                            return new Long(l);
                        } else {
                            DateTime dateTime = new DateTime(l2, eventFunctionMap.getTimeZone());
                            l = (long)dateTime.getHour24() * 60L + (long)dateTime.getMinute();
                        }
                    }
                    return new Long(l);
                } else {
                    if (!8.HasNumericArgs(objectArray)) return null;
                    long l5 = 8.LongValue(objectArray[0]) % 24L;
                    long l6 = 8.LongValue(objectArray[1]) % 60L;
                    l = l5 * 60L + l6;
                }
                return new Long(l);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$TODRANGE", "$TODR"}){

            @Override
            public String getUsage() {
                return "Boolean $TODRANGE(Long FROMTOD, Long TOTOD)";
            }

            @Override
            public String getDescription() {
                return "True iff Event time is within TOD range";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                long l;
                long l2;
                if (objectArray.length < 2 || !9.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                long l3 = eventFunctionMap.getTimestamp(0L);
                if (l3 <= 0L) {
                    return LONG_FALSE;
                }
                DateTime dateTime = new DateTime(l3, eventFunctionMap.getTimeZone());
                long l4 = (long)dateTime.getHour24() * 60L + (long)dateTime.getMinute();
                long l5 = 9.LongValue(objectArray[0]);
                long l6 = l5 / 100L % 24L * 60L + l5 % 100L % 60L;
                if (l6 <= (l2 = (l = 9.LongValue(objectArray[1])) / 100L % 24L * 60L + l % 100L % 60L)) {
                    if (l4 < l6) {
                        return LONG_FALSE;
                    }
                    if (l4 > l2) {
                        return LONG_FALSE;
                    }
                    return LONG_TRUE;
                }
                if (l4 >= l6) {
                    return LONG_TRUE;
                }
                if (l4 <= l2) {
                    return LONG_TRUE;
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ZONE", "$ZONEEXISTS"}){

            @Override
            public String getUsage() {
                return "Boolean $ZONE(String zoneID [, Long sortID])";
            }

            @Override
            public String getDescription() {
                return "True iff the specified zoneID exists";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, String.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 2 || !10.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                if (objectArray.length == 1) {
                    String string = eventFunctionMap.getAccountID();
                    String string2 = (String)objectArray[0];
                    int n = -1;
                    try {
                        boolean bl = Geozone.exists(string, string2, n);
                        return bl ? LONG_TRUE : LONG_FALSE;
                    }
                    catch (DBException dBException) {
                        Print.logError("DBException: " + dBException.getMessage(), new Object[0]);
                        return null;
                    }
                }
                if (objectArray.length == 2 && 10.IsNumericArg(objectArray[1])) {
                    String string = eventFunctionMap.getAccountID();
                    String string3 = (String)objectArray[0];
                    int n = 10.IntValue(objectArray[1]);
                    try {
                        boolean bl = Geozone.exists(string, string3, n);
                        return bl ? LONG_TRUE : LONG_FALSE;
                    }
                    catch (DBException dBException) {
                        Print.logError("DBException: " + dBException.getMessage(), new Object[0]);
                        return null;
                    }
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$INZONEP", "$INSIDEP"}){

            @Override
            public String getUsage() {
                return "Boolean $INZONEP({String PURPOSE_ID})";
            }

            @Override
            public String getDescription() {
                return "True iff Event is inside a zone matching purpose";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !11.IsStringArg(objectArray[0])) {
                    return null;
                }
                String string = (String)objectArray[0];
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string2 = eventFunctionMap.getAccountID();
                String string3 = eventFunctionMap.getDeviceID();
                GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                if (!geoPoint.isValid()) {
                    return LONG_FALSE;
                }
                Geozone geozone = Geozone.getGeozone(string2, null, geoPoint, string, false);
                if (geozone != null && !geozone.isDeviceInGroup(string3)) {
                    geozone = null;
                }
                return geozone != null ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$INZONE", "$IN", "$INSIDE"}){

            @Override
            public String getUsage() {
                return "Boolean $INZONE([{String ID} | {Double LAT, Double LON, Double RAD}])";
            }

            @Override
            public String getDescription() {
                return "True iff Event is inside specified zone(ID), or point(LAT,LON,RAD)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 3, Object.class, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 3) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string = eventFunctionMap.getDeviceID();
                String string2 = eventFunctionMap.getDeviceID();
                if (objectArray.length == 0) {
                    GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                    Geozone geozone = Geozone.getGeozone(string, null, geoPoint, null, false);
                    if (geozone != null && !geozone.isDeviceInGroup(string2)) {
                        geozone = null;
                    }
                    return geozone != null ? LONG_TRUE : LONG_FALSE;
                }
                if (objectArray.length == 1 && 12.IsStringArg(objectArray[0])) {
                    Object object;
                    Account account = eventFunctionMap.getAccount();
                    EventData eventData = eventFunctionMap.getEventData();
                    String string3 = (String)objectArray[0];
                    if (eventData != null && eventData.getStatusCode() == 61968 && !StringTools.isBlank((String)(object = eventData.getGeozoneID())) && ((String)object).equals(string3)) {
                        return LONG_TRUE;
                    }
                    object = eventFunctionMap.getGeoPoint();
                    try {
                        boolean bl = Geozone.containsPoint(account, string3, (GeoPoint)object);
                        return bl ? LONG_TRUE : LONG_FALSE;
                    }
                    catch (DBNotFoundException dBNotFoundException) {
                        Print.logError("DBNotFoundException: " + dBNotFoundException.getMessage(), new Object[0]);
                        return null;
                    }
                }
                if (objectArray.length == 3 && 12.HasNumericArgs(objectArray)) {
                    GeoPoint geoPoint = new GeoPoint(12.DoubleValue(objectArray[0]), 12.DoubleValue(objectArray[1]));
                    double d = 12.DoubleValue(objectArray[2]);
                    double d2 = geoPoint.kilometersToPoint(eventFunctionMap.getGeoPoint()) * 1000.0;
                    return d2 <= d ? LONG_TRUE : LONG_FALSE;
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$CORRIDOR", "$INCORR"}){

            @Override
            public String getUsage() {
                return "Boolean $CORRIDOR([String ID])";
            }

            @Override
            public String getDescription() {
                return "Return true if inside corridor";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, String.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                boolean bl;
                Object object;
                AccountRecord accountRecord;
                String string;
                if (objectArray.length > 2) {
                    return null;
                }
                if (objectArray.length >= 1 && !13.IsStringArg(objectArray[0])) {
                    return null;
                }
                if (objectArray.length >= 2 && !13.IsNumericArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string2 = string = objectArray.length >= 1 ? 13.StringValue(objectArray[0]) : "";
                if (StringTools.isBlank(string)) {
                    accountRecord = eventFunctionMap.getEventData();
                    Object object2 = object = accountRecord != null ? ((DeviceRecord)accountRecord).getDevice() : null;
                    if (object != null) {
                        string = ((Device)object).getActiveCorridor();
                    }
                }
                if (StringTools.isBlank(string)) {
                    return LONG_TRUE;
                }
                accountRecord = null;
                try {
                    accountRecord = GeoCorridor.getGeoCorridor(eventFunctionMap.getAccount(), string);
                    if (accountRecord == null) {
                        return LONG_FALSE;
                    }
                }
                catch (DBException dBException) {
                    Print.logException("Unable to retrieve GeoCorridor: " + string, dBException);
                    return LONG_FALSE;
                }
                object = eventFunctionMap.getGeoPoint();
                try {
                    if (((GeoCorridor)accountRecord).containsPoint((GeoPoint)object)) {
                        Print.logDebug("Corridor Contains point: true", new Object[0]);
                        return LONG_TRUE;
                    }
                }
                catch (DBException dBException) {
                    Print.logException("Unable to check GeoCorridor: " + string, dBException);
                    return LONG_FALSE;
                }
                boolean bl2 = bl = objectArray.length >= 2 && 13.BooleanValue(objectArray[1]);
                if (bl) {
                    try {
                        GeoPoint geoPoint = eventFunctionMap.getPreviousGeoPoint();
                        if (!((GeoCorridor)accountRecord).containsPoint(geoPoint)) {
                            Print.logDebug("Corridor Contains point: false (previous out also outside point)", new Object[0]);
                            return LONG_TRUE;
                        }
                    }
                    catch (DBException dBException) {
                        Print.logException("Unable to check GeoCorridor: " + string, dBException);
                        return LONG_FALSE;
                    }
                }
                Print.logDebug("Corridor Contains point: false", new Object[0]);
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$CDEPART", "$CDEP"}){

            @Override
            public String getUsage() {
                return "Boolean $CDEPART([String ID])";
            }

            @Override
            public String getDescription() {
                return "True iff Event has departed corridor(ID)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                AccountRecord accountRecord;
                String string;
                if (objectArray.length > 1) {
                    return null;
                }
                if (objectArray.length >= 1 && !14.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                if (!GeoPoint.isValid(geoPoint)) {
                    return LONG_FALSE;
                }
                String string2 = string = objectArray.length >= 1 ? 14.StringValue(objectArray[0]) : "";
                if (StringTools.isBlank(string)) {
                    Device device;
                    accountRecord = eventFunctionMap.getEventData();
                    Device device2 = device = accountRecord != null ? ((DeviceRecord)accountRecord).getDevice() : null;
                    if (device != null) {
                        string = device.getActiveCorridor();
                    }
                }
                if (StringTools.isBlank(string)) {
                    Print.logInfo("Depart Corridor: false (No corridor specified)", new Object[0]);
                    return LONG_FALSE;
                }
                accountRecord = null;
                try {
                    accountRecord = GeoCorridor.getGeoCorridor(eventFunctionMap.getAccount(), string);
                    if (accountRecord == null) {
                        Print.logInfo("Depart Corridor: false (corridor not found)", new Object[0]);
                        return LONG_FALSE;
                    }
                }
                catch (DBException dBException) {
                    Print.logException("Unable to retrieve Departure GeoCorridor: (true) " + string, dBException);
                    return LONG_TRUE;
                }
                try {
                    if (((GeoCorridor)accountRecord).containsPoint(geoPoint)) {
                        Print.logInfo("Depart Corridor: false (currently inside)", new Object[0]);
                        return LONG_FALSE;
                    }
                }
                catch (DBException dBException) {
                    Print.logException("Unable to retrieve Departure GeoCorridor: (true) " + string, dBException);
                    return LONG_TRUE;
                }
                boolean bl = true;
                if (bl) {
                    try {
                        GeoPoint geoPoint2 = eventFunctionMap.getPreviousGeoPoint();
                        if (!((GeoCorridor)accountRecord).containsPoint(geoPoint2)) {
                            Print.logInfo("Depart Corridor: false (already outside)", new Object[0]);
                            return LONG_FALSE;
                        }
                    }
                    catch (DBException dBException) {
                        Print.logException("Unable to retrieve Departure GeoCorridor: (true) " + string, dBException);
                        return LONG_TRUE;
                    }
                }
                Print.logInfo("Depart Corridor: true", new Object[0]);
                return LONG_TRUE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$CARRIVE", "$CARR"}){

            @Override
            public String getUsage() {
                return "Boolean $CARRIVE([String ID])";
            }

            @Override
            public String getDescription() {
                return "True iff Event has arrived in corridor(ID)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                AccountRecord accountRecord;
                String string;
                if (objectArray.length > 1) {
                    return null;
                }
                if (objectArray.length >= 1 && !15.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                if (!GeoPoint.isValid(geoPoint)) {
                    return LONG_FALSE;
                }
                String string2 = string = objectArray.length >= 1 ? 15.StringValue(objectArray[0]) : "";
                if (StringTools.isBlank(string)) {
                    Device device;
                    accountRecord = eventFunctionMap.getEventData();
                    Device device2 = device = accountRecord != null ? ((DeviceRecord)accountRecord).getDevice() : null;
                    if (device != null) {
                        string = device.getActiveCorridor();
                    }
                }
                if (StringTools.isBlank(string)) {
                    Print.logInfo("Arrive Corridor: false (No corridor specified)", new Object[0]);
                    return LONG_FALSE;
                }
                accountRecord = null;
                try {
                    accountRecord = GeoCorridor.getGeoCorridor(eventFunctionMap.getAccount(), string);
                    if (accountRecord == null) {
                        Print.logInfo("Arrive Corridor: false (corridor not found)", new Object[0]);
                        return LONG_FALSE;
                    }
                }
                catch (DBException dBException) {
                    Print.logException("Unable to retrieve Arrival GeoCorridor: (true) " + string, dBException);
                    return LONG_TRUE;
                }
                try {
                    if (!((GeoCorridor)accountRecord).containsPoint(geoPoint)) {
                        Print.logInfo("Arrive Corridor: false (currently outside)", new Object[0]);
                        return LONG_FALSE;
                    }
                }
                catch (DBException dBException) {
                    Print.logException("Unable to retrieve Arrival GeoCorridor: (false) " + string, dBException);
                    return LONG_FALSE;
                }
                boolean bl = true;
                if (bl) {
                    try {
                        GeoPoint geoPoint2 = eventFunctionMap.getPreviousGeoPoint();
                        if (((GeoCorridor)accountRecord).containsPoint(geoPoint2)) {
                            Print.logInfo("Arrive Corridor: false (already inside)", new Object[0]);
                            return LONG_FALSE;
                        }
                    }
                    catch (DBException dBException) {
                        Print.logException("Unable to retrieve Arrival GeoCorridor: (true) " + string, dBException);
                        return LONG_TRUE;
                    }
                }
                Print.logInfo("Arrive Corridor: true", new Object[0]);
                return LONG_TRUE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DISTANCE"}){

            @Override
            public String getUsage() {
                return "Double $DISTANCE([Double LAT, Double LON])";
            }

            @Override
            public String getDescription() {
                return "The Event distance to the specified point(LAT,LON) in meters";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 2, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 2) {
                    return null;
                }
                if (objectArray.length == 1 && !16.IsStringArg(objectArray[0])) {
                    return null;
                }
                if (objectArray.length == 2 && !16.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                if (objectArray.length == 0) {
                    GeoPoint geoPoint;
                    GeoPoint geoPoint2 = eventFunctionMap.getGeoPoint();
                    if (geoPoint2.isValid() && (geoPoint = eventFunctionMap.getPreviousGeoPoint()) != null && geoPoint.isValid()) {
                        double d = geoPoint.kilometersToPoint(eventFunctionMap.getGeoPoint()) * 1000.0;
                        return new Double(d);
                    }
                    return new Double(2.0015114442035925E7);
                }
                if (objectArray.length == 1) {
                    block12: {
                        String string = (String)objectArray[0];
                        try {
                            GeoPoint geoPoint;
                            Device device = Device.getDevice(eventFunctionMap.getAccount(), string);
                            GeoPoint geoPoint3 = geoPoint = device != null ? device.getLastValidLocation(true) : null;
                            if (device == null) {
                                Print.logWarn("Device not found: " + eventFunctionMap.getAccountID() + "/" + string, new Object[0]);
                                break block12;
                            }
                            if (geoPoint == null) {
                                Print.logWarn("Unknown Device location: " + eventFunctionMap.getAccountID() + "/" + string, new Object[0]);
                                break block12;
                            }
                            GeoPoint geoPoint4 = eventFunctionMap.getGeoPoint();
                            double d = geoPoint.kilometersToPoint(geoPoint4) * 1000.0;
                            return new Double(d);
                        }
                        catch (DBException dBException) {
                            Print.logWarn("Device DBException: " + eventFunctionMap.getAccountID() + "/" + string + " [" + dBException, new Object[0]);
                        }
                    }
                    return new Double(2.0015114442035925E7);
                }
                if (objectArray.length >= 2) {
                    GeoPoint geoPoint;
                    GeoPoint geoPoint5 = eventFunctionMap.getGeoPoint();
                    if (geoPoint5.isValid() && (geoPoint = new GeoPoint(16.DoubleValue(objectArray[0]), 16.DoubleValue(objectArray[1]))).isValid()) {
                        double d = geoPoint.kilometersToPoint(eventFunctionMap.getGeoPoint()) * 1000.0;
                        return new Double(d);
                    }
                    return new Double(2.0015114442035925E7);
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$NEAR"}){

            @Override
            public String getUsage() {
                return "Boolean $NEAR({String ID, Double RAD} | {Double LAT, Double LON, Double RAD})";
            }

            @Override
            public String getDescription() {
                return "True iff Event is near specified device(ID,RAD)/point(LAT,LON,RAD)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, 3, Object.class, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 2 || objectArray.length > 3) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                if (objectArray.length == 2 && 17.IsStringArg(objectArray[0]) && 17.IsNumericArg(objectArray[1])) {
                    block7: {
                        String string = (String)objectArray[0];
                        try {
                            GeoPoint geoPoint;
                            Device device = Device.getDevice(eventFunctionMap.getAccount(), string);
                            GeoPoint geoPoint2 = geoPoint = device != null ? device.getLastValidLocation(true) : null;
                            if (device == null) {
                                Print.logWarn("Device not found: " + eventFunctionMap.getAccountID() + "/" + string, new Object[0]);
                                break block7;
                            }
                            if (geoPoint == null) {
                                Print.logWarn("Unknown Device location: " + eventFunctionMap.getAccountID() + "/" + string, new Object[0]);
                                break block7;
                            }
                            double d = 17.DoubleValue(objectArray[1]);
                            double d2 = geoPoint.kilometersToPoint(eventFunctionMap.getGeoPoint()) * 1000.0;
                            return d2 <= d ? LONG_TRUE : LONG_FALSE;
                        }
                        catch (DBException dBException) {
                            Print.logWarn("Device DBException: " + eventFunctionMap.getAccountID() + "/" + string + " [" + dBException, new Object[0]);
                        }
                    }
                    return LONG_FALSE;
                }
                if (objectArray.length == 3 && 17.HasNumericArgs(objectArray)) {
                    GeoPoint geoPoint = new GeoPoint(17.DoubleValue(objectArray[0]), 17.DoubleValue(objectArray[1]));
                    double d = 17.DoubleValue(objectArray[2]);
                    double d3 = geoPoint.kilometersToPoint(eventFunctionMap.getGeoPoint()) * 1000.0;
                    return d3 <= d ? LONG_TRUE : LONG_FALSE;
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ARRIVEP", "$ARRIVEPURPOSE"}){

            @Override
            public String getUsage() {
                return "Boolean $ARRIVEP(String PURPOSE_ID)";
            }

            @Override
            public String getDescription() {
                return "True iff Event has arrived at zone matching purpose";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !18.IsStringArg(objectArray[0])) {
                    return null;
                }
                String string = (String)objectArray[0];
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string2 = eventFunctionMap.getAccountID();
                String string3 = eventFunctionMap.getDeviceID();
                GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                if (!geoPoint.isValid()) {
                    return LONG_FALSE;
                }
                Geozone geozone = Geozone.getGeozone(string2, null, geoPoint, string, false);
                if (geozone == null) {
                    return LONG_FALSE;
                }
                if (!geozone.isArrivalZone(string3)) {
                    return LONG_FALSE;
                }
                GeoPoint geoPoint2 = eventFunctionMap.getPreviousGeoPoint();
                if (geoPoint2 == null) {
                    return LONG_TRUE;
                }
                return geozone.containsPoint(geoPoint2) ? LONG_FALSE : LONG_TRUE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DEPARTP", "$DEPARTPURPOSE"}){

            @Override
            public String getUsage() {
                return "Boolean $DEPARTP(String PURPOSE_ID)";
            }

            @Override
            public String getDescription() {
                return "True iff Event has departed from zone matching purpose";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !19.IsStringArg(objectArray[0])) {
                    return null;
                }
                String string = (String)objectArray[0];
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string2 = eventFunctionMap.getAccountID();
                String string3 = eventFunctionMap.getDeviceID();
                GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                if (!geoPoint.isValid()) {
                    return LONG_FALSE;
                }
                GeoPoint geoPoint2 = eventFunctionMap.getPreviousGeoPoint();
                if (geoPoint2 == null) {
                    return LONG_TRUE;
                }
                Geozone geozone = Geozone.getGeozone(string2, null, geoPoint, string, false);
                if (geozone == null) {
                    return LONG_FALSE;
                }
                if (!geozone.isDepartureZone(string3)) {
                    return LONG_FALSE;
                }
                return geozone.containsPoint(geoPoint) ? LONG_FALSE : LONG_TRUE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ARRIVE", "$ARR", "$ARRIVED"}){

            @Override
            public String getUsage() {
                return "Boolean $ARRIVE([{String ID}[,{String ID}} | {Double LAT, Double LON, Double RAD}])";
            }

            @Override
            public String getDescription() {
                return "True iff Event has arrived at zone(ID), or point(LAT,LON,RAD)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, 3, Object.class, Object.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 3) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string = eventFunctionMap.getAccountID();
                String string2 = eventFunctionMap.getDeviceID();
                if (objectArray.length == 0) {
                    GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                    if (!geoPoint.isValid()) {
                        return LONG_FALSE;
                    }
                    Geozone geozone = Geozone.getGeozone(string, null, geoPoint, null, false);
                    if (geozone == null) {
                        return LONG_FALSE;
                    }
                    if (!geozone.isArrivalZone(string2)) {
                        return LONG_FALSE;
                    }
                    GeoPoint geoPoint2 = eventFunctionMap.getPreviousGeoPoint();
                    if (geoPoint2 == null) {
                        return LONG_TRUE;
                    }
                    return geozone.containsPoint(geoPoint2) ? LONG_FALSE : LONG_TRUE;
                }
                if (objectArray.length >= 1 && 20.HasStringArgs(objectArray)) {
                    GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                    if (!geoPoint.isValid()) {
                        return LONG_FALSE;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        Geozone geozone;
                        String string3 = (String)objectArray[i];
                        if (StringTools.isBlank(string3) || (geozone = Geozone.getGeozone(string, string3, geoPoint, null, false)) == null || !geozone.getGeozoneID().equalsIgnoreCase(string3)) continue;
                        GeoPoint geoPoint3 = eventFunctionMap.getPreviousGeoPoint();
                        if (geoPoint3 == null) {
                            return LONG_TRUE;
                        }
                        if (geozone.containsPoint(geoPoint3)) continue;
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                if (objectArray.length == 3 && 20.HasNumericArgs(objectArray)) {
                    boolean bl;
                    double d = 20.DoubleValue(objectArray[0]);
                    double d2 = 20.DoubleValue(objectArray[1]);
                    double d3 = 20.DoubleValue(objectArray[2]);
                    GeoPoint geoPoint = new GeoPoint(d, d2);
                    if (!geoPoint.isValid()) {
                        return null;
                    }
                    if (d3 <= 0.0) {
                        return LONG_FALSE;
                    }
                    GeoPoint geoPoint4 = eventFunctionMap.getGeoPoint();
                    if (!geoPoint4.isValid()) {
                        return LONG_FALSE;
                    }
                    double d4 = geoPoint.kilometersToPoint(geoPoint4) * 1000.0;
                    boolean bl2 = bl = d4 <= d3;
                    if (bl) {
                        GeoPoint geoPoint5 = eventFunctionMap.getPreviousGeoPoint();
                        if (geoPoint5 == null) {
                            return LONG_TRUE;
                        }
                        double d5 = geoPoint.kilometersToPoint(geoPoint5) * 1000.0;
                        boolean bl3 = d5 > d3;
                        return bl3 ? LONG_TRUE : LONG_FALSE;
                    }
                    return LONG_FALSE;
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DEPART", "$DEP", "$DEPARTED"}){

            @Override
            public String getUsage() {
                return "Boolean $DEPART([{String ID} | {Double LAT, Double LON, Double RAD}])";
            }

            @Override
            public String getDescription() {
                return "True iff Event has departed zone(ID), or point(LAT,LON,RAD)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, 3, Object.class, Object.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 3) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string = eventFunctionMap.getAccountID();
                String string2 = eventFunctionMap.getDeviceID();
                if (objectArray.length == 0) {
                    GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                    if (!geoPoint.isValid()) {
                        return LONG_FALSE;
                    }
                    GeoPoint geoPoint2 = eventFunctionMap.getPreviousGeoPoint();
                    if (geoPoint2 == null) {
                        return LONG_TRUE;
                    }
                    Geozone geozone = Geozone.getGeozone(string, null, geoPoint2, null, false);
                    if (geozone == null) {
                        return LONG_FALSE;
                    }
                    if (!geozone.isDepartureZone(string2)) {
                        return LONG_FALSE;
                    }
                    return geozone.containsPoint(geoPoint) ? LONG_FALSE : LONG_TRUE;
                }
                if (objectArray.length >= 1 && 21.HasStringArgs(objectArray)) {
                    GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                    if (!geoPoint.isValid()) {
                        return LONG_FALSE;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string3 = (String)objectArray[i];
                        if (StringTools.isBlank(string3)) continue;
                        GeoPoint geoPoint3 = eventFunctionMap.getPreviousGeoPoint();
                        if (geoPoint3 == null) {
                            return LONG_TRUE;
                        }
                        Geozone geozone = Geozone.getGeozone(string, string3, geoPoint3, null, false);
                        if (geozone == null || !geozone.getGeozoneID().equalsIgnoreCase(string3) || geozone.containsPoint(geoPoint)) continue;
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                if (objectArray.length == 3 && 21.HasNumericArgs(objectArray)) {
                    boolean bl;
                    double d = 21.DoubleValue(objectArray[0]);
                    double d2 = 21.DoubleValue(objectArray[1]);
                    double d3 = 21.DoubleValue(objectArray[2]);
                    GeoPoint geoPoint = new GeoPoint(d, d2);
                    if (!geoPoint.isValid()) {
                        return null;
                    }
                    if (d3 <= 0.0) {
                        return LONG_FALSE;
                    }
                    GeoPoint geoPoint4 = eventFunctionMap.getGeoPoint();
                    if (!geoPoint4.isValid()) {
                        return LONG_FALSE;
                    }
                    double d4 = geoPoint.kilometersToPoint(geoPoint4) * 1000.0;
                    boolean bl2 = bl = d4 > d3;
                    if (bl) {
                        GeoPoint geoPoint5 = eventFunctionMap.getPreviousGeoPoint();
                        if (geoPoint5 == null) {
                            return LONG_TRUE;
                        }
                        double d5 = geoPoint.kilometersToPoint(geoPoint5) * 1000.0;
                        boolean bl3 = d5 <= d3;
                        return bl3 ? LONG_TRUE : LONG_FALSE;
                    }
                    return LONG_FALSE;
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ARRDEP", "$XZONE"}){

            @Override
            public String getUsage() {
                return "Boolean $ARRDEP([{String ID} | {Double LAT, Double LON, Double RAD}])";
            }

            @Override
            public String getDescription() {
                return "True iff Event has arrived/departed zone(ID), or point(LAT,LON,RAD)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 3, Object.class, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 3) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string = eventFunctionMap.getAccountID();
                String string2 = eventFunctionMap.getDeviceID();
                if (objectArray.length == 0) {
                    Geozone geozone;
                    GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                    Geozone geozone2 = GeoPoint.isValid(geoPoint) ? Geozone.getGeozone(string, null, geoPoint, null, false) : null;
                    GeoPoint geoPoint2 = eventFunctionMap.getPreviousGeoPoint();
                    Geozone geozone3 = geozone = GeoPoint.isValid(geoPoint2) ? Geozone.getGeozone(string, null, geoPoint2, null, false) : null;
                    if (geozone == null && geozone2 == null) {
                        return LONG_FALSE;
                    }
                    if (geozone != null && geozone2 != null && geozone2.getGeozoneID().equalsIgnoreCase(geozone.getGeozoneID())) {
                        return LONG_FALSE;
                    }
                    if (geozone2 != null && geozone2.isArrivalZone(string2)) {
                        return LONG_TRUE;
                    }
                    if (geozone != null && geozone.isDepartureZone(string2)) {
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                if (objectArray.length == 1 && 22.IsStringArg(objectArray[0])) {
                    Geozone geozone;
                    String string3 = (String)objectArray[0];
                    if (StringTools.isBlank(string3)) {
                        return LONG_FALSE;
                    }
                    GeoPoint geoPoint = eventFunctionMap.getGeoPoint();
                    Geozone geozone4 = GeoPoint.isValid(geoPoint) ? Geozone.getGeozone(string, string3, geoPoint, null, false) : null;
                    GeoPoint geoPoint3 = eventFunctionMap.getPreviousGeoPoint();
                    Geozone geozone5 = geozone = GeoPoint.isValid(geoPoint3) ? Geozone.getGeozone(string, string3, geoPoint3, null, false) : null;
                    if (geozone == null && geozone4 == null) {
                        return LONG_FALSE;
                    }
                    if (geozone != null && geozone4 != null) {
                        return LONG_FALSE;
                    }
                    if (geozone4 != null) {
                        return LONG_TRUE;
                    }
                    if (geozone != null) {
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                if (objectArray.length == 3 && 22.HasNumericArgs(objectArray)) {
                    boolean bl;
                    double d = 22.DoubleValue(objectArray[0]);
                    double d2 = 22.DoubleValue(objectArray[1]);
                    double d3 = 22.DoubleValue(objectArray[2]);
                    GeoPoint geoPoint = new GeoPoint(d, d2);
                    if (!geoPoint.isValid()) {
                        return null;
                    }
                    if (d3 <= 0.0) {
                        return LONG_FALSE;
                    }
                    GeoPoint geoPoint4 = eventFunctionMap.getGeoPoint();
                    if (!GeoPoint.isValid(geoPoint4)) {
                        return LONG_FALSE;
                    }
                    double d4 = geoPoint.kilometersToPoint(geoPoint4) * 1000.0;
                    boolean bl2 = d4 <= d3;
                    GeoPoint geoPoint5 = eventFunctionMap.getPreviousGeoPoint();
                    double d5 = GeoPoint.isValid(geoPoint5) ? geoPoint.kilometersToPoint(geoPoint5) * 1000.0 : -1.0;
                    boolean bl3 = bl = d5 >= 0.0 && d5 <= d3;
                    if (bl2 && bl) {
                        return LONG_FALSE;
                    }
                    if (!bl2 && !bl) {
                        return LONG_FALSE;
                    }
                    if (bl2) {
                        return LONG_TRUE;
                    }
                    if (bl) {
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ISPARKED", "$PARKED"}){

            @Override
            public String getUsage() {
                return "Boolean $ISPARKED()";
            }

            @Override
            public String getDescription() {
                return "True iff Device is parked";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 0) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Device device = eventFunctionMap.getDevice();
                return device != null && device.isParked() ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$PARKVIO", "$PDEPART", "$PARKEDVIO"}){

            @Override
            public String getUsage() {
                return "Boolean $PARKVIO()";
            }

            @Override
            public String getDescription() {
                return "True iff Device is parked and is outside parked radius";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 0) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Device device = eventFunctionMap.getDevice();
                return device != null && device.isParkedViolation(eventFunctionMap.getGeoPoint()) ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$STOPSEC"}){

            @Override
            public String getUsage() {
                return "Boolean $STOPSEC()";
            }

            @Override
            public String getDescription() {
                return "Number of seconds stopped (0 if not stopped)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                Device device;
                if (objectArray.length > 0) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                Device device2 = device = eventData != null ? eventData.getDevice() : null;
                if (device == null) {
                    return LONG_ZERO;
                }
                if (eventData.getSpeedKPH() > 0.0) {
                    return LONG_ZERO;
                }
                long l = eventData.getTimestamp();
                long l2 = device.getLastStartTime();
                long l3 = device.getLastStopTime();
                boolean bl = l3 > 0L && l3 > l2;
                long l4 = bl ? l - l3 : 0L;
                return new Long(l4);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$STOPPED", "$ISSTOPPED"}){

            @Override
            public String getUsage() {
                return "Boolean $STOPPED([Long SEC])";
            }

            @Override
            public String getDescription() {
                return "True is stopped for specified seconds";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                long l;
                Device device;
                if (objectArray.length > 1 || !26.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                Device device2 = device = eventData != null ? eventData.getDevice() : null;
                if (device == null) {
                    return LONG_FALSE;
                }
                if (eventData.getSpeedKPH() > 0.0) {
                    return LONG_FALSE;
                }
                long l2 = device.getLastStartTime();
                long l3 = device.getLastStopTime();
                boolean bl = l3 > 0L && l3 > l2;
                long l4 = l = bl ? DateTime.getCurrentTimeSec() - l3 : 0L;
                if (objectArray.length >= 1) {
                    long l5 = 26.LongValue(objectArray[0]);
                    return l >= l5 ? LONG_TRUE : LONG_FALSE;
                }
                return l > 0L ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DORMANT"}){

            @Override
            public String getUsage() {
                return "Seconds $DORMANT([Long E])";
            }

            @Override
            public String getDescription() {
                return "Number of seconds since stop/inMotion (or True if > E)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !27.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_ZERO;
                }
                boolean bl = objectArray.length >= 1;
                long l = objectArray.length >= 1 ? 27.LongValue(objectArray[0]) : -1L;
                int[] nArray = new int[]{61713, 61715, 61714};
                int n = eventData.getStatusCode();
                for (int i = 0; i < nArray.length; ++i) {
                    if (n != nArray[i]) continue;
                    long l2 = DateTime.getCurrentTimeSec() - eventData.getTimestamp();
                    if (bl) {
                        return l2 >= l ? LONG_TRUE : LONG_FALSE;
                    }
                    return new Long(l2 >= 0L ? l2 : 0L);
                }
                try {
                    EventData eventData2 = eventData.getPreviousEventData(nArray, false);
                    if (eventData2 == null) {
                        return bl ? LONG_TRUE : new Long(DateTime.getCurrentTimeSec());
                    }
                    long l3 = DateTime.getCurrentTimeSec() - eventData2.getTimestamp();
                    if (bl) {
                        return l3 >= l ? LONG_TRUE : LONG_FALSE;
                    }
                    return new Long(l3 >= 0L ? l3 : 0L);
                }
                catch (DBException dBException) {
                    Print.logWarn("Dormant DBException: " + eventFunctionMap.getAccountID() + " [" + dBException, new Object[0]);
                    return null;
                }
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ELAPSED", "$ELAP"}){

            @Override
            public String getUsage() {
                return "Seconds $ELAPSED([Long CODE [, Long CODE [, Long CODE]]])";
            }

            @Override
            public String getDescription() {
                return "Seconds since last specified status code event";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, 3, Long.class, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 2 || !28.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_ZERO;
                }
                if (objectArray.length == 0) {
                    return new Long(DateTime.getCurrentTimeSec() - eventData.getTimestamp());
                }
                int n = eventData.getStatusCode();
                int[] nArray = new int[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = 28.IntValue(objectArray[i]);
                    if (n != nArray[i]) continue;
                    return new Long(DateTime.getCurrentTimeSec() - eventData.getTimestamp());
                }
                try {
                    EventData eventData2 = eventData.getPreviousEventData(nArray, false);
                    if (eventData2 == null) {
                        return new Long(eventData.getTimestamp());
                    }
                    long l = DateTime.getCurrentTimeSec() - eventData2.getTimestamp();
                    return new Long(l >= 0L ? l : 0L);
                }
                catch (DBException dBException) {
                    Print.logWarn("Elapsed DBException: " + eventFunctionMap.getAccountID() + " [" + dBException, new Object[0]);
                    return null;
                }
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$JOBNUMBER"}){

            @Override
            public String getUsage() {
                return "String $JOBNUMBER([Boolean EVENT_JOB])";
            }

            @Override
            public String getDescription() {
                return "Returns the Job-Number";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return "";
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Boolean.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !29.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                Device device = eventFunctionMap.getDevice();
                if (objectArray.length == 0) {
                    if (eventData != null && eventData.hasJobNumber()) {
                        return eventData.getJobNumber();
                    }
                    if (device != null && device.hasJobNumber()) {
                        return device.getJobNumber();
                    }
                    return "";
                }
                if (29.BooleanValue(objectArray[0])) {
                    return eventData != null ? eventData.getJobNumber() : "";
                }
                return device != null ? device.getJobNumber() : "";
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$HASJOB", "$HASJOBNUMBER"}){

            @Override
            public String getUsage() {
                return "String $HASJOB([Boolean EVENT_JOB])";
            }

            @Override
            public String getDescription() {
                return "Returns true is a Job-Number is defined";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Boolean.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !30.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                Device device = eventFunctionMap.getDevice();
                if (objectArray.length == 0) {
                    if (eventData != null && eventData.hasJobNumber()) {
                        return LONG_TRUE;
                    }
                    if (device != null && device.hasJobNumber()) {
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                if (30.BooleanValue(objectArray[0])) {
                    return eventData != null && eventData.hasJobNumber() ? LONG_TRUE : LONG_FALSE;
                }
                return device != null && device.hasJobNumber() ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$EVENTCOUNT", "$EC"}){

            @Override
            public String getUsage() {
                return "Count $EVENTCOUNT(Long SEC)";
            }

            @Override
            public String getDescription() {
                return "Records count received in last SEC seconds";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !31.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Device device = eventFunctionMap.getDevice();
                if (device != null) {
                    try {
                        long l = objectArray.length >= 1 ? 31.LongValue(objectArray[0]) : -1L;
                        long l2 = l >= 0L ? DateTime.getCurrentTimeSec() - l : -1L;
                        long l3 = -1L;
                        long l4 = EventData.countRangeEvents(device.getAccountID(), device.getDeviceID(), l2, l3, null, false, EventData.LimitType.LAST, -1L, null);
                        return new Long(l4);
                    }
                    catch (DBException dBException) {
                        Print.logError("Unable to obtain EventData record count [" + dBException, new Object[0]);
                    }
                }
                return new Long(-1L);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$INGROUP"}){

            @Override
            public String getUsage() {
                return "Boolean $INGROUP(String G)";
            }

            @Override
            public String getDescription() {
                return "True if Device is a member of group G";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                String string;
                String string2;
                if (objectArray.length != 1 || !32.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string3 = eventFunctionMap.getAccountID();
                return DeviceGroup.isDeviceInDeviceGroup(string3, string2 = (String)objectArray[0], string = eventFunctionMap.getDeviceID()) ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DEVNOTIFY"}){

            @Override
            public String getUsage() {
                return "Boolean $DEVNOTIFY([Long ageSec])";
            }

            @Override
            public String getDescription() {
                return "True if any Device (for Account) has a lastNotifyTime since age seconds";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public boolean isCronOnly() {
                return false;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !33.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Account account = eventFunctionMap.getAccount();
                if (account == null) {
                    return LONG_FALSE;
                }
                User user = eventFunctionMap.getUser();
                try {
                    long l = objectArray.length >= 1 ? 33.LongValue(objectArray[0]) : -1L;
                    long l2 = l >= 0L ? DateTime.getCurrentTimeSec() - l : 1L;
                    return account.hasDeviceLastNotifySince(l2, user) ? LONG_TRUE : LONG_FALSE;
                }
                catch (DBException dBException) {
                    Print.logError("Account/Device DBException: " + eventFunctionMap.getAccountID() + " [" + dBException, new Object[0]);
                    return LONG_FALSE;
                }
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_DEVNOTIFY"}){

            @Override
            public String getUsage() {
                return "Boolean $G_DEVNOTIFY([Long ageSec])";
            }

            @Override
            public String getDescription() {
                return "True if any Device (any Account) has a lastNotifyTime since age seconds";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public boolean isCronOnly() {
                return false;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !34.HasNumericArgs(objectArray)) {
                    return null;
                }
                try {
                    long l = objectArray.length >= 1 ? 34.LongValue(objectArray[0]) : -1L;
                    long l2 = l >= 0L ? DateTime.getCurrentTimeSec() - l : 1L;
                    return Account.hasAnyDeviceLastNotifySince(l2) ? LONG_TRUE : LONG_FALSE;
                }
                catch (DBException dBException) {
                    Print.logError("Account/Device DBException [" + dBException, new Object[0]);
                    return LONG_FALSE;
                }
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$IGNITION", "$IGN"}){

            @Override
            public String getUsage() {
                return "Long $IGNITION([Boolean LAST])";
            }

            @Override
            public String getDescription() {
                return "Ignition State (-1=Unknown, 0=Off, 1=On)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return new Long(-1L);
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !35.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                Device device = eventFunctionMap.getDevice();
                if (device == null) {
                    return new Long(-1L);
                }
                int n = objectArray.length <= 0 || 35.BooleanValue(objectArray[0]) ? device.getCurrentIgnitionState() : device.getIgnitionStateAsOfEvent(eventData);
                switch (n) {
                    case 0: {
                        return new Long(0L);
                    }
                    case 1: {
                        return new Long(1L);
                    }
                }
                return new Long(-1L);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$IGNITIONON", "$IGNON"}){

            @Override
            public String getUsage() {
                return "Boolean $IGNITIONON([Long SECONDS])";
            }

            @Override
            public String getDescription() {
                return "True if Ignition 'On' at least SECONDS";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !36.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                Device device = eventFunctionMap.getDevice();
                if (device == null) {
                    return LONG_FALSE;
                }
                long l = objectArray.length > 0 ? 36.LongValue(objectArray[0]) : 0L;
                long l2 = DateTime.getCurrentTimeSec();
                long l3 = device.getLastIgnitionOnTime();
                long l4 = device.getLastIgnitionOffTime();
                if (l3 <= 0L || l3 < l4) {
                    return LONG_FALSE;
                }
                if (l <= 0L) {
                    return LONG_TRUE;
                }
                if (l2 - l3 >= l) {
                    return LONG_TRUE;
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$IGNITIONOFF", "$IGNOFF"}){

            @Override
            public String getUsage() {
                return "Boolean $IGNITION_OFF([Long SECONDS])";
            }

            @Override
            public String getDescription() {
                return "True if Ignition 'Off' at least SECONDS";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !37.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                Device device = eventFunctionMap.getDevice();
                if (device == null) {
                    return LONG_FALSE;
                }
                long l = objectArray.length > 0 ? 37.LongValue(objectArray[0]) : 0L;
                long l2 = DateTime.getCurrentTimeSec();
                long l3 = device.getLastIgnitionOnTime();
                long l4 = device.getLastIgnitionOffTime();
                if (l4 <= 0L || l4 < l3) {
                    return LONG_FALSE;
                }
                if (l <= 0L) {
                    return LONG_TRUE;
                }
                if (l2 - l4 >= l) {
                    return LONG_TRUE;
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$LASTCONNECT"}){

            @Override
            public String getUsage() {
                return "Seconds|Boolean $LASTCONNECT([Long E])";
            }

            @Override
            public String getDescription() {
                return "Seconds since last device connect (or true if <= E)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return new Long(DateTime.getCurrentTimeSec());
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                EventData eventData;
                if (objectArray.length > 1 || !38.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                long l = DateTime.getCurrentTimeSec();
                Device device = eventFunctionMap.getDevice();
                if (device == null) {
                    return objectArray.length >= 1 ? LONG_FALSE : new Long(l);
                }
                long l2 = device.getLastTotalConnectTime();
                if (l2 > 0L || (eventData = eventFunctionMap.getEventData()) != null) {
                    // empty if block
                }
                long l3 = l - l2;
                if (objectArray.length == 0) {
                    return new Long(l3);
                }
                long l4 = 38.LongValue(objectArray[0]);
                return l3 <= l4 ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$WORKHOURS", "$WKHRS"}){

            @Override
            public String getUsage() {
                return "Boolean $WORKHOURS([Long FROMTOD, Long TOTOD])";
            }

            @Override
            public String getDescription() {
                return "True if Event occurred during working hours";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 2, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                long l;
                long l2;
                if (!(objectArray.length == 0 || objectArray.length == 1 && 39.HasNumericArgs(objectArray) && 39.LongValue(objectArray[0]) > 1440L || objectArray.length == 2 && 39.HasNumericArgs(objectArray))) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                TimeZone timeZone = eventFunctionMap.getTimeZone();
                DateTime dateTime = new DateTime(eventFunctionMap.getTimestamp(), timeZone);
                if (objectArray.length == 0) {
                    Device device = eventFunctionMap.getDevice();
                    if (device != null && device.hasHoursOfOperation()) {
                        return device.isHoursOfOperation(dateTime, timeZone) ? LONG_TRUE : LONG_FALSE;
                    }
                    return Device.DefaultWorkHours.isMatch(dateTime, timeZone) ? LONG_TRUE : LONG_FALSE;
                }
                if (objectArray.length == 1) {
                    Device device = eventFunctionMap.getDevice();
                    long l3 = 39.LongValue(objectArray[0]);
                    DateTime dateTime2 = new DateTime(l3, timeZone);
                    if (device != null && device.hasHoursOfOperation()) {
                        return device.isHoursOfOperation(dateTime2, timeZone) ? LONG_TRUE : LONG_FALSE;
                    }
                    return Device.DefaultWorkHours.isMatch(dateTime2, timeZone) ? LONG_TRUE : LONG_FALSE;
                }
                int n = dateTime.getDayOfWeek();
                if (n == 0 || n == 6) {
                    return LONG_FALSE;
                }
                long l4 = (long)dateTime.getHour24() * 60L + (long)dateTime.getMinute();
                long l5 = 39.LongValue(objectArray[0]);
                long l6 = l5 / 100L % 24L * 60L + l5 % 100L % 60L;
                if (l6 <= (l2 = (l = 39.LongValue(objectArray[1])) / 100L % 24L * 60L + l % 100L % 60L)) {
                    if (l4 < l6) {
                        return LONG_FALSE;
                    }
                    if (l4 > l2) {
                        return LONG_FALSE;
                    }
                    return LONG_TRUE;
                }
                if (l4 >= l6) {
                    return LONG_TRUE;
                }
                if (l4 <= l2) {
                    return LONG_TRUE;
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$TRIPODOM"}){

            @Override
            public String getUsage() {
                return "Double $TRIPODOM(Integer X)";
            }

            @Override
            public String getDescription() {
                return "Number of kilometers traveled in last X seconds";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return new Double(0.0);
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1) {
                    return null;
                }
                long l = 40.LongValue(objectArray[0]);
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return new Double(0.0);
                }
                Print.logInfo("Current OdomKM: " + eventData.getOdometerKM() + " - " + new DateTime(eventData.getTimestamp()), new Object[0]);
                EventData eventData2 = null;
                long l2 = eventData.getTimestamp() - l;
                Print.logInfo("Previous Time : " + new DateTime(l2), new Object[0]);
                try {
                    String string = eventFunctionMap.getAccountID();
                    String string2 = eventFunctionMap.getDeviceID();
                    eventData2 = EventData.getNextEventData(string, string2, l2 - 1L, null, true);
                    if (eventData2 == null) {
                        return new Double(0.0);
                    }
                }
                catch (DBException dBException) {
                    return new Double(0.0);
                }
                Print.logInfo("Prior   OdomKM: " + eventData2.getOdometerKM() + " - " + new DateTime(eventData2.getTimestamp()), new Object[0]);
                Print.logInfo("Previous Time : " + new DateTime(l2) + "[delta " + (eventData2.getTimestamp() - l2) + "]", new Object[0]);
                double d = eventData.getOdometerKM() - eventData2.getOdometerKM();
                return d >= 0.0 ? new Double(d) : new Double(0.0);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$MAINTKM"}){

            @Override
            public String getUsage() {
                return "Boolean $MAINTKM([Integer X [, Double KM]])";
            }

            @Override
            public String getDescription() {
                return "True if maintenance odometer interval X has elapsed";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, Long.class, Double.class);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                int n;
                if (objectArray.length > 2 || !41.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_FALSE;
                }
                Device device = eventData.getDevice();
                if (device == null) {
                    return LONG_FALSE;
                }
                double d = device.getLastOdometerKM();
                Print.logDebug("$MAINTKM: [" + device.getDeviceID() + "] Odometer - " + d, new Object[0]);
                if (d <= 0.0) {
                    return LONG_FALSE;
                }
                Print.logDebug("$MAINTKM: [" + device.getDeviceID() + "] Offset   - " + device.getOdometerOffsetKM(), new Object[0]);
                int n2 = n = objectArray.length >= 1 ? 41.IntValue(objectArray[0]) : -1;
                if (n >= 0) {
                    double d2 = objectArray.length >= 2 ? 41.DoubleValue(objectArray[1]) : device.getMaintIntervalKM(n);
                    Print.logDebug("$MAINTKM #" + n + ": [" + device.getDeviceID() + "] Interval - " + d2, new Object[0]);
                    if (d2 > 0.0) {
                        double d3 = device.getMaintOdometerKM(n);
                        Print.logDebug("$MAINTKM #" + n + ": [" + device.getDeviceID() + "] Maint Odom - " + d3, new Object[0]);
                        if (d >= d3 + d2) {
                            device.setMaintTriggeredKM(n);
                            return LONG_TRUE;
                        }
                    }
                } else {
                    for (int i = 0; i < device.getPeriodicMaintOdometerCount(); ++i) {
                        double d4 = objectArray.length >= 2 ? 41.DoubleValue(objectArray[1]) : device.getMaintIntervalKM(i);
                        Print.logDebug("$MAINTKM #" + i + ": [" + device.getDeviceID() + "] Interval - " + d4, new Object[0]);
                        if (!(d4 > 0.0)) continue;
                        double d5 = device.getMaintOdometerKM(i);
                        Print.logDebug("$MAINTKM #" + i + ": [" + device.getDeviceID() + "] Maint Odom - " + d5, new Object[0]);
                        if (!(d >= d5 + d4)) continue;
                        device.setMaintTriggeredKM(i);
                        return LONG_TRUE;
                    }
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$MAINTHR"}){

            @Override
            public String getUsage() {
                return "Boolean $MAINTHR([Integer X [, Double HR]])";
            }

            @Override
            public String getDescription() {
                return "True if maintenance engine hours interval X has elapsed";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, Long.class, Double.class);
            }

            @Override
            public boolean isCronOnly() {
                return false;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                int n;
                if (objectArray.length > 2 || !42.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_FALSE;
                }
                Device device = eventData.getDevice();
                if (device == null) {
                    return LONG_FALSE;
                }
                double d = device.getLastEngineHours();
                Print.logInfo("$MAINTHR: [" + device.getDeviceID() + "] EngineHours - " + d, new Object[0]);
                if (d <= 0.0) {
                    return LONG_FALSE;
                }
                Print.logInfo("$MAINTHR: [" + device.getDeviceID() + "] Offset   - " + device.getEngineHoursOffset(), new Object[0]);
                int n2 = n = objectArray.length >= 1 ? 42.IntValue(objectArray[0]) : -1;
                if (n >= 0) {
                    double d2 = objectArray.length >= 2 ? 42.DoubleValue(objectArray[1]) : device.getMaintIntervalHR(n);
                    Print.logInfo("$MAINTHR: [" + device.getDeviceID() + "] Interval - " + d2, new Object[0]);
                    if (d2 > 0.0) {
                        double d3 = device.getMaintEngHoursHR0();
                        Print.logInfo("$MAINTHR: [" + device.getDeviceID() + "] Maint Hours - " + d3, new Object[0]);
                        if (d >= d3 + d2) {
                            return LONG_TRUE;
                        }
                    }
                } else {
                    for (int i = 0; i < device.getPeriodicMaintEngHoursCount(); ++i) {
                        double d4 = objectArray.length >= 2 ? 42.DoubleValue(objectArray[1]) : device.getMaintIntervalHR(i);
                        Print.logInfo("$MAINTHR: [" + device.getDeviceID() + "] Interval - " + d4, new Object[0]);
                        if (!(d4 > 0.0)) continue;
                        double d5 = device.getMaintEngHoursHR(i);
                        Print.logInfo("$MAINTHR: [" + device.getDeviceID() + "] Maint Hours - " + d5, new Object[0]);
                        if (!(d >= d5 + d4)) continue;
                        return LONG_TRUE;
                    }
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$REMINDER", "$DEVREMIND"}){

            @Override
            public String getUsage() {
                return "Boolean $REMINDER()";
            }

            @Override
            public String getDescription() {
                return "True if the Device reminder time has expired";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 0) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Device device = eventFunctionMap.getDevice();
                if (device == null) {
                    return LONG_FALSE;
                }
                TimeZone timeZone = eventFunctionMap.getTimeZone();
                return device.isReminderExpired(timeZone) ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$J1708PID", "$JPID"}){

            @Override
            public String getUsage() {
                return "Boolean $J1708PID(Long MID, Long PID [, Long FMI])";
            }

            @Override
            public String getDescription() {
                return "J1708 PID fault code";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, 3, Long.class, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 2 || objectArray.length > 3 || !44.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_FALSE;
                }
                long l = eventData.getOBDFault();
                if (DTOBDFault.IsJ1708_PID(l)) {
                    int n = DTOBDFault.DecodeSystem(l);
                    int n2 = DTOBDFault.DecodePidSid(l);
                    if (n != 44.IntValue(objectArray[0]) || n2 != 44.IntValue(objectArray[1])) {
                        return LONG_FALSE;
                    }
                    if (objectArray.length == 2) {
                        return LONG_TRUE;
                    }
                    int n3 = DTOBDFault.DecodeFMI(l);
                    if (n3 == 44.IntValue(objectArray[2])) {
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$J1708SID", "$JSID"}){

            @Override
            public String getUsage() {
                return "Boolean $J1708SID(Long MID, Long SID [, Long FMI])";
            }

            @Override
            public String getDescription() {
                return "J1708 SID fault code";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, 3, Long.class, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 2 || objectArray.length > 3 || !45.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_FALSE;
                }
                long l = eventData.getOBDFault();
                if (DTOBDFault.IsJ1708_SID(l)) {
                    int n = DTOBDFault.DecodeSystem(l);
                    int n2 = DTOBDFault.DecodePidSid(l);
                    if (n != 45.IntValue(objectArray[0]) || n2 != 45.IntValue(objectArray[1])) {
                        return LONG_FALSE;
                    }
                    if (objectArray.length == 2) {
                        return LONG_TRUE;
                    }
                    int n3 = DTOBDFault.DecodeFMI(l);
                    if (n3 == 45.IntValue(objectArray[2])) {
                        return LONG_TRUE;
                    }
                    return LONG_FALSE;
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$SPEEDING"}){

            @Override
            public String getUsage() {
                return "Boolean $SPEEDING([Double dftKPH, [Double ofsKPH, [Boolean checkZones]]])";
            }

            @Override
            public String getDescription() {
                return "True if exceeding the posted/specified speed limit";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, 3, Double.class, Double.class, Boolean.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                double d;
                double d2;
                if (objectArray.length > 3) {
                    return null;
                }
                if (objectArray.length >= 1 && !46.IsNumericArg(objectArray[0])) {
                    return null;
                }
                if (objectArray.length >= 2 && !46.IsNumericArg(objectArray[1])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_FALSE;
                }
                double d3 = eventData.getSpeedKPH();
                Device device = eventFunctionMap.getDevice();
                String string = eventFunctionMap.getDeviceID();
                if (device != null && (d2 = device.getSpeedLimitKPH()) > 0.0 && d3 > d2) {
                    return LONG_TRUE;
                }
                d2 = eventData.getSpeedLimitKPH();
                if (d2 <= 0.0 && objectArray.length >= 1) {
                    d2 = 46.DoubleValue(objectArray[0]);
                }
                double d4 = d = objectArray.length >= 2 ? 46.DoubleValue(objectArray[1]) : 0.0;
                if (d2 > 0.0 && d3 > d2 + d) {
                    return LONG_TRUE;
                }
                if (objectArray.length >= 3 && 46.BooleanValue(objectArray[2])) {
                    double d5;
                    Geozone geozone = Geozone.getGeozone(eventFunctionMap.getAccountID(), null, eventFunctionMap.getGeoPoint(), null, false);
                    if (geozone != null && !geozone.isDeviceInGroup(string)) {
                        geozone = null;
                    }
                    double d6 = d5 = geozone != null ? geozone.getSpeedLimitKPH() : 0.0;
                    if (d5 > 0.0 && d3 > d5 + d) {
                        return LONG_TRUE;
                    }
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$FUELDELTA"}){

            @Override
            public String getUsage() {
                return "Double $FUELDELTA()";
            }

            @Override
            public String getDescription() {
                return "Returns the percent change (-1.00 to 1.00) in fuel level";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return new Double(0.0);
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 0) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return DOUBLE_ZERO;
                }
                if (eventData.getFuelLevel(true) < 0.0) {
                    return DOUBLE_ZERO;
                }
                Device device = eventData.getDevice();
                if (device == null) {
                    return DOUBLE_ZERO;
                }
                if (device.getLastFuelLevel() < 0.0) {
                    return DOUBLE_ZERO;
                }
                double d = eventData.getFuelLevel(true) - device.getLastFuelLevel();
                if (d < -1.0) {
                    return new Double(-1.0);
                }
                if (d > 1.0) {
                    return new Double(1.0);
                }
                return new Double(d);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$FUELDROP"}){

            @Override
            public String getUsage() {
                return "Boolean $FUELDROP([Double S [,Double M]])";
            }

            @Override
            public String getDescription() {
                return "True if fuel level drops more than S % while stopped, M % while moving";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                EventFunctionMap eventFunctionMap;
                EventData eventData;
                double d;
                if (objectArray.length > 2 || !48.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d2 = objectArray.length > 0 ? 48.DoubleValue(objectArray[0]) : 0.02;
                double d3 = d = objectArray.length > 1 ? 48.DoubleValue(objectArray[1]) : 0.5;
                if (d2 > 1.0) {
                    d2 /= 100.0;
                }
                if (d > 1.0) {
                    d /= 100.0;
                }
                if ((eventData = (eventFunctionMap = (EventFunctionMap)functionMap).getEventData()) == null) {
                    return LONG_FALSE;
                }
                if (eventData.getFuelLevel(true) < 0.0) {
                    return LONG_FALSE;
                }
                Device device = eventData.getDevice();
                if (device == null) {
                    return LONG_FALSE;
                }
                if (device.getLastFuelLevel() < 0.0) {
                    return LONG_FALSE;
                }
                double d4 = eventData.getFuelLevel(true) - device.getLastFuelLevel();
                if (d4 > 0.0) {
                    return LONG_FALSE;
                }
                if (d4 == 0.0) {
                    return LONG_FALSE;
                }
                double d5 = eventData.getOdometerKM() - device.getLastOdometerKM();
                if (d5 <= 0.2) {
                    return Math.abs(d4) > d2 ? LONG_TRUE : LONG_FALSE;
                }
                return Math.abs(d4) > d ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$OILDROP"}){

            @Override
            public String getUsage() {
                return "Boolean $OILDROP([Double S [,Double M]])";
            }

            @Override
            public String getDescription() {
                return "True if oil level drops more than S % while stopped, M % while moving";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, 2, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                EventFunctionMap eventFunctionMap;
                EventData eventData;
                double d;
                if (objectArray.length > 2 || !49.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d2 = objectArray.length > 0 ? 49.DoubleValue(objectArray[0]) : 0.02;
                double d3 = d = objectArray.length > 1 ? 49.DoubleValue(objectArray[1]) : 0.5;
                if (d2 > 1.0) {
                    d2 /= 100.0;
                }
                if (d > 1.0) {
                    d /= 100.0;
                }
                if ((eventData = (eventFunctionMap = (EventFunctionMap)functionMap).getEventData()) == null) {
                    return LONG_FALSE;
                }
                if (eventData.getOilLevel() < 0.0) {
                    return LONG_FALSE;
                }
                Device device = eventData.getDevice();
                if (device == null) {
                    return LONG_FALSE;
                }
                if (device.getLastOilLevel() < 0.0) {
                    return LONG_FALSE;
                }
                double d4 = eventData.getOilLevel() - device.getLastOilLevel();
                if (d4 > 0.0) {
                    return LONG_FALSE;
                }
                if (d4 == 0.0) {
                    return LONG_FALSE;
                }
                double d5 = eventData.getOdometerKM() - device.getLastOdometerKM();
                if (d5 <= 0.2) {
                    return Math.abs(d4) > d2 ? LONG_TRUE : LONG_FALSE;
                }
                return Math.abs(d4) > d ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$THERMO", "$TEMPRANGE"}){

            @Override
            public String getUsage() {
                return "Boolean $THERMO(Long INDEX [, Double LOW_C [, Double HIGH_C]])";
            }

            @Override
            public String getDescription() {
                return "Temperature within range";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 3, Long.class, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 3 || !50.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return LONG_FALSE;
                }
                double d = eventData.getThermoAverage(50.IntValue(objectArray[0]));
                if (!EventData.isValidTemperature(d)) {
                    return LONG_FALSE;
                }
                if (objectArray.length >= 2 && d < 50.DoubleValue(objectArray[1])) {
                    return LONG_FALSE;
                }
                if (objectArray.length >= 3 && d > 50.DoubleValue(objectArray[2])) {
                    return LONG_FALSE;
                }
                return LONG_TRUE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$THERMALPROFILE", "$TEMPPROFILE", "$TPROFILE"}){

            @Override
            public String getUsage() {
                return "Boolean $THERMOPROFILE([Boolean DEFAULT])";
            }

            @Override
            public String getDescription() {
                return "Device Temperature profile within range";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Boolean.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1) {
                    return null;
                }
                Long l = objectArray.length > 0 ? (Comparable<Boolean>)Boolean.valueOf(51.BooleanValue(objectArray[0])) : (Comparable<Boolean>)LONG_TRUE;
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return l;
                }
                Device device = eventData.getDevice();
                if (device == null) {
                    return l;
                }
                String string = device.getThermalProfile();
                if (StringTools.isBlank(string)) {
                    return l;
                }
                RTProperties rTProperties = new RTProperties(string);
                int n = EventData.getThermoCount();
                for (int i = 0; i < n; ++i) {
                    String[] stringArray;
                    String string2;
                    double d = eventData.getThermoAverage(i);
                    if (!EventData.isValidTemperature(d) || StringTools.isBlank(string2 = rTProperties.getString(stringArray = new String[]{"T" + i, "temp" + i}, null))) continue;
                    int n2 = string2.indexOf(",");
                    if (n2 < 0) {
                        n2 = string2.indexOf("/");
                    }
                    String string3 = n2 >= 0 ? string2.substring(0, n2) : string2;
                    String string4 = n2 >= 0 ? string2.substring(n2 + 1) : null;
                    double d2 = StringTools.parseDouble(string3, -9999.9);
                    double d3 = StringTools.parseDouble(string4, 9999.9);
                    if (!(d < d2) && !(d > d3)) continue;
                    String string5 = device.getAccountID() + "/" + device.getDeviceID();
                    Print.logWarn(string5 + "] Thermal Profile #" + i + " out of range", new Object[0]);
                    return LONG_FALSE;
                }
                return LONG_TRUE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DRIVEREXPIRED", "$LICENSEEXPIRED"}){

            @Override
            public String getUsage() {
                return "Boolean $DRIVEREXPIRED([String driverID])";
            }

            @Override
            public String getDescription() {
                return "Driver's License expired";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                String string;
                if (objectArray.length > 1) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string2 = string = objectArray.length >= 1 ? 52.StringValue(objectArray[0]) : eventFunctionMap.getDriverID();
                if (StringTools.isBlank(string)) {
                    return LONG_FALSE;
                }
                Driver driver = eventFunctionMap.getDriver(string);
                if (driver == null) {
                    Print.logWarn("Driver does not exist: " + string, new Object[0]);
                    return LONG_FALSE;
                }
                DateTime dateTime = new DateTime(eventFunctionMap.getTimeZone());
                return driver.isLicenseExpired(dateTime.getDayNumber());
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DEVICON", "$DEVPIN"}){

            @Override
            public String getUsage() {
                return "String $DEVICON([String dftIconID])";
            }

            @Override
            public String getDescription() {
                return "Return the device pushpin icon id";
            }

            @Override
            public Class getReturnType() {
                return String.class;
            }

            @Override
            public Object getDefaultValue() {
                return "";
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !53.HasStringArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return objectArray.length >= 1 ? 53.StringValue(objectArray[0]) : "";
                }
                Device device = eventData.getDevice();
                if (device == null) {
                    return objectArray.length >= 1 ? 53.StringValue(objectArray[0]) : "";
                }
                if (!device.hasPushpinID()) {
                    return objectArray.length >= 1 ? 53.StringValue(objectArray[0]) : "";
                }
                return device.getPushpinID();
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$CODEICON", "$CODEPIN"}){

            @Override
            public String getUsage() {
                return "String $CODEICON([String dftIconID])";
            }

            @Override
            public String getDescription() {
                return "Return the StatusCode pushpin id";
            }

            @Override
            public Class getReturnType() {
                return String.class;
            }

            @Override
            public Object getDefaultValue() {
                return "";
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !54.HasStringArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return objectArray.length >= 1 ? 54.StringValue(objectArray[0]) : "";
                }
                int n = eventFunctionMap.getRecursionLevel();
                if (n >= 0) {
                    try {
                        BasicPrivateLabel basicPrivateLabel = eventFunctionMap.getPrivateLabel();
                        String string = eventData.getStatusCodeIconSelector(basicPrivateLabel);
                        if (!StringTools.isBlank(string)) {
                            Selector.Result result = EventSelector.getInstance().getResult(n + 1, string, eventData);
                            return result.getValue();
                        }
                        String string2 = eventData.getStatusCodeIconName(basicPrivateLabel);
                        if (!StringTools.isBlank(string2)) {
                            return string2;
                        }
                    }
                    catch (ParserException parserException) {
                        Print.logWarn("Pushpin Exception: " + eventFunctionMap.getAccountID() + "/" + eventData.getStatusCodeDescription(null) + " [" + parserException, new Object[0]);
                    }
                }
                return objectArray.length >= 1 ? 54.StringValue(objectArray[0]) : "";
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ICON", "$PUSHPIN"}){

            @Override
            public String getUsage() {
                return "String $ICON([String dftIconID])";
            }

            @Override
            public String getDescription() {
                return "Return the statusCode icon or device icon";
            }

            @Override
            public Class getReturnType() {
                return String.class;
            }

            @Override
            public Object getDefaultValue() {
                return "";
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !55.HasStringArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                EventData eventData = eventFunctionMap.getEventData();
                if (eventData == null) {
                    return objectArray.length >= 1 ? 55.StringValue(objectArray[0]) : "";
                }
                Device device = eventData.getDevice();
                if (device == null) {
                    return objectArray.length >= 1 ? 55.StringValue(objectArray[0]) : "";
                }
                int n = eventFunctionMap.getRecursionLevel();
                if (n >= 0) {
                    try {
                        BasicPrivateLabel basicPrivateLabel = eventFunctionMap.getPrivateLabel();
                        String string = StatusCode.getIconSelector(device, eventData.getStatusCode(), basicPrivateLabel);
                        if (!StringTools.isBlank(string)) {
                            Selector.Result result = EventSelector.getInstance().getResult(n + 1, string, eventData);
                            return result.getValue();
                        }
                        String string2 = StatusCode.getIconName(device, eventData.getStatusCode(), basicPrivateLabel);
                        if (!StringTools.isBlank(string2)) {
                            return string2;
                        }
                    }
                    catch (ParserException parserException) {
                        Print.logWarn("Pushpin Exception: " + eventFunctionMap.getAccountID() + "/" + eventData.getStatusCodeDescription(null) + " [" + parserException, new Object[0]);
                    }
                }
                if (device.hasPushpinID()) {
                    return device.getPushpinID();
                }
                return objectArray.length >= 1 ? 55.StringValue(objectArray[0]) : "";
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$RTPROP", "$RTP"}){

            @Override
            public String getUsage() {
                return "String $RTPROP(String PROP_ID [, String DFT])";
            }

            @Override
            public String getDescription() {
                return "Return Runtime property value";
            }

            @Override
            public Class getReturnType() {
                return String.class;
            }

            @Override
            public Object getDefaultValue() {
                return "";
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, String.class, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 2 || !56.HasStringArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string = (String)objectArray[0];
                String string2 = objectArray.length >= 2 ? (String)objectArray[1] : "";
                BasicPrivateLabel basicPrivateLabel = eventFunctionMap.getPrivateLabel();
                return basicPrivateLabel != null && basicPrivateLabel.hasProperty(string) ? basicPrivateLabel.getStringProperty(string, string2) : RTConfig.getString(string, string2);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DEVRULE"}){

            @Override
            public String getUsage() {
                return "Object $DEVRULE([Object DFT])";
            }

            @Override
            public String getDescription() {
                return "Evaluate device notify selector, return result";
            }

            @Override
            public Class getReturnType() {
                return Object.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                String string;
                if (objectArray.length > 1) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Long l = objectArray.length >= 1 ? objectArray[0] : LONG_FALSE;
                Device device = eventFunctionMap.getDevice();
                String string2 = string = device != null ? device.getNotifySelector() : "";
                if (StringTools.isBlank(string)) {
                    return l;
                }
                int n = eventFunctionMap.getRecursionLevel();
                if (n >= 0) {
                    EventData eventData = eventFunctionMap.getEventData();
                    if (eventData == null) {
                        return l;
                    }
                    try {
                        return EventSelector.getInstance().getResult(n + 1, string, eventData).getValue();
                    }
                    catch (ParserException parserException) {
                        Print.logWarn("Selector Exception: " + string + " [" + parserException, new Object[0]);
                        return l;
                    }
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$EVAL"}){

            @Override
            public String getUsage() {
                return "Object $EVAL(String SEL [, Object DFT [, Boolean PRIOR_EVENT]])";
            }

            @Override
            public String getDescription() {
                return "Evaluate selector, return result";
            }

            @Override
            public Class getReturnType() {
                return Object.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, 3, String.class, Object.class, Boolean.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                Long l;
                if (objectArray.length < 1 || objectArray.length > 3 || !58.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string = (String)objectArray[0];
                Long l2 = l = objectArray.length >= 2 ? objectArray[1] : LONG_FALSE;
                if (StringTools.isBlank(string)) {
                    return l;
                }
                int n = eventFunctionMap.getRecursionLevel();
                if (n >= 0) {
                    EventData eventData;
                    boolean bl = objectArray.length >= 3 && 58.BooleanValue(objectArray[2]);
                    EventData eventData2 = eventData = bl ? eventFunctionMap.getPreviousEventData() : eventFunctionMap.getEventData();
                    if (eventData == null) {
                        return l;
                    }
                    try {
                        return EventSelector.getInstance().getResult(n + 1, string, eventData).getValue();
                    }
                    catch (ParserException parserException) {
                        Print.logWarn("Selector Exception: " + string + " [" + parserException, new Object[0]);
                        return l;
                    }
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$RTEVAL", "$RTE"}){

            @Override
            public String getUsage() {
                return "Object $RTEVAL(String PROP_ID [, Object DFT_VAL])";
            }

            @Override
            public String getDescription() {
                return "Evaluate Runtime property selector";
            }

            @Override
            public Class getReturnType() {
                return Object.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, String.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                String string;
                if (objectArray.length < 1 || objectArray.length > 2 || !59.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string2 = (String)objectArray[0];
                Long l = objectArray.length >= 2 ? objectArray[1] : LONG_FALSE;
                BasicPrivateLabel basicPrivateLabel = eventFunctionMap.getPrivateLabel();
                String string3 = string = basicPrivateLabel != null && basicPrivateLabel.hasProperty(string2) ? basicPrivateLabel.getStringProperty(string2, null) : RTConfig.getString(string2, null);
                if (StringTools.isBlank(string)) {
                    return l;
                }
                int n = eventFunctionMap.getRecursionLevel();
                if (n >= 0) {
                    EventData eventData = eventFunctionMap.getEventData();
                    if (eventData == null) {
                        return l;
                    }
                    try {
                        return EventSelector.getInstance().getResult(n + 1, string, eventData).getValue();
                    }
                    catch (ParserException parserException) {
                        Print.logWarn("Selector Exception: " + string + " [" + parserException, new Object[0]);
                        return l;
                    }
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$RULE", "$RUL"}){

            @Override
            public String getUsage() {
                return "Object $RULE(String ID [, Object DFT])";
            }

            @Override
            public String getDescription() {
                return "Execute Account rule-ID, return result";
            }

            @Override
            public Class getReturnType() {
                return Object.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, String.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 2 || !60.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Account account = eventFunctionMap.getAccount();
                if (account == null) {
                    return LONG_FALSE;
                }
                int n = eventFunctionMap.getRecursionLevel();
                if (n >= 0) {
                    EventData eventData = eventFunctionMap.getEventData();
                    String string = (String)objectArray[0];
                    try {
                        return EventSelector.getInstance().getAccountRuleResult(n + 1, account, string, eventData).getValue();
                    }
                    catch (DBException dBException) {
                        if (objectArray.length >= 2) {
                            return objectArray[1];
                        }
                        Print.logWarn("Rule DBException: " + eventFunctionMap.getAccountID() + "/" + string + " [" + dBException, new Object[0]);
                        return LONG_FALSE;
                    }
                    catch (ParserException parserException) {
                        if (objectArray.length >= 2) {
                            return objectArray[1];
                        }
                        Print.logWarn("Rule Exception: " + eventFunctionMap.getAccountID() + "/" + string + " [" + parserException, new Object[0]);
                        return null;
                    }
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$SYSRULE"}){

            @Override
            public String getUsage() {
                return "Object $SYSRULE(String ID [, Object DFT])";
            }

            @Override
            public String getDescription() {
                return "Execute system rule-ID, return result";
            }

            @Override
            public Class getReturnType() {
                return Object.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, String.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 2 || !61.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                int n = eventFunctionMap.getRecursionLevel();
                if (n >= 0) {
                    EventData eventData = eventFunctionMap.getEventData();
                    String string = (String)objectArray[0];
                    try {
                        return EventSelector.getInstance().getSysAdminRuleResult(n + 1, string, eventData).getValue();
                    }
                    catch (DBException dBException) {
                        if (objectArray.length >= 2) {
                            return objectArray[1];
                        }
                        String string2 = StringTools.blankDefault(AccountRecord.getSystemAdminAccountID(), "?");
                        Print.logWarn("Rule DBException: " + string2 + "/" + string + " [" + dBException, new Object[0]);
                        return LONG_FALSE;
                    }
                    catch (ParserException parserException) {
                        if (objectArray.length >= 2) {
                            return objectArray[1];
                        }
                        String string3 = StringTools.blankDefault(AccountRecord.getSystemAdminAccountID(), "?");
                        Print.logWarn("Rule Exception: " + string3 + "/" + string + " [" + parserException, new Object[0]);
                        return null;
                    }
                }
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$EFIELD", "$EFLD"}){

            @Override
            public String getUsage() {
                return "Object $EFIELD(String FIELD_NAME [, Boolean PRIOR_EVENT])";
            }

            @Override
            public String getDescription() {
                return "Return Event field value";
            }

            @Override
            public Class getReturnType() {
                return Object.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, String.class, Boolean.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                EventData eventData;
                if (objectArray.length < 1 || objectArray.length > 2 || !62.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string = (String)objectArray[0];
                boolean bl = objectArray.length >= 2 && 62.BooleanValue(objectArray[1]);
                EventData eventData2 = eventData = bl ? eventFunctionMap.getPreviousEventData() : eventFunctionMap.getEventData();
                if (eventData == null) {
                    DBFactory<EventData> dBFactory = EventData.getFactory();
                    if (dBFactory.hasField(string)) {
                        return dBFactory.getField(string).getDefaultValue();
                    }
                    Print.logWarn("Event field not found: " + string, new Object[0]);
                    return null;
                }
                Object object = eventData.getValue(string);
                if (object == null) {
                    Print.logWarn("Event field not found: " + string, new Object[0]);
                    return null;
                }
                if (object instanceof Double || object instanceof Long || object instanceof String) {
                    return object;
                }
                if (object instanceof Float) {
                    return new Double(((Number)object).doubleValue());
                }
                if (object instanceof Boolean) {
                    return (Boolean)object != false ? LONG_TRUE : LONG_FALSE;
                }
                if (object instanceof Number) {
                    return new Long(((Number)object).longValue());
                }
                return object.toString();
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DFIELD", "$DFLD"}){

            @Override
            public String getUsage() {
                return "Object $DFIELD(String FIELD_NAME)";
            }

            @Override
            public String getDescription() {
                return "Return Device field value";
            }

            @Override
            public Class getReturnType() {
                return Object.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !63.IsStringArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                String string = (String)objectArray[0];
                Device device = eventFunctionMap.getDevice();
                if (device == null) {
                    DBFactory<Device> dBFactory = Device.getFactory();
                    if (dBFactory.hasField(string)) {
                        return dBFactory.getField(string).getDefaultValue();
                    }
                    Print.logWarn("Device field not found: " + string, new Object[0]);
                    return null;
                }
                Object object = device.getValue(string);
                if (object == null) {
                    Print.logWarn("Device field not found: " + string, new Object[0]);
                    return null;
                }
                if (object instanceof Double || object instanceof Long || object instanceof String) {
                    return object;
                }
                if (object instanceof Float) {
                    return new Double(((Number)object).doubleValue());
                }
                if (object instanceof Boolean) {
                    return (Boolean)object != false ? LONG_TRUE : LONG_FALSE;
                }
                if (object instanceof Number) {
                    return new Long(((Number)object).longValue());
                }
                return object.toString();
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$EQ"}){

            @Override
            public String getUsage() {
                return "Boolean $EQ(Object A, Object B)";
            }

            @Override
            public String getDescription() {
                return "True iff A equals B, ignoring case";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, Object.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                String string;
                if (objectArray.length != 2) {
                    return null;
                }
                String string2 = 64.StringValue(objectArray[0]);
                return string2.equalsIgnoreCase(string = 64.StringValue(objectArray[1])) ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$STARTSWITH", "$SW"}){

            @Override
            public String getUsage() {
                return "Boolean $SW(Object A, Object B)";
            }

            @Override
            public String getDescription() {
                return "True iff A starts with B, ignoring case";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, Object.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                String string;
                if (objectArray.length != 2) {
                    return null;
                }
                String string2 = 65.StringValue(objectArray[0]);
                return StringTools.startsWithIgnoreCase(string2, string = 65.StringValue(objectArray[1])) ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ENDSWITH", "$EW"}){

            @Override
            public String getUsage() {
                return "Boolean $EW(Object A, Object B)";
            }

            @Override
            public String getDescription() {
                return "True iff A ends with B, ignoring case";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, Object.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                String string;
                if (objectArray.length != 2) {
                    return null;
                }
                String string2 = 66.StringValue(objectArray[0]);
                return StringTools.endsWithIgnoreCase(string2, string = 66.StringValue(objectArray[1])) ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$CONTAINS"}){

            @Override
            public String getUsage() {
                return "Boolean $CONTAINS(Object A, Object B)";
            }

            @Override
            public String getDescription() {
                return "True iff A contains B, ignoring case";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, Object.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                String string;
                if (objectArray.length != 2) {
                    return null;
                }
                String string2 = 67.StringValue(objectArray[0]);
                return StringTools.indexOfIgnoreCase(string2, string = 67.StringValue(objectArray[1])) >= 0 ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$MAX"}){

            @Override
            public String getUsage() {
                return "Double $MAX(Double A, Double B [, Double C [, Double D]])";
            }

            @Override
            public String getDescription() {
                return "Maximum value of A, B, C, D";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, 3, 4, Double.class, Double.class, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 2 || objectArray.length > 4 || !68.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 68.DoubleValue(objectArray[0]);
                for (int i = 1; i < objectArray.length; ++i) {
                    double d2 = 68.DoubleValue(objectArray[i]);
                    if (!(d2 > d)) continue;
                    d = d2;
                }
                return new Double(d);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$MIN"}){

            @Override
            public String getUsage() {
                return "Double $MIN(Double A, Double B [, Double C [, Double D]])";
            }

            @Override
            public String getDescription() {
                return "Minimum value of A, B, C, D";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, 3, 4, Double.class, Double.class, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 2 || objectArray.length > 4 || !69.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 69.DoubleValue(objectArray[0]);
                for (int i = 1; i < objectArray.length; ++i) {
                    double d2 = 69.DoubleValue(objectArray[i]);
                    if (!(d2 < d)) continue;
                    d = d2;
                }
                return new Double(d);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$POW"}){

            @Override
            public String getUsage() {
                return "Double $POW(Double A, Double B)";
            }

            @Override
            public String getDescription() {
                return "Value of A raised to the B power";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 2 || !70.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 70.DoubleValue(objectArray[0]);
                double d2 = 70.DoubleValue(objectArray[1]);
                return new Double(Math.pow(d, d2));
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$SQRT"}){

            @Override
            public String getUsage() {
                return "Double $SQRT(Double A)";
            }

            @Override
            public String getDescription() {
                return "Square root of A";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !71.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 71.DoubleValue(objectArray[0]);
                return new Double(Math.sqrt(d));
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$HEX"}){

            @Override
            public String getUsage() {
                return "String $HEX(Long A)";
            }

            @Override
            public String getDescription() {
                return "Convert A to hex String";
            }

            @Override
            public Class getReturnType() {
                return String.class;
            }

            @Override
            public Object getDefaultValue() {
                return "0x0000";
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !72.HasNumericArgs(objectArray)) {
                    return null;
                }
                long l = 72.LongValue(objectArray[0]);
                return "0x" + StringTools.toHexString(l, 16);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$BIT"}){

            @Override
            public String getUsage() {
                return "Boolean $BIT(Long A, Long B)";
            }

            @Override
            public String getDescription() {
                return "True iff bit B in value A is set";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                int n;
                if (objectArray.length != 2 || !73.HasNumericArgs(objectArray)) {
                    return null;
                }
                long l = 73.LongValue(objectArray[0]);
                return (l & 1L << (n = 73.IntValue(objectArray[1]) & 0x3F)) != 0L ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ROUND", "$RND"}){

            @Override
            public String getUsage() {
                return "Long $ROUND(Double A)";
            }

            @Override
            public String getDescription() {
                return "A rounded to the nearest whole integer";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !74.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 74.DoubleValue(objectArray[0]);
                return new Long(Math.round(d));
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$CEIL"}){

            @Override
            public String getUsage() {
                return "Long $CEIL(Double A)";
            }

            @Override
            public String getDescription() {
                return "Round up to the nearest integer";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !75.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 75.DoubleValue(objectArray[0]);
                return new Long((long)Math.ceil(d));
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$FLOOR"}){

            @Override
            public String getUsage() {
                return "Long $FLOOR(Double A)";
            }

            @Override
            public String getDescription() {
                return "Round down to the nearest integer";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !76.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 76.DoubleValue(objectArray[0]);
                return new Long((long)Math.floor(d));
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$TRUNC", "$INT"}){

            @Override
            public String getUsage() {
                return "Long $TRUNC(Double A)";
            }

            @Override
            public String getDescription() {
                return "Whole integer portion of A";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !77.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 77.DoubleValue(objectArray[0]);
                return new Long((long)d);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$FRAC", "$FRC"}){

            @Override
            public String getUsage() {
                return "Long $FRAC(Double A)";
            }

            @Override
            public String getDescription() {
                return "Fractional portion of A";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 1 || !78.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = 78.DoubleValue(objectArray[0]);
                return new Double(d - (double)((long)d));
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$RANDOM", "$RAN"}){

            @Override
            public String getUsage() {
                return "Double $RANDOM([Double A])";
            }

            @Override
            public String getDescription() {
                return "Random value between 0.0 and 1.0 (or A, if specified)";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !79.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d = objectArray.length >= 1 ? 79.DoubleValue(objectArray[0]) : 1.0;
                return new Double(Math.random() * d);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$INDEX"}){

            @Override
            public String getUsage() {
                return "Object $INDEX(Integer I, Object A0, Object A1 [, Object A2])";
            }

            @Override
            public String getDescription() {
                return "Return indexed value of A0, A1, A2, ...";
            }

            @Override
            public Class getReturnType() {
                return Object.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(3, 4, Long.class, Object.class, Object.class, Object.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 3 || !80.IsNumericArg(objectArray[0])) {
                    return null;
                }
                int n = 80.IntValue(objectArray[0]);
                if (n >= 0 && n < objectArray.length - 1) {
                    return objectArray[n + 1];
                }
                return 80.IsStringArg(objectArray[1]) ? "" : LONG_ZERO;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$DOUBLE", "$D"}){

            @Override
            public String getUsage() {
                return "Double $DOUBLE(Object A [, Double D])";
            }

            @Override
            public String getDescription() {
                return "Convert A to Double, or D, if A cannot be converted";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, Object.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 2) {
                    return null;
                }
                if (81.IsNumericArg(objectArray[0])) {
                    return objectArray[0] instanceof Double ? (Double)objectArray[0] : new Double(81.DoubleValue(objectArray[0]));
                }
                if (StringTools.isDouble(objectArray[0], false)) {
                    return new Double(StringTools.parseDouble(objectArray[0], 0.0));
                }
                if (objectArray.length >= 2 && 81.IsNumericArg(objectArray[1])) {
                    return objectArray[1] instanceof Double ? (Double)objectArray[1] : new Double(StringTools.parseDouble(objectArray[1], 0.0));
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$LONG", "$L"}){

            @Override
            public String getUsage() {
                return "Long $LONG(Object A [, Long D])";
            }

            @Override
            public String getDescription() {
                return "Convert A to Long, or D, if A cannot be converted";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, Object.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 2) {
                    return null;
                }
                if (82.IsNumericArg(objectArray[0])) {
                    return objectArray[0] instanceof Long ? (Long)objectArray[0] : new Long(82.LongValue(objectArray[0]));
                }
                if (StringTools.isLong(objectArray[0], false)) {
                    return new Long(StringTools.parseLong(objectArray[0], 0L));
                }
                if (objectArray.length >= 2 && 82.IsNumericArg(objectArray[1])) {
                    return objectArray[1] instanceof Long ? (Long)objectArray[1] : new Long(StringTools.parseLong(objectArray[1], 0L));
                }
                return null;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$RANGE", "$RNG"}){

            @Override
            public String getUsage() {
                return "Boolean $RANGE(Doubla A, Double B, Double C)";
            }

            @Override
            public String getDescription() {
                return "True iff A is between B/C (inclusive)";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(3, Double.class, Double.class, Double.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                double d;
                if (objectArray.length != 3 || !83.HasNumericArgs(objectArray)) {
                    return null;
                }
                double d2 = 83.DoubleValue(objectArray[0]);
                double d3 = 83.DoubleValue(objectArray[1]);
                if (d3 <= (d = 83.DoubleValue(objectArray[2]))) {
                    return d2 >= d3 && d2 <= d ? LONG_TRUE : LONG_FALSE;
                }
                return d2 >= d && d2 <= d3 ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$NOW"}){

            @Override
            public String getUsage() {
                return "Timestamp $NOW()";
            }

            @Override
            public String getDescription() {
                return "Current Timestamp (seconds)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return new Long(DateTime.getCurrentTimeSec());
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 0) {
                    return null;
                }
                return new Long(DateTime.getCurrentTimeSec());
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$FMTTIME", "$FMTDATE"}){

            @Override
            public String getUsage() {
                return "String $FMTTIME(Long EPOCH [, String TIME_ZONE])";
            }

            @Override
            public String getDescription() {
                return "Convert Epoch time to String format";
            }

            @Override
            public Class getReturnType() {
                return String.class;
            }

            @Override
            public Object getDefaultValue() {
                return new DateTime().toString();
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(1, 2, Long.class, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray.length > 2 || !85.IsNumericArg(objectArray[0])) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                long l = 85.LongValue(objectArray[0]);
                TimeZone timeZone = eventFunctionMap.getTimeZone(objectArray.length > 1 ? 85.StringValue(objectArray[1]) : null);
                return new DateTime(l, timeZone).toString();
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$EXPIRED"}){

            @Override
            public String getUsage() {
                return "Boolean $EXPIRED(Long A, Long B)";
            }

            @Override
            public String getDescription() {
                return "True if ((A > 0) && (A < B))";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, Long.class, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length != 2 || !86.HasNumericArgs(objectArray)) {
                    return null;
                }
                long l = 86.LongValue(objectArray[0]);
                long l2 = 86.LongValue(objectArray[1]);
                return l > 0L && l < l2 ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$TRUE", "$T"}){

            @Override
            public String getUsage() {
                return "Boolean $TRUE()";
            }

            @Override
            public String getDescription() {
                return "True";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_TRUE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                return LONG_TRUE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$FALSE", "$F"}){

            @Override
            public String getUsage() {
                return "Boolean $FALSE()";
            }

            @Override
            public String getDescription() {
                return "False";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                return LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$LASTLOGIN"}){

            @Override
            public String getUsage() {
                return "Seconds|Boolean $LASTLOGIN([Long E])";
            }

            @Override
            public String getDescription() {
                return "Seconds since last login (or true if <= E)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return new Long(DateTime.getCurrentTimeSec());
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !89.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                long l = DateTime.getCurrentTimeSec();
                Account account = eventFunctionMap.getAccount();
                if (account == null) {
                    return objectArray.length >= 1 ? LONG_FALSE : new Long(l);
                }
                long l2 = l - account.getLastLoginTime();
                if (objectArray.length == 0) {
                    return new Long(l2);
                }
                long l3 = 89.LongValue(objectArray[0]);
                return l2 <= l3 ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$ACCOUNTEXPIRED", "$ACCTEXP"}){

            @Override
            public String getUsage() {
                return "Boolean $ACCOUNTEXPIRED([Long E])";
            }

            @Override
            public String getDescription() {
                return "True if Account has expired";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_TRUE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, Long.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !90.HasNumericArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Account account = eventFunctionMap.getAccount();
                if (account == null) {
                    return LONG_TRUE;
                }
                long l = objectArray.length >= 1 ? 90.LongValue(objectArray[0]) : 0L;
                return account.willExpire(l) ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$PASSWORDEXPIRED", "$PWDEXP"}){

            @Override
            public String getUsage() {
                return "Boolean $PASSWORDEXPIRED()";
            }

            @Override
            public String getDescription() {
                return "True if Account password has expired";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_TRUE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 0) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                Account account = eventFunctionMap.getAccount();
                if (account == null) {
                    return LONG_TRUE;
                }
                return account.hasPasswordExpired() ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$LASTDCS"}){

            @Override
            public String getUsage() {
                return "Seconds $LASTDCS([String DCS])";
            }

            @Override
            public String getDescription() {
                return "Seconds since last DCS activity (current account)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return new Long(DateTime.getCurrentTimeSec());
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !92.HasStringArgs(objectArray)) {
                    return null;
                }
                EventFunctionMap eventFunctionMap = (EventFunctionMap)functionMap;
                long l = DateTime.getCurrentTimeSec();
                Account account = eventFunctionMap.getAccount();
                if (account == null) {
                    return new Long(l);
                }
                String string = objectArray.length >= 1 ? 92.StringValue(objectArray[0]) : null;
                long l2 = EventFunctionMap.getLastDCSActivity(string, account.getAccountID());
                if (l2 > 0L) {
                    return new Long(l - l2);
                }
                return new Long(l);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$GTS_HOME"}){

            @Override
            public String getUsage() {
                return "String $GTS_HOME()";
            }

            @Override
            public String getDescription() {
                return "The GTS Installation directory";
            }

            @Override
            public Class getReturnType() {
                return String.class;
            }

            @Override
            public Object getDefaultValue() {
                return "";
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                File file;
                if (objectArray.length != 0) {
                    return null;
                }
                String string = null;
                try {
                    string = System.getenv("GTS_HOME");
                    if (!StringTools.isBlank(string)) {
                        if (string.indexOf("\"") >= 0 || string.indexOf("'") >= 0) {
                            string = null;
                        }
                        if (!(file = new File(string)).isDirectory()) {
                            string = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    string = null;
                }
                if (StringTools.isBlank(string) && (file = RTConfig.getLoadedConfigDir()) != null && file.isDirectory()) {
                    string = file.toString();
                }
                return StringTools.trim(string);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_LASTDCS"}){

            @Override
            public String getUsage() {
                return "Seconds $G_LASTDCS([String DCS])";
            }

            @Override
            public String getDescription() {
                return "Seconds since last DCS activity (any account)";
            }

            @Override
            public Class getReturnType() {
                return Long.class;
            }

            @Override
            public Object getDefaultValue() {
                return new Long(DateTime.getCurrentTimeSec());
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !94.HasStringArgs(objectArray)) {
                    return null;
                }
                long l = DateTime.getCurrentTimeSec();
                String string = objectArray.length >= 1 ? 94.StringValue(objectArray[0]) : null;
                long l2 = EventFunctionMap.getLastDCSActivity(string, null);
                if (l2 > 0L) {
                    return new Long(l - l2);
                }
                return new Long(l);
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_DISKTOTAL", "$G_TOTALDISK", "$G_TOTALSPACE"}){

            @Override
            public String getUsage() {
                return "Double $G_DISKTOTAL([String DIR])";
            }

            @Override
            public String getDescription() {
                return "Total Number of megabytes available in the named directory";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !95.HasStringArgs(objectArray)) {
                    return null;
                }
                try {
                    File file;
                    File file2 = file = objectArray.length >= 1 ? new File(95.StringValue(objectArray[0])) : RTConfig.getLoadedConfigDir();
                    if (file != null && file.isDirectory()) {
                        long l = file.getTotalSpace();
                        return new Double((double)l / 1048576.0);
                    }
                    return DOUBLE_ZERO;
                }
                catch (Throwable throwable) {
                    return DOUBLE_ZERO;
                }
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_DISKFREE", "$G_FREEDISK", "$G_FREESPACE"}){

            @Override
            public String getUsage() {
                return "Double $G_DISKFREE([String DIR])";
            }

            @Override
            public String getDescription() {
                return "Number of free megabytes available in the named directory";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !96.HasStringArgs(objectArray)) {
                    return null;
                }
                try {
                    File file;
                    File file2 = file = objectArray.length >= 1 ? new File(96.StringValue(objectArray[0])) : RTConfig.getLoadedConfigDir();
                    if (file != null && file.isDirectory()) {
                        long l = file.getUsableSpace();
                        return new Double((double)l / 1048576.0);
                    }
                    return DOUBLE_ZERO;
                }
                catch (Throwable throwable) {
                    return DOUBLE_ZERO;
                }
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_DISKUSED", "$G_USEDDISK", "$G_USEDSPACE"}){

            @Override
            public String getUsage() {
                return "Double $G_DISKUSED([String DIR])";
            }

            @Override
            public String getDescription() {
                return "Number of used megabytes available in the named directory";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !97.HasStringArgs(objectArray)) {
                    return null;
                }
                try {
                    File file;
                    File file2 = file = objectArray.length >= 1 ? new File(97.StringValue(objectArray[0])) : RTConfig.getLoadedConfigDir();
                    if (file != null && file.isDirectory()) {
                        long l = file.getUsableSpace();
                        long l2 = file.getTotalSpace();
                        long l3 = l2 > l ? l2 - l : 0L;
                        return new Double((double)l3 / 1048576.0);
                    }
                    return DOUBLE_ZERO;
                }
                catch (Throwable throwable) {
                    return DOUBLE_ZERO;
                }
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_DISKUSAGE"}){

            @Override
            public String getUsage() {
                return "Double $G_DISKUSAGE([String DIR])";
            }

            @Override
            public String getDescription() {
                return "Disk usage percent (0..1)";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, 1, String.class);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 1 || !98.HasStringArgs(objectArray)) {
                    return null;
                }
                try {
                    File file;
                    File file2 = file = objectArray.length >= 1 ? new File(98.StringValue(objectArray[0])) : RTConfig.getLoadedConfigDir();
                    if (file != null && file.isDirectory()) {
                        long l = file.getUsableSpace();
                        long l2 = file.getTotalSpace();
                        long l3 = l2 > l ? l2 - l : 0L;
                        return l2 > 0L ? new Double((double)l3 / (double)l2) : DOUBLE_ZERO;
                    }
                    return DOUBLE_ZERO;
                }
                catch (Throwable throwable) {
                    return DOUBLE_ZERO;
                }
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_MEMORYTOTAL"}){

            @Override
            public String getUsage() {
                return "Double $G_MEMORYTOTAL()";
            }

            @Override
            public String getDescription() {
                return "System memory total (bytes)";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 0) {
                    return null;
                }
                OSTools.MemoryUsage memoryUsage = OSTools.getSystemMemoryUsage(null);
                if (memoryUsage != null) {
                    long l = memoryUsage.getTotal();
                    return new Double((double)l / 1048576.0);
                }
                return DOUBLE_ZERO;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_MEMORYFREE"}){

            @Override
            public String getUsage() {
                return "Double $G_MEMORYFREE()";
            }

            @Override
            public String getDescription() {
                return "System memory free (bytes)";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 0) {
                    return null;
                }
                OSTools.MemoryUsage memoryUsage = OSTools.getSystemMemoryUsage(null);
                if (memoryUsage != null) {
                    long l = memoryUsage.getFree();
                    return new Double((double)l / 1048576.0);
                }
                return DOUBLE_ZERO;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_MEMORYUSED"}){

            @Override
            public String getUsage() {
                return "Double $G_MEMORYUSED()";
            }

            @Override
            public String getDescription() {
                return "System memory used (bytes)";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 0) {
                    return null;
                }
                OSTools.MemoryUsage memoryUsage = OSTools.getSystemMemoryUsage(null);
                if (memoryUsage != null) {
                    long l = memoryUsage.getUsed();
                    return new Double((double)l / 1048576.0);
                }
                return DOUBLE_ZERO;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_MEMORYUSAGE"}){

            @Override
            public String getUsage() {
                return "Double $G_MEMORYUSAGE()";
            }

            @Override
            public String getDescription() {
                return "System memory usage percent (0..1)";
            }

            @Override
            public Class getReturnType() {
                return Double.class;
            }

            @Override
            public Object getDefaultValue() {
                return DOUBLE_ZERO;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(0, new Class[0]);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length > 0) {
                    return null;
                }
                OSTools.MemoryUsage memoryUsage = OSTools.getSystemMemoryUsage(null);
                if (memoryUsage != null) {
                    double d = memoryUsage.getUsage();
                    return new Double(d);
                }
                return DOUBLE_ZERO;
            }
        });
        this.addFunction(new EventFunctionHandler(new String[]{"$G_SOCKET"}){

            @Override
            public String getUsage() {
                return "Boolean $G_SOCKET(String HOST, Long PORT [, Long TIMEOUT_MS])";
            }

            @Override
            public String getDescription() {
                return "True if the named host:port is accessible";
            }

            @Override
            public Class getReturnType() {
                return Boolean.class;
            }

            @Override
            public Object getDefaultValue() {
                return LONG_FALSE;
            }

            @Override
            public EventFunctionHandler.ArgCk getArgCheck() {
                return (EventFunctionHandler)this.new EventFunctionHandler.ArgCk(2, 3, String.class, Long.class, Long.class);
            }

            @Override
            public boolean isCronOnly() {
                return true;
            }

            @Override
            public boolean isSystemAdminOnly() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invokeFunction(FunctionMap functionMap, Object[] objectArray) {
                if (objectArray.length < 2 || objectArray.length > 3 || !103.IsStringArg(objectArray[0]) || !103.IsNumericArg(objectArray[1])) {
                    return null;
                }
                String string = 103.StringValue(objectArray[0]);
                int n = 103.IntValue(objectArray[1]);
                Socket socket = null;
                boolean bl = false;
                try {
                    int n2;
                    int n3 = n2 = objectArray.length >= 3 && 103.IsNumericArg(objectArray[2]) ? 103.IntValue(objectArray[2]) : 3000;
                    if (n2 > 7000) {
                        n2 = 7000;
                    }
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(string, n), n2);
                    bl = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (ConnectException connectException) {
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (Throwable throwable) {
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Throwable throwable) {}
                    socket = null;
                }
                return bl ? LONG_TRUE : LONG_FALSE;
            }
        });
    }
}

