/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.event;

import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.rule.event.EventFunctionMap;
import org.opengts.rule.selector.FunctionHandler;
import org.opengts.rule.selector.FunctionMap;
import org.opengts.util.StringTools;

public abstract class EventFunctionHandler
implements FunctionHandler {
    public static final Long LONG_TRUE = FunctionHandler.LONG_TRUE;
    public static final Long LONG_FALSE = FunctionHandler.LONG_FALSE;
    public static final Long LONG_ZERO = FunctionHandler.LONG_ZERO;
    public static final Double DOUBLE_ZERO = FunctionHandler.DOUBLE_ZERO;
    private String[] names = null;
    private ArgCk argCheck = null;

    public static boolean IsStringArg(Object object) {
        return object instanceof String;
    }

    public static boolean HasStringArgs(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (EventFunctionHandler.IsStringArg(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public static String StringValue(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Number) {
            return String.valueOf(((Number)object).longValue());
        }
        return object.toString();
    }

    public static boolean IsNumericArg(Object object) {
        return object instanceof Number;
    }

    public static boolean HasNumericArgs(Object[] objectArray) {
        return EventFunctionHandler.HasNumericArgs(objectArray, 0);
    }

    public static boolean HasNumericArgs(Object[] objectArray, int n) {
        if (objectArray == null) {
            return true;
        }
        for (int i = n; i < objectArray.length; ++i) {
            if (EventFunctionHandler.IsNumericArg(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public static double DoubleValue(Object object) {
        return object instanceof Number ? ((Number)object).doubleValue() : 0.0;
    }

    public static long LongValue(Object object) {
        return object instanceof Number ? ((Number)object).longValue() : 0L;
    }

    public static int IntValue(Object object) {
        return object instanceof Number ? ((Number)object).intValue() : 0;
    }

    public static boolean BooleanValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue() != 0L;
        }
        if (object instanceof String) {
            return !object.equals("");
        }
        return !object.toString().equals("");
    }

    public static EventData GetEventData(FunctionMap functionMap) {
        if (functionMap instanceof EventFunctionMap) {
            return ((EventFunctionMap)functionMap).getEventData();
        }
        return null;
    }

    public static String GetAccountID(FunctionMap functionMap) {
        if (functionMap instanceof EventFunctionMap) {
            return ((EventFunctionMap)functionMap).getAccountID();
        }
        return null;
    }

    public static Account GetAccount(FunctionMap functionMap) {
        if (functionMap instanceof EventFunctionMap) {
            return ((EventFunctionMap)functionMap).getAccount();
        }
        return null;
    }

    public static String GetDeviceID(FunctionMap functionMap) {
        if (functionMap instanceof EventFunctionMap) {
            return ((EventFunctionMap)functionMap).getDeviceID();
        }
        return null;
    }

    public static Device GetDevice(FunctionMap functionMap) {
        if (functionMap instanceof EventFunctionMap) {
            return ((EventFunctionMap)functionMap).getDevice();
        }
        return null;
    }

    public EventFunctionHandler(String ... stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = StringTools.trim(stringArray[i]).toUpperCase();
            if (string.equals("")) continue;
            vector.add(string);
        }
        this.names = vector.toArray(new String[vector.size()]);
        this.argCheck = this.getArgCheck();
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    public Class getReturnType() {
        return null;
    }

    public Object getDefaultValue() {
        Class clazz = this.getReturnType();
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(Long.class)) {
            return LONG_ZERO;
        }
        if (clazz.equals(Boolean.class)) {
            return LONG_FALSE;
        }
        if (clazz.equals(Double.class)) {
            return DOUBLE_ZERO;
        }
        if (clazz.equals(String.class)) {
            return "";
        }
        return null;
    }

    public ArgCk getArgCheck() {
        return null;
    }

    public boolean checkArgs(Object[] objectArray) {
        return this.argCheck == null || this.argCheck.check(objectArray);
    }

    public boolean isSystemAdminOnly() {
        return false;
    }

    public boolean isCronOnly() {
        return false;
    }

    public String toString() {
        return StringTools.join(this.getNames(), ',');
    }

    @Override
    public abstract Object invokeFunction(FunctionMap var1, Object[] var2);

    public class ArgCk {
        private int[] argCnt = null;
        private Class[] argTyp = null;

        public ArgCk(int n, Class ... classArray) {
            this.argCnt = new int[]{n};
            this.argTyp = classArray;
        }

        public ArgCk(int n, int n2, Class ... classArray) {
            this.argCnt = new int[]{n, n2};
            this.argTyp = classArray;
        }

        public ArgCk(int n, int n2, int n3, Class ... classArray) {
            this.argCnt = new int[]{n, n2, n3};
            this.argTyp = classArray;
        }

        public ArgCk(int n, int n2, int n3, int n4, Class ... classArray) {
            this.argCnt = new int[]{n, n2, n3, n4};
            this.argTyp = classArray;
        }

        public ArgCk(int n, int n2, int n3, int n4, int n5, Class ... classArray) {
            this.argCnt = new int[]{n, n2, n3, n4, n5};
            this.argTyp = classArray;
        }

        public int[] getArgCounts() {
            return this.argCnt;
        }

        public Class[] getArgTypes() {
            return this.argTyp;
        }

        public boolean check(Object[] objectArray) {
            int n;
            int n2 = objectArray == null ? 0 : objectArray.length;
            for (n = 0; n < this.argCnt.length && n2 != this.argCnt[n]; ++n) {
            }
            if (n >= this.argCnt.length) {
                return false;
            }
            for (n = 0; n < n2; ++n) {
                if (this.argTyp[n].equals(Object.class) || !(this.argTyp[n].equals(Long.class) || this.argTyp[n].equals(Double.class) || this.argTyp[n].equals(Boolean.class) ? !(objectArray[n] instanceof Number) : !(objectArray[n] instanceof String))) continue;
                return false;
            }
            return true;
        }
    }
}

