/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule;

import java.util.Collection;
import java.util.Set;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.EventRuleFactory;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class RuleCron {
    private static EventRuleFactory evRuleFact = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_RULE = new String[]{"rule", "ruleID"};
    private static final String[] ARG_TAG = new String[]{"tag", "ruleTag"};
    private static final String[] ARG_SELECTOR = new String[]{"selector"};
    private static final String[] ARG_NOEMAIL = new String[]{"noemail", "debug"};
    private static final String[] ARG_EMAIL_SUBJ = new String[]{"emailSubj", "emailSubject"};
    private static final String[] ARG_EMAIL_BODY = new String[]{"emailBody"};
    private static final String[] ARG_SMS_TEXT = new String[]{"smsText", "textMessage"};

    private static EventRuleFactory GetEventRuleFactory() {
        if (evRuleFact == null) {
            evRuleFact = new EventRuleFactory(new EventRuleAction(), true);
            Print.logInfo("EventRuleFactory Cron Mode = " + evRuleFact.getCronMode(), new Object[0]);
        }
        return evRuleFact;
    }

    private static int _executeCronRules(Account account, Set<String> set, String string, String string2, String string3, String string4, String string5, String string6) {
        int n = 0;
        if (account == null) {
            Print.logError("Account not specified!", new Object[0]);
            n = 99;
            return n;
        }
        String string7 = account.getAccountID();
        EventRuleFactory eventRuleFactory = RuleCron.GetEventRuleFactory();
        if (StringTools.isBlank(string)) {
            if (!StringTools.isBlank(string2)) {
                string = "ALL";
                string3 = null;
            } else if (StringTools.isBlank(string3)) {
                string = "ALL";
                string3 = null;
            } else {
                string = null;
                string2 = null;
            }
        } else if (string.equals("ALL")) {
            string3 = null;
        } else {
            String string8 = eventRuleFactory.getRuleSelector(account, string);
            if (string8 != null) {
                string2 = null;
                string3 = null;
            } else if (!StringTools.isBlank(string3)) {
                string = null;
                string2 = null;
            } else {
                Print.logError("No cron ruleID/selector to execute: " + string7, new Object[0]);
                n = 99;
                return n;
            }
        }
        if (!ListTools.isEmpty(set)) {
            for (String string9 : set) {
                try {
                    Device device = Device.getDevice(account, string9);
                    if (device != null) {
                        int n2;
                        RTProperties rTProperties;
                        EventData eventData = device.getLastEvent(-1L, false);
                        if (eventData != null) {
                            if (!StringTools.isBlank(string3)) {
                                rTProperties = eventData.getTemporaryProperties();
                                rTProperties.setString(EventRuleAction.PROP_emailSubj[0], string4);
                                rTProperties.setString(EventRuleAction.PROP_emailBody[0], string5);
                                rTProperties.setString(EventRuleAction.PROP_smsText[0], string6);
                                n2 = eventRuleFactory.executeSelector(string3, eventData);
                            } else if (string.equals("ALL")) {
                                Print.logDebug("Checking all rules (tag '" + string2 + "') for Device: " + string7 + "/" + string9, new Object[0]);
                                n2 = eventRuleFactory.executeRules(eventData, string2);
                            } else {
                                Print.logDebug("Checking ruleID: " + string + " (Device " + string7 + "/" + string9 + ")", new Object[0]);
                                n2 = eventRuleFactory.executeRule(eventData, string);
                            }
                        } else if (!StringTools.isBlank(string3)) {
                            rTProperties = device.getTemporaryProperties();
                            rTProperties.setString(EventRuleAction.PROP_emailSubj[0], string4);
                            rTProperties.setString(EventRuleAction.PROP_emailBody[0], string5);
                            rTProperties.setString(EventRuleAction.PROP_smsText[0], string6);
                            n2 = eventRuleFactory.executeSelector(string3, device);
                        } else if (string.equals("ALL")) {
                            Print.logDebug("Checking all rules (tag '" + string2 + "') for Device: " + string7 + "/" + string9, new Object[0]);
                            n2 = eventRuleFactory.executeRules(device, string2);
                        } else {
                            Print.logDebug("Checking ruleID: " + string + " (Device " + string7 + "/" + string9 + ")", new Object[0]);
                            n2 = eventRuleFactory.executeRule(device, string);
                        }
                        device.updateOtherChangedEventFields();
                        continue;
                    }
                    Print.logError("Device-ID does not exist: " + string7 + "/" + string9, new Object[0]);
                    n = 99;
                }
                catch (DBException dBException) {
                    Print.logException("Error processing rule for Device: " + string9, dBException);
                    n = 99;
                }
            }
        } else if (!StringTools.isBlank(string3)) {
            RTProperties rTProperties = account.getTemporaryProperties();
            rTProperties.setString(EventRuleAction.PROP_emailSubj[0], string4);
            rTProperties.setString(EventRuleAction.PROP_emailBody[0], string5);
            rTProperties.setString(EventRuleAction.PROP_smsText[0], string6);
            int n3 = eventRuleFactory.executeSelector(string3, account);
        } else if (string.equals("ALL")) {
            Print.logDebug("Specific rule not specified, ignoring check for all rules ...", new Object[0]);
            boolean bl = false;
        } else {
            Print.logDebug("Checking ruleID: " + string, new Object[0]);
            int n4 = eventRuleFactory.executeRule(account, string);
        }
        return n;
    }

    private static int _executeCronRules(Account account, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        OrderedSet<String> orderedSet;
        block7: {
            String string8 = account != null ? account.getAccountID() : "NONE";
            orderedSet = null;
            if (string8.equals("NONE") || StringTools.isBlank(string) || string.equals("NONE")) {
                orderedSet = null;
            } else {
                if (string.equals("ALL")) {
                    try {
                        orderedSet = Device.getDeviceIDsForAccount(string8, null, false);
                        if (ListTools.isEmpty(orderedSet)) {
                            return 0;
                        }
                        break block7;
                    }
                    catch (DBException dBException) {
                        Print.logException("Error loading device names for account: " + string8, dBException);
                        return 99;
                    }
                }
                orderedSet = new OrderedSet<String>(StringTools.split(string, ','));
                if (ListTools.isEmpty(orderedSet)) {
                    Print.logError("No Devices specified: " + string8, new Object[0]);
                    return 99;
                }
            }
        }
        return RuleCron._executeCronRules(account, orderedSet, string2, string3, string4, string5, string6, string7);
    }

    protected static int executeCronRules(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Account account = null;
        if (StringTools.isBlank(string) || string.equals("NONE")) {
            string = "NONE";
            string2 = "NONE";
        } else {
            try {
                account = Account.getAccount(string);
                if (account == null) {
                    Print.logError("Account-ID does not exist: " + string, new Object[0]);
                    return 1;
                }
                if (account.isSystemAdmin()) {
                    string2 = "NONE";
                }
            }
            catch (DBException dBException) {
                Print.logException("Error loading Account: " + string, dBException);
                return 99;
            }
        }
        return RuleCron._executeCronRules(account, string2, string3, string4, string5, string6, string7, string8);
    }

    public static int cron(String[] stringArray) {
        RTConfig.setCommandLineArgs(stringArray);
        Print.setLogLevel(6);
        Print.setLogHeaderLevel(6);
        if (RTConfig.getBoolean(ARG_NOEMAIL, false)) {
            SendMail.SetThreadModel("none");
        } else {
            SendMail.SetThreadModel("current");
        }
        String string = RTConfig.getString(ARG_ACCOUNT, "");
        String string2 = RTConfig.getString(ARG_DEVICE, "");
        String string3 = RTConfig.getString(ARG_RULE, null);
        String string4 = RTConfig.getString(ARG_TAG, null);
        String string5 = RTConfig.getString(ARG_SELECTOR, null);
        String string6 = RTConfig.getString(ARG_EMAIL_SUBJ, null);
        String string7 = RTConfig.getString(ARG_EMAIL_BODY, null);
        String string8 = RTConfig.getString(ARG_SMS_TEXT, null);
        if (!StringTools.isBlank(string3)) {
            Print.logDebug("RuleID: " + string3 + (!StringTools.isBlank(string4) ? " [" + string4 + "]" : ""), new Object[0]);
        }
        if (!StringTools.isBlank(string5)) {
            Print.logDebug("Selector: " + string5, new Object[0]);
        }
        if (StringTools.isBlank(string)) {
            Print.logWarn("Missing Account-ID specification", new Object[0]);
            return 1;
        }
        Collection<String> collection = null;
        if (string.equals("ALL")) {
            try {
                collection = Account.getAllAccounts();
            }
            catch (DBException dBException) {
                Print.logException("Error getting list of Accounts", dBException);
                return 99;
            }
            if (!string2.equals("NONE")) {
                string2 = "ALL";
            }
        } else {
            collection = ListTools.toList(StringTools.split(string, ','));
            string2 = StringTools.blankDefault(string2, "ALL");
        }
        int n = 0;
        if (!ListTools.isEmpty(collection)) {
            for (String string9 : collection) {
                Print.logInfo("=============================", new Object[0]);
                if (!StringTools.isBlank(string9)) {
                    Print.logInfo("Checking cron-rules for " + string9 + "/" + string2 + " [" + string3 + "]", new Object[0]);
                    int n2 = RuleCron.executeCronRules(string9, string2, string3, string4, string5, string6, string7, string8);
                    if (n2 == 0) continue;
                    n = n2;
                    continue;
                }
                Print.logWarn("Skipping blank account-ID specification", new Object[0]);
            }
        } else {
            String string10 = "NONE";
            string2 = "NONE";
            Print.logInfo("=============================", new Object[0]);
            Print.logInfo("Checking cron-rules for " + string10 + "/" + string2 + " [" + string3 + "]", new Object[0]);
            int n3 = RuleCron.executeCronRules(string10, string2, string3, string4, string5, string6, string7, string8);
            if (n3 != 0) {
                n = n3;
            }
        }
        return n;
    }

    private static void usage(int n) {
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  java ... " + RuleCron.class.getName() + " {options}", new Object[0]);
        Print.sysPrintln("Specific Device:", new Object[0]);
        Print.sysPrintln("  -account=<id>[,<id>]    Acount ID", new Object[0]);
        Print.sysPrintln("  -device=<id>            Device ID", new Object[0]);
        Print.sysPrintln("  -rule=<rule>            Rule ID", new Object[0]);
        Print.sysPrintln("All Devices in an Account:", new Object[0]);
        Print.sysPrintln("  -account=<id>           Account ID", new Object[0]);
        Print.sysPrintln("  -device=ALL             All devices", new Object[0]);
        Print.sysPrintln("  -rule=<rule>            Rule ID", new Object[0]);
        Print.sysPrintln("All Devices in ALL Accounts:", new Object[0]);
        Print.sysPrintln("  -account=ALL", new Object[0]);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit(stringArray, true);
        int n = RuleCron.cron(stringArray);
        if (n == 1) {
            RuleCron.usage(n);
        }
        System.exit(n);
    }
}

