/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule;

import java.util.Collection;
import java.util.List;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.PredefinedRuleAction;
import org.opengts.db.RuleFactoryAdapter;
import org.opengts.db.RuleParseException;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.RuleAction;
import org.opengts.rule.event.EventFunctionHandler;
import org.opengts.rule.event.EventIdentifierHandler;
import org.opengts.rule.event.EventSelector;
import org.opengts.rule.selector.FunctionHandler;
import org.opengts.rule.selector.IdentifierHandler;
import org.opengts.rule.selector.ParserException;
import org.opengts.rule.selector.Selector;
import org.opengts.rule.tables.GeoCorridor;
import org.opengts.rule.tables.Rule;
import org.opengts.rule.tables.RuleList;
import org.opengts.rule.tables.RuleTrigger;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class EventRuleFactory
extends RuleFactoryAdapter {
    private int _checkRuntime = -1;
    private boolean cronMode = false;
    private RuleAction ruleAction = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_CODE = new String[]{"code"};
    private static final String[] ARG_GP = new String[]{"gp", "pt"};
    private static final String[] ARG_EMAIL = new String[]{"email"};

    public EventRuleFactory(RuleAction ruleAction) {
        this(ruleAction, false);
    }

    public EventRuleFactory(RuleAction ruleAction, boolean bl) {
        this.ruleAction = ruleAction;
        this.setCronMode(bl);
        EventSelector.initSingleton();
    }

    @Override
    public String getName() {
        return "GTSRulesEngine";
    }

    @Override
    public String getVersion() {
        return EventSelector.getInstance()._getVersion();
    }

    public long getCompileTime() {
        return 1381279040L;
    }

    @Override
    public boolean checkRuntime() {
        if (this._checkRuntime < 0) {
            String string = this.getVersion();
            this._checkRuntime = !string.startsWith("*") ? 1 : 0;
        }
        return this._checkRuntime == 1;
    }

    public void setCronMode(boolean bl) {
        this.cronMode = bl;
        EventSelector.SetCronMode(bl);
    }

    public boolean getCronMode() {
        return this.cronMode;
    }

    @Override
    public PredefinedRuleAction[] getPredefinedRuleActions(BasicPrivateLabel basicPrivateLabel) {
        if (basicPrivateLabel == null) {
            return EventRuleAction.PredefinedRuleActionList;
        }
        PredefinedRuleAction[] predefinedRuleActionArray = basicPrivateLabel.getPredefinedRulesActions();
        return !ListTools.isEmpty(predefinedRuleActionArray) ? predefinedRuleActionArray : EventRuleAction.PredefinedRuleActionList;
    }

    @Override
    public List<String> getIdentifierNames() {
        return EventSelector.getInstance().getIdentifierNames();
    }

    @Override
    public String getIdentifierDescription(String string) {
        IdentifierHandler identifierHandler = EventSelector.getInstance().getIdentifier(string);
        return identifierHandler != null ? identifierHandler.getDescription() : null;
    }

    public int addIdentifier(EventIdentifierHandler eventIdentifierHandler) {
        return EventSelector.getInstance().addIdentifier(eventIdentifierHandler);
    }

    @Override
    public List<String> getFunctionNames() {
        return EventSelector.getInstance().getFunctionNames();
    }

    @Override
    public String getFunctionUsage(String string) {
        FunctionHandler functionHandler = EventSelector.getInstance().getFunction(string);
        return functionHandler != null ? functionHandler.getUsage() : null;
    }

    @Override
    public String getFunctionDescription(String string) {
        FunctionHandler functionHandler = EventSelector.getInstance().getFunction(string);
        return functionHandler != null ? functionHandler.getDescription() : null;
    }

    public int addFunction(EventFunctionHandler eventFunctionHandler) {
        return EventSelector.getInstance().addFunction(eventFunctionHandler);
    }

    @Override
    public boolean checkSelectorSyntax(String string) {
        return Rule.checkSelectorSyntax(string);
    }

    @Override
    public boolean isSelectorMatch(String string, EventData eventData) {
        if (eventData != null && !StringTools.isBlank(string)) {
            try {
                return Rule.isSelectorMatch(string, eventData);
            }
            catch (ParserException parserException) {
                Print.logWarn("Rule selector invalid: " + string, new Object[0]);
                Print.logWarn("Rule selector parser error: " + parserException, new Object[0]);
                return false;
            }
        }
        return false;
    }

    public boolean isSelectorMatch(String string, Device device) {
        if (device != null && !StringTools.isBlank(string)) {
            try {
                return Rule.isSelectorMatch(string, device);
            }
            catch (ParserException parserException) {
                Print.logWarn("Rule selector invalid: " + string, new Object[0]);
                Print.logWarn("Rule selector parser error: " + parserException, new Object[0]);
                return false;
            }
        }
        return false;
    }

    public boolean isSelectorMatch(String string, Account account) {
        if (account != null && !StringTools.isBlank(string)) {
            try {
                return Rule.isSelectorMatch(string, account);
            }
            catch (ParserException parserException) {
                Print.logWarn("Rule selector invalid: " + string, new Object[0]);
                Print.logWarn("Rule selector parser error: " + parserException, new Object[0]);
                return false;
            }
        }
        return false;
    }

    @Override
    public Object evaluateSelector(String string, EventData eventData) throws RuleParseException {
        if (eventData != null && !StringTools.isBlank(string)) {
            try {
                Selector.Result result = Rule.getSelectorResult(string, eventData);
                return result != null ? result.getValue() : null;
            }
            catch (ParserException parserException) {
                throw new RuleParseException(parserException.getMessage(), parserException);
            }
        }
        return null;
    }

    @Override
    public Object evaluateSelector(String string, Account account) throws RuleParseException {
        if (account != null && !StringTools.isBlank(string)) {
            try {
                Selector.Result result = Rule.getSelectorResult(string, account);
                return result != null ? result.getValue() : null;
            }
            catch (ParserException parserException) {
                throw new RuleParseException(parserException.getMessage(), parserException);
            }
        }
        return null;
    }

    public int executeSelector(Rule rule, EventData eventData) {
        if (rule == null) {
            Print.logError("Rule not specified", new Object[0]);
            return -1;
        }
        if (this.ruleAction == null) {
            Print.logDebug("No RuleAction for rule: " + rule.getSelector(), new Object[0]);
            return -1;
        }
        if (eventData == null) {
            Print.logDebug("EventData is null for rule: " + rule.getRuleID(), new Object[0]);
            return -1;
        }
        Account account = eventData.getAccount();
        Device device = eventData.getDevice();
        String string = rule.getSelector();
        if (this.isSelectorMatch(string, eventData)) {
            if (rule.elapsedMinimumNotifyAge(eventData)) {
                Print.logInfo("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + eventData.getAccountID() + "/" + eventData.getDeviceID() + "]: " + string + " [cron=" + rule.getIsCronRule() + ", action=0x" + StringTools.toHexString(rule.getActionMask(), 32) + "]" + "", new Object[0]);
                int n = this.ruleAction.performRuleAction(account, device, eventData, this.getCronMode(), string, rule);
                RuleTrigger.setRuleTriggerTime(device, rule, -1L);
                return n;
            }
            Print.logInfo("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + eventData.getAccountID() + "/" + eventData.getDeviceID() + "]: " + " skipping action due to previous trigger", new Object[0]);
            return -1;
        }
        RuleTrigger.clearRuleTriggerTime(device, rule);
        return -1;
    }

    @Override
    public int executeSelector(String string, EventData eventData) {
        if (this.ruleAction == null) {
            Print.logDebug("No RuleAction for rule selector: " + string, new Object[0]);
            return -1;
        }
        if (eventData == null) {
            Print.logDebug("EventData is null for rule selector: " + string, new Object[0]);
            return -1;
        }
        if (this.isSelectorMatch(string, eventData)) {
            Account account = eventData.getAccount();
            Device device = eventData.getDevice();
            Print.logInfo("Rule Selector ==> true [" + eventData.getAccountID() + "/" + eventData.getDeviceID() + "]: " + string, new Object[0]);
            int n = this.ruleAction.performRuleAction(account, device, eventData, this.getCronMode(), string, null);
            return n;
        }
        return -1;
    }

    public int executeSelector(Rule rule, Account account) {
        if (rule == null) {
            Print.logError("Rule not specified", new Object[0]);
            return -1;
        }
        if (this.ruleAction == null) {
            Print.logDebug("No RuleAction for rule: " + rule.getSelector(), new Object[0]);
            return -1;
        }
        if (account == null) {
            Print.logDebug("Account is null for rule: " + rule.getRuleID(), new Object[0]);
            return -1;
        }
        String string = rule.getSelector();
        if (this.isSelectorMatch(string, account)) {
            if (rule.elapsedMinimumNotifyAge(account)) {
                Print.logInfo("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true " + " [" + account.getAccountID() + "]: " + string + " [cron=" + rule.getIsCronRule() + ", action=0x" + StringTools.toHexString(rule.getActionMask(), 32) + "]" + "", new Object[0]);
                int n = this.ruleAction.performRuleAction(account, null, null, this.getCronMode(), string, rule);
                RuleTrigger.setRuleTriggerTime(account, rule, -1L);
                return n;
            }
            Print.logInfo("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + account.getAccountID() + "]: " + " skipping action due to previous trigger", new Object[0]);
            return -1;
        }
        RuleTrigger.clearRuleTriggerTime(account, rule);
        return -1;
    }

    public int executeSelector(String string, Account account) {
        if (this.ruleAction == null) {
            Print.logDebug("No RuleAction for rule selector: " + string, new Object[0]);
            return -1;
        }
        if (account == null) {
            Print.logDebug("Account is null for rule selector: " + string, new Object[0]);
            return -1;
        }
        if (this.isSelectorMatch(string, account)) {
            Print.logInfo("Rule Selector ==> true [" + account.getAccountID() + "]: " + string, new Object[0]);
            int n = this.ruleAction.performRuleAction(account, null, null, this.getCronMode(), string, null);
            return n;
        }
        return -1;
    }

    public int executeSelector(Rule rule, Device device) {
        if (rule == null) {
            Print.logError("Rule not specified", new Object[0]);
            return -1;
        }
        if (this.ruleAction == null) {
            Print.logDebug("No RuleAction for rule: " + rule.getSelector(), new Object[0]);
            return -1;
        }
        if (device == null) {
            Print.logDebug("Device is null for rule: " + rule.getRuleID(), new Object[0]);
            return -1;
        }
        Account account = device.getAccount();
        String string = rule.getSelector();
        if (this.isSelectorMatch(string, device)) {
            if (rule.elapsedMinimumNotifyAge(device)) {
                Print.logInfo("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + device.getAccountID() + "/" + device.getDeviceID() + "]: " + string + " [cron=" + rule.getIsCronRule() + ", action=0x" + StringTools.toHexString(rule.getActionMask(), 32) + "]" + "", new Object[0]);
                int n = this.ruleAction.performRuleAction(account, device, null, this.getCronMode(), string, rule);
                RuleTrigger.setRuleTriggerTime(device, rule, -1L);
                return n;
            }
            Print.logInfo("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + device.getAccountID() + "/" + device.getDeviceID() + "]: " + " skipping action due to previous trigger", new Object[0]);
            return -1;
        }
        RuleTrigger.clearRuleTriggerTime(device, rule);
        return -1;
    }

    public int executeSelector(String string, Device device) {
        if (this.ruleAction == null) {
            Print.logDebug("No RuleAction for rule selector: " + string, new Object[0]);
            return -1;
        }
        if (device == null) {
            Print.logDebug("Device is null for rule selector: " + string, new Object[0]);
            return -1;
        }
        if (this.isSelectorMatch(string, device)) {
            Account account = device.getAccount();
            Print.logInfo("Rule Selector ==> true [" + device.getAccountID() + "/" + device.getDeviceID() + "]: " + string, new Object[0]);
            int n = this.ruleAction.performRuleAction(account, device, null, this.getCronMode(), string, null);
            return n;
        }
        return -1;
    }

    @Override
    public String getRuleSelector(Account account, String string) {
        if (account == null) {
            return null;
        }
        if (StringTools.isBlank(string)) {
            return null;
        }
        try {
            String string2;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string2 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError("Rule not found: " + account.getAccountID() + "/" + string, new Object[0]);
                return null;
            }
            rule.setSystemRuleSettings();
            if (!rule.isActive()) {
                Print.logWarn("Rule not active: " + rule.getAccountID() + "/" + string, new Object[0]);
                return null;
            }
            return rule.getSelector();
        }
        catch (DBException dBException) {
            Print.logError("Returning Rule Selector: " + dBException, new Object[0]);
            return null;
        }
    }

    @Override
    public String[] getRuleIDs(Account account) {
        if (account == null) {
            return null;
        }
        try {
            Collection<String> collection = Rule.getRuleIDs(account.getAccountID(), false, true, false);
            return collection.toArray(new String[collection.size()]);
        }
        catch (DBException dBException) {
            Print.logError("Returning Rule IDs: " + dBException, new Object[0]);
            return null;
        }
    }

    @Override
    public String getRuleNotifyEmail(Account account, String string) {
        if (account == null) {
            return null;
        }
        if (StringTools.isBlank(string)) {
            return null;
        }
        try {
            String string2;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string2 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError("Rule not found: " + account.getAccountID() + "/" + string, new Object[0]);
                return null;
            }
            rule.setSystemRuleSettings();
            if (!rule.isActive()) {
                Print.logWarn("Rule not active: " + rule.getAccountID() + "/" + string, new Object[0]);
            }
            return rule.getNotifyEmail();
        }
        catch (DBException dBException) {
            Print.logError("Returning Rule Notify Email: " + dBException, new Object[0]);
            return null;
        }
    }

    public int executeRule(Account account, String string) {
        if (account == null) {
            return -1;
        }
        String string2 = account.getAccountID();
        if (StringTools.isBlank(string)) {
            return -1;
        }
        int n = 0;
        try {
            String string3;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string3 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError("Rule not found: " + string2 + "/" + string, new Object[0]);
                return -1;
            }
            rule.setSystemRuleSettings();
            string3 = rule.getAccountID();
            if (!rule.isActive()) {
                Print.logWarn("Rule not active: " + string3 + "/" + string, new Object[0]);
                return -1;
            }
            if (this.cronMode != rule.getIsCronRule()) {
                if (this.cronMode) {
                    Print.logError("[CronMode] Invalid NonCronMode rule specified: " + string3 + "/" + string, new Object[0]);
                } else {
                    Print.logError("[NonCronMode] Invalid CronMode rule specified: " + string3 + "/" + string, new Object[0]);
                }
                return -1;
            }
            if (!rule.hasSelector()) {
                Print.logError("Rule has no selector: " + string3 + "/" + string, new Object[0]);
                return -1;
            }
            int n2 = this.executeSelector(rule, account);
            if (n2 >= 0 && n2 != 0) {
                Print.logDebug("Rule Action: " + string + " ==> 0x" + StringTools.toHexString(n2, 32), new Object[0]);
                n |= n2;
            } else {
                Print.logDebug("Rule Action: " + string + " ==> (action ignored)", new Object[0]);
            }
            return n != 0 ? n : -1;
        }
        catch (DBException dBException) {
            Print.logError("Executing Rule: " + dBException, new Object[0]);
            return -1;
        }
    }

    public int executeRule(Device device, String string) {
        Account account;
        Account account2 = account = device != null ? device.getAccount() : null;
        if (account == null) {
            return -1;
        }
        String string2 = device.getAccountID();
        String string3 = device.getDeviceID();
        if (StringTools.isBlank(string)) {
            return -1;
        }
        int n = 0;
        try {
            String string4;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string4 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError("Rule not found: " + string2 + "/" + string, new Object[0]);
                return -1;
            }
            rule.setSystemRuleSettings();
            string4 = rule.getAccountID();
            if (!rule.isActive()) {
                Print.logWarn("Rule not active: " + string4 + "/" + string, new Object[0]);
                return -1;
            }
            if (this.cronMode != rule.getIsCronRule()) {
                if (this.cronMode) {
                    Print.logError("[CronMode] Invalid NonCronMode rule specified: " + string4 + "/" + string, new Object[0]);
                } else {
                    Print.logError("[NonCronMode] Invalid CronMode rule specified: " + string4 + "/" + string, new Object[0]);
                }
                return -1;
            }
            if (!rule.hasSelector()) {
                Print.logError("Rule has no selector: " + string4 + "/" + string, new Object[0]);
                return -1;
            }
            int n2 = this.executeSelector(rule, device);
            if (n2 >= 0 && n2 != 0) {
                Print.logDebug("Rule Action: " + string + " ==> 0x" + StringTools.toHexString(n2, 32), new Object[0]);
                n |= n2;
            } else {
                Print.logDebug("Rule Action: " + string + " ==> (action ignored)", new Object[0]);
            }
            return n != 0 ? n : -1;
        }
        catch (DBException dBException) {
            Print.logError("Executing Rule: " + dBException, new Object[0]);
            return -1;
        }
    }

    public int executeRule(EventData eventData, String string) {
        if (eventData == null) {
            return -1;
        }
        if (StringTools.isBlank(string)) {
            return -1;
        }
        String string2 = eventData.getAccountID();
        Account account = eventData.getAccount();
        Device device = eventData.getDevice();
        if (account == null || device == null) {
            Print.logError("EventData Account/Device not found: " + string2 + "/" + eventData.getDeviceID(), new Object[0]);
            return -1;
        }
        int n = 0;
        try {
            String string3;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string3 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError("Rule not found: " + string2 + "/" + string, new Object[0]);
                return -1;
            }
            rule.setSystemRuleSettings();
            string3 = rule.getAccountID();
            if (!rule.isActive()) {
                Print.logWarn("Rule not active: " + string3 + "/" + string, new Object[0]);
                return -1;
            }
            if (this.cronMode != rule.getIsCronRule()) {
                if (this.cronMode) {
                    Print.logError("[CronMode] Invalid NonCronMode rule specified: " + string3 + "/" + string, new Object[0]);
                } else {
                    Print.logError("[NonCronMode] Invalid CronMode rule specified: " + string3 + "/" + string, new Object[0]);
                }
                return -1;
            }
            if (!rule.hasSelector()) {
                Print.logError("Rule has no selector: " + string3 + "/" + string, new Object[0]);
                return -1;
            }
            int n2 = this.executeSelector(rule, eventData);
            if (n2 >= 0 && n2 != 0) {
                Print.logDebug("Rule Action: " + string + " ==> 0x" + StringTools.toHexString(n2, 32), new Object[0]);
                n |= n2;
            } else {
                Print.logDebug("Rule Action: " + string + " ==> (action ignored)", new Object[0]);
            }
            return n != 0 ? n : -1;
        }
        catch (DBException dBException) {
            Print.logError("Executing Rule: " + dBException, new Object[0]);
            return -1;
        }
    }

    public int executeRules(Account account) {
        return this.executeRules(account, null);
    }

    public int executeRules(Account account, String string) {
        if (!this.getCronMode()) {
            return -1;
        }
        if (account == null) {
            return -1;
        }
        String string2 = account.getAccountID();
        int n = 0;
        int n2 = 0;
        boolean bl = !StringTools.isBlank(string);
        try {
            Collection<String> collection = Rule.getAllRuleIDs(string2, true);
            if (ListTools.isEmpty(collection)) {
                return -1;
            }
            for (String string3 : collection) {
                Rule rule = Rule.getRule(account, string3);
                if (rule == null) {
                    Print.logDebug("Account] Rule not found: " + string2 + "/" + string3, new Object[0]);
                    continue;
                }
                rule.setSystemRuleSettings();
                if (!rule.isActive() || !rule.getIsCronRule() || bl && !string.equalsIgnoreCase(rule.getRuleTag())) continue;
                Print.logDebug("Account] Checking rule: " + string2 + "/" + string3 + " [tag '" + string + "']", new Object[0]);
                if (!rule.hasSelector()) continue;
                int n3 = this.executeSelector(rule, account);
                if (n3 >= 0 && n3 != 0) {
                    Print.logDebug("Rule Action: " + string3 + " ==> 0x" + StringTools.toHexString(n3, 32), new Object[0]);
                    n2 |= n3;
                    ++n;
                    continue;
                }
                Print.logDebug("Rule Action: " + string3 + " ==> (action ignored)", new Object[0]);
            }
        }
        catch (DBException dBException) {
            Print.logError("Executing Account 'Cron' Rules: " + dBException, new Object[0]);
        }
        return n > 0 ? n2 : -1;
    }

    public int executeRule(String string, Account account) {
        return -1;
    }

    public int executeRules(Device device) {
        return this.executeRules(device, null);
    }

    public int executeRules(Device device, String string) {
        if (!this.getCronMode()) {
            return -1;
        }
        if (device == null) {
            return -1;
        }
        Account account = device.getAccount();
        String string2 = device.getAccountID();
        String string3 = device.getDeviceID();
        int n = 0;
        int n2 = 0;
        boolean bl = !StringTools.isBlank(string);
        try {
            Collection<String> collection = Rule.getAllRuleIDs(string2, true);
            if (ListTools.isEmpty(collection)) {
                return -1;
            }
            for (String string4 : collection) {
                Rule rule = Rule.getRule(account, string4);
                if (rule == null) {
                    Print.logDebug("Device] Rule not found: " + string2 + "/" + string4, new Object[0]);
                    continue;
                }
                rule.setSystemRuleSettings();
                if (!rule.isActive() || !rule.getIsCronRule() || bl && !string.equalsIgnoreCase(rule.getRuleTag())) continue;
                Print.logDebug("Device] Checking rule: " + string2 + "/" + string4 + " [tag '" + string + "']: " + string3, new Object[0]);
                if (!rule.hasSelector()) {
                    Print.logDebug("Rule has no selector: " + string2 + "/" + string4, new Object[0]);
                    continue;
                }
                int n3 = this.executeSelector(rule, device);
                if (n3 >= 0 && n3 != 0) {
                    Print.logDebug("Rule Action: " + string4 + " ==> 0x" + StringTools.toHexString(n3, 32), new Object[0]);
                    n2 |= n3;
                    ++n;
                    continue;
                }
                Print.logDebug("Rule Action: " + string4 + " ==> (action ignored)", new Object[0]);
            }
        }
        catch (DBException dBException) {
            Print.logError("Executing Device Rules: " + dBException, new Object[0]);
        }
        return n > 0 ? n2 : -1;
    }

    public int executeRule(String string, Device device) {
        return -1;
    }

    @Override
    public int executeRules(EventData eventData) {
        return this.executeRules(eventData, null);
    }

    public int executeRules(EventData eventData, String string) {
        if (eventData == null) {
            return -1;
        }
        String string2 = eventData.getAccountID();
        Device device = eventData.getDevice();
        if (device == null) {
            Print.logError("EventData Device not found: " + string2 + "/" + eventData.getDeviceID(), new Object[0]);
            return -1;
        }
        String string3 = device.getDeviceID();
        int n = 0;
        int n2 = 0;
        boolean bl = !StringTools.isBlank(string);
        try {
            Collection<String> collection = RuleList.getRulesForDevice(device, eventData.getStatusCode());
            if (!ListTools.isEmpty(collection)) {
                Account account = eventData.getAccount();
                for (String string4 : collection) {
                    Rule rule = Rule.getRule(account, string4);
                    if (rule == null) {
                        Print.logDebug("Event] Rule not found: " + string2 + "/" + string4, new Object[0]);
                        continue;
                    }
                    rule.setSystemRuleSettings();
                    if (!rule.isActive() || this.cronMode && !rule.getIsCronRule() || !this.cronMode && rule.getIsCronRule() || bl && !string.equalsIgnoreCase(rule.getRuleTag())) continue;
                    Print.logDebug("Event] Checking rule: " + string2 + "/" + string4 + " [tag '" + string + "']: " + string3, new Object[0]);
                    if (!rule.hasSelector()) {
                        Print.logDebug("Rule has no selector: " + string2 + "/" + string4, new Object[0]);
                        continue;
                    }
                    int n3 = this.executeSelector(rule, eventData);
                    if (n3 >= 0 && n3 != 0) {
                        Print.logDebug("Rule Action: " + string4 + " ==> 0x" + StringTools.toHexString(n3, 32), new Object[0]);
                        n2 |= n3;
                        ++n;
                        continue;
                    }
                    Print.logDebug("Rule Action: " + string4 + " ==> (action ignored)", new Object[0]);
                }
            }
            return n > 0 ? n2 : -1;
        }
        catch (DBException dBException) {
            Print.logError("Executing EventData Rules: " + dBException, new Object[0]);
            return n > 0 ? n2 : -1;
        }
    }

    @Override
    public int executeRule(String string, EventData eventData) {
        if (eventData == null) {
            return -1;
        }
        String string2 = eventData.getAccountID();
        Account account = eventData.getAccount();
        Device device = eventData.getDevice();
        int n = 0;
        int n2 = 0;
        try {
            Rule rule = Rule.getRule(account, string);
            if (rule == null) {
                Print.logWarn("Rule not found: " + string2 + "/" + string, new Object[0]);
                return -1;
            }
            rule.setSystemRuleSettings();
            if (!rule.isActive()) {
                Print.logWarn("Rule not active: " + string2 + "/" + string, new Object[0]);
                return -1;
            }
            if (this.cronMode && !rule.getIsCronRule()) {
                Print.logInfo("Skipping non-CronMode rule: " + string2 + "/" + string, new Object[0]);
                return -1;
            }
            if (!this.cronMode && rule.getIsCronRule()) {
                Print.logInfo("Skipping CronMode rule: " + string2 + "/" + string, new Object[0]);
                return -1;
            }
            if (!rule.hasSelector()) {
                Print.logWarn("Rule has no selector: " + string2 + "/" + string, new Object[0]);
                return -1;
            }
            int n3 = this.executeSelector(rule, eventData);
            if (n3 >= 0 && n3 != 0) {
                Print.logDebug("Rule Action: " + string + " ==> 0x" + StringTools.toHexString(n3, 32), new Object[0]);
                n2 |= n3;
                ++n;
            } else {
                Print.logDebug("Rule Action: " + string + " ==> (action ignored)", new Object[0]);
            }
            return n > 0 ? n2 : -1;
        }
        catch (DBException dBException) {
            Print.logError("Executing EventData Rule: " + dBException, new Object[0]);
            return n > 0 ? n2 : -1;
        }
    }

    @Override
    public String getGeoCorridorDescription(Account account, String string) {
        try {
            GeoCorridor geoCorridor = GeoCorridor.getGeoCorridor(account, string);
            return geoCorridor != null ? geoCorridor.getDescription() : "";
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit(stringArray, true);
        SendMail.SetThreadModel("current");
        EventRuleAction.DebugSetSendNotification(RTConfig.getBoolean(ARG_EMAIL, false));
        String string = RTConfig.getString(ARG_ACCOUNT, "demo");
        String string2 = RTConfig.getString(ARG_DEVICE, "demo");
        int n = RTConfig.getInt(ARG_CODE, 61968);
        GeoPoint geoPoint = new GeoPoint(RTConfig.getString(ARG_GP, "35.12345/-142.12345"));
        Print.sysPrintln("Account : " + string, new Object[0]);
        Print.sysPrintln("Device  : " + string2, new Object[0]);
        Print.sysPrintln("Code    : " + StatusCodes.GetHex(n) + " - " + StatusCodes.GetName(n, null), new Object[0]);
        Print.sysPrintln("GeoPoint: " + geoPoint, new Object[0]);
        Geozone geozone = Geozone.getGeozone(string, null, geoPoint, true);
        EventData.Key key = new EventData.Key(string, string2, DateTime.getCurrentTimeSec(), n);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setAddress(geozone != null ? geozone.getDescription() : "");
        eventData.setGeozoneID(geozone != null ? geozone.getGeozoneID() : "");
        eventData.setGeoPoint(geoPoint);
        eventData.setSpeedKPH(45.0);
        eventData.setHeading(123.0);
        eventData.setAltitude(457.0);
        eventData.setOdometerKM(123456.0);
        eventData.setDistanceKM(3456.0);
        EventRuleFactory eventRuleFactory = new EventRuleFactory(new EventRuleAction());
        int n2 = eventRuleFactory.executeRules(eventData);
        if (n2 < 0) {
            Print.sysPrintln("ExecuteRules: none", new Object[0]);
        } else {
            Print.sysPrintln("ExecuteRules: 0x" + StringTools.toHexString(n2, 32), new Object[0]);
        }
    }
}

