/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.Audit;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.PredefinedRuleAction;
import org.opengts.db.RuleFactoryAdapter;
import org.opengts.db.SMSOutboundGateway;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtypes.DTOBDFault;
import org.opengts.rule.PredefinedActionListener;
import org.opengts.rule.RuleAction;
import org.opengts.rule.RuleListener;
import org.opengts.rule.tables.NotifyQueue;
import org.opengts.rule.tables.Rule;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadPool;

public class EventRuleAction
implements RuleAction {
    public static final int DEFAULT_PRIORITY = 1;
    public static final String[] PROP_emailSubj;
    public static final String[] PROP_emailBody;
    public static final String[] PROP_smsText;
    private static final String[] KEY_SUBJECT;
    private static final String[] KEY_MESSAGE;
    private static final String[] KEY_SMSTEXT;
    private static final String[] KEY_PRIOR_GEOZONE;
    private static final String[] KEY_PRIOR_ADDRESS;
    private static final String[] KEY_MAP_URL;
    private static final String[] KEY_REPORT_URL;
    public static final String[] CRA_resetMaint;
    public static final String[] CRA_resetReminder;
    public static final String[] CRA_save;
    public static final String[] CRA_setCorridor;
    public static final String[] CRA_clearCorridor;
    public static final String[] CRA_sendCommand;
    public static final String[] CRA_clearEMail;
    public static final String[] CRA_addEvent;
    public static final String[] CRA_sendMQ;
    public static final String[] CRA_emailReport;
    public static final String[] CRA_resetCommands;
    public static final String[] CRA_park;
    public static final String[] CRA_unpark;
    public static final String[] CRA_setvar;
    public static final PredefinedRuleAction[] PredefinedRuleActionList;
    private static boolean SEND_NOTIFICATION;
    private static List<RuleListener> RuleListenerList;
    private static PredefinedActionListener CustomCRAListener;
    private static final RTKey PROP_ThreadPool_EventRuleAction_;
    private static ThreadPool ThreadPool_EventRuleAction;
    private int dftActionMask = 263;
    private long notifyDelayMS = 0L;

    public static String GetActionMaskDescription(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((long)(n & 0x100) != 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("EMail(");
            int n2 = 0;
            if ((long)(n & 1) != 0L) {
                if (n2++ > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("Account");
            }
            if ((long)(n & 2) != 0L) {
                if (n2++ > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("Device");
            }
            if ((long)(n & 4) != 0L) {
                if (n2++ > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("Rule");
            }
            stringBuffer.append(")");
        }
        if ((long)(n & 0x200) != 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("Queue");
        }
        if ((long)(n & 0x400) != 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("Listener");
        }
        if ((long)(n & 0x10000) != 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("SaveLast");
        }
        if (stringBuffer.length() == 0) {
            if (n == 0) {
                stringBuffer.append("None");
            } else {
                stringBuffer.append("?0x").append(StringTools.toHexString(n, 24));
            }
        }
        return stringBuffer.toString();
    }

    public static boolean CRAMatch(String[] stringArray, String string) {
        return ListTools.containsIgnoreCase(stringArray, string);
    }

    public static void DebugSetSendNotification(boolean bl) {
        SEND_NOTIFICATION = bl;
    }

    public static RuleListener getRuleListenerByName(String string) {
        if (RuleListenerList == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        for (RuleListener ruleListener : RuleListenerList) {
            String string2;
            try {
                MethodAction methodAction = new MethodAction((Object)ruleListener, "getName");
                string2 = StringTools.trim(methodAction.invoke());
            }
            catch (Throwable throwable) {
                string2 = ruleListener.toString();
            }
            if (!string.equalsIgnoreCase(string2)) continue;
            return ruleListener;
        }
        return null;
    }

    public static boolean hasRuleListener(String string) {
        RuleListener ruleListener = EventRuleAction.getRuleListenerByName(string);
        return ruleListener != null;
    }

    public static void addRuleListener(RuleListener ruleListener) {
        if (ruleListener != null) {
            if (RuleListenerList == null) {
                RuleListenerList = new Vector<RuleListener>();
            }
            RuleListenerList.add(ruleListener);
        }
    }

    private static void fireRuleListeners(Account account, Device device, EventData eventData, boolean bl, String string, Rule rule) {
        if (RuleListenerList != null) {
            Device device2;
            EventData eventData2 = eventData;
            Device device3 = device != null ? device : (device2 = eventData2 != null ? eventData2.getDevice() : null);
            Account account2 = account != null ? account : (eventData2 != null ? eventData2.getAccount() : (device2 != null ? device2.getAccount() : null));
            Rule rule2 = rule;
            String string2 = StringTools.trim(rule2 != null ? rule2.getSelector() : string);
            for (RuleListener ruleListener : RuleListenerList) {
                ruleListener.handleRuleNotification(account2, device2, eventData2, bl, string2, rule2);
            }
        }
    }

    public EventRuleAction() {
        this(263);
    }

    public EventRuleAction(int n) {
        this.dftActionMask = RuleFactoryAdapter.ValidateActionMask(n);
        this.notifyDelayMS = RTConfig.getLong("rule.waitForEventAddressMS", 0L);
        if (this.notifyDelayMS > 0L) {
            // empty if block
        }
    }

    private static Account GetAccount(Account account, Device device, EventData eventData) {
        if (account != null) {
            return account;
        }
        if (eventData != null) {
            return eventData.getAccount();
        }
        if (device != null) {
            return device.getAccount();
        }
        return null;
    }

    private static Device GetDevice(Device device, EventData eventData) {
        if (device != null) {
            return device;
        }
        if (eventData != null) {
            return eventData.getDevice();
        }
        return null;
    }

    @Override
    public int performRuleAction(Account account, Device device, EventData eventData, boolean bl, String string, Rule rule) {
        Account account2 = EventRuleAction.GetAccount(account, device, eventData);
        Device device2 = EventRuleAction.GetDevice(device, eventData);
        int n = -1;
        n = rule != null ? rule.getActionMask() : (device2 != null ? device2.getNotifyAction() : -1);
        if (n < 0 || n == 0) {
            if (this.dftActionMask < 0 || this.dftActionMask == 0) {
                return -1;
            }
            n = this.dftActionMask;
        }
        n = RuleFactoryAdapter.ValidateActionMask(n);
        int n2 = -1;
        n2 = rule != null ? rule.getPriority() : (device2 != null ? device2.getNotifyPriority() : -1);
        if (n2 <= 0) {
            n2 = 1;
        }
        if (eventData != null && !eventData.hasAddress() && this.notifyDelayMS > 0L) {
            final Account account3 = account2;
            final Device device3 = device2;
            final EventData eventData2 = eventData;
            final boolean bl2 = bl;
            final int n3 = n;
            final int n4 = n2;
            final String string2 = string;
            final Rule rule2 = rule;
            final long l = DateTime.getCurrentTimeMillis() + this.notifyDelayMS;
            ThreadPool_EventRuleAction.run(new Runnable(){

                @Override
                public void run() {
                    long l3 = DateTime.getCurrentTimeMillis();
                    if (l3 < l) {
                        long l2 = l - l3;
                        Print.logInfo("Waiting for EventData address: " + l2 + " ms", new Object[0]);
                        if (l2 > 0L) {
                            OSTools.sleepMS(l2);
                        }
                    }
                    Print.logInfo("Updating EventData address ...", new Object[0]);
                    eventData2.reloadAddress();
                    Print.logInfo("... Updated EventData address: " + eventData2.getAddress(), new Object[0]);
                    boolean bl = EventRuleAction._sendNotification(true, account3, device3, eventData2, bl2, n3, n4, string2, rule2);
                }
            });
        } else {
            boolean bl3 = EventRuleAction._sendNotification(false, account2, device2, eventData, bl, n, n2, string, rule);
        }
        return n;
    }

    protected static String _getNotificationRecipients(Account account, Device device, Rule rule, int n) {
        Object object;
        HashSet hashSet = new HashSet();
        if (account != null && (n & 1) != 0 && !ListTools.isEmpty(object = StringTools.split(account.getNotifyEmail(), ','))) {
            ListTools.toSet(hashSet, object);
        }
        if (device != null && (n & 2) != 0 && !ListTools.isEmpty(object = StringTools.split(device.getNotifyEmail(false, true), ','))) {
            ListTools.toSet(hashSet, object);
        }
        if (rule != null && (n & 4) != 0 && !ListTools.isEmpty(object = StringTools.split(rule.getNotifyEmail(), ','))) {
            ListTools.toSet(hashSet, object);
        }
        if (ListTools.isEmpty(hashSet)) {
            return null;
        }
        object = new StringBuffer();
        for (String string : hashSet) {
            if (StringTools.isBlank(string)) continue;
            if (((StringBuffer)object).length() > 0) {
                ((StringBuffer)object).append(",");
            }
            ((StringBuffer)object).append(string);
        }
        return ((StringBuffer)object).toString();
    }

    protected static String _getNotificationSender(Account account, Rule rule, int n) {
        BasicPrivateLabel basicPrivateLabel;
        BasicPrivateLabel basicPrivateLabel2 = basicPrivateLabel = account != null ? account.getPrivateLabel() : null;
        if (basicPrivateLabel != null) {
            String string = basicPrivateLabel.getEventNotificationFrom();
            if (!SendMail.IsBlankEmailAddress(string)) {
                return string;
            }
            string = basicPrivateLabel.getEMailAddress("notify");
            if (!SendMail.IsBlankEmailAddress(string)) {
                return string;
            }
            string = basicPrivateLabel.getSmtpProperties().getUserEmail();
            if (!SendMail.IsBlankEmailAddress(string)) {
                return string;
            }
        }
        return SendMail.getDefaultUserEmail(null);
    }

    protected static String[] _getNotificationMessage(Account account, Device device, EventData eventData, Rule rule, int n) {
        String string;
        String string2;
        Object object;
        BasicPrivateLabel basicPrivateLabel;
        Account account2 = EventRuleAction.GetAccount(account, device, eventData);
        Device device2 = EventRuleAction.GetDevice(device, eventData);
        BasicPrivateLabel basicPrivateLabel2 = basicPrivateLabel = account2 != null ? account2.getPrivateLabel() : null;
        if (basicPrivateLabel == null) {
            Print.logWarn("No PrivateLabel found for Account", new Object[0]);
        }
        boolean bl = basicPrivateLabel != null && basicPrivateLabel.hasEventNotificationEMail();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (rule != null) {
            object = rule.getEmailSubject();
            string3 = !StringTools.isBlank((String)object) ? object : rule.getDescription();
            string2 = rule.getEmailText();
            string4 = !StringTools.isBlank(string2) ? string2 : rule.getDescription();
            bl = bl && rule.getUseEmailWrapper();
            string = rule.getDefaultSmsText(false);
            string5 = !StringTools.isBlank(string) ? string : null;
        } else if (device2 != null) {
            object = device2.getNotifySubject();
            string3 = !StringTools.isBlank((String)object) ? object : device2.getNotifyDescription();
            string2 = device2.getNotifyText();
            string4 = !StringTools.isBlank(string2) ? string2 : device2.getNotifyDescription();
            bl = bl && device2.getNotifyUseWrapper();
            string = Rule.CreateDefaultSmsText((String)object, string2, null);
            string5 = !StringTools.isBlank(string) ? string : null;
        } else {
            string3 = null;
            string4 = null;
            string5 = null;
        }
        if (eventData != null && eventData.hasTemporaryProperties()) {
            object = eventData.getTemporaryProperties();
            if (StringTools.isBlank(string3) && StringTools.isBlank(string4)) {
                string3 = ((RTProperties)object).getString(PROP_emailSubj, string3);
                string4 = ((RTProperties)object).getString(PROP_emailBody, string4);
            }
            if (StringTools.isBlank(string5)) {
                string5 = ((RTProperties)object).getString(PROP_smsText, string5);
            }
        }
        if (device2 != null && device2.hasTemporaryProperties()) {
            object = device2.getTemporaryProperties();
            if (StringTools.isBlank(string3) && StringTools.isBlank(string4)) {
                string3 = ((RTProperties)object).getString(PROP_emailSubj, string3);
                string4 = ((RTProperties)object).getString(PROP_emailBody, string4);
            }
            if (StringTools.isBlank(string5)) {
                string5 = ((RTProperties)object).getString(PROP_smsText, string5);
            }
        }
        if (account2 != null && account2.hasTemporaryProperties()) {
            object = account2.getTemporaryProperties();
            if (StringTools.isBlank(string3) && StringTools.isBlank(string4)) {
                string3 = ((RTProperties)object).getString(PROP_emailSubj, string3);
                string4 = ((RTProperties)object).getString(PROP_emailBody, string4);
            }
            if (StringTools.isBlank(string5)) {
                string5 = ((RTProperties)object).getString(PROP_smsText, string5);
            }
        }
        object = null;
        string2 = null;
        string = null;
        if (bl) {
            if (basicPrivateLabel != null) {
                object = basicPrivateLabel.getEventNotificationSubject();
                string2 = basicPrivateLabel.getEventNotificationBody();
                string = null;
            }
            if (StringTools.isBlank((String)object)) {
                object = "Vehicle ${device}: ${subject}";
            }
            if (StringTools.isBlank(string2)) {
                string2 = "Account   : [${accountid}] ${account}\nVehicle   : [${deviceid}] ${device}\nDate/Time : ${datetime}\nStatus    : [${statuscode}] ${status}\nLocation  : ${geopoint}\nSpeed     : ${speed}  ${direction}\nAltitude  : ${altitude}\nOdometer  : ${odometer}\n\n";
            }
            if (StringTools.isBlank(string)) {
                string = "";
            }
        } else {
            object = "${" + KEY_SUBJECT[0] + "}";
            string2 = "${" + KEY_MESSAGE[0] + "}";
            string = "${" + KEY_SMSTEXT[0] + "}";
        }
        Locale locale = basicPrivateLabel != null ? basicPrivateLabel.getLocale() : null;
        EventDataText eventDataText = new EventDataText(account2, device2, eventData, string3, string4, string5, basicPrivateLabel);
        String string6 = eventDataText.toString((String)object);
        String string7 = eventDataText.toString(string2);
        String string8 = eventDataText.toString(string);
        return new String[]{string6, string7, string8};
    }

    protected static boolean _sendNotification(boolean bl, Account account, Device device, EventData eventData, boolean bl2, int n, int n2, String string, Rule rule) {
        int n3;
        Object object2;
        CharSequence charSequence;
        String string222;
        Object object3;
        SendMail.SmtpProperties smtpProperties;
        Account account2 = EventRuleAction.GetAccount(account, device, eventData);
        Device device2 = EventRuleAction.GetDevice(device, eventData);
        if (account2 == null && device2 != null && (account2 = device2.getAccount()) == null) {
            Print.logError("*** Device does not have a valid Account: " + device2.getDeviceID(), new Object[0]);
            device2 = null;
        }
        String string3 = account2 != null ? account2.getAccountID() : "?";
        String string4 = device2 != null ? device2.getDeviceID() : "?";
        BasicPrivateLabel basicPrivateLabel = account2 != null ? account2.getPrivateLabel() : null;
        SendMail.SmtpProperties smtpProperties2 = smtpProperties = basicPrivateLabel != null ? basicPrivateLabel.getSmtpProperties() : null;
        if (rule != null && account2 != null && !rule.hasAccount() && rule.getAccountID().equals(string3)) {
            rule.setAccount(account2);
        }
        String string5 = "";
        String string6 = StringTools.trim(EventRuleAction._getNotificationRecipients(account2, device2, rule, n));
        if (!StringTools.isBlank(string6)) {
            for (String string222 : object3 = StringTools.parseStringArray(string6, ',')) {
                if (!SMSOutboundGateway.StartsWithSMS(string222)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                charSequence = new StringBuffer();
                object2 = object3;
                int n4 = ((String[])object2).length;
                for (n3 = 0; n3 < n4; ++n3) {
                    String object4 = object2[n3];
                    if (StringTools.isBlank(object4)) continue;
                    if (SMSOutboundGateway.StartsWithSMS(object4)) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(object4.substring("SMS:".length()));
                        continue;
                    }
                    if (((StringBuffer)charSequence).length() > 0) {
                        ((StringBuffer)charSequence).append(",");
                    }
                    ((StringBuffer)charSequence).append(object4);
                }
                string5 = stringBuffer.toString();
                string6 = ((StringBuffer)charSequence).toString();
                break;
            }
        }
        object3 = StringTools.trim(EventRuleAction._getNotificationSender(account2, rule, n));
        String[] stringArray = EventRuleAction._getNotificationMessage(account2, device2, eventData, rule, n);
        String string7 = stringArray[0];
        String string8 = stringArray[1];
        string222 = stringArray[2];
        if ((n & 0x200) != 0 || (n & 0x100) != 0) {
            Print.logInfo("From: " + (String)object3, new Object[0]);
            Print.logInfo("To (email): " + string6, new Object[0]);
            Print.logInfo("To (SMS)  : " + string5, new Object[0]);
            Print.logInfo("Subject   : " + string7, new Object[0]);
            Print.logInfo("Body      :\n" + string8, new Object[0]);
            if (!StringTools.isBlank(string222)) {
                Print.logInfo("SMS       : " + string222, new Object[0]);
            }
        }
        if (!SEND_NOTIFICATION) {
            Print.logWarn("Notification disabled ...", new Object[0]);
            return true;
        }
        boolean bl3 = true;
        if ((n & 0x100) != 0) {
            if (StringTools.isBlank(string6) && StringTools.isBlank(string5)) {
                Print.logWarn("EMail requested, but no recipients specified", new Object[0]);
                bl3 = false;
            } else {
                if (!StringTools.isBlank(string6)) {
                    if (StringTools.isBlank((String)object3)) {
                        Print.logStackTrace("Cannot determine 'From' email address!!!");
                        bl3 = false;
                    } else {
                        try {
                            Print.logInfo("Sending rule notification email ...", new Object[0]);
                            SendMail.send((String)object3, string6, null, null, string7, string8, null, smtpProperties);
                            Audit.ruleNotification(string3, string4, string6, string7, string8);
                        }
                        catch (Throwable throwable) {
                            Print.logWarn("SendMail error: " + throwable, new Object[0]);
                            bl3 = false;
                        }
                    }
                }
                if (!StringTools.isBlank(string5)) {
                    if (account2 != null && account2.getSmsEnabled()) {
                        SMSOutboundGateway sMSOutboundGateway;
                        charSequence = Rule.CreateDefaultSmsText(string7, string8, string222);
                        if (((String)charSequence).length() > SMSOutboundGateway.getMaximumTextMessageLength()) {
                            charSequence = ((String)charSequence).substring(0, SMSOutboundGateway.getMaximumTextMessageLength()).trim();
                        }
                        if ((sMSOutboundGateway = SMSOutboundGateway.GetSMSGateway((String)(object2 = SMSOutboundGateway.GetDefaultGatewayName()))) != null) {
                            String[] stringArray2;
                            Print.logInfo("Sending SMS via gateway: " + (String)object2, new Object[0]);
                            for (String string2 : stringArray2 = StringTools.split(string5, ',')) {
                                if (SMSOutboundGateway.StartsWithSMS(string2)) {
                                    string2 = string2.substring("SMS:".length());
                                }
                                if (StringTools.isBlank(string2)) continue;
                                Print.logInfo("SMS: " + string2 + " --> " + (String)charSequence, new Object[0]);
                                DCServerFactory.ResultCode resultCode = sMSOutboundGateway.sendSMSMessage(account2, (String)charSequence, string2);
                                if (resultCode.isSuccess()) continue;
                                Print.logWarn("SMS error: " + resultCode, new Object[0]);
                                bl3 = false;
                            }
                        } else {
                            Print.logWarn("SMS Gateway not found: " + (String)object2, new Object[0]);
                        }
                    } else {
                        Print.logWarn("SMS notification disabled for account: " + string3, new Object[0]);
                    }
                }
            }
        }
        if ((n & 0x200) != 0) {
            try {
                charSequence = rule != null ? rule.getRuleID() : null;
                long l = eventData != null ? eventData.getTimestamp() : 0L;
                n3 = eventData != null ? eventData.getStatusCode() : 0;
                NotifyQueue.Key key = new NotifyQueue.Key(string3, string4, (String)charSequence, l, n3);
                NotifyQueue notifyQueue = (NotifyQueue)key.getDBRecord();
                notifyQueue.setAccount(account2);
                notifyQueue.setDevice(device2);
                notifyQueue.setRule(rule);
                notifyQueue.setPriority(n2);
                notifyQueue.setSender((String)object3);
                notifyQueue.setRecipients(string6);
                notifyQueue.setSubject(string7);
                notifyQueue.setMessage(string8);
                notifyQueue.save();
            }
            catch (DBException dBException) {
                Print.logException("NotifyQueue error", dBException);
                bl3 = false;
            }
        }
        if ((n & 0x400) != 0) {
            EventRuleAction.fireRuleListeners(account2, device2, eventData, bl2, string, rule);
        }
        if ((n & 0x10000) != 0 && device2 != null) {
            try {
                String string10;
                boolean bl4 = bl;
                String string9 = string10 = rule != null ? rule.getRuleID() : "";
                if (eventData != null) {
                    device2.setLastNotifyEvent(eventData, string10, bl4);
                } else {
                    device2.setLastNotifyEvent(DateTime.getCurrentTimeSec(), string10, bl4);
                }
            }
            catch (DBException dBException) {
                Print.logError("CRA: Unable to save Device notify time/code - " + dBException, new Object[0]);
            }
        }
        if (rule != null && rule.hasCannedActions()) {
            String[] stringArray3;
            for (String string10 : stringArray3 = StringTools.parseStringArray(rule.getCannedActions(), ";|")) {
                Object object;
                boolean bl4;
                String string2;
                String[] stringArray2 = StringTools.parseStringArray(string10, ":,");
                if (ListTools.size(stringArray2) <= 0) continue;
                String string11 = stringArray2[0];
                if (StringTools.isBlank(string11)) {
                    Print.logWarn("CRA: Blank command: " + string10, new Object[0]);
                    continue;
                }
                string2 = stringArray2.length > 1 ? stringArray2[1] : "";
                char c = string11.charAt(0);
                if (c == '%' || c == '@') continue;
                if (!Character.isLetter(c)) {
                    Print.logWarn("CRA: Invalid command: " + string10, new Object[0]);
                    continue;
                }
                if (CustomCRAListener != null && (bl4 = CustomCRAListener.handlePredefinedAction(rule, string11, string2, account2, device2, eventData))) {
                    String string12 = string3 + "/" + string4;
                    Print.logInfo("CRA: [" + string12 + "] Custom Predefined Action: " + string11 + ":" + string2, new Object[0]);
                    continue;
                }
                bl4 = false;
                if (account2 != null && device2 != null) {
                    bl4 = true;
                    String string13 = string3 + "/" + string4;
                    if (EventRuleAction.CRAMatch(CRA_resetMaint, string11)) {
                        int string20 = StringTools.parseInt(string2, 0);
                        string22 = device2.getMaintDescriptionKM(string20);
                        device2.resetMaintOdometerKM(string20);
                        Print.logInfo("CRA: [" + string13 + "] Resetting Device maintenance: [" + string20 + "] " + string22, new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_resetReminder, string11)) {
                        int bl7 = StringTools.parseInt(string2, 0);
                        device2.resetReminder();
                        Print.logInfo("CRA: [" + string13 + "] Resetting Device reminder", new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_save, string11)) {
                        if ((n & 0x10000) != 0) continue;
                        try {
                            String n7;
                            boolean bl10 = bl;
                            Print.logInfo("CRA: [" + string13 + "] Saving Device notify time/code", new Object[0]);
                            String string14 = n7 = rule != null ? rule.getRuleID() : "";
                            if (eventData != null) {
                                device2.setLastNotifyEvent(eventData, n7, bl10);
                                continue;
                            }
                            device2.setLastNotifyEvent(DateTime.getCurrentTimeSec(), n7, bl10);
                        }
                        catch (DBException dBException) {
                            Print.logError("CRA: Unable to save Device notify time/code - " + dBException, new Object[0]);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_setCorridor, string11)) {
                        String dCServerConfig = string2;
                        if (!StringTools.isBlank(dCServerConfig)) {
                            Print.logInfo("CRA: [" + string13 + "] Setting active corridor - " + dCServerConfig, new Object[0]);
                            device2.setActiveCorridor(dCServerConfig);
                            if (bl) {
                                try {
                                    device2.update("activeCorridor");
                                }
                                catch (DBException bl11) {
                                    Print.logError("CRA: [" + string13 + "] Unable to update Device - " + bl11, new Object[0]);
                                }
                                continue;
                            }
                            device2.addOtherChangedFieldNames("activeCorridor");
                            continue;
                        }
                        Print.logWarn("CRA: [" + string13 + "] Invalid GeoCorridor ID specified: " + dCServerConfig, new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_clearCorridor, string11)) {
                        String n8 = device2.getActiveCorridor();
                        Print.logInfo("CRA: [" + string13 + "] Clearing active corridor - " + n8, new Object[0]);
                        device2.setActiveCorridor("");
                        if (bl) {
                            try {
                                device2.update("activeCorridor");
                            }
                            catch (DBException string26) {
                                Print.logError("CRA: [" + string13 + "] Unable to update Device - " + string26, new Object[0]);
                            }
                            continue;
                        }
                        device2.addOtherChangedFieldNames("activeCorridor");
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_clearEMail, string11)) {
                        String string24 = device2.getNotifyEmail();
                        Print.logInfo("CRA: [" + string13 + "] Clearing Device notify-email - " + string24, new Object[0]);
                        device2.setNotifyEmail("");
                        if (bl) {
                            try {
                                device2.update("notifyEmail");
                            }
                            catch (DBException bl14) {
                                Print.logError("CRA: [" + string13 + "] Unable to update Device - " + bl14, new Object[0]);
                            }
                            continue;
                        }
                        device2.addOtherChangedFieldNames("notifyEmail");
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_park, string11)) {
                        boolean n10 = false;
                        GeoPoint string31 = null;
                        String string30 = "Unspecified";
                        double d = 200.0;
                        if (eventData != null && eventData.isValidGeoPoint()) {
                            string31 = eventData.getGeoPoint();
                            string30 = "Event";
                            d = 200.0;
                        } else if (n10 && eventData != null && eventData.hasCellLocation()) {
                            string31 = eventData.getCellGeoPoint();
                            string30 = "CellTower";
                            d = 500.0;
                        } else if (device2.hasLastValidLocation()) {
                            string31 = device2.getLastValidLocation();
                            string30 = "LastKnown";
                            d = 200.0;
                        } else {
                            string31 = null;
                            string30 = "None";
                        }
                        try {
                            boolean bl5;
                            boolean bl6 = bl5 = bl;
                            if (GeoPoint.isValid(string31)) {
                                double d2 = StringTools.parseDouble(string2, 0.0);
                                if (d2 <= 0.0) {
                                    d2 = d;
                                } else if (d2 < 5.0) {
                                    d2 = 5.0;
                                }
                                Print.logInfo("CRA: [" + string13 + "] Setting Device park - (" + string30 + ") " + string31 + " radM=" + d2, new Object[0]);
                                device2.setParkedLocation(string31, d2, bl5);
                                continue;
                            }
                            Print.logInfo("CRA: [" + string13 + "] Unable to park Device (no valid GeoPoint)", new Object[0]);
                            device2.setParkedLocation(null, 0.0, bl5);
                        }
                        catch (DBException dBException) {
                            Print.logError("CRA: [" + string13 + "] Unable to save Device park attributes - " + dBException, new Object[0]);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_unpark, string11)) {
                        try {
                            boolean string28 = bl;
                            Print.logInfo("CRA: [" + string13 + "] Clearing Device park", new Object[0]);
                            device2.setParkedLocation(null, 0.0, string28);
                        }
                        catch (DBException string29) {
                            Print.logError("CRA: [" + string13 + "] Unable to save Device park attributes - " + string29, new Object[0]);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_sendCommand, string11)) {
                        DCServerConfig n12 = device2.getDCServerConfig();
                        if (n12 != null) {
                            String string15 = "config";
                            String string16 = string2;
                            String[] stringArray4 = ListTools.toArray(stringArray2, 2, -1);
                            object = DCServerFactory.sendServerCommand(device2, string15, string16, stringArray4);
                            if (object != null) {
                                Print.logWarn("CRA: [" + string13 + "] 'sendCommand' response: " + object, new Object[0]);
                                continue;
                            }
                            Print.logWarn("CRA: [" + string13 + "] 'sendCommand' failed", new Object[0]);
                            continue;
                        }
                        Print.logWarn("CRA: [" + string13 + "] Device DCServerConfig not found - " + device2.getDeviceCode(), new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_addEvent, string11)) {
                        EventData eventData2;
                        int n4;
                        int n5 = StringTools.parseInt(string2, -1);
                        if (eventData == null) {
                            Print.logWarn("CRA: [" + string13 + "] Unable to add event - no EventData instance available", new Object[0]);
                            continue;
                        }
                        if (eventData.getIsSynthesizedEvent()) {
                            Print.logWarn("CRA: [" + string13 + "] Skipping recursive add event - already a rule triggered event", new Object[0]);
                            continue;
                        }
                        if (n5 < 0) {
                            Print.logWarn("CRA: [" + string13 + "] Unable to add event - no StatusCode specified", new Object[0]);
                            continue;
                        }
                        if (n5 == eventData.getStatusCode()) {
                            Print.logWarn("CRA: [" + string13 + "] Unable to add event - StatusCode already matches current event", new Object[0]);
                            continue;
                        }
                        int n6 = n4 = n5 <= 15 ? 0xFF00 | n5 : n5;
                        if (bl && !eventData.hasAddress()) {
                            eventData.reloadAddress();
                        }
                        if (device2.insertEventData(eventData2 = EventData.copySynthesizedEvent(eventData, n4))) {
                            Print.logWarn("CRA: [" + string13 + "] Added new EventData - " + eventData2, new Object[0]);
                            continue;
                        }
                        Print.logError("CRA: [" + string13 + "] New EventData failed!", new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_resetCommands, string11)) {
                        String string17 = string2;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        if (string17.equalsIgnoreCase("both") || StringTools.isBlank(string17)) {
                            bl7 = true;
                            bl8 = true;
                        } else if (string17.equalsIgnoreCase("account") || string17.equalsIgnoreCase("a")) {
                            bl7 = true;
                        } else if (string17.equalsIgnoreCase("device") || string17.equalsIgnoreCase("d")) {
                            bl8 = true;
                        }
                        if (bl8) {
                            Print.logWarn("CRA: [" + string13 + "] Clearing Device 'totalPingCount'", new Object[0]);
                            device2.setTotalPingCount(0);
                            if (bl) {
                                try {
                                    device2.update("totalPingCount");
                                }
                                catch (DBException dBException) {
                                    Print.logError("CRA: [" + string13 + "] Unable to update Device - " + dBException, new Object[0]);
                                }
                            } else {
                                device2.addOtherChangedFieldNames("totalPingCount");
                            }
                        }
                        if (!bl7) continue;
                        account2.setTotalPingCount(0);
                        try {
                            account2.update("totalPingCount");
                            Print.logWarn("CRA: [" + string13 + "] Cleared Account 'totalPingCount'", new Object[0]);
                        }
                        catch (DBException dBException) {
                            Print.logException("CRA: [" + string13 + "] Unable to update Account", dBException);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_setvar, string11)) {
                        String string18;
                        int n7 = string2.indexOf("=");
                        String string19 = n7 >= 0 ? string2.substring(0, n7) : "";
                        String string20 = string18 = n7 >= 0 ? string2.substring(n7 + 1) : "";
                        if (StringTools.isBlank(string19)) {
                            Print.logWarn("CRA: [" + string13 + "] Setvar fieldName not specified", new Object[0]);
                            continue;
                        }
                        int n8 = -1;
                        object = "";
                        DBField dBField = null;
                        if (StringTools.startsWithIgnoreCase(string19, "Account.")) {
                            string19 = string19.substring("Account.".length());
                            dBField = Account.getFactory().getField(string19);
                            n8 = 0;
                            object = "Account";
                        } else if (StringTools.startsWithIgnoreCase(string19, "Device.")) {
                            string19 = string19.substring("Device.".length());
                            dBField = Device.getFactory().getField(string19);
                            n8 = 1;
                            object = "Device";
                        } else {
                            Print.logWarn("CRA: [" + string13 + "] Setvar fieldName does not start with 'Account.' or 'Device.'", new Object[0]);
                            continue;
                        }
                        if (dBField == null) {
                            Print.logWarn("CRA: [" + string13 + "] Setvar fieldName does not exist: (" + (String)object + ") " + string19, new Object[0]);
                            continue;
                        }
                        if (dBField.getFactory() == null) {
                            Print.logWarn("CRA: [" + string13 + "] Setvar fieldName DBFactory is null (" + (String)object + ")", new Object[0]);
                            continue;
                        }
                        if (dBField.isPrimaryKey()) {
                            Print.logWarn("CRA: [" + string13 + "] Setvar fieldName specifies a primary key field: (" + (String)object + ") " + string19, new Object[0]);
                            continue;
                        }
                        Object object4 = dBField.parseStringValue(string18);
                        if (object4 == null) {
                            Print.logWarn("CRA: [" + string13 + "] Setvar fieldValue is invalid for field type: (" + (String)object + ") " + string19, new Object[0]);
                            continue;
                        }
                        switch (n8) {
                            case 0: {
                                Print.logWarn("CRA: [" + string13 + "] Setting Account Field '" + string19 + "' to value - " + object4, new Object[0]);
                                account2.setFieldValue(string19, object4);
                                try {
                                    account2.update(string19);
                                }
                                catch (DBException dBException) {
                                    Print.logError("CRA: [" + string13 + "] Unable to update Account - " + dBException, new Object[0]);
                                }
                                break;
                            }
                            case 1: {
                                Print.logWarn("CRA: [" + string13 + "] Setting Device Field '" + string19 + "' to value - " + object4, new Object[0]);
                                device2.setFieldValue(string19, object4);
                                if (bl) {
                                    try {
                                        device2.update(string19);
                                    }
                                    catch (DBException dBException) {
                                        Print.logError("CRA: [" + string13 + "] Unable to update Device '" + string4 + "' " + dBException, new Object[0]);
                                    }
                                    break;
                                }
                                device2.addOtherChangedFieldNames(string19);
                                break;
                            }
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_sendMQ, string11)) {
                        if (eventData == null) {
                            Print.logWarn("CRA: [" + string13 + "] Unable to add event - no EventData instance available", new Object[0]);
                            continue;
                        }
                        Print.logWarn("CRA: [" + string13 + "] Sending Event record via JMS/MQ not yet supported.", new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_emailReport, string11)) {
                        String string21 = string2;
                        if (StringTools.isBlank(string21)) {
                            Print.logWarn("CRA: [" + string13 + "] Report not specified", new Object[0]);
                            continue;
                        }
                        Print.logWarn("CRA: [" + string13 + "] Emailing report not yet supported.", new Object[0]);
                        continue;
                    }
                }
                boolean bl9 = false;
                if (account2 != null) {
                    bl9 = true;
                    if (EventRuleAction.CRAMatch(CRA_resetCommands, string11)) {
                        String string23 = string2;
                        boolean bl10 = false;
                        if (string23.equalsIgnoreCase("both") || StringTools.isBlank(string23)) {
                            bl10 = true;
                        } else if (string23.equalsIgnoreCase("account") || string23.equalsIgnoreCase("a")) {
                            bl10 = true;
                        }
                        if (!bl10) continue;
                        account2.setTotalPingCount(0);
                        try {
                            account2.update("totalPingCount");
                            Print.logWarn("CRA: [" + string3 + "] Cleared Account 'totalPingCount'", new Object[0]);
                        }
                        catch (DBException dBException) {
                            Print.logException("CRA: [" + string3 + "] Unable to update Account", dBException);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_setvar, string11)) {
                        String string24;
                        int n9 = string2.indexOf("=");
                        String string25 = n9 >= 0 ? string2.substring(0, n9) : "";
                        String string26 = string24 = n9 >= 0 ? string2.substring(n9 + 1) : "";
                        if (StringTools.isBlank(string25)) {
                            Print.logWarn("CRA: [" + string3 + "] Setvar fieldName not specified", new Object[0]);
                            continue;
                        }
                        int n10 = -1;
                        object = null;
                        if (!string25.startsWith("Account.")) {
                            Print.logWarn("CRA: [" + string3 + "] Setvar fieldName does not start with Account", new Object[0]);
                            continue;
                        }
                        string25 = string25.substring("Account.".length());
                        object = Account.getFactory().getField(string25);
                        n10 = 0;
                        if (object == null) {
                            Print.logWarn("CRA: [" + string3 + "] Setvar fieldName does not exist", new Object[0]);
                            continue;
                        }
                        if (((DBField)object).getFactory() == null) {
                            Print.logWarn("CRA: [" + string3 + "] Setvar fieldName DBFactory is null", new Object[0]);
                            continue;
                        }
                        if (((DBField)object).isPrimaryKey()) {
                            Print.logWarn("CRA: [" + string3 + "] Setvar fieldName specifies a primary key field", new Object[0]);
                            continue;
                        }
                        Object object5 = ((DBField)object).parseStringValue(string24);
                        if (object5 == null) {
                            Print.logWarn("CRA: [" + string3 + "] Setvar fieldValue is invalid", new Object[0]);
                            continue;
                        }
                        switch (n10) {
                            case 0: {
                                account2.setFieldValue(string25, object5);
                                try {
                                    account2.update(string25);
                                    Print.logWarn("CRA: [" + string3 + "] Set Account Field '" + string25 + "' to value: " + object5, new Object[0]);
                                }
                                catch (DBException dBException) {
                                    Print.logException("CRA: [" + string3 + "] Unable to update Account", dBException);
                                }
                                break;
                            }
                        }
                        continue;
                    }
                }
                if (!bl4 && !bl9) {
                    Print.logWarn("CRA: Account is null - " + string10, new Object[0]);
                    continue;
                }
                Print.logWarn("CRA: Command not found - " + string10, new Object[0]);
            }
        }
        return bl3;
    }

    public static boolean _debugSendNotification(String string, String string2, int n) {
        EventData.Key key = new EventData.Key(string, string2, DateTime.getCurrentTimeSec(), n);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setAddress("1234 Somewhere Ln, Somewhere CA, 98765");
        eventData.setGeoPoint(new GeoPoint(35.12345, -142.12345));
        eventData.setSpeedKPH(105.0);
        eventData.setHeading(123.0);
        eventData.setAltitude(457.0);
        eventData.setOdometerKM(123456.0);
        eventData.setDistanceKM(3456.0);
        int n2 = 519;
        boolean bl = EventRuleAction._sendNotification(false, eventData.getAccount(), eventData.getDevice(), eventData, true, n2, 1, "(true)", null);
        Print.logInfo("Notification saved: " + bl, new Object[0]);
        return bl;
    }

    public static boolean _debugSendNotification(EventData eventData, Rule rule) {
        if (eventData == null) {
            Print.logError("EventData is null", new Object[0]);
            return false;
        }
        Account account = eventData.getAccount();
        Device device = eventData.getDevice();
        int n = rule != null ? rule.getActionMask() : 775;
        boolean bl = rule != null ? rule.getIsCronRule() : true;
        int n2 = rule != null ? rule.getPriority() : 1;
        String string = rule != null ? rule.getSelector() : "(true)";
        boolean bl2 = EventRuleAction._sendNotification(false, account, device, eventData, bl, n, n2, string, rule);
        Print.logInfo("Notification result: " + bl2, new Object[0]);
        return bl2;
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit(stringArray, true);
        SendMail.SetThreadModel("debug");
        BasicPrivateLabelLoader.loadPrivateLabelXML();
        EventRuleAction.DebugSetSendNotification(RTConfig.getBoolean("send", false));
        String string = RTConfig.getString("account", "opendmtp");
        String string2 = RTConfig.getString("device", "mobile");
        long l = DateTime.getCurrentTimeSec();
        Account account = null;
        Device device = null;
        try {
            account = Account.getAccount(string);
            device = Device.getDevice(account, string2);
            if (device == null) {
                Print.logError("Device not found: " + string + "/" + string2, new Object[0]);
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            Print.logException("Account/Device error", throwable);
            System.exit(2);
        }
        long l2 = l - DateTime.MinuteSeconds(10L);
        EventData.Key key = new EventData.Key(string, string2, l2, 61472);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setDevice(device);
        eventData.setAddress("1234 Somewhere Else, Somewhere CA, 98765");
        eventData.setGeoPoint(new GeoPoint(35.12345, -142.12345));
        eventData.setSpeedKPH(27.0);
        eventData.setHeading(241.0);
        eventData.setAltitude(402.0);
        eventData.setOdometerKM(123412.0);
        eventData.setDistanceKM(3412.0);
        EventData.Key key2 = new EventData.Key(string, string2, l, 63761);
        EventData eventData2 = (EventData)key2.getDBRecord();
        eventData2.setDevice(device);
        eventData2.setAddress("4321 Somewhere Ln, Somewhere CA, 98764");
        eventData2.setGeoPoint(new GeoPoint(35.13456, -142.13456));
        eventData2.setSpeedKPH(45.0);
        eventData2.setHeading(123.0);
        eventData2.setAltitude(457.0);
        eventData2.setOdometerKM(123456.0);
        eventData2.setDistanceKM(3456.0);
        eventData2.setFieldValue("j1708Fault", DTOBDFault.EncodeFault_J1708(128, true, 235, 3, 0, true));
        eventData2.setPreviousEventData(eventData);
        String string3 = EventRuleAction._getNotificationRecipients(account, device, null, -1);
        Print.sysPrintln("Email Recipients: " + string3, new Object[0]);
        boolean bl = EventRuleAction._sendNotification(false, eventData2.getAccount(), eventData2.getDevice(), eventData2, true, 263, 1, "(true)", null);
        if (bl) {
            Print.logInfo("EMail/SMS sent successfully", new Object[0]);
        } else {
            Print.logInfo("EMail/SMS not sent", new Object[0]);
        }
    }

    static {
        Object object;
        Object object2;
        PROP_emailSubj = new String[]{"emailSubject", "emailSubj"};
        PROP_emailBody = new String[]{"emailBody"};
        PROP_smsText = new String[]{"smsText", "textMessage"};
        KEY_SUBJECT = new String[]{"subject", "ruleSubject"};
        KEY_MESSAGE = new String[]{"message", "ruleMessage"};
        KEY_SMSTEXT = new String[]{"smsText", "ruleSmsText"};
        KEY_PRIOR_GEOZONE = new String[]{"priorGeozone", "priorGeozoneID"};
        KEY_PRIOR_ADDRESS = new String[]{"priorAddress", "priorFullAddress"};
        KEY_MAP_URL = new String[]{"mapURL"};
        KEY_REPORT_URL = new String[]{"reportURL"};
        CRA_resetMaint = new String[]{"resetMaint"};
        CRA_resetReminder = new String[]{"resetReminder", "resetRemind"};
        CRA_save = new String[]{"saveAlert", "save"};
        CRA_setCorridor = new String[]{"setCorridor"};
        CRA_clearCorridor = new String[]{"clearCorridor"};
        CRA_sendCommand = new String[]{"sendCommand"};
        CRA_clearEMail = new String[]{"clearEMail"};
        CRA_addEvent = new String[]{"addEvent", "event"};
        CRA_sendMQ = new String[]{"sendMQ", "sendJMS"};
        CRA_emailReport = new String[]{"emailReport"};
        CRA_resetCommands = new String[]{"resetCommands", "resetPingCount"};
        CRA_park = new String[]{"park"};
        CRA_unpark = new String[]{"unpark"};
        CRA_setvar = new String[]{"setvar", "setfield"};
        PredefinedRuleActionList = new PredefinedRuleAction[]{new PredefinedRuleAction(CRA_resetMaint[0], "0", I18N.getString(EventRuleAction.class, "PredefinedRuleAction.resetMaint_0", "Reset Maintenance #0")), new PredefinedRuleAction(CRA_resetMaint[0], "1", I18N.getString(EventRuleAction.class, "PredefinedRuleAction.resetMaint_1", "Reset Maintenance #1")), new PredefinedRuleAction(CRA_resetReminder[0], "", I18N.getString(EventRuleAction.class, "PredefinedRuleAction.resetReminder", "Reset Reminder")), new PredefinedRuleAction(CRA_resetCommands[0], "", I18N.getString(EventRuleAction.class, "PredefinedRuleAction.resetCommands", "Reset Max Commands")), new PredefinedRuleAction(CRA_park[0], "100", I18N.getString(EventRuleAction.class, "PredefinedRuleAction.park_100", "Park with 100 meter radius")), new PredefinedRuleAction(CRA_unpark[0], "", I18N.getString(EventRuleAction.class, "PredefinedRuleAction.unpark", "Unpark"))};
        SEND_NOTIFICATION = true;
        RuleListenerList = null;
        CustomCRAListener = null;
        String string = RTConfig.getString("rule.ruleListenerClass");
        if (!StringTools.isBlank(string)) {
            try {
                object2 = Class.forName(string);
                object = (RuleListener)((Class)object2).newInstance();
                EventRuleAction.addRuleListener((RuleListener)object);
            }
            catch (Throwable throwable) {
                Print.logException("Invalid RuleListener class (property rule.ruleListenerClass)", throwable);
            }
        }
        if (!StringTools.isBlank((String)(object2 = RTConfig.getString("rule.predefinedActionClass")))) {
            try {
                PredefinedActionListener predefinedActionListener;
                object = Class.forName((String)object2);
                CustomCRAListener = predefinedActionListener = (PredefinedActionListener)((Class)object).newInstance();
            }
            catch (Throwable throwable) {
                Print.logException("Invalid PredefinedActionListener class (property rule.predefinedActionClass)", throwable);
            }
        }
        PROP_ThreadPool_EventRuleAction_ = RTKey.valueOf("Rule.ThreadPool.EventRuleAction.");
        ThreadPool_EventRuleAction = new ThreadPool("EventRuleAction", PROP_ThreadPool_EventRuleAction_, 20, 0, 0);
    }

    public static class EventDataText
    implements StringTools.KeyValueMap {
        private Account account = null;
        private Device device = null;
        private EventData event = null;
        private BasicPrivateLabel privLabel = null;
        private String messageSubj = null;
        private String messageBody = null;
        private String messageSmsM = null;

        public EventDataText(Account account, Device device, EventData eventData, String string, String string2, String string3, BasicPrivateLabel basicPrivateLabel) {
            String string4;
            this.account = account;
            this.device = device;
            this.event = eventData;
            this.privLabel = basicPrivateLabel;
            this.messageSubj = !StringTools.isBlank(string) ? StringTools.insertKeyValues(string, "${", "}", "=", this) : null;
            if (!StringTools.isBlank(string2)) {
                string4 = StringTools.insertKeyValues(string2, "${", "}", "=", this);
                this.messageBody = StringTools.replace(string4, "\\n", "\n");
            } else {
                this.messageBody = null;
            }
            if (!StringTools.isBlank(string3)) {
                string4 = StringTools.insertKeyValues(string3, "${", "}", "=", this);
                this.messageSmsM = StringTools.replace(string4, "\\n", "\n");
            } else {
                this.messageSmsM = null;
            }
        }

        public String toString(String string) {
            return StringTools.insertKeyValues(string, "${", "}", "=", this);
        }

        public String toString() {
            return this.toString("Account   : [${accountid}] ${account}\nVehicle   : [${deviceid}] ${device}\nDate/Time : ${datetime}\nStatus    : [${statuscode}] ${status}\nLocation  : ${geopoint}\nSpeed     : ${speed}  ${direction}\nAltitude  : ${altitude}\nOdometer  : ${odometer}\n\n");
        }

        @Override
        public String getKeyValue(String string, String string2, String string3) {
            if (ListTools.containsIgnoreCase(KEY_SUBJECT, string)) {
                return this.messageSubj != null ? this.messageSubj : string3;
            }
            if (ListTools.containsIgnoreCase(KEY_MESSAGE, string)) {
                return this.messageBody != null ? this.messageBody : string3;
            }
            if (ListTools.containsIgnoreCase(KEY_SMSTEXT, string)) {
                return this.messageSmsM != null ? this.messageSmsM : string3;
            }
            if (ListTools.containsIgnoreCase(KEY_MAP_URL, string)) {
                return string3;
            }
            if (ListTools.containsIgnoreCase(KEY_REPORT_URL, string)) {
                return string3;
            }
            if (ListTools.containsIgnoreCase(KEY_PRIOR_ADDRESS, string)) {
                if (this.event != null) {
                    try {
                        EventData eventData = this.event.getPreviousEventData(true);
                        return eventData != null ? eventData.getAddress() : string3;
                    }
                    catch (DBException dBException) {
                        return "(" + string + "!)";
                    }
                }
                return string3;
            }
            if (ListTools.containsIgnoreCase(KEY_PRIOR_GEOZONE, string)) {
                if (this.event != null) {
                    try {
                        EventData eventData = this.event.getPreviousEventData(true);
                        return eventData != null ? eventData.getGeozoneID() : string3;
                    }
                    catch (DBException dBException) {
                        return "(" + string + "!)";
                    }
                }
                return string3;
            }
            if (string.startsWith("#")) {
                if (this.event != null) {
                    try {
                        EventData eventData = this.event.getPreviousEventData(true);
                        if (eventData != null) {
                            String string4 = string.substring(1);
                            String string5 = eventData.getKeyFieldValue(string4, string2, this.privLabel);
                            return string5 != null ? string5 : string3;
                        }
                        return string3;
                    }
                    catch (DBException dBException) {
                        return "(" + string + "!)";
                    }
                }
                return string3;
            }
            if (this.event != null) {
                String string6 = this.event.getKeyFieldValue(string, string2, this.privLabel);
                return string6 != null ? string6 : "(" + string + ")";
            }
            if (this.device != null) {
                String string7 = this.device.getKeyFieldValue(string, string2, this.privLabel);
                return string7 != null ? string7 : "(" + string + ")";
            }
            if (this.account != null) {
                String string8 = this.account.getKeyFieldValue(string, string2, this.privLabel);
                return string8 != null ? string8 : "(" + string + ")";
            }
            return "(" + string + ")";
        }
    }
}

