/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.db;

import java.util.Vector;
import org.opengts.util.GeoPoint;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class PayloadTemplate {
    public static final int MAX_FIELD_COUNT = 128;
    public static final int PRIMITIVE_MASK = 240;
    public static final int PRIMITIVE_LONG = 16;
    public static final int PRIMITIVE_GPS = 48;
    public static final int PRIMITIVE_STRING = 64;
    public static final int PRIMITIVE_BINARY = 80;
    public static final int FIELD_STATUS_CODE = 1;
    public static final int FIELD_TIMESTAMP = 2;
    public static final int FIELD_INDEX = 3;
    public static final int FIELD_SEQUENCE = 4;
    public static final int FIELD_GPS_POINT = 6;
    public static final int FIELD_GPS_AGE = 7;
    public static final int FIELD_SPEED = 8;
    public static final int FIELD_HEADING = 9;
    public static final int FIELD_ALTITUDE = 10;
    public static final int FIELD_DISTANCE = 11;
    public static final int FIELD_ODOMETER = 12;
    public static final int FIELD_GEOFENCE_ID = 14;
    public static final int FIELD_TOP_SPEED = 15;
    public static final int FIELD_BRAKE_G_FORCE = 16;
    public static final int FIELD_STRING = 17;
    public static final int FIELD_STRING_PAD = 18;
    public static final int FIELD_ENTITY = 21;
    public static final int FIELD_ENTITY_PAD = 22;
    public static final int FIELD_BINARY = 26;
    public static final int FIELD_INPUT_ID = 33;
    public static final int FIELD_INPUT_STATE = 34;
    public static final int FIELD_OUTPUT_ID = 36;
    public static final int FIELD_OUTPUT_STATE = 37;
    public static final int FIELD_ELAPSED_TIME = 39;
    public static final int FIELD_COUNTER = 40;
    public static final int FIELD_SENSOR32_LOW = 49;
    public static final int FIELD_SENSOR32_HIGH = 50;
    public static final int FIELD_SENSOR32_AVER = 51;
    public static final int FIELD_TEMP_LOW = 58;
    public static final int FIELD_TEMP_HIGH = 59;
    public static final int FIELD_TEMP_AVER = 60;
    public static final int FIELD_GPS_DGPS_UPDATE = 65;
    public static final int FIELD_GPS_HORZ_ACCURACY = 66;
    public static final int FIELD_GPS_VERT_ACCURACY = 67;
    public static final int FIELD_GPS_SATELLITES = 68;
    public static final int FIELD_GPS_MAG_VARIATION = 69;
    public static final int FIELD_GPS_QUALITY = 70;
    public static final int FIELD_GPS_TYPE = 71;
    public static final int FIELD_GPS_GEOID_HEIGHT = 72;
    public static final int FIELD_GPS_PDOP = 73;
    public static final int FIELD_GPS_HDOP = 74;
    public static final int FIELD_GPS_VDOP = 75;
    public static final int FIELD_OBC_VALUE = 80;
    public static final int FIELD_OBC_GENERIC = 81;
    public static final int FIELD_OBC_J1708_FAULT = 82;
    public static final int FIELD_OBC_DISTANCE = 84;
    public static final int FIELD_OBC_ENGINE_HOURS = 87;
    public static final int FIELD_OBC_ENGINE_RPM = 88;
    public static final int FIELD_OBC_COOLANT_TEMP = 89;
    public static final int FIELD_OBC_COOLANT_LEVEL = 90;
    public static final int FIELD_OBC_OIL_LEVEL = 91;
    public static final int FIELD_OBC_OIL_PRESSURE = 92;
    public static final int FIELD_OBC_FUEL_LEVEL = 93;
    public static final int FIELD_OBC_FUEL_ECONOMY = 94;
    public static final int FIELD_OBC_FUEL_TOTAL = 95;
    public static final int FIELD_OBC_FUEL_IDLE = 96;
    public static final int FIELD_CELLTOWER_0 = 128;
    public static final int FIELD_CELLTOWER_1 = 129;
    public static final int FIELD_CELLTOWER_2 = 130;
    public static final int FIELD_CELLTOWER_3 = 131;
    private int customType = -1;
    private Field[] fields = null;
    private boolean repeatLast = false;
    private static final char FIELD_VALUE_SEPARATOR = '|';

    protected static Field[] parseFields(String[] fldStr) {
        Vector<Field> pfl = new Vector<Field>();
        for (int i = 0; i < fldStr.length; ++i) {
            Field pf = new Field(fldStr[i]);
            if (pf.isValidType()) {
                pfl.add(pf);
                continue;
            }
            Print.logError((String)("Invalid field format [ignored]: " + fldStr[i]), (Object[])new Object[0]);
        }
        return pfl.toArray(new Field[pfl.size()]);
    }

    public PayloadTemplate(int type, Field[] flds) {
        this.customType = type;
        this.fields = flds;
        this.repeatLast = false;
    }

    public PayloadTemplate(int type, Field[] flds, boolean repeatLast) {
        this.customType = type;
        this.fields = flds;
        this.repeatLast = repeatLast;
    }

    public PayloadTemplate(int type, String[] flds) {
        this(type, PayloadTemplate.parseFields(flds));
    }

    public PayloadTemplate(int type, String[] flds, boolean repeatLast) {
        this(type, PayloadTemplate.parseFields(flds), repeatLast);
    }

    public int getPacketType() {
        return this.customType;
    }

    public Field getField(int ndx) {
        if (ndx >= 0 && this.fields != null && this.fields.length > 0) {
            if (ndx < this.fields.length) {
                return this.fields[ndx];
            }
            if (this.repeatLast) {
                return this.fields[this.fields.length - 1];
            }
        }
        return null;
    }

    public Field[] getFields() {
        if (this.fields == null) {
            this.fields = new Field[0];
        }
        return this.fields;
    }

    public boolean getRepeatLast() {
        return this.repeatLast;
    }

    public static class Field {
        private boolean hiRes = false;
        private int fldType = -1;
        private int fldNdx = 0;
        private int fldLen = 0;

        public Field(int type, boolean hiRes, int index, int length) {
            this.fldType = type;
            this.hiRes = hiRes;
            this.fldNdx = index;
            this.fldLen = length;
        }

        public Field(long mask) {
            this.fldType = (int)(mask >> 16) & 0x7F;
            this.hiRes = (mask & 0x800000L) != 0L;
            this.fldNdx = (int)(mask >> 8) & 0xFF;
            this.fldLen = (int)mask & 0xFF;
        }

        public Field(String s) {
            String[] f = StringTools.parseString((String)s, (char)'|');
            this.fldType = f.length > 0 ? StringTools.parseInt((String)f[1], (int)-1) : -1;
            this.hiRes = f.length > 1 ? f[0].equalsIgnoreCase("H") : false;
            this.fldNdx = f.length > 2 ? StringTools.parseInt((String)f[2], (int)0) : 0;
            this.fldLen = f.length > 3 ? StringTools.parseInt((String)f[3], (int)0) : 0;
        }

        public int getType() {
            return this.fldType;
        }

        public int getPrimitiveType() {
            switch (this.fldType) {
                case 6: {
                    return 48;
                }
                case 17: {
                    return 64;
                }
                case 18: {
                    return 64;
                }
                case 21: {
                    return 64;
                }
                case 22: {
                    return 64;
                }
                case 26: {
                    return 80;
                }
            }
            return 16;
        }

        public boolean isValidType() {
            return this.fldType >= 0 && this.fldLen > 0;
        }

        public boolean isSigned() {
            switch (this.fldType) {
                case 10: 
                case 58: 
                case 59: 
                case 60: 
                case 69: 
                case 72: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHex() {
            switch (this.fldType) {
                case 9: {
                    return !this.hiRes;
                }
                case 1: 
                case 4: 
                case 14: 
                case 33: 
                case 34: 
                case 36: 
                case 37: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHiRes() {
            return this.hiRes;
        }

        public int getIndex() {
            return this.fldNdx;
        }

        public int getLength() {
            return this.fldLen;
        }

        public int parseString(String[] s, int sndx, Payload payload) {
            int length = this.getLength();
            switch (this.getPrimitiveType()) {
                case 48: {
                    double lat = StringTools.parseDouble((String)s[sndx++], (double)0.0);
                    double lon = sndx < s.length ? StringTools.parseDouble((String)s[sndx++], (double)0.0) : 0.0;
                    payload.writeGPS(new GeoPoint(lat, lon), length);
                    break;
                }
                case 64: {
                    payload.writeString(s[sndx++], length);
                    break;
                }
                case 80: {
                    byte[] b = StringTools.parseHex((String)s[sndx++], (byte[])new byte[0]);
                    payload.writeBytes(b, length);
                    break;
                }
                default: {
                    long val;
                    long l = val = s[sndx].startsWith("0x") ? StringTools.parseHexLong((String)s[sndx++], (long)0L) : StringTools.parseLong((String)s[sndx++], (long)0L);
                    if (this.isSigned()) {
                        payload.writeLong(val, length);
                        break;
                    }
                    payload.writeULong(val, length);
                    break;
                }
            }
            return sndx;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getType());
            sb.append('|');
            sb.append(this.isHiRes() ? "H" : "L");
            sb.append('|');
            sb.append(this.getIndex());
            sb.append('|');
            sb.append(this.getLength());
            return sb.toString();
        }

        public boolean equals(Object other) {
            if (other instanceof Field) {
                return this.toString().equals(other.toString());
            }
            return false;
        }
    }
}

