/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import org.opendmtp.codes.ServerErrors;
import org.opendmtp.server.base.Packet;
import org.opengts.util.StringTools;

public class PacketParseException
extends Exception {
    private int errorCode = 0;
    private Packet errPacket = null;
    private byte[] errorData = null;
    private boolean terminate = false;

    public PacketParseException(int servErrCode) {
        this(servErrCode, null, null);
    }

    public PacketParseException(int servErrCode, Packet packet) {
        this(servErrCode, packet, null);
    }

    public PacketParseException(int servErrCode, Packet packet, byte[] errData) {
        this.errorCode = servErrCode;
        this.errPacket = packet;
        this.errorData = errData;
    }

    public Packet getPacket() {
        return this.errPacket;
    }

    public void setPacket(Packet pkt) {
        this.errPacket = pkt;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public byte[] getErrorData() {
        return this.errorData;
    }

    public Packet createServerErrorPacket() {
        int errCode = this.getErrorCode();
        Packet cause = this.getPacket();
        byte[] errData = this.getErrorData();
        Packet errPkt = Packet.createServerErrorPacket(errCode, cause);
        if (errData != null) {
            errPkt.getPayload(false).writeBytes(errData, errData.length);
        }
        return errPkt;
    }

    public void setTerminate() {
        this.terminate = true;
    }

    public boolean terminateSession() {
        return this.terminate;
    }

    public String toString() {
        Packet errPkt = this.getPacket();
        int errCode = this.getErrorCode();
        StringBuffer sb = new StringBuffer();
        sb.append(ServerErrors.getErrorDescription(errCode));
        sb.append(" [ServerError=");
        sb.append(StringTools.toHexString((long)errCode, (int)16));
        if (errPkt != null) {
            int hdrType = errPkt.getPacketHeader() << 8 | errPkt.getPacketType();
            sb.append(", Packet=");
            sb.append(StringTools.toHexString((long)hdrType, (int)16));
        }
        sb.append("] ");
        return sb.toString();
    }
}

