/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import org.opendmtp.codes.Encoding;
import org.opendmtp.codes.PropCodes;
import org.opendmtp.server.base.DeviceID;
import org.opendmtp.server.base.PacketParseException;
import org.opendmtp.server.db.PayloadTemplate;
import org.opengts.util.Base64;
import org.opengts.util.GeoPoint;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class Packet {
    public static final int MIN_HEADER_LENGTH = 3;
    public static final int MAX_PAYLOAD_LENGTH = 255;
    public static final int HEADER_BASIC = 224;
    public static final int PKT_CLIENT_EOB_DONE = 0;
    public static final int PKT_CLIENT_EOB_MORE = 1;
    public static final int PKT_CLIENT_UNIQUE_ID = 17;
    public static final int PKT_CLIENT_ACCOUNT_ID = 18;
    public static final int PKT_CLIENT_DEVICE_ID = 19;
    public static final int PKT_CLIENT_FIXED_FMT_STD = 48;
    public static final int PKT_CLIENT_FIXED_FMT_HIGH = 49;
    public static final int PKT_CLIENT_CELLTOWER_FMT_STD = 52;
    public static final int PKT_CLIENT_CELLTOWER_FMT_HIGH = 53;
    public static final int PKT_CLIENT_DMTSP_FMT_0 = 80;
    public static final int PKT_CLIENT_DMTSP_FMT_1 = 81;
    public static final int PKT_CLIENT_DMTSP_FMT_2 = 82;
    public static final int PKT_CLIENT_DMTSP_FMT_3 = 83;
    public static final int PKT_CLIENT_DMTSP_FMT_4 = 84;
    public static final int PKT_CLIENT_DMTSP_FMT_5 = 85;
    public static final int PKT_CLIENT_DMTSP_FMT_6 = 86;
    public static final int PKT_CLIENT_DMTSP_FMT_7 = 87;
    public static final int PKT_CLIENT_DMTSP_FMT_8 = 88;
    public static final int PKT_CLIENT_DMTSP_FMT_9 = 89;
    public static final int PKT_CLIENT_DMTSP_FMT_A = 90;
    public static final int PKT_CLIENT_DMTSP_FMT_B = 91;
    public static final int PKT_CLIENT_DMTSP_FMT_C = 92;
    public static final int PKT_CLIENT_DMTSP_FMT_D = 93;
    public static final int PKT_CLIENT_DMTSP_FMT_E = 94;
    public static final int PKT_CLIENT_DMTSP_FMT_F = 95;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_0 = 112;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_1 = 113;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_2 = 114;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_3 = 115;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_4 = 116;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_5 = 117;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_6 = 118;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_7 = 119;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_8 = 120;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_9 = 121;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_A = 122;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_B = 123;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_C = 124;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_D = 125;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_E = 126;
    public static final int PKT_CLIENT_CUSTOM_FORMAT_F = 127;
    public static final int PKT_CLIENT_PROPERTY_VALUE = 176;
    public static final int PKT_CLIENT_FORMAT_DEF_24 = 207;
    public static final int PKT_CLIENT_DIAGNOSTIC = 208;
    public static final int PKT_CLIENT_ERROR = 224;
    public static final int PKT_SERVER_EOB_DONE = 0;
    public static final int PKT_SERVER_EOB_SPEAK_FREELY = 1;
    public static final int PKT_SERVER_ACK = 160;
    public static final int PKT_SERVER_GET_PROPERTY = 176;
    public static final int PKT_SERVER_SET_PROPERTY = 177;
    public static final int PKT_SERVER_FILE_UPLOAD = 192;
    public static final int PKT_SERVER_ERROR = 224;
    public static final int PKT_SERVER_EOT = 255;
    private static PayloadTemplate ClientCustomEvent_30 = new PayloadTemplate(48, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2), new PayloadTemplate.Field(2, false, 0, 4), new PayloadTemplate.Field(6, false, 0, 6), new PayloadTemplate.Field(8, false, 0, 1), new PayloadTemplate.Field(9, false, 0, 1), new PayloadTemplate.Field(10, false, 0, 2), new PayloadTemplate.Field(11, false, 0, 3), new PayloadTemplate.Field(4, false, 0, 1)});
    private static PayloadTemplate ClientCustomEvent_31 = new PayloadTemplate(49, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, true, 0, 2), new PayloadTemplate.Field(2, true, 0, 4), new PayloadTemplate.Field(6, true, 0, 8), new PayloadTemplate.Field(8, true, 0, 2), new PayloadTemplate.Field(9, true, 0, 2), new PayloadTemplate.Field(10, true, 0, 3), new PayloadTemplate.Field(11, true, 0, 3), new PayloadTemplate.Field(4, true, 0, 1)});
    private static PayloadTemplate ClientCustomEvent_34 = new PayloadTemplate(52, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2), new PayloadTemplate.Field(2, false, 0, 4), new PayloadTemplate.Field(6, false, 0, 6), new PayloadTemplate.Field(128, false, 0, 10), new PayloadTemplate.Field(8, false, 0, 1), new PayloadTemplate.Field(9, false, 0, 1), new PayloadTemplate.Field(10, false, 0, 2), new PayloadTemplate.Field(11, false, 0, 3), new PayloadTemplate.Field(4, false, 0, 1)});
    private static PayloadTemplate ClientCustomEvent_35 = new PayloadTemplate(53, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, true, 0, 2), new PayloadTemplate.Field(2, true, 0, 4), new PayloadTemplate.Field(6, true, 0, 8), new PayloadTemplate.Field(128, true, 0, 10), new PayloadTemplate.Field(8, true, 0, 2), new PayloadTemplate.Field(9, true, 0, 2), new PayloadTemplate.Field(10, true, 0, 3), new PayloadTemplate.Field(11, true, 0, 3), new PayloadTemplate.Field(4, true, 0, 1)});
    private static PayloadTemplate ClientTemplate_EndOfBlock_Done = new PayloadTemplate(0, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2)});
    private static PayloadTemplate ClientTemplate_EndOfBlock_More = new PayloadTemplate(1, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2)});
    private static PayloadTemplate ClientTemplate_Unique_ID = new PayloadTemplate(17, new PayloadTemplate.Field[]{new PayloadTemplate.Field(26, false, 0, 20)});
    private static PayloadTemplate ClientTemplate_Account_ID = new PayloadTemplate(18, new PayloadTemplate.Field[]{new PayloadTemplate.Field(17, false, 0, 20)});
    private static PayloadTemplate ClientTemplate_Device_ID = new PayloadTemplate(19, new PayloadTemplate.Field[]{new PayloadTemplate.Field(17, false, 0, 20)});
    private static PayloadTemplate ClientTemplate_ProvertyValue = new PayloadTemplate(176, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2), new PayloadTemplate.Field(26, false, 0, 253)});
    private static PayloadTemplate ClientTemplate_CustomDef = new PayloadTemplate(207, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 1), new PayloadTemplate.Field(3, false, 0, 1), new PayloadTemplate.Field(26, false, 0, 3)}, true);
    private static PayloadTemplate ClientTemplate_Diagnostic = new PayloadTemplate(208, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2), new PayloadTemplate.Field(26, false, 0, 253)});
    private static PayloadTemplate ClientTemplate_Error = new PayloadTemplate(224, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2), new PayloadTemplate.Field(26, false, 0, 253)});
    private static PayloadTemplate[] ClientEventPayloadTemplate_table = new PayloadTemplate[]{ClientCustomEvent_30, ClientCustomEvent_31, ClientCustomEvent_34, ClientCustomEvent_35};
    private static PayloadTemplate[] ClientStandardPayloadTemplate_table = new PayloadTemplate[]{ClientTemplate_EndOfBlock_Done, ClientTemplate_EndOfBlock_More, ClientTemplate_Unique_ID, ClientTemplate_Account_ID, ClientTemplate_Device_ID, ClientTemplate_ProvertyValue, ClientTemplate_CustomDef, ClientTemplate_Diagnostic, ClientTemplate_Error};
    private static PayloadTemplate ServerTemplate_EndOfBlock_Done = new PayloadTemplate(0, new PayloadTemplate.Field[0]);
    private static PayloadTemplate ServerTemplate_EndOfBlock_SpeakFreely = new PayloadTemplate(1, new PayloadTemplate.Field[0]);
    private static PayloadTemplate ServerTemplate_Ack = new PayloadTemplate(160, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 4)});
    private static PayloadTemplate ServerTemplate_GetProperty = new PayloadTemplate(176, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 4)});
    private static PayloadTemplate ServerTemplate_SetProperty = new PayloadTemplate(177, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2), new PayloadTemplate.Field(26, false, 0, 251)});
    private static PayloadTemplate ServerTemplate_Error = new PayloadTemplate(224, new PayloadTemplate.Field[]{new PayloadTemplate.Field(1, false, 0, 2), new PayloadTemplate.Field(1, false, 0, 1), new PayloadTemplate.Field(1, false, 0, 1), new PayloadTemplate.Field(26, false, 0, 251)});
    private static PayloadTemplate ServerTemplate_EndOfTransmission = new PayloadTemplate(255, new PayloadTemplate.Field[0]);
    private static PayloadTemplate[] ServerStandardPayloadTemplate_table = new PayloadTemplate[]{ServerTemplate_EndOfBlock_Done, ServerTemplate_Ack, ServerTemplate_GetProperty, ServerTemplate_SetProperty, ServerTemplate_Error, ServerTemplate_EndOfTransmission};
    private int encoding = 0;
    private boolean hasAsciiChecksum = false;
    private DeviceID deviceId = null;
    private PayloadTemplate payloadTemplate = null;
    private boolean isClient = true;
    private int header = 0;
    private int type = 0;
    private Payload payload = null;

    public static PayloadTemplate GetClientPayloadTemplate(int type) {
        int i;
        for (i = 0; i < ClientEventPayloadTemplate_table.length; ++i) {
            if (type != ClientEventPayloadTemplate_table[i].getPacketType()) continue;
            return ClientEventPayloadTemplate_table[i];
        }
        for (i = 0; i < ClientStandardPayloadTemplate_table.length; ++i) {
            if (type != ClientStandardPayloadTemplate_table[i].getPacketType()) continue;
            return ClientStandardPayloadTemplate_table[i];
        }
        return null;
    }

    public static PayloadTemplate GetServerPayloadTemplate(int type) {
        for (int i = 0; i < ServerStandardPayloadTemplate_table.length; ++i) {
            if (type != ServerStandardPayloadTemplate_table[i].getPacketType()) continue;
            return ServerStandardPayloadTemplate_table[i];
        }
        return null;
    }

    public static Packet createServerPacket(int type) {
        return new Packet(null, false, 224, type);
    }

    public static Packet createServerPacket(int type, Payload payload) {
        return new Packet(null, false, 224, type, payload);
    }

    public static Packet createServerPacket(int type, byte[] payload) {
        return new Packet(null, false, 224, type, payload);
    }

    public static Packet createServerErrorPacket(int errCode, Packet causePkt) {
        Payload payload = new Payload();
        payload.writeULong((long)errCode, 2);
        if (causePkt != null) {
            payload.writeULong((long)causePkt.getPacketHeader(), 1);
            payload.writeULong((long)causePkt.getPacketType(), 1);
        } else {
            payload.writeULong(0L, 1);
            payload.writeULong(0L, 1);
        }
        return Packet.createServerPacket(224, payload);
    }

    public static Packet createServerErrorPacket(int errCode, int header, int type) {
        Payload payload = new Payload();
        payload.writeULong((long)errCode, 2);
        payload.writeULong((long)header, 1);
        payload.writeULong((long)type, 1);
        return Packet.createServerPacket(224, payload);
    }

    public static Packet createServerGetFilePacket(String fileName, long fileSize) {
        if (fileName == null) {
            fileName = "";
        }
        Payload payload = new Payload();
        payload.writeULong(49L, 1);
        payload.writeULong(fileSize, 3);
        payload.writeString(fileName, 64);
        return Packet.createServerPacket(192, payload);
    }

    public static Packet createServerPutFilePacket(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        Payload payload = new Payload();
        payload.writeULong(65L, 1);
        payload.writeULong(0L, 3);
        payload.writeString(fileName, 64);
        return Packet.createServerPacket(192, payload);
    }

    public static Packet createServerGetPropertyPacket(int propCode, byte[] propData, int propDataLen) {
        Payload payload = new Payload();
        payload.writeULong((long)propCode, 2);
        payload.writeBytes(propData, propDataLen);
        return Packet.createServerPacket(176, payload);
    }

    public static Packet createServerSetPropertyPacket(int propCode, byte[] propData, int propDataLen) {
        Payload payload = new Payload();
        payload.writeULong((long)propCode, 2);
        payload.writeBytes(propData, propDataLen);
        return Packet.createServerPacket(177, payload);
    }

    public static Packet createServerSetPropertyPacket(int propCode, long[] value) {
        byte[] propData = PropCodes.encodePropertyData(propCode, value);
        if (propData != null) {
            return Packet.createServerSetPropertyPacket(propCode, propData, propData.length);
        }
        return null;
    }

    public static Packet createServerSetPropertyPacket(int propCode, double[] value) {
        byte[] propData = PropCodes.encodePropertyData(propCode, value);
        if (propData != null) {
            return Packet.createServerSetPropertyPacket(propCode, propData, propData.length);
        }
        return null;
    }

    public static Packet createServerSetPropertyPacket(int propCode, String value) {
        byte[] propData = PropCodes.encodePropertyData(propCode, value != null ? value : "");
        if (propData != null) {
            return Packet.createServerSetPropertyPacket(propCode, propData, propData.length);
        }
        return null;
    }

    private static int CalcChecksum(byte[] b) {
        if (b == null) {
            return -1;
        }
        int cksum = 0;
        int s = 0;
        if (b.length > 0 && b[0] == 36) {
            ++s;
        }
        while (s < b.length && b[s] != 42 && b[s] != 13) {
            cksum = (cksum ^ b[s]) & 0xFF;
            ++s;
        }
        return cksum;
    }

    public Packet(PayloadTemplate template, int header, byte[] payload) {
        this.deviceId = null;
        this.payloadTemplate = template;
        this.isClient = true;
        this.header = header;
        this.type = template.getPacketType();
        this.payload = new Payload(payload);
    }

    public Packet(DeviceID devId, boolean isClient, int header, int type) {
        this(devId, isClient, header, type, new Payload());
    }

    public Packet(DeviceID devId, boolean isClient, int header, int type, byte[] payload) {
        this(devId, isClient, header, type, new Payload(payload));
    }

    public Packet(DeviceID devId, boolean isClient, int header, int type, Payload payload) {
        this.deviceId = devId;
        this.payloadTemplate = null;
        this.isClient = isClient;
        this.header = header;
        this.type = type;
        this.payload = payload;
    }

    public Packet(DeviceID devId, boolean isClient, String pkt) throws PacketParseException {
        this(devId, isClient, StringTools.getBytes((String)pkt));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Packet(DeviceID devId, boolean isClient, byte[] pkt) throws PacketParseException {
        this.deviceId = devId;
        this.isClient = isClient;
        this.encoding = -1;
        if (pkt.length < 3) {
            this.header = pkt.length > 0 ? pkt[0] & 0xFF : 0;
            this.type = pkt.length > 1 ? pkt[1] & 0xFF : 0;
            throw new PacketParseException(61715, this);
        }
        if (pkt[0] == 36) {
            int ench;
            int pLen;
            int cksumActual = 0;
            int cksumTest = -1;
            this.hasAsciiChecksum = false;
            for (pLen = 1; pLen < pkt.length && pkt[pLen] != 13; ++pLen) {
                if (pkt[pLen] == 42) {
                    this.hasAsciiChecksum = true;
                    String hexCksum = StringTools.toStringValue((byte[])pkt, (int)(pLen + 1), (int)2);
                    cksumTest = StringTools.parseHexInt((String)hexCksum, (int)-1);
                    break;
                }
                cksumActual = (cksumActual ^ pkt[pLen]) & 0xFF;
            }
            String p = StringTools.toStringValue((byte[])pkt, (int)0, (int)pLen);
            this.header = pLen >= 3 ? StringTools.parseHexInt((String)p.substring(1, 3), (int)0) : 0;
            int n = this.type = pLen >= 5 ? StringTools.parseHexInt((String)p.substring(3, 5), (int)0) : 0;
            if (this.header != 224) {
                throw new PacketParseException(61713, this);
            }
            if (pLen < 5) {
                throw new PacketParseException(61715, this);
            }
            if (cksumTest >= 0 && cksumTest != cksumActual) {
                throw new PacketParseException(61718, this);
            }
            int n2 = ench = p.length() >= 6 ? (int)p.charAt(5) : -1;
            if (ench == 13 || ench < 0) {
                this.encoding = this.hasAsciiChecksum ? 11 : 10;
                this.payload = new Payload(new byte[0]);
                return;
            } else if (ench == 58) {
                this.encoding = this.hasAsciiChecksum ? 21 : 20;
                this.payload = new Payload(StringTools.parseHex((String)p.substring(6), (byte[])new byte[0]));
                return;
            } else if (ench == 61) {
                this.encoding = this.hasAsciiChecksum ? 11 : 10;
                try {
                    this.payload = new Payload(Base64.decode((String)p.substring(6)));
                    return;
                }
                catch (Base64.Base64DecodeException bde) {
                    this.payload = new Payload(new byte[0]);
                }
                return;
            } else {
                if (ench != 44) throw new PacketParseException(61717, this);
                this.encoding = this.hasAsciiChecksum ? 31 : 30;
                this.payload = Packet._decodeCSV(this, p.substring(6));
            }
            return;
        } else if (pkt[0] == -32) {
            this.encoding = 0;
            this.header = pkt[0] & 0xFF;
            this.type = pkt[1] & 0xFF;
            int len = pkt[2] & 0xFF;
            if (len != pkt.length - 3) {
                throw new PacketParseException(61715, this);
            }
            this.payload = new Payload(pkt, 3, len);
            return;
        } else {
            this.encoding = -1;
            this.header = pkt[0] & 0xFF;
            this.type = pkt[1] & 0xFF;
            throw new PacketParseException(61713, this);
        }
    }

    public Packet(byte[] pkt) throws PacketParseException {
        this(null, false, pkt);
    }

    public void setEncoding(int encoding) {
        this.encoding = encoding;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public int getPacketHeader() {
        return this.header;
    }

    public boolean isBasicPacketHeader() {
        return this.getPacketHeader() == 224;
    }

    public int getPacketType() {
        return this.type;
    }

    public boolean isIdentType() {
        int t = this.getPacketType();
        return t == 17 || t == 18 || t == 19;
    }

    public boolean isEventType() {
        return Packet.isEventType(this.getPacketType());
    }

    public static boolean isEventType(int t) {
        if (Packet.isFixedEventType(t) || Packet.isCustomEventType(t)) {
            return true;
        }
        return t >= 80 && t <= 95;
    }

    public static boolean isFixedEventType(int t) {
        switch (t) {
            case 48: 
            case 49: 
            case 52: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCustomEventType(int t) {
        return t >= 112 && t <= 127;
    }

    public boolean hasAsciiChecksum() {
        return this.hasAsciiChecksum;
    }

    public int getPacketLength() {
        return 3 + this.getPayloadLength();
    }

    public int getPayloadLength() {
        return this.payload.getSize();
    }

    public boolean hasPayload() {
        return this.getPayloadLength() > 0;
    }

    public Payload getPayload(boolean reset) {
        if (reset) {
            this.payload.resetIndex();
        }
        return this.payload;
    }

    public PayloadTemplate getPayloadTemplate() {
        if (this.isClient) {
            if (this.payloadTemplate != null) {
                return this.payloadTemplate;
            }
            PayloadTemplate plt = Packet.GetClientPayloadTemplate(this.type);
            if (plt == null && this.deviceId != null) {
                plt = this.deviceId.getClientPayloadTemplate(this.type);
            }
            this.payloadTemplate = plt;
            return plt;
        }
        return Packet.GetServerPayloadTemplate(this.type);
    }

    public byte[] getPayloadBytes(int ofs, int len) {
        byte[] b = this.getPayload(true).getBytes();
        if (ofs >= b.length) {
            return new byte[0];
        }
        if (len > b.length - ofs) {
            len = b.length - ofs;
        }
        byte[] n = new byte[len];
        System.arraycopy(b, ofs, n, 0, len);
        return n;
    }

    public byte[] encode() {
        return this.encode(this.getEncoding());
    }

    public byte[] encode(int encoding) {
        int cksum;
        byte[] payload = this.getPayload(true).getBytes();
        if (encoding == 0) {
            int len = payload.length;
            byte[] pkt = new byte[3 + len];
            pkt[0] = (byte)(this.header & 0xFF);
            pkt[1] = (byte)(this.type & 0xFF);
            pkt[2] = (byte)(len & 0xFF);
            System.arraycopy(payload, 0, pkt, 3, len);
            return pkt;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('$');
        sb.append(StringTools.toHexString((long)((long)this.header & 0xFFL), (int)8));
        sb.append(StringTools.toHexString((long)((long)this.type & 0xFFL), (int)8));
        if (payload.length > 0) {
            switch (encoding) {
                case 30: 
                case 31: {
                    sb.append(Packet._encodeCSV(this));
                    break;
                }
                case 10: 
                case 11: {
                    sb.append('=');
                    sb.append(Base64.encode((byte[])payload));
                    break;
                }
                case 20: 
                case 21: {
                    sb.append(':');
                    StringTools.toHexString((byte[])payload, (StringBuffer)sb);
                    break;
                }
                default: {
                    Print.logError((String)("Unknown encoding: " + encoding), (Object[])new Object[0]);
                    encoding = 20;
                    sb.append(':');
                    StringTools.toHexString((byte[])payload, (StringBuffer)sb);
                }
            }
        }
        if (Encoding.IsEncodingChecksum(encoding) && (cksum = Packet.CalcChecksum(StringTools.getBytes((String)sb.toString()))) >= 0) {
            sb.append('*');
            sb.append(StringTools.toHexString((long)((long)cksum & 0xFFL), (int)8));
        }
        sb.append('\r');
        return StringTools.getBytes((StringBuffer)sb);
    }

    public String toString(int encoding) {
        switch (encoding) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 30: 
            case 31: {
                break;
            }
            default: {
                encoding = 20;
            }
        }
        byte[] b = this.encode(encoding);
        if (b != null && b.length > 0) {
            if (b[0] == 36) {
                int len = b[b.length - 1] == 13 ? b.length - 1 : b.length;
                return StringTools.toStringValue((byte[])b, (int)0, (int)len);
            }
            return "0x" + StringTools.toHexString((byte[])b);
        }
        return "";
    }

    public String toString() {
        return this.toString(this.getEncoding());
    }

    private static Payload _decodeCSV(Packet pkt, String csv) throws PacketParseException {
        PayloadTemplate.Field pltFld;
        PayloadTemplate plt = pkt.getPayloadTemplate();
        if (plt == null) {
            if (Packet.isCustomEventType(pkt.getPacketType())) {
                throw new PacketParseException(62498, pkt);
            }
            throw new PacketParseException(61714, pkt);
        }
        String[] csvFlds = StringTools.parseString((String)csv, (char)',');
        Payload payload = new Payload();
        int p = 0;
        int c = 0;
        while (c < csvFlds.length && (pltFld = plt.getField(p)) != null) {
            c = pltFld.parseString(csvFlds, c, payload);
            ++p;
        }
        payload.resetIndex();
        return payload;
    }

    private static String _encodeCSV(Packet pkt) {
        PayloadTemplate.Field pltFld;
        StringBuffer sb = new StringBuffer();
        Payload payload = pkt.getPayload(true);
        PayloadTemplate plt = pkt.getPayloadTemplate();
        if (plt == null) {
            sb.append('=');
            sb.append(Base64.encode((byte[])payload.getBytes()));
            return sb.toString();
        }
        payload.resetIndex();
        int p = 0;
        while (payload.isValidReadLength(0) && (pltFld = plt.getField(p)) != null) {
            sb.append(',');
            int length = pltFld.getLength();
            switch (pltFld.getPrimitiveType()) {
                case 48: {
                    GeoPoint gp = payload.readGPS(length);
                    if (pltFld.isHiRes()) {
                        sb.append(StringTools.format((double)gp.getLatitude(), (String)"###0.00000"));
                        sb.append(',');
                        sb.append(StringTools.format((double)gp.getLongitude(), (String)"###0.00000"));
                        break;
                    }
                    sb.append(StringTools.format((double)gp.getLatitude(), (String)"###0.0000"));
                    sb.append(',');
                    sb.append(StringTools.format((double)gp.getLongitude(), (String)"###0.0000"));
                    break;
                }
                case 64: {
                    sb.append(payload.readString(length));
                    break;
                }
                case 80: {
                    byte[] b = payload.readBytes(length);
                    sb.append("0x" + StringTools.toHexString((byte[])b));
                    break;
                }
                default: {
                    long val;
                    long l = val = pltFld.isSigned() ? payload.readLong(length, 0L) : payload.readULong(length, 0L);
                    if (pltFld.isHex()) {
                        sb.append("0x" + StringTools.toHexString((long)val, (int)(length * 8)));
                        break;
                    }
                    sb.append(String.valueOf(val));
                    break;
                }
            }
            ++p;
        }
        return sb.toString();
    }

    public static int getPacketLength(byte[] data, int dataOfs) {
        boolean STRICT_ASCII_EOL = false;
        if (data == null) {
            return -1;
        }
        int dataLen = data.length;
        if (dataOfs + 3 >= dataLen) {
            return -1;
        }
        if (data[dataOfs] == 36) {
            for (int ofs = dataOfs; ofs < dataLen; ++ofs) {
                if (STRICT_ASCII_EOL) {
                    if (data[ofs] != 13) continue;
                    return ++ofs - dataOfs;
                }
                if (data[ofs] != 13 && data[ofs] != 10) continue;
                while (ofs < dataLen && (data[ofs] == 13 || data[ofs] == 10)) {
                    ++ofs;
                }
                return ofs - dataOfs;
            }
            return -1;
        }
        int len = 3 + (data[dataOfs + 2] & 0xFF);
        if (dataOfs + len <= dataLen) {
            return len;
        }
        return -1;
    }
}

