/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import org.opendmtp.server.base.DMTPGeoEvent;
import org.opendmtp.server.base.Packet;
import org.opendmtp.server.base.PacketParseException;
import org.opendmtp.server.db.PayloadTemplate;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class Event {
    private static final long INVALID_TEMPERATURE = -99999L;
    private Packet packet = null;
    private PayloadTemplate custTemplate = null;
    private int custFieldLen = 0;
    private DMTPGeoEvent geoEvent = null;

    public Event(Packet pkt) throws PacketParseException {
        this(null, pkt);
    }

    public Event(String ipAddr, Packet pkt) throws PacketParseException {
        this.packet = pkt;
        this.geoEvent = new DMTPGeoEvent();
        if (this.packet == null) {
            throw new PacketParseException(61715, this.packet);
        }
        if (!this.packet.isEventType()) {
            throw new PacketParseException(61714, this.packet);
        }
        if (!this.packet.hasPayload()) {
            throw new PacketParseException(61716, this.packet);
        }
        this.custTemplate = this.packet.getPayloadTemplate();
        if (this.custTemplate == null) {
            int hdrType = this.packet.getPacketHeader() << 8 | this.packet.getPacketType();
            Print.logError((String)("PayloadTemplate not found: 0x" + StringTools.toHexString((long)hdrType, (int)16)), (Object[])new Object[0]);
            throw new PacketParseException(62498, this.packet);
        }
        this.setEventValue("IPAddress", ipAddr != null ? ipAddr : "");
        this.custFieldLen = 0;
        this._decodeEvent();
    }

    public String getIPAddress() {
        return this.getGeoEvent().getIPAddress();
    }

    public Packet getPacket() {
        return this.packet;
    }

    public DMTPGeoEvent getGeoEvent() {
        return this.geoEvent;
    }

    public long getSequence() {
        return this.getGeoEvent().getSequence();
    }

    public int getSequenceLength() {
        return this.getGeoEvent().getSequenceLength();
    }

    private void setEventValue(String fldName, Object val, int ndx) {
        this.getGeoEvent().setEventValue(fldName, val, ndx);
    }

    private void setEventValue(String fldName, Object val) {
        this.getGeoEvent().setEventValue(fldName, val);
    }

    public void setEventValue(String fldName, long val, int ndx) {
        this.getGeoEvent().setEventValue(fldName, val, ndx);
    }

    public void setEventValue(String fldName, long val) {
        this.getGeoEvent().setEventValue(fldName, val);
    }

    public void setEventValue(String fldName, double val, int ndx) {
        this.getGeoEvent().setEventValue(fldName, val, ndx);
    }

    public void setEventValue(String fldName, double val) {
        this.getGeoEvent().setEventValue(fldName, val);
    }

    public byte[] getByteValue(String fldName, byte[] dft) {
        return this.getGeoEvent().getByteValue(fldName, dft);
    }

    public byte[] getByteValue(String fldName, byte[] dft, int ndx) {
        return this.getGeoEvent().getByteValue(fldName, dft, ndx);
    }

    public String getStringValue(String fldName, String dft) {
        return this.getGeoEvent().getStringValue(fldName, dft);
    }

    public String getStringValue(String fldName, String dft, int ndx) {
        return this.getGeoEvent().getStringValue(fldName, dft, ndx);
    }

    public long getLongValue(String fldName, long dft) {
        return this.getGeoEvent().getLongValue(fldName, dft);
    }

    public long getLongValue(String fldName, long dft, int ndx) {
        return this.getGeoEvent().getLongValue(fldName, dft, ndx);
    }

    public double getDoubleValue(String fldName, double dft) {
        return this.getGeoEvent().getDoubleValue(fldName, dft);
    }

    public double getDoubleValue(String fldName, double dft, int ndx) {
        return this.getGeoEvent().getDoubleValue(fldName, dft, ndx);
    }

    public GeoPoint getGeoPointValue(String fldName, GeoPoint dft) {
        return this.getGeoEvent().getGeoPointValue(fldName, dft);
    }

    public GeoPoint getGeoPointValue(String fldName, GeoPoint dft, int ndx) {
        return this.getGeoEvent().getGeoPointValue(fldName, dft, ndx);
    }

    private void _decodeEvent() throws PacketParseException {
        Payload payload = this.packet.getPayload(true);
        this.setEventValue("RawData", this.packet.toString());
        this.setEventValue("StatusCode", 0L);
        this.setEventValue("Timestamp", DateTime.getCurrentTimeSec());
        boolean hasStatusCode = false;
        boolean hasGeoPoint = false;
        payload.resetIndex();
        this.custFieldLen = 0;
        while (payload.hasAvailableRead()) {
            if (this.custFieldLen >= 128) {
                Print.logError((String)("Invalid number of fields: " + this.custFieldLen), (Object[])new Object[0]);
                Payload p = new Payload();
                p.writeULong((long)this.packet.getPacketType(), 1);
                byte[] errData = p.getBytes();
                throw new PacketParseException(62481, this.packet, errData);
            }
            PayloadTemplate.Field field = this.custTemplate.getField(this.custFieldLen);
            if (field == null) break;
            int type = field.getType();
            boolean hiRes = field.isHiRes();
            int ndx = field.getIndex();
            int length = field.getLength();
            if (length == 0) {
                Print.logError((String)("Invalid Field length: " + StringTools.toHexString((long)type, (int)8)), (Object[])new Object[0]);
                Payload p = new Payload();
                p.writeULong((long)this.packet.getPacketType(), 1);
                byte[] errData = p.getBytes();
                throw new PacketParseException(62481, this.packet, errData);
            }
            long longVal = 0L;
            Object gp = null;
            switch (type) {
                case 1: {
                    this.setEventValue("StatusCode", payload.readULong(length, 0L));
                    hasStatusCode = true;
                    break;
                }
                case 2: {
                    this.setEventValue("Timestamp", payload.readULong(length, 0L));
                    break;
                }
                case 3: {
                    this.setEventValue("Index", payload.readULong(length, 0L));
                    break;
                }
                case 6: {
                    this.setEventValue("GeoPoint", payload.readGPS(length));
                    hasGeoPoint = true;
                    break;
                }
                case 8: {
                    this.setEventValue("SpeedKPH", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 9: {
                    this.setEventValue("Heading", hiRes ? (double)payload.readULong(length, 0L) / 100.0 : (double)payload.readULong(length, 0L) * 360.0 / 255.0);
                    break;
                }
                case 10: {
                    this.setEventValue("AltitudeM", hiRes ? (double)payload.readLong(length, 0L) / 10.0 : (double)payload.readLong(length, 0L));
                    break;
                }
                case 11: {
                    this.setEventValue("DistanceKM", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 12: {
                    this.setEventValue("OdometerKM", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 4: {
                    this.setEventValue("Sequence", payload.readULong(length, -1L));
                    this.setEventValue("SeqLen", length);
                    break;
                }
                case 33: {
                    this.setEventValue("InputID", payload.readULong(length, 0L));
                    break;
                }
                case 34: {
                    this.setEventValue("InputState", payload.readULong(length, 0L));
                    break;
                }
                case 36: {
                    this.setEventValue("OutputID", payload.readULong(length, 0L));
                    break;
                }
                case 37: {
                    this.setEventValue("OutputState", payload.readULong(length, 0L));
                    break;
                }
                case 39: {
                    this.setEventValue("ElapsedTime", hiRes ? payload.readULong(length, 0L) : payload.readULong(length, 0L) * 1000L, ndx);
                    break;
                }
                case 40: {
                    this.setEventValue("Counter", payload.readULong(length, 0L), ndx);
                    break;
                }
                case 49: {
                    this.setEventValue("Sens32LO", payload.readULong(length, 0L), ndx);
                    break;
                }
                case 50: {
                    this.setEventValue("Sens32HI", payload.readULong(length, 0L), ndx);
                    break;
                }
                case 51: {
                    this.setEventValue("Sens32AV", payload.readULong(length, 0L), ndx);
                    break;
                }
                case 58: {
                    longVal = payload.readLong(length, -99999L);
                    if (length == 1 && Math.abs(longVal) > 126L) {
                        longVal = -99999L;
                    }
                    this.setEventValue("TempLO", hiRes ? (double)longVal / 10.0 : (double)longVal, ndx);
                    break;
                }
                case 59: {
                    longVal = payload.readLong(length, -99999L);
                    if (length == 1 && Math.abs(longVal) > 126L) {
                        longVal = -99999L;
                    }
                    this.setEventValue("TempHI", hiRes ? (double)longVal / 10.0 : (double)longVal, ndx);
                    break;
                }
                case 60: {
                    longVal = payload.readLong(length, -99999L);
                    if (length == 1 && Math.abs(longVal) > 126L) {
                        longVal = -99999L;
                    }
                    this.setEventValue("TempAV", hiRes ? (double)longVal / 10.0 : (double)longVal, ndx);
                    break;
                }
                case 14: {
                    this.setEventValue("Geofence", payload.readULong(length, 0L), ndx);
                    break;
                }
                case 15: {
                    this.setEventValue("TopSpeedKPH", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L), ndx);
                    break;
                }
                case 16: {
                    this.setEventValue("BrakeGForce", (double)payload.readLong(length, 0L) / 10.0);
                    break;
                }
                case 17: {
                    this.setEventValue("String", payload.readString(length, true), ndx);
                    break;
                }
                case 18: {
                    this.setEventValue("String", payload.readString(length, false), ndx);
                    break;
                }
                case 21: {
                    this.setEventValue("Entity", payload.readString(length, true), ndx);
                    break;
                }
                case 22: {
                    this.setEventValue("Entity", payload.readString(length, false), ndx);
                    break;
                }
                case 26: {
                    this.setEventValue("Binary", payload.readBytes(length), ndx);
                    break;
                }
                case 7: {
                    this.setEventValue("GPSAge", payload.readULong(length, 0L));
                    break;
                }
                case 65: {
                    this.setEventValue("GPSDgpsUpd", payload.readULong(length, 0L));
                    break;
                }
                case 66: {
                    this.setEventValue("GPSHorzAcc", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 67: {
                    this.setEventValue("GPSVertAcc", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 68: {
                    this.setEventValue("GPSSats", payload.readULong(length, 0L));
                    break;
                }
                case 69: {
                    this.setEventValue("GPSMagVar", (double)payload.readLong(length, 0L) / 100.0);
                    break;
                }
                case 70: {
                    this.setEventValue("GPSQuality", payload.readULong(length, 0L));
                    break;
                }
                case 71: {
                    this.setEventValue("GPS2D3D", payload.readULong(length, 0L));
                    break;
                }
                case 72: {
                    this.setEventValue("GPSGeoidHt", hiRes ? (double)payload.readLong(length, 0L) / 10.0 : (double)payload.readLong(length, 0L));
                    break;
                }
                case 73: {
                    this.setEventValue("GPSPDOP", (double)payload.readLong(length, 0L) / 10.0);
                    break;
                }
                case 74: {
                    this.setEventValue("GPSHDOP", (double)payload.readLong(length, 0L) / 10.0);
                    break;
                }
                case 75: {
                    this.setEventValue("GPSVDOP", (double)payload.readLong(length, 0L) / 10.0);
                    break;
                }
                case 80: {
                    this.setEventValue("OBCValue", payload.readBytes(length), ndx);
                    break;
                }
                case 81: {
                    this.setEventValue("OBCGeneric", payload.readULong(length, 0L), ndx);
                    break;
                }
                case 82: {
                    this.setEventValue("OBCJ1708Fault", payload.readULong(length, 0L), ndx);
                    break;
                }
                case 84: {
                    this.setEventValue("OBCDistance", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 87: {
                    this.setEventValue("OBCEngHours", (double)payload.readULong(length, 0L) / 10.0);
                    break;
                }
                case 88: {
                    this.setEventValue("OBCEngRPM", payload.readULong(length, 0L));
                    break;
                }
                case 89: {
                    longVal = payload.readLong(length, -99999L);
                    if (length == 1 && Math.abs(longVal) > 126L) {
                        longVal = -99999L;
                    }
                    this.setEventValue("OBCCoolantTemp", hiRes ? (double)longVal / 10.0 : (double)longVal);
                    break;
                }
                case 90: {
                    this.setEventValue("OBCCoolantLevel", hiRes ? (double)payload.readULong(length, 0L) / 1000.0 : (double)payload.readULong(length, 0L) / 100.0);
                    break;
                }
                case 91: {
                    this.setEventValue("OBCOilLevel", hiRes ? (double)payload.readULong(length, 0L) / 1000.0 : (double)payload.readULong(length, 0L) / 100.0);
                    break;
                }
                case 92: {
                    this.setEventValue("OBCOilPressure", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 93: {
                    this.setEventValue("OBCFuelLevel", hiRes ? (double)payload.readULong(length, 0L) / 1000.0 : (double)payload.readULong(length, 0L) / 100.0);
                    break;
                }
                case 94: {
                    this.setEventValue("OBCFuelEcon", (double)payload.readULong(length, 0L) / 10.0);
                    break;
                }
                case 95: {
                    this.setEventValue("OBCFuelTotal", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 96: {
                    this.setEventValue("OBCFuelIdle", hiRes ? (double)payload.readULong(length, 0L) / 10.0 : (double)payload.readULong(length, 0L));
                    break;
                }
                case 128: {
                    this.setEventValue("CellTower_0", payload.readBytes(length), ndx);
                    break;
                }
                case 129: {
                    this.setEventValue("CellTower_1", payload.readBytes(length), ndx);
                    break;
                }
                case 130: {
                    this.setEventValue("CellTower_2", payload.readBytes(length), ndx);
                    break;
                }
                case 131: {
                    this.setEventValue("CellTower_3", payload.readBytes(length), ndx);
                    break;
                }
                default: {
                    Print.logError((String)("Field not defined: " + StringTools.toHexString((long)type, (int)8)), (Object[])new Object[0]);
                    Payload p = new Payload();
                    p.writeULong((long)this.packet.getPacketType(), 1);
                    byte[] errData = p.getBytes();
                    throw new PacketParseException(62481, this.packet, errData);
                }
            }
            ++this.custFieldLen;
        }
        if (!hasStatusCode) {
            this.setEventValue("StatusCode", hasGeoPoint ? 61472L : 0L);
        }
    }

    public String toString() {
        return this.getGeoEvent().toString();
    }
}

