/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.server.base;

import java.util.Iterator;
import org.opendmtp.codes.StatusCodes;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.OrderedMap;
import org.opengts.util.Payload;
import org.opengts.util.StringTools;

public class DMTPGeoEvent {
    public static final double GALLONS_PER_LITER = 0.264172052;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String FLD_ipAddress = "IPAddress";
    public static final String FLD_dataSource = "DataSource";
    public static final String FLD_rawData = "RawData";
    public static final String FLD_statusCode = "StatusCode";
    public static final String FLD_timestamp = "Timestamp";
    public static final String FLD_geoPoint = "GeoPoint";
    public static final String FLD_speedKPH = "SpeedKPH";
    public static final String FLD_heading = "Heading";
    public static final String FLD_altitude = "AltitudeM";
    public static final String FLD_distanceKM = "DistanceKM";
    public static final String FLD_odometerKM = "OdometerKM";
    public static final String FLD_sequence = "Sequence";
    public static final String FLD_sequenceLength = "SeqLen";
    public static final String FLD_geofenceID = "Geofence";
    public static final String FLD_topSpeedKPH = "TopSpeedKPH";
    public static final String FLD_brakeGForce = "BrakeGForce";
    public static final String FLD_index = "Index";
    public static final String FLD_inputID = "InputID";
    public static final String FLD_inputState = "InputState";
    public static final String FLD_outputID = "OutputID";
    public static final String FLD_outputState = "OutputState";
    public static final String FLD_elapsedTime = "ElapsedTime";
    public static final String FLD_counter = "Counter";
    public static final String FLD_sensor32LO = "Sens32LO";
    public static final String FLD_sensor32HI = "Sens32HI";
    public static final String FLD_sensor32AV = "Sens32AV";
    public static final String FLD_tempLO = "TempLO";
    public static final String FLD_tempHI = "TempHI";
    public static final String FLD_tempAV = "TempAV";
    public static final String FLD_entity = "Entity";
    public static final String FLD_string = "String";
    public static final String FLD_binary = "Binary";
    public static final String FLD_gpsAge = "GPSAge";
    public static final String FLD_gpsDgpsUpdate = "GPSDgpsUpd";
    public static final String FLD_gpsHorzAccuracy = "GPSHorzAcc";
    public static final String FLD_gpsVertAccuracy = "GPSVertAcc";
    public static final String FLD_gpsSatellites = "GPSSats";
    public static final String FLD_gpsMagVariation = "GPSMagVar";
    public static final String FLD_gpsQuality = "GPSQuality";
    public static final String FLD_gps2D3D = "GPS2D3D";
    public static final String FLD_gpsGeoidHeight = "GPSGeoidHt";
    public static final String FLD_gpsPDOP = "GPSPDOP";
    public static final String FLD_gpsHDOP = "GPSHDOP";
    public static final String FLD_gpsVDOP = "GPSVDOP";
    public static final String FLD_obcValue = "OBCValue";
    public static final String FLD_obcGeneric = "OBCGeneric";
    public static final String FLD_obcJ1708Fault = "OBCJ1708Fault";
    public static final String FLD_obcDistanceKM = "OBCDistance";
    public static final String FLD_obcEngineHours = "OBCEngHours";
    public static final String FLD_obcEngineRPM = "OBCEngRPM";
    public static final String FLD_obcCoolantTemp = "OBCCoolantTemp";
    public static final String FLD_obcCoolantLevel = "OBCCoolantLevel";
    public static final String FLD_obcOilLevel = "OBCOilLevel";
    public static final String FLD_obcOilPressure = "OBCOilPressure";
    public static final String FLD_obcFuelLevel = "OBCFuelLevel";
    public static final String FLD_obcFuelEconomy = "OBCFuelEcon";
    public static final String FLD_obcFuelTotal = "OBCFuelTotal";
    public static final String FLD_obcFuelIdle = "OBCFuelIdle";
    public static final String FLD_cellTower_0 = "CellTower_0";
    public static final String FLD_cellTower_1 = "CellTower_1";
    public static final String FLD_cellTower_2 = "CellTower_2";
    public static final String FLD_cellTower_3 = "CellTower_3";
    private OrderedMap<String, Object> fieldMap = new OrderedMap();

    public Iterator keyIterator() {
        return this.fieldMap.keyIterator();
    }

    public void setEventValue(String fldName, Object newVal, int ndx) {
        if (ndx <= 0) {
            this.fieldMap.put((Object)fldName, newVal);
        } else {
            this.fieldMap.put((Object)(fldName + "." + ndx), newVal);
        }
    }

    public void setEventValue(String fldName, Object newVal) {
        this.setEventValue(fldName, newVal, -1);
    }

    public void setEventValue(String fldName, long val, int ndx) {
        this.setEventValue(fldName, new Long(val), ndx);
    }

    public void setEventValue(String fldName, long val) {
        this.setEventValue(fldName, new Long(val), -1);
    }

    public void setEventValue(String fldName, double val, int ndx) {
        this.setEventValue(fldName, new Double(val), ndx);
    }

    public void setEventValue(String fldName, double val) {
        this.setEventValue(fldName, new Double(val), -1);
    }

    public Object getEventValue(String fldName, int ndx) {
        String fn = ndx <= 0 ? fldName : fldName + "." + ndx;
        return this.fieldMap.get((Object)fn);
    }

    public Object getEventValue(String fldName) {
        return this.fieldMap.get((Object)fldName);
    }

    public String getStringValue(String fldName, String dft, int ndx) {
        Object val = this.getEventValue(fldName, ndx);
        if (val instanceof byte[]) {
            return "0x" + StringTools.toHexString((byte[])((byte[])val));
        }
        if (val != null) {
            return val.toString();
        }
        return dft;
    }

    public String getStringValue(String fldName, String dft) {
        return this.getStringValue(fldName, dft, -1);
    }

    public byte[] getByteValue(String fldName, byte[] dft, int ndx) {
        Object val = this.getEventValue(fldName, ndx);
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        return dft;
    }

    public byte[] getByteValue(String fldName, byte[] dft) {
        return this.getByteValue(fldName, dft, -1);
    }

    public long getLongValue(String fldName, long dft, int ndx) {
        Object val = this.getEventValue(fldName, ndx);
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return dft;
    }

    public long getLongValue(String fldName, long dft) {
        return this.getLongValue(fldName, dft, -1);
    }

    public double getDoubleValue(String fldName, double dft, int ndx) {
        Object val = this.getEventValue(fldName, ndx);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return dft;
    }

    public double getDoubleValue(String fldName, double dft) {
        return this.getDoubleValue(fldName, dft, -1);
    }

    public GeoPoint getGeoPointValue(String fldName, GeoPoint dft, int ndx) {
        Object val = this.getEventValue(fldName, ndx);
        if (val instanceof GeoPoint) {
            return (GeoPoint)val;
        }
        return dft;
    }

    public GeoPoint getGeoPointValue(String fldName, GeoPoint dft) {
        return this.getGeoPointValue(fldName, dft, -1);
    }

    public GeoPoint getGeoPoint(int ndx) {
        return this.getGeoPointValue(FLD_geoPoint, null, ndx);
    }

    public double getLatitude(int ndx) {
        GeoPoint gp = this.getGeoPoint(ndx);
        return gp != null ? gp.getLatitude() : 0.0;
    }

    public double getLongitude(int ndx) {
        GeoPoint gp = this.getGeoPoint(ndx);
        return gp != null ? gp.getLongitude() : 0.0;
    }

    public String getIPAddress() {
        return this.getStringValue(FLD_ipAddress, "");
    }

    public String getDataSource() {
        return this.getStringValue(FLD_dataSource, "");
    }

    public int getStatusCode() {
        return (int)this.getLongValue(FLD_statusCode, -1L);
    }

    public long getTimestamp() {
        return this.getLongValue(FLD_timestamp, -1L);
    }

    public GeoPoint getGeoPoint() {
        return this.getGeoPointValue(FLD_geoPoint, null);
    }

    public double getSpeed() {
        return this.getDoubleValue(FLD_speedKPH, 0.0);
    }

    public double getHeading() {
        return this.getDoubleValue(FLD_heading, 0.0);
    }

    public double getAltitude() {
        return this.getDoubleValue(FLD_altitude, 0.0);
    }

    public double getDistance() {
        return this.getDoubleValue(FLD_distanceKM, 0.0);
    }

    public double getOdometer() {
        return this.getDoubleValue(FLD_odometerKM, 0.0);
    }

    public double getTopSpeed() {
        return this.getDoubleValue(FLD_topSpeedKPH, 0.0);
    }

    public double getBrakeGForce() {
        return this.getDoubleValue(FLD_brakeGForce, 0.0);
    }

    public long getGeofence(int ndx) {
        return this.getLongValue(FLD_geofenceID, 0L, ndx);
    }

    public long getGpsAge() {
        return this.getLongValue(FLD_gpsAge, 0L);
    }

    public double getHorizontalAccuracy() {
        return this.getDoubleValue(FLD_gpsHorzAccuracy, 0.0);
    }

    public double getVerticalAccuracy() {
        return this.getDoubleValue(FLD_gpsVertAccuracy, 0.0);
    }

    public long getNumberOfSatellites() {
        return this.getLongValue(FLD_gpsSatellites, 0L);
    }

    public double getPDOP() {
        return this.getDoubleValue(FLD_gpsPDOP, 0.0);
    }

    public double getHDOP() {
        return this.getDoubleValue(FLD_gpsHDOP, 0.0);
    }

    public double getVDOP() {
        return this.getDoubleValue(FLD_gpsVDOP, 0.0);
    }

    public long getIndex() {
        return this.getLongValue(FLD_index, 0L);
    }

    public long getInputId() {
        return this.getLongValue(FLD_inputID, 0L);
    }

    public long getInputState() {
        return this.getLongValue(FLD_inputState, 0L);
    }

    public long getOutputId() {
        return this.getLongValue(FLD_outputID, 0L);
    }

    public long getOutputState() {
        return this.getLongValue(FLD_outputState, 0L);
    }

    public long getElapsedTime(int ndx) {
        return this.getLongValue(FLD_elapsedTime, 0L, ndx);
    }

    public long getCounter(int ndx) {
        return this.getLongValue(FLD_counter, 0L, ndx);
    }

    public long getSensorLow(int ndx) {
        return this.getLongValue(FLD_sensor32LO, 0L, ndx);
    }

    public long getSensorHigh(int ndx) {
        return this.getLongValue(FLD_sensor32HI, 0L, ndx);
    }

    public double getTemeratureLow(int ndx) {
        return this.getDoubleValue(FLD_tempLO, -9999.0, ndx);
    }

    public double getTemeratureHigh(int ndx) {
        return this.getDoubleValue(FLD_tempHI, -9999.0, ndx);
    }

    public double getTemeratureAverage(int ndx) {
        return this.getDoubleValue(FLD_tempAV, -9999.0, ndx);
    }

    public String getEntity(int ndx) {
        return this.getStringValue(FLD_entity, "", ndx);
    }

    public String getString(int ndx) {
        return this.getStringValue(FLD_string, "", ndx);
    }

    public byte[] getBinary(int ndx) {
        return this.getByteValue(FLD_binary, EMPTY_BYTE_ARRAY, ndx);
    }

    public byte[] getObcValue(int ndx) {
        return this.getByteValue(FLD_obcValue, EMPTY_BYTE_ARRAY, ndx);
    }

    public long getObcGeneric(int ndx) {
        return this.getLongValue(FLD_obcGeneric, 0L, ndx);
    }

    public long getObcJ1708Fault(int ndx) {
        return this.getLongValue(FLD_obcJ1708Fault, 0L, ndx);
    }

    public double getObcDistanceKM() {
        return this.getDoubleValue(FLD_obcDistanceKM, 0.0);
    }

    public double getObcEngineHours() {
        return this.getDoubleValue(FLD_obcEngineHours, 0.0);
    }

    public long getObcEngineRPM() {
        return this.getLongValue(FLD_obcEngineRPM, 0L);
    }

    public double getObcCoolantLevel() {
        return this.getDoubleValue(FLD_obcCoolantLevel, 0.0);
    }

    public double getObcCoolantTemperature() {
        return this.getDoubleValue(FLD_obcCoolantTemp, 0.0);
    }

    public double getObcOilLevel() {
        return this.getDoubleValue(FLD_obcOilLevel, 0.0);
    }

    public double getObcOilPressure() {
        return this.getDoubleValue(FLD_obcOilPressure, 0.0);
    }

    public double getObcFuelLevel() {
        return this.getDoubleValue(FLD_obcFuelLevel, 0.0);
    }

    public double getObcFuelEconomy() {
        return this.getDoubleValue(FLD_obcFuelEconomy, 0.0);
    }

    public double getObcFuelTotal() {
        return this.getDoubleValue(FLD_obcFuelTotal, 0.0);
    }

    public double getObcFuelIdle() {
        return this.getDoubleValue(FLD_obcFuelIdle, 0.0);
    }

    private static int[] _ParseCellTower(byte[] b) {
        Payload p = new Payload(b);
        if (p.getAvailableReadLength() <= 0) {
            return new int[0];
        }
        int MCC = p.readUInt(2, 0);
        int MNC = p.readUInt(2, 0);
        int LAC = p.readUInt(2, 0);
        int CID = p.readUInt(4, 0);
        if (p.getAvailableReadLength() <= 0) {
            return new int[]{MCC, MNC, LAC, CID};
        }
        int TAV = p.readUInt(1, 0);
        if (p.getAvailableReadLength() <= 0) {
            return new int[]{MCC, MNC, LAC, CID, TAV};
        }
        int RXL = p.readUInt(1, 0);
        if (p.getAvailableReadLength() <= 0) {
            return new int[]{MCC, MNC, LAC, CID, TAV, RXL};
        }
        int ARF = p.readUInt(2, 0);
        if (p.getAvailableReadLength() <= 0) {
            return new int[]{MCC, MNC, LAC, CID, TAV, RXL, ARF};
        }
        int RAT = p.readUInt(2, 0);
        return new int[]{MCC, MNC, LAC, CID, TAV, RXL, ARF, RAT};
    }

    public int[] getCellTower_0() {
        byte[] b = this.getByteValue(FLD_cellTower_0, EMPTY_BYTE_ARRAY, 0);
        return DMTPGeoEvent._ParseCellTower(b);
    }

    public int[] getCellTower_1() {
        byte[] b = this.getByteValue(FLD_cellTower_1, EMPTY_BYTE_ARRAY, 0);
        return DMTPGeoEvent._ParseCellTower(b);
    }

    public int[] getCellTower_2() {
        byte[] b = this.getByteValue(FLD_cellTower_2, EMPTY_BYTE_ARRAY, 0);
        return DMTPGeoEvent._ParseCellTower(b);
    }

    public int[] getCellTower_3() {
        byte[] b = this.getByteValue(FLD_cellTower_3, EMPTY_BYTE_ARRAY, 0);
        return DMTPGeoEvent._ParseCellTower(b);
    }

    public long getSequence() {
        return this.getLongValue(FLD_sequence, -1L);
    }

    public int getSequenceLength() {
        return (int)this.getLongValue(FLD_sequenceLength, 0L);
    }

    public String getRawData() {
        return this.getStringValue(FLD_rawData, "");
    }

    private String _getEventValueString(String key, Object val) {
        if (key == null) {
            return null;
        }
        if (key.startsWith(FLD_statusCode)) {
            if (val instanceof Number) {
                StringBuffer sb = new StringBuffer();
                int n = ((Number)val).intValue();
                String code = StringTools.toHexString((long)n, (int)16);
                sb.append("[0x").append(code).append("] ");
                sb.append(StatusCodes.GetCodeDescription(n));
                return sb.toString();
            }
        } else if (key.startsWith(FLD_timestamp)) {
            if (val instanceof Number) {
                StringBuffer sb = new StringBuffer();
                long n = ((Number)val).longValue();
                sb.append("[").append(n).append("] ");
                sb.append(new DateTime(n).toString());
                return sb.toString();
            }
        } else if (key.startsWith(FLD_speedKPH)) {
            if (val instanceof Number) {
                StringBuffer sb = new StringBuffer();
                double n = ((Number)val).doubleValue();
                sb.append("[");
                sb.append(StringTools.format((double)n, (String)"#0.0"));
                sb.append(" kph] ");
                sb.append(StringTools.format((double)(n * 0.621371192237334), (String)"#0.0"));
                sb.append(" mph");
                return sb.toString();
            }
        } else if (key.startsWith(FLD_altitude)) {
            if (val instanceof Number) {
                StringBuffer sb = new StringBuffer();
                double n = ((Number)val).doubleValue();
                sb.append("[");
                sb.append(StringTools.format((double)n, (String)"#0.0"));
                sb.append(" meters] ");
                sb.append(StringTools.format((double)(n * 3.280839895013123), (String)"#0.0"));
                sb.append(" feet");
                return sb.toString();
            }
        } else if (key.startsWith(FLD_distanceKM) || key.startsWith(FLD_odometerKM) || key.startsWith(FLD_obcDistanceKM)) {
            if (val instanceof Number) {
                StringBuffer sb = new StringBuffer();
                double n = ((Number)val).doubleValue();
                sb.append("[");
                sb.append(StringTools.format((double)n, (String)"#0.0"));
                sb.append(" km] ");
                sb.append(StringTools.format((double)(n * 0.621371192237334), (String)"#0.0"));
                sb.append(" miles");
                return sb.toString();
            }
        } else if (key.startsWith(FLD_sensor32LO) || key.startsWith(FLD_sensor32HI)) {
            if (val instanceof Number) {
                StringBuffer sb = new StringBuffer();
                long n = ((Number)val).longValue();
                sb.append("[0x").append(StringTools.toHexString((long)n, (int)32)).append("] ");
                sb.append(n);
                return sb.toString();
            }
        } else if (key.startsWith(FLD_tempLO) || key.startsWith(FLD_tempHI) || key.startsWith(FLD_tempAV)) {
            if (val instanceof Number) {
                StringBuffer sb = new StringBuffer();
                double n = ((Number)val).doubleValue();
                sb.append("[");
                sb.append(StringTools.format((double)n, (String)"#0.0"));
                sb.append(" C] ");
                sb.append(StringTools.format((double)(n * 1.8 + 32.0), (String)"#0.0"));
                sb.append(" F");
                return sb.toString();
            }
        } else {
            if (key.startsWith(FLD_obcFuelTotal) || key.startsWith(FLD_obcFuelIdle)) {
                StringBuffer sb = new StringBuffer();
                double liters = ((Number)val).doubleValue();
                sb.append("[");
                sb.append(StringTools.format((double)liters, (String)"#0.0"));
                sb.append(" liters] ");
                sb.append(StringTools.format((double)(liters * 0.264172052), (String)"#0.0"));
                sb.append(" gallons");
                return sb.toString();
            }
            if (key.startsWith(FLD_obcJ1708Fault) && val instanceof Number) {
                StringBuffer sb = new StringBuffer();
                long n = ((Number)val).longValue();
                int mid = (int)(n >> 24 & 0xFFL);
                int pidSid = (int)(n >> 8 & 0xFFFFL);
                int fmi = (int)(n >> 0 & 0xFFL);
                sb.append("[0x").append(StringTools.toHexString((long)n, (int)32)).append("] ");
                if (n != 0L) {
                    sb.append("MID=").append(mid).append(" ");
                    if ((pidSid & 0x8000) != 0) {
                        sb.append("SID=").append(pidSid & 0xFFF);
                        sb.append(" ");
                    } else {
                        sb.append("PID=").append(pidSid & 0xFFF);
                        sb.append("[").append(pidSid & 0xFF).append("]");
                        sb.append(" ");
                    }
                    sb.append("FMI=").append(fmi);
                }
                return sb.toString();
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Event:\n");
        DMTPGeoEvent gev = this;
        Iterator keyIter = gev.keyIterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            sb.append("  ").append(key);
            sb.append(StringTools.replicateString((String)" ", (int)(14 - key.length())));
            sb.append(": ");
            Object val = gev.getEventValue(key);
            String valStr = this._getEventValueString(key, val);
            if (valStr != null) {
                sb.append(valStr);
            } else if (val instanceof Long) {
                long n = ((Number)val).longValue();
                String ns = (n & 0xFFFFFFFF00000000L) != 0L ? StringTools.toHexString((long)n, (int)64) : ((n & 0xFFFFFFFFFFFF0000L) != 0L ? StringTools.toHexString((long)n, (int)32) : StringTools.toHexString((long)n, (int)16));
                sb.append("[0x").append(ns).append("] ");
                sb.append(n);
            } else if (val instanceof Double) {
                double n = ((Number)val).doubleValue();
                sb.append(StringTools.format((double)n, (String)"#0.00"));
            } else if (val instanceof byte[]) {
                byte[] b = (byte[])val;
                sb.append("0x");
                sb.append(StringTools.toHexString((byte[])b));
            } else if (val instanceof GeoPoint) {
                sb.append(val.toString());
            } else if (val instanceof String) {
                sb.append((String)val);
            } else {
                sb.append("? ");
                sb.append(val.toString());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

