/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.codes;

import org.opengts.util.StringTools;

public class ServerErrors {
    public static final int NAK_OK = 0;
    public static final int NAK_ID_INVALID = 61457;
    public static final int NAK_ACCOUNT_INVALID = 61473;
    public static final int NAK_ACCOUNT_INACTIVE = 61474;
    public static final int NAK_ACCOUNT_ERROR = 61475;
    public static final int NAK_DEVICE_INVALID = 61489;
    public static final int NAK_DEVICE_INACTIVE = 61490;
    public static final int NAK_DEVICE_ERROR = 61491;
    public static final int NAK_EXCESSIVE_CONNECTIONS = 61505;
    public static final int NAK_PACKET_HEADER = 61713;
    public static final int NAK_PACKET_TYPE = 61714;
    public static final int NAK_PACKET_LENGTH = 61715;
    public static final int NAK_PACKET_PAYLOAD = 61716;
    public static final int NAK_PACKET_ENCODING = 61717;
    public static final int NAK_PACKET_CHECKSUM = 61718;
    public static final int NAK_BLOCK_CHECKSUM = 62225;
    public static final int NAK_PROTOCOL_ERROR = 62226;
    public static final int NAK_FORMAT_DEFINITION_INVALID = 62481;
    public static final int NAK_FORMAT_NOT_SUPPORTED = 62497;
    public static final int NAK_FORMAT_NOT_RECOGNIZED = 62498;
    public static final int NAK_EXCESSIVE_EVENTS = 62513;
    public static final int NAK_DUPLICATE_EVENT = 62514;
    public static final int NAK_EVENT_ERROR = 62529;

    public static String getErrorDescription(int errCode) {
        switch (errCode) {
            case 0: {
                return "OK";
            }
            case 61457: {
                return "Invalid unique ID";
            }
            case 61473: {
                return "Invalid account ID";
            }
            case 61474: {
                return "Account inactive";
            }
            case 61475: {
                return "Account error";
            }
            case 61489: {
                return "Invalid device ID";
            }
            case 61490: {
                return "Device inactive";
            }
            case 61491: {
                return "Device error";
            }
            case 61505: {
                return "Excessive connections";
            }
            case 61713: {
                return "Invalid packet header";
            }
            case 61714: {
                return "Invalid packet type";
            }
            case 61715: {
                return "Invalid packet length";
            }
            case 61716: {
                return "Invalid packet payload";
            }
            case 61717: {
                return "Unsupported packet encoding";
            }
            case 61718: {
                return "Invalid packet checksum";
            }
            case 62225: {
                return "Invalid block checksum";
            }
            case 62226: {
                return "Protocol error";
            }
            case 62481: {
                return "Invalid custom format definition";
            }
            case 62497: {
                return "Custom formats not supported";
            }
            case 62498: {
                return "Custom format not recognized";
            }
            case 62513: {
                return "Excessive events";
            }
            case 62514: {
                return "Duplicate event";
            }
            case 62529: {
                return "Event error";
            }
        }
        return "Unknown [" + StringTools.toHexString((long)errCode, (int)16) + "]";
    }
}

