/*
 * Decompiled with CFR 0.152.
 */
package org.opendmtp.codes;

import java.util.HashMap;
import org.opengts.util.GeoPoint;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class PropCodes {
    public static final int GEOF_CMD_ADD_STD_2 = 16;
    public static final int GEOF_CMD_ADD_HIGH_2 = 17;
    public static final int GEOF_CMD_ADD_STD_N = 30;
    public static final int GEOF_CMD_ADD_HIGH_N = 31;
    public static final int GEOF_CMD_REMOVE = 32;
    public static final int GEOF_CMD_SAVE = 48;
    public static final int TYPE_TYPE_MASK = 61440;
    public static final int TYPE_SIZE_MASK = 15;
    public static final int TYPE_COMMAND = 4096;
    public static final int TYPE_STRING = 8192;
    public static final int TYPE_BINARY = 12288;
    public static final int TYPE_GPS = 16384;
    public static final int TYPE_BOOLEAN = 20480;
    public static final int TYPE_NUMERIC = 24576;
    public static final int TYPE_DEC = 256;
    public static final int TYPE_SIGNED = 2048;
    public static final int TYPE_UINT8 = 24577;
    public static final int TYPE_UINT16 = 24578;
    public static final int TYPE_INT16 = 26626;
    public static final int TYPE_UINT32 = 24580;
    public static final int TYPE_UDEC16 = 24834;
    public static final int TYPE_DEC16 = 26882;
    public static final int PROP_CFG_XPORT_PORT = 61201;
    public static final int PROP_CFG_XPORT_BPS = 61202;
    public static final int PROP_CFG_XPORT_DEBUG = 61213;
    public static final int PROP_CFG_GPS_PORT = 61217;
    public static final int PROP_CFG_GPS_BPS = 61218;
    public static final int PROP_CFG_GPS_MODEL = 61226;
    public static final int PROP_CFG_GPS_DEBUG = 61229;
    public static final int PROP_CFG_SERIAL0_PORT = 61233;
    public static final int PROP_CFG_SERIAL0_BPS = 61234;
    public static final int PROP_CFG_SERIAL0_DEBUG = 61245;
    public static final int PROP_CFG_SERIAL1_PORT = 61249;
    public static final int PROP_CFG_SERIAL1_BPS = 61250;
    public static final int PROP_CFG_SERIAL1_DEBUG = 61261;
    public static final int PROP_CFG_SERIAL2_PORT = 61265;
    public static final int PROP_CFG_SERIAL2_BPS = 61266;
    public static final int PROP_CFG_SERIAL2_DEBUG = 61277;
    public static final int PROP_CFG_SERIAL3_PORT = 61281;
    public static final int PROP_CFG_SERIAL3_BPS = 61282;
    public static final int PROP_CFG_SERIAL3_DEBUG = 61293;
    public static final int PROP_CMD_SAVE_PROPS = 61440;
    public static final int PROP_CMD_AUTHORIZE = 61442;
    public static final int PROP_CMD_STATUS_EVENT = 61457;
    public static final int PROP_CMD_SET_OUTPUT = 61489;
    public static final int PROP_CMD_RESET = 61695;
    public static final int PROP_STATE_PROTOCOL = 61696;
    public static final int PROP_STATE_FIRMWARE = 61697;
    public static final int PROP_STATE_COPYRIGHT = 61703;
    public static final int PROP_STATE_SERIAL = 61712;
    public static final int PROP_STATE_UNIQUE_ID = 61714;
    public static final int PROP_STATE_ACCOUNT_ID = 61716;
    public static final int PROP_STATE_DEVICE_ID = 61717;
    public static final int PROP_STATE_USER_ID = 61719;
    public static final int PROP_STATE_USER_TIME = 61720;
    public static final int PROP_STATE_TIME = 61729;
    public static final int PROP_STATE_GPS = 61731;
    public static final int PROP_STATE_GPS_DIAGNOSTIC = 61732;
    public static final int PROP_STATE_QUEUED_EVENTS = 61745;
    public static final int PROP_STATE_DEV_DIAGNOSTIC = 61761;
    public static final int PROP_COMM_SPEAK_FIRST = 62211;
    public static final int PROP_COMM_FIRST_BRIEF = 62213;
    public static final int PROP_COMM_FAILURE_DELAY = 62217;
    public static final int PROP_COMM_MAX_CONNECTIONS = 62225;
    public static final int PROP_COMM_MIN_XMIT_DELAY = 62226;
    public static final int PROP_COMM_MIN_XMIT_RATE = 62227;
    public static final int PROP_COMM_MAX_XMIT_RATE = 62229;
    public static final int PROP_COMM_MAX_DUP_EVENTS = 62231;
    public static final int PROP_COMM_MAX_SIM_EVENTS = 62232;
    public static final int PROP_COMM_SETTINGS = 62368;
    public static final int PROP_COMM_DMTP_HOST = 62369;
    public static final int PROP_COMM_DMTP_PORT = 62370;
    public static final int PROP_COMM_DNS_1 = 62371;
    public static final int PROP_COMM_DNS_2 = 62372;
    public static final int PROP_COMM_CONNECTION = 62373;
    public static final int PROP_COMM_APN_NAME = 62374;
    public static final int PROP_COMM_APN_SERVER = 62375;
    public static final int PROP_COMM_APN_USER = 62376;
    public static final int PROP_COMM_APN_PASSWORD = 62377;
    public static final int PROP_COMM_APN_PHONE = 62378;
    public static final int PROP_COMM_APN_SETTINGS = 62380;
    public static final int PROP_COMM_MIN_SIGNAL = 62381;
    public static final int PROP_COMM_ACCESS_PIN = 62383;
    public static final int PROP_COMM_CUSTOM_FORMATS = 62400;
    public static final int PROP_COMM_ENCODINGS = 62401;
    public static final int PROP_COMM_BYTES_READ = 62449;
    public static final int PROP_COMM_BYTES_WRITTEN = 62450;
    public static final int PROP_GPS_SAMPLE_RATE = 62737;
    public static final int PROP_GPS_ACQUIRE_WAIT = 62738;
    public static final int PROP_GPS_EXPIRATION = 62739;
    public static final int PROP_GPS_CLOCK_DELTA = 62741;
    public static final int PROP_GPS_ACCURACY = 62753;
    public static final int PROP_GPS_MIN_SPEED = 62754;
    public static final int PROP_GPS_DISTANCE_DELTA = 62769;
    public static final int PROP_CMD_GEOF_ADMIN = 62786;
    public static final int PROP_GEOF_COUNT = 62791;
    public static final int PROP_GEOF_VERSION = 62792;
    public static final int PROP_GEOF_ARRIVE_DELAY = 62794;
    public static final int PROP_GEOF_DEPART_DELAY = 62797;
    public static final int PROP_GEOF_CURRENT = 62801;
    public static final int PROP_CMD_GEOC_ADMIN = 62818;
    public static final int PROP_GEOC_ACTIVE_ID = 62823;
    public static final int PROP_GEOC_VIOLATION_INTRVL = 62826;
    public static final int PROP_GEOC_VIOLATION_COUNT = 62829;
    public static final int PROP_MOTION_START_TYPE = 63249;
    public static final int PROP_MOTION_START = 63250;
    public static final int PROP_MOTION_IN_MOTION = 63251;
    public static final int PROP_MOTION_STOP = 63252;
    public static final int PROP_MOTION_STOP_TYPE = 63253;
    public static final int PROP_MOTION_DORMANT_INTRVL = 63254;
    public static final int PROP_MOTION_DORMANT_COUNT = 63255;
    public static final int PROP_MOTION_EXCESS_SPEED = 63265;
    public static final int PROP_MOTION_MOVING_INTRVL = 63269;
    public static final int PROP_ODOMETER_0_VALUE = 63344;
    public static final int PROP_ODOMETER_1_VALUE = 63345;
    public static final int PROP_ODOMETER_2_VALUE = 63346;
    public static final int PROP_ODOMETER_3_VALUE = 63347;
    public static final int PROP_ODOMETER_4_VALUE = 63348;
    public static final int PROP_ODOMETER_5_VALUE = 63349;
    public static final int PROP_ODOMETER_6_VALUE = 63350;
    public static final int PROP_ODOMETER_7_VALUE = 63351;
    public static final int PROP_ODOMETER_0_LIMIT = 63360;
    public static final int PROP_ODOMETER_1_LIMIT = 63361;
    public static final int PROP_ODOMETER_2_LIMIT = 63362;
    public static final int PROP_ODOMETER_3_LIMIT = 63363;
    public static final int PROP_ODOMETER_4_LIMIT = 63364;
    public static final int PROP_ODOMETER_5_LIMIT = 63365;
    public static final int PROP_ODOMETER_6_LIMIT = 63366;
    public static final int PROP_ODOMETER_7_LIMIT = 63367;
    public static final int PROP_ODOMETER_0_GPS = 63376;
    public static final int PROP_ODOMETER_1_GPS = 63377;
    public static final int PROP_ODOMETER_2_GPS = 63378;
    public static final int PROP_ODOMETER_3_GPS = 63379;
    public static final int PROP_ODOMETER_4_GPS = 63380;
    public static final int PROP_ODOMETER_5_GPS = 63381;
    public static final int PROP_ODOMETER_6_GPS = 63382;
    public static final int PROP_ODOMETER_7_GPS = 63383;
    public static final int PROP_INPUT_STATE = 63745;
    public static final int PROP_INPUT_CONFIG_0 = 63760;
    public static final int PROP_INPUT_CONFIG_1 = 63761;
    public static final int PROP_INPUT_CONFIG_2 = 63762;
    public static final int PROP_INPUT_CONFIG_3 = 63763;
    public static final int PROP_INPUT_CONFIG_4 = 63764;
    public static final int PROP_INPUT_CONFIG_5 = 63765;
    public static final int PROP_INPUT_CONFIG_6 = 63766;
    public static final int PROP_INPUT_CONFIG_7 = 63767;
    public static final int PROP_INPUT_CONFIG_8 = 63768;
    public static final int PROP_INPUT_CONFIG_9 = 63769;
    public static final int PROP_INPUT_CONFIG_A = 63770;
    public static final int PROP_INPUT_CONFIG_B = 63771;
    public static final int PROP_INPUT_CONFIG_C = 63772;
    public static final int PROP_INPUT_CONFIG_D = 63773;
    public static final int PROP_INPUT_CONFIG_E = 63774;
    public static final int PROP_INPUT_CONFIG_F = 63775;
    public static final int PROP_OUTPUT_CONFIG_0 = 63792;
    public static final int PROP_OUTPUT_CONFIG_1 = 63793;
    public static final int PROP_OUTPUT_CONFIG_2 = 63794;
    public static final int PROP_OUTPUT_CONFIG_3 = 63795;
    public static final int PROP_OUTPUT_CONFIG_4 = 63796;
    public static final int PROP_OUTPUT_CONFIG_5 = 63797;
    public static final int PROP_OUTPUT_CONFIG_6 = 63798;
    public static final int PROP_OUTPUT_CONFIG_7 = 63799;
    public static final int PROP_ELAPSED_0_VALUE = 63856;
    public static final int PROP_ELAPSED_1_VALUE = 63857;
    public static final int PROP_ELAPSED_2_VALUE = 63858;
    public static final int PROP_ELAPSED_3_VALUE = 63859;
    public static final int PROP_ELAPSED_4_VALUE = 63860;
    public static final int PROP_ELAPSED_5_VALUE = 63861;
    public static final int PROP_ELAPSED_6_VALUE = 63862;
    public static final int PROP_ELAPSED_7_VALUE = 63863;
    public static final int PROP_ELAPSED_0_LIMIT = 63872;
    public static final int PROP_ELAPSED_1_LIMIT = 63873;
    public static final int PROP_ELAPSED_2_LIMIT = 63874;
    public static final int PROP_ELAPSED_3_LIMIT = 63875;
    public static final int PROP_ELAPSED_4_LIMIT = 63876;
    public static final int PROP_ELAPSED_5_LIMIT = 63877;
    public static final int PROP_ELAPSED_6_LIMIT = 63878;
    public static final int PROP_ELAPSED_7_LIMIT = 63879;
    public static final int PROP_UNDERVOLTAGE_LIMIT = 64257;
    public static final int PROP_SENSOR_CONFIG_0 = 64272;
    public static final int PROP_SENSOR_CONFIG_1 = 64273;
    public static final int PROP_SENSOR_CONFIG_2 = 64274;
    public static final int PROP_SENSOR_CONFIG_3 = 64275;
    public static final int PROP_SENSOR_CONFIG_4 = 64276;
    public static final int PROP_SENSOR_CONFIG_5 = 64277;
    public static final int PROP_SENSOR_CONFIG_6 = 64278;
    public static final int PROP_SENSOR_CONFIG_7 = 64279;
    public static final int PROP_SENSOR_RANGE_0 = 64288;
    public static final int PROP_SENSOR_RANGE_1 = 64289;
    public static final int PROP_SENSOR_RANGE_2 = 64290;
    public static final int PROP_SENSOR_RANGE_3 = 64291;
    public static final int PROP_SENSOR_RANGE_4 = 64292;
    public static final int PROP_SENSOR_RANGE_5 = 64293;
    public static final int PROP_SENSOR_RANGE_6 = 64294;
    public static final int PROP_SENSOR_RANGE_7 = 64295;
    public static final int PROP_TEMP_SAMPLE_INTRVL = 64352;
    public static final int PROP_TEMP_REPORT_INTRVL = 64355;
    public static final int PROP_TEMP_CONFIG_0 = 64368;
    public static final int PROP_TEMP_CONFIG_1 = 64369;
    public static final int PROP_TEMP_CONFIG_2 = 64370;
    public static final int PROP_TEMP_CONFIG_3 = 64371;
    public static final int PROP_TEMP_RANGE_0 = 64384;
    public static final int PROP_TEMP_RANGE_1 = 64385;
    public static final int PROP_TEMP_RANGE_2 = 64386;
    public static final int PROP_TEMP_RANGE_3 = 64387;
    public static final int PROP_MAX_BRAKE_G_FORCE = 64416;
    public static final int PROP_OBC_J1708_CONFIG = 64513;
    public static final int PROP_OBC_ODOM_OFFSET = 64514;
    public static final int PROP_OBC_J1708_VALUE = 64529;
    private static Attr[] propAttr = new Attr[]{new Attr(61201, 8192L, 1, "Transport ComPort"), new Attr(61202, 24580L, 1, "Transport BPS"), new Attr(61213, 20480L, 1, "Transport Debug"), new Attr(61217, 8192L, 1, "GPS Receiver ComPort"), new Attr(61218, 24580L, 1, "GPS Receiver BPS"), new Attr(61226, 8192L, 1, "GPS Receiver Model"), new Attr(61229, 20480L, 1, "GPS Receiver Debug"), new Attr(61233, 8192L, 1, "Serial-0 ComPort"), new Attr(61234, 24580L, 1, "Serial-0 BPS"), new Attr(61245, 20480L, 1, "Serial-0 Debug"), new Attr(61249, 8192L, 1, "Serial-1 ComPort"), new Attr(61250, 24580L, 1, "Serial-1 BPS"), new Attr(61261, 20480L, 1, "Serial-1 Debug"), new Attr(61265, 8192L, 1, "Serial-2 ComPort"), new Attr(61266, 24580L, 1, "Serial-2 BPS"), new Attr(61277, 20480L, 1, "Serial-2 Debug"), new Attr(61281, 8192L, 1, "Serial-3 ComPort"), new Attr(61282, 24580L, 1, "Serial-3 BPS"), new Attr(61293, 20480L, 1, "Serial-3 Debug"), new Attr(61440, 4096L, 1, "Command Save Properties"), new Attr(61442, 4096L, 1, "Command Authorize"), new Attr(61457, 4096L, 1, "Command Status Event"), new Attr(61489, 4096L, 1, "Command Set Output"), new Attr(61695, 4096L, 1, "Command Reset/Reboot"), new Attr(61696, 24577L, 3, "Protocol Version"), new Attr(61697, 8192L, 1, "Firmware Version"), new Attr(61703, 8192L, 1, "Copyright"), new Attr(61712, 8192L, 1, "Device Serial Number"), new Attr(61714, 12288L, 1, "Unique ID"), new Attr(61716, 8192L, 1, "Account ID"), new Attr(61717, 8192L, 1, "Device ID"), new Attr(61719, 8192L, 1, "User ID"), new Attr(61720, 24580L, 1, "User Login Time"), new Attr(61729, 24580L, 1, "Current Time"), new Attr(61731, 16384L, 1, "Current GPS Fix"), new Attr(61732, 24580L, 5, "GPS Diagnostics"), new Attr(61745, 24580L, 2, "Number of Queued Events"), new Attr(61761, 24580L, 5, "Device Diagnostics"), new Attr(62211, 20480L, 1, "Speak First"), new Attr(62213, 20480L, 1, "Speak First Brief"), new Attr(62217, 24580L, 2, "Connection failure delay"), new Attr(62225, 24577L, 3, "Max Connections"), new Attr(62226, 24578L, 1, "Min Transmit Delay"), new Attr(62227, 24580L, 1, "Min Transmit Rate"), new Attr(62229, 24580L, 1, "Max Transmit Rate"), new Attr(62231, 24577L, 1, "Max Duplex Events"), new Attr(62232, 24577L, 1, "Max Simplex Events"), new Attr(62368, 8192L, 1, "Comm Settings"), new Attr(62369, 8192L, 1, "Comm Host"), new Attr(62370, 24578L, 1, "Comm Port"), new Attr(62371, 8192L, 1, "DNS-1"), new Attr(62372, 8192L, 1, "DNS-2"), new Attr(62373, 8192L, 1, "Connection Name"), new Attr(62374, 8192L, 1, "APN Name"), new Attr(62375, 8192L, 1, "APN Server"), new Attr(62376, 8192L, 1, "APN Username"), new Attr(62377, 8192L, 1, "APN Password"), new Attr(62378, 8192L, 1, "APN Phone Number"), new Attr(62380, 8192L, 1, "APN Settings"), new Attr(62381, 26626L, 1, "Minimum Signal"), new Attr(62383, 12288L, 1, "Access PIN"), new Attr(62400, 24577L, 1, "Custom Formats"), new Attr(62401, 24577L, 1, "Supported Encodings"), new Attr(62449, 24580L, 1, "Bytes Read"), new Attr(62450, 24580L, 1, "Bytes Written"), new Attr(62737, 24578L, 1, "GPS Sample Rate"), new Attr(62738, 24578L, 1, "GPS Acquire Wait"), new Attr(62739, 24578L, 1, "GPS Expiration Time"), new Attr(62741, 20480L, 1, "GPS Clock Delta"), new Attr(62753, 24578L, 1, "GPS Accuracy"), new Attr(62754, 24834L, 1, "GPS Minimum Speed"), new Attr(62769, 24580L, 1, "GPS Distance Delta"), new Attr(62786, 4096L, 1, "Command Geofence Admin"), new Attr(62791, 24578L, 1, "Geofence Count"), new Attr(62792, 8192L, 1, "Geofence Version"), new Attr(62794, 24580L, 1, "Geofence Arrive Delay"), new Attr(62797, 24580L, 1, "Geofence Depart Delay"), new Attr(62801, 24580L, 1, "Geofence Current"), new Attr(62818, 4096L, 1, "Command Geocorridor Admin"), new Attr(62823, 24580L, 1, "Geocorridor Active ID"), new Attr(62826, 24578L, 1, "Geocorridor Violation Interval"), new Attr(62829, 24578L, 1, "Geocorridor Violation Count"), new Attr(63249, 24577L, 1, "Motion Start Type"), new Attr(63250, 24834L, 1, "Motion Start Definition"), new Attr(63251, 24578L, 1, "Motion In-Motion Interval"), new Attr(63252, 24578L, 1, "Motion Stop Delay"), new Attr(63253, 24577L, 1, "Motion Stop Type"), new Attr(63254, 24580L, 1, "Motion Dormant Interval"), new Attr(63255, 24578L, 1, "Motion Dormant Count"), new Attr(63265, 24834L, 1, "Motion Excess Speed"), new Attr(63269, 24578L, 1, "Moving Interval"), new Attr(63344, 24580L, 1, "Odometer-0 Value"), new Attr(63345, 24580L, 1, "Odometer-1 Value"), new Attr(63346, 24580L, 1, "Odometer-2 Value"), new Attr(63347, 24580L, 1, "Odometer-3 Value"), new Attr(63348, 24580L, 1, "Odometer-4 Value"), new Attr(63349, 24580L, 1, "Odometer-5 Value"), new Attr(63350, 24580L, 1, "Odometer-6 Value"), new Attr(63351, 24580L, 1, "Odometer-7 Value"), new Attr(63360, 24580L, 1, "Odometer-0 Limit"), new Attr(63361, 24580L, 1, "Odometer-1 Limit"), new Attr(63362, 24580L, 1, "Odometer-2 Limit"), new Attr(63363, 24580L, 1, "Odometer-3 Limit"), new Attr(63364, 24580L, 1, "Odometer-4 Limit"), new Attr(63365, 24580L, 1, "Odometer-5 Limit"), new Attr(63366, 24580L, 1, "Odometer-6 Limit"), new Attr(63367, 24580L, 1, "Odometer-7 Limit"), new Attr(63376, 16384L, 1, "Odometer-0 GPS"), new Attr(63377, 16384L, 1, "Odometer-1 GPS"), new Attr(63378, 16384L, 1, "Odometer-2 GPS"), new Attr(63379, 16384L, 1, "Odometer-3 GPS"), new Attr(63380, 16384L, 1, "Odometer-4 GPS"), new Attr(63381, 16384L, 1, "Odometer-5 GPS"), new Attr(63382, 16384L, 1, "Odometer-6 GPS"), new Attr(63383, 16384L, 1, "Odometer-7 GPS"), new Attr(63745, 24580L, 1, "Input State Mask"), new Attr(63760, 24580L, 2, "Input-0 Configuration"), new Attr(63761, 24580L, 2, "Input-1 Configuration"), new Attr(63762, 24580L, 2, "Input-2 Configuration"), new Attr(63763, 24580L, 2, "Input-3 Configuration"), new Attr(63764, 24580L, 2, "Input-4 Configuration"), new Attr(63765, 24580L, 2, "Input-5 Configuration"), new Attr(63766, 24580L, 2, "Input-6 Configuration"), new Attr(63767, 24580L, 2, "Input-7 Configuration"), new Attr(63768, 24580L, 2, "Input-8 Configuration"), new Attr(63769, 24580L, 2, "Input-9 Configuration"), new Attr(63770, 24580L, 2, "Input-A Configuration"), new Attr(63771, 24580L, 2, "Input-B Configuration"), new Attr(63772, 24580L, 2, "Input-C Configuration"), new Attr(63773, 24580L, 2, "Input-D Configuration"), new Attr(63774, 24580L, 2, "Input-E Configuration"), new Attr(63775, 24580L, 2, "Input-F Configuration"), new Attr(63792, 24580L, 2, ""), new Attr(63793, 24580L, 2, ""), new Attr(63794, 24580L, 2, ""), new Attr(63795, 24580L, 2, ""), new Attr(63796, 24580L, 2, ""), new Attr(63797, 24580L, 2, ""), new Attr(63798, 24580L, 2, ""), new Attr(63799, 24580L, 2, ""), new Attr(63856, 24580L, 1, ""), new Attr(63857, 24580L, 1, ""), new Attr(63858, 24580L, 1, ""), new Attr(63859, 24580L, 1, ""), new Attr(63860, 24580L, 1, ""), new Attr(63861, 24580L, 1, ""), new Attr(63862, 24580L, 1, ""), new Attr(63863, 24580L, 1, ""), new Attr(63872, 24580L, 1, ""), new Attr(63873, 24580L, 1, ""), new Attr(63874, 24580L, 1, ""), new Attr(63875, 24580L, 1, ""), new Attr(63876, 24580L, 1, ""), new Attr(63877, 24580L, 1, ""), new Attr(63878, 24580L, 1, ""), new Attr(63879, 24580L, 1, ""), new Attr(64257, 24580L, 1, ""), new Attr(64272, 24580L, 2, ""), new Attr(64273, 24580L, 2, ""), new Attr(64274, 24580L, 2, ""), new Attr(64275, 24580L, 2, ""), new Attr(64276, 24580L, 2, ""), new Attr(64277, 24580L, 2, ""), new Attr(64278, 24580L, 2, ""), new Attr(64279, 24580L, 2, ""), new Attr(64288, 24580L, 2, ""), new Attr(64289, 24580L, 2, ""), new Attr(64290, 24580L, 2, ""), new Attr(64291, 24580L, 2, ""), new Attr(64292, 24580L, 2, ""), new Attr(64293, 24580L, 2, ""), new Attr(64294, 24580L, 2, ""), new Attr(64295, 24580L, 2, ""), new Attr(64352, 24580L, 2, "Temperature Sample Interval"), new Attr(64355, 24580L, 2, "Temperature Report Interval"), new Attr(64368, 26626L, 2, "Temperature-0 Configuration"), new Attr(64369, 26626L, 2, "Temperature-1 Configuration"), new Attr(64370, 26626L, 2, "Temperature-2 Configuration"), new Attr(64371, 26626L, 2, "Temperature-3 Configuration"), new Attr(64384, 26882L, 2, "Temperature-0 Range"), new Attr(64385, 26882L, 2, "Temperature-1 Range"), new Attr(64386, 26882L, 2, "Temperature-2 Range"), new Attr(64387, 26882L, 2, "Temperature-3 Range"), new Attr(64416, 26882L, 1, "Max Brake G-Force"), new Attr(64513, 24580L, 1, "J1708 Configuration"), new Attr(64514, 24580L, 1, "J1708 Odometer Offset"), new Attr(64529, 12288L, 1, "J1708 Value")};
    private static HashMap<Integer, Attr> propsTable = new HashMap();

    private static void putAttr(Attr attr) {
        propsTable.put(new Integer(attr.getKey()), attr);
    }

    public static Attr getAttr(int key) {
        return propsTable.get(new Integer(key));
    }

    public static boolean isValidPropertyCode(int key) {
        return PropCodes.getAttr(key) != null;
    }

    public static String getPropertyDescription(int key) {
        Attr attr = PropCodes.getAttr(key);
        return attr != null ? attr.getDescription() : null;
    }

    public static Object[] parsePropertyValue(int key, String value) {
        if (value == null) {
            Print.logError((String)"Null value specified", (Object[])new Object[0]);
            return null;
        }
        Attr attr = PropCodes.getAttr(key);
        if (attr == null) {
            Print.logError((String)("Property not found: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        return attr.parseString(value);
    }

    public static byte[] encodePropertyData(int key, Object[] value) {
        byte[] data;
        block14: {
            int arrayLen;
            Attr attr;
            block17: {
                block16: {
                    block15: {
                        if (value == null || value.length == 0) {
                            Print.logError((String)"Null/empty value specified", (Object[])new Object[0]);
                            return null;
                        }
                        attr = PropCodes.getAttr(key);
                        if (attr == null) {
                            Print.logError((String)("Property not found: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
                            return null;
                        }
                        arrayLen = attr.getArrayLength();
                        if (arrayLen > value.length) {
                            Print.logError((String)("Invalid array length [expected " + arrayLen + "]"), (Object[])new Object[0]);
                            return null;
                        }
                        data = null;
                        if (!attr.isString()) break block15;
                        if (!(value[0] instanceof String)) break block14;
                        byte[] vs = StringTools.getBytes((String)((String)value[0]));
                        int vsLen = vs.length <= 253 ? vs.length : 253;
                        data = new byte[vsLen];
                        System.arraycopy(vs, 0, data, 0, vsLen);
                        break block14;
                    }
                    if (!attr.isBinary()) break block16;
                    if (!(value[0] instanceof byte[])) break block14;
                    byte[] vb = (byte[])value[0];
                    int vbLen = vb.length <= 253 ? vb.length : 253;
                    data = new byte[vbLen];
                    System.arraycopy(vb, 0, data, 0, vbLen);
                    break block14;
                }
                if (!attr.isGPS()) break block17;
                if (!(value[0] instanceof GeoPoint)) break block14;
                GeoPoint gp = (GeoPoint)value[0];
                data = new byte[8];
                GeoPoint.encodeGeoPoint((GeoPoint)gp, (byte[])data, (int)0, (int)data.length);
                break block14;
            }
            if (attr.isBoolean()) {
                int elemLen = attr.getTypeLength();
                int ofs = 0;
                data = new byte[elemLen * arrayLen];
                for (int i = 0; i < arrayLen; ++i) {
                    long val = 0L;
                    if (value[i] instanceof Boolean) {
                        val = (Boolean)value[i] != false ? 1L : 0L;
                    } else {
                        if (!(value[i] instanceof Number)) {
                            data = null;
                            break;
                        }
                        val = ((Number)value[i]).longValue() != 0L ? 1L : 0L;
                    }
                    int len = Payload.encodeLong((byte[])data, (int)ofs, (int)elemLen, (boolean)true, (long)val);
                    if (len != elemLen) {
                        data = null;
                        break;
                    }
                    ofs += elemLen;
                }
            } else if (attr.isNumeric()) {
                int elemLen = attr.getTypeLength();
                int ofs = 0;
                data = new byte[elemLen * arrayLen];
                for (int i = 0; i < arrayLen; ++i) {
                    long val = 0L;
                    if (!(value[i] instanceof Number)) {
                        data = null;
                        break;
                    }
                    Number v = (Number)value[i];
                    val = attr.isDecimal() ? Math.round(v.doubleValue() * 10.0) : v.longValue();
                    int len = Payload.encodeLong((byte[])data, (int)ofs, (int)elemLen, (boolean)true, (long)val);
                    if (len != elemLen) {
                        data = null;
                        break;
                    }
                    ofs += elemLen;
                }
            }
        }
        return data;
    }

    public static byte[] encodePropertyData(int key, long value) {
        return PropCodes.encodePropertyData(key, new long[]{value});
    }

    public static byte[] encodePropertyData(int key, long[] value) {
        if (value == null || value.length == 0) {
            Print.logError((String)"Null/empty value specified", (Object[])new Object[0]);
            return null;
        }
        Attr attr = PropCodes.getAttr(key);
        if (attr == null) {
            Print.logError((String)("Property not found: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        if (!attr.isNumeric() && !attr.isBoolean()) {
            Print.logError((String)("Property is not a numeric: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        int arrayLen = attr.getArrayLength();
        if (arrayLen > value.length) {
            Print.logError((String)("Invalid array length [expected " + arrayLen + "]"), (Object[])new Object[0]);
            return null;
        }
        int elemLen = attr.getTypeLength();
        byte[] data = new byte[elemLen * arrayLen];
        int ofs = 0;
        for (int i = 0; i < arrayLen; ++i) {
            long val = 0L;
            val = attr.isBoolean() ? (value[i] != 0L ? 1L : 0L) : (attr.isDecimal() ? value[i] * 10L : value[i]);
            int n = Payload.encodeLong((byte[])data, (int)ofs, (int)elemLen, (boolean)true, (long)val);
            if (n != elemLen) {
                return null;
            }
            ofs += elemLen;
        }
        return data;
    }

    public static byte[] encodePropertyData(int key, double value) {
        return PropCodes.encodePropertyData(key, new double[]{value});
    }

    public static byte[] encodePropertyData(int key, double[] value) {
        if (value == null || value.length == 0) {
            Print.logError((String)"Null/empty value specified", (Object[])new Object[0]);
            return null;
        }
        Attr attr = PropCodes.getAttr(key);
        if (attr == null) {
            Print.logError((String)("Property not found: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        if (!attr.isNumeric() && !attr.isBoolean()) {
            Print.logError((String)("Property is not numeric: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        int arrayLen = attr.getArrayLength();
        if (arrayLen > value.length) {
            Print.logError((String)("Invalid array length [expected " + arrayLen + "]"), (Object[])new Object[0]);
            return null;
        }
        int elemLen = attr.getTypeLength();
        byte[] data = new byte[elemLen * arrayLen];
        int ofs = 0;
        for (int i = 0; i < arrayLen; ++i) {
            long val = 0L;
            val = attr.isBoolean() ? (Math.round(value[i]) != 0L ? 1L : 0L) : (attr.isDecimal() ? Math.round(value[i] * 10.0) : Math.round(value[i]));
            int n = Payload.encodeLong((byte[])data, (int)ofs, (int)elemLen, (boolean)true, (long)val);
            if (n != elemLen) {
                return null;
            }
            ofs += elemLen;
        }
        return data;
    }

    public static byte[] encodePropertyData(int key, byte[] value) {
        if (value == null) {
            Print.logError((String)"Null/empty value specified", (Object[])new Object[0]);
            return null;
        }
        Attr attr = PropCodes.getAttr(key);
        if (attr == null) {
            Print.logError((String)("Property not found: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        if (!attr.isBinary()) {
            Print.logError((String)("Property is not a byte array: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        byte[] vb = value;
        int vbLen = vb.length <= 253 ? vb.length : 253;
        byte[] data = new byte[vbLen];
        int ofs = 0;
        System.arraycopy(vb, 0, data, ofs, vbLen);
        return data;
    }

    public static byte[] encodePropertyData(int key, String value) {
        if (value == null) {
            Print.logError((String)"Null value specified", (Object[])new Object[0]);
            return null;
        }
        Attr attr = PropCodes.getAttr(key);
        if (attr == null) {
            Print.logError((String)("Property not found: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        if (!attr.isString()) {
            Print.logError((String)("Property is not a String: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        byte[] vs = StringTools.getBytes((String)value);
        int vsLen = vs.length <= 253 ? vs.length : 253;
        byte[] data = new byte[vsLen];
        int ofs = 0;
        System.arraycopy(vs, 0, data, ofs, vsLen);
        return data;
    }

    public static byte[] encodePropertyData(int key, GeoPoint value) {
        return PropCodes._encodePropertyData(key, value, true);
    }

    private static byte[] _encodePropertyData(int key, GeoPoint value, boolean hiRes) {
        if (value == null) {
            Print.logError((String)"Null value specified", (Object[])new Object[0]);
            return null;
        }
        Attr attr = PropCodes.getAttr(key);
        if (attr == null) {
            Print.logError((String)("Property not found: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        if (!attr.isGPS()) {
            Print.logError((String)("Property is not a GPS point: 0x" + StringTools.toHexString((int)key)), (Object[])new Object[0]);
            return null;
        }
        byte[] data = new byte[hiRes ? 8 : 6];
        return GeoPoint.encodeGeoPoint((GeoPoint)value, (byte[])data, (int)0, (int)data.length);
    }

    static {
        for (int i = 0; i < propAttr.length; ++i) {
            PropCodes.putAttr(propAttr[i]);
        }
    }

    private static class Attr {
        private int key = 0;
        private long type = 0L;
        private int arrayCount = 0;
        private String descript = null;

        public Attr(int key, long type, int array, String desc) {
            this.key = key;
            this.type = type;
            this.arrayCount = array > 0 ? array : 1;
            this.descript = desc;
        }

        public int getKey() {
            return this.key;
        }

        public long getType() {
            return this.type;
        }

        public boolean isCommand() {
            return (this.type & 0xF000L) == 4096L;
        }

        public boolean isNumeric() {
            return (this.type & 0xF000L) == 24576L;
        }

        public boolean isDecimal() {
            return this.isNumeric() && (this.type & 0x100L) != 0L;
        }

        public boolean isString() {
            return (this.type & 0xF000L) == 8192L;
        }

        public boolean isBinary() {
            return (this.type & 0xF000L) == 12288L;
        }

        public boolean isBoolean() {
            return (this.type & 0xF000L) == 20480L;
        }

        public boolean isGPS() {
            return (this.type & 0xF000L) == 16384L;
        }

        public int getTypeLength() {
            int t = (int)(this.type & 0xF000L);
            switch (t) {
                case 4096: {
                    return -1;
                }
                case 8192: {
                    return 1;
                }
                case 12288: {
                    return 1;
                }
                case 16384: {
                    return 1;
                }
                case 20480: {
                    return 1;
                }
                case 24576: {
                    return (int)(this.type & 0xFL);
                }
            }
            return -1;
        }

        public int getArrayLength() {
            return this.arrayCount;
        }

        public String getDescription() {
            return this.descript != null ? this.descript : "";
        }

        public Object[] parseString(String value) {
            if (value == null || this.isCommand()) {
                Print.logError((String)("Invalid value or property: 0x" + StringTools.toHexString((int)this.getKey())), (Object[])new Object[0]);
                return null;
            }
            int arrayLen = this.getArrayLength();
            String[] val = null;
            if (arrayLen == 1) {
                val = new String[]{value};
            } else {
                val = StringTools.parseArray((String)value);
                if (val.length != arrayLen) {
                    Print.logError((String)("Invalid array length [expected " + arrayLen + ", found=" + val.length + "]"), (Object[])new Object[0]);
                    return null;
                }
            }
            Object[] obj = null;
            block0 : switch ((int)(this.getType() & 0xF000L)) {
                case 8192: {
                    obj = new Object[]{val[0]};
                    break;
                }
                case 12288: {
                    if (!StringTools.isHex((String)val[0], (boolean)true)) break;
                    obj = new Object[]{StringTools.parseHex((String)val[0], (byte[])new byte[0])};
                    break;
                }
                case 16384: {
                    if (val[0].indexOf("/") <= 0) break;
                    obj = new Object[]{new GeoPoint(val[0])};
                    break;
                }
                case 20480: {
                    obj = new Object[arrayLen];
                    for (int i = 0; i < arrayLen; ++i) {
                        String v = val[i].trim();
                        if (!StringTools.isBoolean((String)v, (boolean)true)) {
                            Print.logError((String)("Invalid boolean value: " + v), (Object[])new Object[0]);
                            obj = null;
                            break block0;
                        }
                        obj[i] = new Boolean(StringTools.parseBoolean((String)v, (boolean)false));
                    }
                    break;
                }
                case 24576: {
                    obj = new Object[arrayLen];
                    for (int i = 0; i < arrayLen; ++i) {
                        String v = val[i].trim();
                        if (this.isDecimal()) {
                            if (StringTools.isDouble((String)v, (boolean)true)) {
                                obj[i] = new Double(StringTools.parseDouble((String)v, (double)0.0));
                                continue;
                            }
                            Print.logError((String)("Invalid decimal value: " + v), (Object[])new Object[0]);
                            obj = null;
                            break block0;
                        }
                        if (StringTools.isLong((String)v, (boolean)true)) {
                            obj[i] = new Long(StringTools.parseLong((String)v, (long)0L));
                            continue;
                        }
                        Print.logError((String)("Invalid integer value: " + v), (Object[])new Object[0]);
                        obj = null;
                        break block0;
                    }
                    break;
                }
            }
            return obj;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDescription());
            sb.append(" [0x").append(StringTools.toHexString((long)this.getKey(), (int)16)).append("]");
            sb.append(" type=0x").append(StringTools.toHexString((long)this.getType(), (int)16));
            sb.append(" array=").append(this.getArrayLength());
            return sb.toString();
        }
    }
}

