/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.teltonika;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.servers.GPSEvent;
import org.opengts.servers.teltonika.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static boolean DEBUG_MODE = false;
    public static String[] UNIQUEID_PREFIX = null;
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static boolean SIMEVENT_ENGINEHOURS = true;
    public static long SIMEVENT_DIGITAL_INPUTS = 255L;
    public static boolean XLATE_LOCATON_INMOTION = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static boolean PACKET_LEN_END_OF_STREAM = false;
    public static int CODEC_GH3000 = 7;
    public static int CODEC_FMXXXX = 8;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    private Device device = null;
    private DataTransport dataXPort = null;
    private String mobileID = null;
    private boolean isDuplex = true;
    private InetAddress inetAddress = null;
    private String ipAddress = null;
    private int clientPort = 0;
    private static final int[] InputStatusCodes_ON = new int[]{62496, 62497, 62498, 62499, 62500, 62501, 62502, 62503, 62504, 62505, 62506, 62507, 62508, 62509, 62510, 62511};
    private static final int[] InputStatusCodes_OFF = new int[]{62528, 62529, 62530, 62531, 62532, 62533, 62534, 62535, 62536, 62537, 62538, 62539, 62540, 62541, 62542, 62543};
    private static final TimeZone gmtTimezone = DateTime.getGMTTimeZone();

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.mobileID = null;
        this.device = null;
        this.isDuplex = isTCP;
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public boolean isDuplex() {
        return this.isDuplex;
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        if (PACKET_LEN_END_OF_STREAM) {
            return -2;
        }
        return -1;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        String hex = StringTools.toHexString(pktBytes);
        String s = StringTools.toStringValue(pktBytes).trim();
        if (ListTools.isEmpty(pktBytes)) {
            Print.logWarn("Ignoring empty/null packet", new Object[0]);
        }
        if (this.isDuplex()) {
            return this.parseInsertRecord_TeltonikaFM_TCP(pktBytes);
        }
        return this.parseInsertRecord_TeltonikaFM_UDP(pktBytes, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] parseInsertRecord_TeltonikaFM_TCP(byte[] pktBytes) {
        Print.logInfo("Parsing(Teltonika FM): ", new Object[0]);
        if (pktBytes.length == 17) {
            this.mobileID = StringTools.toStringValue(pktBytes, 2);
            this.device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), this.mobileID);
            if (this.device == null) {
                Print.logWarn("Unregistered IMEI " + this.mobileID, new Object[0]);
                return "\u0000".getBytes();
            }
            Print.logInfo("Registered IMEI " + this.mobileID, new Object[0]);
            return "\u0001".getBytes();
        }
        if (StringTools.isBlank(this.mobileID)) {
            Print.logError("'IMEI' value is missing", new Object[0]);
            return null;
        }
        String accountID = this.device.getAccountID();
        String deviceID = this.device.getDeviceID();
        String uniqueID = this.device.getUniqueID();
        Payload p = new Payload(pktBytes);
        int tcpHeader = p.readInt(4, 0);
        int AVLpktLen = p.readInt(4, 0);
        int CodecID = p.readInt(1, 0);
        byte by = p.readInt(1, 0);
        boolean validGPS = true;
        long fixtime = 0L;
        int priority = 0;
        double longitude = 0.0;
        double latitude = 0.0;
        double altitudeM = 0.0;
        double headingDeg = 0.0;
        int numSats = 0;
        double speedKPH = 0.0;
        int EventIOID = 0;
        int NumOfIO = 0;
        int IOvalue = 0;
        int IOindex = 0;
        double AIN1 = 0.0;
        double AIN2 = 0.0;
        double AIN3 = 0.0;
        double AIN4 = 0.0;
        int statusCode = 61472;
        double engineHours = 0.0;
        double odomKM = 0.0;
        double batteryV = 0.0;
        long gpioInput = -1L;
        int inputMask = 0;
        for (int i = 1; i <= by; ++i) {
            List<Device.GeozoneTransition> zone;
            int batType;
            fixtime = p.readLong(8, 1262260800L) / 1000L;
            priority = p.readInt(1, 0);
            longitude = (double)p.readInt(4, 0) / 1.0E7;
            latitude = (double)p.readInt(4, 0) / 1.0E7;
            altitudeM = p.readInt(2, 0);
            headingDeg = p.readInt(2, 0);
            numSats = p.readInt(1, 0);
            speedKPH = p.readInt(2, 0);
            EventIOID = p.readInt(1, 0);
            NumOfIO = p.readInt(1, 0);
            if (EventIOID == 240) {
                statusCode = 61715;
            }
            if (EventIOID == 240) {
                statusCode = 61714;
            }
            if (EventIOID == 69) {
                statusCode = 64802;
            }
            if (EventIOID == 69) {
                // empty if block
            }
            if (EventIOID == 2) {
                statusCode = 62477;
            }
            if (EventIOID == 2) {
                statusCode = 62476;
            }
            if (EventIOID == 1) {
                statusCode = 62467;
            }
            if (EventIOID == 1) {
                statusCode = 62465;
            }
            for (int j = 1; j <= 8; j *= 2) {
                NumOfIO = p.readInt(1, 0);
                if (NumOfIO < 1) continue;
                block16: for (int k = 1; k <= NumOfIO; ++k) {
                    IOindex = p.readInt(1, 0);
                    IOvalue = p.readInt(j, 0);
                    switch (IOindex) {
                        case 1: {
                            if (IOvalue <= 0) continue block16;
                            inputMask = (int)((long)inputMask | 1L);
                            continue block16;
                        }
                        case 2: {
                            if (IOvalue <= 0) continue block16;
                            inputMask = (int)((long)inputMask | 2L);
                            continue block16;
                        }
                        case 3: {
                            if (IOvalue <= 0) continue block16;
                            inputMask = (int)((long)inputMask | 4L);
                            continue block16;
                        }
                        case 4: {
                            if (IOvalue <= 0) continue block16;
                            inputMask = (int)((long)inputMask | 8L);
                            continue block16;
                        }
                        case 69: {
                            if (IOvalue <= 0) continue block16;
                            inputMask = (int)((long)inputMask | 0x10L);
                            continue block16;
                        }
                        case 240: {
                            if (IOvalue <= 0) continue block16;
                            inputMask = (int)((long)inputMask | 0x20L);
                            continue block16;
                        }
                        case 9: {
                            AIN1 = IOvalue;
                            continue block16;
                        }
                        case 66: {
                            batteryV = (float)IOvalue / 1000.0f;
                        }
                    }
                }
            }
            gpioInput = inputMask;
            int n = batType = batteryV < 15.0 ? 12 : 24;
            if (fixtime <= 0L) {
                Print.logWarn("Invalid date. ", new Object[0]);
                fixtime = DateTime.getCurrentTimeSec();
            }
            if (validGPS && !GeoPoint.isValid(latitude, longitude)) {
                Print.logWarn("Invalid GPRMC lat/lon: " + latitude + "/" + longitude, new Object[0]);
                latitude = 0.0;
                longitude = 0.0;
                validGPS = false;
            }
            GeoPoint geoPoint = new GeoPoint(latitude, longitude);
            Print.logInfo("IMEI     : " + this.mobileID, new Object[0]);
            Print.logInfo("UniqueID  : " + uniqueID, new Object[0]);
            Print.logInfo("DeviceID  : " + accountID + "/" + deviceID, new Object[0]);
            Print.logInfo("Timestamp: " + fixtime + " [" + new DateTime(fixtime) + "]", new Object[0]);
            Print.logInfo("GPS      : " + geoPoint, new Object[0]);
            Print.logInfo("Record # : " + by, new Object[0]);
            if (statusCode == -1) {
                Print.logError("Ignoring EventCode. ", new Object[0]);
                return null;
            }
            if (statusCode == 0) {
                statusCode = speedKPH > 0.0 ? 61714 : 61472;
            } else if (XLATE_LOCATON_INMOTION && statusCode == 61472 && speedKPH > 0.0) {
                statusCode = 61714;
            }
            DataTransport dataXPort = this.device.getDataTransport();
            if (this.hasIPAddress() && !dataXPort.isValidIPAddress(this.getIPAddress())) {
                DTIPAddrList validIPAddr = dataXPort.getIpAddressValid();
                Print.logError("Invalid IP Address from device: " + this.getIPAddress() + " [expecting " + validIPAddr + "]", new Object[0]);
                return null;
            }
            dataXPort.setIpAddressCurrent(this.getIPAddress());
            dataXPort.setRemotePortCurrent(this.getRemotePort());
            dataXPort.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
            if (!dataXPort.getDeviceCode().equalsIgnoreCase(Main.getServerName())) {
                dataXPort.setDeviceCode(Main.getServerName());
            }
            if (speedKPH < MINIMUM_SPEED_KPH) {
                speedKPH = 0.0;
                headingDeg = 0.0;
            } else if (headingDeg < 0.0) {
                GeoPoint lastGP;
                headingDeg = 0.0;
                if (validGPS && this.device != null && GeoPoint.isValid(lastGP = this.device.getLastValidLocation())) {
                    headingDeg = lastGP.headingToPoint(geoPoint);
                }
            }
            Print.logInfo("Speed    : " + StringTools.format(speedKPH, "0.0") + " km/h " + headingDeg, new Object[0]);
            odomKM = odomKM <= 0.0 ? (ESTIMATE_ODOMETER && validGPS ? this.device.getNextOdometerKM(geoPoint) : this.device.getLastOdometerKM()) : this.device.adjustOdometerKM(odomKM);
            Print.logInfo("OdometerKM: " + odomKM, new Object[0]);
            if (SIMEVENT_GEOZONES && validGPS && (zone = this.device.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
                for (Device.GeozoneTransition z : zone) {
                    this.insertEventRecord(this.device, z.getTimestamp(), z.getStatusCode(), z.getGeozone(), geoPoint, 0L, 0.0, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV, engineHours);
                    Print.logInfo("Geozone    : " + z, new Object[0]);
                    if (z.getStatusCode() != statusCode) continue;
                    Print.logDebug("StatusCode already inserted: 0x" + StatusCodes.GetHex(statusCode), new Object[0]);
                    statusCode = -1;
                }
            }
            if (!(statusCode < 0 || statusCode == -1 || statusCode == 61472 && this.hasSavedEvents())) {
                if (statusCode != 61472) {
                    this.insertEventRecord(this.device, fixtime, statusCode, null, geoPoint, 0L, 0.0, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV, engineHours);
                } else if (validGPS && !this.device.isNearLastValidLocation(geoPoint, MINIMUM_MOVED_METERS)) {
                    this.insertEventRecord(this.device, fixtime, statusCode, null, geoPoint, 0L, 0.0, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV, engineHours);
                }
            }
            if (DEBUG_MODE || this.device == null) continue;
            try {
                this.device.updateChangedEventFields();
            }
            catch (DBException dbe) {
                Print.logException("Unable to update Device: " + accountID + "/" + deviceID, dbe);
            }
            continue;
        }
        byte[] rtnbytes = new byte[]{0, 0, 0, by};
        return rtnbytes;
    }

    private byte[] parseInsertRecord_TeltonikaFM_UDP(byte[] pktBytes, String s) {
        Print.logInfo("Parsing(Teltonika FM): ", new Object[0]);
        String mobileID = null;
        String hexstring = new String();
        hexstring = null;
        String tmpstring = new String();
        tmpstring = null;
        char[] IMEI = new char[40];
        int[] intIMEI = new int[40];
        String headerstr = "000F";
        String tcpheaderstr = "00000000";
        hexstring = StringTools.toHexString(pktBytes);
        int indexSTARTofIMEI = hexstring.indexOf("000F") + 4;
        int indexavlpacketID = hexstring.indexOf("000F") + 2;
        int indexENDofIMEI = hexstring.indexOf("08", indexSTARTofIMEI - 1);
        int indexAvlData = indexENDofIMEI + 4;
        int indexGPSdata = indexAvlData + 18;
        boolean i = false;
        boolean j = false;
        mobileID = hexstring.substring(indexavlpacketID, indexENDofIMEI);
        mobileID = s.substring(6, 22).trim();
        tmpstring = hexstring.substring(indexAvlData, indexAvlData + 16);
        long fixtime = Long.parseLong(tmpstring, 16);
        BigDecimal d_fixtime = new BigDecimal(fixtime);
        fixtime = d_fixtime.movePointLeft(3).longValue();
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd,yyyy HH:mm");
        Date resultdate = new Date(fixtime);
        tmpstring = hexstring.substring(indexGPSdata, indexGPSdata + 8);
        long longitude_L = Long.parseLong(tmpstring, 16);
        BigDecimal d_longitude = new BigDecimal(longitude_L);
        double longitude = d_longitude.movePointLeft(7).doubleValue();
        tmpstring = hexstring.substring(indexGPSdata + 8, indexGPSdata + 16);
        long latitude_L = Long.parseLong(tmpstring, 16);
        BigDecimal d_latitude = new BigDecimal(latitude_L);
        double latitude = d_latitude.movePointLeft(7).doubleValue();
        tmpstring = hexstring.substring(indexGPSdata + 16, indexGPSdata + 20);
        long altitudeM_L = Long.parseLong(tmpstring, 16);
        double altitudeM = altitudeM_L;
        tmpstring = hexstring.substring(indexGPSdata + 26, indexGPSdata + 30);
        long speedKPH_L = Long.parseLong(tmpstring, 16);
        double speedKPH = speedKPH_L;
        double heading = 0.0;
        int statusCode = 61472;
        if (StringTools.isBlank(mobileID)) {
            Print.logWarn("MobileID not specified!", new Object[0]);
            return null;
        }
        GPSEvent gpsEvent = new GPSEvent(Main.getServerConfig(), this.ipAddress, this.clientPort, mobileID);
        Device device = gpsEvent.getDevice();
        if (device == null) {
            return null;
        }
        gpsEvent.setTimestamp(fixtime);
        gpsEvent.setStatusCode(statusCode);
        gpsEvent.setLatitude(latitude);
        gpsEvent.setLongitude(longitude);
        gpsEvent.setSpeedKPH(speedKPH);
        gpsEvent.setHeading(heading);
        gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(gpsEvent)) {
            return "0005ABCD01+hexstring.substring(indexSTARTofIMEI,indexavlpacketID+2)+39E".getBytes();
        }
        return ("0005ABCD01" + hexstring.substring(indexavlpacketID, indexavlpacketID + 2) + "1E" + "\n").getBytes();
    }

    private boolean parseInsertRecord_Common(GPSEvent gpsEvent) {
        long fixtime = gpsEvent.getTimestamp();
        int statusCode = gpsEvent.getStatusCode();
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date/time", new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
            gpsEvent.setTimestamp(fixtime);
        }
        if (!gpsEvent.isValidGeoPoint()) {
            Print.logWarn("Invalid GPRMC lat/lon: " + gpsEvent.getLatitude() + "/" + gpsEvent.getLongitude(), new Object[0]);
            gpsEvent.setLatitude(0.0);
            gpsEvent.setLongitude(0.0);
        }
        GeoPoint geoPoint = gpsEvent.getGeoPoint();
        if (gpsEvent.getSpeedKPH() < MINIMUM_SPEED_KPH) {
            gpsEvent.setSpeedKPH(0.0);
            gpsEvent.setHeading(0.0);
        }
        Device device = gpsEvent.getDevice();
        double odomKM = 0.0;
        odomKM = odomKM <= 0.0 ? (ESTIMATE_ODOMETER && geoPoint.isValid() ? device.getNextOdometerKM(geoPoint) : device.getLastOdometerKM()) : device.adjustOdometerKM(odomKM);
        gpsEvent.setOdometerKM(odomKM);
        gpsEvent.insertEventData(fixtime, statusCode);
        gpsEvent.updateDevice();
        return true;
    }

    private EventData createEventRecord(Device device, long gpsTime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitudeM, double odomKM, long gpioInput, double batteryV, double engineHours) {
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        EventData.Key evKey = new EventData.Key(accountID, deviceID, gpsTime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeozone(geozone);
        evdb.setGeoPoint(geoPoint);
        evdb.setGpsAge(gpsAge);
        evdb.setHDOP(HDOP);
        evdb.setSatelliteCount(numSats);
        evdb.setSpeedKPH(speedKPH);
        evdb.setHeading(heading);
        evdb.setAltitude(altitudeM);
        evdb.setOdometerKM(odomKM);
        evdb.setInputMask(gpioInput);
        evdb.setBatteryVolts(batteryV);
        evdb.setEngineHours(engineHours);
        return evdb;
    }

    private void insertEventRecord(Device device, long gpsTime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitudeM, double odomKM, long gpioInput, double batteryV, double engineHours) {
        EventData evdb = this.createEventRecord(device, gpsTime, statusCode, geozone, geoPoint, gpsAge, HDOP, numSats, speedKPH, heading, altitudeM, odomKM, gpioInput, batteryV, engineHours);
        Print.logInfo("Event: [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        if (!DEBUG_MODE) {
            device.insertEventData(evdb);
            this.incrementSavedEventCount();
        }
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
            SIMEVENT_DIGITAL_INPUTS = dcsc.getSimulateDigitalInputs(SIMEVENT_DIGITAL_INPUTS) & 0xFFL;
            XLATE_LOCATON_INMOTION = dcsc.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            PACKET_LEN_END_OF_STREAM = dcsc.getBooleanProperty("teltonika.packetLenEndOfStream", PACKET_LEN_END_OF_STREAM);
        }
    }
}

