/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.opengts.Version;
import org.opengts.db.AccountRecord;
import org.opengts.db.AclEntry;
import org.opengts.util.FileTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.PixelDimension;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.war.tools.ComboMap;
import org.opengts.war.tools.ComboOption;
import org.opengts.war.tools.MenuGroup;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPage;

public abstract class WebPageAdaptor
implements WebPage {
    public static final String PARM_PAGE = "page";
    public static final String PARM_COMMAND = "page_cmd";
    public static final String PARM_ARGUMENT = "page_cmd_arg";
    public static final String PARM_CONTENT = "co";
    public static final String SUBACL_SEPARATOR = ":";
    public static final String SORTTABLE_SORTKEY = "sorttable_customkey";
    public static final String SORTTABLE_JS = "sorttable/sorttable.js";
    private static final boolean COMBOBOX_SHOW_DISABLED_IF_NOT_ENABLED = true;
    private PrivateLabel privateLabel = null;
    private String baseURI = null;
    private String jspURI = null;
    private String cssDir = "css";
    private MenuGroup menuGroup = null;
    private String iconImageURI = null;
    private String btnImageURI = null;
    private String btnImageALT = null;
    private String pageName = null;
    private String[] pageNavList = null;
    private String pageNavHTML = null;
    private String aclName = null;
    private boolean loginRequired = true;
    private int sortIndex = -1;
    private I18N.Text menuDesc = null;
    private I18N.Text menuHelp = null;
    private I18N.Text navDesc = null;
    private I18N.Text navTab = null;
    private String pagePropertyPrefix = null;
    private RTProperties pageProperties = null;

    public static boolean isValidID(RequestProperties reqState, String id) {
        if (StringTools.isBlank((String)id)) {
            return false;
        }
        return id.equals(WebPageAdaptor.getFilteredID(reqState, id));
    }

    public static String getFilteredID(RequestProperties reqState, String id) {
        PrivateLabel privLabel;
        if (id == null) {
            return "";
        }
        PrivateLabel privateLabel = privLabel = reqState != null ? reqState.getPrivateLabel() : null;
        if (privLabel == null || privLabel.globalValidateIDs()) {
            return StringTools.trim((String)AccountRecord.getFilteredID((String)id, (boolean)false, (boolean)true));
        }
        return StringTools.trim((String)id);
    }

    public static boolean isValidID(PrivateLabel privLabel, String id) {
        if (StringTools.isBlank((String)id)) {
            return false;
        }
        return id.equals(WebPageAdaptor.getFilteredID(privLabel, id));
    }

    public static String getFilteredID(PrivateLabel privLabel, String id) {
        if (id == null) {
            return "";
        }
        if (privLabel == null || privLabel.globalValidateIDs()) {
            return StringTools.trim((String)AccountRecord.getFilteredID((String)id, (boolean)false, (boolean)true));
        }
        return StringTools.trim((String)id);
    }

    public static String EncodeURL(RequestProperties reqState, URIArg url) {
        if (url == null) {
            return "";
        }
        return WebPageAdaptor.EncodeURL(reqState, url.toString());
    }

    public static String EncodeURL(RequestProperties reqState, String urlStr) {
        if (StringTools.isBlank((String)urlStr)) {
            return "";
        }
        if (reqState == null || reqState.getCookiesRequired()) {
            return urlStr;
        }
        HttpServletResponse response = reqState.getHttpServletResponse();
        return response.encodeURL(urlStr);
    }

    public static URIArg MakeURL(String baseURI) {
        return WebPageAdaptor.MakeURL(baseURI, null, null, null);
    }

    public static URIArg MakeURL(String baseURI, String page) {
        return WebPageAdaptor.MakeURL(baseURI, page, null, null);
    }

    public static URIArg MakeURL(String baseURI, String page, String cmd) {
        return WebPageAdaptor.MakeURL(baseURI, page, cmd, null);
    }

    public static URIArg MakeURL(String baseURI, String page, String cmd, String arg) {
        URIArg uri = new URIArg(baseURI);
        if (page != null) {
            uri.addArg(PARM_PAGE, page);
        }
        if (cmd != null) {
            uri.addArg(PARM_COMMAND, cmd);
        }
        if (arg != null) {
            uri.addArg(PARM_ARGUMENT, arg);
        }
        return uri;
    }

    public static String EncodeMakeURL(RequestProperties reqState, String baseURI) {
        return WebPageAdaptor.EncodeMakeURL(reqState, baseURI, null, null, null);
    }

    public static String EncodeMakeURL(RequestProperties reqState, String baseURI, String page, String cmd, String arg) {
        URIArg uri = WebPageAdaptor.MakeURL(baseURI, page, cmd, arg);
        if (reqState.getPageFrameContentOnly()) {
            uri.addArg(PARM_CONTENT, 1);
        }
        return WebPageAdaptor.EncodeURL(reqState, uri);
    }

    public static String FormRow_TextNote(String description, String note) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        sb.append("<td class='adminViewTableHeader' valign='top' nowrap>");
        sb.append(StringTools.blankDefault((String)description, (String)"&nbsp;"));
        sb.append("</td>");
        sb.append("<td class='adminViewTableData'>");
        sb.append(StringTools.blankDefault((String)StringTools.replace((String)StringTools.trim((String)note), (String)"\n", (String)"<BR>"), (String)"&nbsp;"));
        sb.append("</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    public static String FormRow_Separator(String description) {
        String d = !StringTools.isBlank((String)description) ? description : "&nbsp;";
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        sb.append("<td class='adminViewTableHeader' valign='top' nowrap>" + d + "</td>");
        sb.append("<td class='adminViewTableData'><hr></td>");
        sb.append("</tr>");
        return sb.toString();
    }

    public static String FormRow_Separator() {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        sb.append("<td class='adminViewTableHeader'><hr></td>");
        sb.append("<td class='adminViewTableData'><hr></td>");
        sb.append("</tr>");
        return sb.toString();
    }

    public static String FormRow_SubSeparator() {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        sb.append("<td class='adminViewTableHeader'><hr style='border:0; height:1px; color:#BBBBBB; background-color:#BBBBBB;'></td>");
        sb.append("<td class='adminViewTableData'>&nbsp;</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    private static String escapeValue(String val) {
        String v = StringTools.htmlFilterValue((Object)val);
        return v;
    }

    public static String Form_TextField(String name, boolean editable, String value, int size, int maxLen) {
        return WebPageAdaptor.Form_TextField(null, name, editable, value, null, size, maxLen, null);
    }

    public static String Form_TextField(String id, String name, boolean editable, String value, int size, int maxLen) {
        return WebPageAdaptor.Form_TextField(id, name, editable, value, null, size, maxLen, null);
    }

    public static String Form_TextField(String id, String name, boolean editable, String value, String onclick, int size, int maxLen) {
        return WebPageAdaptor.Form_TextField(id, name, editable, value, onclick, size, maxLen, null);
    }

    public static String Form_TextField(String id, String name, boolean editable, String value, String onclick, int size, int maxLen, String cssClass) {
        StringBuffer sb = new StringBuffer();
        if (maxLen < size) {
            maxLen = size;
        }
        String inputClass = null;
        inputClass = !StringTools.isBlank((String)cssClass) ? cssClass : (editable && !StringTools.isBlank((String)onclick) ? "textOnClick" : (editable ? "textInput" : "textReadOnly"));
        sb.append("<input");
        if (!StringTools.isBlank((String)id)) {
            sb.append(" id='" + id + "'");
        }
        sb.append(" class='" + inputClass + "'");
        sb.append(" type='text'");
        sb.append(" name='" + name + "'");
        sb.append(" value='" + WebPageAdaptor.escapeValue(value) + "'");
        if (!editable) {
            sb.append(" readonly");
        }
        if (size > 0 && maxLen > 0) {
            sb.append(" size='" + size + "'");
            sb.append(" maxlength='" + maxLen + "'");
        }
        if (editable) {
            String js = "return ignoreEnterKeyPress(event);";
            sb.append(" onKeyPress=\"" + js + "\"");
        }
        if (editable && !StringTools.isBlank((String)onclick)) {
            sb.append(" onclick=\"" + onclick + "\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public static String FormRow_TextField(String key, boolean editable, String description, String value, int size, int maxLen) {
        return WebPageAdaptor.FormRow_TextField(key, editable, description, value, size, maxLen, null);
    }

    public static String FormRow_TextField(String key, boolean editable, String description, String value, int size, int maxLen, String trailingHtml) {
        return WebPageAdaptor.FormRow_TextField(null, key, editable, description, value, null, size, maxLen, trailingHtml);
    }

    public static String FormRow_TextField(String id, String key, boolean editable, String description, String value, String onclick, int size, int maxLen, String trailingHtml) {
        StringBuffer sb = new StringBuffer();
        if (maxLen < size) {
            maxLen = size;
        }
        sb.append("<tr>");
        sb.append("<td class='adminViewTableHeader' nowrap>" + description + "</td>");
        sb.append("<td class='adminViewTableData'>");
        sb.append(WebPageAdaptor.Form_TextField(id, key, editable, value, onclick, size, maxLen));
        if (!StringTools.isBlank((String)trailingHtml)) {
            sb.append(" ").append(trailingHtml);
        }
        sb.append("</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    public static String Form_TextArea(String name, boolean editable, String value, int rows, int cols) {
        return WebPageAdaptor.Form_TextArea(null, name, editable, value, rows, cols);
    }

    public static String Form_TextArea(String id, String name, boolean editable, String value, int rows, int cols) {
        StringBuffer sb = new StringBuffer();
        String inputClass = editable ? "textAreaInput" : "textAreaReadOnly";
        sb.append("<textArea");
        if (!StringTools.isBlank((String)id)) {
            sb.append(" id='" + id + "'");
        }
        sb.append(" class='" + inputClass + "'");
        sb.append(" name='" + name + "'");
        if (!editable) {
            sb.append(" readonly");
        }
        sb.append(" rows='" + rows + "'");
        sb.append(" cols='" + cols + "'");
        if (editable) {
            // empty if block
        }
        sb.append(" nowrap>");
        sb.append(value);
        sb.append("</textArea>");
        return sb.toString();
    }

    public static String FormRow_TextArea(String key, boolean editable, String desc, String value, int rows, int cols) {
        return WebPageAdaptor.FormRow_TextArea(null, key, editable, desc, value, rows, cols);
    }

    public static String FormRow_TextArea(String id, String key, boolean editable, String desc, String value, int rows, int cols) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        if (StringTools.isBlank((String)desc)) {
            desc = "&nbsp;";
        }
        sb.append("<td class='adminViewTableHeader' valign='top' nowrap>" + desc + "</td>");
        sb.append("<td class='adminViewTableTextArea'>");
        sb.append(WebPageAdaptor.Form_TextArea(id, key, editable, value, rows, cols));
        sb.append("</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    public static String Form_ComboBox(String id, String key, boolean editable, ComboMap map, String selKey, String onchange, int size) {
        ComboOption opt = ComboMap.getComboOption(map, selKey);
        return WebPageAdaptor.Form_ComboBox(id, key, editable, map, opt, onchange, size);
    }

    public static String Form_ComboBox(String id, String key, boolean editable, ComboMap map, ComboOption selKey, String onchange, int size) {
        if (!editable) {
            // empty if block
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<select");
        if (!StringTools.isBlank((String)id)) {
            sb.append(" id='" + id + "'");
        }
        sb.append(" class='adminComboBox'");
        sb.append(" name='" + key + "'");
        if (size > 0) {
            sb.append(" style='width:" + size * 8 + "px;'");
        }
        if (editable) {
            if (!StringTools.isBlank((String)onchange)) {
                sb.append(" onchange=\"" + onchange + "\"");
            }
        } else {
            sb.append(" disabled");
        }
        sb.append(">");
        if (selKey == null) {
            selKey = new ComboOption("");
        }
        if (ListTools.isEmpty((Map)((Object)map))) {
            Print.logWarn((String)("ComboBox 'list' is empty: key=" + key), (Object[])new Object[0]);
            sb.append("<option value='" + selKey.getKey() + "' selected>" + WebPageAdaptor.FilterText(selKey.getDescription()) + "</option>");
        } else {
            for (String comboKey : map.keySet()) {
                String comboDesc = (String)map.get(comboKey);
                if (StringTools.isBlank((String)comboDesc)) {
                    comboDesc = comboKey;
                }
                String isSel = selKey.isMatch(comboKey) ? " selected" : "";
                sb.append("<option value='" + comboKey + "' " + isSel + ">" + WebPageAdaptor.FilterText(comboDesc) + "</option>");
            }
        }
        sb.append("</select>");
        return sb.toString();
    }

    public static String Form_ComboBox(String id, String key, boolean editable, ComboMap map, String selKey, String onchange) {
        ComboOption opt = ComboMap.getComboOption(map, selKey);
        return WebPageAdaptor.Form_ComboBox(id, key, editable, map, opt, onchange, -1);
    }

    public static String Form_ComboBox(String id, String key, boolean editable, ComboMap map, ComboOption sel, String onchange) {
        return WebPageAdaptor.Form_ComboBox(id, key, editable, map, sel, onchange, -1);
    }

    public static String FormRow_ComboBox(String key, boolean editable, String desc, String selKey, ComboMap map, String onchange, int size) {
        ComboOption opt = ComboMap.getComboOption(map, selKey);
        return WebPageAdaptor.FormRow_ComboBox(null, key, editable, desc, opt, map, onchange, size, null);
    }

    public static String FormRow_ComboBox(String key, boolean editable, String desc, ComboOption sel, ComboMap map, String onchange, int size) {
        return WebPageAdaptor.FormRow_ComboBox(null, key, editable, desc, sel, map, onchange, size, null);
    }

    public static String FormRow_ComboBox(String key, boolean editable, String desc, String selKey, ComboMap map, String onchange, int size, String trailingHtml) {
        ComboOption opt = ComboMap.getComboOption(map, selKey);
        return WebPageAdaptor.FormRow_ComboBox(null, key, editable, desc, opt, map, onchange, size, trailingHtml);
    }

    public static String FormRow_ComboBox(String id, String key, boolean editable, String desc, String selKey, ComboMap map, String onchange, int size, String trailingHtml) {
        ComboOption opt = ComboMap.getComboOption(map, selKey);
        return WebPageAdaptor.FormRow_ComboBox(id, key, editable, desc, opt, map, onchange, size, trailingHtml);
    }

    public static String FormRow_ComboBox(String key, boolean editable, String desc, ComboOption sel, ComboMap map, String onchange, int size, String trailingHtml) {
        return WebPageAdaptor.FormRow_ComboBox(null, key, editable, desc, sel, map, onchange, size, trailingHtml);
    }

    public static String FormRow_ComboBox(String id, String key, boolean editable, String desc, ComboOption sel, ComboMap map, String onchange, int size, String trailingHtml) {
        if (!editable) {
            // empty if block
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        if (StringTools.isBlank((String)desc)) {
            desc = "&nbsp;";
        }
        sb.append("<td class='adminViewTableHeader' nowrap>" + desc + "</td>");
        sb.append("<td class='adminViewTableData'>");
        sb.append(WebPageAdaptor.Form_ComboBox(id, key, editable, map, sel, onchange, size));
        if (!StringTools.isBlank((String)trailingHtml)) {
            sb.append(" ").append(trailingHtml);
        }
        sb.append("</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    public static String Form_CheckBox(String id, String name, boolean editable, boolean checked, String tooltip, String onchange) {
        StringBuffer sb = new StringBuffer();
        sb.append("<input type='checkbox' style='margin: 0px 0px 0px 0px;'");
        if (!StringTools.isBlank((String)id)) {
            sb.append(" id='" + id + "'");
        }
        if (!StringTools.isBlank((String)name)) {
            sb.append(" name='" + name + "'");
        }
        if (!editable) {
            sb.append(" disabled");
        }
        if (checked) {
            sb.append(" checked");
        }
        if (!StringTools.isBlank((String)onchange)) {
            sb.append(" onclick=\"" + onchange + "\"");
        }
        if (!StringTools.isBlank((String)tooltip)) {
            sb.append(" title=\"" + tooltip + "\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public static String FormRow_CheckBox(String desc, String id, String name, boolean editable, boolean checked, String tooltip, String onchange) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        if (StringTools.isBlank((String)desc)) {
            desc = "&nbsp;";
        }
        sb.append("<td class='adminViewTableHeader' nowrap>" + desc + "</td>");
        sb.append("<td class='adminViewTableData'>");
        sb.append(WebPageAdaptor.Form_CheckBox(id, name, editable, checked, tooltip, onchange));
        sb.append("</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    protected static String JS_alert(boolean inclJS, String msg) {
        if (!StringTools.isBlank((String)msg)) {
            StringBuffer sb = new StringBuffer();
            if (inclJS) {
                sb.append("javascript:");
            }
            String m = StringTools.replace((String)msg, (String)"\"", (String)"'");
            m = StringTools.replace((String)m, (String)"\n", (String)"\\n");
            m = StringTools.replace((String)m, (String)"<br>", (String)"\\n");
            m = StringTools.replace((String)m, (String)"<BR>", (String)"\\n");
            sb.append("alert(&quot;").append(m).append("&quot;);");
            return sb.toString();
        }
        return "";
    }

    protected static String Onclick_ConfirmDelete(Locale locale) {
        I18N i18n = I18N.getI18N(WebPageAdaptor.class, (Locale)locale);
        String confirmDel = i18n.getString("WebPageAdapter.confirmDelete", "Are you sure you want to delete the selected item?");
        return "onclick=\"return confirm('" + confirmDel + "');\"";
    }

    protected static String Onclick_ConfirmSelected(Locale locale, String itemOperation) {
        I18N i18n = I18N.getI18N(WebPageAdaptor.class, (Locale)locale);
        String confirmOp = i18n.getString("WebPageAdapter.confirmSelected", "Are you sure you want to {0} the selected item?", (Object)StringTools.trim((String)itemOperation));
        return "onclick=\"return confirm('" + confirmOp + "');\"";
    }

    protected static String Onclick_ConfirmOperation(Locale locale, String operation) {
        I18N i18n = I18N.getI18N(WebPageAdaptor.class, (Locale)locale);
        String confirmOp = i18n.getString("WebPageAdapter.confirmOperation", "Are you sure you want to {0}?", (Object)StringTools.trim((String)operation));
        return "onclick=\"return confirm('" + confirmOp + "');\"";
    }

    public static String FilterText(String s) {
        return s == null || s.equals("") ? "&nbsp;" : StringTools.htmlFilterText((Object)s);
    }

    public static String FilterValue(String s) {
        return StringTools.isBlank((String)s) ? "" : StringTools.htmlFilterValue((Object)s);
    }

    protected void postInit() {
    }

    @Override
    public boolean getIsEnabled() {
        return true;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public URIArg getPageURI() {
        return this.getPageURI(null, null);
    }

    public URIArg getPageURI(String command) {
        return this.getPageURI(command, null);
    }

    public URIArg getPageURI(String command, String cmdArg) {
        return WebPageAdaptor.MakeURL(this.getBaseURI(), this.getPageName(), command, cmdArg);
    }

    @Override
    public String getPageName() {
        return this.pageName;
    }

    @Override
    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public PrivateLabel getPrivateLabel() {
        return this.privateLabel;
    }

    public void setPrivateLabel(PrivateLabel privLabel) {
        this.privateLabel = privLabel;
    }

    @Override
    public String getJspURI() {
        return this.jspURI;
    }

    public void setJspURI(String jspURI) {
        this.jspURI = jspURI;
    }

    @Override
    public String getTarget() {
        return "_self";
    }

    @Override
    public PixelDimension getWindowDimension() {
        return null;
    }

    public String getCssDirectory() {
        return this.cssDir;
    }

    public void setCssDirectory(String cssDir) {
        this.cssDir = cssDir;
    }

    @Override
    public String getPageNavigationHTML(RequestProperties reqState) {
        return this.getPageNavigationHTML(reqState, true);
    }

    public String getPageNavigationHTML(RequestProperties reqState, boolean reInit) {
        if ((reInit || this.pageNavHTML == null) && this.hasPageNavigation()) {
            String[] pageNavNames = this.getPageNavigation();
            PrivateLabel privLbl = this.getPrivateLabel();
            if (privLbl == null) {
                Print.logWarn((String)("Page Navigation PrivateLabel undefined: " + this.getPageName()), (Object[])new Object[0]);
                this.pageNavHTML = "";
            } else {
                StringBuffer sb = new StringBuffer();
                for (int i = pageNavNames.length - 1; i >= 0; --i) {
                    String pageName = pageNavNames[i];
                    WebPage page = privLbl.getWebPage(pageName);
                    if (page != null) {
                        if (sb.length() > 0) {
                            sb.append(" | ");
                        }
                        String uri = WebPageAdaptor.EncodeURL(reqState, page.getPageURI());
                        String desc = page.getNavigationDescription(reqState);
                        sb.append("<a href='" + uri + "'>").append(desc).append("</a>");
                        continue;
                    }
                    String vers = Version.getVersion();
                    String plName = privLbl.getName();
                    Print.logWarn((String)("Page not found: " + pageName + " [v=" + vers + ", pl=" + plName + "]"), (Object[])new Object[0]);
                }
                this.pageNavHTML = sb.toString();
            }
        }
        return this.pageNavHTML;
    }

    public void setPageNavigation(String[] pageNav) {
        this.pageNavList = pageNav;
    }

    public boolean hasPageNavigation() {
        return !ListTools.isEmpty((Object[])this.getPageNavigation());
    }

    public String[] getPageNavigation() {
        if (this.pageNavList == null) {
            this.setPageNavigation(new String[]{this.getPageName()});
        }
        return this.pageNavList;
    }

    public void setLoginRequired(boolean required) {
        this.loginRequired = required;
    }

    @Override
    public boolean isLoginRequired() {
        return this.loginRequired;
    }

    @Override
    public boolean isOkToDisplay(RequestProperties reqState) {
        return true;
    }

    public void setAclName(String name) {
        this.aclName = StringTools.isBlank((String)name) || name.equals("*") ? null : name;
    }

    @Override
    public String getAclName() {
        return this.aclName;
    }

    @Override
    public String getAclName(String subAcl) {
        return AclEntry.CreateAclName((String)this.getAclName(), (String)subAcl);
    }

    public String[] getChildAclList() {
        return null;
    }

    @Override
    public boolean systemAdminOnly() {
        return false;
    }

    public void setMenuGroup(MenuGroup mg) {
        this.menuGroup = mg;
    }

    @Override
    public MenuGroup getMenuGroup(RequestProperties reqState) {
        return this.menuGroup;
    }

    @Override
    public String encodePageURL(RequestProperties reqState) {
        return this.encodePageURL(reqState, null, null);
    }

    @Override
    public String encodePageURL(RequestProperties reqState, String command) {
        return this.encodePageURL(reqState, command, null);
    }

    @Override
    public String encodePageURL(RequestProperties reqState, String command, String cmdArg) {
        URIArg uri = this.getPageURI(command, cmdArg);
        if (reqState.getPageFrameContentOnly()) {
            uri.addArg(PARM_CONTENT, 1);
        }
        return WebPageAdaptor.EncodeURL(reqState, uri);
    }

    @Override
    public abstract String getMenuName(RequestProperties var1);

    @Override
    public String getMenuIconImage() {
        return this.iconImageURI;
    }

    public void setMenuIconImage(String iconURI) {
        this.iconImageURI = StringTools.isBlank((String)iconURI) || iconURI.startsWith("!") ? null : iconURI;
    }

    @Override
    public String getMenuButtonImage() {
        return this.btnImageURI;
    }

    public void setMenuButtonImage(String btnURI) {
        this.btnImageURI = StringTools.isBlank((String)btnURI) || btnURI.startsWith("!") ? null : btnURI;
    }

    @Override
    public String getMenuButtonAltImage() {
        return this.btnImageALT;
    }

    public void setMenuButtonAltImage(String btnURI) {
        this.btnImageALT = StringTools.isBlank((String)btnURI) || btnURI.startsWith("!") ? null : btnURI;
    }

    public void setMenuDescription(I18N.Text menuDesc) {
        this.menuDesc = menuDesc;
    }

    @Override
    public String getMenuDescription(RequestProperties reqState, String parentMenuName) {
        if (this.menuDesc != null) {
            Locale locale = reqState != null ? reqState.getLocale() : null;
            return this.menuDesc.toString(locale);
        }
        return "";
    }

    protected String _getMenuDescription(RequestProperties reqState, String dft) {
        if (this.menuDesc != null) {
            Locale locale = reqState != null ? reqState.getLocale() : null;
            return this.menuDesc.toString(locale);
        }
        return dft;
    }

    public void setMenuHelp(I18N.Text menuHelp) {
        this.menuHelp = menuHelp;
    }

    @Override
    public String getMenuHelp(RequestProperties reqState, String parentMenuName) {
        if (this.menuHelp != null) {
            Locale locale = reqState != null ? reqState.getLocale() : null;
            return this.menuHelp.toString(locale);
        }
        return "";
    }

    protected String _getMenuHelp(RequestProperties reqState, String dft) {
        if (this.menuHelp != null) {
            Locale locale = reqState != null ? reqState.getLocale() : null;
            return this.menuHelp.toString(locale);
        }
        return dft;
    }

    public void setNavigationDescription(I18N.Text navDesc) {
        this.navDesc = navDesc;
    }

    @Override
    public String getNavigationDescription(RequestProperties reqState) {
        if (this.navDesc != null) {
            Locale locale = reqState != null ? reqState.getLocale() : null;
            return this.navDesc.toString(locale);
        }
        return "";
    }

    protected String _getNavigationDescription(RequestProperties reqState, String dft) {
        if (this.navDesc != null) {
            Locale locale = reqState != null ? reqState.getLocale() : null;
            return this.navDesc.toString(locale);
        }
        return dft;
    }

    public void setNavigationTab(I18N.Text navTab) {
        this.navTab = navTab;
    }

    @Override
    public String getNavigationTab(RequestProperties reqState) {
        if (this.navTab != null) {
            Locale locale = reqState != null ? reqState.getLocale() : null;
            return this.navTab.toString(locale);
        }
        return this.getNavigationDescription(reqState);
    }

    protected String _getNavigationTab(RequestProperties reqState, String dft) {
        if (this.navTab != null) {
            Locale locale = reqState != null ? reqState.getLocale() : null;
            return this.navTab.toString(locale);
        }
        return dft;
    }

    public void setRuntimePropertyKeyPrefix(String rtKeyPfx) {
        if (!StringTools.isBlank((String)rtKeyPfx)) {
            this.pagePropertyPrefix = rtKeyPfx;
            if (!this.pagePropertyPrefix.endsWith(".")) {
                this.pagePropertyPrefix = this.pagePropertyPrefix + ".";
            }
        } else {
            this.pagePropertyPrefix = null;
        }
    }

    public String getRuntimePropertyKeyPrefix() {
        return this.pagePropertyPrefix;
    }

    public boolean hasRuntimePropertyKeyPrefix() {
        return !StringTools.isBlank((String)this.pagePropertyPrefix);
    }

    public String getRuntimePropertyKey(String key) {
        if (!StringTools.isBlank((String)key) && this.hasRuntimePropertyKeyPrefix()) {
            return this.getRuntimePropertyKeyPrefix() + key;
        }
        return null;
    }

    public void setProperties(RTProperties rtp) {
        this.pageProperties = rtp;
    }

    @Override
    public RTProperties getProperties() {
        if (this.pageProperties == null) {
            this.pageProperties = new RTProperties();
            this.pageProperties.setPropertySeparatorChar(';');
        }
        return this.pageProperties;
    }

    public String getStringProperty(PrivateLabel privLabel, String key, String dft) {
        String val;
        if (StringTools.isBlank((String)key)) {
            return dft;
        }
        String K = this.getRuntimePropertyKey(key);
        if (RTConfig.hasProperty((String)K) && (val = RTConfig.getString((String)K, null)) != null) {
            return val;
        }
        RTProperties rtp = this.getProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getString(key, dft);
        }
        if (privLabel != null) {
            return privLabel.getStringProperty(key, dft);
        }
        return dft;
    }

    public double getDoubleProperty(PrivateLabel privLabel, String key, double dft) {
        double val;
        if (StringTools.isBlank((String)key)) {
            return dft;
        }
        String K = this.getRuntimePropertyKey(key);
        if (RTConfig.hasProperty((String)K) && (val = RTConfig.getDouble((String)K, (double)Double.NaN)) != Double.NaN) {
            return val;
        }
        RTProperties rtp = this.getProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getDouble(key, dft);
        }
        if (privLabel != null) {
            return privLabel.getDoubleProperty(key, dft);
        }
        return dft;
    }

    public long getLongProperty(PrivateLabel privLabel, String key, long dft) {
        long val;
        if (StringTools.isBlank((String)key)) {
            return dft;
        }
        String K = this.getRuntimePropertyKey(key);
        if (RTConfig.hasProperty((String)K) && (val = RTConfig.getLong((String)K, (long)Long.MIN_VALUE)) != Long.MIN_VALUE) {
            return val;
        }
        RTProperties rtp = this.getProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getLong(key, dft);
        }
        if (privLabel != null) {
            return privLabel.getLongProperty(key, dft);
        }
        return dft;
    }

    public boolean getBooleanProperty(PrivateLabel privLabel, String key, boolean dft) {
        if (StringTools.isBlank((String)key)) {
            return dft;
        }
        String K = this.getRuntimePropertyKey(key);
        if (RTConfig.hasProperty((String)K)) {
            boolean val = RTConfig.getBoolean((String)K, (boolean)false);
            return val;
        }
        RTProperties rtp = this.getProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getBoolean(key, dft);
        }
        if (privLabel != null) {
            return privLabel.getBooleanProperty(key, dft);
        }
        return dft;
    }

    @Override
    public abstract void writePage(RequestProperties var1, String var2) throws IOException;

    public static void writeCssLink(PrintWriter out, RequestProperties reqState, String cssFileName, String cssFileDir) throws IOException {
        File rootDir;
        PrivateLabel privLabel = reqState != null ? reqState.getPrivateLabel() : RequestProperties.NullPrivateLabel;
        boolean isAbsolute = URIArg.isAbsoluteURL((String)cssFileName);
        if (!isAbsolute && reqState != null && reqState.getEncodeEMailHTML() && (rootDir = RTConfig.getServletContextPath()) != null) {
            String cssRelPath;
            File cssAbsPath;
            String cssDir;
            String string = cssDir = !StringTools.isBlank((String)cssFileDir) ? cssFileDir : StringTools.trim((String)privLabel.getCssDirectory());
            if (cssDir.startsWith("/")) {
                cssDir = cssDir.substring(1);
            }
            if (!(cssAbsPath = new File(rootDir, cssRelPath = cssDir + "/" + cssFileName)).isFile()) {
                cssRelPath = "css/" + cssFileName;
                cssAbsPath = new File(rootDir, cssRelPath);
            }
            if (cssAbsPath.isFile()) {
                String css = StringTools.toStringValue((byte[])FileTools.readFile((File)cssAbsPath));
                if (!StringTools.isBlank((String)css)) {
                    out.write("<!-- Inline CSS file: " + cssFileName + " -->\n");
                    out.write("<style type='text/css'>\n");
                    out.write(css);
                    out.write("\n");
                    out.write("</style>\n");
                    return;
                }
            } else {
                Print.logWarn((String)("CSS file not found: " + cssAbsPath), (Object[])new Object[0]);
            }
        }
        out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        if (isAbsolute) {
            out.write(cssFileName);
        } else {
            out.write(privLabel.resolveCssFile(cssFileName, cssFileDir));
        }
        out.write("\"/>\n");
    }

    protected boolean SubmitMatch(String value, String expect) {
        return this.SubmitMatch(value, expect, null);
    }

    protected boolean SubmitMatch(String value, String expect, String alt) {
        if (StringTools.isBlank((String)value)) {
            return false;
        }
        if (value.equals(expect)) {
            return true;
        }
        if (alt != null && value.equals(alt)) {
            return true;
        }
        if (StringTools.isBlank((String)expect)) {
            return true;
        }
        return true;
    }
}

