/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opengts.Version;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.AccountString;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.StatusCode;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.DayNumber;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.war.tools.AttributeTools;
import org.opengts.war.tools.IDDescription;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.MapShape;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.PushpinIcon;
import org.opengts.war.tools.RTConfigContextListener;
import org.opengts.war.tools.WebPage;

public class RequestProperties
implements StringTools.KeyValueMap {
    public static final String HTML_LOGIN_FRAME = "loginFrame.html";
    public static final String _HTML_LOGIN_FRAME = "/loginFrame.html";
    public static final String HTML_LOGIN = "login.html";
    public static final String _HTML_LOGIN = "/login.html";
    public static final PrivateLabel NullPrivateLabel = new PrivateLabel("null");
    public static final int PAGE_FRAME_HEADER = 1;
    public static final int PAGE_FRAME_NAVIGATION = 2;
    public static final int PAGE_FRAME_FOOTER = 4;
    public static final int PAGE_FRAME_LEFT = 16;
    public static final int PAGE_FRAME_RIGHT = 32;
    public static final int PAGE_FRAME_CONTENT = 256;
    public static final int PAGE_FRAME_CONTENT_MENUBAR = 512;
    public static final int PAGE_FRAME_ALL = 823;
    private static String TRACK_BASE_URI = null;
    private HttpServletResponse response = null;
    private HttpServletRequest request = null;
    private boolean isSoapRequest = false;
    private String baseURI = null;
    private String webPageURI = null;
    private boolean cookiesRequired = true;
    private String ipAddress = "";
    private String pageName = "";
    private String pageNavHTML = null;
    private int pageFrameSections = 823;
    private String cmdName = "";
    private String cmdArg = "";
    private boolean isFleet = false;
    private boolean isReport = false;
    private boolean notifyEventsOnly = false;
    private PrivateLabel privLabel = null;
    private String localeStr = null;
    private MapProvider mapProvider = null;
    private Account account = null;
    private User user = null;
    private Account sysadmin = null;
    private Device selDevice = null;
    private String selDeviceID = null;
    private boolean isActualSelDevID = false;
    private DeviceGroup selDeviceGroup = null;
    private String selDeviceGroupID = null;
    private boolean isActualSelGrpID = false;
    private boolean loginErrorAlert = false;
    private String[] userList = null;
    private OrderedSet<String> devList = null;
    private OrderedSet<String> devGrpSet = null;
    private OrderedSet<String> devGrpSetAll = null;
    private DateTime dateFrom = null;
    private DateTime dateTo = null;
    private TimeZone timeZone = null;
    private String timeZoneShortStr = null;
    private String timeZoneLongStr = null;
    private long eventLimitCnt = 100L;
    private EventData.LimitType eventLimitType = EventData.LimitType.LAST;
    private DateTime lastEvent = null;
    private int showPassword = -1;
    private int enableDemo = -1;
    private boolean encodeEmailHTML = false;
    private OrderedSet<String> pushpinIconKeys = null;
    private DeviceGroup descLastGroup = null;
    private Device descLastDevice = null;
    private boolean _didCacheZoomeRegionShapes = false;
    private Map<String, MapShape> _cacheZoomRegionShapes = null;
    public static final String KEY_pageName = "pageName";
    public static final String KEY_navigation = "navigation";
    public static final String KEY_pageTitle = "pageTitle";
    public static final String KEY_copyright = "copyright";
    public static final String KEY_isLoggedIn = "isLoggedIn";
    public static final String KEY_loginURL = "loginURL";
    public static final String KEY_loginCount = "loginCount";
    public static final String KEY_i18n_Login = "i18n.Login";
    public static final String KEY_accountID = "accountID";
    public static final String KEY_accountDesc = "accountDesc";
    public static final String KEY_accountTel = "accountPhone";
    public static final String KEY_accountEmail = "accountEmail";
    public static final String KEY_welcomeMsg = "welcomeMsg";
    public static final String KEY_logout = "logout";
    public static final String KEY_accountJsp = "accountJsp";
    public static final String KEY_i18n_Account = "i18n.Account";
    public static final String KEY_i18n_Accounts = "i18n.Accounts";
    public static final String KEY_deviceID = "deviceID";
    public static final String KEY_deviceDesc = "deviceDesc";
    public static final String KEY_i18n_Device = "i18n.Device";
    public static final String KEY_i18n_Devices = "i18n.Devices";
    public static final String KEY_groupID = "groupID";
    public static final String KEY_groupDesc = "groupDesc";
    public static final String KEY_i18n_Group = "i18n.Group";
    public static final String KEY_i18n_Groups = "i18n.Groups";
    public static final String KEY_userID = "userID";
    public static final String KEY_userDesc = "userDesc";
    public static final String KEY_i18n_User = "i18n.User";
    public static final String KEY_i18n_Users = "i18n.Users";
    public static final String KEY_speedUnits = "speedUnits";
    public static final String KEY_altitudeUnits = "altitudeUnits";
    public static final String KEY_accuracyUnits = "accuracyUnits";
    public static final String KEY_distanceUnits = "distanceUnits";
    public static final String KEY_economyUnits = "economyUnits";
    public static final String KEY_pressureUnits = "pressureUnits";
    public static final String KEY_volumeUnits = "volumeUnits";
    public static final String KEY_statusCodeDesc = "statusCodeDesc";
    public static final String KEY_version = "version";
    public static final String KEY_hostname = "hostname";
    public static final String KEY_locale = "locale";
    public static final String KEY_isLocaleRTL = "isLocaleRTL";
    public static final String KEY_ipAddress = "ipAddress";
    public static final String KEY_privateLabelName = "privateLabelName";
    public static final String KEY_MapsTop = "mapsTop";
    public static final String KEY_ReportsTop = "reportsTop";
    public static final String KEY_AdminTop = "adminTop";
    public static final String KEY_SuperTop = "superTop";
    public static final String KEY_lastMap = "lastMap";
    public static final String KEY_deviceMap = "deviceMap";
    public static final String KEY_fleetMap = "fleetMap";
    public static final String KEY_sosMap = "sosMap";
    public static final String KEY_alertMap = "alertMap";
    public static final String KEY_detailReport = "detailReport";
    public static final String KEY_fleetReport = "fleetReport";
    public static final String KEY_summaryReport = "summaryReport";
    public static final String KEY_performanceReport = "performanceReport";
    public static final String KEY_accountAdmin = "accountAdmin";
    public static final String KEY_userAdmin = "userAdmin";
    public static final String KEY_roleAdmin = "roleAdmin";
    public static final String KEY_statusCodeAdmin = "statusCodeAdmin";
    public static final String KEY_deviceAdmin = "deviceAdmin";
    public static final String KEY_fleetAdmin = "fleetAdmin";
    public static final String KEY_driverAdmin = "driverAdmin";
    public static final String KEY_truckAdmin = "truckAdmin";
    public static final String KEY_packageAdmin = "packageAdmin";
    public static final String KEY_rfidAdmin = "rfidAdmin";
    public static final String KEY_geozoneAdmin = "geozoneAdmin";
    public static final String KEY_corridorAdmin = "corridorAdmin";
    public static final String KEY_ruleAdmin = "ruleAdmin";
    public static final String KEY_alertArdmin = "alertAdmin";
    public static final String KEY_monitorAdmin = "monitorAdmin";
    public static final String KEY_jobAdmin = "jobAdmin";
    public static final String KEY_passwordAdmin = "passwordAdmin";
    public static final String KEY_systemSuper = "systemSuper";
    public static final String KEY_accountsSuper = "accountsSuper";
    public static final String KEY_findSuper = "findSuper";
    public static final String KEY_adminSuper = "adminSuper";
    public static final String KEY_lafSuper = "lafSuper";
    public static final String KEY_platformMessage = "platformMessage";
    private static Map<String, KeyValue> propKeyMap = null;

    public static String TRACK_BASE_URI() {
        if (TRACK_BASE_URI == null) {
            String uri = RTConfig.getString((String)"track.baseURI", null);
            if (uri == null) {
                uri = "./Track";
            }
            TRACK_BASE_URI = uri.equals(".") ? "./" : (uri.startsWith("./") ? uri : (uri.startsWith("/") ? "." + uri : "./" + uri));
        }
        return TRACK_BASE_URI;
    }

    public boolean getEncodeEMailHTML() {
        return this.encodeEmailHTML;
    }

    public void setEncodeEMailHTML(boolean state) {
        this.encodeEmailHTML = state;
    }

    public void setBaseURI(String baseUri) {
        this.baseURI = baseUri;
    }

    public String getBaseURI() {
        return this.baseURI != null ? this.baseURI : "/";
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public URIArg getHttpServletRequestURIArg(boolean inclUserPass) {
        if (this.request != null) {
            String encPass;
            URIArg url = new URIArg(this.getBaseURI(), true);
            url.addArg("account", this.getCurrentAccountID());
            url.addArg("user", this.getCurrentUserID());
            if (inclUserPass && !(encPass = this.getCurrentUserEncodedPassword()).equals("*blank*")) {
                url.addArg("encpass", encPass);
            }
            Enumeration e = this.request.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = this.request.getParameter(key);
                url.addArg(key, val);
            }
            return url;
        }
        return null;
    }

    public void setSoapRequest(boolean soap) {
        this.isSoapRequest = soap;
    }

    public boolean isSoapRequest() {
        return this.isSoapRequest;
    }

    public void setCookiesRequired(boolean cookiesReq) {
        this.cookiesRequired = cookiesReq;
    }

    public boolean getCookiesRequired() {
        return this.cookiesRequired;
    }

    public void setIPAddress(String ipAddr) {
        this.ipAddress = ipAddr;
    }

    public String getIPAddress() {
        return this.ipAddress != null ? this.ipAddress : "";
    }

    public void setPageName(String page) {
        this.pageName = page;
    }

    public String getPageName() {
        return this.pageName != null ? this.pageName : "";
    }

    public WebPage getWebPage() {
        if (this.pageName != null) {
            PrivateLabel _privLabel = this.getPrivateLabel();
            return _privLabel.getWebPage(this.pageName);
        }
        return null;
    }

    public String getJspName() {
        String jn = this.getPrivateLabel().getWebPageJSP();
        return StringTools.replaceKeys((String)jn, (StringTools.KeyValueMap)this, null);
    }

    public String getJspURI() {
        String jspURI = this.getWebPageURI();
        String jspFile = this.getPrivateLabel().getWebPageJSP(jspURI, this);
        return jspFile;
    }

    public void setWebPageURI(String uri) {
        this.webPageURI = uri;
    }

    public String getWebPageURI() {
        if (!StringTools.isBlank((String)this.webPageURI)) {
            return this.webPageURI;
        }
        WebPage page = this.getWebPage();
        String jsp = page != null ? page.getJspURI() : null;
        return jsp;
    }

    public void setReport(boolean report) {
        this.isReport = report;
    }

    public boolean isReport() {
        return this.isReport;
    }

    public void setFleet(boolean fleet) {
        this.isFleet = fleet;
    }

    public boolean isFleet() {
        return this.isFleet;
    }

    public long getFleetDeviceEventCount() {
        long dec;
        PrivateLabel _privLabel = this.getPrivateLabel();
        WebPage webPage = this.getWebPage();
        if (webPage != null && (dec = webPage.getProperties().getLong("fleetDeviceEventCount", -1L)) > 0L) {
            return dec;
        }
        dec = _privLabel.getLongProperty("trackMap.fleetDeviceEventCount", 1L);
        return dec >= 1L ? dec : 1L;
    }

    public void setDeviceNotifyEventsOnly(boolean notifyEvents) {
        this.notifyEventsOnly = notifyEvents;
    }

    public boolean getDeviceNotifyEventsOnly() {
        return this.notifyEventsOnly;
    }

    public void setPageNavigationHTML(String pageNav) {
        this.pageNavHTML = pageNav;
    }

    public String getPageNavigationHTML() {
        return this.pageNavHTML;
    }

    public void setPageFrameSections(int pfs) {
        this.pageFrameSections = pfs | 0x100;
    }

    public int getPageFrameSections() {
        return this.pageFrameSections;
    }

    public void setPageFrameContentOnly(boolean contentOnly) {
        if (contentOnly) {
            this.setPageFrameSections(256);
        } else {
            this.setPageFrameSections(823);
        }
    }

    public boolean getPageFrameContentOnly() {
        return this.getPageFrameSections() == 256;
    }

    public boolean writePageFrameSection(int pfs) {
        return (pfs & this.pageFrameSections) != 0;
    }

    public void setCommandName(String cmd) {
        this.cmdName = cmd;
    }

    public String getCommandName() {
        return this.cmdName != null ? this.cmdName : "";
    }

    public void setCommandArg(String arg) {
        this.cmdArg = arg;
    }

    public String getCommandArg() {
        return this.cmdArg != null ? this.cmdArg : "";
    }

    public void setPrivateLabel(PrivateLabel _privLabel) {
        this.privLabel = _privLabel;
    }

    public PrivateLabel getPrivateLabel() {
        return this.privLabel != null ? this.privLabel : NullPrivateLabel;
    }

    public void setLocaleString(String localeStr) {
        this.localeStr = !StringTools.isBlank((String)localeStr) ? localeStr : null;
    }

    public Locale getLocale() {
        if (!StringTools.isBlank((String)this.localeStr)) {
            return I18N.getLocale((String)this.localeStr);
        }
        return this.getPrivateLabel().getLocale();
    }

    public void setMapProvider(MapProvider mapProv) {
        this.mapProvider = mapProv;
    }

    public MapProvider getMapProvider() {
        if (this.mapProvider == null) {
            this.mapProvider = this.getPrivateLabel().getMapProvider();
        }
        return this.mapProvider;
    }

    public OrderedSet<String> getMapProviderIconKeys() {
        if (this.pushpinIconKeys == null) {
            MapProvider mapProv = this.getMapProvider();
            this.pushpinIconKeys = mapProv != null ? (OrderedSet)mapProv.getPushpinIconMap(this).keySet() : new OrderedSet();
        }
        return this.pushpinIconKeys;
    }

    public List<String> getMapProviderPushpinIDs() {
        MapProvider mapProv = this.getMapProvider();
        if (mapProv != null) {
            return ListTools.toList((Set)mapProv.getPushpinIconMap(this).keySet(), new Vector());
        }
        return new Vector<String>();
    }

    public PushpinIcon getPushpinIcon(String ppName) {
        MapProvider mapProv = this.getMapProvider();
        if (mapProv != null) {
            OrderedMap<String, PushpinIcon> ppMap = mapProv.getPushpinIconMap(this);
            return (PushpinIcon)ppMap.get((Object)ppName);
        }
        return null;
    }

    public PushpinIcon getPushpinIcon(int ppNdx) {
        MapProvider mapProv = this.getMapProvider();
        if (mapProv != null) {
            OrderedMap<String, PushpinIcon> ppMap = mapProv.getPushpinIconMap(this);
            return (PushpinIcon)ppMap.getValue(ppNdx);
        }
        return null;
    }

    public void _setLoginErrorAlert() {
        this.loginErrorAlert = true;
    }

    public boolean _isLoginErrorAlert() {
        return this.loginErrorAlert;
    }

    public boolean isLoggedInFromSysAdmin() {
        return RequestProperties.isLoggedInFromSysAdmin(this.getHttpServletRequest(), this.getPrivateLabel());
    }

    public static boolean isLoggedInFromSysAdmin(HttpServletRequest request, PrivateLabel _privLabel) {
        if (request == null) {
            return false;
        }
        if (_privLabel == null) {
            return false;
        }
        String saAcctID = AttributeTools.getSessionString((ServletRequest)request, "saRelogin_account", "");
        String saUserID = AttributeTools.getSessionString((ServletRequest)request, "saRelogin_user", "");
        String saPass = (String)AttributeTools.getSessionAttribute((ServletRequest)request, "saRelogin", (Object)"");
        long saTimeSt = AttributeTools.getSessionLong((ServletRequest)request, "saRelogin_session", 0L);
        if (!_privLabel.isSystemAccountsLoginEnabled(saAcctID)) {
            return false;
        }
        if (StringTools.isBlank((String)saPass)) {
            return false;
        }
        if (StringTools.isBlank((String)saAcctID)) {
            Print.logWarn((String)"Relogin passcode specified, but not a SysAdmin/Manager relogin session ...", (Object[])new Object[0]);
            return false;
        }
        if (saTimeSt + DateTime.MinuteSeconds((long)30L) < DateTime.getCurrentTimeSec()) {
            Print.logWarn((String)"SysAdmin/Manager relogin session timeout ...", (Object[])new Object[0]);
            return false;
        }
        String passcode = _privLabel.getSystemAccountsLoginPasscode(saAcctID);
        if (StringTools.isBlank((String)passcode)) {
            return false;
        }
        if (!saPass.equals(passcode)) {
            return false;
        }
        Print.logInfo((String)("Auto Logged-In from '" + saAcctID + "/" + saUserID + "' ..."), (Object[])new Object[0]);
        return true;
    }

    public boolean isReturnToSysAdminEnabled() {
        HttpServletRequest request = this.getHttpServletRequest();
        PrivateLabel privLabel = this.getPrivateLabel();
        return RequestProperties.isReturnToSysAdminEnabled(request, privLabel);
    }

    public static boolean isReturnToSysAdminEnabled(HttpServletRequest request, PrivateLabel _privLabel) {
        if (request == null) {
            return false;
        }
        if (_privLabel == null) {
            return false;
        }
        String saAcctID = AttributeTools.getSessionString((ServletRequest)request, "saRelogin_account", "");
        long saLoginTS = AttributeTools.getSessionLong((ServletRequest)request, "saRelogin_session", 0L);
        if (StringTools.isBlank((String)saAcctID)) {
            return false;
        }
        if (!RequestProperties.isLoggedInFromSysAdmin(request, _privLabel)) {
            return false;
        }
        if (!_privLabel.isSystemAccountsLoginReturnEnabled(saAcctID)) {
            return false;
        }
        long rtnTMOSec = _privLabel.getSystemAccountsLoginReturnTimeout(saAcctID);
        return rtnTMOSec < 0L || saLoginTS + rtnTMOSec >= DateTime.getCurrentTimeSec();
    }

    public void setCurrentAccount(Account account) {
        this.account = account;
        if (this.account == null) {
            Print.logWarn((String)"Account not specified!", (Object[])new Object[0]);
        }
    }

    public Account getCurrentAccount() {
        return this.account;
    }

    public String getCurrentAccountID() {
        return this.account != null ? this.account.getAccountID() : "";
    }

    public boolean isLoggedIn() {
        return this.getCurrentAccount() != null;
    }

    public void setCurrentUser(User user) {
        this.user = user;
    }

    public User getCurrentUser() {
        return this.user;
    }

    public String getCurrentUserEncodedPassword() {
        if (this.user != null) {
            return this.user.getEncodedPassword();
        }
        if (this.account != null) {
            return this.account.getEncodedPassword();
        }
        return null;
    }

    public String getCurrentUserID() {
        return this.user != null ? this.user.getUserID() : User.getAdminUserID();
    }

    public void setUserList(String[] userList) {
        this.userList = userList;
    }

    public String[] getUserList() {
        if (this.userList == null) {
            try {
                User user = this.getCurrentUser();
                PrivateLabel privLabel = this.getPrivateLabel();
                WebPage userPage = privLabel.getWebPage("user.info");
                this.userList = userPage == null ? new String[0] : (privLabel.hasReadAccess(user, userPage.getAclName("all")) ? User.getUsersForAccount((String)this.getCurrentAccountID()) : (privLabel.hasReadAccess(user, userPage.getAclName()) ? new String[]{user.getUserID()} : new String[0]));
            }
            catch (DBException dbe) {
                String[] stringArray;
                Print.logWarn((String)("Error getting User list: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                String uid = this.getCurrentUserID();
                if (StringTools.isBlank((String)uid)) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = uid;
                }
                this.userList = stringArray;
            }
        }
        return this.userList;
    }

    public void setSelectedDeviceGroupID(String groupID) {
        this.setSelectedDeviceGroupID(groupID, true);
    }

    public void setSelectedDeviceGroupID(String groupID, boolean isActualSpecifiedGroup) {
        this.selDeviceGroupID = groupID;
        this.isActualSelGrpID = isActualSpecifiedGroup;
        this.selDeviceGroup = null;
    }

    public String getSelectedDeviceGroupID() {
        if (!StringTools.isBlank((String)this.selDeviceGroupID)) {
            return this.selDeviceGroupID;
        }
        OrderedSet<String> grpList = this.getDeviceGroupIDList(false);
        if (!ListTools.isEmpty(grpList)) {
            return (String)grpList.get(0);
        }
        return "all";
    }

    public boolean isActualSpecifiedGroup() {
        return !StringTools.isBlank((String)this.selDeviceGroupID) && this.isActualSelGrpID;
    }

    public DeviceGroup getSelectedDeviceGroup() {
        String groupID;
        if (this.selDeviceGroup == null && !(groupID = this.getSelectedDeviceGroupID()).equalsIgnoreCase("all")) {
            try {
                Account account = this.getCurrentAccount();
                this.selDeviceGroup = DeviceGroup.getDeviceGroup((Account)account, (String)groupID);
                if (this.selDeviceGroup == null) {
                    this.selDeviceGroupID = "all";
                }
            }
            catch (DBException dbe) {
                this.selDeviceGroupID = "all";
                Print.logException((String)("Error reading DeviceGroup: " + this.getCurrentAccountID() + "/" + groupID), (Throwable)dbe);
            }
        }
        return this.selDeviceGroup;
    }

    public void clearDeviceGroupList() {
        this.devGrpSet = null;
        this.devGrpSetAll = null;
        this.selDeviceGroupID = null;
        this.selDeviceGroup = null;
    }

    public OrderedSet<String> getDeviceGroupIDList(boolean inclAll) {
        block8: {
            if (this.devGrpSet == null) {
                User user = this.getCurrentUser();
                if (!User.isAdminUser((User)user)) {
                    try {
                        List grpList = user.getDeviceGroups(true);
                        if (!ListTools.isEmpty((Collection)grpList)) {
                            this.devGrpSet = new OrderedSet((Collection)grpList);
                            this.devGrpSetAll = new OrderedSet(this.devGrpSet);
                            this.devGrpSetAll.add(0, (Object)"all");
                            break block8;
                        }
                        this.devGrpSet = DeviceGroup.getDeviceGroupsForAccount((String)this.getCurrentAccountID(), (boolean)false);
                        this.devGrpSetAll = new OrderedSet(this.devGrpSet);
                        this.devGrpSetAll.add(0, (Object)"all");
                    }
                    catch (DBException dbe) {
                        Print.logException((String)("Retrieving user groups: " + user.getUserID()), (Throwable)dbe);
                        this.devGrpSet = DeviceGroup.GROUP_LIST_EMPTY;
                        this.devGrpSetAll = DeviceGroup.GROUP_LIST_EMPTY;
                    }
                } else {
                    try {
                        this.devGrpSet = DeviceGroup.getDeviceGroupsForAccount((String)this.getCurrentAccountID(), (boolean)false);
                        this.devGrpSetAll = new OrderedSet(this.devGrpSet);
                        this.devGrpSetAll.add(0, (Object)"all");
                    }
                    catch (DBException dbe) {
                        this.devGrpSet = DeviceGroup.GROUP_LIST_EMPTY;
                        this.devGrpSetAll = DeviceGroup.GROUP_LIST_ALL;
                    }
                }
            }
        }
        return inclAll ? this.devGrpSetAll : this.devGrpSet;
    }

    public String getDeviceGroupDescription(String grpID, boolean rtnDispName) {
        if (StringTools.isBlank((String)grpID)) {
            return "";
        }
        if (this.descLastGroup != null && this.descLastGroup.getAccountID().equals(this.getCurrentAccountID()) && this.descLastGroup.getGroupID().equals(grpID)) {
            String n = rtnDispName ? this.descLastGroup.getDisplayName() : this.descLastGroup.getDescription();
            return !n.equals("") ? n : grpID;
        }
        Account acct = this.getCurrentAccount();
        if (acct != null) {
            try {
                this.descLastGroup = DeviceGroup.getDeviceGroup((Account)acct, (String)grpID);
                if (this.descLastGroup != null) {
                    String n = rtnDispName ? this.descLastGroup.getDisplayName() : this.descLastGroup.getDescription();
                    return !n.equals("") ? n : grpID;
                }
                if (grpID.equalsIgnoreCase("all")) {
                    return DeviceGroup.GetDeviceGroupAll((Locale)this.getLocale());
                }
                return grpID;
            }
            catch (DBException dbe) {
                return grpID;
            }
        }
        return grpID;
    }

    public void setSelectedDeviceID(String devID) {
        this.setSelectedDeviceID(devID, true);
    }

    public void setSelectedDeviceID(String devID, boolean isActualSpecifiedDevice) {
        this.selDeviceID = devID;
        this.isActualSelDevID = isActualSpecifiedDevice;
        this.selDevice = null;
    }

    public String getSelectedDeviceID() {
        return this.selDeviceID != null ? this.selDeviceID : "";
    }

    public boolean isActualSpecifiedDevice() {
        return !StringTools.isBlank((String)this.selDeviceID) && this.isActualSelDevID;
    }

    public Device getSelectedDevice() {
        String deviceID;
        if (this.selDevice == null && !StringTools.isBlank((String)(deviceID = this.getSelectedDeviceID()))) {
            try {
                Account account = this.getCurrentAccount();
                this.selDevice = Device.getDevice((Account)account, (String)deviceID);
                if (this.selDevice == null) {
                    Print.logWarn((String)("Device not found: " + deviceID), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Error reading Device: " + this.getCurrentAccountID() + "/" + deviceID), (Throwable)dbe);
            }
        }
        return this.selDevice;
    }

    public void clearDeviceList() {
        this.devList = null;
    }

    public OrderedSet<String> getDeviceIDList(boolean inclInactv) {
        if (this.devList == null) {
            try {
                this.devList = User.getAuthorizedDeviceIDs((User)this.getCurrentUser(), (String)this.getCurrentAccountID(), (boolean)inclInactv);
            }
            catch (DBException dbe) {
                this.devList = new OrderedSet();
            }
        }
        return this.devList;
    }

    protected OrderedSet<String> _getDeviceIDsForSelectedGroup(boolean isFleet, boolean inclInactv) throws DBException {
        if (isFleet) {
            String accountID = this.getCurrentAccountID();
            String groupID = this.getSelectedDeviceGroupID();
            if (!groupID.equals("") && !groupID.equalsIgnoreCase("all")) {
                OrderedSet dList = DeviceGroup.getDeviceIDsForGroup((String)accountID, (String)groupID, null, (boolean)inclInactv);
                return dList;
            }
            return this.getDeviceIDList(inclInactv);
        }
        return this.getDeviceIDList(inclInactv);
    }

    public String getDeviceDescription(String devID, boolean rtnDispName) {
        if (StringTools.isBlank((String)devID)) {
            return "";
        }
        if (this.descLastDevice != null && this.descLastDevice.getAccountID().equals(this.getCurrentAccountID()) && this.descLastDevice.getDeviceID().equals(devID)) {
            String n = rtnDispName ? this.descLastDevice.getDisplayName() : this.descLastDevice.getDescription();
            return !n.equals("") ? n : devID;
        }
        Account acct = this.getCurrentAccount();
        if (acct != null) {
            try {
                this.descLastDevice = Device.getDevice((Account)acct, (String)devID);
                if (this.descLastDevice != null) {
                    String n = rtnDispName ? this.descLastDevice.getDisplayName() : this.descLastDevice.getDescription();
                    return !n.equals("") ? n : devID;
                }
                return devID;
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return devID;
    }

    public List<IDDescription> createGroupIDDescriptionList(boolean inclAll, IDDescription.SortBy sortBy) {
        OrderedSet<String> dgList = this.getDeviceGroupIDList(inclAll);
        Vector<IDDescription> idList = new Vector<IDDescription>();
        if (!ListTools.isEmpty(dgList)) {
            sortBy = IDDescription.GetSortBy(sortBy);
            boolean rtnDispName = sortBy.equals((Object)IDDescription.SortBy.NAME);
            for (int i = 0; i < dgList.size(); ++i) {
                String dgid = (String)dgList.get(i);
                String desc = this.getDeviceGroupDescription(dgid, rtnDispName);
                idList.add(new IDDescription(dgid, desc));
            }
            if (rtnDispName) {
                sortBy = IDDescription.SortBy.DESCRIPTION;
            }
            IDDescription.SortList(idList, sortBy);
        }
        return idList;
    }

    public OrderedMap<String, String> createGroupDescriptionMap(boolean inclID, boolean inclAll) {
        List<IDDescription> list = this.createGroupIDDescriptionList(inclAll, null);
        OrderedMap map = new OrderedMap();
        for (IDDescription idd : list) {
            String id = idd.getID();
            String desc = idd.getDescription();
            if (inclID) {
                desc = desc + " [" + id + "]";
            }
            map.put((Object)id, (Object)desc);
        }
        return map;
    }

    public List<IDDescription> createDeviceIDDescriptionList(boolean inclInactv, IDDescription.SortBy sortBy) {
        OrderedSet<String> dgList = this.getDeviceIDList(inclInactv);
        Vector<IDDescription> idList = new Vector<IDDescription>();
        if (!ListTools.isEmpty(dgList)) {
            sortBy = IDDescription.GetSortBy(sortBy);
            boolean rtnDispName = sortBy.equals((Object)IDDescription.SortBy.NAME);
            for (int i = 0; i < dgList.size(); ++i) {
                String dgid = (String)dgList.get(i);
                String desc = this.getDeviceDescription(dgid, rtnDispName);
                idList.add(new IDDescription(dgid, desc));
            }
            if (rtnDispName) {
                sortBy = IDDescription.SortBy.DESCRIPTION;
            }
            IDDescription.SortList(idList, sortBy);
        }
        return idList;
    }

    public OrderedMap<String, String> createDeviceDescriptionMap(boolean inclID) {
        List<IDDescription> list = this.createDeviceIDDescriptionList(false, null);
        OrderedMap map = new OrderedMap();
        for (IDDescription idd : list) {
            String id = idd.getID();
            String desc = idd.getDescription();
            if (inclID) {
                desc = desc + " [" + id + "]";
            }
            map.put((Object)id, (Object)desc);
        }
        return map;
    }

    public Map<String, MapShape> getZoomRegionShapes() {
        if (!this._didCacheZoomeRegionShapes) {
            this._didCacheZoomeRegionShapes = true;
            Map<String, MapShape> msList = this.getPrivateLabel().getMapShapes();
            if (!ListTools.isEmpty(msList)) {
                if (this._cacheZoomRegionShapes != null) {
                    this._cacheZoomRegionShapes.putAll(msList);
                } else {
                    this._cacheZoomRegionShapes = msList;
                }
            }
        }
        return this._cacheZoomRegionShapes;
    }

    public EventData[] getMapEvents() throws DBException {
        return this.getMapEvents(null, -1L);
    }

    public EventData[] getMapEvents(int[] statusCodes, long perDevLimit) throws DBException {
        long endTime;
        long startTime;
        EventData.LimitType limitType;
        block8: {
            PrivateLabel privLabel = this.getPrivateLabel();
            long limitCnt = this.getEventLimit();
            limitType = this.getEventLimitType();
            if (perDevLimit <= 0L) {
                perDevLimit = this.isFleet() ? this.getFleetDeviceEventCount() : limitCnt;
            }
            boolean notifyEventsOnly = this.getDeviceNotifyEventsOnly();
            startTime = this.getEventDateFromSec();
            endTime = this.getEventDateToSec();
            if (!this.isFleet()) break block8;
            Account account = this.getCurrentAccount();
            if (account == null) {
                return EventData.EMPTY_ARRAY;
            }
            User user = this.getCurrentUser();
            OrderedSet<String> devIDList = this._getDeviceIDsForSelectedGroup(true, false);
            if (ListTools.isEmpty(devIDList)) {
                Print.logInfo((String)"No devices ...", (Object[])new Object[0]);
                return EventData.EMPTY_ARRAY;
            }
            Vector<EventData> evList = new Vector<EventData>();
            for (int i = 0; i < devIDList.size(); ++i) {
                block10: {
                    Device device;
                    block9: {
                        String deviceID = (String)devIDList.get(i);
                        if (user != null && !user.isAuthorizedDevice(deviceID) || (device = Device.getDevice((Account)account, (String)deviceID)) == null) continue;
                        if (!notifyEventsOnly) break block9;
                        EventData E = device.getLastNotifyEvent();
                        if (E == null) break block10;
                        long ts = E.getTimestamp();
                        if (startTime > 0L && ts < startTime || endTime > 0L && ts > endTime) break block10;
                        evList.add(E);
                        break block10;
                    }
                    EventData[] ev = device.getRangeEvents(startTime, endTime, statusCodes, true, limitType, perDevLimit);
                    if (ev != null) {
                        for (int e = 0; e < ev.length; ++e) {
                            evList.add(ev[e]);
                        }
                    }
                }
                if (limitCnt > 0L && (long)evList.size() >= limitCnt) break;
            }
            Collections.sort(evList, EventData.getDeviceDescriptionComparator());
            return evList.toArray(new EventData[evList.size()]);
        }
        Device device = this.getSelectedDevice();
        if (device == null) {
            return EventData.EMPTY_ARRAY;
        }
        EventData[] ev = startTime <= 0L && endTime <= 0L ? device.getRangeEvents(-1L, -1L, statusCodes, true, limitType, perDevLimit) : device.getRangeEvents(startTime, endTime, statusCodes, true, limitType, perDevLimit);
        if (ev == null) {
            return EventData.EMPTY_ARRAY;
        }
        return ev;
    }

    public Collection<Device> getMapEventsByDevice() throws DBException {
        return this.getMapEventsByDevice(null, -1L);
    }

    public Collection<Device> getMapEventsByDevice(int[] statusCodes, long perDevLimit) throws DBException {
        PrivateLabel privLabel = this.getPrivateLabel();
        long limitCnt = this.getEventLimit();
        EventData.LimitType limitType = this.getEventLimitType();
        if (perDevLimit <= 0L) {
            perDevLimit = this.isFleet() ? this.getFleetDeviceEventCount() : limitCnt;
        }
        boolean notifyEventsOnly = this.getDeviceNotifyEventsOnly();
        long startTime = this.getEventDateFromSec();
        long endTime = this.getEventDateToSec();
        Vector<Device> devList = new Vector<Device>();
        if (this.isFleet()) {
            Account account = this.getCurrentAccount();
            if (account == null) {
                return null;
            }
            User user = this.getCurrentUser();
            OrderedSet<String> devIDList = this._getDeviceIDsForSelectedGroup(true, false);
            if (ListTools.isEmpty(devIDList)) {
                Print.logInfo((String)"No devices ...", (Object[])new Object[0]);
                return null;
            }
            int evCount = 0;
            for (int i = 0; i < devIDList.size(); ++i) {
                Device device;
                String deviceID = (String)devIDList.get(i);
                if (user != null && !user.isAuthorizedDevice(deviceID) || (device = Device.getDevice((Account)account, (String)deviceID)) == null) continue;
                EventData[] ev = null;
                if (notifyEventsOnly) {
                    EventData E = device.getLastNotifyEvent();
                    if (E != null) {
                        long ts = E.getTimestamp();
                        if (!(startTime > 0L && ts < startTime || endTime > 0L && ts > endTime)) {
                            ev = new EventData[]{E};
                        }
                    }
                } else {
                    ev = device.getRangeEvents(startTime, endTime, statusCodes, true, limitType, perDevLimit);
                }
                if (!ListTools.isEmpty(ev)) {
                    device.setSavedRangeEvents(ev);
                    devList.add(device);
                    evCount += ev.length;
                }
                if (limitCnt > 0L && (long)evCount >= limitCnt) break;
            }
            Collections.sort(devList, Device.getDeviceDescriptionComparator());
            return !ListTools.isEmpty(devList) ? devList : null;
        }
        Device device = this.getSelectedDevice();
        if (device == null) {
            return null;
        }
        Object[] ev = startTime <= 0L && endTime <= 0L ? device.getRangeEvents(-1L, -1L, statusCodes, true, limitType, perDevLimit) : device.getRangeEvents(startTime, endTime, statusCodes, true, limitType, perDevLimit);
        if (!ListTools.isEmpty((Object[])ev)) {
            device.setSavedRangeEvents((EventData[])ev);
            devList.add(device);
        }
        return !ListTools.isEmpty(devList) ? devList : null;
    }

    public boolean getShowAddress() {
        Account acct = this.getCurrentAccount();
        if (acct == null) {
            return false;
        }
        return !Account.getGeocoderMode((Account)acct).isNone();
    }

    public void setEventDateFrom(DateTime fr) {
        this.dateFrom = fr;
    }

    public DateTime getEventDateFrom() {
        return this.dateFrom;
    }

    public long getEventDateFromSec() {
        return this.dateFrom != null ? this.dateFrom.getTimeSec() : -1L;
    }

    public void setEventDateTo(DateTime to) {
        this.dateTo = to;
    }

    public DateTime getEventDateTo() {
        return this.dateTo;
    }

    public long getEventDateToSec() {
        return this.dateTo != null ? this.dateTo.getTimeSec() : -1L;
    }

    public String getDateFormat() {
        return this.getPrivateLabel().getDateFormat();
    }

    public void setTimeZone(TimeZone tz, String tzStr) {
        this.timeZone = tz;
        this.timeZoneLongStr = tzStr;
    }

    public String getTimeZoneString(DateTime dt) {
        if (StringTools.isBlank((String)this.timeZoneLongStr)) {
            String tzStr = null;
            Account a = this.getCurrentAccount();
            User u = this.getCurrentUser();
            if (u != null) {
                tzStr = u.getTimeZone();
                if (StringTools.isBlank((String)tzStr) && a != null) {
                    tzStr = a.getTimeZone();
                }
            } else if (a != null) {
                tzStr = a.getTimeZone();
            }
            if (StringTools.isBlank((String)tzStr)) {
                tzStr = "GMT";
            }
            this.timeZoneLongStr = tzStr;
        }
        if (dt != null) {
            if (StringTools.isBlank((String)this.timeZoneShortStr)) {
                TimeZone tz = DateTime.getTimeZone((String)this.timeZoneShortStr, null);
                if (tz != null) {
                    boolean dst = dt.isDaylightSavings(tz);
                    this.timeZoneShortStr = tz.getDisplayName(dst, 0);
                } else {
                    this.timeZoneShortStr = this.timeZoneLongStr;
                }
            }
            return this.timeZoneShortStr;
        }
        return this.timeZoneLongStr;
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        if (this.dateFrom != null) {
            this.timeZone = this.dateFrom.getTimeZone();
            return this.timeZone;
        }
        this.timeZone = DateTime.getTimeZone((String)this.getTimeZoneString(null));
        return this.timeZone;
    }

    public List getTimeZonesList() {
        String tmz = this.getTimeZoneString(null);
        Vector<String> tzList = this.getPrivateLabel().getTimeZonesList();
        if (!StringTools.isBlank((String)tmz) && !tzList.contains(tmz)) {
            tzList = new Vector<String>(tzList);
            tzList.add(tmz);
        }
        return tzList;
    }

    public void setEventLimit(long limitCnt) {
        this.eventLimitCnt = limitCnt;
    }

    public long getEventLimit() {
        return this.eventLimitCnt;
    }

    public void setEventLimitType(EventData.LimitType limitType) {
        this.eventLimitType = limitType != null ? limitType : EventData.LimitType.LAST;
    }

    public void setEventLimitType(String limitType) {
        this.eventLimitType = limitType != null && limitType.equalsIgnoreCase("first") ? EventData.LimitType.FIRST : EventData.LimitType.LAST;
    }

    public EventData.LimitType getEventLimitType() {
        return this.isFleet() ? EventData.LimitType.LAST : (this.eventLimitType != null ? this.eventLimitType : EventData.LimitType.LAST);
    }

    public void setLastEventTime(DateTime lastTime) {
        this.lastEvent = lastTime;
    }

    public boolean hasLastEvent() {
        return this.lastEvent != null && this.lastEvent.getTimeSec() > 0L;
    }

    public DateTime getLastEventTime() {
        return this.lastEvent;
    }

    public String formatDateTime(DateTime dt) {
        return this.formatDateTime(dt, this.getTimeZone(), "");
    }

    public String formatDateTime(DateTime dt, String dft) {
        return this.formatDateTime(dt, this.getTimeZone(), dft);
    }

    public String formatDateTime(long timestamp) {
        return this.formatDateTime(timestamp, this.getTimeZone(), "");
    }

    public String formatDateTime(long timestamp, String dft) {
        return this.formatDateTime(timestamp, this.getTimeZone(), dft);
    }

    public String formatDateTime(long timestamp, TimeZone tmz) {
        return this.formatDateTime(timestamp, tmz, "");
    }

    public String formatDateTime(long timestamp, TimeZone tmz, String dft) {
        return timestamp > 0L ? this.formatDateTime(new DateTime(timestamp, tmz), tmz, dft) : dft;
    }

    public String formatDateTime(DateTime dt, TimeZone tmz) {
        return this.formatDateTime(dt, tmz, "");
    }

    public String formatDateTime(DateTime dt, TimeZone tmz, String dft) {
        if (dt != null && dt.getTimeSec() > 0L) {
            Account a = this.getCurrentAccount();
            String dateFmt = a != null ? a.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
            String timeFmt = a != null ? a.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
            return dt.format(dateFmt + " " + timeFmt + " z", tmz);
        }
        return dft;
    }

    public String formatDayNumber(long dayNumber) {
        return this.formatDayNumber(dayNumber, "");
    }

    public String formatDayNumber(long dayNumber, String dft) {
        return dayNumber > 0L ? this.formatDayNumber(new DayNumber(dayNumber), dft) : dft;
    }

    public String formatDayNumber(DayNumber dn) {
        return this.formatDayNumber(dn, "");
    }

    public String formatDayNumber(DayNumber dn, String dft) {
        if (dn != null && dn.getDayNumber() > 0L) {
            Account a = this.getCurrentAccount();
            String dateFmt = a != null ? a.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
            return dn.format(dateFmt);
        }
        return dft;
    }

    public Account.SpeedUnits getSpeedUnits() {
        return Account.getSpeedUnits((Account)this.getCurrentAccount());
    }

    public Account.DistanceUnits getDistanceUnits() {
        return Account.getDistanceUnits((Account)this.getCurrentAccount());
    }

    public Account.TemperatureUnits getTemperatureUnits() {
        return Account.getTemperatureUnits((Account)this.getCurrentAccount());
    }

    public String[] getDeviceTitles() {
        Locale locale = this.getLocale();
        Account account = this.getCurrentAccount();
        String[] titles = account != null ? account.getDeviceTitles(locale) : null;
        return titles != null ? titles : Device.GetTitles((Locale)locale);
    }

    public String[] getDeviceGroupTitles() {
        Locale locale = this.getLocale();
        Account account = this.getCurrentAccount();
        String[] titles = account != null ? account.getDeviceGroupTitles(locale) : null;
        return titles != null ? titles : DeviceGroup.GetTitles((Locale)locale);
    }

    public String[] getEntityTitles() {
        String[] stringArray;
        String[] titles;
        Locale locale = this.getLocale();
        Account account = this.getCurrentAccount();
        String[] stringArray2 = titles = account != null ? account.getEntityTitles(locale) : null;
        if (titles != null) {
            stringArray = titles;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "";
            stringArray = stringArray3;
            stringArray3[1] = "";
        }
        return stringArray;
    }

    public String[] getAddressTitles() {
        String[] stringArray;
        String[] titles;
        Locale locale = this.getLocale();
        Account account = this.getCurrentAccount();
        String[] stringArray2 = titles = account != null ? account.getAddressTitles(locale) : null;
        if (titles != null) {
            stringArray = titles;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "";
            stringArray = stringArray3;
            stringArray3[1] = "";
        }
        return stringArray;
    }

    public void setShowPassword(boolean showPass) {
        this.showPassword = showPass ? 1 : 0;
    }

    public boolean getShowPassword() {
        if (this.showPassword < 0) {
            return this.getPrivateLabel().getShowPassword();
        }
        return this.showPassword > 0;
    }

    public void setEnableDemo(boolean enableDemo) {
        this.enableDemo = enableDemo ? 1 : 0;
    }

    public boolean getEnableDemo() {
        if (this.enableDemo < 0) {
            return this.getPrivateLabel().getEnableDemo();
        }
        return this.enableDemo > 0;
    }

    public String getDemoAccountID() {
        return this.getEnableDemo() ? Account.GetDemoAccountID() : "";
    }

    public boolean isDemoAccount() {
        return this.getEnableDemo() && this.getCurrentAccountID().equals(this.getDemoAccountID());
    }

    public String[] getDemoDateRange() {
        if (this.getEnableDemo()) {
            return Account.GetDemoDeviceDateRange((String)this.getDemoAccountID(), (String)this.getSelectedDeviceID());
        }
        return null;
    }

    private static Map<String, KeyValue> _getKeyMap() {
        if (propKeyMap == null) {
            propKeyMap = new OrderedMap();
            ((OrderedMap)propKeyMap).setIgnoreCase(true);
            propKeyMap.put(KEY_pageName, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    return reqState.getPageName();
                }
            });
            propKeyMap.put(KEY_navigation, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    return reqState.getPageNavigationHTML();
                }
            });
            propKeyMap.put(KEY_pageTitle, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    PrivateLabel privLabel = reqState.getPrivateLabel();
                    String title = privLabel.getPageTitle();
                    if (StringTools.isBlank((String)title)) {
                        Print.logWarn((String)("PageTitle is blank: " + privLabel.getName()), (Object[])new Object[0]);
                    }
                    return title;
                }
            });
            propKeyMap.put(KEY_copyright, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    PrivateLabel privLabel = reqState.getPrivateLabel();
                    String copyright = privLabel.getCopyright();
                    return copyright;
                }
            });
            propKeyMap.put(KEY_isLoggedIn, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    boolean isLoggedIn = acct != null;
                    return isLoggedIn ? "true" : "false";
                }
            });
            propKeyMap.put(KEY_loginURL, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    HttpServletRequest request = reqState.getHttpServletRequest();
                    if (request != null) {
                        String url = StringTools.trim((String)request.getRequestURL().toString());
                        int p = url.lastIndexOf("/");
                        if (p > 0) {
                            String baseURI = RequestProperties.TRACK_BASE_URI();
                            if (baseURI.startsWith(".")) {
                                baseURI = baseURI.substring(1);
                            }
                            url = url.substring(0, p) + baseURI;
                            RTProperties hostProps = (RTProperties)AttributeTools.getSessionAttribute((ServletRequest)request, "hostProperties", null);
                            String hostPropID = hostProps != null ? hostProps.getString("lfid", null) : null;
                            url = !StringTools.isBlank((String)hostPropID) ? url + "?lfid=" + hostPropID : url + "?lfid=default";
                        }
                        return url;
                    }
                    return "";
                }
            });
            propKeyMap.put(KEY_loginCount, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    int count = reqState.GetLoginCount();
                    if (count < 0) {
                        return "?";
                    }
                    if (reqState.isLoggedIn()) {
                        return String.valueOf(count);
                    }
                    return String.valueOf(count) + "*";
                }
            });
            propKeyMap.put(KEY_i18n_Login, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("RequestProperties.login", "Login");
                }
            });
            propKeyMap.put(KEY_accountID, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    String acctID = reqState.getCurrentAccountID();
                    return !StringTools.isBlank((String)acctID) ? acctID : null;
                }
            });
            propKeyMap.put(KEY_accountDesc, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return acct != null ? acct.getDescription() : null;
                }
            });
            propKeyMap.put(KEY_accountTel, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return acct != null ? acct.getContactPhone() : null;
                }
            });
            propKeyMap.put(KEY_accountEmail, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return acct != null ? acct.getContactEmail() : null;
                }
            });
            propKeyMap.put(KEY_welcomeMsg, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("RequestProperties.welcomeMsg", "Welcome");
                }
            });
            propKeyMap.put(KEY_logout, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("RequestProperties.logout", "Logout");
                }
            });
            propKeyMap.put(KEY_MapsTop, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.MapsTop", "Maps");
                }
            });
            propKeyMap.put(KEY_ReportsTop, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.ReportsTop", "Reports");
                }
            });
            propKeyMap.put(KEY_AdminTop, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.AdminTop", "Admin");
                }
            });
            propKeyMap.put(KEY_SuperTop, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.SuperTop", "Superadmin");
                }
            });
            propKeyMap.put(KEY_lastMap, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.lastMap", "Last Maps");
                }
            });
            propKeyMap.put(KEY_deviceMap, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.deviceMap", "Device Map");
                }
            });
            propKeyMap.put(KEY_fleetMap, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.fleetMap", "Fleet Map");
                }
            });
            propKeyMap.put(KEY_sosMap, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.sosMap", "SoS Map");
                }
            });
            propKeyMap.put(KEY_alertMap, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.alertMap", "Alerts Map");
                }
            });
            propKeyMap.put(KEY_detailReport, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.detailReport", "Detail Report");
                }
            });
            propKeyMap.put(KEY_fleetReport, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.fleetReport", "Fleet Report");
                }
            });
            propKeyMap.put(KEY_summaryReport, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.summaryReport", "Summary Report");
                }
            });
            propKeyMap.put(KEY_performanceReport, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.performanceReport", "Performance Report");
                }
            });
            propKeyMap.put(KEY_accountAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.accountAdmin", "Account");
                }
            });
            propKeyMap.put(KEY_userAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.userAdmin", "User");
                }
            });
            propKeyMap.put(KEY_statusCodeAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.statusCode", "Status Code");
                }
            });
            propKeyMap.put(KEY_roleAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.roleAdmin", "Role");
                }
            });
            propKeyMap.put(KEY_deviceAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.deviceAdmin", "Device");
                }
            });
            propKeyMap.put(KEY_fleetAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.fleetAdmin", "Fleet");
                }
            });
            propKeyMap.put(KEY_driverAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.driverAdmin.", "Driver");
                }
            });
            propKeyMap.put(KEY_truckAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.truckAdmin", "Truck");
                }
            });
            propKeyMap.put(KEY_packageAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.packageAdmin", "Package");
                }
            });
            propKeyMap.put(KEY_rfidAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.rfidAdmin", "RFID");
                }
            });
            propKeyMap.put(KEY_geozoneAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.geozoneAdmin", "Geozone");
                }
            });
            propKeyMap.put(KEY_corridorAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.corridorAdmin", "Corridor");
                }
            });
            propKeyMap.put(KEY_ruleAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.ruleAdmin", "Rule");
                }
            });
            propKeyMap.put(KEY_alertArdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.alertArdmin", "Alerts");
                }
            });
            propKeyMap.put(KEY_monitorAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.monitorAdmin", "Monitor Panel");
                }
            });
            propKeyMap.put(KEY_jobAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.jobAdmin", "Report Job");
                }
            });
            propKeyMap.put(KEY_passwordAdmin, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.passwordAdmin", "Password");
                }
            });
            propKeyMap.put(KEY_systemSuper, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.systemSuper", "System Info");
                }
            });
            propKeyMap.put(KEY_accountsSuper, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.accountsSuper", "Accounts");
                }
            });
            propKeyMap.put(KEY_findSuper, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.findSuper", "Find Device");
                }
            });
            propKeyMap.put(KEY_adminSuper, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.adminSuper", "Report Admin");
                }
            });
            propKeyMap.put(KEY_lafSuper, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("Menu.", "Look and Feel");
                }
            });
            propKeyMap.put(KEY_platformMessage, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    User usr = reqState.getCurrentUser();
                    String usrID = usr.getUserID();
                    if (usrID.equalsIgnoreCase("admin")) {
                        return acct != null ? acct.getPlatformMessage() : null;
                    }
                    String mensaje = "";
                    mensaje = acct.getDescription() + "  Tel:" + acct.getContactPhone() + "  Email:" + acct.getContactEmail();
                    return mensaje;
                }
            });
            propKeyMap.put(KEY_accountJsp, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return acct != null ? StringTools.blankDefault((String)acct.getPrivateLabelJsp(), null) : null;
                }
            });
            propKeyMap.put(KEY_i18n_Account, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    if (acct != null) {
                        try {
                            AccountString as = AccountString.getAccountString((Account)acct, (String)"account");
                            if (as != null && as.hasSingularTitle()) {
                                return as.getSingularTitle();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    return Account.GetTitles((Locale)reqState.getLocale())[0];
                }
            });
            propKeyMap.put(KEY_i18n_Accounts, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    if (acct != null) {
                        try {
                            AccountString as = AccountString.getAccountString((Account)acct, (String)"account");
                            if (as != null && as.hasPluralTitle()) {
                                return as.getPluralTitle();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    return Account.GetTitles((Locale)reqState.getLocale())[1];
                }
            });
            propKeyMap.put(KEY_deviceID, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    String selDevID = reqState.getSelectedDeviceID();
                    if (!StringTools.isBlank((String)selDevID)) {
                        return selDevID;
                    }
                    Device selDev = reqState.getSelectedDevice();
                    if (selDev != null) {
                        return selDev.getDeviceID();
                    }
                    Print.logWarn((String)"RequestProperties does not have a selected Device", (Object[])new Object[0]);
                    return null;
                }
            });
            propKeyMap.put(KEY_deviceDesc, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Device selDev = reqState.getSelectedDevice();
                    if (selDev != null) {
                        return selDev.getDescription();
                    }
                    Print.logWarn((String)"RequestProperties does not have a selected Device", (Object[])new Object[0]);
                    return null;
                }
            });
            propKeyMap.put(KEY_i18n_Device, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    if (acct != null) {
                        try {
                            AccountString as = AccountString.getAccountString((Account)acct, (String)"device");
                            if (as != null && as.hasSingularTitle()) {
                                return as.getSingularTitle();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    return Device.GetTitles((Locale)reqState.getLocale())[0];
                }
            });
            propKeyMap.put("i18n.Vehicle", propKeyMap.get(KEY_i18n_Device));
            propKeyMap.put(KEY_i18n_Devices, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    if (acct != null) {
                        try {
                            AccountString as = AccountString.getAccountString((Account)acct, (String)"device");
                            if (as != null && as.hasPluralTitle()) {
                                return as.getPluralTitle();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    return Device.GetTitles((Locale)reqState.getLocale())[1];
                }
            });
            propKeyMap.put("i18n.Vehicles", propKeyMap.get(KEY_i18n_Devices));
            propKeyMap.put(KEY_groupID, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    String selGrpID = reqState.getSelectedDeviceGroupID();
                    if (!StringTools.isBlank((String)selGrpID)) {
                        return selGrpID;
                    }
                    DeviceGroup selGrp = reqState.getSelectedDeviceGroup();
                    if (selGrp != null) {
                        return selGrp.getGroupID();
                    }
                    Print.logWarn((String)"RequestProperties does not have a selected DeviceGroup", (Object[])new Object[0]);
                    return null;
                }
            });
            propKeyMap.put(KEY_groupDesc, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    DeviceGroup selGrp = reqState.getSelectedDeviceGroup();
                    if (selGrp != null) {
                        return selGrp.getDescription();
                    }
                    Print.logWarn((String)"RequestProperties does not have a selected DeviceGroup", (Object[])new Object[0]);
                    return null;
                }
            });
            propKeyMap.put(KEY_i18n_Group, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    if (acct != null) {
                        try {
                            AccountString as = AccountString.getAccountString((Account)acct, (String)"deviceGroup");
                            if (as != null && as.hasSingularTitle()) {
                                return as.getSingularTitle();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    return DeviceGroup.GetTitles((Locale)reqState.getLocale())[0];
                }
            });
            propKeyMap.put(KEY_i18n_Groups, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    if (acct != null) {
                        try {
                            AccountString as = AccountString.getAccountString((Account)acct, (String)"deviceGroup");
                            if (as != null && as.hasPluralTitle()) {
                                return as.getPluralTitle();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    return Device.GetTitles((Locale)reqState.getLocale())[1];
                }
            });
            propKeyMap.put(KEY_userID, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    String userID = reqState.getCurrentUserID();
                    return !StringTools.isBlank((String)userID) ? userID : null;
                }
            });
            propKeyMap.put(KEY_userDesc, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    return reqState.user != null ? reqState.user.getDescription() : User.getAdminUserID();
                }
            });
            propKeyMap.put(KEY_i18n_User, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    if (acct != null) {
                        try {
                            AccountString as = AccountString.getAccountString((Account)acct, (String)"user");
                            if (as != null && as.hasSingularTitle()) {
                                return as.getSingularTitle();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("RequestProperties.user", "User");
                }
            });
            propKeyMap.put(KEY_i18n_Users, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    if (acct != null) {
                        try {
                            AccountString as = AccountString.getAccountString((Account)acct, (String)"user");
                            if (as != null && as.hasSingularTitle()) {
                                return as.getPluralTitle();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    return i18n.getString("RequestProperties.users", "Users");
                }
            });
            propKeyMap.put(KEY_speedUnits, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return Account.getSpeedUnits((Account)acct).toString(reqState.getLocale());
                }
            });
            propKeyMap.put(KEY_distanceUnits, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return Account.getDistanceUnits((Account)acct).toString(reqState.getLocale());
                }
            });
            propKeyMap.put(KEY_altitudeUnits, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    Account.AltitudeUnits altUnits = Account.getAltitudeUnits((Account)acct);
                    if (altUnits.isFeet()) {
                        return i18n.getString("RequestProperties.feet", "feet");
                    }
                    if (altUnits.isMeters()) {
                        return i18n.getString("RequestProperties.meters", "meters");
                    }
                    return altUnits.toString(reqState.getLocale());
                }
            });
            propKeyMap.put(KEY_accuracyUnits, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    I18N i18n = I18N.getI18N(RequestProperties.class, (Locale)reqState.getLocale());
                    Account.AltitudeUnits altUnits = Account.getAltitudeUnits((Account)acct);
                    if (altUnits.isFeet()) {
                        return i18n.getString("RequestProperties.feet", "feet");
                    }
                    if (altUnits.isMeters()) {
                        return i18n.getString("RequestProperties.meters", "meters");
                    }
                    return altUnits.toString(reqState.getLocale());
                }
            });
            propKeyMap.put(KEY_economyUnits, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return Account.getEconomyUnits((Account)acct).toString(reqState.getLocale());
                }
            });
            propKeyMap.put(KEY_pressureUnits, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return Account.getPressureUnits((Account)acct).toString(reqState.getLocale());
                }
            });
            propKeyMap.put(KEY_volumeUnits, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    Account acct = reqState.getCurrentAccount();
                    return Account.getVolumeUnits((Account)acct).toString(reqState.getLocale());
                }
            });
            propKeyMap.put(KEY_statusCodeDesc, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    int sc = StringTools.parseInt((String)arg, (int)-1);
                    if (sc <= 0) {
                        return StatusCodes.GetDescription((int)0, null);
                    }
                    PrivateLabel privLabel = reqState.getPrivateLabel();
                    String acctID = reqState.getCurrentAccountID();
                    return StatusCode.getDescription((String)acctID, (int)sc, (BasicPrivateLabel)privLabel, null);
                }
            });
            propKeyMap.put(KEY_locale, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    PrivateLabel privLabel = reqState.getPrivateLabel();
                    return privLabel.getLocaleString();
                }
            });
            propKeyMap.put(KEY_isLocaleRTL, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    PrivateLabel privLabel = reqState.getPrivateLabel();
                    Locale locale = privLabel.getLocale();
                    if (locale == null) {
                        return "false";
                    }
                    String locCode = StringTools.trim((String)locale.getLanguage()).toLowerCase();
                    if (StringTools.isBlank((String)locCode)) {
                        return "false";
                    }
                    if (locCode.equals("ar") || locCode.equals("he")) {
                        return "true";
                    }
                    return "false";
                }
            });
            propKeyMap.put(KEY_version, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    return Version.getVersion();
                }
            });
            propKeyMap.put(KEY_hostname, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    return OSTools.getHostName();
                }
            });
            propKeyMap.put(KEY_ipAddress, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    return reqState.getIPAddress();
                }
            });
            propKeyMap.put(KEY_privateLabelName, new KeyValue(){

                @Override
                public String getValue(RequestProperties reqState, String arg) {
                    PrivateLabel privLabel = reqState.getPrivateLabel();
                    return privLabel.getName();
                }
            });
        }
        return propKeyMap;
    }

    private String _getKeyValue(String key, String arg, String dft) {
        Object v;
        if (StringTools.isBlank((String)key)) {
            return dft;
        }
        PrivateLabel privLabel = this.getPrivateLabel();
        String i18nVal = privLabel.getI18NTextString(key, null);
        if (i18nVal != null) {
            return i18nVal;
        }
        String propVal = privLabel.getStringProperty(key, null);
        if (propVal != null) {
            return propVal;
        }
        KeyValue kv = RequestProperties._getKeyMap().get(key);
        if (kv != null) {
            String v2 = kv.getValue(this, arg);
            return v2;
        }
        if (this.request != null && (v = AttributeTools.getSessionAttribute((ServletRequest)this.request, key, null)) != null) {
            return v.toString();
        }
        if (RTConfig.hasProperty((String)key)) {
            v = RTConfig.getString((String)key, null);
            return v;
        }
        return dft;
    }

    public String getKeyValue(String key, String arg, String dft) {
        String v = this._getKeyValue(key, arg, dft);
        return v;
    }

    public int GetLoginCount() {
        HttpSession hs = AttributeTools.getSession((ServletRequest)this.getHttpServletRequest());
        if (hs != null) {
            String aid = this.getCurrentAccountID();
            String uid = this.getCurrentUserID();
            if (StringTools.isBlank((String)uid)) {
                uid = User.getAdminUserID();
            }
            return RequestProperties.GetLoginCount(hs.getServletContext(), aid, uid);
        }
        return -1;
    }

    public static int GetLoginCount(ServletContext sc, String accountID, String userID) {
        if (StringTools.isBlank((String)accountID)) {
            return RTConfigContextListener.GetSessionCount(sc);
        }
        final String aid = StringTools.trim((String)accountID);
        final String uid = !StringTools.isBlank((String)userID) ? StringTools.trim((String)userID) : null;
        return RTConfigContextListener.GetSessionCount(sc, new RTConfigContextListener.HttpSessionFilter(){

            @Override
            public boolean countSession(HttpSession s) {
                Object sa = AttributeTools.getSessionAttribute(s, "account", (Object)"");
                if (aid.equals(sa)) {
                    if (uid == null) {
                        return true;
                    }
                    Object su = AttributeTools.getSessionAttribute(s, "user", (Object)"");
                    return uid.equals(su);
                }
                return false;
            }
        });
    }

    private static interface KeyValue {
        public String getValue(RequestProperties var1, String var2);
    }
}

