/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.dbtools.DBConnection;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadPool;

public class RTConfigContextListener
implements ServletContextListener,
HttpSessionListener {
    public static final String PARM_ACCOUNT = "account";
    public static final String PARM_USER = "user";
    public static final String[] PROP_DebugMode = new String[]{"debugMode", "debug"};
    public static final String[] PROP_DBConfig_init = new String[]{"DBConfig.init", "DBConfig.servletInit"};
    public static final Object ServletLock = new Object();
    private int sessionCount = 0;
    private Map<String, HttpSession> sessionMap = Collections.synchronizedMap(new HashMap());

    public static int GetSessionCount(ServletContext sc) {
        return RTConfigContextListener.GetSessionCount(sc, null);
    }

    public static int GetSessionCount(ServletContext sc, HttpSessionFilter filter) {
        RTConfigContextListener rccl;
        RTConfigContextListener rTConfigContextListener = rccl = sc != null ? (RTConfigContextListener)sc.getAttribute("RTConfigContextListener") : null;
        if (rccl != null) {
            return rccl.getSessionCount(filter);
        }
        Print.logWarn((String)"RTConfigContextListener not found!", (Object[])new Object[0]);
        return -1;
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext srvCtx = sce.getServletContext();
        String srvCtxName = StringTools.trim((String)srvCtx.getServletContextName());
        if (!StringTools.isBlank((String)srvCtxName)) {
            String dcsName;
            Print.logInfo((String)("Context Name: " + srvCtxName), (Object[])new Object[0]);
            if (srvCtxName.startsWith("dcs.") || srvCtxName.startsWith("dcs:")) {
                dcsName = srvCtxName.substring(4).trim();
                RTConfig.setContextName((String)dcsName);
                DCServerFactory.SetSpecificDCServerName((String)dcsName);
            } else if (srvCtxName.startsWith("dcs_") || srvCtxName.startsWith("dcs-")) {
                RTConfig.setContextName((String)srvCtxName);
                dcsName = srvCtxName.substring(4).trim();
                DCServerFactory.SetSpecificDCServerName((String)dcsName);
            } else {
                RTConfig.setContextName((String)srvCtxName);
            }
        } else {
            Print.logWarn((String)"Context Name not defined", (Object[])new Object[0]);
        }
        String srvCtxPath = StringTools.trim((String)srvCtx.getRealPath(""));
        if (!StringTools.isBlank((String)srvCtxPath)) {
            Print.logInfo((String)("Context Path: " + srvCtxPath), (Object[])new Object[0]);
            RTConfig.setContextPath((String)srvCtxPath);
        } else {
            Print.logWarn((String)("Context Path not defined: " + srvCtxName), (Object[])new Object[0]);
        }
        boolean dbConfigInit = true;
        Properties srvCtxProps = new Properties();
        Enumeration parmEnum = srvCtx.getInitParameterNames();
        while (parmEnum.hasMoreElements()) {
            String key = parmEnum.nextElement().toString();
            String val = srvCtx.getInitParameter(key);
            if (val == null) continue;
            Print.logInfo((String)("Adding Servlet property: " + key + " ==> " + val), (Object[])new Object[0]);
            srvCtxProps.setProperty(key, val);
            if (ListTools.contains((Object[])PROP_DebugMode, (Object)key)) {
                boolean debugMode = StringTools.parseBoolean((String)val, (boolean)true);
                RTConfig.setDebugMode((boolean)debugMode);
                if (!debugMode) continue;
                Print.setLogLevel((int)6);
                Print.setLogHeaderLevel((int)6);
                continue;
            }
            if (!ListTools.contains((Object[])PROP_DBConfig_init, (Object)key)) continue;
            dbConfigInit = StringTools.parseBoolean((String)val, (boolean)true);
        }
        if (dbConfigInit) {
            DBConfig.servletInit((Properties)srvCtxProps);
        } else {
            Print.logInfo((String)"Skipping 'DBConfig.servletInit' ...", (Object[])new Object[0]);
            RTConfig.setServletContextProperties((Map)srvCtxProps);
            if (RTConfig.isDebugMode()) {
                Print.setLogLevel((int)6);
                Print.setLogHeaderLevel((int)6);
            }
        }
        srvCtx.setAttribute("RTConfigContextListener", (Object)this);
        String headless = System.getProperty("java.awt.headless", "false");
        Print.logInfo((String)("java.awt.headless=" + headless), (Object[])new Object[0]);
        File logFile = Print.getLogFile();
        if (logFile != null) {
            Print.sysPrintln((String)("[" + srvCtxName + "] Logging to file: " + logFile), (Object[])new Object[0]);
        } else {
            Print.sysPrintln((String)("[" + srvCtxName + "] Logging to default location"), (Object[])new Object[0]);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext srvCtx = sce.getServletContext();
        String srvCtxName = srvCtx.getServletContextName();
        DBConnection.closeAllConnections();
        int preThreadCount = ThreadPool.GetTotalThreadCount();
        ThreadPool.StopThreads((boolean)true);
        try {
            Thread.sleep(500L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        int postThreadCount = ThreadPool.GetTotalThreadCount();
        Print.logInfo((String)("Remaining pool threads [" + preThreadCount + "]: " + postThreadCount), (Object[])new Object[0]);
        Print.logInfo((String)("... Servlet Context destroyed: " + srvCtxName), (Object[])new Object[0]);
        Print.logInfo((String)"-----------------------------------------------", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent se) {
        HttpSession hs = se.getSession();
        String hid = hs.getId();
        Map<String, HttpSession> map = this.sessionMap;
        synchronized (map) {
            ++this.sessionCount;
            this.sessionMap.put(hid, hs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession hs = se.getSession();
        String hid = hs.getId();
        Map<String, HttpSession> map = this.sessionMap;
        synchronized (map) {
            if (this.sessionCount > 0) {
                --this.sessionCount;
            }
            this.sessionMap.remove(hid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HttpSession> getSessions() {
        Vector<HttpSession> list = null;
        Map<String, HttpSession> map = this.sessionMap;
        synchronized (map) {
            list = new Vector<HttpSession>(this.sessionMap.values());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCount(HttpSessionFilter filter) {
        int count = 0;
        Map<String, HttpSession> map = this.sessionMap;
        synchronized (map) {
            if (filter == null) {
                count = this.sessionCount;
            } else {
                for (String id : this.sessionMap.keySet()) {
                    HttpSession hs = this.sessionMap.get(id);
                    if (hs == null || !filter.countSession(hs)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static interface HttpSessionFilter {
        public boolean countSession(HttpSession var1);
    }
}

