/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.swing.ImageIcon;
import org.opengts.db.GoogleKML;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.RequestProperties;

public class PushpinIcon {
    private static final String G_PUSHPIN_URL = GoogleKML.GooglePushpinBase();
    private static final String G_PUSHPIN_BLACK = G_PUSHPIN_URL + "mm_20_black.png";
    private static final String G_PUSHPIN_BROWN = G_PUSHPIN_URL + "mm_20_brown.png";
    private static final String G_PUSHPIN_RED = G_PUSHPIN_URL + "mm_20_red.png";
    private static final String G_PUSHPIN_ORANGE = G_PUSHPIN_URL + "mm_20_orange.png";
    private static final String G_PUSHPIN_YELLOW = G_PUSHPIN_URL + "mm_20_yellow.png";
    private static final String G_PUSHPIN_GREEN = G_PUSHPIN_URL + "mm_20_green.png";
    private static final String G_PUSHPIN_BLUE = G_PUSHPIN_URL + "mm_20_blue.png";
    private static final String G_PUSHPIN_PURPLE = G_PUSHPIN_URL + "mm_20_purple.png";
    private static final String G_PUSHPIN_GRAY = G_PUSHPIN_URL + "mm_20_gray.png";
    private static final String G_PUSHPIN_WHITE = G_PUSHPIN_URL + "mm_20_white.png";
    private static final int[] G_ICON_SIZE = new int[]{12, 20};
    private static final int[] G_ICON_OFFSET = new int[]{6, 20};
    private static final String G_PUSHPIN_SHADOW = G_PUSHPIN_URL + "mm_20_shadow.png";
    private static final int[] G_SHADOW_SIZE = new int[]{22, 20};
    public static String DEFAULT_TEXT_FONT = "SanSerif";
    private static final String PUSHPIN_URL = "images/pp/";
    private static final String PUSHPIN_BLACK = "images/pp/pin30_black.png";
    private static final String PUSHPIN_BROWN = "images/pp/pin30_brown.png";
    private static final String PUSHPIN_RED = "images/pp/pin30_red.png";
    private static final String PUSHPIN_ORANGE = "images/pp/pin30_orange.png";
    private static final String PUSHPIN_YELLOW = "images/pp/pin30_yellow.png";
    private static final String PUSHPIN_GREEN = "images/pp/pin30_green.png";
    private static final String PUSHPIN_BLUE = "images/pp/pin30_blue.png";
    private static final String PUSHPIN_PURPLE = "images/pp/pin30_purple.png";
    private static final String PUSHPIN_GRAY = "images/pp/pin30_gray.png";
    private static final String PUSHPIN_WHITE = "images/pp/pin30_white.png";
    private static final int[] ICON_SIZE = new int[]{18, 30};
    private static final int[] ICON_OFFSET = new int[]{9, 30};
    private static final String PUSHPIN_SHADOW = "images/pp/pin30_shadow.png";
    private static final int[] SHADOW_SIZE = new int[]{30, 30};
    private static OrderedMap<String, PushpinIcon> DefaultPushpinIconMap = null;
    public static final String MARKER_ARG_ICON = "icon";
    public static final String MARKER_ARG_FRAME = "fr";
    public static final String MARKER_ARG_FILL_COLOR = "fill";
    public static final String MARKER_ARG_BORDER_COLOR = "border";
    public static final String MARKER_ARG_COLOR = "color";
    public static final String MARKER_ARG_TEXT = "text";
    public static final String MARKER_ARG_ARROW = "arrow";
    private String name = "";
    private String imageURL = null;
    private String iconURL = null;
    private boolean iconEval = false;
    private int iconWidth = 12;
    private int iconHeight = 20;
    private int iconHotspotX = 6;
    private int iconHotspotY = 20;
    private String shadowURL = null;
    private int shadowWidth = 22;
    private int shadowHeight = 20;
    private String backURL = null;
    private int backWidth = 0;
    private int backHeight = 0;
    private int backOffsetX = 0;
    private int backOffsetY = 0;

    private static OrderedMap<String, PushpinIcon> _DefaultPushpinIconMap() {
        if (DefaultPushpinIconMap == null) {
            DefaultPushpinIconMap = new OrderedMap();
            DefaultPushpinIconMap.put((Object)"black", (Object)new PushpinIcon("black", null, PUSHPIN_BLACK, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"brown", (Object)new PushpinIcon("brown", null, PUSHPIN_BROWN, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"red", (Object)new PushpinIcon("red", null, PUSHPIN_RED, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"orange", (Object)new PushpinIcon("orange", null, PUSHPIN_ORANGE, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"yellow", (Object)new PushpinIcon("yellow", null, PUSHPIN_YELLOW, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"green", (Object)new PushpinIcon("green", null, PUSHPIN_GREEN, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"blue", (Object)new PushpinIcon("blue", null, PUSHPIN_BLUE, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"purple", (Object)new PushpinIcon("purple", null, PUSHPIN_PURPLE, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"gray", (Object)new PushpinIcon("gray", null, PUSHPIN_GRAY, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
            DefaultPushpinIconMap.put((Object)"white", (Object)new PushpinIcon("white", null, PUSHPIN_WHITE, ICON_SIZE, ICON_OFFSET, PUSHPIN_SHADOW, SHADOW_SIZE));
        }
        return DefaultPushpinIconMap;
    }

    public static OrderedMap<String, PushpinIcon> newDefaultPushpinIconMap() {
        return new OrderedMap(PushpinIcon._DefaultPushpinIconMap());
    }

    public static void writePushpinChooserJS(PrintWriter out, RequestProperties reqState, boolean inclBlank) throws IOException {
        Locale locale = reqState.getLocale();
        MapProvider mp = reqState.getMapProvider();
        HttpServletRequest request = reqState.getHttpServletRequest();
        OrderedMap<String, PushpinIcon> iconMap = mp != null ? mp.getPushpinIconMap(reqState) : null;
        JavaScriptTools.writeStartJavaScript(out);
        PushpinIcon.writePushpinImageArray(out, iconMap, locale, inclBlank);
        JavaScriptTools.writeEndJavaScript(out);
        JavaScriptTools.writeJSInclude(out, JavaScriptTools.qualifyJSFileRef("PushpinChooser.js"), request);
    }

    public static void writePushpinImageArray(PrintWriter out, OrderedMap<String, PushpinIcon> pushpinMap, Locale locale, boolean inclBlank) throws IOException {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("var ppcPushpinChooserList = new Array(\n");
        if (inclBlank) {
            I18N i18n = I18N.getI18N(PushpinIcon.class, (Locale)locale);
            String desc = i18n.getString("PushpinIcon.default", "default");
            sb.append("   { name:\"\", desc:\"" + desc + "\", isEval:false, image:\"\", width:24, height:0, index:-1 }");
            ++count;
        }
        if (pushpinMap != null) {
            int ppNdx = 0;
            for (PushpinIcon ppi : pushpinMap.values()) {
                String desc = ppi.getName();
                if (desc.length() > 4) {
                    int st = 0;
                    StringBuffer nd = new StringBuffer();
                    for (int c = 0; c < desc.length(); ++c) {
                        char ch = desc.charAt(c);
                        if (Character.isUpperCase(ch)) {
                            if (st != 0) {
                                nd.append(" ");
                                st = 0;
                            }
                            nd.append(ch);
                            continue;
                        }
                        if (Character.isLowerCase(ch)) {
                            if (st != 0 && st != 1) {
                                nd.append(" ");
                            }
                            st = 1;
                            nd.append(ch);
                            continue;
                        }
                        if (Character.isDigit(ch)) {
                            if (st != 2) {
                                nd.append(" ");
                                st = 2;
                            }
                            nd.append(ch);
                            continue;
                        }
                        if (st == 3) continue;
                        nd.append(" ");
                        st = 3;
                    }
                    desc = nd.toString().trim();
                }
                if (count++ > 0) {
                    sb.append(",\n");
                }
                sb.append("   {");
                sb.append(" name:\"").append(ppi.getName()).append("\",");
                sb.append(" desc:\"").append(desc).append("\",");
                sb.append(" isEval:").append(ppi.getIconEval()).append(",");
                sb.append(" image:\"").append(StringTools.blankDefault((String)ppi.getImageURL(), (String)"?")).append("\",");
                sb.append(" width:").append(ppi.getIconWidth()).append(",");
                sb.append(" height:").append(ppi.getIconHeight()).append(",");
                sb.append(" index:").append(ppNdx++);
                sb.append(" }");
            }
            sb.append("\n");
        }
        sb.append("   );\n");
        out.write(sb.toString());
    }

    public PushpinIcon(String name, String imageURL, String icon, boolean iconEval, int[] iconSize, int[] iconHotspot, String shadow, int[] shadowSize, String back, int[] backSize, int[] backOffset) {
        this.name = StringTools.trim((String)name);
        this.imageURL = StringTools.trim((String)imageURL);
        this.iconURL = StringTools.trim((String)icon);
        this.iconEval = iconEval;
        this.iconWidth = ListTools.size((int[])iconSize) >= 2 ? iconSize[0] : 0;
        this.iconHeight = ListTools.size((int[])iconSize) >= 2 ? iconSize[1] : 0;
        this.iconHotspotX = ListTools.size((int[])iconHotspot) >= 2 ? iconHotspot[0] : 0;
        this.iconHotspotY = ListTools.size((int[])iconHotspot) >= 2 ? iconHotspot[1] : 0;
        this.shadowURL = shadow;
        this.shadowWidth = ListTools.size((int[])shadowSize) >= 2 ? shadowSize[0] : 0;
        this.shadowHeight = ListTools.size((int[])shadowSize) >= 2 ? shadowSize[1] : 0;
        this.backURL = StringTools.trim((String)back);
        this.backWidth = ListTools.size((int[])backSize) >= 2 ? backSize[0] : 0;
        this.backHeight = ListTools.size((int[])backSize) >= 2 ? backSize[1] : 0;
        this.backOffsetX = ListTools.size((int[])backOffset) >= 2 ? backOffset[0] : 0;
        this.backOffsetY = ListTools.size((int[])backOffset) >= 2 ? backOffset[1] : 0;
    }

    public PushpinIcon(String name, String imageURL, String icon, int[] iconSize, int[] iconHotspot, String shadow, int[] shadowSize) {
        this(name, imageURL, icon, false, iconSize, iconHotspot, shadow, shadowSize, null, null, null);
    }

    public String getName() {
        return this.name;
    }

    public String getImageURL() {
        if (!StringTools.isBlank((String)this.imageURL)) {
            return this.imageURL;
        }
        if (!this.getIconEval()) {
            return this.getIconURL();
        }
        return "";
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public boolean getIconEval() {
        return this.iconEval;
    }

    public String getIconEvalURL(EventData e, int index) {
        if (!this.getIconEval()) {
            return this.getImageURL();
        }
        double e_speedKPH = e != null ? e.getSpeedKPH() : 0.0;
        double e_heading = e != null ? e.getHeading() : 0.0;
        String eval = this.getIconURL();
        if (eval.startsWith("evHeadingYellowURL(")) {
            if (e_speedKPH < 1.0) {
                return PUSHPIN_YELLOW;
            }
            int x = (int)Math.round(e_heading / 45.0) % 8;
            return "images/pp/pin30_yellow_h" + x + ".png";
        }
        if (eval.startsWith("evHeadingGreenURL(")) {
            if (e_speedKPH < 1.0) {
                return PUSHPIN_GREEN;
            }
            int x = (int)Math.round(e_heading / 45.0) % 8;
            return "images/pp/pin30_green_h" + x + ".png";
        }
        if (eval.startsWith("evHeadingMarkerURL(")) {
            if (e_speedKPH < 5.0) {
                return "images/pp/pin30_red_dot.png";
            }
            if (e_speedKPH < 32.0) {
                int x = (int)Math.round(e_heading / 45.0) % 8;
                return "images/pp/pin30_yellow_h" + x + ".png";
            }
            int x = (int)Math.round(e_heading / 45.0) % 8;
            return "images/pp/pin30_green_h" + x + ".png";
        }
        if (eval.startsWith("evHeadingMarkerURL_eu(")) {
            double speedMPH = e_speedKPH * 0.621371192237334;
            if (speedMPH < 5.0) {
                return "images/pp/pin30_red_dot.png";
            }
            if (speedMPH < 50.0) {
                int x = (int)Math.round(e_heading / 45.0) % 8;
                return "images/pp/pin30_yellow_h" + x + ".png";
            }
            if (speedMPH < 90.0) {
                int x = (int)Math.round(e_heading / 45.0) % 8;
                return "images/pp/pin30_green_h" + x + ".png";
            }
            if (speedMPH < 110.0) {
                return PUSHPIN_GRAY;
            }
            return PUSHPIN_BLACK;
        }
        if (eval.startsWith("evHeadingMarkerURL_ca(")) {
            if (e_speedKPH < 1.0) {
                return PUSHPIN_RED;
            }
            if (e_speedKPH < 70.0) {
                int x = (int)Math.round(e_heading / 45.0) % 8;
                return "images/pp/pin30_yellow_h" + x + ".png";
            }
            if (e_speedKPH < 100.0) {
                int x = (int)Math.round(e_heading / 45.0) % 8;
                return "images/pp/pin30_green_h" + x + ".png";
            }
            if (e_speedKPH < 130.0) {
                int x = (int)Math.round(e_heading / 45.0) % 8;
                return "images/pp/pin30_blue_h" + x + ".png";
            }
            int x = (int)Math.round(e_heading / 45.0) % 8;
            return "images/pp/pin30_gray_h" + x + ".png";
        }
        if (eval.startsWith("evDeviceNameIconURL(")) {
            Device dev = e != null ? e.getDevice() : null;
            String icon = "/images/pp/label47_fill.png";
            String fr = "3,2,42,13,9";
            String text = dev != null ? dev.getDisplayName() : (e != null ? e.getDeviceID() : "");
            String fill = "";
            String border = "";
            String color = "";
            String url = "Marker?icon=" + icon + "&fr=" + fr + "&fill=" + fill + "&border=" + border + "&color=" + color + "&text=" + StringTools.htmlFilterValue((Object)text);
            return url;
        }
        if (eval.startsWith("evArrowIconURL(")) {
            double arrow = e_heading;
            String icon = "/images/pp/pin30_cyan.png";
            String fr = "3,4,11,7,10";
            String text = "";
            String fill = "";
            String border = "";
            String color = "000000";
            String url = "Marker?icon=" + icon + "&fr=" + fr + "&fill=" + fill + "&border=" + border + "&color=" + color + "&arrow=" + arrow;
            return url;
        }
        if (eval.startsWith("evIndexedIconURL(")) {
            String icon = "/images/pp/pin30_blue_fill.png";
            String fr = "3,4,11,7,9,Serif";
            String text = String.valueOf(1);
            String fill = "";
            String border = "";
            String color = "880000";
            String url = "Marker?icon=" + icon + "&fr=" + fr + "&fill=" + fill + "&border=" + border + "&color=" + color + "&text=" + StringTools.htmlFilterValue((Object)text);
            return url;
        }
        return this.getImageURL();
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public int getIconHotspotX() {
        return this.iconHotspotX;
    }

    public int getIconHotspotY() {
        return this.iconHotspotY;
    }

    public String getShadowURL() {
        return this.shadowURL;
    }

    public int getShadowWidth() {
        return this.shadowWidth;
    }

    public int getShadowHeight() {
        return this.shadowHeight;
    }

    public String getBackgroundURL() {
        return this.backURL;
    }

    public int getBackgroundWidth() {
        return this.backWidth;
    }

    public int getBackgroundHeight() {
        return this.backHeight;
    }

    public int getBackgroundOffsetX() {
        return this.backOffsetX;
    }

    public int getBackgroundOffsetY() {
        return this.backOffsetY;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Icon:'").append(this.getIconURL()).append("', ");
        sb.append("IconSize:[").append(this.getIconWidth()).append(",").append(this.getIconHeight()).append("], ");
        sb.append("IconOffset:[").append(this.getIconHotspotX()).append(",").append(this.getIconHotspotY()).append("], ");
        sb.append("Shadow:'").append(this.getShadowURL()).append("', ");
        sb.append("ShadowSize:[").append(this.getShadowWidth()).append(",").append(this.getShadowHeight()).append("]");
        if (!StringTools.isBlank((String)this.getBackgroundURL())) {
            sb.append("Back:'").append(this.getBackgroundURL()).append("', ");
            sb.append("BackSize:[").append(this.getBackgroundWidth()).append(",").append(this.getBackgroundHeight()).append("], ");
            sb.append("BackOffset:[").append(this.getBackgroundOffsetX()).append(",").append(this.getBackgroundOffsetY()).append("], ");
        }
        return sb.toString();
    }

    public static class TextIcon {
        private File iconFile = null;
        private int frameOffset_x = 0;
        private int frameOffset_y = 0;
        private int frameWidth = 0;
        private int frameHeight = 0;
        private ImageIcon imageIcon = null;
        private Color fillColor = null;
        private Color bordColor = null;
        private Color foreColor = null;
        private String fontName = null;
        private double fontSize = 0.0;

        public TextIcon(File file, int xOfs, int yOfs, int xSiz, int ySiz) {
            this(file, xOfs, yOfs, xSiz, ySiz, 0, null);
        }

        public TextIcon(File file, int xOfs, int yOfs, int xSiz, int ySiz, int fontPt) {
            this(file, xOfs, yOfs, xSiz, ySiz, fontPt, null);
        }

        public TextIcon(File file, int xOfs, int yOfs, int xSiz, int ySiz, int fontPt, String fontName) {
            this.iconFile = file != null && file.isFile() ? file : null;
            this.frameOffset_x = xOfs;
            this.frameOffset_y = yOfs;
            this.frameWidth = xSiz;
            this.frameHeight = ySiz;
            this.fontSize = fontPt > 0 ? (double)fontPt : 8.0;
            this.fontName = StringTools.blankDefault((String)fontName, (String)DEFAULT_TEXT_FONT);
            try {
                this.imageIcon = this.iconFile != null ? new ImageIcon(this.iconFile.toString()) : null;
            }
            catch (Throwable th) {
                Print.logError((String)("Unable to create ImageIcon: " + th), (Object[])new Object[0]);
                this.imageIcon = null;
            }
        }

        public void setFillColor(Color color) {
            this.fillColor = color;
        }

        public void setBorderColor(Color color) {
            this.bordColor = color;
        }

        public int getFrameOffset_X() {
            return this.frameOffset_x;
        }

        public void setForegroundColor(Color color) {
            this.foreColor = color;
        }

        public int getFrameOffset_Y() {
            return this.frameOffset_y;
        }

        public int getFrameWidth() {
            return this.frameWidth;
        }

        public int getFrameHeight() {
            return this.frameHeight;
        }

        public String getFontName() {
            return !StringTools.isBlank((String)this.fontName) ? this.fontName : DEFAULT_TEXT_FONT;
        }

        public double getFontSize() {
            return this.fontSize > 0.0 ? this.fontSize : 8.0;
        }

        public boolean hasImageIcon() {
            return this.imageIcon != null && this.imageIcon.getImageLoadStatus() == 8;
        }

        public ImageIcon getImageIcon() {
            return this.hasImageIcon() ? this.imageIcon : null;
        }

        public RenderedImage createImage(String text, double arrow) {
            ImageIcon icon = this.getImageIcon();
            if (icon == null) {
                return null;
            }
            int xOfs = this.getFrameOffset_X();
            int yOfs = this.getFrameOffset_Y();
            int xSiz = this.getFrameWidth();
            int ySiz = this.getFrameHeight();
            BufferedImage image = null;
            Graphics2D g2D = null;
            try {
                int W = icon.getIconWidth();
                int H = icon.getIconHeight();
                image = new BufferedImage(W, H, 2);
                g2D = image.createGraphics();
                g2D.drawImage(icon.getImage(), 0, 0, W, H, new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int W, int H) {
                        return false;
                    }
                });
                if (this.fillColor != null) {
                    g2D.setColor(this.fillColor);
                    g2D.fillRect(xOfs, yOfs, xSiz, ySiz);
                }
                if (this.bordColor != null) {
                    g2D.setColor(this.bordColor);
                    g2D.drawRect(xOfs, yOfs, xSiz - 1, ySiz - 1);
                }
            }
            catch (Throwable th) {
                Print.logError((String)("Unable to create TextIcon image: " + th), (Object[])new Object[0]);
                return null;
            }
            try {
                text = StringTools.trim((String)text);
                int txLen = text.length();
                if (txLen > 0) {
                    double pt = this.getFontSize();
                    g2D.setFont(new Font(this.getFontName(), 0, (int)Math.round(pt)));
                    g2D.setColor(this.foreColor != null ? this.foreColor : Color.black);
                    double txPx = g2D.getFontMetrics().stringWidth(text);
                    double dx = ((double)xSiz - txPx) / 2.0;
                    double dy = ((double)ySiz - pt) / 2.0 + pt - 1.0;
                    if (dx < 0.0) {
                        dx = 0.0;
                    }
                    g2D.drawString(text, (float)((double)xOfs + dx), (float)((double)yOfs + dy));
                }
            }
            catch (Throwable th) {
                Print.logError((String)("Unable to draw text into Icon: " + th), (Object[])new Object[0]);
            }
            try {
                if (arrow == 360.0) {
                    double D = (double)Math.min(xSiz, ySiz) - 5.0;
                    double dx = (double)xOfs + ((double)xSiz - D) / 2.0;
                    double dy = (double)yOfs + ((double)ySiz - D) / 2.0;
                    Ellipse2D.Double circle = new Ellipse2D.Double(dx, dy, D, D);
                    g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (this.bordColor != null) {
                        g2D.setColor(this.bordColor);
                        g2D.draw(circle);
                    } else {
                        g2D.setColor(Color.black);
                        g2D.draw(circle);
                    }
                    g2D.setColor(this.foreColor != null ? this.foreColor : Color.black);
                    g2D.fill(circle);
                } else if (arrow >= 0.0) {
                    int ayOfs;
                    double L = (double)Math.min(xSiz, ySiz) - 2.0;
                    Polygon poly = new Polygon();
                    double thetaR = (360.0 - (arrow - 20.0) % 360.0) * (Math.PI / 180);
                    double thetaC = (360.0 - arrow % 360.0) * (Math.PI / 180);
                    double thetaL = (360.0 - (arrow + 20.0) % 360.0) * (Math.PI / 180);
                    double dx = Math.sin(thetaC) * L;
                    double dy = Math.cos(thetaC) * L;
                    int axOfs = xOfs + xSiz / 2 - (int)Math.round(dx / 2.0);
                    if (axOfs < 0) {
                        axOfs = 0;
                    }
                    if ((ayOfs = yOfs + ySiz / 2 - (int)Math.round(dy / 2.0) - 1) < 0) {
                        ayOfs = 0;
                    }
                    poly.addPoint(0, 0);
                    poly.addPoint((int)(Math.sin(thetaR) * L), (int)(Math.cos(thetaR) * L));
                    poly.addPoint((int)(Math.sin(thetaC) * (L - 2.0)), (int)(Math.cos(thetaC) * (L - 2.0)));
                    poly.addPoint((int)(Math.sin(thetaL) * L), (int)(Math.cos(thetaL) * L));
                    poly.addPoint(0, 0);
                    poly.translate(axOfs, ayOfs);
                    g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (this.bordColor != null) {
                        g2D.setColor(this.bordColor);
                        g2D.draw(poly);
                    } else {
                        g2D.setColor(Color.black);
                        g2D.draw(poly);
                    }
                    g2D.setColor(this.foreColor != null ? this.foreColor : Color.black);
                    g2D.fill(poly);
                }
            }
            catch (Throwable th) {
                Print.logError((String)("Unable to draw arrow into Icon: " + th), (Object[])new Object[0]);
            }
            try {
                g2D.dispose();
            }
            catch (Throwable th) {
                Print.logError((String)("Error disposing image graphics: " + th), (Object[])new Object[0]);
            }
            return image;
        }
    }
}

