/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.PoiProvider;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportFactory;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.MapProviderAdapter;
import org.opengts.war.tools.MapShape;
import org.opengts.war.tools.MenuGroup;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.PushpinIcon;
import org.opengts.war.tools.WebPage;
import org.opengts.war.tools.WebPageAdaptor;
import org.opengts.war.tools.WebPageURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrivateLabelLoader
extends BasicPrivateLabelLoader {
    public static final String PROP_PrivateLabelLoader_skipTag_WebPages = "PrivateLabelLoader.skipTag_WebPages";
    private static int _skipTag_WebPages = -1;
    public static final String PROP_PrivateLabelLoader_skipTag_MapProvider = "PrivateLabelLoader.skipTag_MapProvider";
    private static int _skipTag_MapProvider = -1;

    public static boolean GetSkipTag_WebPages() {
        if (_skipTag_WebPages < 0) {
            int n = _skipTag_WebPages = RTConfig.getBoolean((String)PROP_PrivateLabelLoader_skipTag_WebPages, (boolean)false) ? 1 : 0;
            if (_skipTag_WebPages == 1) {
                Print.logWarn((String)"Skipping 'private.xml' WebPages ...", (Object[])new Object[0]);
            }
        }
        return _skipTag_WebPages == 1;
    }

    public static boolean GetSkipTag_MapProvider() {
        if (_skipTag_MapProvider < 0) {
            int n = _skipTag_MapProvider = RTConfig.getBoolean((String)PROP_PrivateLabelLoader_skipTag_MapProvider, (boolean)false) ? 1 : 0;
            if (_skipTag_MapProvider == 1) {
                Print.logWarn((String)"Skipping 'private.xml' MapProvider ...", (Object[])new Object[0]);
            }
        }
        return _skipTag_MapProvider == 1;
    }

    protected BasicPrivateLabel createPrivateLabel(File xmlFile, String hostName) {
        return new PrivateLabel(hostName);
    }

    protected int _resetLoadDefaultXML() {
        int count = 0;
        if (PrivateLabelLoader.isTrackServlet()) {
            ReportFactory.loadReportDefinitionXML();
            count = super._resetLoadDefaultXML();
            if (ReportFactory.hasParsingErrors()) {
                this._setHasParsingErrors(null);
            }
        } else {
            count = super._resetLoadDefaultXML();
        }
        return count;
    }

    protected void parseTag_MapProvider(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element mapProvElem, OrderedMap<String, Object> dftPushpinMap, OrderedMap<String, String> dftLegend) {
        PrivateLabel pl = (PrivateLabel)bpl;
        if (PrivateLabelLoader.GetSkipTag_MapProvider()) {
            return;
        }
        String mapName = XMLTools.getAttribute((Element)mapProvElem, (String)"name", null, (boolean)false);
        if (StringTools.isBlank((String)mapName)) {
            PrivateLabelLoader.printError((String)"MapProvider 'name' not specified.", (Object[])new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        String active = XMLTools.getAttribute((Element)mapProvElem, (String)"active", null, (boolean)true);
        if (!PrivateLabelLoader._isAttributeActive((String)active, (String)mapName)) {
            Print.logDebug((String)("Ignoring inactive MapProvider: " + mapName), (Object[])new Object[0]);
            return;
        }
        String mapClass = XMLTools.getAttribute((Element)mapProvElem, (String)"class", null, (boolean)false);
        if (StringTools.isBlank((String)mapClass)) {
            PrivateLabelLoader.printError((String)"MapProvider 'class' not specified.", (Object[])new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        String mapKey = XMLTools.getAttribute((Element)mapProvElem, (String)"key", null, (boolean)true);
        String keyPrefix = XMLTools.getAttribute((Element)mapProvElem, (String)"rtPropPrefix", null, (boolean)true);
        MapProvider mp = null;
        MapProviderAdapter mpa = null;
        try {
            Class<?> providerClass = Class.forName(mapClass);
            MethodAction ma = new MethodAction((Object)mapClass, new Class[]{String.class, String.class});
            mp = (MapProvider)ma.invoke(new Object[]{mapName, mapKey});
            if (pl.getMapProviderCount() > 0) {
                MapProvider firstMP = pl.getMapProvider();
                PrivateLabelLoader.printError((String)("More than one MapProvider defined: " + firstMP.getName() + ", " + mapName), (Object[])new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
            Print.logDebug((String)("Adding MapProvider: " + mapName), (Object[])new Object[0]);
            pl.addMapProvider(mp);
            if (mp instanceof MapProviderAdapter) {
                mpa = (MapProviderAdapter)mp;
            }
        }
        catch (ClassNotFoundException cnfe) {
            PrivateLabelLoader.printError((String)("MapProvider class not found: " + mapClass), (Object[])new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        catch (Throwable t) {
            PrivateLabelLoader.printError((String)("MapProvider creation error: " + mapClass + " [" + t), (Object[])new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        if (!ListTools.isEmpty(dftPushpinMap)) {
            OrderedMap<String, PushpinIcon> pushpinMap = mp.getPushpinIconMap(null);
            for (String ppKey : dftPushpinMap.keySet()) {
                PushpinIcon ppi = (PushpinIcon)dftPushpinMap.get((Object)ppKey);
                pushpinMap.put((Object)ppKey, (Object)ppi);
            }
        }
        NodeList attrList = mapProvElem.getChildNodes();
        for (int c = 0; c < attrList.getLength(); ++c) {
            String key;
            Node attrNode = attrList.item(c);
            if (!(attrNode instanceof Element)) continue;
            String attrName = attrNode.getNodeName();
            Element attrElem = (Element)attrNode;
            if (attrName.equalsIgnoreCase("Property")) {
                String key2 = this._adjustPropertyKey(xmlFile, XMLTools.getAttribute((Element)attrElem, (String)"key", null, (boolean)false));
                String rtKey = StringTools.blankDefault((String)XMLTools.getAttribute((Element)attrElem, (String)"rtKey", null, (boolean)false), (String)key2);
                if (!StringTools.isBlank((String)key2)) {
                    String v;
                    boolean valTrim = XMLTools.getAttributeBoolean((Element)attrElem, (String)"trim", (boolean)true, (boolean)false);
                    String val = XMLTools.getNodeText((Node)attrElem, (String)(valTrim ? "\n" : null), (boolean)true);
                    if (!StringTools.isBlank((String)keyPrefix) && (v = RTConfig.getString((String)(keyPrefix + rtKey), null)) != null) {
                        Print.logDebug((String)"[%s] Property override '%s' ==> '%s' (was '%s')", (Object[])new Object[]{mapName, key2, v, val});
                        val = v;
                    }
                    Print.logDebug((String)"[%s] Property '%s' ==> '%s'", (Object[])new Object[]{mapName, key2, val});
                    mp.getProperties().setProperty((Object)key2, (Object)val);
                    continue;
                }
                PrivateLabelLoader.printWarn((String)"Undefined property key ignored.", (Object[])new Object[0]);
                this._setHasParsingWarnings(xmlFile);
                continue;
            }
            if (attrName.equalsIgnoreCase("Pushpins")) {
                OrderedMap<String, Object> ppMap = this.parseTAG_Pushpins(xmlFile, pl, attrElem, dftPushpinMap, false);
                if (ppMap == null) continue;
                OrderedMap<String, PushpinIcon> mpPushpins = mp.getPushpinIconMap(null);
                for (String ppKey : ppMap.keySet()) {
                    PushpinIcon ppi = (PushpinIcon)ppMap.get((Object)ppKey);
                    mpPushpins.put((Object)ppKey, (Object)ppi);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase("IconSelector")) {
                Object[] rfName = StringTools.split((String)XMLTools.getAttribute((Element)attrElem, (String)"ruleFactoryName", (String)"", (boolean)false), (char)',');
                RuleFactory rf = Device.getRuleFactory((boolean)true);
                if (rf == null || !ListTools.isEmpty((Object[])rfName) && !ListTools.containsIgnoreCase((String[])rfName, (String)rf.getName())) continue;
                boolean isFleet = XMLTools.getAttribute((Element)attrElem, (String)"type", (String)"", (boolean)false).equalsIgnoreCase("fleet");
                String iconSel = XMLTools.getNodeText((Node)attrElem, (String)" ", (boolean)false).trim();
                if (!rf.checkSelectorSyntax(iconSel)) {
                    Print.logError((String)("[" + xmlFile + "] Invalid IconSelector syntax: " + iconSel + " [" + rf.getName() + "]"), (Object[])new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                    continue;
                }
                if (mpa != null) {
                    mpa.setIconSelector(isFleet, iconSel);
                    continue;
                }
                key = isFleet ? MapProvider.PROP_iconSel_fleet[0] : MapProvider.PROP_iconSelector[0];
                mp.getProperties().setProperty((Object)key, (Object)iconSel);
                continue;
            }
            if (attrName.equalsIgnoreCase("Legend")) {
                String legType = XMLTools.getAttribute((Element)attrElem, (String)"type", (String)"", (boolean)false);
                boolean isFleet = legType.equalsIgnoreCase("fleet");
                String legend = StringTools.replace((String)XMLTools.getNodeText((Node)attrElem, (String)"\n", (boolean)true), (String)"\\n", (String)"\n").trim();
                boolean useDefault = XMLTools.getAttributeBoolean((Element)attrElem, (String)"includeDefault", (boolean)false, (boolean)false);
                if (useDefault && dftLegend != null && dftLegend.containsKey((Object)legType)) {
                    legend = (String)dftLegend.get((Object)legType);
                } else if (StringTools.isBlank((String)legend) && mpa != null) {
                    String refName = xmlFile.getName() + ":" + mpa.getName();
                    Locale locale = bpl.getLocale();
                    OrderedMap<String, PushpinIcon> pushpinMap = mpa.getPushpinIconMap(null);
                    legend = MapProviderAdapter.GetIconLegendHtml(refName, locale, pushpinMap, legType, attrElem, true);
                }
                if (mpa != null) {
                    mpa.setIconSelectorLegend(isFleet, legend);
                    continue;
                }
                key = isFleet ? MapProvider.PROP_iconSel_fleet_legend[0] : MapProvider.PROP_iconSelector_legend[0];
                mp.getProperties().setProperty((Object)key, (Object)legend);
                continue;
            }
            if (attrName.equalsIgnoreCase("LogMessage")) {
                this.parseTag_LogMessage(xmlFile, pl, attrElem);
                continue;
            }
            Print.logWarn((String)("MapProvider sub-tag not recognized: " + attrName), (Object[])new Object[0]);
        }
        if (mpa != null) {
            mpa.postInit();
        }
    }

    protected String parseLegendHTML(String refName, Locale locale, OrderedMap pushpins, String legendType, Element legendElem) {
        OrderedMap pushpinMap = pushpins;
        return MapProviderAdapter.GetIconLegendHtml(refName, locale, (OrderedMap<String, PushpinIcon>)pushpinMap, legendType, legendElem, true);
    }

    private int[] _parseDim(String dim) {
        String[] d = StringTools.split((String)dim, (char)',');
        return new int[]{d.length > 0 ? StringTools.parseInt((String)d[0], (int)0) : 0, d.length > 1 ? StringTools.parseInt((String)d[1], (int)0) : 0};
    }

    protected OrderedMap<String, Object> parseTAG_Pushpins(File xmlFile, BasicPrivateLabel pl, Element attrElem, OrderedMap<String, Object> dftPushpinMap, boolean isGlobalPushpins) {
        String baseURL = XMLTools.getAttribute((Element)attrElem, (String)"baseURL", (String)"", (boolean)false);
        OrderedMap pushpinMap = new OrderedMap();
        boolean inclDefault = XMLTools.getAttributeBoolean((Element)attrElem, (String)"includeDefault", (boolean)false, (boolean)false);
        if (inclDefault) {
            if (!ListTools.isEmpty(dftPushpinMap)) {
                pushpinMap.putAll(dftPushpinMap);
                if (isGlobalPushpins) {
                    for (String ppKey : dftPushpinMap.keySet()) {
                        PushpinIcon ppi = (PushpinIcon)dftPushpinMap.get((Object)ppKey);
                        PrivateLabel.GetGlobalPushpinIcons().put((Object)ppKey, (Object)ppi);
                    }
                }
            } else {
                PrivateLabelLoader.printWarn((String)"Pushpins 'includeDefault' specified, but no default pushpins defined!", (Object[])new Object[0]);
                this._setHasParsingWarnings(xmlFile);
            }
        }
        NodeList iconList = attrElem.getChildNodes();
        for (int i = 0; i < iconList.getLength(); ++i) {
            Node iconNode = iconList.item(i);
            if (!(iconNode instanceof Element)) continue;
            String iconTagName = iconNode.getNodeName();
            Element iconElem = (Element)iconNode;
            if (iconTagName.equalsIgnoreCase("Pushpin")) {
                String key = XMLTools.getAttribute((Element)iconElem, (String)"key", null, (boolean)false);
                if (!StringTools.isBlank((String)key)) {
                    String shadowURL;
                    String imageURL;
                    int[] iconHotspot;
                    boolean iconEval = false;
                    String iconJS = XMLTools.getAttribute((Element)iconElem, (String)"eval", (String)"", (boolean)false).trim();
                    String iconURL = XMLTools.getAttribute((Element)iconElem, (String)"icon", (String)"", (boolean)false).trim();
                    String alias = XMLTools.getAttribute((Element)iconElem, (String)"alias", (String)"", (boolean)false).trim();
                    if (!alias.equals("")) {
                        if (!iconJS.equals("") || !iconURL.equals("")) {
                            PrivateLabelLoader.printWarn((String)"Pushpin 'evel'/'icon' may not be specified with 'alias'", (Object[])new Object[0]);
                            this._setHasParsingWarnings(xmlFile);
                            continue;
                        }
                        PushpinIcon ppi = (PushpinIcon)pushpinMap.get((Object)alias);
                        if (ppi != null || inclDefault || !ListTools.isEmpty(dftPushpinMap)) {
                            // empty if block
                        }
                        if (ppi != null) {
                            pushpinMap.put((Object)key, (Object)ppi);
                            if (!isGlobalPushpins) continue;
                            PrivateLabel.GetGlobalPushpinIcons().put((Object)key, (Object)ppi);
                            continue;
                        }
                        PrivateLabelLoader.printWarn((String)"Pushpin icon 'alias' not defined: key=%s, alias=%s", (Object[])new Object[]{key, alias});
                        this._setHasParsingWarnings(xmlFile);
                        continue;
                    }
                    if (!iconJS.equals("") && !iconURL.equals("")) {
                        PrivateLabelLoader.printWarn((String)"Pushpin 'eval' and 'icon' are mutally exclusive, Pushpin ignored", (Object[])new Object[0]);
                        this._setHasParsingWarnings(xmlFile);
                        iconURL = "";
                    } else if (iconJS.equalsIgnoreCase("DELETE") || iconURL.equalsIgnoreCase("DELETE")) {
                        pushpinMap.remove((Object)key);
                        if (isGlobalPushpins) {
                            PrivateLabel.GetGlobalPushpinIcons().remove((Object)key);
                        }
                        iconURL = "";
                    } else if (!iconJS.equals("")) {
                        iconEval = true;
                        iconURL = iconJS;
                        if (StringTools.endsWithIgnoreCase((String)iconURL, (String[])new String[]{".png", ".gif", ".jpg", ".jpeg"})) {
                            PrivateLabelLoader.printWarn((String)("JavaScript evaluated String may be an image file reference: " + iconURL), (Object[])new Object[0]);
                            this._setHasParsingWarnings(xmlFile);
                        }
                    } else if (!iconURL.equals("")) {
                        iconEval = false;
                        iconURL = baseURL + iconURL;
                    } else {
                        PrivateLabelLoader.printWarn((String)"One of Pushpin 'eval' or 'icon' must be specified", (Object[])new Object[0]);
                        this._setHasParsingWarnings(xmlFile);
                        iconURL = "";
                    }
                    if (iconURL.equals("")) continue;
                    int[] iconSize = this._parseDim(XMLTools.getAttribute((Element)iconElem, (String)"iconSize", (String)"12,20", (boolean)false));
                    String hotspot = XMLTools.getAttribute((Element)iconElem, (String)"iconHotspot", null, (boolean)false);
                    if (StringTools.isBlank((String)hotspot) && StringTools.isBlank((String)(hotspot = XMLTools.getAttribute((Element)iconElem, (String)"iconAnchor", null, (boolean)false))) && StringTools.isBlank((String)(hotspot = XMLTools.getAttribute((Element)iconElem, (String)"iconOffset", null, (boolean)false)))) {
                        hotspot = "-1,-1";
                    }
                    if ((iconHotspot = this._parseDim(hotspot))[0] < 0) {
                        iconHotspot[0] = iconSize[0] / 2;
                    }
                    if (iconHotspot[1] < 0) {
                        iconHotspot[1] = iconSize[1];
                    }
                    if (!StringTools.isBlank((String)(imageURL = XMLTools.getAttribute((Element)iconElem, (String)"image", (String)"", (boolean)false).trim()))) {
                        imageURL = baseURL + imageURL;
                    }
                    if (!StringTools.isBlank((String)(shadowURL = XMLTools.getAttribute((Element)iconElem, (String)"shadow", (String)"", (boolean)false).trim()))) {
                        shadowURL = baseURL + shadowURL;
                    }
                    int[] shadowSize = this._parseDim(XMLTools.getAttribute((Element)iconElem, (String)"shadowSize", (String)"22,20", (boolean)false));
                    String backURL = XMLTools.getAttribute((Element)iconElem, (String)"back", (String)"", (boolean)false).trim();
                    if (!StringTools.isBlank((String)backURL)) {
                        backURL = baseURL + backURL;
                    }
                    int[] backSize = this._parseDim(XMLTools.getAttribute((Element)iconElem, (String)"backSize", (String)"0,0", (boolean)false));
                    int[] backOffset = this._parseDim(XMLTools.getAttribute((Element)iconElem, (String)"backOffset", (String)"-1,-1", (boolean)false));
                    if (backOffset[0] < 0) {
                        backOffset[0] = backSize[0] / 2;
                    }
                    if (backOffset[1] < 0) {
                        backOffset[1] = backSize[1] / 2;
                    }
                    PushpinIcon ppi = new PushpinIcon(key, imageURL, iconURL, iconEval, iconSize, iconHotspot, shadowURL, shadowSize, backURL, backSize, backOffset);
                    pushpinMap.put((Object)key, (Object)ppi);
                    if (!isGlobalPushpins) continue;
                    PrivateLabel.GetGlobalPushpinIcons().put((Object)key, (Object)ppi);
                    continue;
                }
                PrivateLabelLoader.printWarn((String)"Pushpin missing 'key' attribute", (Object[])new Object[0]);
                this._setHasParsingWarnings(xmlFile);
                continue;
            }
            if (!iconTagName.equalsIgnoreCase("LogMessage")) continue;
            this.parseTag_LogMessage(xmlFile, pl, iconElem);
        }
        return pushpinMap;
    }

    protected void parseTag_JSPEntries(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element jspFiles) {
        String keyPrefix = XMLTools.getAttribute((Element)jspFiles, (String)"rtPropPrefix", null, (boolean)true);
        HashMap<String, PrivateLabel.JSPEntry> jspMap = new HashMap<String, PrivateLabel.JSPEntry>();
        PrivateLabel pl = (PrivateLabel)bpl;
        boolean foundDefault = false;
        NodeList jspList = jspFiles.getChildNodes();
        for (int j = 0; j < jspList.getLength(); ++j) {
            Node jspNode = jspList.item(j);
            if (!(jspNode instanceof Element)) continue;
            Element jspElem = (Element)jspNode;
            String jspElemName = jspElem.getNodeName();
            if (jspElemName.equalsIgnoreCase("JSP")) {
                String v;
                String name = XMLTools.getAttribute((Element)jspElem, (String)"name", null, (boolean)false);
                String rtKey = StringTools.blankDefault((String)XMLTools.getAttribute((Element)jspElem, (String)"rtKey", null, (boolean)false), (String)name);
                String file = XMLTools.getAttribute((Element)jspElem, (String)"file", null, (boolean)false);
                String i18nKey = XMLTools.getAttribute((Element)jspElem, (String)"i18n", null, (boolean)false);
                String desc = XMLTools.getNodeText((Node)jspElem, (String)"\\n", (boolean)false);
                I18N.Text descTxt = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey, (String)desc);
                if (StringTools.isBlank((String)name)) {
                    Print.logError((String)("[" + xmlFile + "] Blank JSP Entry name"), (Object[])new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                    continue;
                }
                if (!StringTools.isBlank((String)keyPrefix) && (v = RTConfig.getString((String)(keyPrefix + rtKey), null)) != null) {
                    file = v;
                }
                if (StringTools.isBlank((String)file)) {
                    Print.logError((String)("[" + xmlFile + "] Blank JSP Entry file: " + name), (Object[])new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                    continue;
                }
                PrivateLabel.JSPEntry jsp = new PrivateLabel.JSPEntry(name, descTxt, file);
                jspMap.put(name, jsp);
                if (foundDefault || !name.equals("default")) continue;
                foundDefault = true;
                continue;
            }
            if (!jspElemName.equalsIgnoreCase("LogMessage")) continue;
            this.parseTag_LogMessage(xmlFile, pl, jspElem);
        }
        pl.setJSPMap(jspMap);
        if (!foundDefault) {
            Print.logError((String)("[" + xmlFile + "] \"" + "default" + "\" JSP page not found."), (Object[])new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
    }

    protected void parseTag_WebPages(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element webPages) {
        if (PrivateLabelLoader.GetSkipTag_WebPages()) {
            return;
        }
        OrderedMap pageMap = new OrderedMap();
        OrderedMap menuGroupMap = new OrderedMap();
        PrivateLabel pl = (PrivateLabel)bpl;
        String keyPrefix = XMLTools.getAttribute((Element)webPages, (String)"rtPropPrefix", null, (boolean)true);
        String dftJSP = XMLTools.getAttribute((Element)webPages, (String)"jsp", null, (boolean)false);
        String dftCssDir = XMLTools.getAttribute((Element)webPages, (String)"cssDir", null, (boolean)false);
        String dftIconDir = XMLTools.getAttribute((Element)webPages, (String)"iconDir", null, (boolean)false);
        String dftButtonDir = XMLTools.getAttribute((Element)webPages, (String)"buttonDir", null, (boolean)false);
        if (!StringTools.isBlank((String)keyPrefix)) {
            dftJSP = RTConfig.getString((String)(keyPrefix + "jsp"), (String)dftJSP);
            dftCssDir = RTConfig.getString((String)(keyPrefix + "cssDir"), (String)dftCssDir);
            dftIconDir = RTConfig.getString((String)(keyPrefix + "iconDir"), (String)dftIconDir);
            dftButtonDir = RTConfig.getString((String)(keyPrefix + "buttonDir"), (String)dftButtonDir);
        }
        if (!StringTools.isBlank((String)dftJSP)) {
            pl.setWebPageJSP(dftJSP);
        }
        if (!StringTools.isBlank((String)dftCssDir)) {
            pl.setCssDirectory(dftCssDir);
        }
        this._parseTag_WebPages(xmlFile, i18nPkgName, pl, dftJSP, dftCssDir, dftIconDir, dftButtonDir, keyPrefix, webPages, (Map<String, WebPage>)pageMap, null, (Map<String, MenuGroup>)menuGroupMap);
        pl.setWebPageMap((Map<String, WebPage>)pageMap);
        pl.setMenuGroupMap((Map<String, MenuGroup>)menuGroupMap);
    }

    private void _parseTag_WebPages(File xmlFile, String i18nPkgName, PrivateLabel pl, String dftJSP, String dftCssDir, String dftIconDir, String dftButtonDir, String keyPrefix, Element webPages, Map<String, WebPage> pageMap, MenuGroup menuGroup, Map<String, MenuGroup> menuGroupMap) {
        NodeList webPageList = webPages.getChildNodes();
        for (int p = 0; p < webPageList.getLength(); ++p) {
            String i18nKey;
            Node wpNode = webPageList.item(p);
            if (!(wpNode instanceof Element)) continue;
            Element wpElem = (Element)wpNode;
            String wpElemName = wpElem.getNodeName();
            if (wpElemName.equalsIgnoreCase("MenuGroup")) {
                if (menuGroup == null) {
                    String mgName = XMLTools.getAttribute((Element)wpElem, (String)"name", null, (boolean)false);
                    boolean menuBar = XMLTools.getAttributeBoolean((Element)wpElem, (String)"menuBar", (boolean)true, (boolean)false);
                    boolean topMenu = XMLTools.getAttributeBoolean((Element)wpElem, (String)"topMenu", (boolean)true, (boolean)false);
                    MenuGroup mg = new MenuGroup(mgName);
                    mg.setShowInMenuBar(menuBar);
                    mg.setShowInTopMenu(topMenu);
                    menuGroupMap.put(mgName, mg);
                    this._parseTag_WebPages(xmlFile, i18nPkgName, pl, dftJSP, dftCssDir, dftIconDir, dftButtonDir, keyPrefix, wpElem, pageMap, mg, menuGroupMap);
                    continue;
                }
                PrivateLabelLoader.printError((String)"Recursive 'MenuGroup' tags not allowed", (Object[])new Object[0]);
                this._setHasParsingErrors(xmlFile);
                continue;
            }
            if (wpElemName.equalsIgnoreCase("Title")) {
                if (menuGroup != null) {
                    i18nKey = XMLTools.getAttribute((Element)wpElem, (String)"i18n", null, (boolean)false);
                    String titleDft = XMLTools.getNodeText((Node)wpElem, (String)"\\n", (boolean)false);
                    menuGroup.setTitle(BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey, (String)titleDft));
                    continue;
                }
                PrivateLabelLoader.printError((String)"'MenuGroup' not defined", (Object[])new Object[0]);
                this._setHasParsingErrors(xmlFile);
                continue;
            }
            if (wpElemName.equalsIgnoreCase("Description")) {
                if (menuGroup != null) {
                    i18nKey = XMLTools.getAttribute((Element)wpElem, (String)"i18n", null, (boolean)false);
                    String descDft = XMLTools.getNodeText((Node)wpElem, (String)"\\n", (boolean)false);
                    menuGroup.setDescription(BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey, (String)descDft));
                    continue;
                }
                PrivateLabelLoader.printError((String)"'MenuGroup' not defined", (Object[])new Object[0]);
                this._setHasParsingErrors(xmlFile);
                continue;
            }
            if (wpElemName.equalsIgnoreCase("Page")) {
                boolean enabled;
                String rtKeyPfx;
                Element page = wpElem;
                String pageName = XMLTools.getAttribute((Element)page, (String)"name", null, (boolean)false);
                String rtKey = StringTools.blankDefault((String)XMLTools.getAttribute((Element)page, (String)"rtKey", null, (boolean)false), (String)pageName);
                String string = rtKeyPfx = !StringTools.isBlank((String)keyPrefix) ? keyPrefix + rtKey : null;
                if (!StringTools.isBlank(rtKeyPfx) && RTConfig.hasProperty(rtKeyPfx)) {
                    enabled = RTConfig.getBoolean((String)rtKeyPfx, (boolean)true);
                    if (!enabled) {
                        Print.logDebug((String)("Ignoring Page '" + pageName + "'- property is false: " + rtKeyPfx), (Object[])new Object[0]);
                        continue;
                    }
                } else {
                    enabled = XMLTools.getAttributeBoolean((Element)page, (String)"enabled", (boolean)true, (boolean)false);
                    if (!enabled) {
                        Print.logDebug((String)("Ignoring Page '" + pageName + "' - page not enabled"), (Object[])new Object[0]);
                        continue;
                    }
                }
                String pageAlias = XMLTools.getAttribute((Element)page, (String)"alias", null, (boolean)false);
                String classname = XMLTools.getAttribute((Element)page, (String)"class", null, (boolean)false);
                boolean optional = XMLTools.getAttributeBoolean((Element)page, (String)"optional", (boolean)false, (boolean)false);
                String aclName = XMLTools.getAttribute((Element)page, (String)"aclName", null, (boolean)false);
                String jspURI = XMLTools.getAttribute((Element)page, (String)"jsp", null, (boolean)false);
                String cssDir = XMLTools.getAttribute((Element)page, (String)"cssDir", null, (boolean)false);
                String iconURI = XMLTools.getAttribute((Element)page, (String)"icon", null, (boolean)false);
                String buttonURI = XMLTools.getAttribute((Element)page, (String)"button", null, (boolean)false);
                String buttonALT = XMLTools.getAttribute((Element)page, (String)"altButton", null, (boolean)false);
                I18N.Text navDesc = null;
                I18N.Text navTab = null;
                I18N.Text menuDesc = null;
                I18N.Text menuHelp = null;
                RTProperties rtProps = null;
                NodeList chList = page.getChildNodes();
                for (int c = 0; c < chList.getLength(); ++c) {
                    String i18nKey2;
                    Node chNode = chList.item(c);
                    if (!(chNode instanceof Element)) continue;
                    String childName = chNode.getNodeName();
                    Element childElem = (Element)chNode;
                    if (childName.equalsIgnoreCase("NavigationDescription")) {
                        i18nKey2 = XMLTools.getAttribute((Element)childElem, (String)"i18n", null, (boolean)false);
                        String text = XMLTools.getNodeText((Node)childElem, (String)" ", (boolean)false);
                        navDesc = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey2, (String)text, (boolean)false);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("NavigationTab")) {
                        i18nKey2 = XMLTools.getAttribute((Element)childElem, (String)"i18n", null, (boolean)false);
                        String text = XMLTools.getNodeText((Node)childElem, (String)" ", (boolean)false);
                        navTab = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey2, (String)text, (boolean)false);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("MenuDescription")) {
                        i18nKey2 = XMLTools.getAttribute((Element)childElem, (String)"i18n", null, (boolean)false);
                        String text = XMLTools.getNodeText((Node)childElem, (String)" ", (boolean)false);
                        menuDesc = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey2, (String)text, (boolean)false);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("MenuHelp")) {
                        i18nKey2 = XMLTools.getAttribute((Element)childElem, (String)"i18n", null, (boolean)false);
                        String text = XMLTools.getNodeText((Node)childElem, (String)" ", (boolean)false);
                        menuHelp = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey2, (String)text, (boolean)false);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("IconImage")) {
                        iconURI = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                        continue;
                    }
                    if (childName.equalsIgnoreCase("ButtonImage")) {
                        buttonURI = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                        continue;
                    }
                    if (childName.equalsIgnoreCase("ButtonImageAlt")) {
                        buttonALT = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                        continue;
                    }
                    if (childName.equalsIgnoreCase("AclName")) {
                        aclName = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                        continue;
                    }
                    if (childName.equalsIgnoreCase("Property")) {
                        String key = this._adjustPropertyKey(xmlFile, XMLTools.getAttribute((Element)childElem, (String)"key", null, (boolean)false));
                        if (!StringTools.isBlank((String)key)) {
                            String rtk;
                            String v;
                            boolean valTrim;
                            if (rtProps == null) {
                                rtProps = new RTProperties();
                            }
                            String val = XMLTools.getNodeText((Node)childElem, (String)((valTrim = XMLTools.getAttributeBoolean((Element)childElem, (String)"trim", (boolean)true, (boolean)false)) ? "\n" : null), (boolean)true);
                            if (!StringTools.isBlank((String)rtKeyPfx) && (v = RTConfig.getString((String)(rtk = rtKeyPfx + "." + key), null)) != null) {
                                val = v;
                            }
                            rtProps.setProperty((Object)key, (Object)val);
                            continue;
                        }
                        PrivateLabelLoader.printWarn((String)"Undefined property key ignored.", (Object[])new Object[0]);
                        this._setHasParsingWarnings(xmlFile);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("LogMessage")) {
                        this.parseTag_LogMessage(xmlFile, pl, childElem);
                        continue;
                    }
                    PrivateLabelLoader.printWarn((String)("Unrecognized tag name: " + childName), (Object[])new Object[0]);
                    this._setHasParsingWarnings(xmlFile);
                }
                if (!StringTools.isBlank((String)iconURI)) {
                    if (iconURI.startsWith("/")) {
                        iconURI = iconURI.substring(1);
                    } else if (!StringTools.isBlank((String)dftIconDir)) {
                        iconURI = iconURI.startsWith("/") && dftIconDir.endsWith("/") ? dftIconDir + iconURI.substring(1) : (iconURI.startsWith("/") || dftIconDir.endsWith("/") ? dftIconDir + iconURI : dftIconDir + "/" + iconURI);
                    }
                }
                if (!StringTools.isBlank((String)buttonURI)) {
                    if (buttonURI.startsWith("/")) {
                        buttonURI = buttonURI.substring(1);
                    } else if (!StringTools.isBlank((String)dftButtonDir)) {
                        buttonURI = buttonURI.startsWith("/") && dftButtonDir.endsWith("/") ? dftButtonDir + buttonURI.substring(1) : (buttonURI.startsWith("/") || dftButtonDir.endsWith("/") ? dftButtonDir + buttonURI : dftButtonDir + "/" + buttonURI);
                    }
                }
                if (!StringTools.isBlank((String)buttonALT)) {
                    if (buttonALT.startsWith("/")) {
                        buttonALT = buttonALT.substring(1);
                    } else if (!StringTools.isBlank((String)dftButtonDir)) {
                        buttonALT = buttonALT.startsWith("/") && dftButtonDir.endsWith("/") ? dftButtonDir + buttonALT.substring(1) : (buttonALT.startsWith("/") || dftButtonDir.endsWith("/") ? dftButtonDir + buttonALT : dftButtonDir + "/" + buttonALT);
                    }
                }
                if (!StringTools.isBlank((String)aclName) && !pl.hasAclEntry(aclName)) {
                    PrivateLabelLoader.printError((String)"Domain '%s' Page class='%s': Undefined ACL key '%s'", (Object[])new Object[]{pl.getName(), classname, aclName});
                    this._setHasParsingErrors(xmlFile);
                }
                try {
                    Class<?> pageClass = Class.forName(classname);
                    if (WebPage.class.isAssignableFrom(pageClass)) {
                        WebPage wp = (WebPage)pageClass.newInstance();
                        if (!StringTools.isBlank((String)pageName)) {
                            wp.setPageName(pageName);
                        }
                        if (menuGroup != null) {
                            menuGroup.addWebPage(wp);
                        }
                        if (wp instanceof WebPageAdaptor) {
                            WebPageAdaptor wpa = (WebPageAdaptor)wp;
                            wpa.setJspURI(!StringTools.isBlank((String)jspURI) ? jspURI : dftJSP);
                            wpa.setCssDirectory(!StringTools.isBlank((String)cssDir) ? cssDir : dftCssDir);
                            wpa.setPrivateLabel(pl);
                            wpa.setMenuGroup(menuGroup);
                            wpa.setAclName(aclName);
                            wpa.setNavigationDescription(navDesc);
                            wpa.setNavigationTab(navTab);
                            wpa.setMenuDescription(menuDesc);
                            wpa.setMenuHelp(menuHelp);
                            wpa.setMenuIconImage(iconURI);
                            wpa.setMenuButtonImage(buttonURI);
                            wpa.setMenuButtonAltImage(buttonALT);
                            wpa.setRuntimePropertyKeyPrefix(rtKeyPfx);
                            wpa.setProperties(rtProps);
                            Object[] subAclList = wpa.getChildAclList();
                            if (!ListTools.isEmpty((Object[])subAclList)) {
                                if (StringTools.isBlank((String)aclName)) {
                                    PrivateLabelLoader.printError((String)"Domain '%s' Page class='%s': ACL key not specified", (Object[])new Object[0]);
                                    this._setHasParsingErrors(xmlFile);
                                } else {
                                    for (Object subAcl : subAclList) {
                                        String subName = wpa.getAclName((String)subAcl);
                                        if (pl.hasAclEntry(subName)) continue;
                                        PrivateLabelLoader.printError((String)"Domain '%s' Page class='%s': Undefined ACL key '%s'", (Object[])new Object[]{pl.getName(), classname, subName});
                                        this._setHasParsingErrors(xmlFile);
                                    }
                                }
                            }
                            wpa.postInit();
                        } else {
                            Print.logWarn((String)("Page is not subclassed from 'WebPageAdaptor': " + StringTools.className(pageClass)), (Object[])new Object[0]);
                        }
                        if (!wp.getIsEnabled()) continue;
                        String pn = wp.getPageName();
                        pageMap.put(pn, wp);
                        if (StringTools.isBlank((String)pageAlias) || pageAlias.equals(pn)) continue;
                        pageMap.put(pageAlias, wp);
                        continue;
                    }
                    PrivateLabelLoader.printError((String)(classname + " does not implement interface WebPage"), (Object[])new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                }
                catch (ClassNotFoundException cnfe) {
                    if (optional) continue;
                    PrivateLabelLoader.printError((String)("Domain '" + pl.getName() + "', WebPage class not found: " + classname), (Object[])new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                }
                catch (InstantiationException ie) {
                    if (optional) {
                        PrivateLabelLoader.printWarn((String)("Domain '" + pl.getName() + "', Unable to instantiate WebPage: " + classname), (Object[])new Object[0]);
                        this._setHasParsingWarnings(xmlFile);
                        continue;
                    }
                    PrivateLabelLoader.printError((String)("Domain '" + pl.getName() + "', Unable to instantiate WebPage: " + classname), (Object[])new Object[0]);
                    Print.logException((String)("Domain '" + pl.getName() + "', Unable to instantiate WebPage: " + classname), (Throwable)ie);
                    this._setHasParsingErrors(xmlFile);
                }
                catch (NoClassDefFoundError ncde) {
                    String ncdm = ncde.getMessage();
                    if (ncdm.indexOf("javax.servlet") >= 0 || ncdm.indexOf("javax/servlet") >= 0) {
                        PrivateLabelLoader.printError((String)("Missing Servlet Classes: " + ncdm + " (check 'CATALALINA_HOME')"), (Object[])new Object[0]);
                    } else {
                        PrivateLabelLoader.printError((String)ncde.toString(), (Object[])new Object[0]);
                    }
                    if (optional) {
                        PrivateLabelLoader.printWarn((String)("Domain '" + pl.getName() + "', Unable to load optional WebPage: " + classname), (Object[])new Object[0]);
                        this._setHasParsingWarnings(xmlFile);
                        continue;
                    }
                    PrivateLabelLoader.printError((String)("Domain '" + pl.getName() + "', Unable to load WebPage: " + classname), (Object[])new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                }
                catch (Throwable t) {
                    if (optional) {
                        PrivateLabelLoader.printWarn((String)("Domain '" + pl.getName() + "', Unable to load optional WebPage: " + classname), (Object[])new Object[0]);
                        this._setHasParsingWarnings(xmlFile);
                        continue;
                    }
                    PrivateLabelLoader.printError((String)("Domain '" + pl.getName() + "', Unable to load WebPage: " + classname), (Object[])new Object[0]);
                    Print.logException((String)("Domain '" + pl.getName() + "', Unable to load WebPage: " + classname), (Throwable)t);
                    this._setHasParsingErrors(xmlFile);
                }
                continue;
            }
            if (wpElemName.equalsIgnoreCase("Link")) {
                Element link = wpElem;
                String urlLink = XMLTools.getAttribute((Element)link, (String)"url", null, (boolean)false);
                String target = XMLTools.getAttribute((Element)link, (String)"target", null, (boolean)false);
                String aclName = XMLTools.getAttribute((Element)link, (String)"aclName", null, (boolean)false);
                String iconURI = XMLTools.getAttribute((Element)link, (String)"icon", null, (boolean)false);
                String buttonURI = XMLTools.getAttribute((Element)link, (String)"button", null, (boolean)false);
                String buttonALT = XMLTools.getAttribute((Element)link, (String)"altButton", null, (boolean)false);
                I18N.Text navDesc = null;
                I18N.Text navTab = null;
                I18N.Text menuDesc = null;
                I18N.Text menuHelp = null;
                NodeList chList = link.getChildNodes();
                for (int c = 0; c < chList.getLength(); ++c) {
                    String text;
                    String i18nKey3;
                    Node chNode = chList.item(c);
                    if (!(chNode instanceof Element)) continue;
                    String childName = chNode.getNodeName();
                    Element childElem = (Element)chNode;
                    if (childName.equalsIgnoreCase("NavigationDescription")) {
                        i18nKey3 = XMLTools.getAttribute((Element)childElem, (String)"i18n", null, (boolean)false);
                        text = XMLTools.getNodeText((Node)childElem, (String)" ", (boolean)false);
                        navDesc = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey3, (String)text, (boolean)false);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("NavigationTab")) {
                        i18nKey3 = XMLTools.getAttribute((Element)childElem, (String)"i18n", null, (boolean)false);
                        text = XMLTools.getNodeText((Node)childElem, (String)" ", (boolean)false);
                        navTab = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey3, (String)text, (boolean)false);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("MenuDescription")) {
                        i18nKey3 = XMLTools.getAttribute((Element)childElem, (String)"i18n", null, (boolean)false);
                        text = XMLTools.getNodeText((Node)childElem, (String)" ", (boolean)false);
                        menuDesc = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey3, (String)text, (boolean)false);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("MenuHelp")) {
                        i18nKey3 = XMLTools.getAttribute((Element)childElem, (String)"i18n", null, (boolean)false);
                        text = XMLTools.getNodeText((Node)childElem, (String)" ", (boolean)false);
                        menuHelp = BasicPrivateLabelLoader.parseI18N((File)xmlFile, (String)i18nPkgName, (String)i18nKey3, (String)text, (boolean)false);
                        continue;
                    }
                    if (childName.equalsIgnoreCase("IconImage")) {
                        iconURI = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                        continue;
                    }
                    if (childName.equalsIgnoreCase("ButtonImage")) {
                        buttonURI = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                        continue;
                    }
                    if (childName.equalsIgnoreCase("ButtonImageAlt")) {
                        buttonALT = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                        continue;
                    }
                    if (childName.equalsIgnoreCase("AclName")) {
                        aclName = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                        continue;
                    }
                    if (childName.equalsIgnoreCase("LogMessage")) {
                        this.parseTag_LogMessage(xmlFile, pl, childElem);
                        continue;
                    }
                    PrivateLabelLoader.printWarn((String)("Unrecognized tag name: " + childName), (Object[])new Object[0]);
                    this._setHasParsingWarnings(xmlFile);
                }
                if (!StringTools.isBlank((String)iconURI)) {
                    if (iconURI.startsWith("/")) {
                        iconURI = iconURI.substring(1);
                    } else if (!StringTools.isBlank((String)dftIconDir)) {
                        iconURI = iconURI.startsWith("/") && dftIconDir.endsWith("/") ? dftIconDir + iconURI.substring(1) : (iconURI.startsWith("/") || dftIconDir.endsWith("/") ? dftIconDir + iconURI : dftIconDir + "/" + iconURI);
                    }
                }
                if (!StringTools.isBlank((String)buttonURI)) {
                    if (buttonURI.startsWith("/")) {
                        buttonURI = buttonURI.substring(1);
                    } else if (!StringTools.isBlank((String)dftButtonDir)) {
                        buttonURI = buttonURI.startsWith("/") && dftButtonDir.endsWith("/") ? dftButtonDir + buttonURI.substring(1) : (buttonURI.startsWith("/") || dftButtonDir.endsWith("/") ? dftButtonDir + buttonURI : dftButtonDir + "/" + buttonURI);
                    }
                }
                if (!StringTools.isBlank((String)buttonALT)) {
                    if (buttonALT.startsWith("/")) {
                        buttonALT = buttonALT.substring(1);
                    } else if (!StringTools.isBlank((String)dftButtonDir)) {
                        buttonALT = buttonALT.startsWith("/") && dftButtonDir.endsWith("/") ? dftButtonDir + buttonALT.substring(1) : (buttonALT.startsWith("/") || dftButtonDir.endsWith("/") ? dftButtonDir + buttonALT : dftButtonDir + "/" + buttonALT);
                    }
                }
                if (!StringTools.isBlank((String)aclName) && !pl.hasAclEntry(aclName)) {
                    PrivateLabelLoader.printError((String)"Domain '%s' Link url='%s': Undefined ACL key '%s'", (Object[])new Object[]{pl.getName(), urlLink, aclName});
                    this._setHasParsingErrors(xmlFile);
                }
                WebPageURL wpu = new WebPageURL();
                if (menuGroup != null) {
                    menuGroup.addWebPage(wpu);
                }
                wpu.setURL(urlLink);
                wpu.setTarget(target);
                wpu.setPrivateLabel(pl);
                wpu.setMenuGroup(menuGroup);
                wpu.setAclName(aclName);
                wpu.setNavigationDescription(navDesc);
                wpu.setNavigationTab(navTab);
                wpu.setMenuDescription(menuDesc);
                wpu.setMenuHelp(menuHelp);
                wpu.setMenuIconImage(iconURI);
                wpu.setMenuButtonImage(buttonURI);
                wpu.setMenuButtonAltImage(buttonALT);
                if (!wpu.getIsEnabled()) continue;
                pageMap.put(wpu.getPageName(), wpu);
                continue;
            }
            if (!wpElemName.equalsIgnoreCase("LogMessage")) continue;
            this.parseTag_LogMessage(xmlFile, pl, wpElem);
        }
    }

    protected void parseTag_Reports(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element reports) {
        PrivateLabel pl = (PrivateLabel)bpl;
        String keyPrefix = XMLTools.getAttribute((Element)reports, (String)"rtPropPrefix", null, (boolean)true);
        OrderedMap reportMap = new OrderedMap();
        NodeList reportList = XMLTools.getChildElements((Node)reports, (String)"Report");
        for (int r = 0; r < reportList.getLength(); ++r) {
            String rk;
            Element report = (Element)reportList.item(r);
            String reportName = XMLTools.getAttribute((Element)report, (String)"name", null, (boolean)false);
            String rtKey = StringTools.blankDefault((String)XMLTools.getAttribute((Element)report, (String)"rtKey", null, (boolean)false), (String)reportName);
            String aclName = XMLTools.getAttribute((Element)report, (String)"aclName", null, (boolean)false);
            boolean optional = XMLTools.getAttributeBoolean((Element)report, (String)"optional", (boolean)false, (boolean)false);
            boolean enabled = XMLTools.getAttributeBoolean((Element)report, (String)"enabled", (boolean)true, (boolean)false);
            String sysAdmin = XMLTools.getAttribute((Element)report, (String)"sysAdminOnly", null, (boolean)false);
            if (!enabled) {
                Print.logDebug((String)("Ignoring report (exlicitly disabled): " + reportName), (Object[])new Object[0]);
                continue;
            }
            if (!StringTools.isBlank((String)keyPrefix) && !RTConfig.getBoolean((String)(rk = keyPrefix + rtKey), (boolean)true)) {
                Print.logDebug((String)("Ignoring report per property [" + rk + "]: " + reportName), (Object[])new Object[0]);
                continue;
            }
            NodeList chList = report.getChildNodes();
            for (int c = 0; c < chList.getLength(); ++c) {
                Node chNode = chList.item(c);
                if (!(chNode instanceof Element)) continue;
                String childName = chNode.getNodeName();
                Element childElem = (Element)chNode;
                if (childName.equalsIgnoreCase("AclName")) {
                    aclName = StringTools.trim((String)XMLTools.getNodeText((Node)childElem, (String)"", (boolean)false));
                    continue;
                }
                if (childName.equalsIgnoreCase("LogMessage")) {
                    this.parseTag_LogMessage(xmlFile, pl, childElem);
                    continue;
                }
                PrivateLabelLoader.printWarn((String)("[" + xmlFile + "] Unrecognized tag name: " + childName), (Object[])new Object[0]);
                this._setHasParsingWarnings(xmlFile);
            }
            if (!StringTools.isBlank((String)aclName) && !pl.hasAclEntry(aclName)) {
                PrivateLabelLoader.printError((String)("[" + xmlFile + "] Domain '%s' Report name='%s': Undefined ACL key '%s'"), (Object[])new Object[]{pl.getName(), reportName, aclName});
                this._setHasParsingErrors(xmlFile);
            }
            try {
                ReportFactory rf = ReportFactory.getReportFactory(reportName, optional);
                if (rf == null) continue;
                if (StringTools.isBoolean((String)sysAdmin, (boolean)true)) {
                    rf.setSysAdminOnly(StringTools.parseBoolean((String)sysAdmin, (boolean)true));
                }
                rf.getReportClass();
                ReportEntry re = new ReportEntry(rf, aclName);
                reportMap.put(reportName, re);
                continue;
            }
            catch (ReportException re) {
                PrivateLabelLoader.printError((String)("[" + xmlFile + "] Unable to add report: " + reportName + " [" + re.getMessage() + "]"), (Object[])new Object[0]);
                this._setHasParsingErrors(xmlFile);
                continue;
            }
            catch (Throwable t) {
                PrivateLabelLoader.printError((String)("[" + xmlFile + "] Unable to add report: " + reportName), (Object[])new Object[0]);
                Print.logException((String)("[" + xmlFile + "] Unable to add report: " + reportName), (Throwable)t);
                this._setHasParsingErrors(xmlFile);
            }
        }
        pl.setReportMap((Map<String, ReportEntry>)reportMap);
    }

    protected void parseTag_PointsOfInterest(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element pois) {
        boolean enable = XMLTools.getAttributeBoolean((Element)pois, (String)"enabled", (boolean)true);
        if (!enable) {
            return;
        }
        PrivateLabel pl = (PrivateLabel)bpl;
        Vector<PoiProvider> poiList = new Vector<PoiProvider>();
        NodeList poiNodeList = XMLTools.getChildElements((Node)pois, (String)"POI");
        for (int p = 0; p < poiNodeList.getLength(); ++p) {
            Element poi = (Element)poiNodeList.item(p);
            String acctID = "sysadmin";
            final String poiID = XMLTools.getAttribute((Element)poi, (String)"name", null, (boolean)false);
            final String poiDesc = XMLTools.getAttribute((Element)poi, (String)"description", null, (boolean)false);
            final String icn = XMLTools.getAttribute((Element)poi, (String)"iconName", (String)"black", (boolean)false);
            final GeoPoint poiGP = new GeoPoint(XMLTools.getAttribute((Element)poi, (String)"location", (String)"0,0", (boolean)false), ',');
            final String address = poiDesc;
            if (!poiGP.isValid()) continue;
            PoiProvider pp = new PoiProvider(){

                public String getAccountID() {
                    return "sysadmin";
                }

                public String getPoiID() {
                    return poiID;
                }

                public String getPoiDescription() {
                    return poiDesc;
                }

                public int getPushpinIconIndex(OrderedSet<String> ick, BasicPrivateLabel bpl) {
                    return EventData._getPushpinIconIndex((String)icn, ick, (int)0);
                }

                public double getLatitude() {
                    return poiGP.getLatitude();
                }

                public double getLongitude() {
                    return poiGP.getLongitude();
                }

                public String getAddress() {
                    return address;
                }
            };
            poiList.add(pp);
        }
        pl.setPointsOfInterest(poiList);
    }

    protected void parseTag_MapShapes(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element mapShps) {
        boolean enable = XMLTools.getAttributeBoolean((Element)mapShps, (String)"enabled", (boolean)true);
        if (!enable) {
            return;
        }
        PrivateLabel pl = (PrivateLabel)bpl;
        Vector<MapShape> shapeList = new Vector<MapShape>();
        NodeList shapeNodeList = XMLTools.getChildElements((Node)mapShps, (String)"Shape");
        for (int s = 0; s < shapeNodeList.getLength(); ++s) {
            Element shape = (Element)shapeNodeList.item(s);
            String name = XMLTools.getAttribute((Element)shape, (String)"name", (String)"", (boolean)false).trim();
            String clear = XMLTools.getAttribute((Element)shape, (String)"clear", (String)"", (boolean)false).trim();
            String typeS = XMLTools.getAttribute((Element)shape, (String)"type", (String)"", (boolean)false).trim();
            String typeX = typeS.startsWith("!") ? typeS.substring(1) : typeS;
            MapShape.ShapeType type = MapShape.getShapeType(typeX, null);
            if (StringTools.isBlank((String)name)) {
                PrivateLabelLoader.printError((String)"Missing MapShape:Shape name", (Object[])new Object[0]);
                this._setHasParsingErrors(xmlFile);
                continue;
            }
            if (type == null) {
                PrivateLabelLoader.printError((String)("Missing/Invalid MapShape:Shape type: [" + name + "] " + typeS), (Object[])new Object[0]);
                this._setHasParsingErrors(xmlFile);
                continue;
            }
            double radM = XMLTools.getAttributeDouble((Element)shape, (String)"radius", (double)0.0);
            String color = XMLTools.getAttribute((Element)shape, (String)"color", (String)"", (boolean)false);
            boolean zoom = XMLTools.getAttributeBoolean((Element)shape, (String)"zoom", (boolean)false);
            String desc = "";
            NodeList descNodeList = XMLTools.getChildElements((Node)shape, (String)"Description");
            if (descNodeList.getLength() > 0) {
                Element descElem = (Element)descNodeList.item(0);
                desc = XMLTools.getNodeText((Node)descElem, (String)" ", (boolean)false);
            }
            Vector<GeoPoint> gpList = new Vector<GeoPoint>();
            NodeList dataNodeList = XMLTools.getChildElements((Node)shape, (String)"Points");
            for (int d = 0; d < dataNodeList.getLength(); ++d) {
                Element data = (Element)dataNodeList.item(d);
                String[] dataStr = StringTools.split((String)XMLTools.getNodeText((Node)data, (String)",", (boolean)false), (char)',');
                for (int g = 0; g < dataStr.length; ++g) {
                    if (dataStr[g].indexOf(47) <= 0) continue;
                    GeoPoint gp = new GeoPoint(dataStr[g]);
                    if (gp.isValid()) {
                        gpList.add(gp);
                        continue;
                    }
                    Print.logInfo((String)("GeoPoint Invalid: " + dataStr[g]), (Object[])new Object[0]);
                }
            }
            MapShape ms = new MapShape(name, type, radM, gpList);
            ms.setDescription(desc);
            ms.setColor(color);
            ms.setZoomTo(zoom);
            shapeList.add(ms);
        }
        pl.setMapShapes(shapeList);
    }

    protected void _addPrivateLabel(File xmlFile, BasicPrivateLabel privLabel, boolean ignoreDuplicates) {
        PrivateLabel pl = (PrivateLabel)privLabel;
        if (pl.hasUserPageDecorations()) {
            pl.getUserPageDecorations().setDefaultPageDecorations(pl.getDefaultPageDecorations());
        }
        super._addPrivateLabel(xmlFile, (BasicPrivateLabel)pl, ignoreDuplicates);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        RTConfig.setDebugMode((boolean)true);
        Print.setLogLevel((int)6);
        Print.setLogHeaderLevel((int)6);
        PrivateLabelLoader pll = new PrivateLabelLoader();
        File xmlFile = RTConfig.getFile((String)"xml", null);
        if (xmlFile != null) {
            if (PrivateLabelLoader.isTrackServlet()) {
                ReportFactory.loadReportDefinitionXML();
                pll._resetLoadXML(xmlFile);
                if (ReportFactory.hasParsingErrors()) {
                    pll._setHasParsingErrors(xmlFile);
                }
            } else {
                pll._resetLoadXML(xmlFile);
            }
        } else {
            pll._resetLoadDefaultXML();
        }
    }
}

