/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.PoiProvider;
import org.opengts.db.tables.EventData;
import org.opengts.util.EnumTools;
import org.opengts.util.FileTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportFactory;
import org.opengts.war.tools.ComboMap;
import org.opengts.war.tools.ComboOption;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.MapShape;
import org.opengts.war.tools.MenuGroup;
import org.opengts.war.tools.PageDecorations;
import org.opengts.war.tools.PageDecorationsDefault;
import org.opengts.war.tools.PushpinIcon;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPage;

public class PrivateLabel
extends BasicPrivateLabel {
    public static final String DEFAULT_CSS_DIR = "css";
    public static final String JSPENTRY_DEFAULT = "default";
    private static OrderedMap<String, PushpinIcon> GlobalPushpins = null;
    private PageDecorations dftPageDecorations = null;
    private PageDecorations userPageDecorations = null;
    private OrderedMap<String, MapProvider> mapProvider = null;
    private String webPageJSP = null;
    private Map<String, WebPage> pageMap = null;
    private String cssDirectory = "css";
    private Map<String, String> cssFileMap = new HashMap<String, String>();
    private Map<String, MenuGroup> menuGroupMap = null;
    private Map<String, ReportEntry> reportMap = null;
    private Map<String, JSPEntry> jspMap = null;
    private ComboMap timeZonesMap = null;
    public static final String CONTEXT_FILE_OFFLINE = ".offline";
    private List<PoiProvider> pointsOfInterest = null;
    private Map<String, MapShape> mapShapes = null;

    public static OrderedMap<String, PushpinIcon> GetGlobalPushpinIcons() {
        if (GlobalPushpins == null) {
            GlobalPushpins = new OrderedMap(PushpinIcon.newDefaultPushpinIconMap());
        }
        return GlobalPushpins;
    }

    private PrivateLabel() {
    }

    protected PrivateLabel(String host) {
        super(host);
    }

    public boolean hasUserPageDecorations() {
        return this.userPageDecorations != null;
    }

    public void setUserPageDecorations(PageDecorations pd) {
        this.userPageDecorations = pd;
    }

    public PageDecorations getUserPageDecorations() {
        if (this.userPageDecorations != null) {
            return this.userPageDecorations;
        }
        return this.getDefaultPageDecorations();
    }

    public void setDefaultPageDecorations(PageDecorations pd) {
        this.dftPageDecorations = pd;
    }

    public PageDecorations getDefaultPageDecorations() {
        if (this.dftPageDecorations == null) {
            this.dftPageDecorations = new PageDecorationsDefault(this);
        }
        return this.dftPageDecorations;
    }

    public void addMapProvider(MapProvider mapProv) {
        if (mapProv != null) {
            if (this.mapProvider == null) {
                this.mapProvider = new OrderedMap();
            }
            String name = mapProv.getName().toLowerCase();
            this.mapProvider.put((Object)name, (Object)mapProv);
        }
    }

    public MapProvider getMapProvider() {
        return this.mapProvider != null ? (MapProvider)this.mapProvider.getValue(0) : null;
    }

    public MapProvider getMapProvider(String name) {
        if (name != null && this.mapProvider != null) {
            return (MapProvider)this.mapProvider.get((Object)name.toLowerCase());
        }
        return null;
    }

    public int getMapProviderCount() {
        return this.mapProvider != null ? this.mapProvider.size() : 0;
    }

    public int getPushpinIconIndex(String mapProviderID, String pushpinID, int dftIndex) {
        MapProvider mp;
        MapProvider mapProvider = mp = StringTools.isBlank((String)mapProviderID) ? this.getMapProvider() : this.getMapProvider(mapProviderID);
        if (mp != null) {
            OrderedMap<String, PushpinIcon> iconMap = mp.getPushpinIconMap(null);
            OrderedSet iconKeys = (OrderedSet)iconMap.keySet();
            return EventData._getPushpinIconIndex((String)pushpinID, (OrderedSet)iconKeys, (int)dftIndex);
        }
        return EventData._getPushpinIconIndex((String)pushpinID, null, (int)dftIndex);
    }

    public void setWebPageJSP(String dftJSP) {
        this.webPageJSP = dftJSP;
    }

    public String getWebPageJSP() {
        return this.webPageJSP;
    }

    protected String _getWebPageJSP(RequestProperties reqState) {
        String jsp = StringTools.blankDefault((String)this.getWebPageJSP(), (String)JSPENTRY_DEFAULT);
        if (StringTools.isBlank((String)jsp)) {
            return null;
        }
        if (jsp.startsWith("/")) {
            return jsp;
        }
        if (!ListTools.isEmpty(this.jspMap)) {
            String jn = StringTools.replaceKeys((String)jsp, (StringTools.KeyValueMap)reqState, null);
            String jf = this.getJSPFile(jn, true);
            if (!StringTools.isBlank((String)jf)) {
                return jf;
            }
            Print.logWarn((String)("Named JSP name not found: " + jn + " [" + jsp + "]"), (Object[])new Object[0]);
            return null;
        }
        return jsp;
    }

    public String getWebPageJSP(String jsp, RequestProperties reqState) {
        if (StringTools.isBlank((String)jsp)) {
            return this._getWebPageJSP(reqState);
        }
        if (jsp.startsWith("/")) {
            return jsp;
        }
        String jn = StringTools.replaceKeys((String)jsp, (StringTools.KeyValueMap)reqState, null);
        String jf = this.getJSPFile(jn, false);
        if (!StringTools.isBlank((String)jf)) {
            return jf;
        }
        Print.logWarn((String)("Named JSP name not found: " + jn + " [" + jsp + "]"), (Object[])new Object[0]);
        return this._getWebPageJSP(reqState);
    }

    public void setCssDirectory(String cssDir) {
        this.cssDirectory = cssDir;
    }

    public String getCssDirectory() {
        if (StringTools.isBlank((String)this.cssDirectory)) {
            return DEFAULT_CSS_DIR;
        }
        return this.cssDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveCssFile(String cssFileName, String cssFileDir) {
        if (URIArg.isAbsoluteURL((String)cssFileName)) {
            return cssFileName;
        }
        String cssRelPath = this.cssFileMap.get(cssFileName);
        if (cssRelPath == null) {
            Map<String, String> map = this.cssFileMap;
            synchronized (map) {
                cssRelPath = this.cssFileMap.get(cssFileName);
                if (cssRelPath == null) {
                    File cssAbsPath;
                    String cssDir;
                    cssRelPath = "";
                    String string = cssDir = !StringTools.isBlank((String)cssFileDir) ? cssFileDir : this.getCssDirectory();
                    if (!StringTools.isBlank((String)cssDir)) {
                        cssRelPath = cssDir.startsWith("/") ? cssRelPath + cssDir.substring(1) + "/" : cssRelPath + cssDir + "/";
                    }
                    cssRelPath = cssRelPath + cssFileName;
                    File rootDir = RTConfig.getServletContextPath();
                    if (rootDir != null && !(cssAbsPath = new File(rootDir, cssRelPath)).isFile() && !cssDir.equals(DEFAULT_CSS_DIR)) {
                        cssRelPath = "css/" + cssFileName;
                    }
                    this.cssFileMap.put(cssFileName, cssRelPath);
                }
            }
        }
        return cssRelPath;
    }

    private static String _readOfflineMessage(File offlineFile, String n) {
        if (offlineFile != null && offlineFile.exists()) {
            if (offlineFile.isFile()) {
                byte[] msg = FileTools.readFile((File)offlineFile);
                return StringTools.trim((String)StringTools.toStringValue((byte[])msg));
            }
            Print.logError((String)(n + " Offline indicator exists, but is not a file: " + offlineFile), (Object[])new Object[0]);
            return "";
        }
        return null;
    }

    public static String GetContextOfflineMessage() {
        File rd = RTConfig.getServletContextPath();
        return rd != null ? PrivateLabel._readOfflineMessage(new File(rd, CONTEXT_FILE_OFFLINE), "Context") : null;
    }

    public static String GetGlobalOfflineMessage() {
        return PrivateLabel._readOfflineMessage(RTConfig.getFile((String)"track.offlineFile", null), "Global");
    }

    public static String GetOfflineMessage() {
        String msg = PrivateLabel.GetContextOfflineMessage();
        if (msg == null) {
            msg = PrivateLabel.GetGlobalOfflineMessage();
        }
        return msg;
    }

    public static void SetContextOfflineMessage(String msg) {
        block9: {
            File rootDir = RTConfig.getServletContextPath();
            if (rootDir != null) {
                File filePath = new File(rootDir, CONTEXT_FILE_OFFLINE);
                if (msg == null) {
                    if (filePath.isFile()) {
                        try {
                            boolean didDelete = filePath.delete();
                            if (didDelete) {
                                Print.logInfo((String)("Context 'offline' file deleted: " + filePath), (Object[])new Object[0]);
                                break block9;
                            }
                            Print.logError((String)("Unable to delete context 'offline' file: " + filePath), (Object[])new Object[0]);
                        }
                        catch (Throwable th) {
                            Print.logException((String)("Unable to delete 'offline' message file " + filePath), (Throwable)th);
                        }
                    }
                } else {
                    try {
                        FileTools.writeFile((byte[])msg.getBytes(), (File)filePath, (boolean)false);
                    }
                    catch (IOException ioe) {
                        Print.logException((String)("Unable to create/write 'offline' message file " + filePath), (Throwable)ioe);
                    }
                }
            }
        }
    }

    public void setWebPageMap(Map<String, WebPage> pageMap) {
        this.pageMap = pageMap;
    }

    public Map<String, WebPage> getWebPageMap() {
        return this.pageMap;
    }

    public WebPage getWebPage(String pageName) {
        Map<String, WebPage> map = this.getWebPageMap();
        return map != null ? map.get(pageName) : null;
    }

    public boolean hasWebPage(String pageName) {
        return this.getWebPage(pageName) != null;
    }

    public String getWebPageURL(RequestProperties reqState, String pageName) {
        WebPage wp = this.getWebPage(pageName);
        return wp != null ? wp.encodePageURL(reqState) : "";
    }

    public String getWebPageURL(RequestProperties reqState, String pageName, String command) {
        WebPage wp = this.getWebPage(pageName);
        return wp != null ? wp.encodePageURL(reqState, command) : null;
    }

    public String getWebPageURL(RequestProperties reqState, String pageName, String command, String arg) {
        WebPage wp = this.getWebPage(pageName);
        return wp != null ? wp.encodePageURL(reqState, command, arg) : null;
    }

    public void setMenuGroupMap(Map<String, MenuGroup> menuGroupMap) {
        this.menuGroupMap = menuGroupMap;
    }

    public Map<String, MenuGroup> getMenuGroupMap() {
        return this.menuGroupMap;
    }

    public void setReportMap(Map<String, ReportEntry> reportMap) {
        this.reportMap = reportMap;
    }

    public Map<String, ReportEntry> getReportMap() {
        return this.reportMap;
    }

    public ReportEntry getReportEntry(String rptName) {
        if (StringTools.isBlank((String)rptName)) {
            return null;
        }
        Map<String, ReportEntry> map = this.getReportMap();
        if (map == null) {
            return null;
        }
        String rn = rptName.trim();
        return map.containsKey(rn) ? map.get(rn) : map.get(rn.toLowerCase());
    }

    public ReportFactory getReportFactory(String rptName) {
        ReportEntry re = this.getReportEntry(rptName);
        return re != null ? re.getReportFactory() : null;
    }

    public boolean hasReport(String rptName) {
        return this.getReportEntry(rptName) != null;
    }

    public void setJSPMap(Map<String, JSPEntry> jspMap) {
        this.jspMap = jspMap;
    }

    private Map<String, JSPEntry> _getJSPMap() {
        return this.jspMap;
    }

    public Set<String> getJSPEntryNames() {
        Map<String, JSPEntry> jspMap = this._getJSPMap();
        return jspMap != null ? jspMap.keySet() : new HashSet<String>();
    }

    public OrderedMap<String, String> getJSPEntryDescriptions(Locale locale) {
        OrderedMap descMap = new OrderedMap();
        Map<String, JSPEntry> jspMap = this._getJSPMap();
        if (jspMap != null) {
            String dftName = JSPENTRY_DEFAULT;
            if (jspMap.containsKey(dftName)) {
                String d = jspMap.get(dftName).getDescription(locale);
                descMap.put((Object)dftName, (Object)d);
            }
            for (String n : jspMap.keySet()) {
                if (descMap.containsKey((Object)n)) continue;
                String d = jspMap.get(n).getDescription(locale);
                descMap.put((Object)n, (Object)d);
            }
        }
        return descMap;
    }

    public JSPEntry getJSPEntry(String jspName) {
        Map<String, JSPEntry> map = this._getJSPMap();
        if (map != null && !StringTools.isBlank((String)jspName)) {
            String jspPropKey = "JSPEntry." + jspName;
            String jspn = this.getStringProperty(jspPropKey, jspName);
            JSPEntry je = map.get(jspn);
            if (je == null && !jspn.equals(jspName)) {
                je = map.get(jspName);
            }
            if (je != null) {
                return je;
            }
        }
        return null;
    }

    public String getJSPFile(String jspName, boolean rtnDefault) {
        JSPEntry jsp = this.getJSPEntry(jspName);
        if (jsp == null && rtnDefault) {
            jsp = this.getJSPEntry(JSPENTRY_DEFAULT);
        }
        return jsp != null ? jsp.getFile() : null;
    }

    public void setPointsOfInterest(List<PoiProvider> poiList) {
        this.pointsOfInterest = poiList;
    }

    public List<PoiProvider> getPointsOfInterest() {
        return this.pointsOfInterest;
    }

    public void setMapShapes(List<MapShape> shapeList) {
        this.mapShapes = new OrderedMap();
        if (!ListTools.isEmpty(shapeList)) {
            for (MapShape ms : shapeList) {
                this.mapShapes.put(ms.getName(), ms);
            }
        }
    }

    public Map<String, MapShape> getMapShapes() {
        return this.mapShapes;
    }

    public void clearTimeZones() {
        super.clearTimeZones();
        this.timeZonesMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComboMap getTimeZoneComboMap() {
        if (this.timeZonesMap == null) {
            List tzList;
            List list = tzList = this.getTimeZonesList();
            synchronized (list) {
                if (this.timeZonesMap == null) {
                    this.timeZonesMap = new ComboMap();
                    for (String tz : tzList) {
                        this.timeZonesMap.add(tz, tz);
                    }
                }
            }
        }
        return this.timeZonesMap;
    }

    public <T extends Enum<T>> ComboMap getEnumComboMap(Class<T> enumClass) {
        return new ComboMap(EnumTools.getValueMap(enumClass, (Locale)this.getLocale()));
    }

    public <T extends Enum<T>> ComboMap getEnumComboMap(Class<T> enumClass, T[] list) {
        return new ComboMap(EnumTools.getValueMap(enumClass, list, (Locale)this.getLocale()));
    }

    public ComboOption getEnumComboOption(EnumTools.StringLocale enumType) {
        return new ComboOption(enumType, this.getLocale());
    }

    public static class JSPEntry {
        private String name = null;
        private I18N.Text desc = null;
        private String file = null;
        private String cssDir = null;

        public JSPEntry(String name, I18N.Text desc, String file) {
            this.name = name;
            this.desc = desc;
            this.file = file;
            this.cssDir = null;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription(Locale locale) {
            if (this.desc != null) {
                return this.desc.toString(locale);
            }
            return this.name;
        }

        public String getFile() {
            return this.file;
        }

        public String getCSSDir() {
            return this.cssDir;
        }
    }
}

