/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.IOException;
import java.io.PrintWriter;
import org.opengts.util.StringTools;
import org.opengts.war.tools.PageDecorations;
import org.opengts.war.tools.RequestProperties;

public class PageDecorationsAdaptor
implements PageDecorations {
    private PageDecorations dftPageDecorations = null;
    private String jspURI = null;
    private String pageStyle = null;
    private String pageHeader = null;
    private String pageNavigate = null;
    private String pageFooter = null;
    private String pageLeft = null;
    private String pageRight = null;

    public PageDecorationsAdaptor() {
    }

    public PageDecorationsAdaptor(PageDecorations dftPageDecor) {
        this();
        this.setDefaultPageDecorations(dftPageDecor);
    }

    @Override
    public void setDefaultPageDecorations(PageDecorations dftPageDecor) {
        this.dftPageDecorations = dftPageDecor;
    }

    public PageDecorations getDefaultPageDecorations() {
        return this.dftPageDecorations;
    }

    @Override
    public boolean hasJspURI() {
        return !StringTools.isBlank((String)this.jspURI);
    }

    @Override
    public void setJspURI(String jspURI) {
        this.jspURI = !StringTools.isBlank((String)jspURI) ? jspURI : null;
    }

    @Override
    public String getJspURI() {
        return this.jspURI;
    }

    protected String trimStringRecords(String s) {
        if (s != null) {
            String[] sa = StringTools.parseStringArray((String)s, (String)"\r\n");
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = sa[i].trim();
            }
            s = StringTools.join((String[])sa, (char)'\n').trim();
        }
        return s;
    }

    @Override
    public void setPageStyle(String style) {
        this.pageStyle = this.trimStringRecords(style);
    }

    public String getPageStyle() {
        return this.pageStyle;
    }

    @Override
    public void writeStyle(PrintWriter out, RequestProperties reqState) throws IOException {
        String s = this.getPageStyle();
        if (s != null) {
            out.write(s);
            if (!s.endsWith("\n")) {
                out.write("\n");
            }
        } else {
            this.getDefaultPageDecorations().writeStyle(out, reqState);
        }
    }

    @Override
    public void setPageHeader(String header) {
        this.pageHeader = this.trimStringRecords(header);
    }

    public String getPageHeader() {
        return this.pageHeader;
    }

    @Override
    public void writeHeader(PrintWriter out, RequestProperties reqState) throws IOException {
        String s = this.getPageHeader();
        if (s != null) {
            out.write(StringTools.replaceKeys((String)s, (StringTools.KeyValueMap)reqState));
        } else {
            this.getDefaultPageDecorations().writeHeader(out, reqState);
        }
    }

    @Override
    public void setPageNavigation(String navigate) {
        this.pageNavigate = this.trimStringRecords(navigate);
    }

    public String getPageNavigation() {
        return this.pageNavigate;
    }

    @Override
    public void writeNavigation(PrintWriter out, RequestProperties reqState) throws IOException {
        String s = this.getPageNavigation();
        if (s != null) {
            out.write(StringTools.replaceKeys((String)s, (StringTools.KeyValueMap)reqState));
        } else {
            this.getDefaultPageDecorations().writeNavigation(out, reqState);
        }
    }

    @Override
    public void setPageFooter(String footer) {
        this.pageFooter = this.trimStringRecords(footer);
    }

    public String getPageFooter() {
        return this.pageFooter;
    }

    @Override
    public void writeFooter(PrintWriter out, RequestProperties reqState) throws IOException {
        String s = this.getPageFooter();
        if (s != null) {
            out.write(StringTools.replaceKeys((String)s, (StringTools.KeyValueMap)reqState));
        } else {
            this.getDefaultPageDecorations().writeFooter(out, reqState);
        }
    }

    @Override
    public void setPageLeft(String left) {
        this.pageLeft = this.trimStringRecords(left);
    }

    public String getPageLeft() {
        return this.pageLeft;
    }

    @Override
    public void writeLeft(PrintWriter out, RequestProperties reqState) throws IOException {
        String s = this.getPageLeft();
        if (s != null) {
            out.write(StringTools.replaceKeys((String)s, (StringTools.KeyValueMap)reqState));
        } else {
            this.getDefaultPageDecorations().writeLeft(out, reqState);
        }
    }

    @Override
    public void setPageRight(String right) {
        this.pageRight = this.trimStringRecords(right);
    }

    public String getPageRight() {
        return this.pageRight;
    }

    @Override
    public void writeRight(PrintWriter out, RequestProperties reqState) throws IOException {
        String s = this.getPageRight();
        if (s != null) {
            out.write(StringTools.replaceKeys((String)s, (StringTools.KeyValueMap)reqState));
        } else {
            this.getDefaultPageDecorations().writeRight(out, reqState);
        }
    }
}

