/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.opengts.util.MethodAction;

public class OutputProvider {
    private Object provider = null;
    private OutputStream stream = null;
    private PrintWriter writer = null;

    public OutputProvider() {
    }

    public OutputProvider(Object provider) {
        this.provider = provider;
    }

    public OutputProvider(OutputStream stream) {
        this.stream = stream;
    }

    public OutputProvider(PrintWriter writer) {
        this.writer = writer;
    }

    public boolean hasOutputStream() {
        return this.stream != null;
    }

    public OutputStream getOutputStream() throws IOException, IllegalStateException {
        if (this.stream != null) {
            return this.stream;
        }
        if (this.writer != null) {
            throw new IllegalStateException("'stream' already defined");
        }
        if (this.provider != null) {
            try {
                MethodAction ma = new MethodAction(this.provider, "getOutputStream");
                this.stream = (OutputStream)ma.invoke();
                return this.stream;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasWriter() {
        return this.writer != null;
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            this.writer = new PrintWriter(this.stream);
            return this.writer;
        }
        if (this.provider != null) {
            try {
                MethodAction ma = new MethodAction(this.provider, "getWriter");
                this.writer = (PrintWriter)ma.invoke();
                return this.writer;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

