/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.User;
import org.opengts.util.I18N;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPage;

public class MenuGroup {
    private String name = null;
    private I18N.Text title = null;
    private I18N.Text description = null;
    private List<WebPage> pageList = null;
    private boolean showMenuBar = true;
    private boolean showTopMenu = true;

    public MenuGroup(String name, I18N.Text title, I18N.Text desc) {
        this.setName(name);
        this.setTitle(title);
        this.setDescription(desc);
        this.pageList = new Vector<WebPage>();
    }

    public MenuGroup(String name, I18N.Text title) {
        this(name, title, null);
    }

    public MenuGroup(String name) {
        this(name, null, null);
    }

    public void setShowInMenuBar(boolean show) {
        this.showMenuBar = show;
    }

    public boolean showInMenuBar() {
        return this.showMenuBar;
    }

    public void setShowInTopMenu(boolean show) {
        this.showTopMenu = show;
    }

    public boolean showInTopMenu() {
        return this.showTopMenu;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTitle(I18N.Text title) {
        this.title = title;
    }

    public String getTitle(Locale loc) {
        return this.title != null ? this.title.toString(loc) : "";
    }

    public void setDescription(I18N.Text desc) {
        this.description = desc;
    }

    public String getDescription(Locale loc) {
        String desc;
        String string = desc = this.description != null ? this.description.toString(loc) : null;
        if (desc != null && !desc.equals("")) {
            return desc;
        }
        return this.getTitle(loc);
    }

    public void addWebPage(WebPage wp) {
        if (wp != null) {
            this.pageList.add(wp);
        }
    }

    public List<WebPage> getWebPageList(RequestProperties reqState) {
        if (reqState == null) {
            return this.pageList;
        }
        PrivateLabel privLabel = reqState.getPrivateLabel();
        Account account = reqState.getCurrentAccount();
        User user = reqState.getCurrentUser();
        Vector<WebPage> authPageList = new Vector<WebPage>();
        for (WebPage wp : this.pageList) {
            if (wp.systemAdminOnly() && !Account.isSystemAdmin((Account)account) || !wp.isOkToDisplay(reqState) || !privLabel.hasReadAccess(user, wp.getAclName())) continue;
            authPageList.add(wp);
        }
        return authPageList;
    }
}

