/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.opengts.util.ListTools;
import org.opengts.util.PixelDimension;
import org.opengts.util.StringTools;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.MenuGroup;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPage;
import org.opengts.war.track.Constants;

public class MenuBar
implements Constants {
    public static final boolean DFT_USE_PULL_DOWN_MENUS = true;
    public static final int MENU_TIMEOUT_MS = 3700;
    public static final String CSS_MENU_TAB_UNSEL_WIDE = "menuBarUnsW";
    public static final String CSS_MENU_TAB_SEL_WIDE = "menuBarSelW";
    public static final String CSS_MENU_TAB_UNSEL = "menuBarUns";
    public static final String CSS_MENU_TAB_SEL = "menuBarSel";
    public static final String CSS_MENU_BAR = "menuBar";
    public static final String CSS_MENU_TABLE = "menuSubFrame";
    public static final String CSS_MENU_TABLE_ROW = "menuSubItemRow";
    public static final String CSS_MENU_CELL = "menuSubItemCol";
    public static final String CSS_MENU_LINK = "menuSubItemLink";
    public static final String MENU_MAIN = "menu.main";
    public static final String MENU_ADMIN = "menu.admin";
    public static final String MENU_TRACK_DEVICE = "menu.track.device";
    public static final String MENU_TRACK_FLEET = "menu.track.fleet";
    public static final String MENU_REPORTS = "menu.rpts";
    public static final String MENU_REPORTS_DEVDETAIL = "menu.rpts.devDetail";
    public static final String MENU_REPORTS_GRPDETAIL = "menu.rpts.grpDetail";
    public static final String MENU_REPORTS_GRPSUMMARY = "menu.rpts.grpSummary";
    public static final String MENU_REPORTS_PERFORM = "menu.rpts.performance";
    public static final String MENU_REPORTS_IFTA = "menu.rpts.ifta";
    public static final String MENU_REPORTS_SYSADMIN = "menu.rpts.sysadmin";

    public static void writeJavaScript(JspWriter out, String pageName, RequestProperties reqState) throws IOException {
        MenuBar.writeJavaScript(new PrintWriter((Writer)out, out.isAutoFlush()), pageName, reqState);
    }

    public static void writeJavaScript(PrintWriter out, String pageName, RequestProperties reqState) throws IOException {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        HttpServletRequest request = reqState.getHttpServletRequest();
        if (!privLabel.getBooleanProperty("menuBar.usePullDownMenus", true)) {
            return;
        }
        JavaScriptTools.writeJSInclude(out, JavaScriptTools.qualifyJSFileRef("MenuBar.js"), request);
        boolean inclAnchor = privLabel.getBooleanProperty("menuBar.includeTextAnchor", false);
        int itemHeight = 13;
        JavaScriptTools.writeStartJavaScript(out);
        out.println("function mnubarCreateSubMenu(mainObj) {");
        out.println("  var itemHeight = " + itemHeight + ";");
        out.println("  var id = mainObj.id;");
        out.println("  var absLoc = getElementPosition(mainObj);");
        out.println("  var absSiz = getElementSize(mainObj);");
        out.println("  for (;;) {");
        Map<String, MenuGroup> menuMap = privLabel.getMenuGroupMap();
        for (String mgn : menuMap.keySet()) {
            List<WebPage> pageList;
            MenuGroup mg = menuMap.get(mgn);
            if (!mg.showInMenuBar() || ListTools.isEmpty(pageList = mg.getWebPageList(reqState))) continue;
            out.println("    if (id == '" + mgn + "') {");
            out.println("      mbSubMenuObj = mnubarCreateMenuFrame(absLoc,absSiz,((" + pageList.size() + "*itemHeight)+6));");
            out.println("      mbSubMenuObj.innerHTML = ");
            out.println("        \"<table class='menuSubFrame' cellspacing='0' cellpadding='0'>\" +");
            for (WebPage wp : pageList) {
                PixelDimension pixDim;
                String url = wp.encodePageURL(reqState);
                String desc = wp.getNavigationTab(reqState);
                String help = wp.getMenuHelp(reqState, null);
                out.write("        ");
                out.write("\"<tr class='menuSubItemRow'>");
                String target = StringTools.blankDefault((String)wp.getTarget(), (String)"_self");
                String onclick = "openURL('" + url + "','" + target + "')";
                if (!target.startsWith("_") && (pixDim = wp.getWindowDimension()) != null) {
                    int W = pixDim.getWidth();
                    int H = pixDim.getHeight();
                    onclick = "openFixedWindow('" + url + "','" + target + "'," + W + "," + H + ")";
                }
                out.write("<td class='menuSubItemCol' height='\"+itemHeight+\"' onclick=\\\"javascript:" + onclick + ";\\\" title=\\\"" + help + "\\\">");
                if (inclAnchor) {
                    out.write("<a class='menuSubItemLink'");
                    if (target.startsWith("_")) {
                        out.write(" href='" + url + "' target='" + target + "'");
                    } else {
                        pixDim = wp.getWindowDimension();
                        if (pixDim == null) {
                            out.write(" href='" + url + "' target='" + target + "'");
                        }
                    }
                    out.write(">");
                    out.write(desc);
                    out.write("</a>");
                } else {
                    out.write(desc);
                }
                out.write("</td>");
                out.write("</tr>\" +\n");
            }
            out.println("        \"</table>\";");
            out.println("      break;");
            out.println("    }");
        }
        out.println("    break; // error");
        out.println("  }");
        out.println("  if (mbSubMenuObj) { document.body.appendChild(mbSubMenuObj); }");
        out.println("  return mbSubMenuObj;");
        out.println("}");
        JavaScriptTools.writeEndJavaScript(out);
    }

    public static void writeTableRow(JspWriter out, String pageName, RequestProperties reqState) throws IOException {
        MenuBar.writeTableRow(new PrintWriter((Writer)out, out.isAutoFlush()), pageName, reqState);
    }

    public static void writeTableRow(PrintWriter out, String pageName, RequestProperties reqState) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        out.write("\n");
        out.write("<!-- Begin Menu Bar -->\n");
        out.write("<td nowrap class='menuBar'>\n");
        out.write("<table border='0' cellpadding='0' cellspacing='0'>");
        out.write("<tr style='margin-bottom:0px; padding-bottom:0px'>\n");
        if (privLabel.getBooleanProperty("menuBar.usePullDownMenus", true)) {
            Map<String, MenuGroup> menuMap = privLabel.getMenuGroupMap();
            boolean openOnMouseOver = privLabel.getBooleanProperty("menuBar.openOnMouseOver", false);
            for (String mgn : menuMap.keySet()) {
                MenuGroup mg = menuMap.get(mgn);
                if (!mg.showInMenuBar() || ListTools.isEmpty(mg.getWebPageList(reqState))) continue;
                String desc = mg.getTitle(reqState.getLocale());
                out.write(" <td id='" + mgn + "' class='" + CSS_MENU_TAB_UNSEL_WIDE + "'");
                out.write(" onmouseover=\"mnubarMouseOverTab('" + mgn + "'," + openOnMouseOver + ")\"");
                out.write(" onmouseout=\"mnubarMouseOutTab('" + mgn + "')\"");
                out.write(" onclick=\"mnubarToggleMenu('" + mgn + "')\">");
                out.write(desc);
                out.write("</td>\n");
            }
        } else {
            Map<String, WebPage> pageMap = privLabel.getWebPageMap();
            WebPage mainMenu = pageMap.get("menu.top");
            if (mainMenu != null) {
                String desc = mainMenu.getNavigationTab(reqState);
                if (pageName == null || !pageName.equals("menu.top")) {
                    String url = mainMenu.encodePageURL(reqState);
                    out.write(" <td class='menuBarUns' onclick=\"javascript:window.open('" + url + "','_top')\">" + desc + "</td>\n");
                } else {
                    out.write(" <td class='menuBarSel'>" + desc + "</td>\n");
                }
            }
            Map<String, MenuGroup> menuMap = privLabel.getMenuGroupMap();
            for (String mgn : menuMap.keySet()) {
                MenuGroup mg = menuMap.get(mgn);
                if (!mg.showInMenuBar()) continue;
                List<WebPage> menuItems = mg.getWebPageList(reqState);
                for (WebPage wp : menuItems) {
                    String wpname = wp.getPageName();
                    if (wpname.equals("login") || wpname.equals("menu.top") || wpname.equals("alert.panel")) continue;
                    String desc = wp.getNavigationTab(reqState);
                    if (pageName == null || !pageName.equals(wpname)) {
                        String url = wp.encodePageURL(reqState);
                        out.write(" <td class='menuBarUns' onclick=\"javascript:window.open('" + url + "','_top')\">" + desc + "</td>\n");
                        continue;
                    }
                    out.write(" <td class='menuBarSel'>" + desc + "</td>\n");
                }
            }
        }
        out.write("</tr>\n");
        out.write("</table>\n");
        out.write("</td>\n");
        out.write("<!-- End Menu Bar -->\n");
    }
}

