/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.opengts.util.ColorTools;
import org.opengts.util.EnumTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.StringTools;

public class MapShape {
    public static final ShapeType DEFAULT_SHAPE_TYPE = ShapeType.CIRCLE;
    public static final ColorTools.RGB DEFAULT_COLOR = ColorTools.BLUE;
    private String name = "";
    private String desc = "";
    private ShapeType shapeType = DEFAULT_SHAPE_TYPE;
    private double radiusMeters = 0.0;
    private List<GeoPoint> geoPoints = null;
    private ColorTools.RGB color = DEFAULT_COLOR;
    private boolean zoomTo = false;

    public static ShapeType getShapeType(String type, ShapeType dft) {
        return (ShapeType)EnumTools.getValueOf(ShapeType.class, (String)type, (Enum)dft);
    }

    public static ShapeType getShapeType(String type) {
        return (ShapeType)EnumTools.getValueOf(ShapeType.class, (String)type, (Enum)DEFAULT_SHAPE_TYPE);
    }

    public MapShape(String name, ShapeType type, double radiusM, GeoPoint[] gp) {
        this.setName(name);
        this.setType(type);
        this.setRadiusMeters(radiusM);
        this.setPoints(gp);
    }

    public MapShape(String name, ShapeType type, double radiusM, List<GeoPoint> gp) {
        this.setName(name);
        this.setType(type);
        this.setRadiusMeters(radiusM);
        this.setPoints(gp);
    }

    public void setName(String name) {
        this.name = StringTools.trim((String)name);
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.desc = StringTools.trim((String)desc);
    }

    public String getDescription() {
        return !StringTools.isBlank((String)this.desc) ? this.desc : this.getName();
    }

    public void setType(ShapeType type) {
        this.shapeType = type != null ? type : DEFAULT_SHAPE_TYPE;
    }

    public ShapeType getType() {
        return this.shapeType;
    }

    public void setRadiusMeters(double radius) {
        this.radiusMeters = radius;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    public void setPoints(GeoPoint[] gp) {
        this.geoPoints = new Vector<GeoPoint>();
        ListTools.toList((Object[])gp, this.geoPoints);
    }

    public void setPoints(List<GeoPoint> gp) {
        this.geoPoints = new Vector<GeoPoint>();
        ListTools.toList(gp, this.geoPoints);
    }

    public List<GeoPoint> getPoints() {
        return this.geoPoints;
    }

    public String getPointsString() {
        return StringTools.join(this.getPoints(), (String)",");
    }

    public String getColorString() {
        return this.getColor().toString(true);
    }

    public ColorTools.RGB getColor() {
        return this.color != null ? this.color : DEFAULT_COLOR;
    }

    public void setColor(ColorTools.RGB color) {
        this.color = color != null ? color : DEFAULT_COLOR;
    }

    public void setColor(String color) {
        this.setColor(ColorTools.parseColor((String)color, (ColorTools.RGB)DEFAULT_COLOR));
    }

    public boolean isZoomTo() {
        return this.zoomTo;
    }

    public boolean getZoomTo() {
        return this.zoomTo;
    }

    public void setZoomTo(boolean zoom) {
        this.zoomTo = zoom;
    }

    public String toString() {
        return this.getName();
    }

    public String toLegacyZoomRegion() {
        StringBuffer sb = new StringBuffer();
        if (this.isZoomTo()) {
            switch (this.getType()) {
                case CIRCLE: {
                    sb.append("0,");
                    break;
                }
                case RECTANGLE: {
                    sb.append("1,");
                    break;
                }
                case CORRIDOR: {
                    sb.append("2,");
                    break;
                }
                case POLYGON: {
                    sb.append("3,");
                    break;
                }
                case LINE: {
                    sb.append("9,");
                    break;
                }
                case CENTER: {
                    sb.append("-1,");
                }
            }
            sb.append(Math.round(this.getRadiusMeters())).append(",");
            sb.append(this.getPointsString());
        }
        return sb.toString();
    }

    public static enum ShapeType implements EnumTools.IntValue
    {
        CIRCLE(0, "circle", I18N.getString(MapShape.class, (String)"MapShape.type.circle", (String)"Circle")),
        RECTANGLE(1, "rectangle", I18N.getString(MapShape.class, (String)"MapShape.type.rectangle", (String)"Rectangle")),
        CORRIDOR(2, "corridor", I18N.getString(MapShape.class, (String)"MapShape.type.corridor", (String)"Corridor")),
        POLYGON(3, "polygon", I18N.getString(MapShape.class, (String)"MapShape.type.polygon", (String)"Polygon")),
        LINE(10, "line", I18N.getString(MapShape.class, (String)"MapShape.type.line", (String)"Line")),
        CENTER(98, "center", I18N.getString(MapShape.class, (String)"MapShape.type.center", (String)"Center")),
        ZOOM(99, "zoom", I18N.getString(MapShape.class, (String)"MapShape.type.zoom", (String)"Zoom"));

        private int vv = 0;
        private String nn = null;
        private I18N.Text aa = null;

        private ShapeType(int v, String n2, I18N.Text a) {
            this.vv = v;
            this.nn = n2;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.nn;
        }

        public String getDescription(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean isDefault() {
            return this.equals((Object)CIRCLE);
        }
    }
}

