/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.util.HashMap;
import org.opengts.util.Print;
import org.opengts.war.tools.MapProvider;

public class MapProviderFactory {
    private static final String MAP_PROVIDER_PACKAGE = "org.opengts.war.maps";
    private static MapProviderFactory mapFactory = null;
    private HashMap<String, MapProvider> mapProviderMap = new HashMap();

    public static MapProviderFactory getInstance() {
        if (mapFactory == null) {
            mapFactory = new MapProviderFactory();
        }
        return mapFactory;
    }

    public static MapProvider getMapProviderForName(String providerClassName) {
        return MapProviderFactory.getInstance().getMapProvider(providerClassName);
    }

    private MapProviderFactory() {
    }

    private MapProvider getMapProvider(String providerClassName) {
        MapProvider mp = null;
        if (this.mapProviderMap.containsKey(providerClassName)) {
            mp = this.mapProviderMap.get(providerClassName);
        } else {
            String clzName = null;
            clzName = providerClassName.indexOf(".") >= 0 ? providerClassName : "org.opengts.war.maps." + providerClassName;
            try {
                Class<?> providerClass = Class.forName(clzName);
                mp = (MapProvider)providerClass.newInstance();
                this.mapProviderMap.put(providerClassName, mp);
            }
            catch (Throwable t) {
                Print.logError((String)("MapProvider creation error: " + clzName + " [" + t), (Object[])new Object[0]);
                mp = null;
            }
        }
        return mp;
    }
}

